<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-cart-plus me-2"></i> Nova Ordem de Serviço</h2>
        <p class="text-muted">Preencha os dados da ordem de serviço e adicione os itens</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/ordem-servico') ?>" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left me-2"></i> Voltar
        </a>
    </div>
</div>

<form id="form-ordem-servico" method="POST" action="<?= url('/ordem-servico/criar') ?>">
    <?php include ROOT_PATH . '/views/ordem-servico/form.php'; ?>

    <div class="row mt-4">
        <div class="col-12">
            <div class="d-grid gap-2 d-md-flex">
                <button type="submit" class="btn btn-success btn-lg">
                    <i class="bi bi-check-circle me-2"></i> Salvar Ordem de Serviço
                </button>
                <a href="<?= url('/ordem-servico') ?>" class="btn btn-outline-secondary btn-lg">
                    <i class="bi bi-x-circle me-2"></i> Cancelar
                </a>
            </div>
        </div>
    </div>
</form>

<script>
$(document).ready(function() {
    $('#form-ordem-servico').on('submit', function(e) {
        e.preventDefault();

        // Validar se há itens
        if (itensTabela.length === 0) {
            Swal.fire({
                icon: 'warning',
                title: 'Atenção',
                text: 'Adicione pelo menos um item à ordem de serviço!'
            });
            $('#itens-tab').tab('show');
            return false;
        }

        // Não precisa validar cliente - pode ser Consumidor Final (vazio)

        const formData = $(this).serialize();
        const $btn = $(this).find('button[type="submit"]');
        $btn.prop('disabled', true).html(
            '<span class="spinner-border spinner-border-sm me-2"></span>Salvando...');

        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Sucesso!',
                        text: response.message,
                        timer: 1500,
                        showConfirmButton: false
                    }).then(() => {
                        window.location.href = response.redirect || appUrl(
                            '/ordem-servico');
                    });
                } else {
                    $btn.prop('disabled', false).html(
                        '<i class="bi bi-check-circle me-2"></i> Salvar Ordem de Serviço');
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: response.message
                    });
                }
            },
            error: function(xhr) {
                $btn.prop('disabled', false).html(
                    '<i class="bi bi-check-circle me-2"></i> Salvar Ordem de Serviço');
                const response = xhr.responseJSON || {};
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: response.message || 'Erro ao salvar ordem de serviço'
                });
            }
        });
    });
});
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'ordem-servico';
include ROOT_PATH . '/views/layouts/app.php';
?>