<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-eye me-2"></i> Visualizar Ordem de Serviço PMOC</h2>
        <p class="text-muted">Detalhes da ordem de serviço PMOC</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/ordem-servico-pmoc') ?>" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left me-2"></i> Voltar
        </a>
        <a href="<?= url('/ordem-servico-pmoc/editar?id=' . $ordem['id']) ?>" class="btn btn-primary">
            <i class="bi bi-pencil me-2"></i> Editar
        </a>
        <a href="<?= url('/ordem-servico-pmoc/imprimir?id=' . $ordem['id']) ?>" target="_blank" class="btn btn-info">
            <i class="bi bi-printer me-2"></i> Imprimir
        </a>
    </div>
</div>

<div class="row">
    <!-- Dados da Ordem de Serviço -->
    <div class="col-md-8">
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-file-text me-2"></i> Dados da Ordem de Serviço</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <strong>Número:</strong><br>
                        <?= htmlspecialchars($ordem['sale_number']) ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Data:</strong><br>
                        <?= date('d/m/Y', strtotime($ordem['sale_date'])) ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Cliente:</strong><br>
                        <?= htmlspecialchars($ordem['customer_name'] ?? '-') ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Documento:</strong><br>
                        <?= htmlspecialchars($ordem['customer_document'] ?? '-') ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Vendedor:</strong><br>
                        <?= htmlspecialchars($ordem['vendor_name'] ?? '-') ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Status:</strong><br>
                        <?php
                        $statusBadges = [
                            'orcamento' => '<span class="badge bg-secondary">Orçamento</span>',
                            'pendente' => '<span class="badge bg-warning text-dark">Pendente</span>',
                            'realizado' => '<span class="badge bg-info">Realizado</span>',
                            'faturamento' => '<span class="badge bg-primary">Faturamento</span>',
                            'finalizado' => '<span class="badge bg-success">Finalizado</span>'
                        ];
                        echo $statusBadges[$ordem['status']] ?? '<span class="badge bg-secondary">' . htmlspecialchars($ordem['status']) . '</span>';
                        ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Dados do PMOC -->
        <?php if (!empty($ordem['pmoc_id'])): ?>
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-clipboard-data me-2"></i> Dados do PMOC</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <strong>Número PMOC:</strong><br>
                            <span class="badge bg-info"><?= htmlspecialchars($ordem['numero_pmoc'] ?? '-') ?></span>
                        </div>
                        <div class="col-md-6 mb-3">
                            <strong>Data de Emissão:</strong><br>
                            <?= !empty($ordem['pmoc_data_emissao']) ? date('d/m/Y', strtotime($ordem['pmoc_data_emissao'])) : '-' ?>
                        </div>
                        <div class="col-md-6 mb-3">
                            <strong>Data de Validade:</strong><br>
                            <?= !empty($ordem['pmoc_data_validade']) ? date('d/m/Y', strtotime($ordem['pmoc_data_validade'])) : '-' ?>
                        </div>
                        <div class="col-md-6 mb-3">
                            <strong>Responsável Técnico:</strong><br>
                            <?= htmlspecialchars($ordem['responsavel_tecnico'] ?? '-') ?>
                        </div>
                        <div class="col-md-6 mb-3">
                            <strong>CREA/CAU:</strong><br>
                            <?= htmlspecialchars($ordem['crea_cau'] ?? '-') ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Equipamentos -->
        <?php if (!empty($equipamentos)): ?>
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-gear me-2"></i> Equipamentos</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Tipo</th>
                                    <th>Marca/Modelo</th>
                                    <th>Capacidade</th>
                                    <th>Local</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($equipamentos as $equipamento): ?>
                                    <tr>
                                        <td><?= htmlspecialchars($equipamento['tipo_equipamento'] ?? '-') ?></td>
                                        <td><?= htmlspecialchars($equipamento['marca'] ?? '-') ?> / <?= htmlspecialchars($equipamento['modelo'] ?? '-') ?></td>
                                        <td><?= htmlspecialchars($equipamento['capacidade'] ?? '-') ?></td>
                                        <td><?= htmlspecialchars($equipamento['local_instalacao'] ?? '-') ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Itens -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-list-ul me-2"></i> Itens da Ordem de Serviço</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Produto/Serviço</th>
                                <th class="text-center">Quantidade</th>
                                <th class="text-end">Valor Unit.</th>
                                <th class="text-end">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($itens as $item): ?>
                                <tr>
                                    <td><?= htmlspecialchars($item['product_name'] ?? '-') ?></td>
                                    <td class="text-center"><?= number_format($item['quantity'] ?? 0, 2, ',', '.') ?></td>
                                    <td class="text-end"><?= formatCurrency($item['unit_price'] ?? 0) ?></td>
                                    <td class="text-end"><?= formatCurrency($item['total_price'] ?? 0) ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan="3" class="text-end">Subtotal:</th>
                                <th class="text-end"><?= formatCurrency($ordem['subtotal'] ?? 0) ?></th>
                            </tr>
                            <?php if (!empty($ordem['discount']) && $ordem['discount'] > 0): ?>
                                <tr>
                                    <th colspan="3" class="text-end">Desconto:</th>
                                    <th class="text-end text-danger">- <?= formatCurrency($ordem['discount']) ?></th>
                                </tr>
                            <?php endif; ?>
                            <tr>
                                <th colspan="3" class="text-end">Total:</th>
                                <th class="text-end"><?= formatCurrency($ordem['total'] ?? 0) ?></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Resumo -->
    <div class="col-md-4">
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-calculator me-2"></i> Resumo</h5>
            </div>
            <div class="card-body">
                <div class="d-flex justify-content-between mb-2">
                    <strong>Subtotal:</strong>
                    <span><?= formatCurrency($ordem['subtotal'] ?? 0) ?></span>
                </div>
                <?php if (!empty($ordem['discount']) && $ordem['discount'] > 0): ?>
                    <div class="d-flex justify-content-between mb-2">
                        <strong>Desconto:</strong>
                        <span class="text-danger">- <?= formatCurrency($ordem['discount']) ?></span>
                    </div>
                <?php endif; ?>
                <hr>
                <div class="d-flex justify-content-between">
                    <strong>Total:</strong>
                    <strong class="text-primary"><?= formatCurrency($ordem['total'] ?? 0) ?></strong>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
$content = ob_get_clean();
$activeMenu = 'ordem-servico-pmoc';
include ROOT_PATH . '/views/layouts/app.php';
?>