<?php
ob_start();
?>

<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ordem de Serviço PMOC - <?= htmlspecialchars($ordem['sale_number']) ?></title>
    <style>
        @media print {
            .no-print {
                display: none;
            }
        }

        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
        }

        .header {
            border-bottom: 2px solid #000;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }

        .header h1 {
            margin: 0;
            font-size: 18px;
        }

        .info-box {
            border: 1px solid #ddd;
            padding: 10px;
            margin-bottom: 15px;
        }

        .info-box h3 {
            margin-top: 0;
            font-size: 14px;
            border-bottom: 1px solid #ddd;
            padding-bottom: 5px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
        }

        table th,
        table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }

        table th {
            background-color: #f5f5f5;
            font-weight: bold;
        }

        .text-right {
            text-align: right;
        }

        .text-center {
            text-align: center;
        }

        .total-box {
            border-top: 2px solid #000;
            padding-top: 10px;
            margin-top: 20px;
        }
    </style>
</head>

<body>
    <div class="no-print" style="margin-bottom: 20px; text-align: right;">
        <button onclick="window.print()" class="btn btn-primary">Imprimir</button>
        <button onclick="window.close()" class="btn btn-secondary">Fechar</button>
    </div>

    <div class="header">
        <h1>ORDEM DE SERVIÇO PMOC</h1>
        <p><strong>Número:</strong> <?= htmlspecialchars($ordem['sale_number']) ?></p>
        <p><strong>Data:</strong> <?= date('d/m/Y', strtotime($ordem['sale_date'])) ?></p>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="info-box">
                <h3>Dados do Cliente</h3>
                <p><strong>Nome:</strong> <?= htmlspecialchars($ordem['customer_name'] ?? '-') ?></p>
                <p><strong>Documento:</strong> <?= htmlspecialchars($ordem['customer_document'] ?? '-') ?></p>
            </div>
        </div>
        <div class="col-md-6">
            <div class="info-box">
                <h3>Dados da Ordem</h3>
                <p><strong>Vendedor:</strong> <?= htmlspecialchars($ordem['vendor_name'] ?? '-') ?></p>
                <p><strong>Status:</strong> <?= htmlspecialchars($ordem['status'] ?? '-') ?></p>
            </div>
        </div>
    </div>

    <?php if (!empty($ordem['pmoc_id'])): ?>
        <div class="info-box">
            <h3>Dados do PMOC</h3>
            <div class="row">
                <div class="col-md-6">
                    <p><strong>Número PMOC:</strong> <?= htmlspecialchars($ordem['numero_pmoc'] ?? '-') ?></p>
                    <p><strong>Data de Emissão:</strong> <?= !empty($ordem['pmoc_data_emissao']) ? date('d/m/Y', strtotime($ordem['pmoc_data_emissao'])) : '-' ?></p>
                </div>
                <div class="col-md-6">
                    <p><strong>Data de Validade:</strong> <?= !empty($ordem['pmoc_data_validade']) ? date('d/m/Y', strtotime($ordem['pmoc_data_validade'])) : '-' ?></p>
                    <p><strong>Responsável Técnico:</strong> <?= htmlspecialchars($ordem['responsavel_tecnico'] ?? '-') ?></p>
                    <?php if (!empty($ordem['crea_cau'])): ?>
                        <p><strong>CREA/CAU:</strong> <?= htmlspecialchars($ordem['crea_cau']) ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if (!empty($equipamentos)): ?>
        <div class="info-box">
            <h3>Equipamentos</h3>
            <table>
                <thead>
                    <tr>
                        <th>Tipo</th>
                        <th>Marca</th>
                        <th>Modelo</th>
                        <th>Capacidade</th>
                        <th>Local de Instalação</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($equipamentos as $equipamento): ?>
                        <tr>
                            <td><?= htmlspecialchars($equipamento['tipo_equipamento'] ?? '-') ?></td>
                            <td><?= htmlspecialchars($equipamento['marca'] ?? '-') ?></td>
                            <td><?= htmlspecialchars($equipamento['modelo'] ?? '-') ?></td>
                            <td><?= htmlspecialchars($equipamento['capacidade'] ?? '-') ?></td>
                            <td><?= htmlspecialchars($equipamento['local_instalacao'] ?? '-') ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>

    <div class="info-box">
        <h3>Itens da Ordem de Serviço</h3>
        <table>
            <thead>
                <tr>
                    <th>Produto/Serviço</th>
                    <th class="text-center">Quantidade</th>
                    <th class="text-right">Valor Unit.</th>
                    <th class="text-right">Total</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($itens as $item): ?>
                    <tr>
                        <td><?= htmlspecialchars($item['product_name'] ?? '-') ?></td>
                        <td class="text-center"><?= number_format($item['quantity'] ?? 0, 2, ',', '.') ?></td>
                        <td class="text-right"><?= formatCurrency($item['unit_price'] ?? 0) ?></td>
                        <td class="text-right"><?= formatCurrency($item['total_price'] ?? 0) ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
            <tfoot>
                <tr>
                    <th colspan="3" class="text-right">Subtotal:</th>
                    <th class="text-right"><?= formatCurrency($ordem['subtotal'] ?? 0) ?></th>
                </tr>
                <?php if (!empty($ordem['discount']) && $ordem['discount'] > 0): ?>
                    <tr>
                        <th colspan="3" class="text-right">Desconto:</th>
                        <th class="text-right">- <?= formatCurrency($ordem['discount']) ?></th>
                    </tr>
                <?php endif; ?>
                <tr>
                    <th colspan="3" class="text-right">Total:</th>
                    <th class="text-right"><?= formatCurrency($ordem['total'] ?? 0) ?></th>
                </tr>
            </tfoot>
        </table>
    </div>

    <div class="total-box">
        <div style="text-align: right;">
            <p><strong>TOTAL: <?= formatCurrency($ordem['total'] ?? 0) ?></strong></p>
        </div>
    </div>

    <div style="margin-top: 50px; border-top: 1px solid #ddd; padding-top: 20px;">
        <div style="display: flex; justify-content: space-between;">
            <div style="text-align: center; width: 45%;">
                <p>_________________________________</p>
                <p><strong>Cliente</strong></p>
            </div>
            <div style="text-align: center; width: 45%;">
                <p>_________________________________</p>
                <p><strong>Responsável Técnico</strong></p>
            </div>
        </div>
    </div>
</body>

</html>

<?php
$content = ob_get_clean();
echo $content;
?>