<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-clipboard-check me-2"></i> Ordens de Serviço PMOC</h2>
        <p class="text-muted">Gerencie ordens de serviço relacionadas a PMOC</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/modelos-pmoc') ?>" class="btn btn-outline-secondary me-2">
            <i class="bi bi-file-earmark-text me-2"></i> Modelos PMOC
        </a>
        <a href="<?= url('/ordem-servico-pmoc/criar') ?>" class="btn btn-primary">
            <i class="bi bi-plus-circle me-2"></i> Nova Ordem de Serviço PMOC
        </a>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-6">
                <input type="text" class="form-control" name="search" placeholder="Buscar por número, cliente, PMOC..."
                    value="<?= htmlspecialchars($search ?? '') ?>">
            </div>
            <div class="col-md-3">
                <select class="form-select" name="status">
                    <option value="">Todos os Status</option>
                    <?php
                    foreach ($statusOrdens ?? [] as $s) {
                        $selected = (!empty($status) && $status === $s['codigo']) ? 'selected' : '';
                        echo "<option value=\"{$s['codigo']}\" {$selected}>{$s['nome']}</option>\n";
                    }
                    ?>
                </select>
            </div>
            <div class="col-md-3">
                <button type="submit" class="btn btn-secondary w-100">
                    <i class="bi bi-search"></i> Buscar
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Listagem -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span><i class="bi bi-list-ul me-2"></i> Lista de Ordens de Serviço PMOC</span>
        <span class="badge bg-primary"><?= count($ordens ?? []) ?> registro(s)</span>
    </div>
    <div class="card-body p-0">
        <?php if (!empty($ordens)): ?>
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th width="60">ID</th>
                            <th>Número OS</th>
                            <th>Número PMOC</th>
                            <th>Cliente</th>
                            <th>Data</th>
                            <th>Total</th>
                            <th>Status</th>
                            <th width="100">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($ordens as $ordem): ?>
                            <tr>
                                <td><?= $ordem['id'] ?></td>
                                <td><strong><?= htmlspecialchars($ordem['sale_number']) ?></strong></td>
                                <td>
                                    <?php if (!empty($ordem['numero_pmoc'])): ?>
                                        <span class="badge bg-info"><?= htmlspecialchars($ordem['numero_pmoc']) ?></span>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td><?= htmlspecialchars($ordem['customer_name'] ?? '-') ?></td>
                                <td><?= date('d/m/Y', strtotime($ordem['sale_date'])) ?></td>
                                <td><?= formatCurrency($ordem['total'] ?? 0) ?></td>
                                <td>
                                    <?php
                                    $statusBadges = [
                                        'orcamento' => '<span class="badge bg-secondary">Orçamento</span>',
                                        'pendente' => '<span class="badge bg-warning text-dark">Pendente</span>',
                                        'realizado' => '<span class="badge bg-info">Realizado</span>',
                                        'faturamento' => '<span class="badge bg-primary">Faturamento</span>',
                                        'finalizado' => '<span class="badge bg-success">Finalizado</span>'
                                    ];
                                    echo $statusBadges[$ordem['status']] ?? '<span class="badge bg-secondary">' . htmlspecialchars($ordem['status']) . '</span>';
                                    ?>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <a href="<?= url('/ordem-servico-pmoc/visualizar?id=' . $ordem['id']) ?>"
                                            class="btn btn-sm btn-outline-primary" title="Visualizar">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                        <a href="<?= url('/ordem-servico-pmoc/editar?id=' . $ordem['id']) ?>"
                                            class="btn btn-sm btn-outline-secondary" title="Editar">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        <a href="<?= url('/ordem-servico-pmoc/imprimir?id=' . $ordem['id']) ?>"
                                            target="_blank" class="btn btn-sm btn-outline-info" title="Imprimir">
                                            <i class="bi bi-printer"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-clipboard-check" style="font-size: 4rem; color: var(--text-secondary);"></i>
                <p class="text-muted mt-3">Nenhuma ordem de serviço PMOC encontrada</p>
                <a href="<?= url('/ordem-servico-pmoc/criar') ?>" class="btn btn-primary mt-2">
                    <i class="bi bi-plus-circle me-2"></i> Cadastrar Primeira Ordem de Serviço PMOC
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php
$content = ob_get_clean();
$activeMenu = 'ordem-servico-pmoc';
include ROOT_PATH . '/views/layouts/app.php';
?>