<?php
$isEdit = !empty($ordem ?? null);
$ordem = $ordem ?? [];
$itens = $itens ?? [];
$servicosPmoc = $servicosPmoc ?? [];
?>

<form id="formOrdemServicoPmoc" method="POST" action="<?= url($isEdit ? '/ordem-servico-pmoc/editar' : '/ordem-servico-pmoc/criar') ?>">
    <?php if ($isEdit): ?>
        <input type="hidden" name="id" value="<?= $ordem['id'] ?>">
    <?php endif; ?>

    <!-- Abas -->
    <ul class="nav nav-tabs mb-4" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="dados-tab" data-bs-toggle="tab" data-bs-target="#dados" type="button" role="tab">
                <i class="bi bi-file-earmark-text me-2"></i> Dados da OS
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="pmoc-tab" data-bs-toggle="tab" data-bs-target="#pmoc" type="button" role="tab">
                <i class="bi bi-clipboard-data me-2"></i> PMOC
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="itens-tab" data-bs-toggle="tab" data-bs-target="#itens" type="button" role="tab">
                <i class="bi bi-cart-plus me-2"></i> Itens
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="pagamento-tab" data-bs-toggle="tab" data-bs-target="#pagamento" type="button" role="tab">
                <i class="bi bi-credit-card me-2"></i> Pagamento e Valores
            </button>
        </li>
    </ul>

    <!-- Conteúdo das Abas -->
    <div class="tab-content">
        <!-- Aba: Dados da OS -->
        <div class="tab-pane fade show active" id="dados" role="tabpanel">
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <i class="bi bi-file-earmark-text me-2"></i> Informações Principais
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Número da OS *</label>
                                    <input type="text" class="form-control" name="sale_number"
                                        value="<?= htmlspecialchars($ordem['sale_number'] ?? $proximoNumero ?? '') ?>" required>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Data *</label>
                                    <input type="date" class="form-control" name="sale_date"
                                        value="<?= $ordem['sale_date'] ?? date('Y-m-d') ?>" required>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Status</label>
                                    <select class="form-select" name="status">
                                        <?php foreach ($statusVendas ?? [] as $status): ?>
                                            <option value="<?= $status['codigo'] ?>"
                                                <?= (!empty($ordem['status']) && $ordem['status'] == $status['codigo']) ||
                                                    (empty($ordem['status']) && $status['codigo'] == ($statusPadrao ?? 'orcamento')) ? 'selected' : '' ?>>
                                                <?= htmlspecialchars($status['nome']) ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>

                            <hr class="my-4">

                            <!-- Cliente com Autocomplete -->
                            <h6 class="text-primary mb-3">
                                <i class="bi bi-person me-2"></i> Cliente
                            </h6>
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <label for="customer_search" class="form-label">
                                        Cliente *
                                        <small class="text-muted">(Digite para buscar ou deixe vazio para Consumidor Final)</small>
                                    </label>
                                    <div class="position-relative">
                                        <input type="text" class="form-control" id="customer_search"
                                            placeholder="Digite nome, razão social ou CNPJ/CPF do cliente..." autocomplete="off"
                                            value="<?= htmlspecialchars($ordem['customer_name'] ?? '') ?>">
                                        <div id="customer_dropdown" class="autocomplete-dropdown" style="display: none;">
                                        </div>
                                    </div>
                                    <input type="hidden" id="customer_id" name="customer_id"
                                        value="<?= $ordem['customer_id'] ?? '' ?>">
                                    <input type="hidden" id="customer_type" name="customer_type"
                                        value="<?= $ordem['customer_type'] ?? 'pessoa' ?>">
                                    <input type="hidden" id="customer_name" name="customer_name"
                                        value="<?= htmlspecialchars($ordem['customer_name'] ?? '') ?>">
                                    <input type="hidden" id="customer_document" name="customer_document"
                                        value="<?= htmlspecialchars($ordem['customer_document'] ?? '') ?>">
                                </div>
                                <div class="col-md-12" id="customer_info" style="display: none;">
                                    <div class="alert alert-info mb-3">
                                        <div class="d-flex justify-content-between align-items-start">
                                            <div class="flex-grow-1">
                                                <div id="customer_info_name"></div>
                                            </div>
                                            <button type="button" class="btn btn-sm btn-outline-danger ms-2"
                                                onclick="limparCliente()">
                                                <i class="bi bi-x"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <hr class="my-4">

                            <!-- Vendedor -->
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">
                                        <i class="bi bi-person-badge me-1"></i> Vendedor
                                    </label>
                                    <select class="form-select" name="vendor_id">
                                        <option value="">Selecione o vendedor</option>
                                        <?php foreach ($vendedores ?? [] as $vendedor): ?>
                                            <option value="<?= $vendedor['id'] ?>"
                                                <?= (!empty($ordem['vendor_id']) && $ordem['vendor_id'] == $vendedor['id']) ? 'selected' : '' ?>>
                                                <?= htmlspecialchars($vendedor['name']) ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>

                            <hr class="my-4">

                            <!-- Observações -->
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <label class="form-label">
                                        <i class="bi bi-chat-left-text me-1"></i> Observações
                                    </label>
                                    <textarea class="form-control" name="observations" rows="4"
                                        placeholder="Digite observações sobre esta ordem de serviço..."><?= htmlspecialchars($ordem['notes'] ?? $ordem['observations'] ?? '') ?></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Aba: PMOC -->
        <div class="tab-pane fade" id="pmoc" role="tabpanel">
            <div class="card">
                <div class="card-header">
                    <i class="bi bi-clipboard-data me-2"></i> Dados do PMOC
                </div>
                <div class="card-body">
                    <!-- Sub-abas Nav -->
                    <ul class="nav nav-pills nav-fill mb-4" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="pmoc-info-geral-tab" data-bs-toggle="tab" data-bs-target="#pmoc-info-geral" type="button" role="tab">
                                <i class="bi bi-info-circle me-2"></i> Informações Gerais
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="pmoc-equipamento-tab" data-bs-toggle="tab" data-bs-target="#pmoc-equipamento" type="button" role="tab">
                                <i class="bi bi-gear me-2"></i> Dados do Equipamento
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="pmoc-servicos-tab" data-bs-toggle="tab" data-bs-target="#pmoc-servicos" type="button" role="tab">
                                <i class="bi bi-tools me-2"></i> Serviços
                            </button>
                        </li>
                    </ul>

                    <!-- Conteúdo das Sub-abas -->
                    <div class="tab-content" id="pmocSubTabsContent">
                        <!-- Sub-aba: Informações Gerais -->
                        <div class="tab-pane fade show active" id="pmoc-info-geral" role="tabpanel">
                            <div class="card border-0 bg-light">
                                <div class="card-body">
                                    <h6 class="text-primary mb-3">
                                        <i class="bi bi-plus-circle me-2"></i> Informações Gerais
                                    </h6>
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Data de Emissão do PMOC *</label>
                                            <input type="date" class="form-control" name="pmoc_data_emissao"
                                                id="pmoc_data_emissao"
                                                value="<?= !empty($ordem['pmoc_data_emissao']) ? date('Y-m-d', strtotime($ordem['pmoc_data_emissao'])) : date('Y-m-d') ?>"
                                                required>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Data de Validade do PMOC *</label>
                                            <input type="date" class="form-control" name="pmoc_data_validade"
                                                id="pmoc_data_validade"
                                                value="<?= !empty($ordem['pmoc_data_validade']) ? date('Y-m-d', strtotime($ordem['pmoc_data_validade'])) : date('Y-m-d', strtotime('+1 year')) ?>"
                                                required>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Responsável Técnico</label>
                                            <input type="text" class="form-control" name="pmoc_responsavel_tecnico"
                                                id="pmoc_responsavel_tecnico"
                                                placeholder="Nome do responsável técnico"
                                                value="<?= htmlspecialchars($ordem['pmoc_responsavel_tecnico'] ?? '') ?>">
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">CREA/CAU</label>
                                            <input type="text" class="form-control" name="pmoc_crea_cau"
                                                id="pmoc_crea_cau"
                                                placeholder="Número do CREA/CAU"
                                                value="<?= htmlspecialchars($ordem['pmoc_crea_cau'] ?? '') ?>">
                                        </div>
                                        <div class="col-md-12 mb-3">
                                            <label class="form-label">Observações do PMOC</label>
                                            <textarea class="form-control" name="pmoc_observacoes" rows="4"
                                                id="pmoc_observacoes"
                                                placeholder="Observações sobre o PMOC..."><?= htmlspecialchars($ordem['pmoc_observacoes'] ?? '') ?></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Sub-aba: Dados do Equipamento -->
                        <div class="tab-pane fade" id="pmoc-equipamento" role="tabpanel">
                            <div class="card border-0 bg-light">
                                <div class="card-body">
                                    <h6 class="text-primary mb-3">
                                        <i class="bi bi-gear me-2"></i> Dados do Equipamento
                                    </h6>
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Tipo de Equipamento</label>
                                            <select class="form-select" name="pmoc_tipo_equipamento" id="pmoc_tipo_equipamento">
                                                <option value="">Selecione o tipo</option>
                                                <option value="Split Hi-Wall" <?= (!empty($ordem['pmoc_tipo_equipamento']) && $ordem['pmoc_tipo_equipamento'] == 'Split Hi-Wall') ? 'selected' : '' ?>>Split Hi-Wall</option>
                                                <option value="Split Cassete" <?= (!empty($ordem['pmoc_tipo_equipamento']) && $ordem['pmoc_tipo_equipamento'] == 'Split Cassete') ? 'selected' : '' ?>>Split Cassete</option>
                                                <option value="ACJ" <?= (!empty($ordem['pmoc_tipo_equipamento']) && $ordem['pmoc_tipo_equipamento'] == 'ACJ') ? 'selected' : '' ?>>ACJ</option>
                                                <option value="VRF" <?= (!empty($ordem['pmoc_tipo_equipamento']) && $ordem['pmoc_tipo_equipamento'] == 'VRF') ? 'selected' : '' ?>>VRF</option>
                                                <option value="Chiller" <?= (!empty($ordem['pmoc_tipo_equipamento']) && $ordem['pmoc_tipo_equipamento'] == 'Chiller') ? 'selected' : '' ?>>Chiller</option>
                                                <option value="Sistema Central" <?= (!empty($ordem['pmoc_tipo_equipamento']) && $ordem['pmoc_tipo_equipamento'] == 'Sistema Central') ? 'selected' : '' ?>>Sistema Central</option>
                                                <option value="Outro" <?= (!empty($ordem['pmoc_tipo_equipamento']) && $ordem['pmoc_tipo_equipamento'] == 'Outro') ? 'selected' : '' ?>>Outro</option>
                                            </select>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Marca</label>
                                            <input type="text" class="form-control" name="pmoc_equipamento_marca"
                                                id="pmoc_equipamento_marca"
                                                placeholder="Marca do equipamento"
                                                value="<?= htmlspecialchars($ordem['pmoc_equipamento_marca'] ?? '') ?>">
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Modelo</label>
                                            <input type="text" class="form-control" name="pmoc_equipamento_modelo"
                                                id="pmoc_equipamento_modelo"
                                                placeholder="Modelo do equipamento"
                                                value="<?= htmlspecialchars($ordem['pmoc_equipamento_modelo'] ?? '') ?>">
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Capacidade (BTU)</label>
                                            <input type="text" class="form-control" name="pmoc_equipamento_capacidade"
                                                id="pmoc_equipamento_capacidade"
                                                placeholder="Ex: 12000 BTU"
                                                value="<?= htmlspecialchars($ordem['pmoc_equipamento_capacidade'] ?? '') ?>">
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Local de Instalação</label>
                                            <input type="text" class="form-control" name="pmoc_equipamento_local"
                                                id="pmoc_equipamento_local"
                                                placeholder="Local onde o equipamento está instalado"
                                                value="<?= htmlspecialchars($ordem['pmoc_equipamento_local'] ?? '') ?>">
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Número de Série</label>
                                            <input type="text" class="form-control" name="pmoc_equipamento_serie"
                                                id="pmoc_equipamento_serie"
                                                placeholder="Número de série do equipamento"
                                                value="<?= htmlspecialchars($ordem['pmoc_equipamento_serie'] ?? '') ?>">
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Data de Instalação</label>
                                            <input type="date" class="form-control" name="pmoc_equipamento_data_instalacao"
                                                id="pmoc_equipamento_data_instalacao"
                                                value="<?= !empty($ordem['pmoc_equipamento_data_instalacao']) ? date('Y-m-d', strtotime($ordem['pmoc_equipamento_data_instalacao'])) : '' ?>">
                                        </div>
                                        <div class="col-md-12 mb-3">
                                            <label class="form-label">Observações do Equipamento</label>
                                            <textarea class="form-control" name="pmoc_equipamento_observacoes" rows="3"
                                                id="pmoc_equipamento_observacoes"
                                                placeholder="Observações sobre o equipamento..."><?= htmlspecialchars($ordem['pmoc_equipamento_observacoes'] ?? '') ?></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Sub-aba: Serviços -->
                        <div class="tab-pane fade" id="pmoc-servicos" role="tabpanel">
                            <div class="card border-0 bg-light">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <h6 class="text-primary mb-0">
                                            <i class="bi bi-tools me-2"></i> Serviços do PMOC
                                        </h6>
                                        <button type="button" class="btn btn-sm btn-primary" onclick="adicionarServicoPmoc()">
                                            <i class="bi bi-plus-circle me-1"></i> Adicionar Serviço
                                        </button>
                                    </div>
                                    <div id="pmoc-servicos-container">
                                        <p class="text-muted text-center py-4" id="pmoc-empty-services-message">
                                            Nenhum serviço adicionado. Clique em "Adicionar Serviço" para começar.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Aba: Itens -->
        <div class="tab-pane fade" id="itens" role="tabpanel">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="bi bi-cart-plus me-2"></i> Itens da Ordem de Serviço</h5>
                    <button type="button" class="btn btn-sm btn-primary" onclick="adicionarItem()">
                        <i class="bi bi-plus-circle me-1"></i> Adicionar Item
                    </button>
                </div>
                <div class="card-body">
                    <div id="itens-container">
                        <?php if (!empty($itens)): ?>
                            <?php foreach ($itens as $index => $item): ?>
                                <div class="item-row mb-3 p-3 border rounded">
                                    <div class="row">
                                        <div class="col-md-5">
                                            <label class="form-label">Produto/Serviço</label>
                                            <select class="form-select produto-select" name="itens[<?= $index ?>][product_id]"
                                                onchange="atualizarItem(this, <?= $index ?>)">
                                                <option value="">Selecione</option>
                                                <?php foreach ($produtos ?? [] as $produto): ?>
                                                    <option value="<?= $produto['id'] ?>"
                                                        data-price="<?= $produto['price'] ?>"
                                                        data-name="<?= htmlspecialchars($produto['name']) ?>"
                                                        <?= (!empty($item['product_id']) && $item['product_id'] == $produto['id']) ? 'selected' : '' ?>>
                                                        <?= htmlspecialchars($produto['name']) ?>
                                                    </option>
                                                <?php endforeach; ?>
                                            </select>
                                            <input type="hidden" name="itens[<?= $index ?>][product_name]"
                                                value="<?= htmlspecialchars($item['product_name'] ?? '') ?>">
                                        </div>
                                        <div class="col-md-2">
                                            <label class="form-label">Quantidade</label>
                                            <input type="number" class="form-control quantidade"
                                                name="itens[<?= $index ?>][quantity]"
                                                value="<?= $item['quantity'] ?? 1 ?>"
                                                step="0.01" min="0.01"
                                                onchange="calcularTotalItem(<?= $index ?>)">
                                        </div>
                                        <div class="col-md-2">
                                            <label class="form-label">Valor Unit.</label>
                                            <input type="number" class="form-control valor-unitario"
                                                name="itens[<?= $index ?>][unit_price]"
                                                value="<?= $item['unit_price'] ?? 0 ?>"
                                                step="0.01" min="0"
                                                onchange="calcularTotalItem(<?= $index ?>)">
                                        </div>
                                        <div class="col-md-2">
                                            <label class="form-label">Total</label>
                                            <input type="text" class="form-control total-item"
                                                name="itens[<?= $index ?>][total_price]"
                                                value="<?= $item['total_price'] ?? 0 ?>" readonly>
                                        </div>
                                        <div class="col-md-1">
                                            <label class="form-label">&nbsp;</label>
                                            <button type="button" class="btn btn-danger w-100" onclick="removerItem(this)">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Aba: Pagamento e Valores -->
        <div class="tab-pane fade" id="pagamento" role="tabpanel">
            <div class="row">
                <div class="col-lg-8">
                    <div class="card">
                        <div class="card-header">
                            <i class="bi bi-calculator me-2"></i> Cálculo de Valores
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <strong>Subtotal:</strong>
                                        <span id="subtotal" class="fs-5">R$ 0,00</span>
                                    </div>
                                </div>
                                <div class="col-md-12 mb-3">
                                    <label class="form-label">Desconto</label>
                                    <div class="input-group">
                                        <span class="input-group-text">R$</span>
                                        <input type="number" class="form-control" name="discount"
                                            id="discount" value="<?= $ordem['discount'] ?? 0 ?>"
                                            step="0.01" min="0" onchange="calcularTotal()">
                                    </div>
                                </div>
                                <div class="col-md-12 mb-3">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <strong class="fs-5">Total:</strong>
                                        <span id="total" class="fs-4 fw-bold text-primary">R$ 0,00</span>
                                    </div>
                                </div>
                                <input type="hidden" name="subtotal" id="subtotal_hidden" value="0">
                                <input type="hidden" name="total" id="total_hidden" value="0">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="card mb-3">
                        <div class="card-header">
                            <i class="bi bi-credit-card me-2"></i> Método de Pagamento
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="form-label">Método de Pagamento</label>
                                <select class="form-select" name="payment_method_id">
                                    <option value="">Selecione o método</option>
                                    <?php foreach ($metodosPagamento ?? [] as $metodo): ?>
                                        <option value="<?= $metodo['id'] ?>"
                                            <?= (!empty($ordem['payment_method_id']) && $ordem['payment_method_id'] == $metodo['id']) ? 'selected' : '' ?>>
                                            <?= htmlspecialchars($metodo['name']) ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header">
                            <i class="bi bi-info-circle me-2"></i> Informações
                        </div>
                        <div class="card-body">
                            <p class="text-muted small">
                                <i class="bi bi-lightbulb me-1"></i>
                                Os valores são calculados automaticamente com base nos itens adicionados.
                            </p>
                            <p class="text-muted small">
                                <i class="bi bi-calculator me-1"></i>
                                O desconto é aplicado sobre o subtotal.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Botões de Ação -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="d-flex justify-content-end gap-2">
                <a href="<?= url('/ordem-servico-pmoc') ?>" class="btn btn-secondary">
                    <i class="bi bi-x-circle me-2"></i> Cancelar
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-check-circle me-2"></i> <?= $isEdit ? 'Atualizar' : 'Salvar' ?>
                </button>
            </div>
        </div>
    </div>
</form>

<style>
    .autocomplete-dropdown {
        position: absolute;
        top: 100%;
        left: 0;
        right: 0;
        background: var(--bs-body-bg, #fff);
        border: 1px solid var(--bs-border-color, #dee2e6);
        border-top: none;
        border-radius: 0 0 0.375rem 0.375rem;
        max-height: 300px;
        overflow-y: auto;
        z-index: 1000;
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
    }

    .autocomplete-item {
        padding: 0.875rem 1rem;
        cursor: pointer;
        border-bottom: 1px solid var(--bs-border-color, #f0f0f0);
        transition: all 0.15s ease-in-out;
        line-height: 1.5;
    }

    .autocomplete-item:hover,
    .autocomplete-item.active {
        background-color: var(--bs-primary, #0d6efd);
        color: white;
        transform: translateX(3px);
    }

    .autocomplete-item:hover .text-muted {
        color: rgba(255, 255, 255, 0.8) !important;
    }

    .autocomplete-item:last-child {
        border-bottom: none;
    }

    .autocomplete-item .mb-1 {
        margin-bottom: 0.375rem;
    }

    .autocomplete-item strong {
        font-weight: 600;
    }

    .autocomplete-no-results {
        padding: 1rem;
        text-align: center;
        color: var(--bs-secondary, #6c757d);
        font-style: italic;
    }
</style>

<script>
    let itemIndex = <?= count($itens ?? []) ?>;

    // Lista de clientes do PHP
    const clientesData = <?= json_encode($clientes ?? []) ?>;
    let selectedCustomer = null;
    let autocompleteTimeout = null;

    // Inicializar autocomplete de cliente quando jQuery estiver disponível
    (function aguardarJQuery() {
        if (typeof jQuery === 'undefined') {
            setTimeout(aguardarJQuery, 100);
            return;
        }
        inicializarAutocompleteCliente();
    })();

    // ============================================
    // AUTOCOMPLETE DE CLIENTE
    // ============================================
    function inicializarAutocompleteCliente() {
        const $search = $('#customer_search');
        const $dropdown = $('#customer_dropdown');

        // Ao digitar
        $search.on('input', function() {
            const query = $(this).val().trim().toLowerCase();

            clearTimeout(autocompleteTimeout);

            if (query.length < 2) {
                $dropdown.hide();
                return;
            }

            autocompleteTimeout = setTimeout(() => {
                buscarClientes(query);
            }, 300);
        });

        // Ao clicar fora, fechar dropdown
        $(document).on('click', function(e) {
            if (!$(e.target).closest('#customer_search, #customer_dropdown').length) {
                $dropdown.hide();
            }
        });

        // Ao focar no campo
        $search.on('focus', function() {
            if ($(this).val().length >= 2) {
                buscarClientes($(this).val().trim().toLowerCase());
            }
        });

        // Ao pressionar Enter, apenas prevenir submit
        $search.on('keydown', function(e) {
            if (e.key === 'Enter') {
                e.preventDefault();
            }
        });

        // Carregar cliente existente se estiver editando
        <?php if ($isEdit && !empty($ordem['customer_id'])): ?>
            const clienteInicial = clientesData.find(c => c.id == <?= $ordem['customer_id'] ?>);
            if (clienteInicial) {
                selecionarCliente(clienteInicial);
            }
        <?php endif; ?>
    }

    function buscarClientes(query) {
        const $dropdown = $('#customer_dropdown');

        // Filtrar clientes
        const results = clientesData.filter(cliente => {
            const name = (cliente.name || '').toLowerCase();
            const tradeName = (cliente.trade_name || '').toLowerCase();
            const document = (cliente.document || '').toLowerCase();
            const email = (cliente.email || '').toLowerCase();
            const phone = (cliente.phone || '').toLowerCase();
            const mobile = (cliente.mobile || '').toLowerCase();

            // Normalizar query e documento para busca mais flexível
            const normalizedQuery = query.replace(/[^\d\w]/g, '').toLowerCase();
            const normalizedDocument = document.replace(/[^\d\w]/g, '').toLowerCase();

            return name.includes(query) || tradeName.includes(query) ||
                document.includes(query) || normalizedDocument.includes(normalizedQuery) ||
                email.includes(query) || phone.includes(query) || mobile.includes(query);
        });

        // Montar HTML
        let html = '';

        if (results.length > 0) {
            results.forEach(cliente => {
                const nomeFantasia = cliente.trade_name || '-';
                const razaoSocial = cliente.name || '-';
                const documento = cliente.document || 'Não informado';
                const codigo = String(cliente.id).padStart(4, '0');
                const telefone = cliente.phone || cliente.mobile || '-';
                const email = cliente.email || '-';

                html += `
                    <div class="autocomplete-item" data-id="${cliente.id}">
                        <div class="mb-1">
                            <strong>Código: ${codigo}</strong>  |  <strong>CNPJ/CPF:</strong> ${documento}
                        </div>
                        <div class="mb-1">
                            <strong>Razão Social:</strong> ${razaoSocial}  |  <strong>Fantasia:</strong> ${nomeFantasia}
                        </div>
                        <div class="text-muted small">
                            <strong>Fone:</strong> ${telefone}  |  <strong>Email:</strong> ${email}
                        </div>
                    </div>
                `;
            });
        } else {
            html = '<div class="autocomplete-no-results">Nenhum cliente encontrado</div>';
        }

        $dropdown.html(html).show();

        // Event listeners
        $dropdown.find('.autocomplete-item').on('click', function() {
            const clienteId = $(this).data('id');
            const cliente = clientesData.find(c => c.id == clienteId);
            if (cliente) {
                selecionarCliente(cliente);
            }
        });
    }

    function selecionarCliente(cliente) {
        selectedCustomer = cliente;

        const nomeFantasia = cliente.trade_name || '-';
        const razaoSocial = cliente.name || '-';
        const nomeExibir = nomeFantasia !== '-' ? nomeFantasia : razaoSocial;
        const codigo = String(cliente.id).padStart(4, '0');
        const documento = cliente.document || 'Não informado';
        const telefone = cliente.phone || cliente.mobile || '-';
        const email = cliente.email || '-';

        // Preencher campos hidden
        $('#customer_id').val(cliente.id);
        $('#customer_type').val('pessoa');
        $('#customer_name').val(razaoSocial);
        $('#customer_document').val(cliente.document || '');

        // Atualizar campo de busca
        $('#customer_search').val(nomeExibir);

        // Mostrar info do cliente no formato estruturado
        let infoHtml = `
            <div style="line-height: 1.6;">
                <div class="mb-1">
                    <strong>Código: ${codigo}</strong>  |  ${documento}
                </div>
                <div class="mb-1">
                    <strong>Razão Social:</strong> ${razaoSocial}  |  <strong>Fantasia:</strong> ${nomeFantasia}
                </div>
                <div class="text-muted small">
                    <strong>Fone:</strong> ${telefone}  |  <strong>Email:</strong> ${email}
                </div>
            </div>
        `;

        $('#customer_info_name').html(infoHtml);
        $('#customer_info').slideDown();

        // Fechar dropdown
        $('#customer_dropdown').hide();
    }

    function limparCliente() {
        selectedCustomer = null;

        $('#customer_id').val('');
        $('#customer_type').val('pessoa');
        $('#customer_name').val('');
        $('#customer_document').val('');
        $('#customer_search').val('');

        $('#customer_info').slideUp();
    }

    function adicionarItem() {
        const container = document.getElementById('itens-container');
        const row = document.createElement('div');
        row.className = 'item-row mb-3 p-3 border rounded';
        row.innerHTML = `
        <div class="row">
            <div class="col-md-5">
                <label class="form-label">Produto/Serviço</label>
                <select class="form-select produto-select" name="itens[${itemIndex}][product_id]"
                        onchange="atualizarItem(this, ${itemIndex})">
                    <option value="">Selecione</option>
                    <?php foreach ($produtos ?? [] as $produto): ?>
                        <option value="<?= $produto['id'] ?>"
                                data-price="<?= $produto['price'] ?>"
                                data-name="<?= htmlspecialchars($produto['name']) ?>">
                            <?= htmlspecialchars($produto['name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                <input type="hidden" name="itens[${itemIndex}][product_name]" value="">
            </div>
            <div class="col-md-2">
                <label class="form-label">Quantidade</label>
                <input type="number" class="form-control quantidade"
                       name="itens[${itemIndex}][quantity]" value="1"
                       step="0.01" min="0.01" onchange="calcularTotalItem(${itemIndex})">
            </div>
            <div class="col-md-2">
                <label class="form-label">Valor Unit.</label>
                <input type="number" class="form-control valor-unitario"
                       name="itens[${itemIndex}][unit_price]" value="0"
                       step="0.01" min="0" onchange="calcularTotalItem(${itemIndex})">
            </div>
            <div class="col-md-2">
                <label class="form-label">Total</label>
                <input type="text" class="form-control total-item"
                       name="itens[${itemIndex}][total_price]" value="0" readonly>
            </div>
            <div class="col-md-1">
                <label class="form-label">&nbsp;</label>
                <button type="button" class="btn btn-danger w-100" onclick="removerItem(this)">
                    <i class="bi bi-trash"></i>
                </button>
            </div>
        </div>
    `;
        container.appendChild(row);
        itemIndex++;
    }

    function removerItem(btn) {
        btn.closest('.item-row').remove();
        calcularTotal();
    }

    function atualizarItem(select, index) {
        const option = select.options[select.selectedIndex];
        const price = parseFloat(option.dataset.price || 0);
        const name = option.dataset.name || '';

        const row = select.closest('.item-row');
        row.querySelector('input[name*="[product_name]"]').value = name;
        row.querySelector('.valor-unitario').value = price.toFixed(2);

        calcularTotalItem(index);
    }

    function calcularTotalItem(index) {
        const rows = document.querySelectorAll('.item-row');
        if (!rows[index]) return;

        const row = rows[index];
        const quantidade = parseFloat(row.querySelector('.quantidade').value || 0);
        const valorUnitario = parseFloat(row.querySelector('.valor-unitario').value || 0);
        const total = quantidade * valorUnitario;

        row.querySelector('.total-item').value = total.toFixed(2);
        row.querySelector('input[name*="[total_price]"]').value = total.toFixed(2);

        calcularTotal();
    }

    function calcularTotal() {
        let subtotal = 0;
        document.querySelectorAll('.total-item').forEach(input => {
            subtotal += parseFloat(input.value || 0);
        });

        const desconto = parseFloat(document.getElementById('discount').value || 0);
        const total = subtotal - desconto;

        document.getElementById('subtotal').textContent = 'R$ ' + subtotal.toFixed(2).replace('.', ',');
        document.getElementById('total').textContent = 'R$ ' + total.toFixed(2).replace('.', ',');
        document.getElementById('subtotal_hidden').value = subtotal.toFixed(2);
        document.getElementById('total_hidden').value = total.toFixed(2);
    }

    // Calcular total ao carregar
    document.addEventListener('DOMContentLoaded', function() {
        calcularTotal();
    });

    // ============================================
    // GERENCIAMENTO DE SERVIÇOS DO PMOC
    // ============================================
    let servicoPmocIndex = 0;
    const servicosPmocData = <?= json_encode($servicosPmoc ?? []) ?>;

    function adicionarServicoPmoc() {
        const container = document.getElementById('pmoc-servicos-container');
        const servicoDiv = document.createElement('div');
        servicoDiv.className = 'servico-pmoc-item mb-3 p-3 border rounded bg-white';
        servicoDiv.setAttribute('data-index', servicoPmocIndex);

        servicoDiv.innerHTML = `
            <div class="row">
                <div class="col-md-5">
                    <label class="form-label">Nome do Serviço *</label>
                    <select class="form-select servico-pmoc-select" name="pmoc_servicos[${servicoPmocIndex}][nome]" required onchange="atualizarDescricaoServicoPmoc(this, ${servicoPmocIndex})">
                        <option value="">Selecione um serviço</option>
                    </select>
                    <input type="hidden" name="pmoc_servicos[${servicoPmocIndex}][product_id]" class="servico-pmoc-product-id" value="">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Frequência</label>
                    <select class="form-select servico-pmoc-frequencia" name="pmoc_servicos[${servicoPmocIndex}][frequencia]">
                        <option value="">Selecione</option>
                        <option value="Mensal">Mensal</option>
                        <option value="Trimestral">Trimestral</option>
                        <option value="Semestral">Semestral</option>
                        <option value="Anual">Anual</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Descrição</label>
                    <textarea class="form-control servico-pmoc-descricao" name="pmoc_servicos[${servicoPmocIndex}][descricao]" rows="2"
                        placeholder="Descrição detalhada do serviço"></textarea>
                </div>
                <div class="col-md-12 mt-2">
                    <button type="button" class="btn btn-sm btn-danger" onclick="removerServicoPmoc(this)">
                        <i class="bi bi-trash me-1"></i> Remover
                    </button>
                </div>
            </div>
            <input type="hidden" name="pmoc_servicos[${servicoPmocIndex}][ordem]" value="${servicoPmocIndex}" class="servico-pmoc-ordem">
        `;

        container.appendChild(servicoDiv);

        // Popular o select com serviços disponíveis
        const select = servicoDiv.querySelector('.servico-pmoc-select');
        if (select && servicosPmocData) {
            servicosPmocData.forEach(servico => {
                const option = document.createElement('option');
                option.value = servico.name || '';
                option.textContent = servico.name || '';
                option.setAttribute('data-descricao', servico.description || '');
                option.setAttribute('data-product-id', servico.id || '');
                select.appendChild(option);
            });
        }

        // Remover mensagem de "nenhum serviço"
        const emptyMessage = container.querySelector('#pmoc-empty-services-message');
        if (emptyMessage) {
            emptyMessage.remove();
        }

        servicoPmocIndex++;
        atualizarOrdemServicosPmoc();
    }

    function removerServicoPmoc(btn) {
        const servicoItem = btn.closest('.servico-pmoc-item');
        servicoItem.remove();
        atualizarOrdemServicosPmoc();

        // Se não houver mais serviços, mostrar mensagem
        const container = document.getElementById('pmoc-servicos-container');
        if (container.querySelectorAll('.servico-pmoc-item').length === 0) {
            container.innerHTML = '<p class="text-muted text-center py-4" id="pmoc-empty-services-message">Nenhum serviço adicionado. Clique em "Adicionar Serviço" para começar.</p>';
        }
    }

    function atualizarOrdemServicosPmoc() {
        const servicos = document.querySelectorAll('.servico-pmoc-item');
        servicos.forEach((item, index) => {
            item.setAttribute('data-index', index);
            const ordemInput = item.querySelector('.servico-pmoc-ordem');
            if (ordemInput) {
                ordemInput.value = index;
                // Atualizar o name do input para manter a ordem correta
                const inputs = item.querySelectorAll('input, select, textarea');
                inputs.forEach(input => {
                    const name = input.getAttribute('name');
                    if (name && name.includes('pmoc_servicos[')) {
                        const newName = name.replace(/pmoc_servicos\[\d+\]/, `pmoc_servicos[${index}]`);
                        input.setAttribute('name', newName);
                    }
                });
                // Atualizar o onchange do select
                const select = item.querySelector('.servico-pmoc-select');
                if (select) {
                    select.setAttribute('onchange', `atualizarDescricaoServicoPmoc(this, ${index})`);
                }
            }
        });
    }

    function atualizarDescricaoServicoPmoc(select, index) {
        const servicoItem = select.closest('.servico-pmoc-item');
        const option = select.options[select.selectedIndex];
        const descricaoServico = option.getAttribute('data-descricao') || '';
        const productId = option.getAttribute('data-product-id') || '';

        // Atualizar campo de product_id hidden
        const productIdInput = servicoItem.querySelector('.servico-pmoc-product-id');
        if (productIdInput) {
            productIdInput.value = productId;
        }

        // Preencher descrição automaticamente se estiver vazia
        const descricaoTextarea = servicoItem.querySelector('.servico-pmoc-descricao');
        if (descricaoTextarea) {
            if (!descricaoTextarea.value || descricaoTextarea.dataset.originalValue === descricaoTextarea.value) {
                descricaoTextarea.value = descricaoServico;
                descricaoTextarea.dataset.originalValue = descricaoServico;
            }
        }
    }

    // Submit do formulário
    document.getElementById('formOrdemServicoPmoc').addEventListener('submit', function(e) {
        e.preventDefault();

        const formData = new FormData(this);

        fetch(this.action, {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    Toast.success(data.message);
                    setTimeout(() => {
                        window.location.href = '<?= url('/ordem-servico-pmoc') ?>';
                    }, 1500);
                } else {
                    Toast.error(data.message || 'Erro ao salvar');
                }
            })
            .catch(error => {
                console.error('Erro:', error);
                Toast.error('Erro ao salvar ordem de serviço');
            });
    });
</script>