<?php
$module = $module ?? [];
$routeBase = $module['routeBase'] ?? '/orcamentos-agua';
$slug = $module['slug'] ?? 'orcamentos-agua';
$plural = $module['plural'] ?? 'DAV';
$singular = $module['singular'] ?? 'DAV';
$icon = $module['icon'] ?? 'bi bi-droplet';
$newIcon = $module['createIcon'] ?? 'bi bi-plus-circle';
$subtitle = $module['subtitle'] ?? 'Controle e acompanhe os DAVs';
$newButtonLabel = $module['newButtonLabel'] ?? ('Novo ' . $singular);
$conversionEnabled = $module['conversionEnabled'] ?? false;
$moduleOrigin = $module['origin'] ?? 'orcamento_agua';
$statusModule = $module['statusModule'] ?? 'orcamentos_agua';

// Capturar scripts adicionais antes de incluir a view de vendas
ob_start();

// Definir URLs para JavaScript
if (!function_exists('url')) {
    function url($path = '/') {
        return \App\Helpers\UrlHelper::url($path);
    }
}
$urlItens = url('/orcamentos-agua/itens');
$urlItensAtualizar = url('/orcamentos-agua/itens/atualizar');
$urlEditar = url('/orcamentos-agua/editar');
$urlStatus = url('/orcamentos-agua/status');
?>
<script>
(function($) {
    'use strict';

    // URLs para AJAX (json_encode já retorna string JSON válida com aspas)
    const URL_ITENS = <?= json_encode($urlItens, JSON_HEX_TAG | JSON_HEX_AMP | JSON_HEX_APOS | JSON_HEX_QUOT) ?>;
    const URL_ITENS_ATUALIZAR =
        <?= json_encode($urlItensAtualizar, JSON_HEX_TAG | JSON_HEX_AMP | JSON_HEX_APOS | JSON_HEX_QUOT) ?>;
    const URL_EDITAR = <?= json_encode($urlEditar, JSON_HEX_TAG | JSON_HEX_AMP | JSON_HEX_APOS | JSON_HEX_QUOT) ?>;
    const URL_STATUS = <?= json_encode($urlStatus, JSON_HEX_TAG | JSON_HEX_AMP | JSON_HEX_APOS | JSON_HEX_QUOT) ?>;

    // Aguardar a tabela ser renderizada
    $(document).ready(function() {
        // Verificar se há orçamentos com status triagem e adicionar colunas
        setTimeout(function() {
            adicionarColunasTriagem();
        }, 500);

        // Event delegation para botões de status (funciona mesmo com elementos adicionados dinamicamente)
        $(document).on('click', '[id^="btn-status-"]', function(e) {
            e.preventDefault();
            e.stopPropagation();

            const $btn = $(this);
            const vendaId = $btn.data('venda-id');
            const statusCodigo = $btn.data('status-codigo');
            const statusNome = $btn.data('status-nome');

            console.log('Botão de status clicado:', { vendaId, statusCodigo, statusNome });

            if (!vendaId || !statusCodigo) {
                console.error('Dados do botão inválidos:', { vendaId, statusCodigo });
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: 'Dados inválidos para mudança de status'
                });
                return;
            }

            if (typeof window.mudarStatusOrcamento === 'function') {
                window.mudarStatusOrcamento(vendaId, statusCodigo, statusNome);
            } else {
                console.error('Função mudarStatusOrcamento não está definida');
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: 'Função de mudança de status não está disponível'
                });
            }
        });
    });

    function adicionarColunasTriagem() {
        const tabela = $('#vendas-table');
        if (!tabela.length) return;

        // Verificar se já tem as colunas
        if (tabela.find('thead th:contains("Quebra")').length) return;

        // Verificar se há alguma linha com status triagem
        let temTriagem = false;
        tabela.find('tbody tr').each(function() {
            const statusBadge = $(this).find('td').eq(5).find('.badge').text().toLowerCase().trim();
            if (statusBadge.includes('triagem')) {
                temTriagem = true;
                return false; // break
            }
        });

        if (!temTriagem) return;

        // Adicionar colunas no cabeçalho
        const thead = tabela.find('thead tr');
        if (thead.length) {
            // Inserir antes da última coluna (Pagamento)
            thead.find('th').eq(6).before(
                '<th class="text-center" width="100">Quebra</th>' +
                '<th class="text-center" width="100">Troca</th>'
            );
        }

        // Adicionar células nas linhas
        tabela.find('tbody tr').each(function() {
            const $row = $(this);
            const statusBadge = $row.find('td').eq(5).find('.badge').text().toLowerCase().trim();
            const vendaId = $row.data('venda-id') || $row.find('td:first').text();

            if (statusBadge.includes('triagem')) {
                // Buscar valores de quebra e troca
                buscarQuebraTroca(vendaId, function(quebra, troca) {
                    // Inserir antes da última coluna
                    $row.find('td').eq(6).before(
                        '<td class="text-center">' +
                        '<input type="number" class="form-control form-control-sm text-center campo-quebra" ' +
                        'data-venda-id="' + vendaId + '" ' +
                        'value="' + (quebra || 0) + '" ' +
                        'min="0" step="0.001" style="width: 80px;">' +
                        '</td>' +
                        '<td class="text-center">' +
                        '<input type="number" class="form-control form-control-sm text-center campo-troca" ' +
                        'data-venda-id="' + vendaId + '" ' +
                        'value="' + (troca || 0) + '" ' +
                        'min="0" step="0.001" style="width: 80px;">' +
                        '</td>'
                    );
                });
            } else {
                // Adicionar células vazias para outras linhas
                $row.find('td').eq(6).before(
                    '<td class="text-center">-</td>' +
                    '<td class="text-center">-</td>'
                );
            }
        });

        // Adicionar evento de blur para salvar
        $(document).on('blur', '.campo-quebra, .campo-troca', function() {
            const $campo = $(this);
            const vendaId = $campo.data('venda-id');
            const tipo = $campo.hasClass('campo-quebra') ? 'quebra' : 'troca';
            const valor = parseFloat($campo.val()) || 0;

            salvarQuebraTroca(vendaId, tipo, valor);
        });
    }

    function buscarQuebraTroca(vendaId, callback) {
        $.ajax({
            url: URL_ITENS,
            method: 'GET',
            data: {
                venda_id: vendaId
            },
            success: function(response) {
                let quebra = 0;
                let troca = 0;

                if (response.success && response.itens) {
                    response.itens.forEach(function(item) {
                        quebra += parseFloat(item.quebra || 0);
                        troca += parseFloat(item.troca || 0);
                    });
                }

                callback(quebra, troca);
            },
            error: function() {
                callback(0, 0);
            }
        });
    }

    function salvarQuebraTroca(vendaId, tipo, valor) {
        $.ajax({
            url: URL_ITENS_ATUALIZAR,
            method: 'POST',
            data: {
                venda_id: vendaId,
                tipo: tipo,
                valor: valor
            },
            success: function(response) {
                if (!response.success) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: response.message || 'Erro ao salvar ' + tipo
                    });
                }
            },
            error: function() {
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: 'Erro ao salvar ' + tipo
                });
            }
        });
    }

    // Sobrescrever função abrirOpcoesVenda para adicionar opção de mudança de status e botão de triagem
    const originalAbrirOpcoesVenda = window.abrirOpcoesVenda;

    window.abrirOpcoesVenda = function(event) {
        // Obter vendaId ANTES de chamar a função original (que pode modificar o DOM)
        const row = $(event.currentTarget).closest('tr');
        const vendaId = row.attr('data-venda-id') || row.data('venda-id') || row.find('td:first').text();
        const statusAtual = row.find('td').eq(5).find('.badge').text().trim() || 'orcamento';

        console.log('abrirOpcoesVenda - vendaId obtido:', vendaId, 'row data:', row.data('venda-id'), 'row attr:', row.attr('data-venda-id'));

        if (originalAbrirOpcoesVenda) {
            originalAbrirOpcoesVenda(event);
        }

        // Adicionar seção de status e botão de triagem após o modal abrir
        setTimeout(() => {
            const statusAtualLower = statusAtual.toLowerCase();

            // Adicionar botão especial para triagem
            if (statusAtualLower.includes('triagem')) {
                const urlEditar = URL_EDITAR;
                const triagemButton = `
                    <button type="button" class="opcao-card opcao-card-warning" onclick="window.location.href='${urlEditar}?id=' + ${vendaId}">
                        <i class="bi bi-clipboard-check"></i>
                        <span>Conferir Triagem</span>
                    </button>
                `;
                const container = $('.swal-venda-container');
                if (container.length) {
                    const opcoesGrid = container.find('.opcoes-grid').first();
                    if (opcoesGrid.length && !opcoesGrid.find('button:contains("Conferir Triagem")')
                        .length) {
                        opcoesGrid.prepend(triagemButton);
                    }
                }
            }

            // Buscar status disponíveis e adicionar seção de status
            $.ajax({
                url: window.location.pathname,
                method: 'GET',
                data: {
                    ajax_status: 1
                },
                success: function(response) {
                    // Adicionar seção de status no modal
                    adicionarSecaoStatus(vendaId, statusAtual);
                }
            });
        }, 100);
    };

    function adicionarSecaoStatus(vendaId, statusAtual) {
        console.log('adicionarSecaoStatus chamado com:', { vendaId, statusAtual });

        if (!vendaId || vendaId === '') {
            console.error('vendaId está vazio na função adicionarSecaoStatus');
            return;
        }

        const statusDisponiveis = [{
                codigo: 'orcamento',
                nome: 'Orçamento',
                cor: '#6c757d',
                icone: 'bi-file-earmark-text'
            },
            {
                codigo: 'triagem',
                nome: 'Triagem',
                cor: '#ffc107',
                icone: 'bi-funnel'
            },
            {
                codigo: 'separacao',
                nome: 'Separação',
                cor: '#17a2b8',
                icone: 'bi-box-seam'
            },
            {
                codigo: 'expedicao',
                nome: 'Expedição',
                cor: '#007bff',
                icone: 'bi-box-arrow-up'
            },
            {
                codigo: 'liberacao_veiculo',
                nome: 'Liberação do Veículo',
                cor: '#28a745',
                icone: 'bi-truck'
            }
        ];

        let statusButtons = '';
        statusDisponiveis.forEach(status => {
            const isAtual = status.codigo === statusAtual.toLowerCase();
            const disabled = isAtual ? 'disabled' : '';
            const opacidade = isAtual ? 'opacity-50' : '';

            // Escapar aspas no nome do status
            const nomeEscapado = status.nome.replace(/'/g, "&#39;").replace(/"/g, "&quot;");
            const codigoEscapado = status.codigo.replace(/'/g, "&#39;").replace(/"/g, "&quot;");

            // Usar addEventListener ao invés de onclick inline para evitar problemas de escape
            const buttonId = `btn-status-${status.codigo}-${vendaId}`;
            statusButtons += `
                <button type="button"
                    id="${buttonId}"
                    class="opcao-card ${opacidade}"
                    ${disabled}
                    data-venda-id="${vendaId}"
                    data-status-codigo="${codigoEscapado}"
                    data-status-nome="${nomeEscapado.replace(/"/g, '&quot;')}"
                    style="border-color: ${status.cor}; ${isAtual ? 'background: ' + status.cor + '20;' : ''}">
                    <i class="bi ${status.icone}" style="color: ${status.cor};"></i>
                    <span>${status.nome}</span>
                </button>
            `;
        });

        const statusSection = `
            <div class="opcoes-grupo">
                <h6 class="opcoes-titulo">Transição de Status</h6>
                <div class="opcoes-grid">
                    ${statusButtons}
                </div>
            </div>
        `;

        // Adicionar antes do botão de fechar
        const container = $('.swal-venda-container');
        if (container.length && !container.find('.opcoes-grupo:contains("Transição de Status")').length) {
            container.find('.opcoes-grid').last().after(statusSection);
        }
    }


})(jQuery);
</script>

<script>
// URLs globais para serem acessíveis em todas as funções
const URL_EDITAR_GLOBAL = <?= json_encode($urlEditar, JSON_HEX_TAG | JSON_HEX_AMP | JSON_HEX_APOS | JSON_HEX_QUOT) ?>;

// Definir função global fora do IIFE para ser acessível pelos event listeners
window.mudarStatusOrcamento = function(vendaId, novoStatus, nomeStatus) {
    console.log('mudarStatusOrcamento chamado:', {
        vendaId,
        novoStatus,
        nomeStatus
    });

    if (!vendaId || !novoStatus) {
        console.error('Parâmetros inválidos:', {
            vendaId,
            novoStatus
        });
        Swal.fire({
            icon: 'error',
            title: 'Erro',
            text: 'Parâmetros inválidos para mudança de status'
        });
        return;
    }
    Swal.fire({
        title: 'Confirmar mudança de status?',
        html: `
            <div class="text-start">
                <p>Deseja alterar o status do DAV para <strong>${nomeStatus}</strong>?</p>
            </div>
        `,
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: '<i class="bi bi-check-circle me-2"></i> Confirmar',
        cancelButtonText: '<i class="bi bi-x-circle me-2"></i> Cancelar',
        confirmButtonColor: '#198754',
        cancelButtonColor: '#6c757d'
    }).then((result) => {
        if (result.isConfirmed) {
            const urlStatus =
                <?= json_encode($urlStatus, JSON_HEX_TAG | JSON_HEX_AMP | JSON_HEX_APOS | JSON_HEX_QUOT) ?>;
            $.ajax({
                url: urlStatus,
                method: 'POST',
                data: {
                    id: vendaId,
                    status: novoStatus
                },
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Status atualizado!',
                            text: response.message || 'Status alterado com sucesso',
                            timer: 1500,
                            showConfirmButton: false
                        }).then(() => {
                            // Se o novo status for 'triagem', redirecionar para a página de edição
                            if (novoStatus === 'triagem' && vendaId) {
                                window.location.href = URL_EDITAR_GLOBAL + '?id=' + vendaId;
                            } else {
                                window.location.reload();
                            }
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro',
                            text: response.message || 'Erro ao atualizar status'
                        });
                    }
                },
                error: function(xhr) {
                    const response = xhr.responseJSON || {};
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: response.message || 'Erro ao atualizar status'
                    });
                }
            });
        }
    });
};
</script>
<?php
$additionalScripts = ob_get_clean();

// Incluir a view de vendas (ela vai usar $additionalScripts se existir e incluir o layout)
include __DIR__ . '/../vendas/index.php';
?>