<?php
// Incluir o form de vendas base
$isEdit = isset($venda['id']);
$statusAtual = $venda['status'] ?? '';
$isTriagem = ($statusAtual === 'triagem');

// Incluir o form de vendas
include ROOT_PATH . '/views/vendas/form.php';
?>

<script>
$(document).ready(function() {
    const isTriagem = <?= $isTriagem ? 'true' : 'false' ?>;

    if (isTriagem) {
        // Bloquear campos principais
        $('#customer_id, #sale_date, .quantidade').prop('readonly', true).addClass('bg-light');

        // Adicionar colunas de triagem na tabela de itens
        const thead = $('#tabela-itens thead tr');
        if (thead.length && !thead.find('th:contains("Conferido")').length) {
            // Inserir antes da última coluna (Ações)
            thead.find('th').eq(6).before(
                '<th width="8%" class="text-center">Conferido</th>' +
                '<th width="8%" class="text-center">Quebra</th>' +
                '<th width="8%" class="text-center">Troca</th>'
            );
        }

        // Adicionar campos de triagem nos itens existentes após carregamento
        setTimeout(function() {
            $('#tbody-itens tr').each(function() {
                const $row = $(this);
                const index = $row.data('index');
                const item = itensTabela[index];

                if (item && !$row.find('.campo-conferido').length) {
                    const conferido = item.conferido ? 'checked' : '';
                    const quebra = parseFloat(item.quebra || 0).toFixed(3);
                    const troca = parseFloat(item.troca || 0).toFixed(3);
                    const itemId = item.id || '';

                    // Inserir antes da última coluna (Ações)
                    $row.find('td').eq(6).before(
                        '<td class="text-center">' +
                            '<input type="checkbox" class="form-check-input campo-conferido" ' +
                            'data-index="' + index + '" ' + conferido + '>' +
                        '</td>' +
                        '<td class="text-center">' +
                            '<input type="number" class="form-control form-control-sm text-center campo-quebra" ' +
                            'data-index="' + index + '" ' +
                            'value="' + quebra + '" ' +
                            'min="0" step="0.001" style="width: 80px;">' +
                        '</td>' +
                        '<td class="text-center">' +
                            '<input type="number" class="form-control form-control-sm text-center campo-troca" ' +
                            'data-index="' + index + '" ' +
                            'value="' + troca + '" ' +
                            'min="0" step="0.001" style="width: 80px;">' +
                        '</td>'
                    );

                    // Adicionar campos hidden (incluindo ID do item)
                    $row.append(
                        '<input type="hidden" name="itens[' + index + '][id]" value="' + itemId + '">' +
                        '<input type="hidden" name="itens[' + index + '][conferido]" class="hidden-conferido" value="' + (item.conferido ? '1' : '0') + '">' +
                        '<input type="hidden" name="itens[' + index + '][quebra]" class="hidden-quebra" value="' + quebra + '">' +
                        '<input type="hidden" name="itens[' + index + '][troca]" class="hidden-troca" value="' + troca + '">'
                    );
                }
            });
        }, 500);

        // Event listeners para campos de triagem
        $(document).on('change', '.campo-conferido', function() {
            const index = $(this).data('index');
            const checked = $(this).is(':checked') ? '1' : '0';
            $(this).closest('tr').find('.hidden-conferido').val(checked);
        });

        $(document).on('blur', '.campo-quebra, .campo-troca', function() {
            const $campo = $(this);
            const index = $campo.data('index');
            const valor = parseFloat($campo.val()) || 0;
            const tipo = $campo.hasClass('campo-quebra') ? 'quebra' : 'troca';

            $campo.closest('tr').find('.hidden-' + tipo).val(valor.toFixed(3));
        });
    }

    // Sobrescrever função adicionarItemNaTabela para incluir campos de triagem
    const originalAdicionarItemNaTabela = window.adicionarItemNaTabela;
    window.adicionarItemNaTabela = function(item, isLoad) {
        if (originalAdicionarItemNaTabela) {
            originalAdicionarItemNaTabela(item, isLoad);
        }

        if (isTriagem) {
            // Adicionar campos de triagem ao item recém-adicionado
            setTimeout(() => {
                const $row = $('#tbody-itens tr').last();
                const index = $row.data('index');

                if (!$row.find('.campo-conferido').length) {
                    const conferido = item.conferido ? 'checked' : '';
                    const quebra = parseFloat(item.quebra || 0).toFixed(3);
                    const troca = parseFloat(item.troca || 0).toFixed(3);

                    $row.find('td').eq(6).before(
                        '<td class="text-center">' +
                            '<input type="checkbox" class="form-check-input campo-conferido" ' +
                            'data-index="' + index + '" ' + conferido + '>' +
                        '</td>' +
                        '<td class="text-center">' +
                            '<input type="number" class="form-control form-control-sm text-center campo-quebra" ' +
                            'data-index="' + index + '" ' +
                            'value="' + quebra + '" ' +
                            'min="0" step="0.001" style="width: 80px;">' +
                        '</td>' +
                        '<td class="text-center">' +
                            '<input type="number" class="form-control form-control-sm text-center campo-troca" ' +
                            'data-index="' + index + '" ' +
                            'value="' + troca + '" ' +
                            'min="0" step="0.001" style="width: 80px;">' +
                        '</td>'
                    );

                    const itemId = item.id || '';
                    $row.append(
                        '<input type="hidden" name="itens[' + index + '][id]" value="' + itemId + '">' +
                        '<input type="hidden" name="itens[' + index + '][conferido]" class="hidden-conferido" value="' + (item.conferido ? '1' : '0') + '">' +
                        '<input type="hidden" name="itens[' + index + '][quebra]" class="hidden-quebra" value="' + quebra + '">' +
                        '<input type="hidden" name="itens[' + index + '][troca]" class="hidden-troca" value="' + troca + '">'
                    );
                }
            }, 100);
        }
    };
});
</script>

