<?php
ob_start();

$venda = $venda ?? [];
$itens = $itens ?? [];
$clientes = $clientes ?? [];
$produtos = $produtos ?? [];
$user = $user ?? [];
$userName = $user['name'] ?? 'Responsável não identificado';
$userId = $user['id'] ?? null;
$userRole = strtolower(trim($userRole ?? ($user['role'] ?? '')));
$isOperator = ($userRole === 'operator' || $userRole === 'operador');
$isTriagemRole = ($userRole === 'triagem');

// Debug
error_log("DEBUG - userRole: " . var_export($userRole, true));
error_log("DEBUG - isTriagemRole: " . var_export($isTriagemRole, true));

// Debug: verificar status
$statusVenda = strtolower(trim($venda['status'] ?? ''));
$isTriagem = ($statusVenda === 'triagem');
$vendaId = (int) ($venda['id'] ?? 0);
$saleNumber = $venda['sale_number'] ?? '';
$saleDate = $venda['sale_date'] ?? date('Y-m-d');
$customerId = (int) ($venda['customer_id'] ?? 0);
$notes = $venda['notes'] ?? '';

// Debug log
error_log("Edit Orcamento - Status: " . $statusVenda . ", isTriagem: " . ($isTriagem ? 'true' : 'false'));

// Buscar dados do cliente selecionado
$clienteSelecionado = null;
if ($customerId > 0) {
    foreach ($clientes as $cliente) {
        if ((int) $cliente['id'] === $customerId) {
            $clienteSelecionado = $cliente;
            break;
        }
    }
}

// Criar mapa de itens por produto_id para facilitar busca
$itensMap = [];
foreach ($itens as $item) {
    $itensMap[(int) $item['product_id']] = $item;
}

?>

<style>
.orcamento-form-card {
    border-radius: 16px;
    border: 1px solid rgba(15, 23, 42, 0.08);
    box-shadow: 0 10px 24px rgba(15, 23, 42, 0.08);
}

.orcamento-section-title {
    font-size: 0.85rem;
    font-weight: 700;
    letter-spacing: 0.08em;
    text-transform: uppercase;
    color: #64748b;
}

.produto-quantidade input[type="number"] {
    max-width: 120px;
}

.resumo-card {
    border-radius: 14px;
    background: #0ea5e9;
    color: #fff;
}

.autocomplete-dropdown {
    position: absolute;
    top: 100%;
    left: 0;
    right: 0;
    background: var(--bs-body-bg, #fff);
    border: 1px solid var(--bs-border-color, #dee2e6);
    border-radius: 0.375rem;
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
    max-height: 400px;
    overflow-y: auto;
    z-index: 1000;
    margin-top: 0.25rem;
}

.autocomplete-item {
    padding: 0.875rem 1rem;
    cursor: pointer;
    border-bottom: 1px solid var(--bs-border-color, #f0f0f0);
    transition: all 0.15s ease-in-out;
    line-height: 1.5;
}

.autocomplete-item:hover,
.autocomplete-item.active {
    background-color: var(--bs-primary, #0d6efd);
    color: white;
    transform: translateX(3px);
}

.autocomplete-item:hover .text-muted {
    color: rgba(255, 255, 255, 0.8) !important;
}

.autocomplete-item:last-child {
    border-bottom: none;
}

.autocomplete-item .mb-1 {
    margin-bottom: 0.375rem;
}

.autocomplete-item strong {
    font-weight: 600;
}

.autocomplete-no-results {
    padding: 1rem;
    text-align: center;
    color: var(--bs-secondary, #6c757d);
}

.campo-bloqueado {
    background-color: #e9ecef !important;
    cursor: not-allowed;
    opacity: 0.7;
}

.campo-bloqueado:focus {
    outline: none;
    box-shadow: none;
    border-color: #ced4da;
}

/* Garantir que coluna Qtd Informada fique oculta para role triagem */
<?php if ($isTriagemRole): ?>.coluna-qtd-informada {
    display: none !important;
    visibility: hidden !important;
    width: 0 !important;
    padding: 0 !important;
    margin: 0 !important;
}

.coluna-qtd-informada-header {
    display: none !important;
    visibility: hidden !important;
    width: 0 !important;
    padding: 0 !important;
    margin: 0 !important;
}

<?php endif;
?>
</style>

<form method="POST" action="<?= url('/orcamentos-agua/editar') ?>" id="form-orcamento">
    <input type="hidden" name="id" value="<?= $vendaId ?>">

    <?php if ($isTriagem): ?>
    <div class="alert alert-warning mb-4">
        <i class="bi bi-exclamation-triangle me-2"></i>
        <strong>Modo Triagem:</strong> Os campos de Cliente, Data e Quantidade estão bloqueados. Preencha os campos de
        Conferido, Quebra e Troca para cada item.
    </div>
    <?php endif; ?>

    <div class="card orcamento-form-card mb-4">
        <div class="card-header bg-light d-flex justify-content-between align-items-center">
            <div>
                <h5 class="mb-1"><i class="bi bi-droplet me-2"></i>Editar Orçamento de Água Mineral</h5>
                <small class="text-muted">Número: <strong><?= htmlspecialchars($saleNumber) ?></strong></small>
            </div>
            <a href="<?= url('/orcamentos-agua') ?>" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-2"></i>Voltar
            </a>
        </div>
        <div class="card-body">
            <div class="row g-4">
                <div class="col-md-6">
                    <span class="orcamento-section-title d-block mb-2">Responsável</span>
                    <div class="card border-0 bg-slate-50">
                        <div class="card-body py-3">
                            <strong><?= htmlspecialchars($userName) ?></strong>
                            <input type="hidden" name="vendor_id" value="<?= htmlspecialchars((string) $userId) ?>">
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <span class="orcamento-section-title d-block mb-2">Data do Orçamento</span>
                    <input type="date" class="form-control <?= $isTriagem ? 'campo-bloqueado' : '' ?>" name="sale_date"
                        value="<?= htmlspecialchars($saleDate) ?>" <?= $isTriagem ? 'readonly' : '' ?>>
                </div>
                <div class="col-12">
                    <span class="orcamento-section-title d-block mb-2">Cliente</span>
                    <div class="position-relative">
                        <input type="text" class="form-control <?= $isTriagem ? 'campo-bloqueado' : '' ?>"
                            id="cliente_busca" placeholder="Digite nome, razão social ou CNPJ/CPF do cliente..."
                            autocomplete="off" <?= $isTriagem ? 'readonly disabled' : '' ?>
                            value="<?= $clienteSelecionado ? htmlspecialchars($clienteSelecionado['trade_name'] ?: $clienteSelecionado['name']) : '' ?>">
                        <div id="cliente_dropdown" class="autocomplete-dropdown" style="display: none;"></div>
                    </div>
                    <input type="hidden" name="customer_id" id="customer_id" value="<?= $customerId ?>">
                    <div class="mt-2" id="cliente_info" style="<?= $clienteSelecionado ? '' : 'display: none;' ?>">
                        <div class="alert alert-info mb-0">
                            <div class="d-flex justify-content-between align-items-start">
                                <div class="flex-grow-1" id="cliente_info_name">
                                    <?php if ($clienteSelecionado): ?>
                                    <?php
                                        $nomeFantasia = $clienteSelecionado['trade_name'] ?? '-';
                                        $razaoSocial = $clienteSelecionado['name'] ?? '-';
                                        $codigo = str_pad((string) $clienteSelecionado['id'], 4, '0', STR_PAD_LEFT);
                                        $documento = $clienteSelecionado['document'] ?? 'Não informado';
                                        $telefone = $clienteSelecionado['phone'] ?? $clienteSelecionado['mobile'] ?? '-';
                                        $email = $clienteSelecionado['email'] ?? '-';
                                        ?>
                                    <div style="line-height: 1.6;">
                                        <div class="mb-1">
                                            <strong>Código: <?= htmlspecialchars($codigo) ?></strong> |
                                            <?= htmlspecialchars($documento) ?>
                                        </div>
                                        <div class="mb-1">
                                            <strong>Razão Social:</strong> <?= htmlspecialchars($razaoSocial) ?> |
                                            <strong>Fantasia:</strong> <?= htmlspecialchars($nomeFantasia) ?>
                                        </div>
                                        <div class="text-muted small">
                                            <strong>Fone:</strong> <?= htmlspecialchars($telefone) ?> |
                                            <strong>Email:</strong> <?= htmlspecialchars($email) ?>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                                <?php if (!$isTriagem): ?>
                                <button type="button" class="btn btn-sm btn-outline-danger ms-2"
                                    onclick="limparCliente()">
                                    <i class="bi bi-x"></i>
                                </button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if (!empty($profissionais ?? [])): ?>
                <div class="col-md-6">
                    <span class="orcamento-section-title d-block mb-2">Profissional</span>
                    <select class="form-select" name="profissional_id" id="profissional_id">
                        <option value="">Selecione um profissional...</option>
                        <?php foreach ($profissionais as $prof): ?>
                        <option value="<?= $prof['id'] ?>"><?= htmlspecialchars($prof['name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="card orcamento-form-card mb-4">
        <div class="card-header bg-light">
            <h6 class="mb-0"><i class="bi bi-basket me-2"></i>Produtos disponíveis</h6>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table align-middle mb-0">
                    <thead class="table-light">
                        <tr>
                            <th>Produto</th>
                            <?php if (!$isOperator && !$isTriagemRole): ?>
                            <th class="text-center">SKU</th>
                            <th class="text-end">Preço Unitário</th>
                            <?php endif; ?>
                            <?php if (!$isTriagemRole): ?>
                            <th class="text-center" style="width: 120px;">Qtd Informada</th>
                            <?php endif; ?>
                            <?php if (!$isOperator): ?>
                            <th class="text-center" style="width: 120px;">Qtd Conferida</th>
                            <th class="text-center" style="width: 120px;">Diferença</th>
                            <th class="text-center" style="width: 120px;">Troca</th>
                            <th class="text-center" style="width: 120px;">Quebra</th>
                            <th class="text-center" style="width: 120px;">Cashback</th>
                            <th class="text-center" style="width: 120px;">Compra</th>
                            <th class="text-center" style="width: 120px;">Qtd Faturada</th>
                            <?php endif; ?>
                            <?php if (!$isOperator && !$isTriagemRole): ?>
                            <!-- <th class="text-center" style="width: 120px;">P/ +1 Faltam R$</th> -->
                            <th class="text-end">Subtotal</th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        // Mostrar apenas produtos que têm itens no orçamento
                        foreach ($itens as $item):
                            $produtoId = (int) $item['product_id'];
                            // Buscar dados do produto
                            $produto = null;
                            foreach ($produtos as $p) {
                                if ((int) $p['id'] === $produtoId) {
                                    $produto = $p;
                                    break;
                                }
                            }
                            if (!$produto) continue; // Pular se produto não encontrado

                            $preco = (float) ($produto['price'] ?? $item['unit_price'] ?? 0);
                            $quantidade = (float) $item['quantity'];
                            $qtdInformada = (float) ($item['qtd_informada'] ?? $quantidade);
                            $conferido = (float) ($item['conferido'] ?? 0);
                            $diferenca = (float) ($item['diferenca'] ?? ($qtdInformada - $conferido));
                            $quebra = (float) ($item['quebra'] ?? 0);
                            $troca = (float) ($item['troca'] ?? 0);
                            $cashback = (float) ($item['cashback'] ?? 0);
                            $compra = (float) ($item['compra'] ?? 0);
                            $faltaR = (float) ($item['falta_r'] ?? 0);
                            $produtoCashback = (float) ($produto['cashback'] ?? 0);
                            $lancarQuebra = ($produto['lancar_quebra'] ?? 'Sim');
                            $lancarTroca = ($produto['lancar_troca'] ?? 'Sim');
                            $podeLancarQuebra = ($lancarQuebra === 'Sim' || $lancarQuebra === 'S' || $lancarQuebra === 1 || $lancarQuebra === true);
                            $podeLancarTroca = ($lancarTroca === 'Sim' || $lancarTroca === 'S' || $lancarTroca === 1 || $lancarTroca === true);
                            $itemId = (int) $item['id'];
                        ?>
                        <tr data-produto-id="<?= $produtoId ?>" data-preco="<?= number_format($preco, 2, '.', '') ?>"
                            data-item-id="<?= $itemId ?>"
                            data-produto-cashback="<?= number_format($produtoCashback, 0, '.', '') ?>"
                            data-qtd-informada="<?= number_format($qtdInformada, 3, '.', '') ?>">
                            <td>
                                <strong><?= htmlspecialchars($produto['name'] ?? $item['product_name'] ?? 'Produto') ?></strong>
                            </td>
                            <?php if (!$isOperator && !$isTriagemRole): ?>
                            <td class="text-center">
                                <?= htmlspecialchars($produto['sku'] ?? $item['product_sku'] ?? '—') ?></td>
                            <td class="text-end">R$ <?= number_format($preco, 2, ',', '.') ?></td>
                            <?php endif; ?>
                            <?php if (!$isTriagemRole): ?>
                            <td class="text-center coluna-qtd-informada">
                                <input type="number"
                                    class="form-control form-control-sm text-center campo-qtd-informada"
                                    name="itens[<?= $produtoId ?>][qtd_informada]"
                                    value="<?= number_format($qtdInformada, 3, '.', '') ?>" min="0" step="0.001"
                                    style="width: 100px;" <?= ($isTriagem || $isTriagemRole) ? 'readonly' : '' ?>>
                                <input type="hidden" name="itens[<?= $produtoId ?>][id]" value="<?= $itemId ?>">
                            </td>
                            <?php else: ?>
                            <!-- Campo hidden para preservar qtd_informada quando role = triagem -->
                            <input type="hidden" name="itens[<?= $produtoId ?>][qtd_informada]"
                                value="<?= number_format($qtdInformada, 3, '.', '') ?>">
                            <input type="hidden" name="itens[<?= $produtoId ?>][id]" value="<?= $itemId ?>">
                            <?php endif; ?>
                            <?php if (!$isOperator): ?>
                            <td class="text-center">
                                <input type="number" class="form-control form-control-sm text-center campo-conferido"
                                    name="itens[<?= $produtoId ?>][conferido]"
                                    value="<?= number_format($conferido, 3, '.', '') ?>" min="0" step="0.001"
                                    style="width: 100px;" data-qtd-informada="<?= $qtdInformada ?>" autocomplete="off"
                                    data-lpignore="true" <?= $isTriagemRole ? 'data-bloquear-apos-blur="true"' : '' ?>>
                            </td>
                            <td class="text-center">
                                <input type="number" class="form-control form-control-sm text-center campo-diferenca"
                                    name="itens[<?= $produtoId ?>][diferenca]"
                                    value="<?= number_format($diferenca, 3, '.', '') ?>" min="0" step="0.001"
                                    style="width: 100px;" readonly autocomplete="off" data-lpignore="true">
                            </td>
                            <td class="text-center">
                                <input type="number" class="form-control form-control-sm text-center campo-troca"
                                    name="itens[<?= $produtoId ?>][troca]"
                                    value="<?= number_format($troca, 3, '.', '') ?>" min="0" step="0.001"
                                    style="width: 100px;" autocomplete="off" data-lpignore="true"
                                    <?= !$podeLancarTroca ? 'readonly' : '' ?>>
                            </td>
                            <td class="text-center">
                                <input type="number" class="form-control form-control-sm text-center campo-quebra"
                                    name="itens[<?= $produtoId ?>][quebra]"
                                    value="<?= number_format($quebra, 3, '.', '') ?>" min="0" step="0.001"
                                    style="width: 100px;" autocomplete="off" data-lpignore="true"
                                    <?= !$podeLancarQuebra ? 'readonly' : '' ?>>
                            </td>
                            <td class="text-center">
                                <input type="number" class="form-control form-control-sm text-center campo-cashback"
                                    name="itens[<?= $produtoId ?>][cashback]"
                                    value="<?= number_format($cashback, 3, '.', '') ?>" min="0" step="0.001"
                                    style="width: 100px;" readonly autocomplete="off" data-lpignore="true">
                            </td>
                            <td class="text-center">
                                <input type="number" class="form-control form-control-sm text-center campo-compra"
                                    name="itens[<?= $produtoId ?>][compra]"
                                    value="<?= number_format($compra, 3, '.', '') ?>" min="0" step="0.001"
                                    style="width: 100px;" readonly autocomplete="off" data-lpignore="true">
                            </td>
                            <td class="text-center produto-quantidade">
                                <input type="number"
                                    class="form-control text-center quantidade-input <?= $isTriagem ? 'campo-bloqueado' : '' ?>"
                                    name="quantities[<?= $produtoId ?>]" min="0" step="1"
                                    value="<?= number_format($quantidade, 0, '.', '') ?>"
                                    <?= $isTriagem ? 'readonly' : '' ?>>
                            </td>
                            <?php endif; ?>
                            <?php if (!$isOperator && !$isTriagemRole): ?>
                            <!-- <td class="text-center">
                                    <input type="number" class="form-control form-control-sm text-center campo-falta-r"
                                        name="itens[<?= $produtoId ?>][falta_r]"
                                        value="<?= number_format($faltaR, 2, '.', '') ?>"
                                        min="0" step="0.01" style="width: 100px;"
                                        readonly>
                                </td> -->
                            <td class="text-end subtotal-item">R$
                                <?= number_format($preco * $quantidade, 2, ',', '.') ?></td>
                            <?php endif; ?>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="row g-4 mb-4">
        <div class="col-lg-8">
            <div class="card orcamento-form-card">
                <div class="card-header bg-light">
                    <h6 class="mb-0"><i class="bi bi-sticky me-2"></i>Observações</h6>
                </div>
                <div class="card-body">
                    <textarea class="form-control" name="notes" rows="4"
                        placeholder="Informe observações relevantes (ex.: condições de entrega, forma de pagamento, etc.)"
                        <?= $isTriagem ? 'readonly' : '' ?>><?= htmlspecialchars($notes) ?></textarea>
                </div>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="card resumo-card border-0">
                <div class="card-body">
                    <h6 class="text-uppercase mb-3">Resumo do Orçamento</h6>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Itens selecionados</span>
                        <strong id="resumo-itens">0</strong>
                    </div>
                    <div class="d-flex justify-content-between">
                        <span>Total estimado</span>
                        <strong id="resumo-total">R$ 0,00</strong>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="d-flex justify-content-end gap-2">
        <a href="<?= url('/orcamentos-agua') ?>" class="btn btn-outline-secondary">
            Cancelar
        </a>
        <button type="submit" class="btn btn-primary">
            <i class="bi bi-check-circle me-2"></i><?= $isTriagem ? 'Salvar Triagem' : 'Atualizar Orçamento' ?>
        </button>
    </div>
</form>

<script>
(function($) {
    'use strict';

    const clientesData = <?= json_encode($clientes ?? []) ?>;
    let selectedCustomer = <?= $clienteSelecionado ? json_encode($clienteSelecionado) : 'null' ?>;
    let autocompleteTimeout = null;
    const isTriagem = <?= $isTriagem ? 'true' : 'false' ?>;

    // Inicializar autocomplete de cliente (apenas se não estiver em triagem)
    function inicializarAutocompleteCliente() {
        if (isTriagem) {
            return; // Não inicializar se estiver em triagem
        }

        const $search = $('#cliente_busca');
        const $dropdown = $('#cliente_dropdown');

        // Ao digitar
        $search.on('input', function() {
            const query = $(this).val().trim().toLowerCase();

            clearTimeout(autocompleteTimeout);

            if (query.length < 2) {
                $dropdown.hide();
                return;
            }

            autocompleteTimeout = setTimeout(() => {
                buscarClientes(query);
            }, 300);
        });

        // Ao clicar fora, fechar dropdown
        $(document).on('click', function(e) {
            if (!$(e.target).closest('#cliente_busca, #cliente_dropdown').length) {
                $dropdown.hide();
            }
        });

        // Ao focar no campo
        $search.on('focus', function() {
            if ($(this).val().length >= 2) {
                buscarClientes($(this).val().trim().toLowerCase());
            }
        });

        // Ao pressionar Enter, apenas prevenir submit
        $search.on('keydown', function(e) {
            if (e.key === 'Enter') {
                e.preventDefault();
            }
        });
    }

    function buscarClientes(query) {
        const $dropdown = $('#cliente_dropdown');

        // Filtrar clientes
        const results = clientesData.filter(cliente => {
            const name = (cliente.name || '').toLowerCase();
            const tradeName = (cliente.trade_name || '').toLowerCase();
            const document = (cliente.document || '').toLowerCase();
            const email = (cliente.email || '').toLowerCase();
            const phone = (cliente.phone || '').toLowerCase();
            const mobile = (cliente.mobile || '').toLowerCase();

            // Normalizar query e documento para busca mais flexível
            const normalizedQuery = query.replace(/[^\d\w]/g, '').toLowerCase();
            const normalizedDocument = document.replace(/[^\d\w]/g, '').toLowerCase();

            return name.includes(query) || tradeName.includes(query) ||
                document.includes(query) || normalizedDocument.includes(normalizedQuery) ||
                email.includes(query) || phone.includes(query) || mobile.includes(query);
        });

        // Montar HTML
        let html = '';

        if (results.length > 0) {
            results.forEach(cliente => {
                const nomeFantasia = cliente.trade_name || '-';
                const razaoSocial = cliente.name || '-';
                const documento = cliente.document || 'Não informado';
                const codigo = String(cliente.id).padStart(4, '0');
                const telefone = cliente.phone || cliente.mobile || '-';
                const email = cliente.email || '-';

                html += `
                    <div class="autocomplete-item" data-id="${cliente.id}">
                        <div class="mb-1">
                            <strong>Código: ${codigo}</strong>  |  <strong>CNPJ/CPF:</strong> ${documento}
                        </div>
                        <div class="mb-1">
                            <strong>Razão Social:</strong> ${razaoSocial}  |  <strong>Fantasia:</strong> ${nomeFantasia}
                        </div>
                        <div class="text-muted small">
                            <strong>Fone:</strong> ${telefone}  |  <strong>Email:</strong> ${email}
                        </div>
                    </div>
                `;
            });
        } else {
            html = '<div class="autocomplete-no-results">Nenhum cliente encontrado</div>';
        }

        $dropdown.html(html).show();

        // Event listeners
        $dropdown.find('.autocomplete-item').on('click', function() {
            const clienteId = $(this).data('id');
            const cliente = clientesData.find(c => c.id == clienteId);
            if (cliente) {
                selecionarCliente(cliente);
            }
        });
    }

    function selecionarCliente(cliente) {
        selectedCustomer = cliente;

        const nomeFantasia = cliente.trade_name || '-';
        const razaoSocial = cliente.name || '-';
        const nomeExibir = nomeFantasia !== '-' ? nomeFantasia : razaoSocial;
        const codigo = String(cliente.id).padStart(4, '0');
        const documento = cliente.document || 'Não informado';
        const telefone = cliente.phone || cliente.mobile || '-';
        const email = cliente.email || '-';

        // Preencher campo hidden
        $('#customer_id').val(cliente.id);

        // Atualizar campo de busca
        $('#cliente_busca').val(nomeExibir);

        // Mostrar info do cliente no formato estruturado
        let infoHtml = `
            <div style="line-height: 1.6;">
                <div class="mb-1">
                    <strong>Código: ${codigo}</strong>  |  ${documento}
                </div>
                <div class="mb-1">
                    <strong>Razão Social:</strong> ${razaoSocial}  |  <strong>Fantasia:</strong> ${nomeFantasia}
                </div>
                <div class="text-muted small">
                    <strong>Fone:</strong> ${telefone}  |  <strong>Email:</strong> ${email}
                </div>
            </div>
        `;

        $('#cliente_info_name').html(infoHtml);
        $('#cliente_info').slideDown();

        // Fechar dropdown
        $('#cliente_dropdown').hide();
    }

    window.limparCliente = function() {
        if (isTriagem) {
            return; // Não permitir limpar em triagem
        }
        selectedCustomer = null;

        $('#customer_id').val('');
        $('#cliente_busca').val('');
        $('#cliente_info').slideUp();
    };

    // Inicializar quando o DOM estiver pronto
    $(document).ready(function() {
        // Forçar bloqueio de campos se estiver em triagem
        if (isTriagem) {
            // Bloquear campos
            $('input[name="sale_date"]').prop('readonly', true).addClass('campo-bloqueado');
            $('#cliente_busca').prop('readonly', true).prop('disabled', true).addClass('campo-bloqueado');
            $('.quantidade-input').prop('readonly', true).addClass('campo-bloqueado');
            $('textarea[name="notes"]').prop('readonly', true).addClass('campo-bloqueado');

            // Garantir que campos de triagem estejam visíveis e habilitados
            // Nota: diferenca, cashback e falta_r são sempre readonly (calculados automaticamente)
            // Nota: quebra e troca podem ser readonly se produto.lancar_quebra/troca = "Não"
            $('.campo-qtd-informada, .campo-conferido').prop('disabled', false);
            $('.campo-quebra').each(function() {
                if (!$(this).prop('readonly')) {
                    $(this).prop('disabled', false);
                }
            });
            $('.campo-troca').each(function() {
                if (!$(this).prop('readonly')) {
                    $(this).prop('disabled', false);
                }
            });
        }

        // Bloquear campo conferido após blur quando role = triagem e exibir Qtd Informada
        $(document).on('blur', '.campo-conferido[data-bloquear-apos-blur="true"]', function() {
            const $campo = $(this);
            const $row = $campo.closest('tr');
            const valor = parseFloat($campo.val() || 0);
            if (valor > 0) {
                $campo.prop('readonly', true);
                $campo.addClass('campo-bloqueado');

                // Exibir coluna Qtd Informada APENAS após blur do campo Qtd Conferida
                // Se a célula não existir, criar dinamicamente
                if ($row.find('.coluna-qtd-informada').length === 0) {
                    const qtdInformada = parseFloat($row.data('qtd-informada') || $row.find(
                        'input[name*="[qtd_informada]"]').val() || 0);
                    const produtoId = $row.data('produto-id');
                    const itemId = $row.data('item-id');

                    const $td = $(`
                        <td class="text-center coluna-qtd-informada">
                            <input type="number" class="form-control form-control-sm text-center campo-qtd-informada"
                                name="itens[${produtoId}][qtd_informada]"
                                value="${qtdInformada.toFixed(3)}"
                                min="0" step="0.001" style="width: 100px;"
                                readonly>
                            <input type="hidden" name="itens[${produtoId}][id]" value="${itemId}">
                        </td>
                    `);

                    // Inserir antes da coluna Qtd Conferida
                    $row.find('td:has(.campo-conferido)').before($td);
                } else {
                    $row.find('.coluna-qtd-informada').css({
                        'display': 'table-cell',
                        'visibility': 'visible',
                        'width': 'auto',
                        'padding': '',
                        'margin': ''
                    });
                }

                // Adicionar cabeçalho da coluna se não existir
                if ($('th.coluna-qtd-informada-header').length === 0) {
                    const $header = $(
                        '<th class="text-center coluna-qtd-informada-header" style="width: 120px;">Qtd Informada</th>'
                    );
                    $row.closest('table').find('thead tr th:first').after($header);
                } else {
                    $('th.coluna-qtd-informada-header').css({
                        'display': 'table-cell',
                        'visibility': 'visible',
                        'width': 'auto',
                        'padding': '',
                        'margin': ''
                    });
                }
            }
        });

        // Calcular diferença automaticamente quando conferido for alterado
        $(document).on('input change', '.campo-conferido', function() {
            const $row = $(this).closest('tr');
            const qtdInformada = parseFloat($row.find('.campo-qtd-informada').val() || 0);
            const conferido = parseFloat($(this).val() || 0);
            const diferenca = qtdInformada - conferido;

            $row.find('.campo-diferenca').val(diferenca.toFixed(3));

            // Validar: se quebra for maior que a nova diferença, ajustar
            const quebra = parseFloat($row.find('.campo-quebra').val() || 0);
            if (quebra > diferenca) {
                $row.find('.campo-quebra').val(diferenca.toFixed(3));
                calcularCashbackFaltaR($row);
            }
        });

        // Recalcular Qtd Faturada quando Conferido for alterado (blur) - exceto produto id = 2
        $(document).on('blur', '.campo-conferido', function() {
            const $row = $(this).closest('tr');
            const produtoId = parseInt($row.data('produto-id') || 0);

            // Não processar para produto id = 2
            if (produtoId === 2) {
                return;
            }

            // Buscar qtd_informada: primeiro do campo visível, depois do hidden, depois do data attribute
            let qtdInformada = 0;
            const $campoVisivel = $row.find('.campo-qtd-informada');
            if ($campoVisivel.length > 0) {
                qtdInformada = parseFloat($campoVisivel.val() || 0);
            }
            if (!qtdInformada || isNaN(qtdInformada)) {
                const $campoHidden = $row.find('input[name*="[qtd_informada]"]');
                if ($campoHidden.length > 0) {
                    qtdInformada = parseFloat($campoHidden.val() || 0);
                }
            }
            if (!qtdInformada || isNaN(qtdInformada)) {
                const dataQtd = $row.data('qtd-informada');
                if (dataQtd !== undefined && dataQtd !== null) {
                    qtdInformada = parseFloat(dataQtd || 0);
                }
            }
            if (isNaN(qtdInformada)) {
                qtdInformada = 0;
            }

            const conferido = parseFloat($(this).val() || 0);
            const troca = parseFloat($row.find('.campo-troca').val() || 0);
            const cashback = parseFloat($row.find('.campo-cashback').val() || 0);
            const $campoCompra = $row.find('.campo-compra');
            const $campoQtdFaturada = $row.find('.quantidade-input');

            // Calcular: conferido + troca + cashback
            const soma = conferido + troca + cashback;

            if (Math.abs(soma - qtdInformada) < 0.001) {
                // Se conferido + troca + cashback = qtd informada
                $campoQtdFaturada.val(Math.round(soma));
                $campoCompra.val('0.000');
                atualizarResumo();
            } else {
                // Se não for igual, calcular diferença
                const diferenca = qtdInformada - soma;

                if (diferenca > 0) {
                    // Formatar diferença para exibir apenas números inteiros
                    const diferencaFormatada = diferenca % 1 === 0 ? Math.round(diferenca) :
                        diferenca.toFixed(3);

                    // Exibir SweetAlert2 perguntando se deseja comprar
                    Swal.fire({
                        title: 'Garrafões faltando',
                        html: `A diferença é de <strong>${diferencaFormatada}</strong> garrafões.<br>Deseja comprar os garrafões que faltam?`,
                        icon: 'question',
                        showCancelButton: true,
                        confirmButtonText: 'Sim, comprar',
                        cancelButtonText: 'Não',
                        confirmButtonColor: '#0ea5e9',
                        cancelButtonColor: '#6c757d'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            // Popular compra com a diferença
                            $campoCompra.val(diferenca.toFixed(3));
                            // Calcular qtd faturada: conferido + troca + cashback + compra
                            const qtdFaturada = soma + diferenca;
                            $campoQtdFaturada.val(Math.round(qtdFaturada));
                        } else {
                            // Não comprar, manter valores atuais
                            $campoCompra.val('0.000');
                            $campoQtdFaturada.val(Math.round(soma));
                        }
                        atualizarResumo();
                    });
                } else {
                    // Diferença negativa (excesso)
                    $campoCompra.val('0.000');
                    $campoQtdFaturada.val(Math.round(soma));
                    atualizarResumo();
                }
            }
        });

        // Calcular diferença quando qtd_informada for alterada (se não estiver em triagem)
        if (!isTriagem) {
            $(document).on('input change', '.campo-qtd-informada', function() {
                const $row = $(this).closest('tr');
                const qtdInformada = parseFloat($(this).val() || 0);
                const conferido = parseFloat($row.find('.campo-conferido').val() || 0);
                const diferenca = qtdInformada - conferido;

                $row.find('.campo-diferenca').val(diferenca.toFixed(3));

                // Validar: se quebra for maior que a nova diferença, ajustar
                const quebra = parseFloat($row.find('.campo-quebra').val() || 0);
                if (quebra > diferenca) {
                    $row.find('.campo-quebra').val(diferenca.toFixed(3));
                    calcularCashbackFaltaR($row);
                }
            });
        }

        // Função para calcular cashback e falta_r baseado em quebra e produto.cashback
        function calcularCashbackFaltaR($row) {
            const quebra = parseFloat($row.find('.campo-quebra').val() || 0);
            const produtoCashback = parseFloat($row.data('produto-cashback') || 0);
            const preco = parseFloat($row.data('preco') || 0);

            if (produtoCashback > 0 && quebra > 0) {
                // Calcular quantos cashbacks completos: floor(quebra / produtoCashback)
                const cashbackCalculado = Math.floor(quebra / produtoCashback);

                // Calcular o resto da divisão (diferença não múltipla do cashback)
                const resto = quebra % produtoCashback;

                // Calcular falta_r: (resto / fator_cashback) * preço_unitário
                const faltaR = resto > 0 ? (resto / produtoCashback) * preco : 0;

                $row.find('.campo-cashback').val(cashbackCalculado.toFixed(3));
                $row.find('.campo-falta-r').val(faltaR.toFixed(2));
            } else {
                $row.find('.campo-cashback').val('0.000');
                $row.find('.campo-falta-r').val('0.00');
            }
        }

        // Calcular cashback e falta_r quando quebra for alterada
        $(document).on('input change', '.campo-quebra', function() {
            const $row = $(this).closest('tr');
            const quebra = parseFloat($(this).val() || 0);
            const diferenca = parseFloat($row.find('.campo-diferenca').val() || 0);

            // Validar: quebra não pode ser maior que diferença
            if (quebra > diferenca) {
                $(this).val(diferenca.toFixed(3));
                alert('A quebra não pode ser maior que a diferença!');
            }

            calcularCashbackFaltaR($row);
        });

        // Validar e calcular compra no blur do campo quebra
        $(document).on('blur', '.campo-quebra', function() {
            const $campoQuebra = $(this);
            const $row = $campoQuebra.closest('tr');
            const produtoId = parseInt($row.data('produto-id') || 0);

            // Recalcular cashback antes de validar (garantir que está atualizado)
            calcularCashbackFaltaR($row);

            // Pequeno delay para garantir que o cashback foi atualizado
            setTimeout(function() {
                // Ler DIFERENÇA do campo diferença
                const diferenca = parseFloat($row.find('.campo-diferenca').val() || 0);

                // Ler CASHBACK do campo cashback
                const cashback = parseFloat($row.find('.campo-cashback').val() || 0);

                // Calcular quantidade faltando: DIFERENÇA - CASHBACK
                const quantidadeFaltando = diferenca - cashback;

                // Formatar quantidade para exibir apenas números inteiros se for inteiro
                const quantidadeFormatada = quantidadeFaltando % 1 === 0 ? Math.round(
                    quantidadeFaltando) : quantidadeFaltando.toFixed(3);

                // Exibir SweetAlert2 informando quantos itens faltam comprar
                Swal.fire({
                    title: 'Itens faltando',
                    html: `Faltam comprar <strong>${quantidadeFormatada}</strong> garrafões.<br>Deseja popular o campo Compra com este valor?`,
                    icon: 'question',
                    showCancelButton: true,
                    confirmButtonText: 'Confirmar',
                    cancelButtonText: 'Cancelar',
                    confirmButtonColor: '#0ea5e9',
                    cancelButtonColor: '#6c757d'
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Popular campo Compra com DIFERENÇA - CASHBACK
                        const $campoCompra = $row.find('.campo-compra');
                        $campoCompra.val(quantidadeFaltando.toFixed(3));

                        // Se produto id = 2, Qtd Faturada recebe o mesmo valor de Compra
                        if (produtoId === 2) {
                            const $campoQtdFaturada = $row.find(
                                '.quantidade-input');
                            $campoQtdFaturada.val(Math.round(quantidadeFaltando));
                        }

                        atualizarResumo();
                    }
                    // Se cancelar, não fazer nada
                });
            }, 100);
        });

        // Para produto id = 2, atualizar Qtd Faturada quando Compra for alterada
        $(document).on('input change blur', '.campo-compra', function() {
            const $row = $(this).closest('tr');
            const produtoId = parseInt($row.data('produto-id') || 0);

            if (produtoId === 2) {
                const compra = parseFloat($(this).val() || 0);
                const $campoQtdFaturada = $row.find('.quantidade-input');
                $campoQtdFaturada.val(Math.round(compra));
                atualizarResumo();
            }
        });


        // Calcular cashback e falta_r ao carregar a página
        $('tr[data-produto-id]').each(function() {
            calcularCashbackFaltaR($(this));

            // Inicializar Qtd Faturada para produto id = 2
            const produtoId = parseInt($(this).data('produto-id') || 0);
            if (produtoId === 2) {
                const compra = parseFloat($(this).find('.campo-compra').val() || 0);
                $(this).find('.quantidade-input').val(Math.round(compra));
            }
        });

        inicializarAutocompleteCliente();

        // Cálculo de resumo
        const resumoItens = document.getElementById('resumo-itens');
        const resumoTotal = document.getElementById('resumo-total');
        const quantidadeInputs = document.querySelectorAll('.quantidade-input');

        function formatCurrency(value) {
            return value.toLocaleString('pt-BR', {
                style: 'currency',
                currency: 'BRL'
            });
        }

        function atualizarResumo() {
            let totalItens = 0;
            let totalValor = 0;

            document.querySelectorAll('tr[data-produto-id]').forEach(function(row) {
                const preco = parseFloat(row.dataset.preco || '0');
                const input = row.querySelector('.quantidade-input');
                const subtotalElement = row.querySelector('.subtotal-item');
                const quantidade = parseFloat(input.value || '0');

                const subtotal = preco * quantidade;
                subtotalElement.textContent = formatCurrency(subtotal);

                if (quantidade > 0) {
                    totalItens += quantidade;
                    totalValor += subtotal;
                }
            });

            resumoItens.textContent = totalItens.toLocaleString('pt-BR');
            resumoTotal.textContent = formatCurrency(totalValor);
        }

        quantidadeInputs.forEach(function(input) {
            input.addEventListener('input', atualizarResumo);
            input.addEventListener('change', atualizarResumo);
        });

        atualizarResumo();

        // Validação do formulário
        document.getElementById('form-orcamento').addEventListener('submit', function(event) {
            if (!$('#customer_id').val()) {
                event.preventDefault();
                Swal.fire({
                    icon: 'warning',
                    title: 'Cliente obrigatório',
                    text: 'Selecione um cliente válido antes de salvar o orçamento.'
                });
                return;
            }

            const algumItemSelecionado = Array.from(quantidadeInputs).some(function(input) {
                return parseFloat(input.value || '0') > 0;
            });

            if (!algumItemSelecionado) {
                event.preventDefault();
                Swal.fire({
                    icon: 'warning',
                    title: 'Itens obrigatórios',
                    text: 'Informe ao menos um produto com quantidade maior que zero.'
                });
                return;
            }

            // Se estiver em triagem, validar campos de triagem
            if (isTriagem) {
                const $btn = $(this).find('button[type="submit"]');
                $btn.prop('disabled', true).html(
                    '<span class="spinner-border spinner-border-sm me-2"></span>Salvando...');

                // Enviar via AJAX
                event.preventDefault();

                const formData = $(this).serialize();

                $.ajax({
                    url: $(this).attr('action'),
                    type: 'POST',
                    data: formData,
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Sucesso!',
                                text: response.message ||
                                    'Triagem salva com sucesso',
                                timer: 1500,
                                showConfirmButton: false
                            }).then(() => {
                                window.location.href = response.redirect ||
                                    '<?= url('/orcamentos-agua') ?>';
                            });
                        } else {
                            $btn.prop('disabled', false).html(
                                '<i class="bi bi-check-circle me-2"></i>Salvar Triagem'
                            );
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro',
                                text: response.message ||
                                    'Erro ao salvar triagem'
                            });
                        }
                    },
                    error: function(xhr) {
                        $btn.prop('disabled', false).html(
                            '<i class="bi bi-check-circle me-2"></i>Salvar Triagem');
                        const response = xhr.responseJSON || {};
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro',
                            text: response.message || 'Erro ao salvar triagem'
                        });
                    }
                });
            }
        });
    });

})(jQuery);
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'orcamentos-agua';
include __DIR__ . '/../layouts/app.php';
?>