<?php
ob_start();

$clientes = $clientes ?? [];
$produtos = $produtos ?? [];
$proximoNumero = $proximoNumero ?? 'OAM-000001';
$user = $user ?? [];
$userName = $user['name'] ?? 'Responsável não identificado';
$userId = $user['id'] ?? null;
$userRole = strtolower(trim($userRole ?? ''));
$isOperator = ($userRole === 'operator' || $userRole === 'operador');
$isTriagemRole = ($userRole === 'triagem');

?>

<style>
.orcamento-form-card {
    border-radius: 16px;
    border: 1px solid rgba(15, 23, 42, 0.08);
    box-shadow: 0 10px 24px rgba(15, 23, 42, 0.08);
}

.orcamento-section-title {
    font-size: 0.85rem;
    font-weight: 700;
    letter-spacing: 0.08em;
    text-transform: uppercase;
    color: #64748b;
}

.produto-quantidade input[type="number"] {
    max-width: 120px;
}

.resumo-card {
    border-radius: 14px;
    background: #0ea5e9;
    color: #fff;
}

.autocomplete-dropdown {
    position: absolute;
    top: 100%;
    left: 0;
    right: 0;
    background: var(--bs-body-bg, #fff);
    border: 1px solid var(--bs-border-color, #dee2e6);
    border-radius: 0.375rem;
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
    max-height: 400px;
    overflow-y: auto;
    z-index: 1000;
    margin-top: 0.25rem;
}

.autocomplete-item {
    padding: 0.875rem 1rem;
    cursor: pointer;
    border-bottom: 1px solid var(--bs-border-color, #f0f0f0);
    transition: all 0.15s ease-in-out;
    line-height: 1.5;
}

.autocomplete-item:hover,
.autocomplete-item.active {
    background-color: var(--bs-primary, #0d6efd);
    color: white;
    transform: translateX(3px);
}

.autocomplete-item:hover .text-muted {
    color: rgba(255, 255, 255, 0.8) !important;
}

.autocomplete-item:last-child {
    border-bottom: none;
}

.autocomplete-item .mb-1 {
    margin-bottom: 0.375rem;
}

.autocomplete-item strong {
    font-weight: 600;
}

.autocomplete-no-results {
    padding: 1rem;
    text-align: center;
    color: var(--bs-secondary, #6c757d);
}
</style>

<form method="POST" action="<?= url('/orcamentos-agua/criar') ?>" id="form-orcamento">
    <div class="card orcamento-form-card mb-4">
        <div class="card-header bg-light d-flex justify-content-between align-items-center">
            <div>
                <h5 class="mb-1"><i class="bi bi-droplet me-2"></i>Novo Orçamento de Água Mineral</h5>
                <small class="text-muted">Número provisório: <strong><?= htmlspecialchars($proximoNumero) ?></strong></small>
            </div>
            <a href="<?= url('/orcamentos-agua') ?>" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-2"></i>Voltar
            </a>
        </div>
        <div class="card-body">
            <div class="row g-4">
                <div class="col-md-6">
                    <span class="orcamento-section-title d-block mb-2">Responsável</span>
                    <div class="card border-0 bg-slate-50">
                        <div class="card-body py-3">
                            <strong><?= htmlspecialchars($userName) ?></strong>
                            <input type="hidden" name="vendor_id" value="<?= htmlspecialchars((string) $userId) ?>">
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <span class="orcamento-section-title d-block mb-2">Data do Orçamento</span>
                    <input type="date" class="form-control" name="sale_date" value="<?= date('Y-m-d') ?>" readonly>
                </div>
                <?php if (!empty($profissionais ?? [])): ?>
                <div class="col-md-6">
                    <span class="orcamento-section-title d-block mb-2">Profissional</span>
                    <select class="form-select" name="profissional_id" id="profissional_id">
                        <option value="">Selecione um profissional...</option>
                        <?php foreach ($profissionais as $prof): ?>
                        <option value="<?= $prof['id'] ?>"><?= htmlspecialchars($prof['name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <?php endif; ?>
                <div class="col-12">
                    <span class="orcamento-section-title d-block mb-2">Cliente</span>
                    <div class="position-relative">
                        <input type="text" class="form-control" id="cliente_busca"
                            placeholder="Digite nome, razão social ou CNPJ/CPF do cliente..." autocomplete="off">
                        <div id="cliente_dropdown" class="autocomplete-dropdown" style="display: none;"></div>
                    </div>
                    <input type="hidden" name="customer_id" id="customer_id">
                    <div class="mt-2" id="cliente_info" style="display: none;">
                        <div class="alert alert-info mb-0">
                            <div class="d-flex justify-content-between align-items-start">
                                <div class="flex-grow-1" id="cliente_info_name"></div>
                                <button type="button" class="btn btn-sm btn-outline-danger ms-2" onclick="limparCliente()">
                                    <i class="bi bi-x"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card orcamento-form-card mb-4">
        <div class="card-header bg-light">
            <h6 class="mb-0"><i class="bi bi-basket me-2"></i>Produtos disponíveis</h6>
        </div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table align-middle mb-0">
                    <thead class="table-light">
                        <tr>
                            <th>Produto</th>
                            <?php if (!$isOperator && !$isTriagemRole): ?>
                            <th class="text-center">SKU</th>
                            <th class="text-end">Preço Unitário</th>
                            <?php endif; ?>
                            <?php if (!$isTriagemRole): ?>
                            <th class="text-center" style="width: 120px;">Qtd Informada</th>
                            <?php endif; ?>
                            <?php if (!$isOperator): ?>
                            <th class="text-center" style="width: 120px;">Qtd Conferida</th>
                            <th class="text-center" style="width: 120px;">Diferença</th>
                            <th class="text-center" style="width: 120px;">Troca</th>
                            <th class="text-center" style="width: 120px;">Quebra</th>
                            <th class="text-center" style="width: 120px;">Cashback</th>
                            <th class="text-center" style="width: 120px;">Qtd Faturada</th>
                            <?php endif; ?>
                            <?php if (!$isOperator && !$isTriagemRole): ?>
                            <!-- <th class="text-center" style="width: 120px;">P/ +1 Faltam R$</th> -->
                            <th class="text-end">Subtotal</th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($produtos as $produto): ?>
                            <?php
                            $produtoId = (int) $produto['id'];
                            $preco = (float) ($produto['price'] ?? 0);
                            $produtoCashback = (float) ($produto['cashback'] ?? 0);
                            $lancarQuebra = ($produto['lancar_quebra'] ?? 'Sim');
                            $lancarTroca = ($produto['lancar_troca'] ?? 'Sim');
                            $podeLancarQuebra = ($lancarQuebra === 'Sim' || $lancarQuebra === 'S' || $lancarQuebra === 1 || $lancarQuebra === true);
                            $podeLancarTroca = ($lancarTroca === 'Sim' || $lancarTroca === 'S' || $lancarTroca === 1 || $lancarTroca === true);
                            ?>
                            <tr data-produto-id="<?= $produtoId ?>" data-preco="<?= number_format($preco, 2, '.', '') ?>" data-produto-cashback="<?= number_format($produtoCashback, 0, '.', '') ?>">
                                <td>
                                    <strong><?= htmlspecialchars($produto['name']) ?></strong>
                                </td>
                                <?php if (!$isOperator && !$isTriagemRole): ?>
                                <td class="text-center"><?= htmlspecialchars($produto['sku'] ?? '—') ?></td>
                                <td class="text-end">R$ <?= number_format($preco, 2, ',', '.') ?></td>
                                <?php endif; ?>
                                <?php if (!$isTriagemRole): ?>
                                <td class="text-center">
                                    <input type="number" class="form-control form-control-sm text-center campo-qtd-informada"
                                        name="itens[<?= $produtoId ?>][qtd_informada]"
                                        value="0"
                                        min="0" step="0.001" style="width: 100px;">
                                </td>
                                <?php endif; ?>
                                <?php if (!$isOperator): ?>
                                <td class="text-center">
                                    <input type="number" class="form-control form-control-sm text-center campo-conferido"
                                        name="itens[<?= $produtoId ?>][conferido]"
                                        value="0"
                                        min="0" step="0.001" style="width: 100px;">
                                </td>
                                <td class="text-center">
                                    <input type="number" class="form-control form-control-sm text-center campo-diferenca"
                                        name="itens[<?= $produtoId ?>][diferenca]"
                                        value="0"
                                        min="0" step="0.001" style="width: 100px;"
                                        readonly>
                                </td>
                                <td class="text-center">
                                    <input type="number" class="form-control form-control-sm text-center campo-troca"
                                        name="itens[<?= $produtoId ?>][troca]"
                                        value="0"
                                        min="0" step="0.001" style="width: 100px;"
                                        <?= !$podeLancarTroca ? 'readonly' : '' ?>>
                                </td>
                                <td class="text-center">
                                    <input type="number" class="form-control form-control-sm text-center campo-quebra"
                                        name="itens[<?= $produtoId ?>][quebra]"
                                        value="0"
                                        min="0" step="0.001" style="width: 100px;"
                                        <?= !$podeLancarQuebra ? 'readonly' : '' ?>>
                                </td>
                                <td class="text-center">
                                    <input type="number" class="form-control form-control-sm text-center campo-cashback"
                                        name="itens[<?= $produtoId ?>][cashback]"
                                        value="0"
                                        min="0" step="0.001" style="width: 100px;"
                                        readonly>
                                </td>
                                <td class="text-center produto-quantidade">
                                    <input type="number" class="form-control text-center quantidade-input"
                                        name="quantities[<?= $produtoId ?>]" min="0" step="1" value="0">
                                </td>
                                <?php endif; ?>
                                <?php if (!$isOperator && !$isTriagemRole): ?>
                                <!-- <td class="text-center">
                                    <input type="number" class="form-control form-control-sm text-center campo-falta-r"
                                        name="itens[<?= $produtoId ?>][falta_r]"
                                        value="0"
                                        min="0" step="0.01" style="width: 100px;"
                                        readonly>
                                </td> -->
                                <td class="text-end subtotal-item">R$ 0,00</td>
                                <?php endif; ?>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="row g-4 mb-4">
        <div class="col-lg-8">
            <div class="card orcamento-form-card">
                <div class="card-header bg-light">
                    <h6 class="mb-0"><i class="bi bi-sticky me-2"></i>Observações</h6>
                </div>
                <div class="card-body">
                    <textarea class="form-control" name="notes" rows="4"
                        placeholder="Informe observações relevantes (ex.: condições de entrega, forma de pagamento, etc.)"></textarea>
                </div>
            </div>
        </div>
        <div class="col-lg-4">
            <div class="card resumo-card border-0">
                <div class="card-body">
                    <h6 class="text-uppercase mb-3">Resumo do Orçamento</h6>
                    <div class="d-flex justify-content-between mb-2">
                        <span>Itens selecionados</span>
                        <strong id="resumo-itens">0</strong>
                    </div>
                    <div class="d-flex justify-content-between">
                        <span>Total estimado</span>
                        <strong id="resumo-total">R$ 0,00</strong>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="d-flex justify-content-end gap-2">
        <a href="<?= url('/orcamentos-agua') ?>" class="btn btn-outline-secondary">
            Cancelar
        </a>
        <button type="submit" class="btn btn-primary">
            <i class="bi bi-check-circle me-2"></i>Salvar Orçamento
        </button>
    </div>
</form>

<script>
(function($) {
    'use strict';

    const clientesData = <?= json_encode($clientes ?? []) ?>;
    let selectedCustomer = null;
    let autocompleteTimeout = null;

    // Inicializar autocomplete de cliente
    function inicializarAutocompleteCliente() {
        const $search = $('#cliente_busca');
        const $dropdown = $('#cliente_dropdown');

        // Ao digitar
        $search.on('input', function() {
            const query = $(this).val().trim().toLowerCase();

            clearTimeout(autocompleteTimeout);

            if (query.length < 2) {
                $dropdown.hide();
                return;
            }

            autocompleteTimeout = setTimeout(() => {
                buscarClientes(query);
            }, 300);
        });

        // Ao clicar fora, fechar dropdown
        $(document).on('click', function(e) {
            if (!$(e.target).closest('#cliente_busca, #cliente_dropdown').length) {
                $dropdown.hide();
            }
        });

        // Ao focar no campo
        $search.on('focus', function() {
            if ($(this).val().length >= 2) {
                buscarClientes($(this).val().trim().toLowerCase());
            }
        });

        // Ao pressionar Enter, apenas prevenir submit
        $search.on('keydown', function(e) {
            if (e.key === 'Enter') {
                e.preventDefault();
            }
        });
    }

    function buscarClientes(query) {
        const $dropdown = $('#cliente_dropdown');

        // Filtrar clientes
        const results = clientesData.filter(cliente => {
            const name = (cliente.name || '').toLowerCase();
            const tradeName = (cliente.trade_name || '').toLowerCase();
            const document = (cliente.document || '').toLowerCase();
            const email = (cliente.email || '').toLowerCase();
            const phone = (cliente.phone || '').toLowerCase();
            const mobile = (cliente.mobile || '').toLowerCase();

            // Normalizar query e documento para busca mais flexível
            const normalizedQuery = query.replace(/[^\d\w]/g, '').toLowerCase();
            const normalizedDocument = document.replace(/[^\d\w]/g, '').toLowerCase();

            return name.includes(query) || tradeName.includes(query) ||
                document.includes(query) || normalizedDocument.includes(normalizedQuery) ||
                email.includes(query) || phone.includes(query) || mobile.includes(query);
        });

        // Montar HTML
        let html = '';

        if (results.length > 0) {
            results.forEach(cliente => {
                const nomeFantasia = cliente.trade_name || '-';
                const razaoSocial = cliente.name || '-';
                const documento = cliente.document || 'Não informado';
                const codigo = String(cliente.id).padStart(4, '0');
                const telefone = cliente.phone || cliente.mobile || '-';
                const email = cliente.email || '-';

                html += `
                    <div class="autocomplete-item" data-id="${cliente.id}">
                        <div class="mb-1">
                            <strong>Código: ${codigo}</strong>  |  <strong>CNPJ/CPF:</strong> ${documento}
                        </div>
                        <div class="mb-1">
                            <strong>Razão Social:</strong> ${razaoSocial}  |  <strong>Fantasia:</strong> ${nomeFantasia}
                        </div>
                        <div class="text-muted small">
                            <strong>Fone:</strong> ${telefone}  |  <strong>Email:</strong> ${email}
                        </div>
                    </div>
                `;
            });
        } else {
            html = '<div class="autocomplete-no-results">Nenhum cliente encontrado</div>';
        }

        $dropdown.html(html).show();

        // Event listeners
        $dropdown.find('.autocomplete-item').on('click', function() {
            const clienteId = $(this).data('id');
            const cliente = clientesData.find(c => c.id == clienteId);
            if (cliente) {
                selecionarCliente(cliente);
            }
        });
    }

    function selecionarCliente(cliente) {
        selectedCustomer = cliente;

        const nomeFantasia = cliente.trade_name || '-';
        const razaoSocial = cliente.name || '-';
        const nomeExibir = nomeFantasia !== '-' ? nomeFantasia : razaoSocial;
        const codigo = String(cliente.id).padStart(4, '0');
        const documento = cliente.document || 'Não informado';
        const telefone = cliente.phone || cliente.mobile || '-';
        const email = cliente.email || '-';

        // Preencher campo hidden
        $('#customer_id').val(cliente.id);

        // Atualizar campo de busca
        $('#cliente_busca').val(nomeExibir);

        // Mostrar info do cliente no formato estruturado
        let infoHtml = `
            <div style="line-height: 1.6;">
                <div class="mb-1">
                    <strong>Código: ${codigo}</strong>  |  ${documento}
                </div>
                <div class="mb-1">
                    <strong>Razão Social:</strong> ${razaoSocial}  |  <strong>Fantasia:</strong> ${nomeFantasia}
                </div>
                <div class="text-muted small">
                    <strong>Fone:</strong> ${telefone}  |  <strong>Email:</strong> ${email}
                </div>
            </div>
        `;

        $('#cliente_info_name').html(infoHtml);
        $('#cliente_info').slideDown();

        // Fechar dropdown
        $('#cliente_dropdown').hide();
    }

    window.limparCliente = function() {
        selectedCustomer = null;

        $('#customer_id').val('');
        $('#cliente_busca').val('');
        $('#cliente_info').slideUp();
    };

    // Inicializar quando o DOM estiver pronto
    $(document).ready(function() {
        // Calcular diferença automaticamente quando conferido for alterado
        $(document).on('input change', '.campo-conferido', function() {
            const $row = $(this).closest('tr');
            const qtdInformada = parseFloat($row.find('.campo-qtd-informada').val() || 0);
            const conferido = parseFloat($(this).val() || 0);
            const diferenca = qtdInformada - conferido;

            $row.find('.campo-diferenca').val(diferenca.toFixed(3));

            // Validar: se quebra for maior que a nova diferença, ajustar
            const quebra = parseFloat($row.find('.campo-quebra').val() || 0);
            if (quebra > diferenca) {
                $row.find('.campo-quebra').val(diferenca.toFixed(3));
                calcularCashbackFaltaR($row);
            }
        });

        // Calcular diferença quando qtd_informada for alterada
        $(document).on('input change', '.campo-qtd-informada', function() {
            const $row = $(this).closest('tr');
            const qtdInformada = parseFloat($(this).val() || 0);
            const conferido = parseFloat($row.find('.campo-conferido').val() || 0);
            const diferenca = qtdInformada - conferido;

            $row.find('.campo-diferenca').val(diferenca.toFixed(3));

            // Validar: se quebra for maior que a nova diferença, ajustar
            const quebra = parseFloat($row.find('.campo-quebra').val() || 0);
            if (quebra > diferenca) {
                $row.find('.campo-quebra').val(diferenca.toFixed(3));
                calcularCashbackFaltaR($row);
            }
        });

        // Função para calcular cashback e falta_r baseado em quebra e produto.cashback
        function calcularCashbackFaltaR($row) {
            const quebra = parseFloat($row.find('.campo-quebra').val() || 0);
            const produtoCashback = parseFloat($row.data('produto-cashback') || 0);
            const preco = parseFloat($row.data('preco') || 0);

            if (produtoCashback > 0 && quebra > 0) {
                // Calcular quantos cashbacks completos: floor(quebra / produtoCashback)
                const cashbackCalculado = Math.floor(quebra / produtoCashback);

                // Calcular o resto da divisão (diferença não múltipla do cashback)
                const resto = quebra % produtoCashback;

                // Calcular falta_r: (resto / fator_cashback) * preço_unitário
                const faltaR = resto > 0 ? (resto / produtoCashback) * preco : 0;

                $row.find('.campo-cashback').val(cashbackCalculado.toFixed(3));
                $row.find('.campo-falta-r').val(faltaR.toFixed(2));
            } else {
                $row.find('.campo-cashback').val('0.000');
                $row.find('.campo-falta-r').val('0.00');
            }
        }

        // Calcular cashback e falta_r quando quebra for alterada
        $(document).on('input change', '.campo-quebra', function() {
            const $row = $(this).closest('tr');
            const quebra = parseFloat($(this).val() || 0);
            const diferenca = parseFloat($row.find('.campo-diferenca').val() || 0);

            // Validar: quebra não pode ser maior que diferença
            if (quebra > diferenca) {
                $(this).val(diferenca.toFixed(3));
                alert('A quebra não pode ser maior que a diferença!');
            }

            calcularCashbackFaltaR($row);
        });

        // Calcular cashback e falta_r ao carregar a página
        $('tr[data-produto-id]').each(function() {
            calcularCashbackFaltaR($(this));
        });

        inicializarAutocompleteCliente();

        // Cálculo de resumo
        const resumoItens = document.getElementById('resumo-itens');
        const resumoTotal = document.getElementById('resumo-total');
        const quantidadeInputs = document.querySelectorAll('.quantidade-input');

        function formatCurrency(value) {
            return value.toLocaleString('pt-BR', {
                style: 'currency',
                currency: 'BRL'
            });
        }

        function atualizarResumo() {
            let totalItens = 0;
            let totalValor = 0;

            document.querySelectorAll('tr[data-produto-id]').forEach(function(row) {
                const preco = parseFloat(row.dataset.preco || '0');
                const input = row.querySelector('.quantidade-input');
                const subtotalElement = row.querySelector('.subtotal-item');
                const quantidade = parseFloat(input.value || '0');

                const subtotal = preco * quantidade;
                subtotalElement.textContent = formatCurrency(subtotal);

                if (quantidade > 0) {
                    totalItens += quantidade;
                    totalValor += subtotal;
                }
            });

            resumoItens.textContent = totalItens.toLocaleString('pt-BR');
            resumoTotal.textContent = formatCurrency(totalValor);
        }

        quantidadeInputs.forEach(function(input) {
            input.addEventListener('input', atualizarResumo);
            input.addEventListener('change', atualizarResumo);
        });

        atualizarResumo();

        // Validação do formulário
        document.getElementById('form-orcamento').addEventListener('submit', function(event) {
            if (!$('#customer_id').val()) {
                event.preventDefault();
                Swal.fire({
                    icon: 'warning',
                    title: 'Cliente obrigatório',
                    text: 'Selecione um cliente válido antes de salvar o orçamento.'
                });
                return;
            }

            const algumItemSelecionado = Array.from(quantidadeInputs).some(function(input) {
                return parseFloat(input.value || '0') > 0;
            });

            if (!algumItemSelecionado) {
                event.preventDefault();
                Swal.fire({
                    icon: 'warning',
                    title: 'Itens obrigatórios',
                    text: 'Informe ao menos um produto com quantidade maior que zero.'
                });
            }
        });
    });

})(jQuery);
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'orcamentos-agua';
include __DIR__ . '/../layouts/app.php';

