<?php
ob_start();

$status = $status ?? [];
?>

<div class="row mb-4">
    <div class="col-md-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?= url('/gestao/status') ?>">Gestão de Status</a></li>
                <li class="breadcrumb-item active">Editar Status</li>
            </ol>
        </nav>
        <h2><i class="bi bi-pencil-square me-2"></i> Editar Status</h2>
        <p class="text-muted mb-0">Atualize os comportamentos e a identidade visual deste status.</p>
    </div>
</div>

<form id="formStatus">
    <input type="hidden" name="id" value="<?= (int) ($status['id'] ?? 0) ?>">

    <div class="row">
        <div class="col-xl-8">
            <div class="card shadow-sm mb-4">
                <div class="card-header">
                    <i class="bi bi-info-circle me-2"></i> Informações Principais
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Módulo</label>
                            <input type="text"
                                   class="form-control"
                                   value="<?= htmlspecialchars($status['modulo'] ?? '-') ?>"
                                   readonly>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Código</label>
                            <input type="text"
                                   class="form-control"
                                   value="<?= htmlspecialchars($status['codigo'] ?? '-') ?>"
                                   readonly>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="ordem" class="form-label">Ordem</label>
                            <input type="number"
                                   class="form-control"
                                   id="ordem"
                                   name="ordem"
                                   min="0"
                                   value="<?= htmlspecialchars((string) ($status['ordem'] ?? 0)) ?>">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="nome" class="form-label">Nome *</label>
                            <input type="text"
                                   class="form-control"
                                   id="nome"
                                   name="nome"
                                   value="<?= htmlspecialchars($status['nome'] ?? '') ?>"
                                   required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="icone" class="form-label">Ícone *</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="<?= htmlspecialchars($status['icone'] ?? 'bi bi-flag') ?>"></i></span>
                                <input type="text"
                                       class="form-control"
                                       id="icone"
                                       name="icone"
                                       placeholder="Ex: bi bi-flag"
                                       value="<?= htmlspecialchars($status['icone'] ?? '') ?>"
                                       required>
                            </div>
                            <small class="text-muted">Use classes do Bootstrap Icons</small>
                        </div>
                        <div class="col-md-12 mb-3">
                            <label for="descricao" class="form-label">Descrição</label>
                            <textarea class="form-control"
                                      id="descricao"
                                      name="descricao"
                                      rows="3"
                                      placeholder="Observações ou orientações sobre o uso deste status"><?= htmlspecialchars($status['descricao'] ?? '') ?></textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-4">
            <div class="card shadow-sm mb-4">
                <div class="card-header">
                    <i class="bi bi-palette me-2"></i> Aparência
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="cor" class="form-label">Cor *</label>
                        <input type="text"
                               class="form-control"
                               id="cor"
                               name="cor"
                               placeholder="#0d6efd"
                               value="<?= htmlspecialchars($status['cor'] ?? '#0d6efd') ?>"
                               required>
                        <small class="text-muted">Informe um código hexadecimal (ex: #0d6efd)</small>
                    </div>
                    <div class="status-preview p-3 rounded border text-center" style="background: <?= htmlspecialchars($status['cor'] ?? '#0d6efd') ?>15;">
                        <div class="mb-2">
                            <i class="<?= htmlspecialchars($status['icone'] ?? 'bi bi-flag') ?>" style="font-size: 1.5rem;"></i>
                        </div>
                        <div class="fw-semibold"><?= htmlspecialchars($status['nome'] ?? '-') ?></div>
                        <small class="text-muted">Pré-visualização</small>
                    </div>
                </div>
            </div>

            <div class="card shadow-sm mb-4">
                <div class="card-header">
                    <i class="bi bi-gear-wide-connected me-2"></i> Comportamentos
                </div>
                <div class="card-body">
                    <div class="form-check form-switch mb-3">
                        <input class="form-check-input" type="checkbox" id="gera_financeiro" name="gera_financeiro" value="1" <?= ($status['gera_financeiro'] ?? 0) ? 'checked' : '' ?>>
                        <label class="form-check-label" for="gera_financeiro">Gera movimentação financeira</label>
                    </div>
                    <div class="form-check form-switch mb-3">
                        <input class="form-check-input" type="checkbox" id="movimenta_estoque" name="movimenta_estoque" value="1" <?= ($status['movimenta_estoque'] ?? 0) ? 'checked' : '' ?>>
                        <label class="form-check-label" for="movimenta_estoque">Movimenta estoque</label>
                    </div>
                    <div class="form-check form-switch mb-3">
                        <input class="form-check-input" type="checkbox" id="reserva_estoque" name="reserva_estoque" value="1" <?= ($status['reserva_estoque'] ?? 0) ? 'checked' : '' ?>>
                        <label class="form-check-label" for="reserva_estoque">Reserva estoque</label>
                    </div>
                    <div class="form-check form-switch mb-3">
                        <input class="form-check-input" type="checkbox" id="previsao_estoque" name="previsao_estoque" value="1" <?= ($status['previsao_estoque'] ?? 0) ? 'checked' : '' ?>>
                        <label class="form-check-label" for="previsao_estoque">Considera em previsão de estoque</label>
                    </div>
                    <div class="form-check form-switch mb-3">
                        <input class="form-check-input" type="checkbox" id="emite_nfe" name="emite_nfe" value="1" <?= ($status['emite_nfe'] ?? 0) ? 'checked' : '' ?>>
                        <label class="form-check-label" for="emite_nfe">Permite emissão de NF-e</label>
                    </div>
                </div>
            </div>

            <div class="card shadow-sm">
                <div class="card-header">
                    <i class="bi bi-toggle-on me-2"></i> Regras
                </div>
                <div class="card-body">
                    <div class="form-check form-switch mb-3">
                        <input class="form-check-input" type="checkbox" id="is_default" name="is_default" value="1" <?= ($status['is_default'] ?? 0) ? 'checked' : '' ?>>
                        <label class="form-check-label" for="is_default">Status padrão</label>
                    </div>
                    <div class="form-check form-switch mb-3">
                        <input class="form-check-input" type="checkbox" id="is_final" name="is_final" value="1" <?= ($status['is_final'] ?? 0) ? 'checked' : '' ?>>
                        <label class="form-check-label" for="is_final">Status finalizador</label>
                    </div>
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="ativo" name="ativo" value="1" <?= ($status['ativo'] ?? 0) ? 'checked' : '' ?>>
                        <label class="form-check-label" for="ativo">Status ativo</label>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="d-flex justify-content-between mt-4">
        <a href="<?= url('/gestao/status') ?>" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left me-2"></i> Voltar para a listagem
        </a>
        <button type="submit" class="btn btn-primary">
            <i class="bi bi-save me-2"></i> Salvar alterações
        </button>
    </div>
</form>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('formStatus');
    const corInput = document.getElementById('cor');
    const preview = document.querySelector('.status-preview');
    const nomeInput = document.getElementById('nome');
    const iconeInput = document.getElementById('icone');

    const atualizaPreview = () => {
        if (preview) {
            preview.style.background = (corInput.value || '#0d6efd') + '15';
            preview.querySelector('i').className = iconeInput.value || 'bi bi-flag';
            preview.querySelector('.fw-semibold').textContent = nomeInput.value || 'Status';
        }
    };

    if (corInput) {
        corInput.addEventListener('input', atualizaPreview);
    }

    if (nomeInput) {
        nomeInput.addEventListener('input', atualizaPreview);
    }

    if (iconeInput) {
        iconeInput.addEventListener('input', atualizaPreview);
    }

    if (form) {
        form.addEventListener('submit', function(event) {
            event.preventDefault();

            const formData = new FormData(form);
            formData.set('gera_financeiro', form.querySelector('#gera_financeiro').checked ? '1' : '0');
            formData.set('movimenta_estoque', form.querySelector('#movimenta_estoque').checked ? '1' : '0');
            formData.set('reserva_estoque', form.querySelector('#reserva_estoque').checked ? '1' : '0');
            formData.set('previsao_estoque', form.querySelector('#previsao_estoque').checked ? '1' : '0');
            formData.set('emite_nfe', form.querySelector('#emite_nfe').checked ? '1' : '0');
            formData.set('is_default', form.querySelector('#is_default').checked ? '1' : '0');
            formData.set('is_final', form.querySelector('#is_final').checked ? '1' : '0');
            formData.set('ativo', form.querySelector('#ativo').checked ? '1' : '0');

            fetch(appUrl('/gestao/status/editar'), {
                method: 'POST',
                body: formData,
            })
            .then(response => response.json())
            .then(result => {
                if (result?.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Sucesso',
                        text: result.message || 'Status atualizado com sucesso!',
                        confirmButtonText: 'OK'
                    }).then(() => {
                        window.location.href = appUrl(result.data?.redirect || '/gestao/status');
                    });
                } else {
                    const errorMsg = result?.message || 'Erro ao salvar o status.';
                    const details = result?.errors ? Object.values(result.errors).join('\\n') : '';

                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: errorMsg + (details ? '\\n' + details : '')
                    });
                }
            })
            .catch(error => {
                console.error('Erro ao atualizar status:', error);
                Swal.fire({
                    icon: 'error',
                    title: 'Erro inesperado',
                    text: 'Não foi possível salvar o status. Tente novamente.'
                });
            });
        });
    }

    atualizaPreview();
});
</script>

<?php
$content = ob_get_clean();
include \ROOT_PATH . '/views/layouts/app.php';

