<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-file-earmark-text me-2"></i> Modelos PMOC</h2>
        <p class="text-muted">Gerencie os perfis de PMOC que serão usados nas ordens de serviço</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/ordem-servico-pmoc') ?>" class="btn btn-outline-secondary me-2">
            <i class="bi bi-arrow-left me-2"></i> Voltar
        </a>
        <a href="<?= url('/modelos-pmoc/criar') ?>" class="btn btn-primary">
            <i class="bi bi-plus-circle me-2"></i> Novo Modelo PMOC
        </a>
    </div>
</div>

<!-- Listagem -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span><i class="bi bi-list-ul me-2"></i> Lista de Modelos PMOC</span>
        <span class="badge bg-primary"><?= count($modelos ?? []) ?> registro(s)</span>
    </div>
    <div class="card-body p-0">
        <?php if (!empty($modelos)): ?>
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th width="60">ID</th>
                            <th>Nome</th>
                            <th>Tipo de Equipamento</th>
                            <th>Descrição</th>
                            <th>Status</th>
                            <th width="150">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($modelos as $modelo): ?>
                            <tr>
                                <td><?= $modelo['id'] ?></td>
                                <td><strong><?= htmlspecialchars($modelo['nome']) ?></strong></td>
                                <td>
                                    <?php if (!empty($modelo['tipo_equipamento'])): ?>
                                        <span class="badge bg-info"><?= htmlspecialchars($modelo['tipo_equipamento']) ?></span>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td><?= htmlspecialchars($modelo['descricao'] ?? '-') ?></td>
                                <td>
                                    <span class="badge bg-<?= $modelo['is_active'] ? 'success' : 'danger' ?>">
                                        <?= $modelo['is_active'] ? 'Ativo' : 'Inativo' ?>
                                    </span>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <a href="<?= url('/modelos-pmoc/editar?id=' . $modelo['id']) ?>"
                                            class="btn btn-outline-primary" title="Editar">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        <button class="btn btn-outline-danger" onclick="deletarModelo(<?= $modelo['id'] ?>)" title="Excluir">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-file-earmark-text" style="font-size: 4rem; color: var(--text-secondary);"></i>
                <p class="text-muted mt-3">Nenhum modelo PMOC cadastrado</p>
                <a href="<?= url('/modelos-pmoc/criar') ?>" class="btn btn-primary mt-2">
                    <i class="bi bi-plus-circle me-2"></i> Cadastrar Primeiro Modelo PMOC
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
    async function deletarModelo(id) {
        const confirmed = await confirmDelete('Tem certeza que deseja excluir este modelo PMOC?');
        if (confirmed) {
            $.ajax({
                url: appUrl('/modelos-pmoc/deletar'),
                type: 'POST',
                data: {
                    id: id
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        Toast.success(response.message);
                        setTimeout(() => location.reload(), 1500);
                    } else {
                        Toast.error(response.message);
                    }
                }
            });
        }
    }
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'ordem-servico-pmoc';
include ROOT_PATH . '/views/layouts/app.php';
?>