<?php
$isEdit = $isEdit ?? false;
$modelo = $modelo ?? [];
$servicos = $servicos ?? [];
$servicosDisponiveis = $servicosDisponiveis ?? [];
$errors = $errors ?? [];
?>

<form id="formModeloPmoc" method="POST" action="<?= url($isEdit ? '/modelos-pmoc/editar' : '/modelos-pmoc/criar') ?>">
    <?php if ($isEdit): ?>
        <input type="hidden" name="id" value="<?= $modelo['id'] ?? '' ?>">
    <?php endif; ?>

    <?php if (!empty($errors)): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php foreach ($errors as $error): ?>
                    <li><?= htmlspecialchars($error) ?></li>
                <?php endforeach; ?>
            </ul>
        </div>
    <?php endif; ?>

    <div class="card">
        <div class="card-header">
            <i class="bi bi-info-circle me-2"></i> Informações do Modelo PMOC
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-12 mb-3">
                    <label for="nome" class="form-label">Nome do Modelo *</label>
                    <input type="text" class="form-control" id="nome" name="nome" required
                        value="<?= htmlspecialchars($modelo['nome'] ?? '') ?>"
                        placeholder="Ex: PMOC Padrão, PMOC Residencial, PMOC Comercial">
                    <small class="text-muted">Nome identificador do perfil de PMOC</small>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12 mb-3">
                    <label for="tipo_equipamento" class="form-label">Tipo de Equipamento</label>
                    <select class="form-select" id="tipo_equipamento" name="tipo_equipamento">
                        <option value="">Selecione o tipo de equipamento</option>
                        <option value="Split Hi-Wall" <?= (isset($modelo['tipo_equipamento']) && $modelo['tipo_equipamento'] === 'Split Hi-Wall') ? 'selected' : '' ?>>Split Hi-Wall</option>
                        <option value="Split Cassete" <?= (isset($modelo['tipo_equipamento']) && $modelo['tipo_equipamento'] === 'Split Cassete') ? 'selected' : '' ?>>Split Cassete</option>
                        <option value="Split Piso-Teto" <?= (isset($modelo['tipo_equipamento']) && $modelo['tipo_equipamento'] === 'Split Piso-Teto') ? 'selected' : '' ?>>Split Piso-Teto</option>
                        <option value="Multi Split" <?= (isset($modelo['tipo_equipamento']) && $modelo['tipo_equipamento'] === 'Multi Split') ? 'selected' : '' ?>>Multi Split</option>
                        <option value="Ar Condicionado de Janela" <?= (isset($modelo['tipo_equipamento']) && $modelo['tipo_equipamento'] === 'Ar Condicionado de Janela') ? 'selected' : '' ?>>Ar Condicionado de Janela (ACJ)</option>
                        <option value="Ar Condicionado Portátil" <?= (isset($modelo['tipo_equipamento']) && $modelo['tipo_equipamento'] === 'Ar Condicionado Portátil') ? 'selected' : '' ?>>Ar Condicionado Portátil</option>
                        <option value="Sistema VRF" <?= (isset($modelo['tipo_equipamento']) && $modelo['tipo_equipamento'] === 'Sistema VRF') ? 'selected' : '' ?>>Sistema VRF (Fluxo de Refrigerante Variável)</option>
                        <option value="Chiller" <?= (isset($modelo['tipo_equipamento']) && $modelo['tipo_equipamento'] === 'Chiller') ? 'selected' : '' ?>>Chiller (Sistema Central de Água Gelada)</option>
                        <option value="Fan Coil" <?= (isset($modelo['tipo_equipamento']) && $modelo['tipo_equipamento'] === 'Fan Coil') ? 'selected' : '' ?>>Fan Coil</option>
                        <option value="Self Contained" <?= (isset($modelo['tipo_equipamento']) && $modelo['tipo_equipamento'] === 'Self Contained') ? 'selected' : '' ?>>Self Contained</option>
                    </select>
                    <small class="text-muted">Tipo de equipamento de ar condicionado para este modelo de PMOC</small>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12 mb-3">
                    <label for="descricao" class="form-label">Descrição</label>
                    <textarea class="form-control" id="descricao" name="descricao" rows="3"
                        placeholder="Descreva o propósito e características deste modelo PMOC"><?= htmlspecialchars($modelo['descricao'] ?? '') ?></textarea>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12 mb-3">
                    <label for="observacoes" class="form-label">Observações</label>
                    <textarea class="form-control" id="observacoes" name="observacoes" rows="4"
                        placeholder="Observações adicionais sobre este modelo"><?= htmlspecialchars($modelo['observacoes'] ?? '') ?></textarea>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12 mb-3">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1"
                            <?= (!isset($modelo['is_active']) || $modelo['is_active']) ? 'checked' : '' ?>>
                        <label class="form-check-label" for="is_active">
                            Modelo Ativo
                        </label>
                        <small class="text-muted d-block">Modelos inativos não aparecerão nas seleções</small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Seção de Serviços -->
    <div class="card mt-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <span><i class="bi bi-list-check me-2"></i> Serviços do Modelo PMOC</span>
            <button type="button" class="btn btn-sm btn-primary" onclick="adicionarServico()">
                <i class="bi bi-plus-circle me-1"></i> Adicionar Serviço
            </button>
        </div>
        <div class="card-body">
            <div id="servicos-container">
                <?php if (!empty($servicos)): ?>
                    <?php foreach ($servicos as $index => $servico): ?>
                        <div class="servico-item mb-3 p-3 border rounded" data-index="<?= $index ?>">
                            <div class="row">
                                <div class="col-md-5">
                                    <label class="form-label">Nome do Serviço *</label>
                                    <select class="form-select servico-select" name="servicos[<?= $index ?>][nome]" required onchange="atualizarDescricaoServico(this, <?= $index ?>)">
                                        <option value="">Selecione um serviço</option>
                                        <?php foreach ($servicosDisponiveis ?? [] as $servicoDisponivel): ?>
                                            <?php
                                            $isSelected = false;
                                            if (isset($servico['nome']) && $servico['nome'] === $servicoDisponivel['name']) {
                                                $isSelected = true;
                                            } elseif (isset($servico['product_id']) && $servico['product_id'] == $servicoDisponivel['id']) {
                                                $isSelected = true;
                                            }
                                            ?>
                                            <option value="<?= htmlspecialchars($servicoDisponivel['name']) ?>"
                                                data-descricao="<?= htmlspecialchars($servicoDisponivel['description'] ?? '') ?>"
                                                data-product-id="<?= $servicoDisponivel['id'] ?>"
                                                <?= $isSelected ? 'selected' : '' ?>>
                                                <?= htmlspecialchars($servicoDisponivel['name']) ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                    <input type="hidden" name="servicos[<?= $index ?>][product_id]" class="servico-product-id"
                                        value="<?= $servico['product_id'] ?? '' ?>">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label">Frequência</label>
                                    <select class="form-select servico-frequencia" name="servicos[<?= $index ?>][frequencia]">
                                        <option value="">Selecione</option>
                                        <option value="Mensal" <?= (isset($servico['frequencia']) && $servico['frequencia'] === 'Mensal') ? 'selected' : '' ?>>Mensal</option>
                                        <option value="Trimestral" <?= (isset($servico['frequencia']) && $servico['frequencia'] === 'Trimestral') ? 'selected' : '' ?>>Trimestral</option>
                                        <option value="Semestral" <?= (isset($servico['frequencia']) && $servico['frequencia'] === 'Semestral') ? 'selected' : '' ?>>Semestral</option>
                                        <option value="Anual" <?= (isset($servico['frequencia']) && $servico['frequencia'] === 'Anual') ? 'selected' : '' ?>>Anual</option>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">Descrição</label>
                                    <textarea class="form-control servico-descricao" name="servicos[<?= $index ?>][descricao]" rows="2"
                                        placeholder="Descrição detalhada do serviço"><?= htmlspecialchars($servico['descricao'] ?? '') ?></textarea>
                                </div>
                                <div class="col-md-12 mt-2">
                                    <button type="button" class="btn btn-sm btn-danger" onclick="removerServico(this)">
                                        <i class="bi bi-trash me-1"></i> Remover
                                    </button>
                                </div>
                            </div>
                            <?php if (isset($servico['id'])): ?>
                                <input type="hidden" name="servicos[<?= $index ?>][id]" value="<?= $servico['id'] ?>">
                            <?php endif; ?>
                            <input type="hidden" name="servicos[<?= $index ?>][ordem]" value="<?= $index ?>" class="servico-ordem">
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
            <?php if (empty($servicos)): ?>
                <div class="text-center py-4 text-muted" id="empty-services-message">
                    <i class="bi bi-list-check" style="font-size: 2rem;"></i>
                    <p class="mt-2">Nenhum serviço adicionado. Clique em "Adicionar Serviço" para começar.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Botões de Ação -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="d-flex justify-content-end gap-2">
                <a href="<?= url('/modelos-pmoc') ?>" class="btn btn-secondary">
                    <i class="bi bi-x-circle me-2"></i> Cancelar
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-check-circle me-2"></i> <?= $isEdit ? 'Atualizar' : 'Salvar' ?>
                </button>
            </div>
        </div>
    </div>
</form>

<script>
    document.getElementById('formModeloPmoc').addEventListener('submit', function(e) {
        e.preventDefault();

        const formData = new FormData(this);

        // Enviar requisição AJAX
        fetch(this.action, {
                method: 'POST',
                body: formData
            })
            .then(response => {
                // Verificar se é JSON ou HTML (redirect)
                const contentType = response.headers.get('content-type');
                if (contentType && contentType.includes('application/json')) {
                    return response.json();
                } else {
                    // Se não for JSON, redirecionar
                    window.location.href = response.url || '<?= url('/modelos-pmoc') ?>';
                    return null;
                }
            })
            .then(data => {
                if (!data) return; // Já foi redirecionado

                if (data.success) {
                    Toast.success(data.message);
                    setTimeout(() => {
                        window.location.href = '<?= url('/modelos-pmoc') ?>';
                    }, 1500);
                } else {
                    Toast.error(data.message || 'Erro ao salvar modelo PMOC');
                    // Se houver erros, recarregar página para mostrar validações
                    if (data.errors) {
                        setTimeout(() => location.reload(), 1000);
                    }
                }
            })
            .catch(error => {
                console.error('Erro:', error);
                Toast.error('Erro ao salvar modelo PMOC');
            });
    });

    let servicoIndex = <?= count($servicos ?? []) ?>;
    const servicosDisponiveisData = <?= json_encode($servicosDisponiveis ?? []) ?>;

    function adicionarServico() {
        const container = document.getElementById('servicos-container');
        const servicoDiv = document.createElement('div');
        servicoDiv.className = 'servico-item mb-3 p-3 border rounded';
        servicoDiv.setAttribute('data-index', servicoIndex);

        servicoDiv.innerHTML = `
            <div class="row">
                <div class="col-md-5">
                    <label class="form-label">Nome do Serviço *</label>
                    <select class="form-select servico-select" name="servicos[${servicoIndex}][nome]" required onchange="atualizarDescricaoServico(this, ${servicoIndex})">
                        <option value="">Selecione um serviço</option>
                    </select>
                    <input type="hidden" name="servicos[${servicoIndex}][product_id]" class="servico-product-id" value="">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Frequência</label>
                    <select class="form-select servico-frequencia" name="servicos[${servicoIndex}][frequencia]">
                        <option value="">Selecione</option>
                        <option value="Mensal">Mensal</option>
                        <option value="Trimestral">Trimestral</option>
                        <option value="Semestral">Semestral</option>
                        <option value="Anual">Anual</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Descrição</label>
                    <textarea class="form-control servico-descricao" name="servicos[${servicoIndex}][descricao]" rows="2"
                        placeholder="Descrição detalhada do serviço"></textarea>
                </div>
                <div class="col-md-12 mt-2">
                    <button type="button" class="btn btn-sm btn-danger" onclick="removerServico(this)">
                        <i class="bi bi-trash me-1"></i> Remover
                    </button>
                </div>
            </div>
            <input type="hidden" name="servicos[${servicoIndex}][ordem]" value="${servicoIndex}" class="servico-ordem">
        `;

        container.appendChild(servicoDiv);

        // Popular o select com serviços disponíveis
        const select = servicoDiv.querySelector('.servico-select');
        if (select && servicosDisponiveisData) {
            servicosDisponiveisData.forEach(servico => {
                const option = document.createElement('option');
                option.value = servico.name || '';
                option.textContent = servico.name || '';
                option.setAttribute('data-descricao', servico.description || '');
                option.setAttribute('data-product-id', servico.id || '');
                select.appendChild(option);
            });
        }

        // Remover mensagem de "nenhum serviço"
        const emptyMessage = container.querySelector('#empty-services-message');
        if (emptyMessage) {
            emptyMessage.remove();
        }

        servicoIndex++;
        atualizarOrdemServicos();
    }

    function removerServico(btn) {
        const servicoItem = btn.closest('.servico-item');
        servicoItem.remove();
        atualizarOrdemServicos();

        // Se não houver mais serviços, mostrar mensagem
        const container = document.getElementById('servicos-container');
        if (container.children.length === 0) {
            container.innerHTML = `
                <div class="text-center py-4 text-muted" id="empty-services-message">
                    <i class="bi bi-list-check" style="font-size: 2rem;"></i>
                    <p class="mt-2">Nenhum serviço adicionado. Clique em "Adicionar Serviço" para começar.</p>
                </div>
            `;
        }
    }

    function atualizarOrdemServicos() {
        const servicos = document.querySelectorAll('.servico-item');
        servicos.forEach((item, index) => {
            item.setAttribute('data-index', index);
            const ordemInput = item.querySelector('.servico-ordem');
            if (ordemInput) {
                ordemInput.value = index;
                // Atualizar o name do input para manter a ordem correta
                const inputs = item.querySelectorAll('input, select, textarea');
                inputs.forEach(input => {
                    const name = input.getAttribute('name');
                    if (name && name.includes('servicos[')) {
                        const newName = name.replace(/servicos\[\d+\]/, `servicos[${index}]`);
                        input.setAttribute('name', newName);
                    }
                });
                // Atualizar o onchange do select
                const select = item.querySelector('.servico-select');
                if (select) {
                    select.setAttribute('onchange', `atualizarDescricaoServico(this, ${index})`);
                }
            }
        });
    }

    function atualizarDescricaoServico(select, index) {
        const servicoItem = select.closest('.servico-item');
        const option = select.options[select.selectedIndex];
        const descricaoServico = option.getAttribute('data-descricao') || '';
        const productId = option.getAttribute('data-product-id') || '';

        // Atualizar campo de product_id hidden
        const productIdInput = servicoItem.querySelector('.servico-product-id');
        if (productIdInput) {
            productIdInput.value = productId;
        }

        // Preencher descrição automaticamente se estiver vazia
        const descricaoTextarea = servicoItem.querySelector('.servico-descricao');
        if (descricaoTextarea) {
            // Se a descrição estiver vazia ou for igual à descrição do serviço anterior, atualizar
            if (!descricaoTextarea.value || descricaoTextarea.dataset.originalValue === descricaoTextarea.value) {
                descricaoTextarea.value = descricaoServico;
                descricaoTextarea.dataset.originalValue = descricaoServico;
            }
        }
    }
</script>