<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item active">Métodos de Pagamento</li>
            </ol>
        </nav>
        <h2><i class="bi bi-credit-card me-2"></i> Métodos de Pagamento</h2>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="bi bi-list-ul me-2"></i> Lista de Métodos</h5>
                <div class="d-flex gap-2">
                    <button type="button" class="btn btn-outline-info" onclick="abrirTutorialMetodosPagamento()"
                        title="Tutorial do Módulo">
                        <i class="bi bi-question-circle me-2"></i> Tutorial
                    </button>
                    <button class="btn btn-outline-secondary" onclick="filtrarMetodos()">
                        <i class="bi bi-funnel"></i> Filtrar
                    </button>
                    <a href="<?= url('/metodos-pagamento/criar') ?>" class="btn btn-primary">
                        <i class="bi bi-plus-circle me-2"></i> Novo Método
                    </a>
                </div>
            </div>
            <div class="card-body">
                <!-- Filtros -->
                <div class="row mb-3" id="filtrosMetodos" style="display: none;">
                    <div class="col-md-4">
                        <label for="filtroTipo" class="form-label">Tipo</label>
                        <select class="form-select" id="filtroTipo">
                            <option value="">Todos</option>
                            <option value="dinheiro">Dinheiro</option>
                            <option value="cartao">Cartão</option>
                            <option value="pix">PIX</option>
                            <option value="transferencia">Transferência</option>
                            <option value="boleto">Boleto</option>
                            <option value="cheque">Cheque</option>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label for="filtroStatus" class="form-label">Status</label>
                        <select class="form-select" id="filtroStatus">
                            <option value="">Todos</option>
                            <option value="1">Ativos</option>
                            <option value="0">Inativos</option>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label for="filtroBusca" class="form-label">Buscar</label>
                        <input type="text" class="form-control" id="filtroBusca" placeholder="Nome ou descrição...">
                    </div>
                </div>

                <!-- Tabela -->
                <div class="table-responsive">
                    <table class="table table-hover" id="tabelaMetodos">
                        <thead class="table-light">
                            <tr>
                                <th>Nome</th>
                                <th>Tipo</th>
                                <th>Taxa (%)</th>
                                <th>Prazo (dias)</th>
                                <th>Status</th>
                                <th width="120">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($metodos)): ?>
                                <?php foreach ($metodos as $metodo): ?>
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <i class="<?= $metodo['icon'] ?? 'bi bi-cash' ?> me-2 text-primary"></i>
                                                <strong><?= htmlspecialchars($metodo['name']) ?></strong>
                                            </div>
                                        </td>
                                        <td>
                                            <?php
                                            $tipoLabels = [
                                                'dinheiro' => 'Dinheiro',
                                                'cartao_credito' => 'Cartão Crédito',
                                                'cartao_debito' => 'Cartão Débito',
                                                'pix' => 'PIX',
                                                'boleto' => 'Boleto',
                                                'transferencia' => 'Transferência',
                                                'cheque' => 'Cheque',
                                                'carne' => 'Carnê',
                                                'crediario' => 'Crediário',
                                                'voucher' => 'Voucher',
                                                'operacoes_internas' => 'Operações Internas',
                                                'outro' => 'Outro'
                                            ];

                                            $tipoCores = [
                                                'dinheiro' => 'success',
                                                'cartao_credito' => 'info',
                                                'cartao_debito' => 'info',
                                                'pix' => 'primary',
                                                'boleto' => 'warning',
                                                'transferencia' => 'secondary',
                                                'cheque' => 'secondary',
                                                'carne' => 'warning',
                                                'crediario' => 'warning',
                                                'voucher' => 'secondary',
                                                'operacoes_internas' => 'dark',
                                                'outro' => 'secondary'
                                            ];

                                            $tipo = $metodo['type'] ?? '';
                                            $label = !empty($tipo) ? ($tipoLabels[$tipo] ?? ucfirst($tipo)) : 'Não definido';
                                            $cor = !empty($tipo) ? ($tipoCores[$tipo] ?? 'secondary') : 'secondary';
                                            ?>
                                            <span class="badge bg-<?= $cor ?>">
                                                <?= $label ?>
                                            </span>
                                        </td>
                                        <td>
                                            <?php if ($metodo['fee_percentage'] > 0): ?>
                                                <span class="text-danger"><?= number_format($metodo['fee_percentage'], 2, ',', '.') ?>%</span>
                                            <?php else: ?>
                                                <span class="text-muted">0,00%</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if (!empty($metodo['prazos'])): ?>
                                                <?php foreach (explode(', ', $metodo['prazos']) as $prazo): ?>
                                                    <span class="badge bg-light text-dark me-1"><?= $prazo ?> dias</span>
                                                <?php endforeach; ?>
                                            <?php else: ?>
                                                <span class="badge bg-secondary">Sem prazos</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <span class="badge bg-<?= $metodo['is_active'] ? 'success' : 'danger' ?>">
                                                <?= $metodo['is_active'] ? 'Ativo' : 'Inativo' ?>
                                            </span>
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-sm" role="group">
                                                <a href="<?= url('/metodos-pagamento/editar?id=' . $metodo['id']) ?>"
                                                   class="btn btn-outline-primary" title="Editar">
                                                    <i class="bi bi-pencil"></i>
                                                </a>
                                                <button class="btn btn-outline-danger"
                                                        onclick="deletarMetodo(<?= $metodo['id'] ?>)"
                                                        title="Excluir">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="6" class="text-center text-muted py-4">
                                        <i class="bi bi-credit-card display-6 d-block mb-2"></i>
                                        Nenhum método de pagamento encontrado
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <?php if (!empty($metodos) && isset($totalPages) && $totalPages > 1): ?>
                    <div class="d-flex justify-content-between align-items-center p-3 border-top">
                        <div class="text-muted">
                            Mostrando <?= (($page ?? 1) - 1) * ($perPage ?? 50) + 1 ?> a <?= min(($page ?? 1) * ($perPage ?? 50), $total ?? 0) ?> de <?= $total ?? 0 ?> métodos
                        </div>
                        <nav>
                            <ul class="pagination pagination-sm mb-0">
                                <li class="page-item <?= ($page ?? 1) <= 1 ? 'disabled' : '' ?>">
                                    <a class="page-link" href="?page=<?= max(1, ($page ?? 1) - 1) ?>" aria-label="Anterior">
                                        <span aria-hidden="true">&laquo;</span>
                                    </a>
                                </li>
                                <?php for ($i = max(1, ($page ?? 1) - 2); $i <= min($totalPages, ($page ?? 1) + 2); $i++): ?>
                                    <li class="page-item <?= ($i === ($page ?? 1)) ? 'active' : '' ?>">
                                        <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                                    </li>
                                <?php endfor; ?>
                                <li class="page-item <?= ($page ?? 1) >= $totalPages ? 'disabled' : '' ?>">
                                    <a class="page-link" href="?page=<?= min($totalPages, ($page ?? 1) + 1) ?>" aria-label="Próximo">
                                        <span aria-hidden="true">&raquo;</span>
                                    </a>
                                </li>
                            </ul>
                        </nav>
                    </div>
                <?php elseif (!empty($metodos) && isset($total) && $total > 0): ?>
                    <div class="text-center p-3 border-top">
                        <small class="text-muted">Mostrando todos os <?= $total ?> método(s)</small>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Filtros
    $('#filtroTipo, #filtroStatus, #filtroBusca').on('change keyup', function() {
        filtrarTabela();
    });
});

function filtrarMetodos() {
    $('#filtrosMetodos').toggle();
}

function filtrarTabela() {
    const tipo = $('#filtroTipo').val().toLowerCase();
    const status = $('#filtroStatus').val();
    const busca = $('#filtroBusca').val().toLowerCase();

    $('#tabelaMetodos tbody tr').each(function() {
        const $row = $(this);
        const tipoRow = $row.find('td:nth-child(2) .badge').text().toLowerCase();
        const statusRow = $row.find('td:nth-child(5) .badge').text().toLowerCase();
        const textoRow = $row.text().toLowerCase();

        const matchTipo = !tipo || tipoRow.includes(tipo);
        const matchStatus = !status || (status === '1' && statusRow.includes('ativo')) || (status === '0' && statusRow.includes('inativo'));
        const matchBusca = !busca || textoRow.includes(busca);

        $row.toggle(matchTipo && matchStatus && matchBusca);
    });
}

function deletarMetodo(id) {
    confirmDelete('Tem certeza que deseja excluir este método de pagamento?', function() {
        $.ajax({
            url: appUrl('/metodos-pagamento/deletar'),
            type: 'POST',
            data: { id: id },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Sucesso!',
                        text: response.message,
                        showConfirmButton: false,
                        timer: 1500
                    }).then(() => {
                        location.reload();
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: response.message
                    });
                }
            },
            error: function() {
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: 'Erro ao excluir método de pagamento'
                });
            }
        });
    });
}

// Função para abrir tutorial do módulo de Métodos de Pagamento
function abrirTutorialMetodosPagamento() {
    Swal.fire({
        title: '<i class="bi bi-credit-card text-primary"></i> Tutorial Completo: Métodos de Pagamento',
        html: `
            <div class="text-start" style="max-height: 70vh; overflow-y: auto;">
                <div class="mb-4">
                    <h5 class="text-primary mb-3"><i class="bi bi-info-circle me-2"></i>Visão Geral</h5>
                    <p class="text-muted">O módulo de Métodos de Pagamento permite cadastrar e gerenciar todas as formas de pagamento aceitas pela empresa, incluindo configuração de prazos, taxas e integração com gateways de pagamento.</p>
                </div>

                <div class="accordion" id="tutorialAccordionMetodos">
                    <!-- O QUE SÃO MÉTODOS DE PAGAMENTO -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#oQueSaoMetodos">
                                <i class="bi bi-question-circle me-2"></i> <strong>1. O que são Métodos de Pagamento?</strong>
                            </button>
                        </h2>
                        <div id="oQueSaoMetodos" class="accordion-collapse collapse show" data-bs-parent="#tutorialAccordionMetodos">
                            <div class="accordion-body">
                                <p class="mb-3">Métodos de Pagamento são as formas aceitas pela empresa para receber pagamentos de clientes ou realizar pagamentos a fornecedores. Eles permitem:</p>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-check-circle text-success me-2"></i><strong>Organizar:</strong> Centralizar todas as formas de pagamento em um único local</li>
                                    <li><i class="bi bi-check-circle text-success me-2"></i><strong>Configurar Prazos:</strong> Definir múltiplos prazos de pagamento (ex: 30, 60, 90 dias)</li>
                                    <li><i class="bi bi-check-circle text-success me-2"></i><strong>Taxas:</strong> Configurar taxas de operação por prazo</li>
                                    <li><i class="bi bi-check-circle text-success me-2"></i><strong>Integração:</strong> Conectar com gateways de pagamento (PagSeguro, Mercado Pago, etc.)</li>
                                </ul>
                                <div class="alert alert-info mt-3">
                                    <i class="bi bi-lightbulb me-2"></i>
                                    <small><strong>Exemplo:</strong> Você pode criar um método "Boleto Bancário" com prazos de 30, 60 e 90 dias, cada um com taxas diferentes.</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- TIPOS DE MÉTODOS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#tiposMetodos">
                                <i class="bi bi-tags me-2"></i> <strong>2. Tipos de Métodos Disponíveis</strong>
                            </button>
                        </h2>
                        <div id="tiposMetodos" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionMetodos">
                            <div class="accordion-body">
                                <p class="mb-3">Ao criar um método, você deve selecionar o <strong>Tipo</strong>. Os tipos disponíveis são:</p>

                                <h6 class="text-success mb-3"><i class="bi bi-cash me-2"></i>Dinheiro</h6>
                                <p class="ms-3 mb-3">Pagamento em dinheiro físico</p>

                                <h6 class="text-info mb-3"><i class="bi bi-credit-card me-2"></i>Cartões</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Cartão de Crédito:</strong> Pagamento com cartão de crédito</li>
                                    <li><strong>Cartão de Débito:</strong> Pagamento com cartão de débito</li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-qr-code me-2"></i>PIX</h6>
                                <p class="ms-3 mb-3">Pagamento instantâneo via PIX</p>

                                <h6 class="text-warning mb-3"><i class="bi bi-receipt me-2"></i>Boleto</h6>
                                <p class="ms-3 mb-3">Pagamento via boleto bancário</p>

                                <h6 class="text-secondary mb-3"><i class="bi bi-bank me-2"></i>Transferência Bancária</h6>
                                <p class="ms-3 mb-3">Transferência entre contas bancárias</p>

                                <h6 class="text-secondary mb-3"><i class="bi bi-file-text me-2"></i>Cheque</h6>
                                <p class="ms-3 mb-3">Pagamento via cheque</p>

                                <h6 class="text-warning mb-3"><i class="bi bi-calendar me-2"></i>Carnê</h6>
                                <p class="ms-3 mb-3">Pagamento parcelado via carnê</p>

                                <h6 class="text-warning mb-3"><i class="bi bi-wallet me-2"></i>Crediário</h6>
                                <p class="ms-3 mb-3">Pagamento a prazo via crediário</p>

                                <h6 class="text-secondary mb-3"><i class="bi bi-ticket me-2"></i>Voucher</h6>
                                <p class="ms-3 mb-3">Pagamento via voucher ou vale</p>

                                <h6 class="text-dark mb-3"><i class="bi bi-arrow-left-right me-2"></i>Operações Internas</h6>
                                <p class="ms-3 mb-3">Operações internas da empresa (transferências, ajustes, etc.)</p>

                                <h6 class="text-secondary mb-3"><i class="bi bi-three-dots me-2"></i>Outro</h6>
                                <p class="ms-3 mb-3">Outros métodos de pagamento não listados</p>
                            </div>
                        </div>
                    </div>

                    <!-- ABA: DADOS PRINCIPAIS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#dadosPrincipais">
                                <i class="bi bi-credit-card me-2"></i> <strong>3. Aba: Dados Principais</strong>
                            </button>
                        </h2>
                        <div id="dadosPrincipais" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionMetodos">
                            <div class="accordion-body">
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Nome *:</strong> Nome que identifica o método de pagamento
                                        <br><small class="text-danger">Campo obrigatório</small>
                                        <br><small class="text-muted">Exemplos: "Dinheiro", "PIX", "Cartão de Crédito Visa"</small>
                                    </li>
                                    <li><strong>Tipo *:</strong> Selecione o tipo de método de pagamento
                                        <br><small class="text-danger">Campo obrigatório</small>
                                        <br><small class="text-info">Escolha entre: Dinheiro, Cartão de Crédito, Cartão de Débito, PIX, Boleto, etc.</small>
                                    </li>
                                    <li><strong>Ícone:</strong> Classe do ícone Bootstrap Icons
                                        <br><small class="text-muted">Opcional, mas recomendado para melhor visualização</small>
                                        <br><small class="text-info">Exemplos: "bi bi-cash", "bi bi-credit-card", "bi bi-qr-code"</small>
                                    </li>
                                    <li><strong>Observações:</strong> Campo de texto livre para informações adicionais
                                        <br><small class="text-muted">Opcional, use para registrar informações importantes</small>
                                    </li>
                                    <li><strong>Método Ativo:</strong> Marque para manter o método ativo
                                        <br><small class="text-muted">Métodos inativos não aparecem em seleções</small>
                                        <br><small class="text-info">Disponível apenas ao editar</small>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- ABA: PRAZOS DE PAGAMENTO -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#prazosPagamento">
                                <i class="bi bi-calendar-plus me-2"></i> <strong>4. Aba: Prazos de Pagamento</strong>
                            </button>
                        </h2>
                        <div id="prazosPagamento" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionMetodos">
                            <div class="accordion-body">
                                <p class="mb-3">Esta aba permite configurar múltiplos prazos de pagamento para o método, cada um com sua própria taxa de operação.</p>

                                <h6 class="text-primary mb-3"><i class="bi bi-plus-circle me-2"></i>Adicionando Prazos</h6>
                                <ol class="ms-3 mb-3">
                                    <li>Digite o número de <strong>Dias</strong> (ex: 30, 60, 90)</li>
                                    <li>Digite a <strong>Taxa de Operação (%)</strong> (ex: 2.5, 5.0, 0.0)</li>
                                    <li>Clique em "Adicionar"</li>
                                    <li>O prazo será adicionado à lista</li>
                                </ol>

                                <h6 class="text-primary mb-3"><i class="bi bi-info-circle me-2"></i>Campos</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Dias:</strong> Número de dias para o pagamento
                                        <br><small class="text-muted">Exemplos: 1 (à vista), 30, 60, 90, 120</small>
                                    </li>
                                    <li><strong>Taxa de Operação (%):</strong> Taxa percentual aplicada ao prazo
                                        <br><small class="text-muted">Exemplos: 0.00 (sem taxa), 2.5, 5.0, 10.0</small>
                                        <br><small class="text-info">Use 0.00 para prazos sem taxa adicional</small>
                                    </li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-list-ul me-2"></i>Gerenciando Prazos</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Você pode adicionar múltiplos prazos ao mesmo método</li>
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Para remover um prazo, clique no ícone de lixeira</li>
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Os prazos são salvos junto com o método</li>
                                </ul>

                                <div class="alert alert-info mt-3">
                                    <i class="bi bi-lightbulb me-2"></i>
                                    <small><strong>Exemplo:</strong> Para "Boleto Bancário", você pode criar prazos de 30 dias (taxa 0%), 60 dias (taxa 2%) e 90 dias (taxa 5%).</small>
                                </div>

                                <div class="alert alert-warning mt-3">
                                    <i class="bi bi-exclamation-triangle me-2"></i>
                                    <small><strong>Nota:</strong> Os prazos são opcionais. Você pode salvar um método sem configurar prazos.</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- ABA: INTEGRAÇÃO -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#integracao">
                                <i class="bi bi-plug me-2"></i> <strong>5. Aba: Integração</strong>
                            </button>
                        </h2>
                        <div id="integracao" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionMetodos">
                            <div class="accordion-body">
                                <p class="mb-3">Esta aba permite configurar integração com gateways de pagamento para processamento automático de transações.</p>

                                <h6 class="text-primary mb-3"><i class="bi bi-building me-2"></i>Gateways Disponíveis</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>PagSeguro:</strong> Gateway brasileiro de pagamentos</li>
                                    <li><strong>Mercado Pago:</strong> Plataforma de pagamentos do Mercado Livre</li>
                                    <li><strong>Stripe:</strong> Gateway internacional de pagamentos</li>
                                    <li><strong>Cielo:</strong> Gateway brasileiro de pagamentos</li>
                                    <li><strong>Getnet:</strong> Gateway de pagamentos</li>
                                    <li><strong>Rede:</strong> Gateway de pagamentos</li>
                                    <li><strong>Outro:</strong> Outros gateways não listados</li>
                                    <li><strong>Nenhum:</strong> Sem integração (método manual)</li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-key me-2"></i>Campos de Integração</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Gateway:</strong> Selecione o gateway de pagamento
                                        <br><small class="text-muted">Opcional, apenas se desejar integrar com gateway</small>
                                    </li>
                                    <li><strong>API Key / Token:</strong> Chave de API fornecida pelo gateway
                                        <br><small class="text-muted">Opcional, necessário apenas se usar gateway</small>
                                        <br><small class="text-warning">Mantenha essa chave em segredo!</small>
                                    </li>
                                    <li><strong>Webhook URL:</strong> URL para receber notificações do gateway
                                        <br><small class="text-muted">Opcional, usado para receber atualizações de status de pagamento</small>
                                        <br><small class="text-info">Formato: https://seudominio.com/webhook</small>
                                    </li>
                                </ul>

                                <div class="alert alert-warning mt-3">
                                    <i class="bi bi-exclamation-triangle me-2"></i>
                                    <small><strong>Importante:</strong> As configurações de integração são opcionais. Você pode usar métodos de pagamento sem integração com gateway.</small>
                                </div>

                                <div class="alert alert-info mt-3">
                                    <i class="bi bi-info-circle me-2"></i>
                                    <small><strong>Como obter:</strong> Acesse o painel do gateway escolhido, crie uma aplicação e obtenha a API Key/Token fornecida.</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- COMO USAR -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#comoUsar">
                                <i class="bi bi-play-circle me-2"></i> <strong>6. Como Usar</strong>
                            </button>
                        </h2>
                        <div id="comoUsar" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionMetodos">
                            <div class="accordion-body">
                                <h6 class="text-success mb-3"><i class="bi bi-plus-circle me-2"></i>Criando um Método de Pagamento</h6>
                                <ol class="ms-3 mb-3">
                                    <li>Clique em "Novo Método"</li>
                                    <li>Na aba "Dados Principais", preencha:
                                        <ul>
                                            <li>Nome do método</li>
                                            <li>Tipo de método</li>
                                            <li>Ícone (opcional)</li>
                                            <li>Observações (opcional)</li>
                                        </ul>
                                    </li>
                                    <li>Na aba "Prazos de Pagamento" (opcional):
                                        <ul>
                                            <li>Adicione os prazos desejados com suas respectivas taxas</li>
                                        </ul>
                                    </li>
                                    <li>Na aba "Integração" (opcional):
                                        <ul>
                                            <li>Selecione o gateway (se houver integração)</li>
                                            <li>Informe a API Key/Token</li>
                                            <li>Configure a Webhook URL</li>
                                        </ul>
                                    </li>
                                    <li>Clique em "Salvar"</li>
                                </ol>

                                <h6 class="text-primary mb-3"><i class="bi bi-pencil me-2"></i>Editando um Método</h6>
                                <ol class="ms-3 mb-3">
                                    <li>Na lista de métodos, clique no ícone de editar (lápis)</li>
                                    <li>Modifique os campos desejados</li>
                                    <li>Adicione ou remova prazos conforme necessário</li>
                                    <li>Atualize as configurações de integração (se aplicável)</li>
                                    <li>Clique em "Atualizar"</li>
                                </ol>

                                <h6 class="text-warning mb-3"><i class="bi bi-x-circle me-2"></i>Desativando um Método</h6>
                                <p class="ms-3 mb-3">Para desativar um método sem excluir:</p>
                                <ol class="ms-3 mb-3">
                                    <li>Edite o método</li>
                                    <li>Na aba "Dados Principais", desmarque "Método Ativo"</li>
                                    <li>Salve as alterações</li>
                                    <li>O método não aparecerá mais em seleções, mas os dados permanecem</li>
                                </ol>
                            </div>
                        </div>
                    </div>

                    <!-- BOAS PRÁTICAS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#boasPraticas">
                                <i class="bi bi-lightbulb me-2"></i> <strong>7. Boas Práticas</strong>
                            </button>
                        </h2>
                        <div id="boasPraticas" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionMetodos">
                            <div class="accordion-body">
                                <h6 class="text-success mb-3"><i class="bi bi-check-circle me-2"></i>Nomenclatura</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Use nomes claros e descritivos</li>
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Se tiver múltiplos métodos do mesmo tipo, seja específico</li>
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Exemplo: "Cartão de Crédito Visa" é melhor que apenas "Cartão"</li>
                                </ul>

                                <h6 class="text-info mb-3"><i class="bi bi-calendar me-2"></i>Configuração de Prazos</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Configure prazos apenas para métodos que realmente oferecem parcelamento</li>
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Use taxas realistas baseadas nos custos reais</li>
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Mantenha prazos organizados (ex: 30, 60, 90 dias)</li>
                                </ul>

                                <h6 class="text-warning mb-3"><i class="bi bi-shield-check me-2"></i>Segurança</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Nunca compartilhe API Keys ou Tokens</li>
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Use apenas gateways confiáveis</li>
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Revise periodicamente as permissões de API</li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-arrow-repeat me-2"></i>Manutenção</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Revise periodicamente os métodos cadastrados</li>
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Atualize taxas quando necessário</li>
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Desative métodos que não são mais utilizados</li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- EXEMPLOS PRÁTICOS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#exemplos">
                                <i class="bi bi-book me-2"></i> <strong>8. Exemplos Práticos</strong>
                            </button>
                        </h2>
                        <div id="exemplos" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionMetodos">
                            <div class="accordion-body">
                                <h6 class="text-success mb-3"><i class="bi bi-cash me-2"></i>Dinheiro</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Nome:</strong> "Dinheiro"</li>
                                    <li><strong>Tipo:</strong> Dinheiro</li>
                                    <li><strong>Prazos:</strong> 1 dia (à vista, taxa 0%)</li>
                                    <li><strong>Integração:</strong> Nenhum</li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-qr-code me-2"></i>PIX</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Nome:</strong> "PIX"</li>
                                    <li><strong>Tipo:</strong> PIX</li>
                                    <li><strong>Prazos:</strong> 1 dia (à vista, taxa 0%)</li>
                                    <li><strong>Integração:</strong> Nenhum (ou gateway se usar API)</li>
                                </ul>

                                <h6 class="text-info mb-3"><i class="bi bi-credit-card me-2"></i>Cartão de Crédito</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Nome:</strong> "Cartão de Crédito"</li>
                                    <li><strong>Tipo:</strong> Cartão de Crédito</li>
                                    <li><strong>Prazos:</strong> 1 dia (taxa 3%), 30 dias (taxa 4%), 60 dias (taxa 5%)</li>
                                    <li><strong>Integração:</strong> Cielo, Getnet, ou outro gateway</li>
                                </ul>

                                <h6 class="text-warning mb-3"><i class="bi bi-receipt me-2"></i>Boleto Bancário</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Nome:</strong> "Boleto Bancário"</li>
                                    <li><strong>Tipo:</strong> Boleto</li>
                                    <li><strong>Prazos:</strong> 30 dias (taxa 0%), 60 dias (taxa 2%), 90 dias (taxa 5%)</li>
                                    <li><strong>Integração:</strong> Gateway de boletos (se usar)</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="alert alert-success mt-4">
                    <i class="bi bi-check-circle me-2"></i>
                    <strong>Pronto para começar!</strong> Agora você conhece todos os recursos do módulo de Métodos de Pagamento e pode configurar suas formas de pagamento com prazos, taxas e integrações.
                </div>
            </div>
        `,
        width: '90%',
        heightAuto: false,
        confirmButtonText: 'Entendi, obrigado!',
        confirmButtonColor: '#0d6efd',
        icon: null,
        customClass: {
            popup: 'tutorial-popup',
            container: 'tutorial-container'
        }
    });
}
</script>

<style>
/* Estilos para o Tutorial */
.tutorial-container {
    max-height: 90vh !important;
}

.tutorial-popup {
    max-width: 90vw !important;
    max-height: 90vh !important;
    width: 90% !important;
}

.tutorial-popup .swal2-html-container {
    padding: 0;
    max-height: calc(90vh - 150px);
    overflow-y: auto;
}

.tutorial-popup .accordion-button {
    font-size: 0.95rem;
    font-weight: 600;
    padding: 0.75rem 1rem;
    background-color: #f8f9fa;
    border: 1px solid #dee2e6;
}

.tutorial-popup .accordion-button:not(.collapsed) {
    background-color: #e7f3ff;
    color: #0d6efd;
    border-color: #0d6efd;
}

.tutorial-popup .accordion-button:focus {
    box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
}

.tutorial-popup .accordion-body {
    padding: 1.25rem;
    background-color: #ffffff;
    border-left: 3px solid #0d6efd;
}

.tutorial-popup .accordion-item {
    border: 1px solid #dee2e6;
    border-radius: 8px;
    overflow: hidden;
    margin-bottom: 0.5rem;
}

.tutorial-popup .list-unstyled li {
    padding: 0.25rem 0;
    line-height: 1.6;
}

.tutorial-popup .alert {
    margin-top: 1rem;
    border-left: 4px solid;
}

.tutorial-popup .text-muted {
    font-size: 0.875rem;
}

.tutorial-popup .text-info {
    color: #0dcaf0 !important;
}

.tutorial-popup .text-success {
    color: #198754 !important;
}

.tutorial-popup .text-warning {
    color: #ffc107 !important;
}

.tutorial-popup .text-primary {
    color: #0d6efd !important;
}
</style>

<?php
$content = ob_get_clean();
$activeMenu = 'metodos-pagamento';
include ROOT_PATH . '/views/layouts/app.php';
?>
