<?php
ob_start();
$isEdit = isset($metodo);
$titulo = $isEdit ? 'Editar Método de Pagamento' : 'Novo Método de Pagamento';
?>

<div class="row mb-4">
    <div class="col-md-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?= url('/metodos-pagamento') ?>">Métodos de Pagamento</a></li>
                <li class="breadcrumb-item active"><?= $titulo ?></li>
            </ol>
        </nav>
        <h2><i class="bi bi-credit-card me-2"></i> <?= $titulo ?></h2>
    </div>
</div>

<form id="formMetodo">
    <input type="hidden" name="id" value="<?= $metodo['id'] ?? '' ?>">

    <!-- Navegação por Abas -->
    <div class="row mb-4">
        <div class="col-12">
            <ul class="nav nav-tabs" id="metodoTabs" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="dados-tab" data-bs-toggle="tab" data-bs-target="#dados"
                        type="button" role="tab">
                        <i class="bi bi-credit-card me-2"></i> Dados Principais
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="prazos-tab" data-bs-toggle="tab" data-bs-target="#prazos" type="button"
                        role="tab">
                        <i class="bi bi-calendar-plus me-2"></i> Prazos de Pagamento
                    </button>
                </li>
            </ul>
        </div>
    </div>

    <!-- Conteúdo das Abas -->
    <div class="tab-content" id="metodoTabsContent">
        <!-- Aba: Dados Principais -->
        <div class="tab-pane fade show active" id="dados" role="tabpanel">
            <div class="card">
                <div class="card-header">
                    <i class="bi bi-info-circle me-2"></i> Dados do Método
                </div>
                <div class="card-body">
                    <div class="row">
                        <!-- Nome -->
                        <div class="col-md-4 mb-3">
                            <label for="name" class="form-label">Nome *</label>
                            <input type="text" class="form-control" id="name" name="name"
                                placeholder="Ex: Dinheiro, PIX, Cartão de Crédito..."
                                value="<?= htmlspecialchars($metodo['name'] ?? '') ?>" required>
                        </div>

                        <!-- Grupo -->
                        <div class="col-md-4 mb-3">
                            <label for="grupo_id" class="form-label">Grupo</label>
                            <select class="form-select" id="grupo_id" name="grupo_id">
                                <option value="">Nenhum</option>
                                <?php if (!empty($grupos)): ?>
                                    <?php foreach ($grupos as $grupo): ?>
                                        <option value="<?= $grupo['id'] ?>" <?= ($metodo['grupo_id'] ?? '') == $grupo['id'] ? 'selected' : '' ?>>
                                            <?= htmlspecialchars($grupo['nome']) ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>

                        <!-- Aplicação (Tipo) -->
                        <div class="col-md-4 mb-3">
                            <label for="aplicacao" class="form-label">Tipo *</label>
                            <select class="form-select" id="aplicacao" name="aplicacao" required>
                                <option value="">Selecione...</option>
                                <option value="entradas" <?= ($metodo['aplicacao'] ?? '') === 'entradas' ? 'selected' : '' ?>>
                                    <i class="bi bi-arrow-down-circle"></i> Entradas
                                </option>
                                <option value="saidas" <?= ($metodo['aplicacao'] ?? '') === 'saidas' ? 'selected' : '' ?>>
                                    <i class="bi bi-arrow-up-circle"></i> Saídas
                                </option>
                                <option value="ambos" <?= ($metodo['aplicacao'] ?? 'ambos') === 'ambos' ? 'selected' : '' ?>>
                                    <i class="bi bi-arrow-left-right"></i> Ambos
                                </option>
                            </select>
                        </div>

                        <!-- Tipo de Pagamento -->
                        <div class="col-md-6 mb-3">
                            <label for="type" class="form-label">Forma de Pagamento *</label>
                            <select class="form-select" id="type" name="type" required>
                                <option value="">Selecione...</option>
                                <option value="dinheiro"
                                    <?= ($metodo['type'] ?? '') === 'dinheiro' ? 'selected' : '' ?>>Dinheiro
                                </option>
                                <option value="cartao_credito"
                                    <?= ($metodo['type'] ?? '') === 'cartao_credito' ? 'selected' : '' ?>>Cartão
                                    de Crédito</option>
                                <option value="cartao_debito"
                                    <?= ($metodo['type'] ?? '') === 'cartao_debito' ? 'selected' : '' ?>>Cartão
                                    de Débito</option>
                                <option value="pix" <?= ($metodo['type'] ?? '') === 'pix' ? 'selected' : '' ?>>
                                    PIX</option>
                                <option value="boleto" <?= ($metodo['type'] ?? '') === 'boleto' ? 'selected' : '' ?>>
                                    Boleto
                                </option>
                                <option value="transferencia"
                                    <?= ($metodo['type'] ?? '') === 'transferencia' ? 'selected' : '' ?>>
                                    Transferência Bancária</option>
                                <option value="cheque" <?= ($metodo['type'] ?? '') === 'cheque' ? 'selected' : '' ?>>
                                    Cheque
                                </option>
                                <option value="carne" <?= ($metodo['type'] ?? '') === 'carne' ? 'selected' : '' ?>>
                                    Carnê
                                </option>
                                <option value="crediario"
                                    <?= ($metodo['type'] ?? '') === 'crediario' ? 'selected' : '' ?>>
                                    Crediário
                                </option>
                                <option value="voucher" <?= ($metodo['type'] ?? '') === 'voucher' ? 'selected' : '' ?>>
                                    Voucher
                                </option>
                                <option value="operacoes_internas"
                                    <?= ($metodo['type'] ?? '') === 'operacoes_internas' ? 'selected' : '' ?>>
                                    Operações Internas
                                </option>
                                <option value="outro" <?= ($metodo['type'] ?? '') === 'outro' ? 'selected' : '' ?>>Outro
                                </option>
                            </select>
                        </div>

                        <!-- Ícone -->
                        <div class="col-md-6 mb-3">
                            <label for="icon" class="form-label">Ícone</label>
                            <input type="text" class="form-control" id="icon" name="icon"
                                placeholder="bi bi-cash"
                                value="<?= htmlspecialchars($metodo['icon'] ?? 'bi bi-cash') ?>">
                            <small class="text-muted">
                                <i class="bi bi-info-circle me-1"></i> Use classes do Bootstrap Icons (ex: bi bi-cash)
                            </small>
                        </div>

                        <!-- Observações -->
                        <div class="col-md-12 mb-3">
                            <label for="notes" class="form-label">Observações</label>
                            <textarea class="form-control" id="notes" name="notes" rows="3"
                                placeholder="Informações adicionais..."><?= htmlspecialchars($metodo['notes'] ?? '') ?></textarea>
                        </div>

                        <!-- Usar no PDV -->
                        <div class="col-md-6 mb-3">
                            <div class="card border-success">
                                <div class="card-body py-2">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="usar_pdv" name="usar_pdv"
                                            value="1" <?= ($metodo['usar_pdv'] ?? 1) ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="usar_pdv">
                                            <i class="bi bi-shop text-success me-1"></i>
                                            <strong>Usar no PDV</strong>
                                        </label>
                                    </div>
                                    <small class="text-muted d-block mt-1">
                                        <i class="bi bi-info-circle me-1"></i>
                                        Exibe este método no Ponto de Venda
                                    </small>
                                </div>
                            </div>
                        </div>

                        <!-- Usar Shipay (apenas para PIX e Boleto) -->
                        <div class="col-md-6 mb-3" id="shipay-container" style="display: none;">
                            <div class="card border-primary">
                                <div class="card-body py-2">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="use_shipay" name="use_shipay"
                                            value="1" <?= ($metodo['use_shipay'] ?? 0) ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="use_shipay">
                                            <i class="bi bi-lightning-charge text-warning me-1"></i>
                                            <strong>Usar Shipay</strong>
                                        </label>
                                    </div>
                                    <small class="text-muted d-block mt-1">
                                        <i class="bi bi-info-circle me-1"></i>
                                        Gera cobrança PIX/Boleto automática via Shipay
                                    </small>
                                </div>
                            </div>
                        </div>

                        <?php if ($isEdit): ?>
                        <!-- Status -->
                        <div class="col-md-6 mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="is_active" name="is_active"
                                    value="1" <?= ($metodo['is_active'] ?? 1) ? 'checked' : '' ?>>
                                <label class="form-check-label" for="is_active">
                                    <i class="bi bi-check-circle me-1"></i> Método Ativo
                                </label>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Aba: Prazos de Pagamento -->
        <div class="tab-pane fade" id="prazos" role="tabpanel">
            <div class="card">
                <div class="card-header bg-success text-white">
                    <i class="bi bi-calendar-plus me-2"></i> Prazos de Pagamento
                </div>
                <div class="card-body">
                    <p class="text-muted mb-3">
                        <i class="bi bi-info-circle me-1"></i>
                        <strong>Opcional:</strong> Configure múltiplos prazos para este método (ex: Boleto 30, 60, 90
                        dias). Você pode salvar o método sem prazos.
                    </p>

                    <div class="row">
                        <div class="col-md-5">
                            <label for="prazo_dias" class="form-label">Dias</label>
                            <input type="number" class="form-control" id="prazo_dias" placeholder="30" min="1">
                        </div>

                        <div class="col-md-5">
                            <label for="prazo_taxa" class="form-label">Taxa de Operação (%)</label>
                            <input type="number" class="form-control" id="prazo_taxa" step="0.01" placeholder="0.00"
                                value="0.00" min="0">
                        </div>

                        <div class="col-md-2">
                            <label class="form-label d-block">&nbsp;</label>
                            <button type="button" class="btn btn-success w-100" onclick="adicionarPrazoLista()">
                                <i class="bi bi-plus-circle me-2"></i> Adicionar
                            </button>
                        </div>
                    </div>

                    <hr class="my-4">

                    <!-- Lista de Prazos (Dinâmica) -->
                    <div id="lista-prazos">
                        <div class="alert alert-info" id="alert-sem-prazos">
                            <i class="bi bi-info-circle me-2"></i>
                            Nenhum prazo configurado. Use os campos acima para adicionar.
                        </div>
                        <div id="tabela-prazos" style="display: none;">
                            <table class="table table-sm table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th>Dias</th>
                                        <th>Taxa de Operação (%)</th>
                                        <th width="80">Ações</th>
                                    </tr>
                                </thead>
                                <tbody id="tbody-prazos">
                                    <?php if (isset($prazos) && !empty($prazos)): ?>
                                    <?php foreach ($prazos as $index => $prazo): ?>
                                    <tr data-index="<?= $index ?>">
                                        <td><strong><?= $prazo['dias'] ?> dias</strong></td>
                                        <td><?= number_format($prazo['taxa_adicional'] ?? 0, 2, ',', '.') ?>%</td>
                                        <td>
                                            <button type="button" class="btn btn-sm btn-outline-danger"
                                                onclick="removerPrazoLista(<?= $index ?>)">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </td>
                                        <!-- Hidden inputs para submeter no POST -->
                                        <input type="hidden" name="prazos[<?= $index ?>][dias]"
                                            value="<?= $prazo['dias'] ?>">
                                        <input type="hidden" name="prazos[<?= $index ?>][taxa_adicional]"
                                            value="<?= $prazo['taxa_adicional'] ?>">
                                    </tr>
                                    <?php endforeach; ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                            <div class="alert alert-success mt-2">
                                <i class="bi bi-check-circle me-2"></i>
                                <strong id="total-prazos"><?= isset($prazos) ? count($prazos) : 0 ?></strong> prazo(s)
                                adicionado(s)
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <!-- Botões -->
    <div class="row mt-4">
        <div class="col-12">
            <button type="submit" class="btn btn-primary btn-lg">
                <i class="bi bi-check-circle me-2"></i> <?= $isEdit ? 'Atualizar' : 'Salvar' ?>
            </button>
            <a href="<?= url('/metodos-pagamento') ?>" class="btn btn-outline-secondary btn-lg ms-2">
                <i class="bi bi-x-circle me-2"></i> Cancelar
            </a>
        </div>
    </div>
</form>

<script>
(function aguardarJQuery() {
    if (typeof jQuery === 'undefined' || typeof Swal === 'undefined') {
        setTimeout(aguardarJQuery, 100);
        return;
    }

    $(document).ready(function() {
        const isEdit = <?= $isEdit ? 'true' : 'false' ?>;
        const url = isEdit ? '<?= url('/metodos-pagamento/editar') ?>' : '<?= url('/metodos-pagamento/criar') ?>';

        // Controlar exibição da opção Shipay baseado no tipo
        function toggleShipayOption() {
            const tipo = $('#type').val();
            const shipayContainer = $('#shipay-container');

            if (tipo === 'pix' || tipo === 'boleto') {
                shipayContainer.slideDown(200);
            } else {
                shipayContainer.slideUp(200);
                $('#use_shipay').prop('checked', false);
            }
        }

        // Executar ao carregar e ao mudar o tipo
        toggleShipayOption();
        $('#type').on('change', toggleShipayOption);

        $('#formMetodo').on('submit', function(e) {
            e.preventDefault();

            const formData = $(this).serializeArray();
            const data = {};
            formData.forEach(item => {
                data[item.name] = item.value;
            });

            // Checkbox
            $('input[type="checkbox"]').each(function() {
                data[$(this).attr('name')] = $(this).is(':checked') ? '1' : '0';
            });

            $.ajax({
                url: url,
                type: 'POST',
                data: data,
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Sucesso!',
                            text: response.message,
                            timer: 1500,
                            showConfirmButton: false
                        }).then(() => {
                            window.location.href = response.redirect ||
                                '<?= url('/metodos-pagamento') ?>';
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro!',
                            text: response.message
                        });
                    }
                },
                error: function(xhr) {
                    console.error('Erro:', xhr);
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: 'Erro ao salvar. Verifique os dados.'
                    });
                }
            });
        });
    });
})();

// Array para armazenar prazos temporariamente
let prazosTemp = [];
let prazoIndex = <?= isset($prazos) ? count($prazos) : 0 ?>;

// Inicializar visualização se já houver prazos
$(document).ready(function() {
    <?php if (isset($prazos) && !empty($prazos)): ?>
    prazosTemp = <?= json_encode(array_values($prazos)) ?>;
    $('#alert-sem-prazos').hide();
    $('#tabela-prazos').show();
    <?php endif; ?>
});

// Adicionar prazo à lista (inline, sem salvar)
function adicionarPrazoLista() {
    const dias = $('#prazo_dias').val();
    const taxa = $('#prazo_taxa').val() || '0.00';

    if (!dias || dias <= 0) {
        Swal.fire({
            icon: 'error',
            title: 'Erro',
            text: 'Informe o número de dias (maior que zero)'
        });
        return;
    }

    // Adicionar ao array temporário
    const prazo = {
        index: prazoIndex,
        dias: dias,
        taxa_adicional: taxa
    };

    prazosTemp.push(prazo);
    prazoIndex++;

    // Adicionar linha na tabela
    const taxaFormatada = parseFloat(taxa).toFixed(2).replace('.', ',');
    const row = `
        <tr data-index="${prazo.index}">
            <td><strong>${dias} dias</strong></td>
            <td>${taxaFormatada}%</td>
            <td>
                <button type="button" class="btn btn-sm btn-outline-danger" onclick="removerPrazoLista(${prazo.index})">
                    <i class="bi bi-trash"></i>
                </button>
            </td>
            <input type="hidden" name="prazos[${prazo.index}][dias]" value="${dias}">
            <input type="hidden" name="prazos[${prazo.index}][taxa_adicional]" value="${taxa}">
        </tr>
    `;

    $('#tbody-prazos').append(row);

    // Mostrar tabela e ocultar alert
    $('#alert-sem-prazos').hide();
    $('#tabela-prazos').show();
    $('#total-prazos').text(prazosTemp.length);

    // Limpar campos
    $('#prazo_dias').val('');
    $('#prazo_taxa').val('0.00');
    $('#prazo_dias').focus();
}

// Remover prazo da lista (inline)
function removerPrazoLista(index) {
    $(`tr[data-index="${index}"]`).remove();
    prazosTemp = prazosTemp.filter(p => p.index !== index);

    $('#total-prazos').text(prazosTemp.length);

    if (prazosTemp.length === 0) {
        $('#tabela-prazos').hide();
        $('#alert-sem-prazos').show();
    }
}
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'metodos-pagamento';
include ROOT_PATH . '/views/layouts/app.php';
?>
?>