<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-12 col-lg-6">
        <h2><i class="bi bi-box-seam me-2"></i> Itens</h2>
        <p class="text-muted">Gerencie produtos, serviços e patrimônio</p>
    </div>
    <div class="col-12 col-lg-6 text-lg-end mt-3 mt-lg-0">
        <button type="button" class="btn btn-outline-info me-2" onclick="abrirTutorialItens()"
            title="Tutorial do Módulo">
            <i class="bi bi-question-circle me-2"></i> Tutorial
        </button>
        <a href="<?= url('/itens/criar') ?>" class="btn btn-primary">
            <i class="bi bi-plus-circle me-2"></i> Novo Item
        </a>
    </div>
</div>

<?php
$currentQuery = $_GET ?? [];
$currentType = $type ?? '';
$abas = [
    'todos' => ['label' => 'Todos', 'icone' => 'bi-grid'],
    'produto' => ['label' => 'Produtos', 'icone' => 'bi-box'],
    'servico' => ['label' => 'Serviços', 'icone' => 'bi-gear'],
    'patrimonio' => ['label' => 'Patrimônio', 'icone' => 'bi-building']
];

$buildUrl = function (?string $tipo, ?int $pageNum = null) use ($currentQuery) {
    $params = $currentQuery;
    if ($tipo === null || $tipo === '') {
        unset($params['type']);
    } else {
        $params['type'] = $tipo;
    }

    // Preservar filtros de busca e empresa ao mudar de aba
    if (isset($params['search']) && empty($params['search'])) {
        unset($params['search']);
    }
    if (isset($params['empresa']) && empty($params['empresa'])) {
        unset($params['empresa']);
    }

    // Gerenciar página
    if ($pageNum !== null) {
        if ($pageNum <= 1) {
            unset($params['page']);
        } else {
            $params['page'] = $pageNum;
        }
    }

    $queryString = http_build_query($params);
    return url('/itens' . (!empty($queryString) ? '?' . $queryString : ''));
};

$abaAtiva = $currentType ?: 'todos';
?>

<div class="card mb-4">
    <div class="card-body py-2">
        <div class="d-flex flex-column flex-md-row align-items-stretch align-items-md-center gap-2">
            <ul class="nav nav-pills flex-grow-1 flex-wrap justify-content-md-start">
                <?php foreach ($abas as $tipo => $dadosAba): ?>
                    <?php
                    $isActive = $abaAtiva === $tipo;
                    $classe = $isActive ? 'active' : '';
                    $link = $buildUrl($tipo === 'todos' ? '' : $tipo);
                    ?>
                    <li class="nav-item me-2 mb-2 flex-grow-1 flex-grow-md-0">
                        <a class="nav-link <?= $classe ?>" href="<?= $link ?>">
                            <i class="bi <?= $dadosAba['icone'] ?> me-1"></i>
                            <?= $dadosAba['label'] ?>
                        </a>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3" id="filtros-form" onsubmit="return false;">
            <div class="col-md-5">
                <input type="text" class="form-control" id="search-input" name="search"
                    placeholder="Buscar por ID, código, nome, SKU, código de barras..."
                    value="<?= htmlspecialchars($search ?? '') ?>" autocomplete="off">
            </div>
            <div class="col-md-2">
                <select class="form-select" id="type-filter" name="type">
                    <option value="">Todos os Tipos</option>
                    <option value="produto" <?= ($type ?? '') === 'produto' ? 'selected' : '' ?>>Produtos</option>
                    <option value="servico" <?= ($type ?? '') === 'servico' ? 'selected' : '' ?>>Serviços</option>
                    <option value="patrimonio" <?= ($type ?? '') === 'patrimonio' ? 'selected' : '' ?>>Patrimônio</option>
                </select>
            </div>
            <?php if (!empty($todasEmpresas)): ?>
                <div class="col-md-3">
                    <select class="form-select" id="empresa-filter" name="empresa">
                        <option value="">Todas as Empresas</option>
                        <?php foreach ($todasEmpresas as $emp): ?>
                            <option value="<?= $emp['id'] ?>" <?= (isset($empresa) && $empresa == $emp['id']) ? 'selected' : '' ?>>
                                <?= htmlspecialchars($emp['nome_fantasia'] ?: $emp['razao_social']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
            <?php endif; ?>
            <div class="col-md-2">
                <button type="submit" class="btn btn-secondary w-100" id="search-button">
                    <i class="bi bi-search"></i> Buscar
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Listagem -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span><i class="bi bi-list-ul me-2"></i> Lista de Itens</span>
        <span class="badge bg-primary" id="produtos-count"><?= count($produtos ?? []) ?> registro(s)</span>
    </div>
    <div class="card-body p-0" id="produtos-container">
        <?php if (!empty($produtos)): ?>
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th width="60">ID</th>
                            <th>Nome</th>
                            <th>SKU/Código</th>
                            <th>Grupo</th>
                            <th>Estoque</th>
                            <th>Preço</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($produtos as $produto): ?>
                            <tr style="cursor: pointer;" data-item-id="<?= $produto['id'] ?>"
                                data-item-name="<?= htmlspecialchars($produto['name'], ENT_QUOTES) ?>"
                                data-item-sku="<?= htmlspecialchars($produto['sku'] ?? '-', ENT_QUOTES) ?>"
                                data-item-type="<?= htmlspecialchars($produto['type'] ?? '', ENT_QUOTES) ?>"
                                data-item-price="<?= number_format($produto['price'] ?? 0, 2, ',', '.') ?>"
                                onclick="abrirOpcoesItem(event)">
                                <td><?= $produto['id'] ?></td>
                                <td>
                                    <strong><?= htmlspecialchars($produto['name']) ?></strong>
                                    <?php if (!empty($produto['description'])): ?>
                                        <br><small
                                            class="text-muted"><?= htmlspecialchars(substr($produto['description'], 0, 50)) ?><?= strlen($produto['description']) > 50 ? '...' : '' ?></small>
                                    <?php endif; ?>
                                </td>
                                <td><?= htmlspecialchars($produto['sku'] ?? '-') ?></td>
                                <td><small class="text-muted"><?= htmlspecialchars($produto['grupo_name'] ?? '-') ?></small>
                                </td>
                                <td>
                                    <?php if ($produto['type'] === 'produto'): ?>
                                        <?php
                                        $estoque = $produto['stock_quantity'] ?? 0;
                                        $minEstoque = $produto['min_stock'] ?? 0;
                                        $classe = $estoque <= $minEstoque ? 'text-danger' : 'text-success';
                                        ?>
                                        <span class="<?= $classe ?>"><strong><?= $estoque ?></strong></span>
                                    <?php else: ?>
                                        <span class="text-muted">N/A</span>
                                    <?php endif; ?>
                                </td>
                                <td><strong>R$ <?= number_format($produto['price'] ?? 0, 2, ',', '.') ?></strong></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <?php if (isset($totalPages) && $totalPages > 1): ?>
                <div class="card-footer">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="text-muted">
                            Mostrando <?= (($page ?? 1) - 1) * ($perPage ?? 50) + 1 ?> a <?= min(($page ?? 1) * ($perPage ?? 50), $total ?? 0) ?> de <?= $total ?? 0 ?> itens
                        </div>
                        <nav>
                            <ul class="pagination justify-content-center mb-0">
                                <li class="page-item <?= ($page ?? 1) <= 1 ? 'disabled' : '' ?>">
                                    <a class="page-link" href="<?= $buildUrl(null, max(1, ($page ?? 1) - 1)) ?>">
                                        <i class="bi bi-chevron-left"></i>
                                    </a>
                                </li>
                                <?php
                                $currentPage = $page ?? 1;
                                $startPage = max(1, $currentPage - 2);
                                $endPage = min($totalPages, $currentPage + 2);
                                for ($i = $startPage; $i <= $endPage; $i++):
                                ?>
                                    <li class="page-item <?= $i === $currentPage ? 'active' : '' ?>">
                                        <a class="page-link" href="<?= $buildUrl(null, $i) ?>"><?= $i ?></a>
                                    </li>
                                <?php endfor; ?>
                                <li class="page-item <?= ($page ?? 1) >= $totalPages ? 'disabled' : '' ?>">
                                    <a class="page-link" href="<?= $buildUrl(null, min($totalPages, ($page ?? 1) + 1)) ?>">
                                        <i class="bi bi-chevron-right"></i>
                                    </a>
                                </li>
                            </ul>
                        </nav>
                    </div>
                </div>
            <?php endif; ?>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-box-seam" style="font-size: 4rem; color: var(--text-secondary);"></i>
                <p class="text-muted mt-3">Nenhum item encontrado</p>
                <a href="<?= url('/itens/criar') ?>" class="btn btn-primary mt-2">
                    <i class="bi bi-plus-circle me-2"></i> Cadastrar Primeiro Item
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
    /* Cards de opções (padrão semelhante ao módulo de Vendas) */
    .opcoes-grupo {
        margin-bottom: 1.5rem;
        padding: 0 0.5rem;
    }

    .opcoes-grupo:last-child {
        margin-bottom: 0.5rem;
    }

    .opcoes-titulo {
        font-size: 0.85rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.08em;
        color: #64748b;
        margin-bottom: 0.6rem;
        display: flex;
        align-items: center;
        gap: 0.35rem;
    }

    .opcoes-titulo::before {
        content: '';
        width: 6px;
        height: 6px;
        border-radius: 50%;
        background: #cbd5f5;
    }

    .opcoes-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
        gap: 0.75rem;
    }

    .opcao-card {
        width: 130px;
        height: 130px;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        gap: 0.75rem;
        border: 2px solid #e0e0e0;
        border-radius: 12px;
        background: white;
        cursor: pointer;
        transition: all 0.2s ease-in-out;
        padding: 1rem;
        border: none;
    }

    .opcao-card i {
        font-size: 2rem;
    }

    .opcao-card span {
        font-size: 0.9rem;
        font-weight: 600;
        text-align: center;
    }

    .opcao-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 8px 18px rgba(0, 0, 0, 0.12);
    }

    .opcao-card-primary {
        border-color: #0d6efd;
        color: #0d6efd;
        border: 2px solid #0d6efd;
    }

    .opcao-card-primary:hover {
        background: #0d6efd;
        color: #fff;
    }

    .opcao-card-success {
        border-color: #198754;
        color: #198754;
        border: 2px solid #198754;
    }

    .opcao-card-success:hover {
        background: #198754;
        color: #fff;
    }

    .opcao-card-warning {
        border-color: #ffc107;
        color: #ffc107;
        border: 2px solid #ffc107;
    }

    .opcao-card-warning:hover {
        background: #ffc107;
        color: #fff;
    }

    .opcao-card-danger {
        border-color: #dc3545;
        color: #dc3545;
        border: 2px solid #dc3545;
    }

    .opcao-card-danger:hover {
        background: #dc3545;
        color: #fff;
    }

    .opcao-card-secondary {
        border-color: #6c757d;
        color: #6c757d;
        border: 2px solid #6c757d;
    }

    .opcao-card-secondary:hover {
        background: #6c757d;
        color: #fff;
    }

    .opcao-card-info {
        border-color: #0dcaf0;
        color: #0dcaf0;
        border: 2px solid #0dcaf0;
    }

    .opcao-card-info:hover {
        background: #0dcaf0;
        color: #fff;
    }

    .swal-item-opcoes {
        border-radius: 16px;
        overflow: visible !important;
    }

    .swal-item-container {
        margin: 0 !important;
        padding: 0 !important;
        overflow: visible !important;
    }

    .swal-item-opcoes .swal2-html-container {
        overflow: visible !important;
    }

    .swal-item-opcoes .swal2-close {
        color: white !important;
        background: rgba(255, 255, 255, 0.25) !important;
        border-radius: 8px !important;
        width: 36px !important;
        height: 36px !important;
        font-size: 1.5rem !important;
        transition: all 0.2s !important;
        top: 1rem !important;
        right: 1rem !important;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2) !important;
        z-index: 9999 !important;
    }

    .swal-item-opcoes .swal2-close:hover {
        background: rgba(255, 255, 255, 0.4) !important;
        transform: scale(1.1) !important;
    }

    .swal-item-opcoes .swal2-close:focus {
        box-shadow: 0 0 0 3px rgba(255, 255, 255, 0.3) !important;
    }

    .opcoes-grid {
        padding: 1rem !important;
    }
</style>

<script>
    function abrirOpcoesItem(event) {
        // Buscar dados da linha da tabela
        const row = event.target.closest('tr');
        if (!row) return;

        const id = row.dataset.itemId;
        const name = row.dataset.itemName || 'Item';
        const sku = row.dataset.itemSku || '-';
        const type = row.dataset.itemType || '';
        const price = row.dataset.itemPrice || '0,00';

        const tipoLabel = type === 'produto' ? 'Produto' : (type === 'servico' ? 'Serviço' : 'Item');
        const tipoIcon = type === 'produto' ? 'bi-box' : (type === 'servico' ? 'bi-gear' : 'bi-box-seam');

        const headerHtml = `
        <div style="background: linear-gradient(135deg, #1e3a8a 0%, #3b82f6 100%);
                    padding: 1.5rem;
                    margin: 0 0 1rem 0;
                    border-radius: 12px 12px 0 0;
                    color: white;
                    text-align: left;">
            <div style="display: flex; align-items: center; gap: 1rem; margin-bottom: 0.75rem;">
                <div style="background: rgba(255,255,255,0.2);
                            padding: 0.75rem;
                            border-radius: 10px;
                            display: flex;
                            align-items: center;
                            justify-content: center;">
                    <i class="bi ${tipoIcon}" style="font-size: 1.5rem;"></i>
                </div>
                <div style="flex: 1; padding-right: 3rem;">
                    <div style="font-size: 0.85rem; opacity: 0.9; margin-bottom: 0.25rem;">${tipoLabel}</div>
                    <div style="font-size: 1.25rem; font-weight: 700;">${name}</div>
                </div>
                <div style="text-align: right; min-width: 140px; padding-right: 2.5rem;">
                    <div style="font-size: 0.85rem; opacity: 0.9; margin-bottom: 0.25rem;">Preço</div>
                    <div style="font-size: 1.15rem; font-weight: 600;">R$ ${price}</div>
                </div>
            </div>
            <div style="background: rgba(255,255,255,0.15);
                        padding: 0.75rem 1rem;
                        border-radius: 8px;
                        display: flex;
                        align-items: center;
                        gap: 0.75rem;">
                <i class="bi bi-upc-scan" style="font-size: 1.1rem; opacity: 0.9;"></i>
                <div style="flex: 1;">
                    <strong style="font-size: 0.95rem;">SKU/Código: ${sku}</strong>
                </div>
            </div>
        </div>
    `;

        const itemButtons = `
        <div class="opcoes-grupo">
            <h6 class="opcoes-titulo">Ações</h6>
            <div class="opcoes-grid">
                <button type="button" class="opcao-card opcao-card-primary" onclick="window.location.href='${appUrl('/itens/editar?id=' + id)}'">
                    <i class="bi bi-pencil"></i>
                    <span>Editar Item</span>
                </button>
                ${type === 'produto' ? `
                <button type="button" class="opcao-card opcao-card-info" onclick="Swal.close(); setTimeout(() => abrirExtratoProduto(${id}), 100)">
                    <i class="bi bi-file-earmark-text"></i>
                    <span>Extrato de Produto</span>
                </button>
                ` : ''}
                <button type="button" class="opcao-card opcao-card-danger" onclick="Swal.close(); setTimeout(() => deletarItem(${id}), 100)">
                    <i class="bi bi-trash"></i>
                    <span>Excluir Item</span>
                </button>
            </div>
        </div>
    `;

        const html = headerHtml + itemButtons;

        Swal.fire({
            html: html,
            showConfirmButton: false,
            showCloseButton: true,
            width: '700px',
            padding: '0',
            customClass: {
                popup: 'swal-item-opcoes',
                htmlContainer: 'swal-item-container'
            }
        });
    }

    async function deletarItem(id) {
        const confirmed = await confirmDelete('Tem certeza que deseja excluir este item?');
        if (confirmed) {
            $.ajax({
                url: appUrl('/itens/deletar'),
                type: 'POST',
                data: {
                    id: id
                },
                dataType: 'json',
                success: function (response) {
                    if (response.success) {
                        Toast.success(response.message);
                        setTimeout(() => location.reload(), 1500);
                    } else {
                        Toast.error(response.message);
                    }
                }
            });
        }
    }

    async function abrirExtratoProduto(id) {
        try {
            // Mostrar loading
            Swal.fire({
                title: 'Carregando...',
                text: 'Buscando dados do extrato',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            const response = await $.ajax({
                url: appUrl('/itens/extrato-produto'),
                type: 'GET',
                data: { id: id },
                dataType: 'json'
            });

            Swal.close();

            if (!response.success) {
                Toast.error(response.message || 'Erro ao carregar extrato');
                return;
            }

            const { produto, mes_atual, mes_anterior, periodo_atual, periodo_anterior } = response.data;

            // Formatar valores monetários
            const formatarMoeda = (valor) => {
                if (valor === null || valor === undefined) return '-';
                return new Intl.NumberFormat('pt-BR', { style: 'currency', currency: 'BRL' }).format(valor);
            };

            // Formatar número
            const formatarNumero = (valor) => {
                if (valor === null || valor === undefined) return '-';
                return new Intl.NumberFormat('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).format(valor);
            };

            // Calcular variações
            const calcularVariacao = (atual, anterior) => {
                if (!anterior || anterior === 0) return null;
                const variacao = ((atual - anterior) / anterior) * 100;
                return variacao.toFixed(2);
            };

            const variacaoCustoMedio = calcularVariacao(mes_atual.custo_medio, mes_anterior.custo_medio);
            const variacaoPrecoMedio = calcularVariacao(mes_atual.preco_medio, mes_anterior.preco_medio);
            const variacaoQtdComprada = calcularVariacao(mes_atual.quantidade_comprada, mes_anterior.quantidade_comprada);
            const variacaoQtdVendida = calcularVariacao(mes_atual.quantidade_vendida, mes_anterior.quantidade_vendida);

            const html = `
                <div style="max-width: 900px; margin: 0 auto;">
                    <div style="background: linear-gradient(135deg, #1e3a8a 0%, #3b82f6 100%);
                                padding: 1.5rem;
                                border-radius: 12px;
                                color: white;
                                margin-bottom: 1.5rem;">
                        <h4 style="margin: 0 0 0.5rem 0; font-weight: 700;">
                            <i class="bi bi-file-earmark-text me-2"></i>Extrato de Produto
                        </h4>
                        <div style="font-size: 1.1rem; font-weight: 600;">${produto.name}</div>
                        <div style="font-size: 0.9rem; opacity: 0.9; margin-top: 0.25rem;">SKU: ${produto.sku || '-'}</div>
                    </div>

                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1rem; margin-bottom: 1.5rem;">
                        <div style="background: #f8f9fa; padding: 1rem; border-radius: 8px; border-left: 4px solid #0d6efd;">
                            <div style="font-size: 0.85rem; color: #6c757d; margin-bottom: 0.25rem;">Mês Atual</div>
                            <div style="font-size: 0.9rem; font-weight: 600; color: #495057;">
                                ${new Date(periodo_atual.inicio).toLocaleDateString('pt-BR', { month: 'long', year: 'numeric' })}
                            </div>
                        </div>
                        <div style="background: #f8f9fa; padding: 1rem; border-radius: 8px; border-left: 4px solid #6c757d;">
                            <div style="font-size: 0.85rem; color: #6c757d; margin-bottom: 0.25rem;">Mês Anterior</div>
                            <div style="font-size: 0.9rem; font-weight: 600; color: #495057;">
                                ${new Date(periodo_anterior.inicio).toLocaleDateString('pt-BR', { month: 'long', year: 'numeric' })}
                            </div>
                        </div>
                    </div>

                    <div style="overflow-x: auto;">
                        <table style="width: 100%; border-collapse: collapse; background: white; border-radius: 8px; overflow: hidden;">
                            <thead>
                                <tr style="background: #f8f9fa;">
                                    <th style="padding: 1rem; text-align: left; font-weight: 600; border-bottom: 2px solid #dee2e6;">Indicador</th>
                                    <th style="padding: 1rem; text-align: right; font-weight: 600; border-bottom: 2px solid #dee2e6;">Mês Atual</th>
                                    <th style="padding: 1rem; text-align: right; font-weight: 600; border-bottom: 2px solid #dee2e6;">Mês Anterior</th>
                                    <th style="padding: 1rem; text-align: center; font-weight: 600; border-bottom: 2px solid #dee2e6;">Variação</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td style="padding: 0.75rem 1rem; border-bottom: 1px solid #f0f0f0;"><strong>Custo Médio</strong></td>
                                    <td style="padding: 0.75rem 1rem; text-align: right; border-bottom: 1px solid #f0f0f0;">${formatarMoeda(mes_atual.custo_medio)}</td>
                                    <td style="padding: 0.75rem 1rem; text-align: right; border-bottom: 1px solid #f0f0f0;">${formatarMoeda(mes_anterior.custo_medio)}</td>
                                    <td style="padding: 0.75rem 1rem; text-align: center; border-bottom: 1px solid #f0f0f0;">
                                        ${variacaoCustoMedio !== null ?
                    `<span style="color: ${variacaoCustoMedio >= 0 ? '#dc3545' : '#198754'}; font-weight: 600;">
                                                ${variacaoCustoMedio >= 0 ? '+' : ''}${variacaoCustoMedio}%
                                            </span>` : '-'}
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 0.75rem 1rem; border-bottom: 1px solid #f0f0f0;"><strong>Preço Médio</strong></td>
                                    <td style="padding: 0.75rem 1rem; text-align: right; border-bottom: 1px solid #f0f0f0;">${formatarMoeda(mes_atual.preco_medio)}</td>
                                    <td style="padding: 0.75rem 1rem; text-align: right; border-bottom: 1px solid #f0f0f0;">${formatarMoeda(mes_anterior.preco_medio)}</td>
                                    <td style="padding: 0.75rem 1rem; text-align: center; border-bottom: 1px solid #f0f0f0;">
                                        ${variacaoPrecoMedio !== null ?
                    `<span style="color: ${variacaoPrecoMedio >= 0 ? '#198754' : '#dc3545'}; font-weight: 600;">
                                                ${variacaoPrecoMedio >= 0 ? '+' : ''}${variacaoPrecoMedio}%
                                            </span>` : '-'}
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 0.75rem 1rem; border-bottom: 1px solid #f0f0f0;"><strong>Primeiro Custo</strong></td>
                                    <td style="padding: 0.75rem 1rem; text-align: right; border-bottom: 1px solid #f0f0f0;">${formatarMoeda(mes_atual.primeiro_custo)}</td>
                                    <td style="padding: 0.75rem 1rem; text-align: right; border-bottom: 1px solid #f0f0f0;">${formatarMoeda(mes_anterior.primeiro_custo)}</td>
                                    <td style="padding: 0.75rem 1rem; text-align: center; border-bottom: 1px solid #f0f0f0;">-</td>
                                </tr>
                                <tr>
                                    <td style="padding: 0.75rem 1rem; border-bottom: 1px solid #f0f0f0;"><strong>Último Custo</strong></td>
                                    <td style="padding: 0.75rem 1rem; text-align: right; border-bottom: 1px solid #f0f0f0;">${formatarMoeda(mes_atual.ultimo_custo)}</td>
                                    <td style="padding: 0.75rem 1rem; text-align: right; border-bottom: 1px solid #f0f0f0;">${formatarMoeda(mes_anterior.ultimo_custo)}</td>
                                    <td style="padding: 0.75rem 1rem; text-align: center; border-bottom: 1px solid #f0f0f0;">-</td>
                                </tr>
                                <tr>
                                    <td style="padding: 0.75rem 1rem; border-bottom: 1px solid #f0f0f0;"><strong>Primeiro Preço</strong></td>
                                    <td style="padding: 0.75rem 1rem; text-align: right; border-bottom: 1px solid #f0f0f0;">${formatarMoeda(mes_atual.primeiro_preco)}</td>
                                    <td style="padding: 0.75rem 1rem; text-align: right; border-bottom: 1px solid #f0f0f0;">${formatarMoeda(mes_anterior.primeiro_preco)}</td>
                                    <td style="padding: 0.75rem 1rem; text-align: center; border-bottom: 1px solid #f0f0f0;">-</td>
                                </tr>
                                <tr>
                                    <td style="padding: 0.75rem 1rem; border-bottom: 1px solid #f0f0f0;"><strong>Último Preço</strong></td>
                                    <td style="padding: 0.75rem 1rem; text-align: right; border-bottom: 1px solid #f0f0f0;">${formatarMoeda(mes_atual.ultimo_preco)}</td>
                                    <td style="padding: 0.75rem 1rem; text-align: right; border-bottom: 1px solid #f0f0f0;">${formatarMoeda(mes_anterior.ultimo_preco)}</td>
                                    <td style="padding: 0.75rem 1rem; text-align: center; border-bottom: 1px solid #f0f0f0;">-</td>
                                </tr>
                                <tr>
                                    <td style="padding: 0.75rem 1rem; border-bottom: 1px solid #f0f0f0;"><strong>Quantidade Comprada</strong></td>
                                    <td style="padding: 0.75rem 1rem; text-align: right; border-bottom: 1px solid #f0f0f0;">${formatarNumero(mes_atual.quantidade_comprada)}</td>
                                    <td style="padding: 0.75rem 1rem; text-align: right; border-bottom: 1px solid #f0f0f0;">${formatarNumero(mes_anterior.quantidade_comprada)}</td>
                                    <td style="padding: 0.75rem 1rem; text-align: center; border-bottom: 1px solid #f0f0f0;">
                                        ${variacaoQtdComprada !== null ?
                    `<span style="color: ${variacaoQtdComprada >= 0 ? '#198754' : '#dc3545'}; font-weight: 600;">
                                                ${variacaoQtdComprada >= 0 ? '+' : ''}${variacaoQtdComprada}%
                                            </span>` : '-'}
                                    </td>
                                </tr>
                                <tr>
                                    <td style="padding: 0.75rem 1rem;"><strong>Quantidade Vendida</strong></td>
                                    <td style="padding: 0.75rem 1rem; text-align: right;">${formatarNumero(mes_atual.quantidade_vendida)}</td>
                                    <td style="padding: 0.75rem 1rem; text-align: right;">${formatarNumero(mes_anterior.quantidade_vendida)}</td>
                                    <td style="padding: 0.75rem 1rem; text-align: center;">
                                        ${variacaoQtdVendida !== null ?
                    `<span style="color: ${variacaoQtdVendida >= 0 ? '#198754' : '#dc3545'}; font-weight: 600;">
                                                ${variacaoQtdVendida >= 0 ? '+' : ''}${variacaoQtdVendida}%
                                            </span>` : '-'}
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            `;

            Swal.fire({
                html: html,
                width: '950px',
                showConfirmButton: true,
                confirmButtonText: 'Fechar',
                confirmButtonColor: '#0d6efd',
                customClass: {
                    popup: 'swal-extrato-produto'
                }
            });

        } catch (error) {
            Swal.close();
            Toast.error('Erro ao carregar extrato do produto');
            console.error('Erro ao carregar extrato:', error);
        }
    }

    // Função para abrir tutorial do módulo de Itens
    function abrirTutorialItens() {
        Swal.fire({
            title: '<i class="bi bi-box-seam text-primary"></i> Tutorial Completo: Módulo de Itens',
            html: `
            <div class="text-start" style="max-height: 70vh; overflow-y: auto;">
                <div class="mb-4">
                    <h5 class="text-primary mb-3"><i class="bi bi-info-circle me-2"></i>Visão Geral</h5>
                    <p class="text-muted">O módulo de Itens permite cadastrar e gerenciar produtos, serviços e patrimônio da empresa, incluindo informações de preços, custos, tributação, estoque e configurações avançadas.</p>
                </div>

                <div class="accordion" id="tutorialAccordionItens">
                    <!-- O QUE SÃO ITENS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#oQueSaoItens">
                                <i class="bi bi-question-circle me-2"></i> <strong>1. O que são Itens?</strong>
                            </button>
                        </h2>
                        <div id="oQueSaoItens" class="accordion-collapse collapse show" data-bs-parent="#tutorialAccordionItens">
                            <div class="accordion-body">
                                <p class="mb-3">Itens são produtos, serviços ou patrimônio que a empresa comercializa ou utiliza. Eles podem ser:</p>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-check-circle text-primary me-2"></i><strong>Produtos:</strong> Itens físicos que podem ser estocados e vendidos</li>
                                    <li><i class="bi bi-check-circle text-success me-2"></i><strong>Serviços:</strong> Serviços prestados pela empresa (não têm estoque)</li>
                                </ul>
                                <div class="alert alert-info mt-3">
                                    <i class="bi bi-lightbulb me-2"></i>
                                    <small><strong>Exemplo:</strong> Um produto pode ser "Notebook Dell", enquanto um serviço pode ser "Instalação de Software".</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- ABA: DADOS PRINCIPAIS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#dadosPrincipais">
                                <i class="bi bi-info-circle me-2"></i> <strong>2. Aba: Dados Principais</strong>
                            </button>
                        </h2>
                        <div id="dadosPrincipais" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionItens">
                            <div class="accordion-body">
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Nome do Produto *:</strong> Nome que identifica o item
                                        <br><small class="text-danger">Campo obrigatório</small>
                                        <br><small class="text-muted">Exemplos: "Notebook Dell", "Serviço de Instalação"</small>
                                    </li>
                                    <li><strong>Tipo *:</strong> Selecione se é Produto ou Serviço
                                        <br><small class="text-danger">Campo obrigatório</small>
                                        <br><small class="text-info">Produtos têm controle de estoque, serviços não</small>
                                    </li>
                                    <li><strong>SKU/Código:</strong> Código único do item
                                        <br><small class="text-info">Gerado automaticamente pelo sistema após salvar</small>
                                        <br><small class="text-muted">Usado para identificação interna</small>
                                    </li>
                                    <li><strong>Código de Barras:</strong> Código de barras do produto (EAN, UPC, etc.)
                                        <br><small class="text-muted">Opcional, mas útil para leitura em leitores</small>
                                        <br><small class="text-info">Formato: apenas números (ex: 7891234567890)</small>
                                    </li>
                                    <li><strong>Grupo:</strong> Grupo de categorização do item
                                        <br><small class="text-muted">Opcional, mas recomendado para organização</small>
                                        <br><small class="text-info">Lista grupos do tipo "itens"</small>
                                    </li>
                                    <li><strong>Subgrupo:</strong> Subgrupo dentro do grupo selecionado
                                        <br><small class="text-muted">Opcional, aparece apenas se um grupo for selecionado</small>
                                    </li>
                                    <li><strong>Comissão (%):</strong> Percentual de comissão para vendedores
                                        <br><small class="text-muted">Opcional, ex: 5.00 para 5% de comissão</small>
                                    </li>
                                    <li><strong>Descrição:</strong> Descrição detalhada do item
                                        <br><small class="text-muted">Opcional, mas recomendado para documentação</small>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- ABA: PREÇOS E CUSTOS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#precosCustos">
                                <i class="bi bi-currency-dollar me-2"></i> <strong>3. Aba: Preços e Custos</strong>
                            </button>
                        </h2>
                        <div id="precosCustos" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionItens">
                            <div class="accordion-body">
                                <h6 class="text-primary mb-3"><i class="bi bi-table me-2"></i>Tabelas de Preço</h6>
                                <p class="ms-3 mb-3">Permite criar múltiplas tabelas de preço para o mesmo item, cada uma com valores de compra, custo, margem e venda.</p>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Nome da Tabela:</strong> Selecione uma tabela de preço cadastrada
                                        <br><small class="text-info">Lista tabelas cadastradas no módulo "Tabelas de Preço"</small>
                                    </li>
                                    <li><strong>Compra (R$):</strong> Preço de compra para esta tabela</li>
                                    <li><strong>Custo (R$):</strong> Custo do item para esta tabela</li>
                                    <li><strong>Margem (%):</strong> Margem de lucro desejada</li>
                                    <li><strong>Venda (R$):</strong> Preço de venda para esta tabela</li>
                                </ul>
                                <div class="alert alert-info mt-3">
                                    <i class="bi bi-lightbulb me-2"></i>
                                    <small><strong>Exemplo:</strong> Você pode criar uma "Tabela Atacado" com preço R$ 50,00 e uma "Tabela Varejo" com preço R$ 70,00 para o mesmo produto.</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- ABA: TRIBUTAÇÃO -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#tributacao">
                                <i class="bi bi-file-earmark-text me-2"></i> <strong>4. Aba: Tributação</strong>
                            </button>
                        </h2>
                        <div id="tributacao" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionItens">
                            <div class="accordion-body">
                                <h6 class="text-primary mb-3"><i class="bi bi-list-check me-2"></i>Tipo de Tributação</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Por Produto:</strong> Configure a tributação individualmente para este item</li>
                                    <li><strong>Por Grupo de Impostos:</strong> Use um grupo de impostos pré-configurado
                                        <br><small class="text-info">Mais rápido e prático se você já tem grupos configurados</small>
                                    </li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-barcode me-2"></i>Campos Fiscais</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>NCM:</strong> Nomenclatura Comum do Mercosul
                                        <br><small class="text-muted">Formato: 0000.00.00 (8 dígitos)</small>
                                        <br><small class="text-danger">Obrigatório para produtos</small>
                                    </li>
                                    <li><strong>CEST:</strong> Código Especificador da Substituição Tributária
                                        <br><small class="text-muted">Formato: 00.000.00 (7 dígitos)</small>
                                        <br><small class="text-info">Opcional, apenas para produtos com ST</small>
                                    </li>
                                    <li><strong>CFOP Padrão:</strong> Código Fiscal de Operações
                                        <br><small class="text-muted">Formato: 4 dígitos (ex: 5102)</small>
                                    </li>
                                    <li><strong>Origem da Mercadoria:</strong> Origem do produto
                                        <br><small class="text-info">0 = Nacional, 1-8 = Diferentes tipos de importação</small>
                                    </li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-receipt me-2"></i>Impostos</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>ICMS:</strong> Imposto sobre Circulação de Mercadorias e Serviços
                                        <br><small class="text-muted">CST/CSOSN e Alíquota</small>
                                    </li>
                                    <li><strong>PIS:</strong> Programa de Integração Social
                                        <br><small class="text-muted">CST e Alíquota</small>
                                    </li>
                                    <li><strong>COFINS:</strong> Contribuição para o Financiamento da Seguridade Social
                                        <br><small class="text-muted">CST e Alíquota</small>
                                    </li>
                                    <li><strong>IPI:</strong> Imposto sobre Produtos Industrializados
                                        <br><small class="text-muted">CST e Alíquota</small>
                                    </li>
                                </ul>

                                <div class="alert alert-warning mt-3">
                                    <i class="bi bi-exclamation-triangle me-2"></i>
                                    <small><strong>Importante:</strong> A configuração de tributação é essencial para emissão correta de notas fiscais. Consulte um contador se tiver dúvidas.</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- ABA: ESTOQUE -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#estoque">
                                <i class="bi bi-box me-2"></i> <strong>5. Aba: Estoque</strong>
                            </button>
                        </h2>
                        <div id="estoque" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionItens">
                            <div class="accordion-body">
                                <p class="mb-3">Esta aba é específica para <strong>Produtos</strong>. Serviços não têm controle de estoque.</p>

                                <h6 class="text-primary mb-3"><i class="bi bi-box-arrow-in-down me-2"></i>Controle de Estoque</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Controlar Estoque:</strong> Marque para ativar controle de estoque
                                        <br><small class="text-info">Se desmarcado, o produto não terá controle de estoque</small>
                                    </li>
                                    <li><strong>Quantidade em Estoque:</strong> Quantidade atual disponível
                                        <br><small class="text-muted">Atualizado automaticamente com entradas e saídas</small>
                                    </li>
                                    <li><strong>Estoque Mínimo:</strong> Quantidade mínima antes de alertar
                                        <br><small class="text-warning">Sistema alerta quando estoque fica abaixo deste valor</small>
                                    </li>
                                    <li><strong>Estoque Máximo:</strong> Quantidade máxima recomendada
                                        <br><small class="text-muted">Opcional, para referência</small>
                                    </li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-rulers me-2"></i>Dimensões e Peso</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Largura (cm):</strong> Largura do produto</li>
                                    <li><strong>Altura (cm):</strong> Altura do produto</li>
                                    <li><strong>Comprimento (cm):</strong> Comprimento do produto</li>
                                    <li><strong>Peso (kg):</strong> Peso do produto
                                        <br><small class="text-info">Útil para cálculo de frete</small>
                                    </li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-shop me-2"></i>Localização</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Localização no Estoque:</strong> Onde o produto está armazenado
                                        <br><small class="text-muted">Ex: "Prateleira A-1", "Depósito 2"</small>
                                    </li>
                                </ul>

                                <div class="alert alert-info mt-3">
                                    <i class="bi bi-info-circle me-2"></i>
                                    <small><strong>Nota:</strong> Serviços não têm estoque, então esta aba não se aplica a eles.</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- ABA: CONFIGURAÇÕES -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#configuracoes">
                                <i class="bi bi-gear me-2"></i> <strong>6. Aba: Configurações</strong>
                            </button>
                        </h2>
                        <div id="configuracoes" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionItens">
                            <div class="accordion-body">
                                <h6 class="text-primary mb-3"><i class="bi bi-toggle-on me-2"></i>Status e Visibilidade</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Item Ativo:</strong> Marque para manter o item ativo
                                        <br><small class="text-muted">Itens inativos não aparecem em seleções e vendas</small>
                                    </li>
                                    <li><strong>Vendável:</strong> Marque se o item pode ser vendido
                                        <br><small class="text-info">Útil para itens que são apenas para uso interno</small>
                                    </li>
                                    <li><strong>Comprável:</strong> Marque se o item pode ser comprado
                                        <br><small class="text-info">Útil para itens que são apenas vendidos, não comprados</small>
                                    </li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-tags me-2"></i>Unidade de Medida</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Unidade:</strong> Unidade de medida do item
                                        <br><small class="text-muted">Ex: UN (unidade), KG (quilograma), M (metro), LT (litro)</small>
                                    </li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-sticky me-2"></i>Observações</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Observações:</strong> Campo de texto livre para informações adicionais
                                        <br><small class="text-muted">Use para registrar informações importantes sobre o item</small>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- ABA: MONTAGEM DE KIT -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#montagemKit">
                                <i class="bi bi-box-seam me-2"></i> <strong>7. Aba: Montagem de Kit</strong>
                            </button>
                        </h2>
                        <div id="montagemKit" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionItens">
                            <div class="accordion-body">
                                <p class="mb-3">Permite criar kits compostos por outros produtos. Quando um kit é vendido, o sistema automaticamente reduz o estoque dos produtos componentes.</p>

                                <h6 class="text-primary mb-3"><i class="bi bi-plus-circle me-2"></i>Adicionando Componentes</h6>
                                <ol class="ms-3 mb-3">
                                    <li>Selecione um produto existente</li>
                                    <li>Informe a quantidade necessária</li>
                                    <li>Adicione o componente ao kit</li>
                                    <li>Repita para todos os componentes</li>
                                </ol>

                                <div class="alert alert-info mt-3">
                                    <i class="bi bi-lightbulb me-2"></i>
                                    <small><strong>Exemplo:</strong> Um kit "Computador Completo" pode ter: 1x Processador, 1x Placa Mãe, 2x Memória RAM, 1x HD.</small>
                                </div>

                                <div class="alert alert-warning mt-3">
                                    <i class="bi bi-exclamation-triangle me-2"></i>
                                    <small><strong>Importante:</strong> Apenas produtos podem ser componentes de kits. Serviços não podem fazer parte de kits.</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- COMO USAR -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#comoUsar">
                                <i class="bi bi-play-circle me-2"></i> <strong>8. Como Usar</strong>
                            </button>
                        </h2>
                        <div id="comoUsar" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionItens">
                            <div class="accordion-body">
                                <h6 class="text-success mb-3"><i class="bi bi-plus-circle me-2"></i>Criando um Item</h6>
                                <ol class="ms-3 mb-3">
                                    <li>Clique em "Novo Item"</li>
                                    <li>Na aba "Dados Principais", preencha:
                                        <ul>
                                            <li>Nome do produto</li>
                                            <li>Tipo (Produto ou Serviço)</li>
                                            <li>Código de barras (opcional)</li>
                                            <li>Grupo e Subgrupo (opcional)</li>
                                            <li>Comissão (opcional)</li>
                                            <li>Descrição (opcional)</li>
                                        </ul>
                                    </li>
                                    <li>Na aba "Preços e Custos":
                                        <ul>
                                            <li>Adicione tabelas de preço (opcional)</li>
                                        </ul>
                                    </li>
                                    <li>Na aba "Tributação":
                                        <ul>
                                            <li>Configure NCM, CFOP e impostos</li>
                                            <li>Ou selecione um grupo de impostos</li>
                                        </ul>
                                    </li>
                                    <li>Se for Produto, na aba "Estoque":
                                        <ul>
                                            <li>Configure controle de estoque</li>
                                            <li>Informe dimensões e peso (opcional)</li>
                                        </ul>
                                    </li>
                                    <li>Na aba "Configurações":
                                        <ul>
                                            <li>Configure status e visibilidade</li>
                                            <li>Selecione unidade de medida</li>
                                        </ul>
                                    </li>
                                    <li>Se for criar um kit, na aba "Montagem de Kit":
                                        <ul>
                                            <li>Adicione os componentes do kit</li>
                                        </ul>
                                    </li>
                                    <li>Clique em "Salvar"</li>
                                </ol>

                                <h6 class="text-primary mb-3"><i class="bi bi-pencil me-2"></i>Editando um Item</h6>
                                <ol class="ms-3 mb-3">
                                    <li>Na lista de itens, clique no ícone de editar (lápis)</li>
                                    <li>Modifique os campos desejados</li>
                                    <li>Atualize preços, estoque ou configurações conforme necessário</li>
                                    <li>Clique em "Atualizar"</li>
                                </ol>

                                <h6 class="text-warning mb-3"><i class="bi bi-x-circle me-2"></i>Desativando um Item</h6>
                                <p class="ms-3 mb-3">Para desativar um item sem excluir:</p>
                                <ol class="ms-3 mb-3">
                                    <li>Edite o item</li>
                                    <li>Na aba "Configurações", desmarque "Item Ativo"</li>
                                    <li>Salve as alterações</li>
                                    <li>O item não aparecerá mais em seleções, mas os dados permanecem</li>
                                </ol>
                            </div>
                        </div>
                    </div>

                    <!-- NAVEGAÇÃO POR ABAS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#navegacaoAbas">
                                <i class="bi bi-list-ul me-2"></i> <strong>9. Navegação por Abas</strong>
                            </button>
                        </h2>
                        <div id="navegacaoAbas" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionItens">
                            <div class="accordion-body">
                                <p class="mb-3">Na página principal, os itens são organizados em abas por tipo:</p>

                                <h6 class="text-primary mb-3"><i class="bi bi-grid me-2"></i>Aba: Todos</h6>
                                <p class="ms-3 mb-3">Mostra todos os itens cadastrados (produtos e serviços)</p>

                                <h6 class="text-primary mb-3"><i class="bi bi-box me-2"></i>Aba: Produtos</h6>
                                <p class="ms-3 mb-3">Mostra apenas produtos (itens físicos com estoque)</p>

                                <h6 class="text-success mb-3"><i class="bi bi-gear me-2"></i>Aba: Serviços</h6>
                                <p class="ms-3 mb-3">Mostra apenas serviços (itens sem estoque)</p>

                                <div class="alert alert-info mt-3">
                                    <i class="bi bi-info-circle me-2"></i>
                                    <small>Use os filtros de busca para encontrar itens específicos por nome, SKU ou código de barras.</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- BOAS PRÁTICAS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#boasPraticas">
                                <i class="bi bi-lightbulb me-2"></i> <strong>10. Boas Práticas</strong>
                            </button>
                        </h2>
                        <div id="boasPraticas" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionItens">
                            <div class="accordion-body">
                                <h6 class="text-success mb-3"><i class="bi bi-check-circle me-2"></i>Nomenclatura</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Use nomes claros e descritivos</li>
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Inclua marca e modelo quando aplicável</li>
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Mantenha consistência na nomenclatura</li>
                                </ul>

                                <h6 class="text-info mb-3"><i class="bi bi-barcode me-2"></i>Códigos</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Adicione código de barras sempre que possível</li>
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>O SKU é gerado automaticamente, mas você pode usar códigos próprios</li>
                                </ul>

                                <h6 class="text-warning mb-3"><i class="bi bi-file-earmark-text me-2"></i>Tributação</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Configure NCM corretamente para emissão de notas fiscais</li>
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Use grupos de impostos para facilitar a configuração</li>
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Consulte um contador para configurações fiscais complexas</li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-box me-2"></i>Estoque</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Configure estoque mínimo para receber alertas</li>
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Atualize dimensões e peso para cálculo de frete</li>
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Use localização no estoque para organização</li>
                                </ul>

                                <h6 class="text-secondary mb-3"><i class="bi bi-currency-dollar me-2"></i>Preços</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-secondary me-2"></i>Use tabelas de preço para diferentes políticas</li>
                                    <li><i class="bi bi-arrow-right text-secondary me-2"></i>Mantenha preços atualizados</li>
                                    <li><i class="bi bi-arrow-right text-secondary me-2"></i>Configure margens de lucro adequadas</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="alert alert-success mt-4">
                    <i class="bi bi-check-circle me-2"></i>
                    <strong>Pronto para começar!</strong> Agora você conhece todos os recursos do módulo de Itens e pode cadastrar produtos e serviços com todas as informações necessárias.
                </div>
            </div>
        `,
            width: '90%',
            heightAuto: false,
            confirmButtonText: 'Entendi, obrigado!',
            confirmButtonColor: '#0d6efd',
            icon: null,
            customClass: {
                popup: 'tutorial-popup',
                container: 'tutorial-container'
            }
        });
    }

    // Busca dinâmica de produtos
    (function () {
        let searchTimeout;
        const searchInput = document.getElementById('search-input');
        const typeFilter = document.getElementById('type-filter');
        const empresaFilter = document.getElementById('empresa-filter');
        const produtosContainer = document.getElementById('produtos-container');
        const searchButton = document.getElementById('search-button');
        const badgeCount = document.getElementById('produtos-count');

        function realizarBusca() {
            const search = searchInput ? searchInput.value.trim() : '';
            const type = typeFilter ? typeFilter.value : '';
            const empresa = empresaFilter ? empresaFilter.value : '';

            // Mostrar indicador de carregamento
            if (produtosContainer) {
                produtosContainer.innerHTML = `
                    <div class="text-center py-5">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden">Buscando...</span>
                        </div>
                        <p class="text-muted mt-3">Buscando itens...</p>
                    </div>
                `;
            }

            // Fazer requisição AJAX
            $.ajax({
                url: appUrl('/itens/buscar'),
                method: 'GET',
                data: {
                    search: search,
                    type: type,
                    empresa: empresa
                },
                success: function (response) {
                    if (response.success) {
                        if (produtosContainer) {
                            produtosContainer.innerHTML = response.html;
                        }
                        // Atualizar contador
                        if (badgeCount) {
                            badgeCount.textContent = response.count + ' registro(s)';
                        }
                    } else {
                        if (produtosContainer) {
                            produtosContainer.innerHTML = `
                                <div class="alert alert-danger m-3">
                                    <i class="bi bi-exclamation-triangle me-2"></i>
                                    ${response.message || 'Erro ao buscar itens.'}
                                </div>
                            `;
                        }
                    }
                },
                error: function (xhr) {
                    console.error('Erro na busca:', xhr);
                    let errorMessage = 'Erro ao buscar itens. Tente novamente.';

                    // Tentar extrair mensagem de erro da resposta
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        errorMessage = xhr.responseJSON.message;
                    } else if (xhr.responseText) {
                        try {
                            const response = JSON.parse(xhr.responseText);
                            if (response.message) {
                                errorMessage = response.message;
                            }
                        } catch (e) {
                            // Se não conseguir parsear, usar mensagem padrão
                        }
                    }

                    if (produtosContainer) {
                        produtosContainer.innerHTML = `
                            <div class="alert alert-danger m-3">
                                <i class="bi bi-exclamation-triangle me-2"></i>
                                ${errorMessage}
                            </div>
                        `;
                    }
                }
            });
        }

        // Busca dinâmica ao digitar (com debounce)
        if (searchInput) {
            searchInput.addEventListener('input', function () {
                clearTimeout(searchTimeout);
                searchTimeout = setTimeout(function () {
                    realizarBusca();
                }, 500); // Aguarda 500ms após parar de digitar
            });

            // Buscar ao pressionar Enter
            searchInput.addEventListener('keypress', function (e) {
                if (e.key === 'Enter') {
                    e.preventDefault();
                    clearTimeout(searchTimeout);
                    realizarBusca();
                }
            });
        }

        // Buscar ao mudar filtros
        if (typeFilter) {
            typeFilter.addEventListener('change', function () {
                realizarBusca();
            });
        }

        if (empresaFilter) {
            empresaFilter.addEventListener('change', function () {
                realizarBusca();
            });
        }

        // Manter o botão de busca funcionando (para compatibilidade)
        if (searchButton) {
            searchButton.addEventListener('click', function (e) {
                e.preventDefault();
                clearTimeout(searchTimeout);
                realizarBusca();
            });
        }
    })();
</script>

<style>
    /* Estilos para o Tutorial */
    .tutorial-container {
        max-height: 90vh !important;
    }

    .tutorial-popup {
        max-width: 90vw !important;
        max-height: 90vh !important;
        width: 90% !important;
    }

    .tutorial-popup .swal2-html-container {
        padding: 0;
        max-height: calc(90vh - 150px);
        overflow-y: auto;
    }

    .tutorial-popup .accordion-button {
        font-size: 0.95rem;
        font-weight: 600;
        padding: 0.75rem 1rem;
        background-color: #f8f9fa;
        border: 1px solid #dee2e6;
    }

    .tutorial-popup .accordion-button:not(.collapsed) {
        background-color: #e7f3ff;
        color: #0d6efd;
        border-color: #0d6efd;
    }

    .tutorial-popup .accordion-button:focus {
        box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
    }

    .tutorial-popup .accordion-body {
        padding: 1.25rem;
        background-color: #ffffff;
        border-left: 3px solid #0d6efd;
    }

    .tutorial-popup .accordion-item {
        border: 1px solid #dee2e6;
        border-radius: 8px;
        overflow: hidden;
        margin-bottom: 0.5rem;
    }

    .tutorial-popup .list-unstyled li {
        padding: 0.25rem 0;
        line-height: 1.6;
    }

    .tutorial-popup .alert {
        margin-top: 1rem;
        border-left: 4px solid;
    }

    .tutorial-popup .text-muted {
        font-size: 0.875rem;
    }

    .tutorial-popup .text-info {
        color: #0dcaf0 !important;
    }

    .tutorial-popup .text-success {
        color: #198754 !important;
    }

    .tutorial-popup .text-warning {
        color: #ffc107 !important;
    }

    .tutorial-popup .text-primary {
        color: #0d6efd !important;
    }

    /* Estilos para o modal de extrato de produto */
    .swal-extrato-produto {
        border-radius: 16px;
    }

    .swal-extrato-produto .swal2-html-container {
        padding: 0;
        max-height: 80vh;
        overflow-y: auto;
    }

    .swal-extrato-produto table {
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }

    .swal-extrato-produto table tbody tr:hover {
        background-color: #f8f9fa;
    }
</style>

<?php
$content = ob_get_clean();
$activeMenu = 'itens';
include ROOT_PATH . '/views/layouts/app.php';
?>