<?php
ob_start();

// Garantir que as variáveis necessárias estejam disponíveis para o form.php
$precosPorQuantidade = $precosPorQuantidade ?? [];
$tabelasPrecoProduto = $tabelasPrecoProduto ?? [];
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-box-seam me-2"></i> Novo Item</h2>
        <p class="text-muted">Cadastre um novo produto, serviço ou patrimônio</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/itens') ?>" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left me-2"></i> Voltar
        </a>
    </div>
</div>

<form id="formProduto" method="POST" action="<?= url('/itens/criar') ?>" enctype="multipart/form-data">
    <?php include __DIR__ . '/../produtos/form.php'; ?>

    <div class="row mt-4">
        <div class="col-12">
            <button type="submit" class="btn btn-primary btn-lg">
                <i class="bi bi-check-circle me-2"></i> Salvar Item
            </button>
            <a href="<?= url('/itens') ?>" class="btn btn-outline-secondary btn-lg ms-2">
                <i class="bi bi-x-circle me-2"></i> Cancelar
            </a>
        </div>
    </div>
</form>

<script>
    (function aguardarJQuery() {
        if (typeof jQuery === 'undefined') {
            setTimeout(aguardarJQuery, 100);
            return;
        }

        $(document).ready(function () {
            $('#formProduto').on('submit', function (e) {
                e.preventDefault();

                // Atualizar empresas vinculadas antes de enviar
                if (typeof atualizarEmpresasVinculadasProduto === 'function') {
                    atualizarEmpresasVinculadasProduto();
                }

                // Atualizar campo hidden com empresas selecionadas
                const empresasInput = $('#empresas_vinculadas_produto_input');
                if (empresasInput.length > 0) {
                    const empresasSelecionadas = [];
                    $('.empresa-produto-checkbox:checked').each(function () {
                        empresasSelecionadas.push(parseInt($(this).val()));
                    });
                    empresasInput.val(JSON.stringify(empresasSelecionadas));
                }

                const formData = new FormData(this);

                // Debug: verificar se grupo_tributacao_id está sendo enviado
                const grupoTributacaoId = $('#grupo_tributacao_id').val();
                console.log('grupo_tributacao_id no formulário:', grupoTributacaoId);
                if (grupoTributacaoId) {
                    formData.set('grupo_tributacao_id', grupoTributacaoId);
                    console.log('grupo_tributacao_id adicionado ao FormData:', grupoTributacaoId);
                } else {
                    console.log('grupo_tributacao_id está vazio ou não encontrado');
                }

                // Garantir checkboxes não marcados
                $('input[type="checkbox"]').each(function () {
                    if (!$(this).is(':checked')) {
                        formData.append($(this).attr('name'), '0');
                    }
                });

                $.ajax({
                    url: appUrl('/itens/criar'),
                    type: 'POST',
                    data: formData,
                    processData: false,
                    contentType: false,
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Sucesso!',
                                text: response.message,
                                timer: 1500
                            }).then(() => {
                                const redirectPath = response.redirect || '/itens';
                                if (redirectPath.startsWith('http')) {
                                    window.location.href = redirectPath;
                                } else {
                                    window.location.href = appUrl(redirectPath);
                                }
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro!',
                                text: response.message
                            });
                        }
                    },
                    error: function (xhr) {
                        console.error('Erro:', xhr);
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro!',
                            text: 'Erro ao criar item. Verifique os dados.'
                        });
                    }
                });
            });
        });
    })();
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'itens';
include ROOT_PATH . '/views/layouts/app.php';
?>