<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item active">Gestão de Impostos</li>
            </ol>
        </nav>
        <h2><i class="bi bi-percent me-2"></i> Gestão de Impostos (Grupos Tributários)</h2>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="bi bi-list-ul me-2"></i> Lista de Grupos Tributários</h5>
                <div class="d-flex gap-2">
                    <button type="button" class="btn btn-outline-info" onclick="abrirTutorialImpostos()"
                        title="Tutorial do Módulo">
                        <i class="bi bi-question-circle me-2"></i> Tutorial
                    </button>
                    <button class="btn btn-outline-secondary" onclick="filtrarImpostos()">
                        <i class="bi bi-funnel"></i> Filtrar
                    </button>
                    <a href="<?= url('/impostos/criar') ?>" class="btn btn-primary">
                        <i class="bi bi-plus-circle me-2"></i> Novo Grupo Tributário
                    </a>
                </div>
            </div>
            <div class="card-body">
                <!-- Filtros -->
                <div class="row mb-3" id="filtrosImpostos" style="display: none;">
                    <div class="col-md-4">
                        <label for="filtroNome" class="form-label">Nome</label>
                        <input type="text" class="form-control" id="filtroNome" placeholder="Buscar por nome...">
                    </div>
                    <div class="col-md-3">
                        <label for="filtroStatus" class="form-label">Status</label>
                        <select class="form-select" id="filtroStatus">
                            <option value="">Todos</option>
                            <option value="Sim">Ativos</option>
                            <option value="Não">Inativos</option>
                        </select>
                    </div>
                </div>

                <!-- Tabela -->
                <div class="table-responsive">
                    <table class="table table-hover table-sm" id="tabelaImpostos">
                        <thead class="table-light">
                            <tr>
                                <th>Nome do Grupo</th>
                                <th>Status</th>
                                <th width="150">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($impostos)): ?>
                                <?php foreach ($impostos as $imposto): ?>
                                    <tr>
                                        <td>
                                            <strong><?= htmlspecialchars($imposto['nome']) ?></strong>
                                            <?php if ($imposto['ncm']): ?>
                                                <br><small class="text-muted">NCM: <?= htmlspecialchars($imposto['ncm']) ?></small>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <span class="badge bg-<?= $imposto['ativo'] === 'Sim' ? 'success' : 'danger' ?>">
                                                <?= $imposto['ativo'] === 'Sim' ? 'Ativo' : 'Inativo' ?>
                                            </span>
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-sm" role="group">
                                                <button class="btn btn-outline-info"
                                                    onclick="clonarImposto('<?= $imposto['hash_imposto'] ?>', '<?= $imposto['uf_origem'] ?>')"
                                                    title="Clonar para outro estado">
                                                    <i class="bi bi-files"></i>
                                                </button>
                                                <a href="<?= url('/impostos/editar?id=' . $imposto['id']) ?>"
                                                    class="btn btn-outline-primary" title="Editar">
                                                    <i class="bi bi-pencil"></i>
                                                </a>
                                                <button class="btn btn-outline-danger"
                                                    onclick="deletarImposto(<?= $imposto['id'] ?>)" title="Excluir">
                                                    <i class="bi bi-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="3" class="text-center text-muted py-4">
                                        <i class="bi bi-inbox display-6 d-block mb-2"></i>
                                        Nenhum grupo tributário cadastrado
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal Clonar -->
<div class="modal fade" id="modalClonar" tabindex="-1">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Clonar para qual estado?</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="d-grid gap-2">
                    <button type="button" class="btn btn-primary" onclick="abrirModalSelecionarEstado()">
                        <i class="bi bi-map-marker"></i> Escolher Estado
                    </button>
                    <button type="button" class="btn btn-success" onclick="clonarParaTodos()">
                        <i class="bi bi-globe"></i> Todos os Estados
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal Selecionar Estado -->
<div class="modal fade" id="modalSelecionarEstado" tabindex="-1">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Selecione o Estado</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <select class="form-select" id="estadoSelecionado">
                    <option value="">Selecione um estado</option>
                    <option value="AC">AC - Acre</option>
                    <option value="AL">AL - Alagoas</option>
                    <option value="AP">AP - Amapá</option>
                    <option value="AM">AM - Amazonas</option>
                    <option value="BA">BA - Bahia</option>
                    <option value="CE">CE - Ceará</option>
                    <option value="DF">DF - Distrito Federal</option>
                    <option value="ES">ES - Espírito Santo</option>
                    <option value="GO">GO - Goiás</option>
                    <option value="MA">MA - Maranhão</option>
                    <option value="MT">MT - Mato Grosso</option>
                    <option value="MS">MS - Mato Grosso do Sul</option>
                    <option value="MG">MG - Minas Gerais</option>
                    <option value="PA">PA - Pará</option>
                    <option value="PB">PB - Paraíba</option>
                    <option value="PR">PR - Paraná</option>
                    <option value="PE">PE - Pernambuco</option>
                    <option value="PI">PI - Piauí</option>
                    <option value="RJ">RJ - Rio de Janeiro</option>
                    <option value="RN">RN - Rio Grande do Norte</option>
                    <option value="RS">RS - Rio Grande do Sul</option>
                    <option value="RO">RO - Rondônia</option>
                    <option value="RR">RR - Roraima</option>
                    <option value="SC">SC - Santa Catarina</option>
                    <option value="SP">SP - São Paulo</option>
                    <option value="SE">SE - Sergipe</option>
                    <option value="TO">TO - Tocantins</option>
                </select>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary btn-sm"
                    onclick="confirmarClonagemEstado()">Confirmar</button>
            </div>
        </div>
    </div>
</div>

<script>
    let hashImpostoParaClonar = null;
    let ufOrigemParaClonar = null;

    $(document).ready(function () {
        // Filtros
        $('#filtroNome, #filtroStatus').on('change keyup', function () {
            filtrarTabela();
        });
    });

    function filtrarImpostos() {
        $('#filtrosImpostos').toggle();
    }

    function filtrarTabela() {
        const nome = $('#filtroNome').val().toLowerCase();
        const uf = $('#filtroUF').val();
        const status = $('#filtroStatus').val();

        $('#tabelaImpostos tbody tr').each(function () {
            const $row = $(this);
            const nomeRow = $row.find('td:nth-child(1)').text().toLowerCase();
            const statusRow = $row.find('td:nth-child(2) .badge').text();

            const matchNome = !nome || nomeRow.includes(nome);
            // Filtro de UF removido pois a coluna foi removida
            const matchStatus = !status || (status === 'Sim' && statusRow === 'Ativo') || (status === 'Não' && statusRow === 'Inativo');

            $row.toggle(matchNome && matchStatus);
        });
    }

    function clonarImposto(hash, ufOrigem) {
        hashImpostoParaClonar = hash;
        ufOrigemParaClonar = ufOrigem;
        $('#modalClonar').modal('show');
    }

    function abrirModalSelecionarEstado() {
        $('#modalClonar').modal('hide');
        $('#modalSelecionarEstado').modal('show');
    }

    function confirmarClonagemEstado() {
        const estadoSelecionado = $('#estadoSelecionado').val();
        if (!estadoSelecionado) {
            Swal.fire({
                icon: 'error',
                title: 'Erro!',
                text: 'Por favor, selecione um estado.'
            });
            return;
        }

        $('#modalSelecionarEstado').modal('hide');

        $.ajax({
            url: appUrl('/impostos/clonar'),
            type: 'POST',
            data: {
                hash_imposto: hashImpostoParaClonar,
                uf_origem: ufOrigemParaClonar,
                estado: estadoSelecionado
            },
            dataType: 'json',
            success: function (response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Sucesso!',
                        text: response.message
                    }).then(() => {
                        location.reload();
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: response.message
                    });
                }
            },
            error: function () {
                Swal.fire({
                    icon: 'error',
                    title: 'Erro!',
                    text: 'Ocorreu um erro ao clonar o imposto.'
                });
            }
        });
    }

    function clonarParaTodos() {
        Swal.fire({
            title: 'Confirmar clonagem',
            text: 'Deseja clonar este imposto para todos os estados?',
            icon: 'question',
            showCancelButton: true,
            confirmButtonText: 'Sim, clonar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                $('#modalClonar').modal('hide');

                $.ajax({
                    url: appUrl('/impostos/clonar'),
                    type: 'POST',
                    data: {
                        hash_imposto: hashImpostoParaClonar,
                        uf_origem: ufOrigemParaClonar,
                        todos_estados: true
                    },
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Sucesso!',
                                text: response.message
                            }).then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire({
                                icon: 'info',
                                title: 'Atenção',
                                text: response.message
                            });
                        }
                    },
                    error: function () {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro!',
                            text: 'Ocorreu um erro ao clonar o imposto.'
                        });
                    }
                });
            }
        });
    }

    function deletarImposto(id) {
        Swal.fire({
            title: 'Confirmar Exclusão',
            text: 'Tem certeza que deseja excluir este grupo tributário?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#dc3545',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Sim, excluir!',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: appUrl('/impostos/deletar'),
                    type: 'POST',
                    data: { id: id },
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Sucesso!',
                                text: response.message,
                                showConfirmButton: false,
                                timer: 1500
                            }).then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro',
                                text: response.message
                            });
                        }
                    },
                    error: function () {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro',
                            text: 'Erro ao excluir grupo tributário'
                        });
                    }
                });
            }
        });
    }

    // Função para abrir tutorial do módulo de Gestão de Impostos
    function abrirTutorialImpostos() {
        Swal.fire({
            title: '<i class="bi bi-percent text-primary"></i> Tutorial Completo: Gestão de Impostos',
            html: `
            <div class="text-start" style="max-height: 70vh; overflow-y: auto;">
                <div class="mb-4">
                    <h5 class="text-primary mb-3"><i class="bi bi-info-circle me-2"></i>Visão Geral</h5>
                    <p class="text-muted">O módulo de Gestão de Impostos permite criar e gerenciar grupos tributários com configurações específicas por estado (UF), facilitando o cálculo correto de impostos em operações fiscais.</p>
                </div>

                <div class="accordion" id="tutorialAccordionImpostos">
                    <!-- O QUE SÃO GRUPOS TRIBUTÁRIOS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#oQueSaoGruposTributarios">
                                <i class="bi bi-question-circle me-2"></i> <strong>1. O que são Grupos Tributários?</strong>
                            </button>
                        </h2>
                        <div id="oQueSaoGruposTributarios" class="accordion-collapse collapse show" data-bs-parent="#tutorialAccordionImpostos">
                            <div class="accordion-body">
                                <p class="mb-3">Grupos Tributários são configurações que definem como os impostos serão calculados para produtos ou serviços, considerando:</p>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-check-circle text-success me-2"></i><strong>Estado de Origem:</strong> Estado onde a mercadoria é produzida/armazenada</li>
                                    <li><i class="bi bi-check-circle text-success me-2"></i><strong>Estado de Destino:</strong> Estado para onde a mercadoria será enviada</li>
                                    <li><i class="bi bi-check-circle text-success me-2"></i><strong>Regime Tributário:</strong> Simples Nacional, Lucro Presumido, etc.</li>
                                    <li><i class="bi bi-check-circle text-success me-2"></i><strong>Tipo de Operação:</strong> Venda dentro do estado, fora do estado, etc.</li>
                                </ul>
                                <div class="alert alert-info mt-3">
                                    <i class="bi bi-lightbulb me-2"></i>
                                    <small><strong>Exemplo:</strong> Um produto pode ter alíquotas diferentes de ICMS dependendo se é vendido dentro do mesmo estado (SP → SP) ou para outro estado (SP → RJ).</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- ESTRUTURA DO MÓDULO -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#estruturaModulo">
                                <i class="bi bi-diagram-3 me-2"></i> <strong>2. Estrutura do Módulo</strong>
                            </button>
                        </h2>
                        <div id="estruturaModulo" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionImpostos">
                            <div class="accordion-body">
                                <p class="mb-3">O módulo funciona em duas etapas principais:</p>

                                <h6 class="text-primary mb-3"><i class="bi bi-card-heading me-2"></i>1. Grupo Básico</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Nome do Grupo:</strong> Identificação do grupo tributário
                                        <br><small class="text-muted">Exemplo: "Simples Nacional - Eletrônicos", "Lucro Presumido - Alimentos"</small>
                                    </li>
                                    <li><strong>Empresa:</strong> Vincula o grupo a uma empresa específica (opcional)
                                        <br><small class="text-muted">Se deixar vazio, o grupo fica disponível para todas as empresas</small>
                                    </li>
                                    <li><strong>NCM:</strong> Nomenclatura Comum do Mercosul (opcional)
                                        <br><small class="text-muted">Código de 8 dígitos que classifica a mercadoria</small>
                                    </li>
                                    <li><strong>CEST:</strong> Código Especificador da Substituição Tributária (opcional)
                                        <br><small class="text-muted">Usado para produtos sujeitos à substituição tributária</small>
                                    </li>
                                    <li><strong>IBPT:</strong> Índice de carga tributária (opcional)
                                        <br><small class="text-muted">Percentual médio de impostos sobre o produto</small>
                                    </li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-geo-alt me-2"></i>2. Configurações por UF</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Múltiplas Configurações:</strong> Um grupo pode ter várias configurações, uma para cada UF de origem</li>
                                    <li><strong>Configuração Específica:</strong> Cada configuração define impostos para operações dentro e fora do estado</li>
                                    <li><strong>Clonagem:</strong> Você pode clonar uma configuração para outros estados</li>
                                </ul>

                                <div class="alert alert-success mt-3">
                                    <i class="bi bi-lightbulb me-2"></i>
                                    <small><strong>Dica:</strong> Primeiro salve o grupo básico, depois adicione as configurações por UF.</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- IMPOSTOS EXPLICADOS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#impostosExplicados">
                                <i class="bi bi-cash-stack me-2"></i> <strong>3. Impostos Explicados</strong>
                            </button>
                        </h2>
                        <div id="impostosExplicados" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionImpostos">
                            <div class="accordion-body">
                                <h6 class="text-success mb-3"><i class="bi bi-geo-alt me-2"></i>ICMS (Imposto sobre Circulação de Mercadorias e Serviços)</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>O que é:</strong> Imposto estadual sobre a circulação de mercadorias</li>
                                    <li><strong>CST/CSOSN:</strong> Código de Situação Tributária que define como o ICMS será calculado
                                        <br><small class="text-muted">CST: Para empresas do regime normal | CSOSN: Para Simples Nacional</small>
                                    </li>
                                    <li><strong>Alíquota ICMS:</strong> Percentual do imposto (ex: 18%, 12%, 7%)</li>
                                    <li><strong>Modalidade BC:</strong> Como a base de cálculo será calculada</li>
                                    <li><strong>Origem Mercadoria:</strong> Se é nacional, estrangeira, importada, etc.</li>
                                    <li><strong>CFOP:</strong> Código Fiscal de Operações e Prestações</li>
                                </ul>

                                <h6 class="text-warning mb-3"><i class="bi bi-arrow-left-right me-2"></i>ICMS ST (Substituição Tributária)</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>O que é:</strong> ICMS cobrado antecipadamente pelo remetente</li>
                                    <li><strong>Quando usar:</strong> Para produtos sujeitos à substituição tributária</li>
                                    <li><strong>MVA:</strong> Margem de Valor Agregado - percentual usado no cálculo</li>
                                    <li><strong>Alíquota ICMS ST:</strong> Percentual do imposto de substituição tributária</li>
                                    <li><strong>UF Destino:</strong> Estado para onde a mercadoria será enviada</li>
                                </ul>

                                <h6 class="text-info mb-3"><i class="bi bi-box-seam me-2"></i>IPI (Imposto sobre Produtos Industrializados)</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>O que é:</strong> Imposto federal sobre produtos industrializados</li>
                                    <li><strong>CST IPI:</strong> Código de Situação Tributária do IPI</li>
                                    <li><strong>Alíquota IPI:</strong> Percentual do imposto (ex: 10%, 15%)</li>
                                    <li><strong>Classe Enquadramento:</strong> Se é nacional, importado, etc.</li>
                                    <li><strong>Código Enquadramento:</strong> Código específico de enquadramento fiscal</li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-cash me-2"></i>PIS (Programa de Integração Social)</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>O que é:</strong> Contribuição social federal</li>
                                    <li><strong>CST PIS:</strong> Código de Situação Tributária do PIS</li>
                                    <li><strong>Alíquota PIS:</strong> Percentual do imposto (ex: 1,65%)</li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-cash-stack me-2"></i>COFINS (Contribuição para Financiamento da Seguridade Social)</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>O que é:</strong> Contribuição social federal</li>
                                    <li><strong>CST COFINS:</strong> Código de Situação Tributária da COFINS</li>
                                    <li><strong>Alíquota COFINS:</strong> Percentual do imposto (ex: 7,60%)</li>
                                    <li><strong>Natureza Receita:</strong> Tipo de receita (vendas, serviços, etc.)</li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- CAMPOS DO FORMULÁRIO -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#camposFormulario">
                                <i class="bi bi-card-text me-2"></i> <strong>4. Campos do Formulário</strong>
                            </button>
                        </h2>
                        <div id="camposFormulario" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionImpostos">
                            <div class="accordion-body">
                                <h6 class="text-primary mb-3"><i class="bi bi-card-heading me-2"></i>Grupo Básico</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Empresa *:</strong> Selecione a empresa (ou deixe "Todas as Empresas")</li>
                                    <li><strong>Nome do Grupo *:</strong> Nome identificador do grupo (obrigatório)</li>
                                    <li><strong>Status:</strong> Ativo ou Inativo</li>
                                    <li><strong>NCM:</strong> Código de 8 dígitos (formato: 0000.00.00)</li>
                                    <li><strong>CEST:</strong> Código de 7 dígitos (formato: 00.000.00)</li>
                                    <li><strong>IBPT (%):</strong> Percentual de carga tributária</li>
                                    <li><strong>Atividade SPED:</strong> Atividade econômica para SPED</li>
                                    <li><strong>Gênero Produto:</strong> Classificação do produto</li>
                                </ul>

                                <h6 class="text-success mb-3"><i class="bi bi-geo-alt me-2"></i>Dentro do Estado (ICMS)</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>UF Origem *:</strong> Estado de origem da mercadoria (obrigatório)</li>
                                    <li><strong>CST/CSOSN:</strong> Código de Situação Tributária</li>
                                    <li><strong>Alíquota ICMS (%):</strong> Percentual do ICMS</li>
                                    <li><strong>Modalidade BC ICMS:</strong> Como calcular a base de cálculo</li>
                                    <li><strong>Origem Mercadoria:</strong> Nacional, estrangeira, etc.</li>
                                    <li><strong>Desoneração ICMS:</strong> Motivo da desoneração (se aplicável)</li>
                                    <li><strong>Redução BC (%):</strong> Percentual de redução da base de cálculo</li>
                                    <li><strong>FCP (%):</strong> Fundo de Combate à Pobreza</li>
                                    <li><strong>CFOP:</strong> Código Fiscal de Operações</li>
                                    <li><strong>Pauta ICMS (R$):</strong> Valor fixo da pauta (se aplicável)</li>
                                </ul>

                                <h6 class="text-warning mb-3"><i class="bi bi-arrow-left-right me-2"></i>Fora do Estado (ICMS ST)</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>UF Destino:</strong> Estado de destino da mercadoria</li>
                                    <li><strong>CST ST:</strong> Código de Situação Tributária para ST</li>
                                    <li><strong>Alíquota ICMS ST (%):</strong> Percentual do ICMS ST</li>
                                    <li><strong>MVA (%):</strong> Margem de Valor Agregado</li>
                                    <li><strong>Modalidade BC ICMS ST:</strong> Como calcular a base de cálculo do ST</li>
                                    <li><strong>Redução BC ST (%):</strong> Percentual de redução da base de cálculo ST</li>
                                    <li><strong>FCP ST (%):</strong> Fundo de Combate à Pobreza para ST</li>
                                    <li><strong>CFOP ST:</strong> Código Fiscal de Operações para ST</li>
                                </ul>

                                <h6 class="text-info mb-3"><i class="bi bi-box-seam me-2"></i>IPI</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>CST IPI:</strong> Código de Situação Tributária do IPI</li>
                                    <li><strong>Alíquota IPI (%):</strong> Percentual do IPI</li>
                                    <li><strong>Classe Enquadramento:</strong> Nacional, importado, etc.</li>
                                    <li><strong>Código Enquadramento:</strong> Código específico de enquadramento</li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-cash-stack me-2"></i>PIS / COFINS</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>CST PIS:</strong> Código de Situação Tributária do PIS</li>
                                    <li><strong>Alíquota PIS (%):</strong> Percentual do PIS</li>
                                    <li><strong>CST COFINS:</strong> Código de Situação Tributária da COFINS</li>
                                    <li><strong>Alíquota COFINS (%):</strong> Percentual da COFINS</li>
                                    <li><strong>Natureza Receita:</strong> Tipo de receita (vendas, serviços, etc.)</li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- COMO USAR -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#comoUsar">
                                <i class="bi bi-play-circle me-2"></i> <strong>5. Como Usar</strong>
                            </button>
                        </h2>
                        <div id="comoUsar" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionImpostos">
                            <div class="accordion-body">
                                <h6 class="text-success mb-3"><i class="bi bi-plus-circle me-2"></i>Criando um Grupo Tributário</h6>
                                <ol class="ms-3 mb-3">
                                    <li>Clique em "Novo Grupo Tributário"</li>
                                    <li>Preencha o <strong>Nome do Grupo</strong> (obrigatório)</li>
                                    <li>Selecione a <strong>Empresa</strong> (ou deixe "Todas as Empresas")</li>
                                    <li>Preencha os campos opcionais (NCM, CEST, IBPT, etc.)</li>
                                    <li>Clique em "Salvar Grupo"</li>
                                    <li>Após salvar, você poderá adicionar configurações por UF</li>
                                </ol>

                                <h6 class="text-primary mb-3"><i class="bi bi-geo-alt me-2"></i>Adicionando Configuração por UF</h6>
                                <ol class="ms-3 mb-3">
                                    <li>Após salvar o grupo básico, preencha os campos de configuração</li>
                                    <li>Selecione a <strong>UF Origem</strong> (obrigatório)</li>
                                    <li>Preencha os campos de ICMS (Dentro do Estado)</li>
                                    <li>Se necessário, preencha os campos de ICMS ST (Fora do Estado)</li>
                                    <li>Preencha os campos de IPI, PIS e COFINS</li>
                                    <li>Clique em "Adicionar Imposto"</li>
                                    <li>A configuração será salva e aparecerá na lista abaixo</li>
                                </ol>

                                <h6 class="text-info mb-3"><i class="bi bi-files me-2"></i>Clonando Configurações</h6>
                                <p class="ms-3 mb-3">Para evitar preencher manualmente cada estado, você pode clonar uma configuração:</p>
                                <ol class="ms-3 mb-3">
                                    <li>Na lista de configurações, clique no ícone de clonar (📋)</li>
                                    <li>Escolha uma opção:
                                        <ul>
                                            <li><strong>Escolher Estado Específico:</strong> Clona para um estado escolhido</li>
                                            <li><strong>Clonar para Todos os Estados:</strong> Clona para todos os estados de uma vez</li>
                                        </ul>
                                    </li>
                                    <li>Confirme a clonagem</li>
                                    <li>As configurações clonadas aparecerão na lista</li>
                                </ol>

                                <h6 class="text-warning mb-3"><i class="bi bi-pencil me-2"></i>Editando um Grupo</h6>
                                <ol class="ms-3 mb-3">
                                    <li>Na lista de grupos, clique no ícone de editar (✏️)</li>
                                    <li>Modifique os campos desejados</li>
                                    <li>Salve as alterações</li>
                                    <li>Você pode adicionar, editar ou excluir configurações por UF</li>
                                </ol>

                                <h6 class="text-danger mb-3"><i class="bi bi-trash me-2"></i>Excluindo Configurações</h6>
                                <ol class="ms-3 mb-3">
                                    <li>Na lista de configurações, clique no ícone de excluir (🗑️)</li>
                                    <li>Confirme a exclusão</li>
                                    <li>A configuração será removida</li>
                                </ol>

                                <div class="alert alert-warning mt-3">
                                    <i class="bi bi-exclamation-triangle me-2"></i>
                                    <small><strong>Atenção:</strong> Ao excluir um grupo tributário, todas as configurações por UF também serão excluídas.</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- BOAS PRÁTICAS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#boasPraticas">
                                <i class="bi bi-lightbulb me-2"></i> <strong>6. Boas Práticas</strong>
                            </button>
                        </h2>
                        <div id="boasPraticas" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionImpostos">
                            <div class="accordion-body">
                                <h6 class="text-success mb-3"><i class="bi bi-check-circle me-2"></i>Nomenclatura</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Use nomes descritivos que identifiquem o grupo</li>
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Inclua informações relevantes (regime, tipo de produto, etc.)</li>
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Exemplos: "Simples Nacional - Eletrônicos", "Lucro Presumido - Alimentos"</li>
                                </ul>

                                <h6 class="text-info mb-3"><i class="bi bi-123 me-2"></i>Códigos (NCM, CEST)</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Preencha o NCM sempre que possível para maior precisão</li>
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Use o CEST para produtos sujeitos à substituição tributária</li>
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Verifique se os códigos estão corretos antes de salvar</li>
                                </ul>

                                <h6 class="text-warning mb-3"><i class="bi bi-shield-check me-2"></i>Validação</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Verifique as alíquotas com um contador antes de usar em produção</li>
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Certifique-se de que os CST/CSOSN estão corretos para seu regime tributário</li>
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Teste as configurações antes de aplicar em vendas reais</li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-files me-2"></i>Clonagem</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Use a clonagem para economizar tempo ao criar configurações similares</li>
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Após clonar, revise e ajuste as alíquotas específicas de cada estado</li>
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Nem todos os estados têm as mesmas alíquotas</li>
                                </ul>

                                <h6 class="text-danger mb-3"><i class="bi bi-archive me-2"></i>Organização</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-danger me-2"></i>Mantenha grupos organizados por tipo de produto ou regime</li>
                                    <li><i class="bi bi-arrow-right text-danger me-2"></i>Use o filtro para encontrar grupos rapidamente</li>
                                    <li><i class="bi bi-arrow-right text-danger me-2"></i>Desative grupos não utilizados em vez de excluir</li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- EXEMPLOS PRÁTICOS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#exemplos">
                                <i class="bi bi-book me-2"></i> <strong>7. Exemplos Práticos</strong>
                            </button>
                        </h2>
                        <div id="exemplos" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionImpostos">
                            <div class="accordion-body">
                                <h6 class="text-primary mb-3"><i class="bi bi-shop me-2"></i>Exemplo 1: Simples Nacional - Eletrônicos</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Grupo Básico:</strong>
                                        <br><small class="text-muted">Nome: "Simples Nacional - Eletrônicos"</small>
                                        <br><small class="text-muted">NCM: 8528.71.00 (Monitores)</small>
                                        <br><small class="text-muted">Status: Ativo</small>
                                    </li>
                                    <li><strong>Configuração SP (São Paulo):</strong>
                                        <br><small class="text-muted">UF Origem: SP</small>
                                        <br><small class="text-muted">CST/CSOSN: 101 (Tributada SN com crédito)</small>
                                        <br><small class="text-muted">ICMS: 12%</small>
                                        <br><small class="text-muted">PIS: 1,65% | COFINS: 7,60%</small>
                                    </li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-box-seam me-2"></i>Exemplo 2: Lucro Presumido - Alimentos</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Grupo Básico:</strong>
                                        <br><small class="text-muted">Nome: "Lucro Presumido - Alimentos"</small>
                                        <br><small class="text-muted">NCM: 1901.90.90 (Outros produtos alimentícios)</small>
                                        <br><small class="text-muted">Status: Ativo</small>
                                    </li>
                                    <li><strong>Configuração MG (Minas Gerais):</strong>
                                        <br><small class="text-muted">UF Origem: MG</small>
                                        <br><small class="text-muted">CST: 00 (Tributado Integralmente)</small>
                                        <br><small class="text-muted">ICMS: 18%</small>
                                        <br><small class="text-muted">ICMS ST: 12% (para vendas fora do estado)</small>
                                        <br><small class="text-muted">MVA: 40%</small>
                                    </li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-truck me-2"></i>Exemplo 3: Produto com Substituição Tributária</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Grupo Básico:</strong>
                                        <br><small class="text-muted">Nome: "ST - Bebidas"</small>
                                        <br><small class="text-muted">CEST: 03.001.00 (Bebidas alcoólicas)</small>
                                    </li>
                                    <li><strong>Configuração com ST:</strong>
                                        <br><small class="text-muted">UF Origem: SP | UF Destino: RJ</small>
                                        <br><small class="text-muted">ICMS: 18% (dentro do estado)</small>
                                        <br><small class="text-muted">ICMS ST: 25% (para RJ)</small>
                                        <br><small class="text-muted">MVA: 50%</small>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- USO EM PRODUTOS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#usoProdutos">
                                <i class="bi bi-box me-2"></i> <strong>8. Uso em Produtos</strong>
                            </button>
                        </h2>
                        <div id="usoProdutos" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionImpostos">
                            <div class="accordion-body">
                                <p class="mb-3">Os Grupos Tributários são vinculados aos produtos no cadastro de Itens:</p>

                                <h6 class="text-primary mb-3"><i class="bi bi-link me-2"></i>Vinculação</h6>
                                <p class="ms-3 mb-3">Ao cadastrar ou editar um produto, você pode selecionar um Grupo Tributário. O sistema usará as configurações desse grupo para calcular os impostos nas operações.</p>

                                <h6 class="text-info mb-3"><i class="bi bi-calculator me-2"></i>Cálculo Automático</h6>
                                <p class="ms-3 mb-3">Quando uma venda é realizada, o sistema:</p>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-check-circle text-success me-2"></i>Identifica o Grupo Tributário do produto</li>
                                    <li><i class="bi bi-check-circle text-success me-2"></i>Verifica a UF de origem e destino</li>
                                    <li><i class="bi bi-check-circle text-success me-2"></i>Aplica a configuração correspondente</li>
                                    <li><i class="bi bi-check-circle text-success me-2"></i>Calcula os impostos automaticamente</li>
                                </ul>

                                <div class="alert alert-info mt-3">
                                    <i class="bi bi-lightbulb me-2"></i>
                                    <small><strong>Dica:</strong> Certifique-se de que todos os produtos têm um Grupo Tributário vinculado para garantir o cálculo correto dos impostos.</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="alert alert-success mt-4">
                    <i class="bi bi-check-circle me-2"></i>
                    <strong>Pronto para começar!</strong> Agora você conhece todos os recursos do módulo de Gestão de Impostos e pode criar grupos tributários completos para seus produtos.
                </div>
            </div>
        `,
            width: '90%',
            heightAuto: false,
            confirmButtonText: 'Entendi, obrigado!',
            confirmButtonColor: '#0d6efd',
            icon: null,
            customClass: {
                popup: 'tutorial-popup',
                container: 'tutorial-container'
            }
        });
    }
</script>

<style>
    /* Estilos para o Tutorial */
    .tutorial-container {
        max-height: 90vh !important;
    }

    .tutorial-popup {
        max-width: 90vw !important;
        max-height: 90vh !important;
        width: 90% !important;
    }

    .tutorial-popup .swal2-html-container {
        padding: 0;
        max-height: calc(90vh - 150px);
        overflow-y: auto;
    }

    .tutorial-popup .accordion-button {
        font-size: 0.95rem;
        font-weight: 600;
        padding: 0.75rem 1rem;
        background-color: #f8f9fa;
        border: 1px solid #dee2e6;
    }

    .tutorial-popup .accordion-button:not(.collapsed) {
        background-color: #e7f3ff;
        color: #0d6efd;
        border-color: #0d6efd;
    }

    .tutorial-popup .accordion-button:focus {
        box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
    }

    .tutorial-popup .accordion-body {
        padding: 1.25rem;
        background-color: #ffffff;
        border-left: 3px solid #0d6efd;
    }

    .tutorial-popup .accordion-item {
        border: 1px solid #dee2e6;
        border-radius: 8px;
        overflow: hidden;
        margin-bottom: 0.5rem;
    }

    .tutorial-popup .list-unstyled li {
        padding: 0.25rem 0;
        line-height: 1.6;
    }

    .tutorial-popup .alert {
        margin-top: 1rem;
        border-left: 4px solid;
    }

    .tutorial-popup .text-muted {
        font-size: 0.875rem;
    }

    .tutorial-popup .text-info {
        color: #0dcaf0 !important;
    }

    .tutorial-popup .text-success {
        color: #198754 !important;
    }

    .tutorial-popup .text-warning {
        color: #ffc107 !important;
    }

    .tutorial-popup .text-primary {
        color: #0d6efd !important;
    }
</style>

<?php
$content = ob_get_clean();
$activeMenu = 'impostos';
include ROOT_PATH . '/views/layouts/app.php';
?>