<!-- ICMS - Dentro do Estado -->
<div class="row">
    <div class="col-12"><legend class="text-success"><i class="bi bi-geo-alt me-2"></i> Dentro do Estado</legend></div>
</div>
<div class="row">
    <div class="col-md-2">
        <div class="mb-3">
            <label for="uf_origem" class="form-label">UF Origem</label>
            <select name="uf_origem" id="uf_origem" class="form-select">
                <option value="">Selecione</option>
                <?php foreach ($estados as $estado): ?>
                    <option value="<?= $estado['codigo_uf'] ?>" <?= ($imposto['uf_origem'] ?? '') == $estado['codigo_uf'] ? 'selected' : '' ?>>
                        <?= $estado['codigo_uf'] ?> - <?= htmlspecialchars($estado['nome_estado']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
    </div>
    <div class="col-md-2">
        <div class="mb-3">
            <label for="cst_csosn" class="form-label">CST/CSOSN</label>
            <select class="form-select" id="cst_csosn" name="cst_csosn">
                <option value="">Selecione</option>
                <optgroup label="CST - Regime Normal">
                    <option value="00">00 - Tributada Integralmente</option>
                    <option value="10">10 - Tributada com ST</option>
                    <option value="20">20 - Com redução de base de cálculo</option>
                    <option value="30">30 - Isenta ou não tributada com cobrança do ICMS por substituição tributária</option>
                    <option value="40">40 - Isenta</option>
                    <option value="41">41 - Não tributada</option>
                    <option value="50">50 - Suspensão</option>
                    <option value="51">51 - Diferimento</option>
                    <option value="60">60 - ICMS cobrado anteriormente por substituição tributária</option>
                    <option value="70">70 - Com redução de base de cálculo e cobrança do ICMS por substituição tributária</option>
                    <option value="90">90 - Outras</option>
                </optgroup>
                <optgroup label="CSOSN - Simples Nacional">
                    <option value="101">101 - Tributada pelo Simples Nacional com permissão de crédito</option>
                    <option value="102">102 - Tributada pelo Simples Nacional sem permissão de crédito</option>
                    <option value="103">103 - Isenção do ICMS no Simples Nacional para faixa de receita bruta</option>
                    <option value="201">201 - Tributada pelo Simples Nacional com permissão de crédito e com cobrança do ICMS por substituição tributária</option>
                    <option value="202">202 - Tributada pelo Simples Nacional sem permissão de crédito e com cobrança do ICMS por substituição tributária</option>
                    <option value="203">203 - Isenção do ICMS no Simples Nacional para faixa de receita bruta e com cobrança do ICMS por substituição tributária</option>
                    <option value="300">300 - Imune</option>
                    <option value="400">400 - Não tributada pelo Simples Nacional</option>
                    <option value="500">500 - ICMS cobrado anteriormente por substituição tributária (substituído) ou por antecipação</option>
                    <option value="900">900 - Outros</option>
                </optgroup>
            </select>
        </div>
    </div>
    <div class="col-md-2">
        <div class="mb-3">
            <label for="icms" class="form-label">Alíquota ICMS (%)</label>
            <input type="text" class="form-control mascara-moeda" id="icms" name="icms" value="0,00" placeholder="18,00">
        </div>
    </div>
    <div class="col-md-2">
        <div class="mb-3">
            <label for="modalidade_bc_icms" class="form-label">Modalidade BC ICMS</label>
            <select class="form-select" id="modalidade_bc_icms" name="modalidade_bc_icms">
                <option value="0">0 - % sobre receita bruta</option>
                <option value="1">1 - % sobre BC da operação</option>
                <option value="2">2 - Valor fixo por unidade</option>
            </select>
        </div>
    </div>
    <div class="col-md-2">
        <div class="mb-3">
            <label for="origem_mercadoria" class="form-label">Origem Mercadoria</label>
            <select class="form-select" id="origem_mercadoria" name="origem_mercadoria">
                <option value="0">0 - Nacional</option>
                <option value="1">1 - Estrangeira</option>
                <option value="2">2 - Estrangeira - Mercado interno</option>
                <option value="3">3 - Nacional - Importação direta</option>
                <option value="4">4 - Nacional - Por terceiros</option>
                <option value="5">5 - Nacional - Zona Franca Manaus</option>
                <option value="6">6 - Estrangeira - Importação com isenção</option>
                <option value="7">7 - Estrangeira - Mercado interno com isenção</option>
                <option value="8">8 - Nacional - Exportação</option>
            </select>
        </div>
    </div>
    <div class="col-md-2">
        <div class="mb-3">
            <label for="motivo_desicms" class="form-label">Desoneração ICMS</label>
            <select class="form-select" id="motivo_desicms" name="motivo_desicms">
                <option value="0">Não se aplica</option>
                <option value="1">1 - Táxi</option>
                <option value="2">2 - Deficiente Físico</option>
                <option value="3">3 - Produtor Agropecuário</option>
                <option value="4">4 - Frotista/Locadora</option>
                <option value="5">5 - Diplomático/Consular</option>
                <option value="6">6 - Amazônia Ocidental</option>
                <option value="7">7 - SUFRAMA</option>
                <option value="8">8 - Órgão Público</option>
                <option value="9">9 - Outros</option>
                <option value="10">10 - Deficiente Condutor</option>
                <option value="11">11 - Deficiente Não Condutor</option>
            </select>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-2">
        <div class="mb-3">
            <label for="reducao_bc" class="form-label">Redução BC (%)</label>
            <input type="text" class="form-control mascara-moeda" id="reducao_bc" name="reducao_bc" value="0,00" placeholder="0,00">
        </div>
    </div>
    <div class="col-md-2">
        <div class="mb-3">
            <label for="fcp" class="form-label">FCP (%)</label>
            <input type="text" class="form-control mascara-moeda" id="fcp" name="fcp" value="0,00" placeholder="2,00">
        </div>
    </div>
    <div class="col-md-2">
        <div class="mb-3">
            <label for="cfop" class="form-label">CFOP</label>
            <select name="cfop" id="cfop" class="form-select">
                <option value="">Selecione</option>
                <?php foreach ($cfops as $cfop): ?>
                    <option value="<?= $cfop['id'] ?>">
                        <?= $cfop['id'] ?> - <?= htmlspecialchars($cfop['descricao']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
    </div>
    <div class="col-md-2">
        <div class="mb-3">
            <label for="valor_pauta" class="form-label">Pauta ICMS (R$)</label>
            <input type="text" class="form-control mascara-moeda" id="valor_pauta" name="valor_pauta" value="0,00" placeholder="0,00">
        </div>
    </div>
</div>

<!-- Fora do Estado -->
<div class="row">
    <div class="col-12"><legend class="text-warning"><i class="bi bi-arrow-left-right me-2"></i> Fora do Estado</legend></div>
</div>
<div class="row">
    <div class="col-md-2">
        <div class="mb-3">
            <label for="uf_destino" class="form-label">UF Destino</label>
            <select name="uf_destino" id="uf_destino" class="form-select">
                <option value="">Selecione</option>
                <?php foreach ($estados as $estado): ?>
                    <option value="<?= $estado['codigo_uf'] ?>">
                        <?= $estado['codigo_uf'] ?> - <?= htmlspecialchars($estado['nome_estado']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
    </div>
    <div class="col-md-2">
        <div class="mb-3">
            <label for="cst_csosn_st" class="form-label">CST ST</label>
            <select class="form-select" id="cst_csosn_st" name="cst_csosn_st">
                <option value="">Selecione</option>
                <optgroup label="CST - Regime Normal">
                    <option value="10">10 - Tributada com ST</option>
                    <option value="30">30 - Isenta ou não tributada com cobrança do ICMS por substituição tributária</option>
                    <option value="60">60 - ICMS cobrado anteriormente por substituição tributária</option>
                    <option value="70">70 - Com redução de base de cálculo e cobrança do ICMS por substituição tributária</option>
                </optgroup>
                <optgroup label="CSOSN - Simples Nacional">
                    <option value="201">201 - Tributada pelo Simples Nacional com permissão de crédito e com cobrança do ICMS por substituição tributária</option>
                    <option value="202">202 - Tributada pelo Simples Nacional sem permissão de crédito e com cobrança do ICMS por substituição tributária</option>
                    <option value="203">203 - Isenção do ICMS no Simples Nacional para faixa de receita bruta e com cobrança do ICMS por substituição tributária</option>
                    <option value="500">500 - ICMS cobrado anteriormente por substituição tributária (substituído) ou por antecipação</option>
                </optgroup>
            </select>
        </div>
    </div>
    <div class="col-md-2">
        <div class="mb-3">
            <label for="icms_st" class="form-label">Alíquota ICMS ST (%)</label>
            <input type="text" class="form-control mascara-moeda" id="icms_st" name="icms_st" value="0,00" placeholder="12,00">
        </div>
    </div>
    <div class="col-md-2">
        <div class="mb-3">
            <label for="mva" class="form-label">MVA (%)</label>
            <input type="text" class="form-control mascara-moeda" id="mva" name="mva" value="0,00" placeholder="40,00">
        </div>
    </div>
    <div class="col-md-2">
        <div class="mb-3">
            <label for="modalidade_bc_icms_st" class="form-label">Modalidade BC ICMS ST</label>
            <select class="form-select" id="modalidade_bc_icms_st" name="modalidade_bc_icms_st">
                <option value="0">0 - % receita bruta</option>
                <option value="1">1 - % BC operação</option>
                <option value="2">2 - Valor fixo</option>
                <option value="3">3 - Valor operação</option>
                <option value="4">4 - Valor operação + tributos</option>
            </select>
        </div>
    </div>
    <div class="col-md-2">
        <div class="mb-3">
            <label for="reducao_bc_st" class="form-label">Redução BC ST (%)</label>
            <input type="text" class="form-control mascara-moeda" id="reducao_bc_st" name="reducao_bc_st" value="0,00" placeholder="0,00">
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-2">
        <div class="mb-3">
            <label for="fcp_st" class="form-label">FCP ST (%)</label>
            <input type="text" class="form-control mascara-moeda" id="fcp_st" name="fcp_st" value="0,00" placeholder="0,00">
        </div>
    </div>
    <div class="col-md-2">
        <div class="mb-3">
            <label for="cfop_st" class="form-label">CFOP ST</label>
            <select name="cfop_st" id="cfop_st" class="form-select">
                <option value="">Selecione</option>
                <?php foreach ($cfops as $cfop): ?>
                    <option value="<?= $cfop['id'] ?>">
                        <?= $cfop['id'] ?> - <?= htmlspecialchars($cfop['descricao']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
    </div>
</div>

<!-- IPI -->
<div class="row">
    <div class="col-12"><legend class="text-info"><i class="bi bi-box-seam me-2"></i> IPI</legend></div>
</div>
<div class="row">
    <div class="col-md-3">
        <div class="mb-3">
            <label for="cst_ipi" class="form-label">CST IPI</label>
            <select class="form-select" id="cst_ipi" name="cst_ipi">
                <option value="">Selecione</option>
                <option value="00">00 - Entrada com recuperação de crédito</option>
                <option value="01">01 - Entrada tributada com alíquota zero</option>
                <option value="02">02 - Entrada isenta</option>
                <option value="03">03 - Entrada não-tributada</option>
                <option value="04">04 - Entrada imune</option>
                <option value="05">05 - Entrada com suspensão</option>
                <option value="49">49 - Outras entradas</option>
                <option value="50">50 - Saída tributada</option>
                <option value="51">51 - Saída tributada com alíquota zero</option>
                <option value="52">52 - Saída isenta</option>
                <option value="53">53 - Saída não-tributada</option>
                <option value="54">54 - Saída imune</option>
                <option value="55">55 - Saída com suspensão</option>
                <option value="99">99 - Outras saídas</option>
            </select>
        </div>
    </div>
    <div class="col-md-3">
        <div class="mb-3">
            <label for="ipi" class="form-label">Alíquota IPI (%)</label>
            <input type="text" class="form-control mascara-moeda" id="ipi" name="ipi" value="0,00" placeholder="10,00">
        </div>
    </div>
    <div class="col-md-3">
        <div class="mb-3">
            <label for="classe_enquadramento_ipi" class="form-label">Classe Enquadramento</label>
            <select class="form-select" id="classe_enquadramento_ipi" name="classe_enquadramento_ipi">
                <option value="">Selecione</option>
                <option value="01">01 - Nacional (fabricado no Brasil)</option>
                <option value="02">02 - Importado (origem estrangeira)</option>
                <option value="03">03 - Outros</option>
                <option value="99">99 - Não se aplica</option>
            </select>
        </div>
    </div>
    <div class="col-md-3">
        <div class="mb-3">
            <label for="enquadramento_ipi" class="form-label">Código Enquadramento</label>
            <select class="form-select" id="enquadramento_ipi" name="enquadramento_ipi">
                <option value="">Selecione</option>
                <option value="00">00 - Enquadramento normal</option>
                <option value="01">01 - Fabricação BR, alíquota cheia</option>
                <option value="02">02 - Fabricação BR, alíquota zero</option>
                <option value="03">03 - Fabricação BR, isento</option>
                <option value="04">04 - Fabricação BR, imune</option>
                <option value="05">05 - Fabricação BR, com suspensão</option>
                <option value="49">49 - Outras situações</option>
                <option value="99">99 - Outras (não especificadas)</option>
            </select>
        </div>
    </div>
</div>

<!-- PIS / COFINS -->
<div class="row">
    <div class="col-12"><legend class="text-primary"><i class="bi bi-cash-stack me-2"></i> PIS / COFINS</legend></div>
</div>
<div class="row">
    <div class="col-md-2">
        <div class="mb-3">
            <label for="cst_pis" class="form-label">CST PIS</label>
            <select class="form-select" id="cst_pis" name="cst_pis">
                <option value="">Selecione</option>
                <option value="01">01 - Operação Tributável (Base de Cálculo = Valor da Operação Alíquota Normal (Cumulativo/Não Cumulativo))</option>
                <option value="02">02 - Operação Tributável (Base de Calculo = Valor da Operação (Alíquota Diferenciada))</option>
                <option value="03">03 - Operação Tributável (Base de Calculo = Quantidade Vendida x Alíquota por Unidade de Produto)</option>
                <option value="04">04 - Operação Tributável (Tributação Monofásica (Alíquota Zero))</option>
                <option value="05">05 - Operação Tributável por Substituição Tributária</option>
                <option value="06">06 - Operação Tributável (Alíquota Zero)</option>
                <option value="07">07 - Operação Isenta da Contribuição</option>
                <option value="08">08 - Operação Sem Incidência da Contribuição</option>
                <option value="09">09 - Operação com Suspensão da Contribuição</option>
                <option value="49">49 - Outras Operações de Saída</option>
                <option value="50">50 - Operação com Direito a Crédito - Vinculada Exclusivamente a Receita Tributada no Mercado Interno</option>
                <option value="51">51 - Operação com Direito a Crédito - Vinculada Exclusivamente a Receita Não Tributada no Mercado Interno</option>
                <option value="52">52 - Operação com Direito a Crédito - Vinculada Exclusivamente a Receita de Exportação</option>
                <option value="53">53 - Operação com Direito a Crédito - Vinculada a Receitas Tributadas e Não-Tributadas no Mercado Interno</option>
                <option value="54">54 - Operação com Direito a Crédito - Vinculada a Receitas Tributadas no Mercado Interno e de Exportação</option>
                <option value="55">55 - Operação com Direito a Crédito - Vinculada a Receitas Não-Tributadas no Mercado Interno e de Exportação</option>
                <option value="56">56 - Operação com Direito a Crédito - Vinculada a Receitas Tributadas e Não-Tributadas no Mercado Interno, e de Exportação</option>
                <option value="60">60 - Crédito Presumido - Operação de Aquisição Vinculada Exclusivamente a Receita Tributada no Mercado Interno</option>
                <option value="61">61 - Crédito Presumido - Operação de Aquisição Vinculada Exclusivamente a Receita Não-Tributada no Mercado Interno</option>
                <option value="62">62 - Crédito Presumido - Operação de Aquisição Vinculada Exclusivamente a Receita de Exportação</option>
                <option value="63">63 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas Tributadas e Não-Tributadas no Mercado Interno</option>
                <option value="64">64 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas Tributadas no Mercado Interno e de Exportação</option>
                <option value="65">65 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas Não-Tributadas no Mercado Interno e de Exportação</option>
                <option value="66">66 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas Tributadas e Não-Tributadas no Mercado Interno, e de Exportação</option>
                <option value="67">67 - Crédito Presumido - Outras Operações</option>
                <option value="70">70 - Operação de Aquisição sem Direito a Crédito</option>
                <option value="71">71 - Operação de Aquisição com Isenção</option>
                <option value="72">72 - Operação de Aquisição com Suspensão</option>
                <option value="73">73 - Operação de Aquisição a Alíquota Zero</option>
                <option value="74">74 - Operação de Aquisição sem Incidência da Contribuição</option>
                <option value="75">75 - Operação de Aquisição por Substituição Tributária</option>
                <option value="98">98 - Outras Operações de Entrada</option>
                <option value="99">99 - Outras Operações</option>
            </select>
        </div>
    </div>
    <div class="col-md-2">
        <div class="mb-3">
            <label for="pis" class="form-label">Alíquota PIS (%)</label>
            <input type="text" class="form-control mascara-moeda" id="pis" name="pis" value="0,00" placeholder="1,65">
        </div>
    </div>
    <div class="col-md-2">
        <div class="mb-3">
            <label for="cst_cofins" class="form-label">CST COFINS</label>
            <select id="cst_cofins" name="cst_cofins" class="form-select">
                <option value="">Selecione</option>
                <option value="01">01 - Operação Tributável (Base de Cálculo = Valor da Operação Alíquota Normal (Cumulativo/Não Cumulativo))</option>
                <option value="02">02 - Operação Tributável (Base de Calculo = Valor da Operação (Alíquota Diferenciada))</option>
                <option value="03">03 - Operação Tributável (Base de Calculo = Quantidade Vendida x Alíquota por Unidade de Produto)</option>
                <option value="04">04 - Operação Tributável (Tributação Monofásica (Alíquota Zero))</option>
                <option value="05">05 - Operação Tributável por Substituição Tributária</option>
                <option value="06">06 - Operação Tributável (Alíquota Zero)</option>
                <option value="07">07 - Operação Isenta da Contribuição</option>
                <option value="08">08 - Operação Sem Incidência da Contribuição</option>
                <option value="09">09 - Operação com Suspensão da Contribuição</option>
                <option value="49">49 - Outras Operações de Saída</option>
                <option value="50">50 - Operação com Direito a Crédito - Vinculada Exclusivamente a Receita Tributada no Mercado Interno</option>
                <option value="51">51 - Operação com Direito a Crédito - Vinculada Exclusivamente a Receita Não Tributada no Mercado Interno</option>
                <option value="52">52 - Operação com Direito a Crédito - Vinculada Exclusivamente a Receita de Exportação</option>
                <option value="53">53 - Operação com Direito a Crédito - Vinculada a Receitas Tributadas e Não-Tributadas no Mercado Interno</option>
                <option value="54">54 - Operação com Direito a Crédito - Vinculada a Receitas Tributadas no Mercado Interno e de Exportação</option>
                <option value="55">55 - Operação com Direito a Crédito - Vinculada a Receitas Não-Tributadas no Mercado Interno e de Exportação</option>
                <option value="56">56 - Operação com Direito a Crédito - Vinculada a Receitas Tributadas e Não-Tributadas no Mercado Interno, e de Exportação</option>
                <option value="60">60 - Crédito Presumido - Operação de Aquisição Vinculada Exclusivamente a Receita Tributada no Mercado Interno</option>
                <option value="61">61 - Crédito Presumido - Operação de Aquisição Vinculada Exclusivamente a Receita Não-Tributada no Mercado Interno</option>
                <option value="62">62 - Crédito Presumido - Operação de Aquisição Vinculada Exclusivamente a Receita de Exportação</option>
                <option value="63">63 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas Tributadas e Não-Tributadas no Mercado Interno</option>
                <option value="64">64 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas Tributadas no Mercado Interno e de Exportação</option>
                <option value="65">65 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas Não-Tributadas no Mercado Interno e de Exportação</option>
                <option value="66">66 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas Tributadas e Não-Tributadas no Mercado Interno, e de Exportação</option>
                <option value="67">67 - Crédito Presumido - Outras Operações</option>
                <option value="70">70 - Operação de Aquisição sem Direito a Crédito</option>
                <option value="71">71 - Operação de Aquisição com Isenção</option>
                <option value="72">72 - Operação de Aquisição com Suspensão</option>
                <option value="73">73 - Operação de Aquisição a Alíquota Zero</option>
                <option value="74">74 - Operação de Aquisição sem Incidência da Contribuição</option>
                <option value="75">75 - Operação de Aquisição por Substituição Tributária</option>
                <option value="98">98 - Outras Operações de Entrada</option>
                <option value="99">99 - Outras Operações</option>
            </select>
        </div>
    </div>
    <div class="col-md-2">
        <div class="mb-3">
            <label for="cofins" class="form-label">Alíquota COFINS (%)</label>
            <input type="text" class="form-control mascara-moeda" id="cofins" name="cofins" value="0,00" placeholder="7,60">
        </div>
    </div>
    <div class="col-md-4">
        <div class="mb-3">
            <label for="natureza_receita_pis_cofins" class="form-label">Natureza Receita PIS/COFINS</label>
            <select id="natureza_receita_pis_cofins" name="natureza_receita_pis_cofins" class="form-select">
                <option value="">Selecione</option>
                <option value="001">001 - Receita de vendas de mercadorias</option>
                <option value="002">002 - Receita de prestação de serviços</option>
                <option value="003">003 - Receita de vendas de bens do ativo imobilizado</option>
                <option value="004">004 - Receita de aluguel de bens</option>
                <option value="005">005 - Receita de vendas para o exterior</option>
                <option value="006">006 - Receita de serviços para o exterior</option>
                <option value="007">007 - Receita de vendas a não contribuintes do ICMS</option>
                <option value="008">008 - Receita de vendas no mercado interno, alíquota diferenciada</option>
                <option value="009">009 - Outras receitas</option>
            </select>
        </div>
    </div>
</div>

<!-- IBS / CBS -->
<div class="row">
    <div class="col-12"><legend class="text-primary"><i class="bi bi-calculator me-2"></i> IBS / CBS</legend></div>
</div>
<div class="row">
    <div class="col-md-3">
        <div class="mb-3">
            <label for="cclass" class="form-label">cClass</label>
            <input type="text" class="form-control" id="cclass" name="cclass" placeholder="Ex: 1.01.01">
            <small class="text-muted">Classificação fiscal</small>
        </div>
    </div>
    <div class="col-md-3">
        <div class="mb-3">
            <label for="aliquota_ibs" class="form-label">Alíquota IBS (%)</label>
            <input type="text" class="form-control mascara-moeda" id="aliquota_ibs" name="aliquota_ibs" value="0,00" placeholder="5,00">
        </div>
    </div>
    <div class="col-md-3">
        <div class="mb-3">
            <label for="reducao_aliquota_ibs" class="form-label">Redução Alíquota IBS (%)</label>
            <input type="text" class="form-control mascara-moeda" id="reducao_aliquota_ibs" name="reducao_aliquota_ibs" value="0,00" placeholder="0,00">
        </div>
    </div>
    <div class="col-md-3">
        <div class="mb-3">
            <label for="aliquota_cbs" class="form-label">Alíquota CBS (%)</label>
            <input type="text" class="form-control mascara-moeda" id="aliquota_cbs" name="aliquota_cbs" value="0,00" placeholder="3,00">
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-3">
        <div class="mb-3">
            <label for="reducao_aliquota_cbs" class="form-label">Redução Alíquota CBS (%)</label>
            <input type="text" class="form-control mascara-moeda" id="reducao_aliquota_cbs" name="reducao_aliquota_cbs" value="0,00" placeholder="0,00">
        </div>
    </div>
    <div class="col-md-3">
        <div class="mb-3">
            <label for="aliquota_ibs_municipal" class="form-label">Alíquota IBS Municipal (%)</label>
            <input type="text" class="form-control mascara-moeda" id="aliquota_ibs_municipal" name="aliquota_ibs_municipal" value="0,00" placeholder="2,00">
        </div>
    </div>
    <div class="col-md-3">
        <div class="mb-3">
            <label for="reducao_aliquota_ibs_municipal" class="form-label">Redução Alíquota IBS Municipal (%)</label>
            <input type="text" class="form-control mascara-moeda" id="reducao_aliquota_ibs_municipal" name="reducao_aliquota_ibs_municipal" value="0,00" placeholder="0,00">
        </div>
    </div>
</div>

<script>
// Inicializa máscaras para campos dentro do form
$(document).ready(function() {
    if (typeof initImpostosMasks === 'function') {
        initImpostosMasks();
    }
});
</script>
