<?php
ob_start();

// Salvar dados do imposto em variáveis separadas
$impostoData = $imposto; // Salva dados originais
$hash_imposto = $impostoData['hash_imposto'] ?? '';
$id_imposto = $impostoData['id'] ?? '';
$nome = $impostoData['nome'] ?? '';
$empresa = $impostoData['empresa'] ?? '';
$ncm = $impostoData['ncm'] ?? '';
$cest = $impostoData['cest'] ?? '';
$ibpt = $impostoData['ibpt'] ?? '';
$ativo = $impostoData['ativo'] ?? 'Sim';
$atividade_produto_sped = $impostoData['atividade_produto_sped'] ?? '';
$genero_produto_edoc = $impostoData['genero_produto_edoc'] ?? '';
?>

<div class="row mb-4">
    <div class="col-md-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?= url('/impostos') ?>">Grupos Tributários</a></li>
                <li class="breadcrumb-item active">Editar</li>
            </ol>
        </nav>
        <h2><i class="bi bi-pencil me-2"></i> Editar: <?= htmlspecialchars($nome) ?></h2>
    </div>
</div>

<input type="hidden" id="hash_imposto" name="hash_imposto" value="<?= htmlspecialchars($hash_imposto) ?>">
<input type="hidden" id="id_imposto" name="id_imposto" value="<?= htmlspecialchars($id_imposto) ?>">

<!-- Card: Informações Básicas do Grupo -->
<div class="card mb-3">
    <div class="card-header bg-primary text-white">
        <h6 class="mb-0"><i class="bi bi-info-circle me-2"></i> Informações Básicas do Grupo</h6>
    </div>
    <div class="card-body">
        <form id="formGrupoBasico">
            <div class="row">
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="empresa" class="form-label">Empresa</label>
                        <select name="empresa" id="empresa" class="form-select">
                            <option value="">Todas as Empresas</option>
                            <?php foreach ($empresas as $emp): ?>
                                <option value="<?= $emp['id'] ?>" <?= ($empresa) == $emp['id'] ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($emp['razao_social']) ?> | CNPJ: <?= htmlspecialchars($emp['cnpj']) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="nome" class="form-label">Nome do Grupo <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="nome" name="nome"
                               value="<?= htmlspecialchars($nome) ?>"
                               placeholder="Ex: Simples Nacional" required>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="mb-3">
                        <label for="ativo" class="form-label">Status</label>
                        <select name="ativo" id="ativo" class="form-select" required>
                            <option value="Sim" <?= $ativo === 'Sim' ? 'selected' : '' ?>>Ativo</option>
                            <option value="Não" <?= $ativo === 'Não' ? 'selected' : '' ?>>Inativo</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="mb-3">
                        <label class="form-label">&nbsp;</label>
                        <button type="button" class="btn btn-success w-100" onclick="salvarGrupoBasico()">
                            <i class="bi bi-check-circle me-2"></i> Salvar Grupo
                        </button>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="ncm" class="form-label">NCM</label>
                        <input type="text" class="form-control mascara-ncm" id="ncm" name="ncm"
                               value="<?= htmlspecialchars($ncm) ?>"
                               placeholder="0000.00.00" maxlength="10">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="cest" class="form-label">CEST</label>
                        <input type="text" class="form-control mascara-cest" id="cest" name="cest"
                               value="<?= htmlspecialchars($cest) ?>"
                               placeholder="00.000.00" maxlength="9">
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="mb-3">
                        <label for="ibpt" class="form-label">IBPT (%)</label>
                        <input type="text" class="form-control mascara-moeda" id="ibpt" name="ibpt"
                               value="<?= number_format($ibpt, 2, ',', '.') ?>"
                               placeholder="0,00">
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="mb-3">
                        <label for="atividade_produto_sped" class="form-label">Atividade SPED</label>
                        <select class="form-select" id="atividade_produto_sped" name="atividade_produto_sped">
                            <option value="">Selecione</option>
                            <option value="01" <?= $atividade_produto_sped == '01' ? 'selected' : '' ?>>01 - Indústria de Alimentos</option>
                            <option value="02" <?= $atividade_produto_sped == '02' ? 'selected' : '' ?>>02 - Indústria de Bebidas</option>
                            <option value="07" <?= $atividade_produto_sped == '07' ? 'selected' : '' ?>>07 - Comércio de Produtos</option>
                            <option value="11" <?= $atividade_produto_sped == '11' ? 'selected' : '' ?>>11 - Outros</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="mb-3">
                        <label for="genero_produto_edoc" class="form-label">Gênero Produto</label>
                        <select class="form-select" id="genero_produto_edoc" name="genero_produto_edoc">
                            <option value="">Selecione</option>
                            <option value="00" <?= $genero_produto_edoc == '00' ? 'selected' : '' ?>>00 - Serviço/outros</option>
                            <option value="84" <?= $genero_produto_edoc == '84' ? 'selected' : '' ?>>84 - Máquinas</option>
                        </select>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Card: Adicionar/Gerenciar Configurações por UF -->
<div class="card mb-3">
    <div class="card-header bg-success text-white">
        <h6 class="mb-0"><i class="bi bi-plus-circle me-2"></i> Adicionar Configuração por UF</h6>
    </div>
    <div class="card-body">
        <form id="formAdicionarConfig">
            <!-- Incluir formulário de configurações -->
            <?php
            // Limpar $imposto para não confundir com campos da config
            $imposto = [];
            include __DIR__ . '/form.php';
            ?>

            <div class="row mt-3">
                <div class="col-md-12">
                    <button type="button" id="btnAdicionarImposto" class="btn btn-success btn-lg" onclick="adicionarImposto()">
                        <i class="bi bi-plus-circle me-2"></i> Adicionar Imposto
                    </button>
                    <button type="button" class="btn btn-secondary" onclick="limparCamposConfig()">
                        <i class="bi bi-x-circle me-2"></i> Limpar Campos
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Card: Lista de Configurações -->
<div class="card mb-3">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h6 class="mb-0"><i class="bi bi-list-ul me-2"></i> Lista de Impostos Configurados</h6>
        <button type="button" class="btn btn-sm btn-outline-primary" onclick="carregarConfiguracoes()">
            <i class="bi bi-arrow-clockwise me-1"></i> Atualizar
        </button>
    </div>
    <div class="card-body">
        <div id="lista-impostos-config">
            <?php if (!empty($configuracoes)): ?>
                <div class="table-responsive">
                    <table class="table table-striped table-hover table-sm">
                        <thead class="table-dark">
                            <tr>
                                <th title="Estado de Origem"><i class="bi bi-geo-alt me-1"></i> UF Origem</th>
                                <th title="Estado de Destino (para ICMS ST)"><i class="bi bi-geo me-1"></i> UF Destino</th>
                                <th title="Código de Situação Tributária">CST/CSOSN</th>
                                <th title="Alíquota do ICMS"><i class="bi bi-percent me-1"></i> ICMS (%)</th>
                                <th title="Alíquota do ICMS Substituição Tributária"><i class="bi bi-percent me-1"></i> ICMS ST (%)</th>
                                <th title="Margem de Valor Agregado"><i class="bi bi-graph-up me-1"></i> MVA (%)</th>
                                <th title="Alíquota do Imposto sobre Produtos Industrializados"><i class="bi bi-box-seam me-1"></i> IPI (%)</th>
                                <th title="Alíquota do PIS"><i class="bi bi-cash me-1"></i> PIS (%)</th>
                                <th title="Alíquota da COFINS"><i class="bi bi-cash-stack me-1"></i> COFINS (%)</th>
                                <th title="Código Fiscal de Operações e Prestações">CFOP</th>
                                <th width="80">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($configuracoes as $config): ?>
                                <tr>
                                    <td>
                                        <span class="badge bg-success fs-6"><?= $config['uf_origem'] ?? '-' ?></span>
                                        <?php if ($config['nome_estado_origem']): ?>
                                            <br><small class="text-muted"><strong>Origem:</strong> <?= htmlspecialchars($config['nome_estado_origem']) ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="badge bg-warning text-dark fs-6"><?= $config['uf_destino'] ?? '-' ?></span>
                                        <?php if ($config['nome_estado_destino']): ?>
                                            <br><small class="text-muted"><strong>Destino:</strong> <?= htmlspecialchars($config['nome_estado_destino']) ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <code class="fs-6"><?= htmlspecialchars($config['cst_csosn'] ?? '-') ?></code>
                                        <br><small class="text-muted">CST/CSOSN</small>
                                    </td>
                                    <td>
                                        <strong class="text-success"><?= number_format($config['icms'] ?? 0, 2, ',', '.') ?>%</strong>
                                        <br><small class="text-muted">ICMS</small>
                                    </td>
                                    <td>
                                        <strong class="text-warning"><?= number_format($config['icms_st'] ?? 0, 2, ',', '.') ?>%</strong>
                                        <br><small class="text-muted">ICMS ST</small>
                                    </td>
                                    <td>
                                        <span class="text-primary"><?= number_format($config['mva'] ?? 0, 2, ',', '.') ?>%</span>
                                        <br><small class="text-muted">MVA</small>
                                    </td>
                                    <td>
                                        <span class="text-info"><?= number_format($config['ipi'] ?? 0, 2, ',', '.') ?>%</span>
                                        <br><small class="text-muted">IPI</small>
                                    </td>
                                    <td>
                                        <span><?= number_format($config['pis'] ?? 0, 2, ',', '.') ?>%</span>
                                        <br><small class="text-muted">PIS</small>
                                    </td>
                                    <td>
                                        <span><?= number_format($config['cofins'] ?? 0, 2, ',', '.') ?>%</span>
                                        <br><small class="text-muted">COFINS</small>
                                    </td>
                                    <td>
                                        <code class="fs-6"><?= htmlspecialchars($config['cfop'] ?? '-') ?></code>
                                        <br><small class="text-muted">CFOP</small>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm" role="group">
                                            <button class="btn btn-outline-primary" onclick="editarConfiguracao(<?= $config['id'] ?>)" title="Editar esta configuração">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <button class="btn btn-outline-info" onclick="abrirModalClonar('<?= $config['hash_imposto'] ?>', '<?= $config['uf_origem'] ?>')" title="Clonar esta configuração para outras UFs">
                                                <i class="bi bi-files"></i>
                                            </button>
                                            <button class="btn btn-outline-danger" onclick="excluirConfiguracao(<?= $config['id'] ?>)" title="Excluir esta configuração">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                    <div class="alert alert-success mt-2">
                        <i class="bi bi-check-circle me-2"></i>
                        <strong><?= count($configuracoes) ?></strong> configuração(ões) de UF adicionada(s).
                    </div>
                    <div class="card bg-light">
                        <div class="card-body">
                            <h6 class="mb-3"><i class="bi bi-book me-2"></i> Entenda Cada Campo da Tabela:</h6>
                            <div class="row small">
                                <div class="col-md-12 mb-3">
                                    <div class="alert alert-info mb-2 py-2">
                                        <strong><i class="bi bi-geo-alt me-1"></i> PE (Pernambuco) → AC (Acre):</strong>
                                        Significa que esta configuração fiscal é para operações que <strong>saem de Pernambuco</strong> com <strong>destino ao Acre</strong>.
                                    </div>
                                </div>
                            </div>
                            <div class="row small">
                                <div class="col-md-6">
                                    <ul class="list-unstyled">
                                        <li class="mb-2">
                                            <i class="bi bi-1-circle-fill text-primary me-1"></i>
                                            <strong>CST/CSOSN 102:</strong> Código de Situação Tributária
                                            <br><span class="ms-3 text-muted">→ Define como o produto é tributado (ex: 102 = Tributada pelo Simples Nacional sem crédito)</span>
                                        </li>
                                        <li class="mb-2">
                                            <i class="bi bi-2-circle-fill text-success me-1"></i>
                                            <strong>ICMS 20,50%:</strong> Imposto sobre Circulação de Mercadorias e Serviços
                                            <br><span class="ms-3 text-muted">→ Alíquota aplicada <strong>dentro do estado</strong> de origem (PE)</span>
                                        </li>
                                        <li class="mb-2">
                                            <i class="bi bi-3-circle-fill text-warning me-1"></i>
                                            <strong>ICMS ST 12,00%:</strong> ICMS Substituição Tributária
                                            <br><span class="ms-3 text-muted">→ Alíquota aplicada em operações <strong>interestaduais</strong> (PE → AC)</span>
                                        </li>
                                        <li class="mb-2">
                                            <i class="bi bi-4-circle-fill text-info me-1"></i>
                                            <strong>MVA 40,00%:</strong> Margem de Valor Agregado
                                            <br><span class="ms-3 text-muted">→ Percentual adicionado à base de cálculo do ICMS ST</span>
                                        </li>
                                        <li class="mb-2">
                                            <i class="bi bi-5-circle-fill text-secondary me-1"></i>
                                            <strong>IPI 13,00%:</strong> Imposto sobre Produtos Industrializados
                                            <br><span class="ms-3 text-muted">→ Alíquota aplicada em produtos fabricados/industrializados</span>
                                        </li>
                                    </ul>
                                </div>
                                <div class="col-md-6">
                                    <ul class="list-unstyled">
                                        <li class="mb-2">
                                            <i class="bi bi-6-circle-fill text-primary me-1"></i>
                                            <strong>PIS 1,65%:</strong> Programa de Integração Social
                                            <br><span class="ms-3 text-muted">→ Contribuição federal sobre o faturamento da empresa</span>
                                        </li>
                                        <li class="mb-2">
                                            <i class="bi bi-7-circle-fill text-danger me-1"></i>
                                            <strong>COFINS 7,60%:</strong> Contribuição para Financiamento da Seguridade Social
                                            <br><span class="ms-3 text-muted">→ Contribuição federal sobre o faturamento da empresa</span>
                                        </li>
                                        <li class="mb-2">
                                            <i class="bi bi-8-circle-fill text-dark me-1"></i>
                                            <strong>CFOP 5405:</strong> Código Fiscal de Operações e Prestações
                                            <br><span class="ms-3 text-muted">→ Define o tipo de operação fiscal (ex: 5405 = Venda de produto do estabelecimento industrial)</span>
                                        </li>
                                        <li class="mt-3 pt-3 border-top">
                                            <strong class="text-primary"><i class="bi bi-lightbulb me-1"></i> Exemplo Prático:</strong>
                                            <br><span class="text-muted">Um produto vendido de <strong>PE para AC</strong> terá ICMS de <strong>20,50%</strong> cobrado dentro de PE, mais ICMS ST de <strong>12,00%</strong> para o destino AC, além de IPI <strong>13%</strong>, PIS <strong>1,65%</strong> e COFINS <strong>7,60%</strong>.</span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php else: ?>
                <div class="alert alert-info text-center py-4">
                    <i class="bi bi-info-circle display-6 d-block mb-2"></i>
                    <p class="mb-0">Nenhuma configuração de UF adicionada ainda.</p>
                    <small class="text-muted">Preencha os campos acima e clique em "Adicionar Imposto"</small>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <a href="<?= url('/impostos') ?>" class="btn btn-secondary">
            <i class="bi bi-arrow-left me-2"></i> Voltar para Lista
        </a>
    </div>
</div>

<!-- Modal Clonar -->
<div class="modal fade" id="modalClonar" tabindex="-1">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Clonar Configuração</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p class="mb-3">Como deseja clonar esta configuração?</p>
                <div class="d-grid gap-2">
                    <button type="button" class="btn btn-primary" onclick="abrirModalSelecionarEstado()">
                        <i class="bi bi-geo-alt me-2"></i> Escolher Estado Específico
                    </button>
                    <button type="button" class="btn btn-success" onclick="clonarParaTodosEstados()">
                        <i class="bi bi-globe me-2"></i> Clonar para Todos os Estados
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal Selecionar Estado -->
<div class="modal fade" id="modalSelecionarEstado" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Selecione o Estado de Destino</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <select class="form-select" id="estadoSelecionado">
                    <option value="">Selecione um estado...</option>
                    <?php foreach ($estados as $estado): ?>
                        <option value="<?= $estado['codigo_uf'] ?>"><?= $estado['codigo_uf'] ?> - <?= htmlspecialchars($estado['nome_estado']) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" onclick="confirmarClonagemEstado()">
                    <i class="bi bi-check-circle me-2"></i> Confirmar
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Editar Configuração -->
<div class="modal fade" id="modalEditarConfig" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title"><i class="bi bi-pencil me-2"></i> Editar Configuração Fiscal</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <input type="hidden" id="edit_config_id">

                <!-- ICMS Dentro do Estado -->
                <h6 class="text-success mb-3"><i class="bi bi-geo-alt me-2"></i> ICMS - Dentro do Estado</h6>
                <div class="row">
                    <div class="col-md-3">
                        <label class="form-label">UF Origem</label>
                        <select class="form-select" id="edit_uf_origem">
                            <option value="">Selecione</option>
                            <?php foreach ($estados as $estado): ?>
                                <option value="<?= $estado['codigo_uf'] ?>"><?= $estado['codigo_uf'] ?> - <?= htmlspecialchars($estado['nome_estado']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">CST/CSOSN</label>
                        <select class="form-select" id="edit_cst_csosn">
                            <option value="">Selecione</option>
                            <optgroup label="CST - Regime Normal">
                                <option value="00">00 - Tributada Integralmente</option>
                                <option value="10">10 - Tributada com ST</option>
                                <option value="20">20 - Com redução de base de cálculo</option>
                                <option value="30">30 - Isenta ou não tributada com cobrança do ICMS por substituição tributária</option>
                                <option value="40">40 - Isenta</option>
                                <option value="41">41 - Não tributada</option>
                                <option value="50">50 - Suspensão</option>
                                <option value="51">51 - Diferimento</option>
                                <option value="60">60 - ICMS cobrado anteriormente por substituição tributária</option>
                                <option value="70">70 - Com redução de base de cálculo e cobrança do ICMS por substituição tributária</option>
                                <option value="90">90 - Outras</option>
                            </optgroup>
                            <optgroup label="CSOSN - Simples Nacional">
                                <option value="101">101 - Tributada pelo Simples Nacional com permissão de crédito</option>
                                <option value="102">102 - Tributada pelo Simples Nacional sem permissão de crédito</option>
                                <option value="103">103 - Isenção do ICMS no Simples Nacional para faixa de receita bruta</option>
                                <option value="201">201 - Tributada pelo Simples Nacional com permissão de crédito e com cobrança do ICMS por substituição tributária</option>
                                <option value="202">202 - Tributada pelo Simples Nacional sem permissão de crédito e com cobrança do ICMS por substituição tributária</option>
                                <option value="203">203 - Isenção do ICMS no Simples Nacional para faixa de receita bruta e com cobrança do ICMS por substituição tributária</option>
                                <option value="300">300 - Imune</option>
                                <option value="400">400 - Não tributada pelo Simples Nacional</option>
                                <option value="500">500 - ICMS cobrado anteriormente por substituição tributária (substituído) ou por antecipação</option>
                                <option value="900">900 - Outros</option>
                            </optgroup>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">ICMS (%)</label>
                        <input type="text" class="form-control mascara-moeda" id="edit_icms">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">FCP (%)</label>
                        <input type="text" class="form-control mascara-moeda" id="edit_fcp">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">CFOP</label>
                        <select class="form-select" id="edit_cfop">
                            <option value="">Selecione</option>
                            <?php foreach ($cfops as $cfop): ?>
                                <option value="<?= $cfop['id'] ?>"><?= $cfop['id'] ?> - <?= htmlspecialchars($cfop['descricao']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>

                <hr class="my-3">

                <!-- ICMS ST Fora do Estado -->
                <h6 class="text-warning mb-3"><i class="bi bi-arrow-left-right me-2"></i> ICMS ST - Fora do Estado</h6>
                <div class="row">
                    <div class="col-md-3">
                        <label class="form-label">UF Destino</label>
                        <select class="form-select" id="edit_uf_destino">
                            <option value="">Selecione</option>
                            <?php foreach ($estados as $estado): ?>
                                <option value="<?= $estado['codigo_uf'] ?>"><?= $estado['codigo_uf'] ?> - <?= htmlspecialchars($estado['nome_estado']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">CST ST</label>
                        <select class="form-select" id="edit_cst_csosn_st">
                            <option value="">Selecione</option>
                            <optgroup label="CST - Regime Normal">
                                <option value="10">10 - Tributada com ST</option>
                                <option value="30">30 - Isenta ou não tributada com cobrança do ICMS por substituição tributária</option>
                                <option value="60">60 - ICMS cobrado anteriormente por substituição tributária</option>
                                <option value="70">70 - Com redução de base de cálculo e cobrança do ICMS por substituição tributária</option>
                            </optgroup>
                            <optgroup label="CSOSN - Simples Nacional">
                                <option value="201">201 - Tributada pelo Simples Nacional com permissão de crédito e com cobrança do ICMS por substituição tributária</option>
                                <option value="202">202 - Tributada pelo Simples Nacional sem permissão de crédito e com cobrança do ICMS por substituição tributária</option>
                                <option value="203">203 - Isenção do ICMS no Simples Nacional para faixa de receita bruta e com cobrança do ICMS por substituição tributária</option>
                                <option value="500">500 - ICMS cobrado anteriormente por substituição tributária (substituído) ou por antecipação</option>
                            </optgroup>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">ICMS ST (%)</label>
                        <input type="text" class="form-control mascara-moeda" id="edit_icms_st">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">MVA (%)</label>
                        <input type="text" class="form-control mascara-moeda" id="edit_mva">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">CFOP ST</label>
                        <select class="form-select" id="edit_cfop_st">
                            <option value="">Selecione</option>
                            <?php foreach ($cfops as $cfop): ?>
                                <option value="<?= $cfop['id'] ?>"><?= $cfop['id'] ?> - <?= htmlspecialchars($cfop['descricao']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>

                <hr class="my-3">

                <!-- IPI, PIS, COFINS -->
                <h6 class="text-info mb-3"><i class="bi bi-cash-stack me-2"></i> IPI / PIS / COFINS</h6>
                <div class="row">
                    <div class="col-md-2">
                        <label class="form-label">CST IPI</label>
                        <select class="form-select" id="edit_cst_ipi">
                            <option value="">Selecione</option>
                            <option value="00">00 - Entrada com recuperação de crédito</option>
                            <option value="01">01 - Entrada tributada com alíquota zero</option>
                            <option value="02">02 - Entrada isenta</option>
                            <option value="03">03 - Entrada não-tributada</option>
                            <option value="04">04 - Entrada imune</option>
                            <option value="05">05 - Entrada com suspensão</option>
                            <option value="49">49 - Outras entradas</option>
                            <option value="50">50 - Saída tributada</option>
                            <option value="51">51 - Saída tributada com alíquota zero</option>
                            <option value="52">52 - Saída isenta</option>
                            <option value="53">53 - Saída não-tributada</option>
                            <option value="54">54 - Saída imune</option>
                            <option value="55">55 - Saída com suspensão</option>
                            <option value="99">99 - Outras saídas</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">IPI (%)</label>
                        <input type="text" class="form-control mascara-moeda" id="edit_ipi">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">CST PIS</label>
                        <select class="form-select" id="edit_cst_pis">
                            <option value="">Selecione</option>
                            <option value="01">01 - Operação Tributável (Base de Cálculo = Valor da Operação Alíquota Normal (Cumulativo/Não Cumulativo))</option>
                            <option value="02">02 - Operação Tributável (Base de Calculo = Valor da Operação (Alíquota Diferenciada))</option>
                            <option value="03">03 - Operação Tributável (Base de Calculo = Quantidade Vendida x Alíquota por Unidade de Produto)</option>
                            <option value="04">04 - Operação Tributável (Tributação Monofásica (Alíquota Zero))</option>
                            <option value="05">05 - Operação Tributável por Substituição Tributária</option>
                            <option value="06">06 - Operação Tributável (Alíquota Zero)</option>
                            <option value="07">07 - Operação Isenta da Contribuição</option>
                            <option value="08">08 - Operação Sem Incidência da Contribuição</option>
                            <option value="09">09 - Operação com Suspensão da Contribuição</option>
                            <option value="49">49 - Outras Operações de Saída</option>
                            <option value="50">50 - Operação com Direito a Crédito - Vinculada Exclusivamente a Receita Tributada no Mercado Interno</option>
                            <option value="51">51 - Operação com Direito a Crédito - Vinculada Exclusivamente a Receita Não Tributada no Mercado Interno</option>
                            <option value="52">52 - Operação com Direito a Crédito - Vinculada Exclusivamente a Receita de Exportação</option>
                            <option value="53">53 - Operação com Direito a Crédito - Vinculada a Receitas Tributadas e Não-Tributadas no Mercado Interno</option>
                            <option value="54">54 - Operação com Direito a Crédito - Vinculada a Receitas Tributadas no Mercado Interno e de Exportação</option>
                            <option value="55">55 - Operação com Direito a Crédito - Vinculada a Receitas Não-Tributadas no Mercado Interno e de Exportação</option>
                            <option value="56">56 - Operação com Direito a Crédito - Vinculada a Receitas Tributadas e Não-Tributadas no Mercado Interno, e de Exportação</option>
                            <option value="60">60 - Crédito Presumido - Operação de Aquisição Vinculada Exclusivamente a Receita Tributada no Mercado Interno</option>
                            <option value="61">61 - Crédito Presumido - Operação de Aquisição Vinculada Exclusivamente a Receita Não-Tributada no Mercado Interno</option>
                            <option value="62">62 - Crédito Presumido - Operação de Aquisição Vinculada Exclusivamente a Receita de Exportação</option>
                            <option value="63">63 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas Tributadas e Não-Tributadas no Mercado Interno</option>
                            <option value="64">64 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas Tributadas no Mercado Interno e de Exportação</option>
                            <option value="65">65 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas Não-Tributadas no Mercado Interno e de Exportação</option>
                            <option value="66">66 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas Tributadas e Não-Tributadas no Mercado Interno, e de Exportação</option>
                            <option value="67">67 - Crédito Presumido - Outras Operações</option>
                            <option value="70">70 - Operação de Aquisição sem Direito a Crédito</option>
                            <option value="71">71 - Operação de Aquisição com Isenção</option>
                            <option value="72">72 - Operação de Aquisição com Suspensão</option>
                            <option value="73">73 - Operação de Aquisição a Alíquota Zero</option>
                            <option value="74">74 - Operação de Aquisição sem Incidência da Contribuição</option>
                            <option value="75">75 - Operação de Aquisição por Substituição Tributária</option>
                            <option value="98">98 - Outras Operações de Entrada</option>
                            <option value="99">99 - Outras Operações</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">PIS (%)</label>
                        <input type="text" class="form-control mascara-moeda" id="edit_pis">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">CST COFINS</label>
                        <select class="form-select" id="edit_cst_cofins">
                            <option value="">Selecione</option>
                            <option value="01">01 - Operação Tributável (Base de Cálculo = Valor da Operação Alíquota Normal (Cumulativo/Não Cumulativo))</option>
                            <option value="02">02 - Operação Tributável (Base de Calculo = Valor da Operação (Alíquota Diferenciada))</option>
                            <option value="03">03 - Operação Tributável (Base de Calculo = Quantidade Vendida x Alíquota por Unidade de Produto)</option>
                            <option value="04">04 - Operação Tributável (Tributação Monofásica (Alíquota Zero))</option>
                            <option value="05">05 - Operação Tributável por Substituição Tributária</option>
                            <option value="06">06 - Operação Tributável (Alíquota Zero)</option>
                            <option value="07">07 - Operação Isenta da Contribuição</option>
                            <option value="08">08 - Operação Sem Incidência da Contribuição</option>
                            <option value="09">09 - Operação com Suspensão da Contribuição</option>
                            <option value="49">49 - Outras Operações de Saída</option>
                            <option value="50">50 - Operação com Direito a Crédito - Vinculada Exclusivamente a Receita Tributada no Mercado Interno</option>
                            <option value="51">51 - Operação com Direito a Crédito - Vinculada Exclusivamente a Receita Não Tributada no Mercado Interno</option>
                            <option value="52">52 - Operação com Direito a Crédito - Vinculada Exclusivamente a Receita de Exportação</option>
                            <option value="53">53 - Operação com Direito a Crédito - Vinculada a Receitas Tributadas e Não-Tributadas no Mercado Interno</option>
                            <option value="54">54 - Operação com Direito a Crédito - Vinculada a Receitas Tributadas no Mercado Interno e de Exportação</option>
                            <option value="55">55 - Operação com Direito a Crédito - Vinculada a Receitas Não-Tributadas no Mercado Interno e de Exportação</option>
                            <option value="56">56 - Operação com Direito a Crédito - Vinculada a Receitas Tributadas e Não-Tributadas no Mercado Interno, e de Exportação</option>
                            <option value="60">60 - Crédito Presumido - Operação de Aquisição Vinculada Exclusivamente a Receita Tributada no Mercado Interno</option>
                            <option value="61">61 - Crédito Presumido - Operação de Aquisição Vinculada Exclusivamente a Receita Não-Tributada no Mercado Interno</option>
                            <option value="62">62 - Crédito Presumido - Operação de Aquisição Vinculada Exclusivamente a Receita de Exportação</option>
                            <option value="63">63 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas Tributadas e Não-Tributadas no Mercado Interno</option>
                            <option value="64">64 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas Tributadas no Mercado Interno e de Exportação</option>
                            <option value="65">65 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas Não-Tributadas no Mercado Interno e de Exportação</option>
                            <option value="66">66 - Crédito Presumido - Operação de Aquisição Vinculada a Receitas Tributadas e Não-Tributadas no Mercado Interno, e de Exportação</option>
                            <option value="67">67 - Crédito Presumido - Outras Operações</option>
                            <option value="70">70 - Operação de Aquisição sem Direito a Crédito</option>
                            <option value="71">71 - Operação de Aquisição com Isenção</option>
                            <option value="72">72 - Operação de Aquisição com Suspensão</option>
                            <option value="73">73 - Operação de Aquisição a Alíquota Zero</option>
                            <option value="74">74 - Operação de Aquisição sem Incidência da Contribuição</option>
                            <option value="75">75 - Operação de Aquisição por Substituição Tributária</option>
                            <option value="98">98 - Outras Operações de Entrada</option>
                            <option value="99">99 - Outras Operações</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">COFINS (%)</label>
                        <input type="text" class="form-control mascara-moeda" id="edit_cofins">
                    </div>
                </div>

                <hr class="my-3">

                <!-- IBS / CBS -->
                <h6 class="text-info mb-3"><i class="bi bi-calculator me-2"></i> IBS / CBS</h6>
                <div class="row">
                    <div class="col-md-2">
                        <label class="form-label">cClass</label>
                        <input type="text" class="form-control" id="edit_cclass" placeholder="Ex: 1.01.01">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Alíquota IBS (%)</label>
                        <input type="text" class="form-control mascara-moeda" id="edit_aliquota_ibs">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Redução Alíquota IBS (%)</label>
                        <input type="text" class="form-control mascara-moeda" id="edit_reducao_aliquota_ibs">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Alíquota CBS (%)</label>
                        <input type="text" class="form-control mascara-moeda" id="edit_aliquota_cbs">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Redução Alíquota CBS (%)</label>
                        <input type="text" class="form-control mascara-moeda" id="edit_reducao_aliquota_cbs">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Alíquota IBS Municipal (%)</label>
                        <input type="text" class="form-control mascara-moeda" id="edit_aliquota_ibs_municipal">
                    </div>
                </div>
                <div class="row mt-2">
                    <div class="col-md-2">
                        <label class="form-label">Redução Alíquota IBS Municipal (%)</label>
                        <input type="text" class="form-control mascara-moeda" id="edit_reducao_aliquota_ibs_municipal">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="bi bi-x-circle me-2"></i> Cancelar
                </button>
                <button type="button" class="btn btn-primary" onclick="salvarEdicaoConfiguracao()">
                    <i class="bi bi-check-circle me-2"></i> Salvar Alterações
                </button>
            </div>
        </div>
    </div>
</div>

<!-- jQuery Mask Plugin -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>

<!-- Máscaras de Impostos -->
<script src="<?= asset('/public/assets/js/impostos-masks.js') ?>"></script>

<script>
$(document).ready(function() {
    console.log('=== PÁGINA DE EDIÇÃO CARREGADA ===');
    console.log('Hash:', $('#hash_imposto').val());
    console.log('ID:', $('#id_imposto').val());
    console.log('Configurações carregadas:', <?= count($configuracoes ?? []) ?>);
});

// Salvar grupo básico (atualização)
async function salvarGrupoBasico() {
    const nome = $('#nome').val();
    const hash_imposto = $('#hash_imposto').val();
    const id_imposto = $('#id_imposto').val();
    const empresa = $('#empresa').val();
    const ncm = $('#ncm').val().replace(/\./g, '');
    const cest = $('#cest').val().replace(/\./g, '');
    const ibpt = $('#ibpt').val().replace(/\./g, '').replace(',', '.');
    const ativo = $('#ativo').val();
    const atividade_produto_sped = $('#atividade_produto_sped').val();
    const genero_produto_edoc = $('#genero_produto_edoc').val();

    if (!nome) {
        Swal.fire({
            icon: 'error',
            title: 'Erro!',
            text: 'O campo Nome do Grupo é obrigatório.'
        });
        return;
    }

    try {
        const response = await fetch(appUrl('/impostos/editar'), {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: new URLSearchParams({
                id: id_imposto,
                hash_imposto, nome, empresa, ncm, cest, ibpt, ativo,
                atividade_produto_sped, genero_produto_edoc
            })
        });

        const data = await response.json();

        if (data.success) {
            Swal.fire({
                icon: 'success',
                title: 'Sucesso!',
                text: 'Grupo atualizado com sucesso!',
                showConfirmButton: false,
                timer: 1500
            });
        } else {
            throw new Error(data.message);
        }
    } catch (error) {
        Swal.fire({
            icon: 'error',
            title: 'Erro!',
            text: error.message || 'Erro ao atualizar grupo'
        });
    }
}

// Adicionar configuração de imposto
async function adicionarImposto() {
    const hash_imposto = $('#hash_imposto').val();

    if (!hash_imposto) {
        Swal.fire({
            icon: 'warning',
            title: 'Atenção!',
            text: 'Hash do imposto não encontrado.'
        });
        return;
    }

    if (!$('#uf_origem').val()) {
        Swal.fire({
            icon: 'error',
            title: 'Erro!',
            text: 'Selecione a UF de origem.'
        });
        $('#uf_origem').focus();
        return;
    }

    const dados = {
        hash_imposto: hash_imposto,
        uf_origem: $('#uf_origem').val(),
        cst_csosn: $('#cst_csosn').val(),
        icms: $('#icms').val() ? $('#icms').val().replace(/\./g, '').replace(',', '.') : '0',
        modalidade_bc_icms: $('#modalidade_bc_icms').val(),
        origem_mercadoria: $('#origem_mercadoria').val(),
        motivo_desicms: $('#motivo_desicms').val(),
        reducao_bc: $('#reducao_bc').val() ? $('#reducao_bc').val().replace(/\./g, '').replace(',', '.') : '0',
        fcp: $('#fcp').val() ? $('#fcp').val().replace(/\./g, '').replace(',', '.') : '0',
        cfop: $('#cfop').val(),
        valor_pauta: $('#valor_pauta').val() ? $('#valor_pauta').val().replace(/\./g, '').replace(',', '.') : '0',
        uf_destino: $('#uf_destino').val(),
        cst_csosn_st: $('#cst_csosn_st').val(),
        icms_st: $('#icms_st').val() ? $('#icms_st').val().replace(/\./g, '').replace(',', '.') : '0',
        mva: $('#mva').val() ? $('#mva').val().replace(/\./g, '').replace(',', '.') : '0',
        modalidade_bc_icms_st: $('#modalidade_bc_icms_st').val(),
        reducao_bc_st: $('#reducao_bc_st').val() ? $('#reducao_bc_st').val().replace(/\./g, '').replace(',', '.') : '0',
        fcp_st: $('#fcp_st').val() ? $('#fcp_st').val().replace(/\./g, '').replace(',', '.') : '0',
        cfop_st: $('#cfop_st').val(),
        cst_ipi: $('#cst_ipi').val(),
        ipi: $('#ipi').val() ? $('#ipi').val().replace(/\./g, '').replace(',', '.') : '0',
        classe_enquadramento_ipi: $('#classe_enquadramento_ipi').val(),
        enquadramento_ipi: $('#enquadramento_ipi').val(),
        cst_pis: $('#cst_pis').val(),
        pis: $('#pis').val() ? $('#pis').val().replace(/\./g, '').replace(',', '.') : '0',
        cst_cofins: $('#cst_cofins').val(),
        cofins: $('#cofins').val() ? $('#cofins').val().replace(/\./g, '').replace(',', '.') : '0',
        natureza_receita_pis_cofins: $('#natureza_receita_pis_cofins').val(),
        // IBS/CBS
        cclass: $('#cclass').val(),
        aliquota_ibs: $('#aliquota_ibs').val() ? $('#aliquota_ibs').val().replace(/\./g, '').replace(',', '.') : '0',
        reducao_aliquota_ibs: $('#reducao_aliquota_ibs').val() ? $('#reducao_aliquota_ibs').val().replace(/\./g, '').replace(',', '.') : '0',
        aliquota_cbs: $('#aliquota_cbs').val() ? $('#aliquota_cbs').val().replace(/\./g, '').replace(',', '.') : '0',
        reducao_aliquota_cbs: $('#reducao_aliquota_cbs').val() ? $('#reducao_aliquota_cbs').val().replace(/\./g, '').replace(',', '.') : '0',
        aliquota_ibs_municipal: $('#aliquota_ibs_municipal').val() ? $('#aliquota_ibs_municipal').val().replace(/\./g, '').replace(',', '.') : '0',
        reducao_aliquota_ibs_municipal: $('#reducao_aliquota_ibs_municipal').val() ? $('#reducao_aliquota_ibs_municipal').val().replace(/\./g, '').replace(',', '.') : '0'
    };

    try {
        const response = await fetch(appUrl('/impostos/adicionar-configuracao'), {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: new URLSearchParams(dados)
        });

        const data = await response.json();

        if (data.success) {
            Swal.fire({
                icon: 'success',
                title: 'Sucesso!',
                text: 'Configuração adicionada com sucesso!',
                showConfirmButton: false,
                timer: 1000
            }).then(() => {
                // RECARREGAR A PÁGINA PARA MOSTRAR A NOVA CONFIGURAÇÃO
                window.location.reload();
            });
        } else {
            throw new Error(data.message);
        }
    } catch (error) {
        Swal.fire({
            icon: 'error',
            title: 'Erro!',
            text: error.message || 'Erro ao adicionar configuração'
        });
    }
}

// Carregar configurações - VERSÃO SIMPLIFICADA
async function carregarConfiguracoes() {
    const hash = $('#hash_imposto').val();

    console.log('=== CARREGANDO CONFIGURAÇÕES ===');
    console.log('Hash:', hash);

    if (!hash) {
        $('#lista-impostos-config').html('<div class="alert alert-warning">Hash não encontrado.</div>');
        return;
    }

    try {
        console.log('Fazendo requisição para API...');
        const response = await fetch(appUrl('/impostos/listar-configuracoes') + `?hash=${hash}`);
        const data = await response.json();

        console.log('Resposta da API:', data);
        console.log('Dados recebidos:', data.dados);
        console.log('Quantidade:', data.dados ? data.dados.length : 0);

        if (data.success && data.dados && data.dados.length > 0) {
            console.log('Gerando tabela...');
            const html = gerarTabelaConfiguracoes(data.dados);
            console.log('HTML gerado:', html);
            $('#lista-impostos-config').html(html);
            console.log('Tabela inserida no DOM');
        } else {
            console.log('Nenhuma configuração encontrada');
            $('#lista-impostos-config').html(`
                <div class="alert alert-info text-center py-4">
                    <i class="bi bi-info-circle display-6 d-block mb-2"></i>
                    <p class="mb-0">Nenhuma configuração de UF adicionada ainda.</p>
                    <small class="text-muted">Preencha os campos acima e clique em "Adicionar Imposto"</small>
                </div>
            `);
        }
    } catch (error) {
        console.error('Erro ao carregar configurações:', error);
        $('#lista-impostos-config').html(`
            <div class="alert alert-danger">
                <i class="bi bi-exclamation-triangle me-2"></i>
                Erro ao carregar configurações: ${error.message}
            </div>
        `);
    }
}

// Gerar HTML da tabela - VERSÃO SIMPLIFICADA
function gerarTabelaConfiguracoes(configs) {
    console.log('=== GERANDO TABELA ===');
    console.log('Configurações recebidas:', configs);

    if (!configs || configs.length === 0) {
        console.log('Nenhuma configuração para exibir');
        return '<div class="alert alert-info">Nenhuma configuração adicionada ainda.</div>';
    }

    console.log('Gerando HTML para', configs.length, 'configurações');

    let html = `
        <div class="table-responsive">
            <table class="table table-striped table-hover table-sm">
                <thead class="table-dark">
                    <tr>
                        <th>UF Origem</th>
                        <th>UF Destino</th>
                        <th>CST</th>
                        <th>ICMS</th>
                        <th>ICMS ST</th>
                        <th>MVA</th>
                        <th>IPI</th>
                        <th>PIS</th>
                        <th>COFINS</th>
                        <th>CFOP</th>
                        <th width="80">Ações</th>
                    </tr>
                </thead>
                <tbody>
    `;

    configs.forEach((config, index) => {
        console.log(`Processando configuração ${index + 1}:`, config);

        const ufOrigem = config.uf_origem || '-';
        const ufDestino = config.uf_destino || '-';

        html += `
            <tr>
                <td><span class="badge bg-success">${ufOrigem}</span></td>
                <td><span class="badge bg-warning text-dark">${ufDestino}</span></td>
                <td><code>${config.cst_csosn || '-'}</code></td>
                <td><strong>${parseFloat(config.icms || 0).toFixed(2)}%</strong></td>
                <td><strong>${parseFloat(config.icms_st || 0).toFixed(2)}%</strong></td>
                <td>${parseFloat(config.mva || 0).toFixed(2)}%</td>
                <td>${parseFloat(config.ipi || 0).toFixed(2)}%</td>
                <td>${parseFloat(config.pis || 0).toFixed(2)}%</td>
                <td>${parseFloat(config.cofins || 0).toFixed(2)}%</td>
                <td><code>${config.cfop || '-'}</code></td>
                <td>
                    <button class="btn btn-sm btn-danger" onclick="excluirConfiguracao(${config.id})" title="Excluir">
                        <i class="bi bi-trash"></i>
                    </button>
                </td>
            </tr>
        `;
    });

    html += `
                </tbody>
            </table>
            <div class="alert alert-success mt-2">
                <i class="bi bi-check-circle me-2"></i>
                <strong>${configs.length}</strong> configuração(ões) de UF adicionada(s).
            </div>
        </div>
    `;

    console.log('HTML final gerado:', html);
    return html;
}

// Excluir configuração
async function excluirConfiguracao(id) {
    const result = await Swal.fire({
        title: 'Confirmar Exclusão',
        text: 'Tem certeza que deseja excluir esta configuração?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#dc3545',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Sim, excluir!',
        cancelButtonText: 'Cancelar'
    });

    if (!result.isConfirmed) return;

    try {
        const response = await fetch(appUrl('/impostos/excluir-configuracao'), {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: new URLSearchParams({ id })
        });

        const data = await response.json();

        if (data.success) {
            Swal.fire({
                icon: 'success',
                title: 'Sucesso!',
                text: 'Configuração excluída com sucesso!',
                showConfirmButton: false,
                timer: 1000
            }).then(() => {
                // RECARREGAR A PÁGINA
                window.location.reload();
            });
        } else {
            throw new Error(data.message);
        }
    } catch (error) {
        Swal.fire({
            icon: 'error',
            title: 'Erro!',
            text: error.message || 'Erro ao excluir configuração'
        });
    }
}

// Limpar campos de configuração
function limparCamposConfig() {
    $('#formAdicionarConfig select').val('');
    $('#formAdicionarConfig input[type="text"]').val('');
    $('#formAdicionarConfig .mascara-moeda').val('0,00');
    $('#uf_origem').focus();
}

// Editar configuração no modal
async function editarConfiguracao(id) {
    try {
        console.log('Editando configuração ID:', id);

        const response = await fetch(appUrl('/impostos/buscar-configuracao') + `?id=${id}`);
        const data = await response.json();

        console.log('Resposta da API:', data);

        // A API retorna 'data' e não 'dados'
        const config = data.data || data.dados;

        if (data.success && config) {
            console.log('Configuração carregada:', config);

            // Preencher campos do modal
            $('#edit_config_id').val(id);
            $('#edit_uf_origem').val(config.uf_origem);
            $('#edit_cst_csosn').val(config.cst_csosn);
            $('#edit_icms').val(config.icms ? parseFloat(config.icms).toFixed(2).replace('.', ',') : '0,00');
            $('#edit_fcp').val(config.fcp ? parseFloat(config.fcp).toFixed(2).replace('.', ',') : '0,00');
            $('#edit_cfop').val(config.cfop);
            $('#edit_uf_destino').val(config.uf_destino);
            $('#edit_cst_csosn_st').val(config.cst_csosn_st);
            $('#edit_icms_st').val(config.icms_st ? parseFloat(config.icms_st).toFixed(2).replace('.', ',') : '0,00');
            $('#edit_mva').val(config.mva ? parseFloat(config.mva).toFixed(2).replace('.', ',') : '0,00');
            $('#edit_cfop_st').val(config.cfop_st);
            $('#edit_cst_ipi').val(config.cst_ipi);
            $('#edit_ipi').val(config.ipi ? parseFloat(config.ipi).toFixed(2).replace('.', ',') : '0,00');
            $('#edit_cst_pis').val(config.cst_pis);
            $('#edit_pis').val(config.pis ? parseFloat(config.pis).toFixed(2).replace('.', ',') : '0,00');
            $('#edit_cst_cofins').val(config.cst_cofins);
            $('#edit_cofins').val(config.cofins ? parseFloat(config.cofins).toFixed(2).replace('.', ',') : '0,00');

            // IBS/CBS
            $('#edit_cclass').val(config.cclass || '');
            $('#edit_aliquota_ibs').val(config.aliquota_ibs ? parseFloat(config.aliquota_ibs).toFixed(2).replace('.', ',') : '0,00');
            $('#edit_reducao_aliquota_ibs').val(config.reducao_aliquota_ibs ? parseFloat(config.reducao_aliquota_ibs).toFixed(2).replace('.', ',') : '0,00');
            $('#edit_aliquota_cbs').val(config.aliquota_cbs ? parseFloat(config.aliquota_cbs).toFixed(2).replace('.', ',') : '0,00');
            $('#edit_reducao_aliquota_cbs').val(config.reducao_aliquota_cbs ? parseFloat(config.reducao_aliquota_cbs).toFixed(2).replace('.', ',') : '0,00');
            $('#edit_aliquota_ibs_municipal').val(config.aliquota_ibs_municipal ? parseFloat(config.aliquota_ibs_municipal).toFixed(2).replace('.', ',') : '0,00');
            $('#edit_reducao_aliquota_ibs_municipal').val(config.reducao_aliquota_ibs_municipal ? parseFloat(config.reducao_aliquota_ibs_municipal).toFixed(2).replace('.', ',') : '0,00');

            // Aplicar máscaras nos campos do modal
            $('#modalEditarConfig .mascara-moeda').mask('#.##0,00', {reverse: true});

            // Abrir modal
            const modal = new bootstrap.Modal(document.getElementById('modalEditarConfig'));
            modal.show();

        } else {
            throw new Error(data.message || 'Configuração não encontrada');
        }
    } catch (error) {
        Swal.fire({
            icon: 'error',
            title: 'Erro!',
            text: error.message || 'Erro ao carregar configuração'
        });
    }
}

// Salvar edição da configuração do modal
async function salvarEdicaoConfiguracao() {
    const id = $('#edit_config_id').val();

    if (!id) {
        Swal.fire({
            icon: 'error',
            title: 'Erro!',
            text: 'ID da configuração não encontrado.'
        });
        return;
    }

    const dados = {
        id: id,
        uf_origem: $('#edit_uf_origem').val(),
        cst_csosn: $('#edit_cst_csosn').val(),
        icms: $('#edit_icms').val() ? $('#edit_icms').val().replace(/\./g, '').replace(',', '.') : '0',
        modalidade_bc_icms: '',
        origem_mercadoria: '',
        motivo_desicms: '',
        reducao_bc: '0',
        fcp: $('#edit_fcp').val() ? $('#edit_fcp').val().replace(/\./g, '').replace(',', '.') : '0',
        cfop: $('#edit_cfop').val(),
        valor_pauta: '0',
        uf_destino: $('#edit_uf_destino').val(),
        cst_csosn_st: $('#edit_cst_csosn_st').val(),
        icms_st: $('#edit_icms_st').val() ? $('#edit_icms_st').val().replace(/\./g, '').replace(',', '.') : '0',
        mva: $('#edit_mva').val() ? $('#edit_mva').val().replace(/\./g, '').replace(',', '.') : '0',
        modalidade_bc_icms_st: '',
        reducao_bc_st: '0',
        fcp_st: '0',
        cfop_st: $('#edit_cfop_st').val(),
        cst_ipi: $('#edit_cst_ipi').val(),
        ipi: $('#edit_ipi').val() ? $('#edit_ipi').val().replace(/\./g, '').replace(',', '.') : '0',
        classe_enquadramento_ipi: '',
        enquadramento_ipi: '',
        cst_pis: $('#edit_cst_pis').val(),
        pis: $('#edit_pis').val() ? $('#edit_pis').val().replace(/\./g, '').replace(',', '.') : '0',
        cst_cofins: $('#edit_cst_cofins').val(),
        cofins: $('#edit_cofins').val() ? $('#edit_cofins').val().replace(/\./g, '').replace(',', '.') : '0',
        natureza_receita_pis_cofins: '',
        // IBS/CBS
        cclass: $('#edit_cclass').val() || '',
        aliquota_ibs: $('#edit_aliquota_ibs').val() ? $('#edit_aliquota_ibs').val().replace(/\./g, '').replace(',', '.') : '0',
        reducao_aliquota_ibs: $('#edit_reducao_aliquota_ibs').val() ? $('#edit_reducao_aliquota_ibs').val().replace(/\./g, '').replace(',', '.') : '0',
        aliquota_cbs: $('#edit_aliquota_cbs').val() ? $('#edit_aliquota_cbs').val().replace(/\./g, '').replace(',', '.') : '0',
        reducao_aliquota_cbs: $('#edit_reducao_aliquota_cbs').val() ? $('#edit_reducao_aliquota_cbs').val().replace(/\./g, '').replace(',', '.') : '0',
        aliquota_ibs_municipal: $('#edit_aliquota_ibs_municipal').val() ? $('#edit_aliquota_ibs_municipal').val().replace(/\./g, '').replace(',', '.') : '0',
        reducao_aliquota_ibs_municipal: $('#edit_reducao_aliquota_ibs_municipal').val() ? $('#edit_reducao_aliquota_ibs_municipal').val().replace(/\./g, '').replace(',', '.') : '0'
    };

    try {
        const response = await fetch(appUrl('/impostos/atualizar-configuracao'), {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: new URLSearchParams(dados)
        });

        const data = await response.json();

        if (data.success) {
            // Fechar modal
            const modal = bootstrap.Modal.getInstance(document.getElementById('modalEditarConfig'));
            modal.hide();

            Swal.fire({
                icon: 'success',
                title: 'Sucesso!',
                text: 'Configuração atualizada com sucesso!',
                showConfirmButton: false,
                timer: 1500
            }).then(() => {
                window.location.reload();
            });
        } else {
            throw new Error(data.message);
        }
    } catch (error) {
        Swal.fire({
            icon: 'error',
            title: 'Erro!',
            text: error.message || 'Erro ao atualizar configuração'
        });
    }
}

// Variáveis para clonagem
let hashParaClonar = null;
let ufOrigemParaClonar = null;

// Abrir modal de clonagem
function abrirModalClonar(hash, ufOrigem) {
    hashParaClonar = hash;
    ufOrigemParaClonar = ufOrigem;

    console.log('Abrindo modal para clonar:', hash, 'UF:', ufOrigem);

    const modal = new bootstrap.Modal(document.getElementById('modalClonar'));
    modal.show();
}

// Abrir modal para selecionar estado específico
function abrirModalSelecionarEstado() {
    // Fechar modal de opções
    const modalClonar = bootstrap.Modal.getInstance(document.getElementById('modalClonar'));
    modalClonar.hide();

    // Abrir modal de seleção
    setTimeout(() => {
        const modal = new bootstrap.Modal(document.getElementById('modalSelecionarEstado'));
        modal.show();
    }, 300);
}

// Confirmar clonagem para estado específico
async function confirmarClonagemEstado() {
    const estadoSelecionado = $('#estadoSelecionado').val();

    if (!estadoSelecionado) {
        Swal.fire({
            icon: 'error',
            title: 'Erro!',
            text: 'Por favor, selecione um estado.'
        });
        return;
    }

    // Fechar modal
    const modal = bootstrap.Modal.getInstance(document.getElementById('modalSelecionarEstado'));
    modal.hide();

    await executarClonagem(estadoSelecionado, false);
}

// Clonar para todos os estados
async function clonarParaTodosEstados() {
    const result = await Swal.fire({
        title: 'Confirmar Clonagem',
        text: 'Deseja clonar esta configuração para TODOS os estados?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Sim, clonar para todos!',
        cancelButtonText: 'Cancelar'
    });

    if (!result.isConfirmed) return;

    // Fechar modal
    const modal = bootstrap.Modal.getInstance(document.getElementById('modalClonar'));
    modal.hide();

    await executarClonagem(null, true);
}

// Executar a clonagem
async function executarClonagem(estadoDestino, todosEstados) {
    try {
        console.log('Clonando:', {
            hash: hashParaClonar,
            uf_origem: ufOrigemParaClonar,
            estado: estadoDestino,
            todos_estados: todosEstados
        });

        const response = await fetch(appUrl('/impostos/clonar'), {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: new URLSearchParams({
                hash_imposto: hashParaClonar,
                uf_origem: ufOrigemParaClonar,
                estado: estadoDestino || '',
                todos_estados: todosEstados ? '1' : '0'
            })
        });

        const data = await response.json();

        if (data.success) {
            Swal.fire({
                icon: 'success',
                title: 'Sucesso!',
                text: data.message || 'Configuração clonada com sucesso!',
                showConfirmButton: false,
                timer: 1500
            }).then(() => {
                window.location.reload();
            });
        } else {
            throw new Error(data.message);
        }
    } catch (error) {
        Swal.fire({
            icon: 'error',
            title: 'Erro!',
            text: error.message || 'Erro ao clonar configuração'
        });
    }
}
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'impostos';
include ROOT_PATH . '/views/layouts/app.php';
?>