<?php
ob_start();

// Gerar hash_imposto se estiver criando
$hash_imposto = $_GET['hash'] ?? hash('sha256', uniqid(mt_rand(), true));
$id_imposto = $_GET['id'] ?? null;
$nome = '';
$empresa = '';
$ncm = '';
$cest = '';
$ibpt = '';
$ativo = 'Sim';

// Se estiver editando, buscar dados
if ($id_imposto) {
    // Buscar dados do imposto
    // TODO: implementar busca
}
?>

<div class="row mb-4">
    <div class="col-md-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?= url('/impostos') ?>">Grupos Tributários</a></li>
                <li class="breadcrumb-item active">Novo Grupo</li>
            </ol>
        </nav>
        <h2><i class="bi bi-plus-circle me-2"></i> Cadastro de Grupo Tributário</h2>
    </div>
</div>

<input type="hidden" id="hash_imposto" name="hash_imposto" value="<?= htmlspecialchars($hash_imposto) ?>">
<input type="hidden" id="id_imposto" name="id_imposto" value="<?= htmlspecialchars($id_imposto ?? '') ?>">

<!-- Card: Informações Básicas do Grupo -->
<div class="card mb-3">
    <div class="card-header bg-primary text-white">
        <h6 class="mb-0"><i class="bi bi-info-circle me-2"></i> Informações Básicas do Grupo</h6>
    </div>
    <div class="card-body">
        <form id="formGrupoBasico">
            <div class="row">
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="empresa" class="form-label">Empresa</label>
                        <select name="empresa" id="empresa" class="form-select">
                            <option value="">Todas as Empresas</option>
                            <?php foreach ($empresas as $emp): ?>
                                <option value="<?= $emp['id'] ?>" <?= ($empresa ?? '') == $emp['id'] ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($emp['razao_social']) ?> | CNPJ: <?= htmlspecialchars($emp['cnpj']) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="nome" class="form-label">Nome do Grupo <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="nome" name="nome"
                               value="<?= htmlspecialchars($nome) ?>"
                               placeholder="Ex: Simples Nacional" required>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="mb-3">
                        <label for="ativo" class="form-label">Status</label>
                        <select name="ativo" id="ativo" class="form-select" required>
                            <option value="Sim" <?= ($ativo ?? 'Sim') === 'Sim' ? 'selected' : '' ?>>Ativo</option>
                            <option value="Não" <?= ($ativo ?? 'Sim') === 'Não' ? 'selected' : '' ?>>Inativo</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="mb-3">
                        <label class="form-label">&nbsp;</label>
                        <button type="button" class="btn btn-success w-100" onclick="salvarGrupoBasico()">
                            <i class="bi bi-check-circle me-2"></i> Salvar Grupo
                        </button>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="ncm" class="form-label">NCM</label>
                        <input type="text" class="form-control mascara-ncm" id="ncm" name="ncm"
                               value="<?= htmlspecialchars($ncm) ?>"
                               placeholder="0000.00.00" maxlength="10">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="cest" class="form-label">CEST</label>
                        <input type="text" class="form-control mascara-cest" id="cest" name="cest"
                               value="<?= htmlspecialchars($cest) ?>"
                               placeholder="00.000.00" maxlength="9">
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="mb-3">
                        <label for="ibpt" class="form-label">IBPT (%)</label>
                        <input type="text" class="form-control mascara-moeda" id="ibpt" name="ibpt"
                               value="<?= $ibpt ?? '0,00' ?>"
                               placeholder="0,00">
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="mb-3">
                        <label for="atividade_produto_sped" class="form-label">Atividade SPED</label>
                        <select class="form-select" id="atividade_produto_sped" name="atividade_produto_sped">
                            <option value="">Selecione</option>
                            <option value="01">01 - Indústria de Alimentos</option>
                            <option value="02">02 - Indústria de Bebidas</option>
                            <option value="03">03 - Indústria de Produtos Têxteis</option>
                            <option value="04">04 - Indústria de Vestuário</option>
                            <option value="05">05 - Indústria de Móveis</option>
                            <option value="06">06 - Indústria de Equipamentos</option>
                            <option value="07">07 - Comércio de Produtos</option>
                            <option value="08">08 - Serviços de Transportes</option>
                            <option value="09">09 - Serviços de Saúde</option>
                            <option value="10">10 - Serviços de TI</option>
                            <option value="11">11 - Outros</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="mb-3">
                        <label for="genero_produto_edoc" class="form-label">Gênero Produto</label>
                        <select class="form-select" id="genero_produto_edoc" name="genero_produto_edoc">
                            <option value="">Selecione</option>
                            <option value="00">00 - Serviço/outros</option>
                            <option value="07">07 - Produtos hortícolas</option>
                            <option value="15">15 - Gorduras e óleos</option>
                            <option value="22">22 - Bebidas</option>
                            <option value="30">30 - Produtos farmacêuticos</option>
                            <option value="84">84 - Máquinas e aparelhos</option>
                            <option value="85">85 - Materiais elétricos</option>
                            <option value="87">87 - Veículos</option>
                        </select>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Card: Adicionar Configuração por UF -->
<div class="card mb-3">
    <div class="card-header bg-success text-white">
        <h6 class="mb-0"><i class="bi bi-plus-circle me-2"></i> Adicionar Configuração por UF</h6>
    </div>
    <div class="card-body">
        <!-- Avisos -->
        <div class="alert alert-info" id="avisoSalvarGrupo" style="display: none;">
            <i class="bi bi-info-circle me-2"></i>
            <strong>Atenção:</strong> Salve o grupo básico primeiro antes de adicionar configurações de UF.
        </div>

        <form id="formAdicionarConfig">
            <?php include __DIR__ . '/form.php'; ?>

            <div class="row mt-3">
                <div class="col-md-12">
                    <button type="button" class="btn btn-success btn-lg" onclick="adicionarImposto()">
                        <i class="bi bi-plus-circle me-2"></i> Adicionar Imposto
                    </button>
                    <button type="button" class="btn btn-secondary" onclick="limparCamposConfig()">
                        <i class="bi bi-x-circle me-2"></i> Limpar Campos
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Card: Lista de Configurações -->
<div class="card mb-3">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h6 class="mb-0"><i class="bi bi-list-ul me-2"></i> Lista de Impostos Configurados</h6>
        <button type="button" class="btn btn-sm btn-outline-primary" onclick="carregarConfiguracoes()">
            <i class="bi bi-arrow-clockwise me-1"></i> Atualizar
        </button>
    </div>
    <div class="card-body">
        <div id="lista-impostos-config">
            <div class="text-center py-4">
                <i class="bi bi-hourglass-split display-6 d-block mb-2"></i>
                <p class="text-muted">Carregando configurações...</p>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <a href="<?= url('/impostos') ?>" class="btn btn-secondary">
            <i class="bi bi-arrow-left me-2"></i> Voltar para Lista
        </a>
    </div>
</div>

<!-- jQuery Mask Plugin -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>

<!-- Máscaras de Impostos -->
<script src="<?= asset('/public/assets/js/impostos-masks.js') ?>"></script>

<script>
$(document).ready(function() {
    // Carregar configurações existentes
    carregarConfiguracoes();
});

// Salvar grupo básico
async function salvarGrupoBasico() {
    const nome = $('#nome').val();
    const hash_imposto = $('#hash_imposto').val();
    const empresa = $('#empresa').val();
    const ncm = $('#ncm').val().replace(/\./g, '');
    const cest = $('#cest').val().replace(/\./g, '');
    const ibpt = $('#ibpt').val().replace(',', '.');
    const ativo = $('#ativo').val();
    const id_imposto = $('#id_imposto').val();
    const atividade_produto_sped = $('#atividade_produto_sped').val();
    const genero_produto_edoc = $('#genero_produto_edoc').val();

    if (!nome) {
        Swal.fire({
            icon: 'error',
            title: 'Erro!',
            text: 'O campo Nome do Grupo é obrigatório.'
        });
        return;
    }

    try {
        const response = await fetch(appUrl('/impostos/criar'), {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: new URLSearchParams({
                hash_imposto, nome, empresa, ncm, cest, ibpt, ativo,
                atividade_produto_sped, genero_produto_edoc,
                id: id_imposto
            })
        });

        const data = await response.json();

        if (data.success) {
            // Atualizar o ID se for novo
            if (data.id && !id_imposto) {
                $('#id_imposto').val(data.id);
            }

            Swal.fire({
                icon: 'success',
                title: 'Sucesso!',
                text: 'Grupo salvo com sucesso! Agora adicione as configurações por UF.',
                showConfirmButton: false,
                timer: 2000
            });
        } else {
            throw new Error(data.message);
        }
    } catch (error) {
        Swal.fire({
            icon: 'error',
            title: 'Erro!',
            text: error.message || 'Erro ao salvar grupo'
        });
    }
}

// Adicionar configuração de imposto
async function adicionarImposto() {
    const hash_imposto = $('#hash_imposto').val();
    const uf_origem = $('#uf_origem').val();

    console.log('Hash imposto:', hash_imposto);
    console.log('UF Origem:', uf_origem);

    if (!hash_imposto) {
        Swal.fire({
            icon: 'warning',
            title: 'Atenção!',
            text: 'Salve o grupo básico primeiro antes de adicionar configurações.',
            confirmButtonText: 'OK'
        });
        $('#avisoSalvarGrupo').slideDown();
        return;
    }

    if (!uf_origem) {
        Swal.fire({
            icon: 'error',
            title: 'Erro!',
            text: 'Selecione a UF de origem.',
            confirmButtonText: 'OK'
        });
        $('#uf_origem').focus();
        return;
    }

    // Coletar dados do formulário
    const dados = {
        hash_imposto: hash_imposto,
        uf_origem: $('#uf_origem').val(),
        cst_csosn: $('#cst_csosn').val(),
        icms: $('#icms').val() ? $('#icms').val().replace(/\./g, '').replace(',', '.') : '0',
        modalidade_bc_icms: $('#modalidade_bc_icms').val(),
        origem_mercadoria: $('#origem_mercadoria').val(),
        motivo_desicms: $('#motivo_desicms').val(),
        reducao_bc: $('#reducao_bc').val() ? $('#reducao_bc').val().replace(/\./g, '').replace(',', '.') : '0',
        fcp: $('#fcp').val() ? $('#fcp').val().replace(/\./g, '').replace(',', '.') : '0',
        cfop: $('#cfop').val(),
        valor_pauta: $('#valor_pauta').val() ? $('#valor_pauta').val().replace(/\./g, '').replace(',', '.') : '0',
        uf_destino: $('#uf_destino').val(),
        cst_csosn_st: $('#cst_csosn_st').val(),
        icms_st: $('#icms_st').val() ? $('#icms_st').val().replace(/\./g, '').replace(',', '.') : '0',
        mva: $('#mva').val() ? $('#mva').val().replace(/\./g, '').replace(',', '.') : '0',
        modalidade_bc_icms_st: $('#modalidade_bc_icms_st').val(),
        reducao_bc_st: $('#reducao_bc_st').val() ? $('#reducao_bc_st').val().replace(/\./g, '').replace(',', '.') : '0',
        fcp_st: $('#fcp_st').val() ? $('#fcp_st').val().replace(/\./g, '').replace(',', '.') : '0',
        cfop_st: $('#cfop_st').val(),
        cst_ipi: $('#cst_ipi').val(),
        ipi: $('#ipi').val() ? $('#ipi').val().replace(/\./g, '').replace(',', '.') : '0',
        classe_enquadramento_ipi: $('#classe_enquadramento_ipi').val(),
        enquadramento_ipi: $('#enquadramento_ipi').val(),
        cst_pis: $('#cst_pis').val(),
        pis: $('#pis').val() ? $('#pis').val().replace(/\./g, '').replace(',', '.') : '0',
        cst_cofins: $('#cst_cofins').val(),
        cofins: $('#cofins').val() ? $('#cofins').val().replace(/\./g, '').replace(',', '.') : '0',
        natureza_receita_pis_cofins: $('#natureza_receita_pis_cofins').val(),
        // IBS/CBS
        cclass: $('#cclass').val(),
        aliquota_ibs: $('#aliquota_ibs').val() ? $('#aliquota_ibs').val().replace(/\./g, '').replace(',', '.') : '0',
        reducao_aliquota_ibs: $('#reducao_aliquota_ibs').val() ? $('#reducao_aliquota_ibs').val().replace(/\./g, '').replace(',', '.') : '0',
        aliquota_cbs: $('#aliquota_cbs').val() ? $('#aliquota_cbs').val().replace(/\./g, '').replace(',', '.') : '0',
        reducao_aliquota_cbs: $('#reducao_aliquota_cbs').val() ? $('#reducao_aliquota_cbs').val().replace(/\./g, '').replace(',', '.') : '0',
        aliquota_ibs_municipal: $('#aliquota_ibs_municipal').val() ? $('#aliquota_ibs_municipal').val().replace(/\./g, '').replace(',', '.') : '0',
        reducao_aliquota_ibs_municipal: $('#reducao_aliquota_ibs_municipal').val() ? $('#reducao_aliquota_ibs_municipal').val().replace(/\./g, '').replace(',', '.') : '0'
    };

    console.log('Enviando dados:', dados);

    try {
        const response = await fetch(appUrl('/impostos/adicionar-configuracao'), {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: new URLSearchParams(dados)
        });

        const data = await response.json();
        console.log('Resposta:', data);

        if (data.success) {
            Swal.fire({
                icon: 'success',
                title: 'Sucesso!',
                text: 'Configuração adicionada com sucesso!',
                showConfirmButton: false,
                timer: 1500
            });

            limparCamposConfig();

            // Forçar recarregamento após um pequeno delay
            setTimeout(() => {
                console.log('=== RECARREGANDO APÓS ADIÇÃO ===');
                carregarConfiguracoes();
            }, 100);
        } else {
            throw new Error(data.message);
        }
    } catch (error) {
        console.error('Erro:', error);
        Swal.fire({
            icon: 'error',
            title: 'Erro!',
            text: error.message || 'Erro ao adicionar configuração'
        });
    }
}

// Carregar configurações
async function carregarConfiguracoes() {
    const hash = $('#hash_imposto').val();

    console.log('Carregando configurações para hash:', hash);

    if (!hash) {
        $('#lista-impostos-config').html(`
            <div class="alert alert-warning">
                <i class="bi bi-exclamation-triangle me-2"></i>
                <strong>Primeiro passo:</strong> Preencha e salve o grupo básico acima.
            </div>
        `);
        return;
    }

    try {
        const response = await fetch(appUrl('/impostos/listar-configuracoes') + `?hash=${hash}`);
        const data = await response.json();

        console.log('Resposta do servidor:', data);

        if (data.success && data.dados && data.dados.length > 0) {
            const html = gerarTabelaConfiguracoes(data.dados);
            $('#lista-impostos-config').html(html);
        } else {
            $('#lista-impostos-config').html(`
                <div class="alert alert-info text-center py-4">
                    <i class="bi bi-info-circle display-6 d-block mb-2"></i>
                    <p class="mb-0">Nenhuma configuração de UF adicionada ainda.</p>
                    <small class="text-muted">Preencha os campos acima e clique em "Adicionar Imposto"</small>
                </div>
            `);
        }
    } catch (error) {
        console.error('Erro ao carregar configurações:', error);
        $('#lista-impostos-config').html(`
            <div class="alert alert-danger">
                <i class="bi bi-exclamation-circle me-2"></i>
                Erro ao carregar configurações. Verifique o console.
            </div>
        `);
    }
}

// Gerar HTML da tabela
function gerarTabelaConfiguracoes(configs) {
    console.log('Gerando tabela com', configs.length, 'configurações');

    if (!configs || configs.length === 0) {
        return `
            <div class="alert alert-info text-center py-4">
                <i class="bi bi-info-circle display-6 d-block mb-2"></i>
                <p class="mb-0">Nenhuma configuração de UF adicionada ainda.</p>
                <small class="text-muted">Preencha os campos acima e clique em "Adicionar Imposto"</small>
            </div>
        `;
    }

    let html = `
        <div class="table-responsive">
            <table class="table table-striped table-hover table-sm">
                <thead class="table-dark">
                    <tr>
                        <th title="Estado de Origem"><i class="bi bi-geo-alt me-1"></i> UF Origem</th>
                        <th title="Estado de Destino (para ICMS ST)"><i class="bi bi-geo me-1"></i> UF Destino</th>
                        <th title="Código de Situação Tributária">CST/CSOSN</th>
                        <th title="Alíquota do ICMS"><i class="bi bi-percent me-1"></i> ICMS (%)</th>
                        <th title="Alíquota do ICMS Substituição Tributária"><i class="bi bi-percent me-1"></i> ICMS ST (%)</th>
                        <th title="Margem de Valor Agregado"><i class="bi bi-graph-up me-1"></i> MVA (%)</th>
                        <th title="Alíquota do Imposto sobre Produtos Industrializados"><i class="bi bi-box-seam me-1"></i> IPI (%)</th>
                        <th title="Alíquota do PIS"><i class="bi bi-cash me-1"></i> PIS (%)</th>
                        <th title="Alíquota da COFINS"><i class="bi bi-cash-stack me-1"></i> COFINS (%)</th>
                        <th title="Código Fiscal de Operações e Prestações">CFOP</th>
                        <th width="80">Ações</th>
                    </tr>
                </thead>
                <tbody>
    `;

    configs.forEach(config => {
        const ufOrigem = config.uf_origem || config.nome_estado_origem || '-';
        const ufDestino = config.uf_destino || config.nome_estado_destino || '-';

        html += `
            <tr>
                <td>
                    <span class="badge bg-success">${ufOrigem}</span>
                    ${config.nome_estado_origem ? `<br><small class="text-muted">${config.nome_estado_origem}</small>` : ''}
                </td>
                <td>
                    <span class="badge bg-warning text-dark">${ufDestino}</span>
                    ${config.nome_estado_destino ? `<br><small class="text-muted">${config.nome_estado_destino}</small>` : ''}
                </td>
                <td><code>${config.cst_csosn || '-'}</code></td>
                <td><strong>${parseFloat(config.icms || 0).toFixed(2)}%</strong></td>
                <td><strong>${parseFloat(config.icms_st || 0).toFixed(2)}%</strong></td>
                <td>${parseFloat(config.mva || 0).toFixed(2)}%</td>
                <td>${parseFloat(config.ipi || 0).toFixed(2)}%</td>
                <td>${parseFloat(config.pis || 0).toFixed(2)}%</td>
                <td>${parseFloat(config.cofins || 0).toFixed(2)}%</td>
                <td><code>${config.cfop || '-'}</code></td>
                <td>
                    <div class="btn-group btn-group-sm" role="group">
                        <button class="btn btn-outline-info" onclick="abrirModalClonar('${config.hash_imposto}', '${config.uf_origem}')" title="Clonar">
                            <i class="bi bi-files"></i>
                        </button>
                        <button class="btn btn-outline-danger" onclick="excluirConfiguracao(${config.id})" title="Excluir">
                            <i class="bi bi-trash"></i>
                        </button>
                    </div>
                </td>
            </tr>
        `;
    });

    html += `
                </tbody>
            </table>
            <div class="alert alert-success mt-2">
                <i class="bi bi-check-circle me-2"></i>
                <strong>${configs.length}</strong> configuração(ões) de UF adicionada(s).
            </div>
            <div class="card bg-light mt-2">
                <div class="card-body">
                    <h6 class="mb-2"><i class="bi bi-info-circle me-2"></i> Legenda dos Campos:</h6>
                    <div class="row small">
                        <div class="col-md-6">
                            <ul class="mb-0">
                                <li><strong>CST/CSOSN:</strong> Código de Situação Tributária</li>
                                <li><strong>ICMS:</strong> Imposto sobre Circulação de Mercadorias</li>
                                <li><strong>ICMS ST:</strong> ICMS Substituição Tributária</li>
                                <li><strong>MVA:</strong> Margem de Valor Agregado</li>
                                <li><strong>IPI:</strong> Imposto sobre Produtos Industrializados</li>
                            </ul>
                        </div>
                        <div class="col-md-6">
                            <ul class="mb-0">
                                <li><strong>PIS:</strong> Programa de Integração Social</li>
                                <li><strong>COFINS:</strong> Contribuição para Financiamento da Seguridade Social</li>
                                <li><strong>CFOP:</strong> Código Fiscal de Operações e Prestações</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    `;

    return html;
}

// Excluir configuração
async function excluirConfiguracao(id) {
    const result = await Swal.fire({
        title: 'Confirmar Exclusão',
        text: 'Tem certeza que deseja excluir esta configuração?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#dc3545',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Sim, excluir!',
        cancelButtonText: 'Cancelar'
    });

    if (!result.isConfirmed) return;

    try {
        const response = await fetch(appUrl('/impostos/excluir-configuracao'), {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: new URLSearchParams({ id })
        });

        const data = await response.json();

        if (data.success) {
            Swal.fire({
                icon: 'success',
                title: 'Sucesso!',
                text: 'Configuração excluída com sucesso!',
                showConfirmButton: false,
                timer: 1500
            });

            carregarConfiguracoes();
        } else {
            throw new Error(data.message);
        }
    } catch (error) {
        Swal.fire({
            icon: 'error',
            title: 'Erro!',
            text: error.message || 'Erro ao excluir configuração'
        });
    }
}

// Limpar campos de configuração
function limparCamposConfig() {
    console.log('Limpando campos de configuração...');

    // Limpar selects (exceto hash)
    $('#formAdicionarConfig select').val('');

    // Limpar inputs de texto
    $('#formAdicionarConfig input[type="text"]').val('');

    // Resetar campos com máscara monetária para 0,00
    $('#formAdicionarConfig .mascara-moeda').val('0,00');

    // Focar no primeiro campo
    $('#uf_origem').focus();

    console.log('Campos limpos!');
}

// Variáveis para clonagem
let hashParaClonar = null;
let ufOrigemParaClonar = null;

// Abrir modal de clonagem
function abrirModalClonar(hash, ufOrigem) {
    hashParaClonar = hash;
    ufOrigemParaClonar = ufOrigem;

    console.log('Abrindo modal para clonar:', hash, 'UF:', ufOrigem);

    const modal = new bootstrap.Modal(document.getElementById('modalClonar'));
    modal.show();
}

// Abrir modal para selecionar estado específico
function abrirModalSelecionarEstado() {
    // Fechar modal de opções
    const modalClonar = bootstrap.Modal.getInstance(document.getElementById('modalClonar'));
    modalClonar.hide();

    // Abrir modal de seleção
    setTimeout(() => {
        const modal = new bootstrap.Modal(document.getElementById('modalSelecionarEstado'));
        modal.show();
    }, 300);
}

// Confirmar clonagem para estado específico
async function confirmarClonagemEstado() {
    const estadoSelecionado = $('#estadoSelecionado').val();

    if (!estadoSelecionado) {
        Swal.fire({
            icon: 'error',
            title: 'Erro!',
            text: 'Por favor, selecione um estado.'
        });
        return;
    }

    // Fechar modal
    const modal = bootstrap.Modal.getInstance(document.getElementById('modalSelecionarEstado'));
    modal.hide();

    await executarClonagem(estadoSelecionado, false);
}

// Clonar para todos os estados
async function clonarParaTodosEstados() {
    const result = await Swal.fire({
        title: 'Confirmar Clonagem',
        text: 'Deseja clonar esta configuração para TODOS os estados?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Sim, clonar para todos!',
        cancelButtonText: 'Cancelar'
    });

    if (!result.isConfirmed) return;

    // Fechar modal
    const modal = bootstrap.Modal.getInstance(document.getElementById('modalClonar'));
    modal.hide();

    await executarClonagem(null, true);
}

// Executar a clonagem
async function executarClonagem(estadoDestino, todosEstados) {
    try {
        console.log('Clonando:', {
            hash: hashParaClonar,
            uf_origem: ufOrigemParaClonar,
            estado: estadoDestino,
            todos_estados: todosEstados
        });

        const response = await fetch(appUrl('/impostos/clonar'), {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: new URLSearchParams({
                hash_imposto: hashParaClonar,
                uf_origem: ufOrigemParaClonar,
                estado: estadoDestino || '',
                todos_estados: todosEstados ? '1' : '0'
            })
        });

        const data = await response.json();

        if (data.success) {
            Swal.fire({
                icon: 'success',
                title: 'Sucesso!',
                text: data.message || 'Configuração clonada com sucesso!',
                showConfirmButton: false,
                timer: 1500
            }).then(() => {
                // Recarregar configurações
                carregarConfiguracoes();
            });
        } else {
            throw new Error(data.message);
        }
    } catch (error) {
        Swal.fire({
            icon: 'error',
            title: 'Erro!',
            text: error.message || 'Erro ao clonar configuração'
        });
    }
}
</script>

<!-- Modais de Clonagem -->
<div class="modal fade" id="modalClonar" tabindex="-1">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Clonar Configuração</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p class="mb-3">Como deseja clonar esta configuração?</p>
                <div class="d-grid gap-2">
                    <button type="button" class="btn btn-primary" onclick="abrirModalSelecionarEstado()">
                        <i class="bi bi-geo-alt me-2"></i> Escolher Estado Específico
                    </button>
                    <button type="button" class="btn btn-success" onclick="clonarParaTodosEstados()">
                        <i class="bi bi-globe me-2"></i> Clonar para Todos os Estados
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modalSelecionarEstado" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Selecione o Estado de Destino</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <select class="form-select" id="estadoSelecionado">
                    <option value="">Selecione um estado...</option>
                    <?php foreach ($estados as $estado): ?>
                        <option value="<?= $estado['codigo_uf'] ?>"><?= $estado['codigo_uf'] ?> - <?= htmlspecialchars($estado['nome_estado']) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" onclick="confirmarClonagemEstado()">
                    <i class="bi bi-check-circle me-2"></i> Confirmar
                </button>
            </div>
        </div>
    </div>
</div>

<?php
$content = ob_get_clean();
$activeMenu = 'impostos';
include ROOT_PATH . '/views/layouts/app.php';
?>
