<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?= url('/gestao/backup') ?>">Gestão</a></li>
                <li class="breadcrumb-item active">Importação de Dados</li>
            </ol>
        </nav>
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h2><i class="bi bi-upload me-2"></i> Importação de Dados</h2>
                <p class="text-muted">Importe dados de pessoas, plano de contas, centro de custos, impostos, estoque e contas a receber</p>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h6 class="mb-0"><i class="bi bi-download me-2"></i> Baixar Templates</h6>
            </div>
            <div class="card-body">
                <p class="text-muted">Baixe os templates CSV para preencher com seus dados:</p>
                <div class="list-group">
                    <a href="<?= url('/importacao/template?tabela=pessoas') ?>" class="list-group-item list-group-item-action">
                        <i class="bi bi-people me-2"></i> Template - Pessoas
                    </a>
                    <a href="<?= url('/importacao/template?tabela=plano_contas') ?>" class="list-group-item list-group-item-action">
                        <i class="bi bi-list-ul me-2"></i> Template - Plano de Contas
                    </a>
                    <a href="<?= url('/importacao/template?tabela=centro_custos') ?>" class="list-group-item list-group-item-action">
                        <i class="bi bi-diagram-3 me-2"></i> Template - Centro de Custos
                    </a>
                    <a href="<?= url('/importacao/template?tabela=impostos') ?>" class="list-group-item list-group-item-action">
                        <i class="bi bi-percent me-2"></i> Template - Impostos
                    </a>
                    <a href="<?= url('/importacao/template?tabela=estoque') ?>" class="list-group-item list-group-item-action">
                        <i class="bi bi-box-seam me-2"></i> Template - Estoque
                    </a>
                    <a href="<?= url('/importacao/template?tabela=contas_receber') ?>" class="list-group-item list-group-item-action">
                        <i class="bi bi-receipt me-2"></i> Template - Contas a Receber
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-success text-white">
                <h6 class="mb-0"><i class="bi bi-upload me-2"></i> Importar Dados</h6>
            </div>
            <div class="card-body">
                <form id="formImportacao" enctype="multipart/form-data">
                    <div class="mb-3">
                        <label for="tabela" class="form-label">Selecione a Tabela:</label>
                        <select class="form-select" id="tabela" name="tabela" required>
                            <option value="">Selecione...</option>
                            <option value="pessoas">Pessoas</option>
                            <option value="plano_contas">Plano de Contas</option>
                            <option value="centro_custos">Centro de Custos</option>
                            <option value="impostos">Impostos</option>
                            <option value="estoque">Estoque</option>
                            <option value="contas_receber">Contas a Receber</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label for="arquivo" class="form-label">Selecione o Arquivo (CSV, XLS ou XLSX):</label>
                        <input type="file" class="form-control" id="arquivo" name="arquivo" accept=".csv,.xls,.xlsx" required>
                        <small class="form-text text-muted" id="arquivo-tamanho-info">Formatos aceitos: CSV, XLS, XLSX (máx. 10MB - Contas a Receber: 25MB)</small>
                    </div>

                    <div class="alert alert-info">
                        <i class="bi bi-info-circle me-2"></i>
                        <strong>Dicas:</strong>
                        <ul class="mb-0 mt-2">
                            <li>Use o template correspondente como base</li>
                            <li>Mantenha os cabeçalhos exatamente como no template</li>
                            <li>Registros existentes serão atualizados (pessoas por documento, outros por código)</li>
                            <li>Campos vazios serão ignorados</li>
                        </ul>
                    </div>

                    <button type="submit" class="btn btn-success w-100">
                        <i class="bi bi-upload me-2"></i> Importar Dados
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Atualizar mensagem de tamanho máximo ao selecionar tabela
    $('#tabela').on('change', function() {
        const tabela = $(this).val();
        const $info = $('#arquivo-tamanho-info');

        if (tabela === 'contas_receber') {
            $info.text('Formatos aceitos: CSV, XLS, XLSX (máx. 25MB)');
        } else if (tabela) {
            $info.text('Formatos aceitos: CSV, XLS, XLSX (máx. 10MB)');
        } else {
            $info.text('Formatos aceitos: CSV, XLS, XLSX (máx. 10MB - Contas a Receber: 25MB)');
        }
    });

    $('#formImportacao').on('submit', function(e) {
        e.preventDefault();

        const tabela = $('#tabela').val();
        const arquivo = $('#arquivo')[0].files[0];

        console.log('Tabela selecionada:', tabela);
        console.log('Arquivo selecionado:', arquivo ? arquivo.name : 'nenhum');

        if (!tabela || tabela === '') {
            Swal.fire({
                icon: 'warning',
                title: 'Atenção!',
                text: 'Selecione a tabela para importação.'
            });
            return;
        }

        if (!arquivo) {
            Swal.fire({
                icon: 'warning',
                title: 'Atenção!',
                text: 'Selecione um arquivo para importar.'
            });
            return;
        }

        // Validar tamanho (25MB para contas_receber, 10MB para outros)
        const maxSize = tabela === 'contas_receber' ? 25 * 1024 * 1024 : 10 * 1024 * 1024;
        const maxSizeMB = tabela === 'contas_receber' ? '25MB' : '10MB';

        if (arquivo.size > maxSize) {
            Swal.fire({
                icon: 'error',
                title: 'Erro!',
                text: `Arquivo muito grande. Tamanho máximo: ${maxSizeMB}.`
            });
            return;
        }

        Swal.fire({
            title: 'Importando...',
            text: 'Aguarde enquanto os dados são importados.',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        // Criar FormData manualmente para garantir que todos os campos estão incluídos
        const formData = new FormData();
        formData.append('tabela', tabela);
        formData.append('arquivo', arquivo);

        console.log('FormData - tabela:', formData.get('tabela'));
        console.log('FormData - arquivo:', formData.get('arquivo') ? formData.get('arquivo').name : 'nenhum');

        $.ajax({
            url: appUrl('/importacao/processar'),
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    let mensagem = `<strong>Importação concluída!</strong><br><br>`;
                    mensagem += `<strong>Total de registros:</strong> ${response.data.total}<br>`;
                    mensagem += `<strong>Inseridos:</strong> ${response.data.inseridos}<br>`;
                    mensagem += `<strong>Atualizados:</strong> ${response.data.atualizados}<br>`;

                    if (response.data.erros && response.data.erros.length > 0) {
                        mensagem += `<br><strong>Erros encontrados:</strong> ${response.data.erros.length}`;
                        if (response.data.erros.length <= 10) {
                            mensagem += `<br><small>`;
                            response.data.erros.forEach(function(erro) {
                                mensagem += `Linha ${erro.linha}: ${erro.erro}<br>`;
                            });
                            mensagem += `</small>`;
                        }
                    }

                    Swal.fire({
                        icon: 'success',
                        title: 'Sucesso!',
                        html: mensagem,
                        confirmButtonText: 'OK'
                    }).then(() => {
                        $('#formImportacao')[0].reset();
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: response.message || 'Erro ao processar importação'
                    });
                }
            },
            error: function(xhr) {
                let mensagem = 'Erro ao processar requisição';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    mensagem = xhr.responseJSON.message;
                }
                Swal.fire({
                    icon: 'error',
                    title: 'Erro!',
                    text: mensagem
                });
            }
        });
    });
});
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'importacao';
include ROOT_PATH . '/views/layouts/app.php';
?>

