<?php
ob_start();
?>

<div class="container-fluid">
    <!-- Cabeçalho -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h2><i class="bi bi-folder me-2"></i> Grupos</h2>
            <p class="text-muted">Gerencie os grupos para categorizar clientes, fornecedores e outros contatos</p>
        </div>
        <div class="col-md-4 text-end">
            <button type="button" class="btn btn-outline-info me-2" onclick="abrirTutorialGruposPessoas()"
                title="Tutorial do Módulo">
                <i class="bi bi-question-circle me-2"></i> Tutorial
            </button>
            <a href="<?= url('/grupos-pessoas/criar') ?>" class="btn btn-primary">
                <i class="bi bi-plus-circle me-2"></i> Novo Grupo
            </a>
        </div>
    </div>

    <!-- Tabs -->
    <ul class="nav nav-tabs mb-3" id="gruposTabs" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="pessoas-tab" data-bs-toggle="tab" data-bs-target="#pessoas"
                type="button">
                <i class="bi bi-people me-2"></i> Pessoas
                <span
                    class="badge bg-primary ms-2"><?= count(array_filter($grupos, fn($g) => $g['tipo'] === 'pessoas')) ?></span>
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="itens-tab" data-bs-toggle="tab" data-bs-target="#itens" type="button">
                <i class="bi bi-box-seam me-2"></i> Itens
                <span
                    class="badge bg-primary ms-2"><?= count(array_filter($grupos, fn($g) => $g['tipo'] === 'itens')) ?></span>
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="pagamentos-tab" data-bs-toggle="tab" data-bs-target="#pagamentos"
                type="button">
                <i class="bi bi-credit-card me-2"></i> Métodos de Pagamento
                <span
                    class="badge bg-primary ms-2"><?= count(array_filter($grupos, fn($g) => $g['tipo'] === 'metodos_pagamento')) ?></span>
            </button>
        </li>
    </ul>

    <!-- Conteúdo das Tabs -->
    <div class="tab-content" id="gruposTabContent">
        <?php if (empty($grupos)): ?>
            <div class="alert alert-info">
                <i class="bi bi-info-circle me-2"></i>
                Nenhum grupo cadastrado. <a href="<?= url('/grupos-pessoas/criar') ?>">Criar primeiro grupo</a>
            </div>
        <?php else: ?>

            <?php
            // Separar grupos por tipo
            $gruposPessoas = array_filter($grupos, fn($g) => $g['tipo'] === 'pessoas');
            $gruposItens = array_filter($grupos, fn($g) => $g['tipo'] === 'itens');
            $gruposPagamentos = array_filter($grupos, fn($g) => $g['tipo'] === 'metodos_pagamento');
            ?>

            <!-- Aba Pessoas -->
            <div class="tab-pane fade show active" id="pessoas" role="tabpanel">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <?php if (empty($gruposPessoas)): ?>
                            <div class="alert alert-info">
                                <i class="bi bi-info-circle me-2"></i>
                                Nenhum grupo de pessoas cadastrado.
                            </div>
                        <?php else: ?>
                            <?php echo renderTabelaGrupos($gruposPessoas); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Aba Itens -->
            <div class="tab-pane fade" id="itens" role="tabpanel">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <?php if (empty($gruposItens)): ?>
                            <div class="alert alert-info">
                                <i class="bi bi-info-circle me-2"></i>
                                Nenhum grupo de itens cadastrado.
                            </div>
                        <?php else: ?>
                            <?php echo renderTabelaGrupos($gruposItens); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Aba Métodos de Pagamento -->
            <div class="tab-pane fade" id="pagamentos" role="tabpanel">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <?php if (empty($gruposPagamentos)): ?>
                            <div class="alert alert-info">
                                <i class="bi bi-info-circle me-2"></i>
                                Nenhum grupo de métodos de pagamento cadastrado.
                            </div>
                        <?php else: ?>
                            <?php echo renderTabelaGrupos($gruposPagamentos); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php
// Função auxiliar para renderizar a tabela
function renderTabelaGrupos($grupos)
{
    ob_start();
    ?>
    <div class="table-responsive">
        <table class="table table-hover">
            <thead class="table-light">
                <tr>
                    <th width="50">#</th>
                    <th>Nome</th>
                    <th>Descrição</th>
                    <!-- <th width="100" class="text-center">Subgrupos</th> -->
                    <th width="100" class="text-center">Status</th>
                    <th width="150" class="text-center">Ações</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($grupos as $grupo): ?>
                    <!-- Linha do Grupo Pai -->
                    <tr class="table-group-row">
                        <td><?= $grupo['id'] ?></td>
                        <td>
                            <strong><?= htmlspecialchars($grupo['nome'] ?? '') ?></strong>
                        </td>

                        <td>
                            <small class="text-muted">
                                <?= htmlspecialchars($grupo['descricao'] ?? '') ?: '-' ?>
                            </small>
                        </td>
                        <!-- <td class="text-center">
                            <span class="badge bg-success"><?= $grupo['total_subgrupos'] ?></span>
                        </td> -->
                        <td class="text-center">
                            <?php if ($grupo['ativo']): ?>
                                <span class="badge bg-success"><i class="bi bi-check-circle"></i> Ativo</span>
                            <?php else: ?>
                                <span class="badge bg-secondary"><i class="bi bi-x-circle"></i> Inativo</span>
                            <?php endif; ?>
                        </td>
                        <td class="text-center">
                            <div class="btn-group btn-group-sm" role="group">
                                <a href="<?= url('/grupos-pessoas/editar?id=' . $grupo['id']) ?>"
                                    class="btn btn-outline-primary" title="Editar">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <button class="btn btn-outline-danger"
                                    onclick="excluirGrupo(<?= $grupo['id'] ?>, '<?= htmlspecialchars($grupo['nome'] ?? '') ?>')"
                                    title="Excluir">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    <!-- Linhas dos Subgrupos -->
                    <?php if (!empty($grupo['subgrupos'])): ?>
                        <?php foreach ($grupo['subgrupos'] as $subgrupo): ?>
                            <tr class="table-subgroup-row">
                                <td>
                                    <small class="text-muted"><?= $subgrupo['id'] ?></small>
                                </td>
                                <td>
                                    <span class="ms-4">
                                        <i class="bi bi-arrow-return-right text-muted me-2"></i>
                                        <small class="text-muted"><?= htmlspecialchars($subgrupo['nome'] ?? '') ?></small>
                                    </span>
                                </td>

                                <td>
                                    <small class="text-muted">
                                        <?= htmlspecialchars($subgrupo['descricao'] ?? '') ?: '-' ?>
                                    </small>
                                </td>

                                <td class="text-center">
                                    <?php if ($subgrupo['ativo']): ?>
                                        <span class="badge bg-success badge-sm"><i class="bi bi-check-circle"></i> Ativo</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary badge-sm"><i class="bi bi-x-circle"></i> Inativo</span>
                                    <?php endif; ?>
                                </td>
                                <!-- <td class="text-center">
                                    <div class="btn-group btn-group-sm" role="group">
                                        <button class="btn btn-outline-danger btn-sm"
                                            onclick="excluirSubgrupo(<?= $subgrupo['id'] ?>, <?= $grupo['id'] ?>, '<?= htmlspecialchars($subgrupo['nome'] ?? '') ?>')"
                                            title="Excluir Subgrupo">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                </td> -->
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <?php
    // Adicionar paginação se necessário
    $page = $page ?? 1;
    $perPage = $perPage ?? 50;
    $total = $total ?? 0;
    $totalPages = $totalPages ?? 1;

    if ($totalPages > 1): ?>
        <div class="d-flex justify-content-between align-items-center mt-3">
            <div class="text-muted">
                <small>
                    <i class="bi bi-info-circle me-1"></i>
                    Mostrando <?= ($page - 1) * $perPage + 1 ?> a <?= min($page * $perPage, $total) ?> de <?= $total ?> grupo(s)
                </small>
            </div>
            <nav>
                <ul class="pagination pagination-sm mb-0">
                    <li class="page-item <?= $page <= 1 ? 'disabled' : '' ?>">
                        <a class="page-link" href="?page=<?= max(1, $page - 1) ?>" aria-label="Anterior">
                            <span aria-hidden="true">&laquo;</span>
                        </a>
                    </li>
                    <?php for ($i = max(1, $page - 2); $i <= min($totalPages, $page + 2); $i++): ?>
                        <li class="page-item <?= ($i === $page) ? 'active' : '' ?>">
                            <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                        </li>
                    <?php endfor; ?>
                    <li class="page-item <?= $page >= $totalPages ? 'disabled' : '' ?>">
                        <a class="page-link" href="?page=<?= min($totalPages, $page + 1) ?>" aria-label="Próximo">
                            <span aria-hidden="true">&raquo;</span>
                        </a>
                    </li>
                </ul>
            </nav>
        </div>
    <?php else: ?>
        <div class="mt-3">
            <small class="text-muted">
                <i class="bi bi-info-circle me-1"></i>
                Total: <strong><?= count($grupos) ?></strong> grupo(s)
            </small>
        </div>
    <?php endif; ?>
    <?php
    return ob_get_clean();
}
?>
</div>

<script>
    (function aguardarJQuery() {
        if (typeof jQuery === 'undefined' || typeof Swal === 'undefined') {
            setTimeout(aguardarJQuery, 100);
            return;
        }

        window.excluirGrupo = function (id, nome) {
            Swal.fire({
                title: 'Confirmar Exclusão',
                html: `Deseja realmente excluir o grupo <strong>${nome}</strong>?<br><small class="text-danger">Esta ação não pode ser desfeita!</small>`,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#dc3545',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Sim, excluir!',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: appUrl('/grupos-pessoas/deletar'),
                        type: 'POST',
                        data: {
                            id: id
                        },
                        dataType: 'json',
                        success: function (response) {
                            if (response.success) {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Excluído!',
                                    text: response.message,
                                    timer: 1500,
                                    showConfirmButton: false
                                }).then(() => {
                                    window.location.reload();
                                });
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Erro!',
                                    text: response.message
                                });
                            }
                        },
                        error: function () {
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro!',
                                text: 'Erro ao excluir grupo'
                            });
                        }
                    });
                }
            });
        };

        window.excluirSubgrupo = function (id, grupoId, nome) {
            Swal.fire({
                title: 'Confirmar Exclusão',
                html: `Deseja realmente excluir o subgrupo <strong>${nome}</strong>?<br><small class="text-danger">Esta ação não pode ser desfeita!</small>`,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#dc3545',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Sim, excluir!',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: appUrl('/grupos-pessoas/deletar-subgrupo'),
                        type: 'POST',
                        data: {
                            id: id
                        },
                        dataType: 'json',
                        success: function (response) {
                            if (response.success) {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Excluído!',
                                    text: response.message,
                                    timer: 1500,
                                    showConfirmButton: false
                                }).then(() => {
                                    window.location.reload();
                                });
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Erro!',
                                    text: response.message
                                });
                            }
                        },
                        error: function () {
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro!',
                                text: 'Erro ao excluir subgrupo'
                            });
                        }
                    });
                }
            });
        };
    })();

    // Função para abrir tutorial do módulo de Grupos de Pessoas
    function abrirTutorialGruposPessoas() {
        Swal.fire({
            title: '<i class="bi bi-folder text-primary"></i> Tutorial Completo: Módulo de Grupos',
            html: `
            <div class="text-start" style="max-height: 70vh; overflow-y: auto;">
                <div class="mb-4">
                    <h5 class="text-primary mb-3"><i class="bi bi-info-circle me-2"></i>Visão Geral</h5>
                    <p class="text-muted">O módulo de Grupos permite criar categorias organizadas para Pessoas, Itens/Produtos e Métodos de Pagamento. Cada grupo pode ter subgrupos para uma organização ainda mais detalhada.</p>
                </div>

                <div class="accordion" id="tutorialAccordionGruposPessoas">
                    <!-- O QUE SÃO GRUPOS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#oQueSaoGrupos">
                                <i class="bi bi-question-circle me-2"></i> <strong>1. O que são Grupos?</strong>
                            </button>
                        </h2>
                        <div id="oQueSaoGrupos" class="accordion-collapse collapse show" data-bs-parent="#tutorialAccordionGruposPessoas">
                            <div class="accordion-body">
                                <p class="mb-3">Grupos são categorias hierárquicas que ajudam a organizar e segmentar diferentes tipos de cadastros no sistema. Eles permitem:</p>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-check-circle text-success me-2"></i><strong>Organizar:</strong> Agrupar cadastros relacionados em categorias</li>
                                    <li><i class="bi bi-check-circle text-success me-2"></i><strong>Filtrar:</strong> Encontrar rapidamente cadastros específicos</li>
                                    <li><i class="bi bi-check-circle text-success me-2"></i><strong>Subgrupos:</strong> Criar subcategorias dentro de grupos</li>
                                    <li><i class="bi bi-check-circle text-success me-2"></i><strong>Relatórios:</strong> Gerar relatórios segmentados por grupo</li>
                                </ul>
                                <div class="alert alert-info mt-3">
                                    <i class="bi bi-lightbulb me-2"></i>
                                    <small><strong>Exemplo:</strong> Você pode criar um grupo "Clientes VIP" e dentro dele criar subgrupos como "VIP Gold", "VIP Platinum" para uma organização ainda mais detalhada.</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- TIPOS DE GRUPOS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#tiposGrupos">
                                <i class="bi bi-tags me-2"></i> <strong>2. Tipos de Grupos</strong>
                            </button>
                        </h2>
                        <div id="tiposGrupos" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionGruposPessoas">
                            <div class="accordion-body">
                                <p class="mb-3">Ao criar um grupo, você deve selecionar o <strong>Tipo de Grupo</strong>. Cada tipo tem subtipos específicos:</p>

                                <h6 class="text-primary mb-3"><i class="bi bi-people me-2"></i>Pessoas</h6>
                                <p class="ms-3 mb-2">Usado para categorizar pessoas (clientes, fornecedores, transportadoras)</p>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Subtipo - Todos:</strong> Grupo para todos os tipos de pessoas</li>
                                    <li><strong>Subtipo - Clientes:</strong> Grupo específico para clientes</li>
                                    <li><strong>Subtipo - Fornecedores:</strong> Grupo específico para fornecedores</li>
                                    <li><strong>Subtipo - Transportadoras:</strong> Grupo específico para transportadoras</li>
                                </ul>
                                <p class="ms-3 text-muted"><small>Exemplos: "Clientes VIP", "Fornecedores Nacionais", "Transportadoras Parceiras"</small></p>

                                <h6 class="text-warning mb-3"><i class="bi bi-box-seam me-2"></i>Itens/Produtos</h6>
                                <p class="ms-3 mb-2">Usado para categorizar produtos e serviços</p>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Subtipo - Todos:</strong> Grupo para todos os tipos de itens</li>
                                    <li><strong>Subtipo - Produto:</strong> Grupo específico para produtos</li>
                                    <li><strong>Subtipo - Serviço:</strong> Grupo específico para serviços</li>
                                </ul>
                                <p class="ms-3 text-muted"><small>Exemplos: "Produtos Premium", "Serviços de Instalação", "Materiais de Consumo"</small></p>

                                <h6 class="text-info mb-3"><i class="bi bi-credit-card me-2"></i>Métodos de Pagamento</h6>
                                <p class="ms-3 mb-2">Usado para categorizar métodos de pagamento</p>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Subtipo - Todos:</strong> Grupo para todos os métodos</li>
                                    <li><strong>Subtipo - Entradas:</strong> Métodos de recebimento</li>
                                    <li><strong>Subtipo - Saídas:</strong> Métodos de pagamento</li>
                                </ul>
                                <p class="ms-3 text-muted"><small>Exemplos: "Cartões de Crédito", "Boleto Bancário", "PIX"</small></p>

                                <div class="alert alert-warning mt-3">
                                    <i class="bi bi-exclamation-triangle me-2"></i>
                                    <small><strong>Importante:</strong> O tipo do grupo não pode ser alterado após a criação. Escolha cuidadosamente!</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- CAMPOS DO FORMULÁRIO -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#camposFormulario">
                                <i class="bi bi-card-text me-2"></i> <strong>3. Campos do Formulário</strong>
                            </button>
                        </h2>
                        <div id="camposFormulario" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionGruposPessoas">
                            <div class="accordion-body">
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Tipo de Grupo *:</strong> Selecione o tipo (Pessoas, Itens/Produtos ou Métodos de Pagamento)
                                        <br><small class="text-danger">Campo obrigatório e não pode ser alterado após criação</small>
                                        <br><small class="text-info">Ao selecionar, o campo Subtipo aparecerá automaticamente</small>
                                    </li>
                                    <li><strong>Subtipo:</strong> Selecione um subtipo específico ou deixe "Todos"
                                        <br><small class="text-muted">Opcional, mas recomendado para melhor organização</small>
                                        <br><small class="text-info">As opções de subtipo mudam conforme o tipo selecionado</small>
                                    </li>
                                    <li><strong>Nome do Grupo *:</strong> Nome que identifica o grupo
                                        <br><small class="text-danger">Campo obrigatório</small>
                                        <br><small class="text-muted">Use nomes descritivos e claros (ex: "Clientes VIP", "Produtos Premium")</small>
                                    </li>
                                    <li><strong>Ordem de Exibição:</strong> Número que define a ordem na listagem
                                        <br><small class="text-muted">Grupos com menor número aparecem primeiro</small>
                                        <br><small class="text-info">Exemplo: 0, 1, 2, 10, 20 (permite reorganizar depois)</small>
                                    </li>
                                    <li><strong>Status:</strong> Marque "Ativo" para manter o grupo ativo
                                        <br><small class="text-muted">Grupos inativos não aparecem em listagens e seleções</small>
                                        <br><small class="text-info">Use "Inativo" para desativar temporariamente sem excluir</small>
                                    </li>
                                    <li><strong>Descrição:</strong> Texto explicativo sobre o propósito do grupo
                                        <br><small class="text-muted">Opcional, mas recomendado para documentar o uso do grupo</small>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- SUBGRUPOS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#subgrupos">
                                <i class="bi bi-folder2-open me-2"></i> <strong>4. Subgrupos</strong>
                            </button>
                        </h2>
                        <div id="subgrupos" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionGruposPessoas">
                            <div class="accordion-body">
                                <p class="mb-3">Subgrupos são categorias dentro de um grupo, permitindo uma organização hierárquica mais detalhada.</p>

                                <h6 class="text-primary mb-3"><i class="bi bi-plus-circle me-2"></i>Criando Subgrupos</h6>
                                <ol class="ms-3 mb-3">
                                    <li>Edite um grupo existente</li>
                                    <li>Na seção de Subgrupos, clique em "Adicionar Subgrupo"</li>
                                    <li>Digite o nome do subgrupo</li>
                                    <li>Defina a ordem de exibição (opcional)</li>
                                    <li>Salve o subgrupo</li>
                                </ol>

                                <h6 class="text-primary mb-3"><i class="bi bi-diagram-3 me-2"></i>Estrutura Hierárquica</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Grupo:</strong> Categoria principal (ex: "Clientes VIP")</li>
                                    <li><strong>Subgrupo:</strong> Subcategoria dentro do grupo (ex: "VIP Gold", "VIP Platinum")</li>
                                </ul>

                                <div class="alert alert-info mt-3">
                                    <i class="bi bi-lightbulb me-2"></i>
                                    <small><strong>Exemplo:</strong> Grupo "Fornecedores" pode ter subgrupos: "Nacionais", "Internacionais", "Parceiros Estratégicos".</small>
                                </div>

                                <div class="alert alert-warning mt-3">
                                    <i class="bi bi-exclamation-triangle me-2"></i>
                                    <small><strong>Nota:</strong> Subgrupos só podem ser criados após o grupo principal estar salvo. Edite o grupo para adicionar subgrupos.</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- COMO USAR -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#comoUsar">
                                <i class="bi bi-play-circle me-2"></i> <strong>5. Como Usar</strong>
                            </button>
                        </h2>
                        <div id="comoUsar" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionGruposPessoas">
                            <div class="accordion-body">
                                <h6 class="text-success mb-3"><i class="bi bi-plus-circle me-2"></i>Criando um Grupo</h6>
                                <ol class="ms-3 mb-3">
                                    <li>Clique em "Novo Grupo"</li>
                                    <li>Selecione o <strong>Tipo de Grupo</strong> (Pessoas, Itens ou Métodos de Pagamento)</li>
                                    <li>Selecione um <strong>Subtipo</strong> (opcional, ou deixe "Todos")</li>
                                    <li>Digite o <strong>Nome</strong> do grupo</li>
                                    <li>Defina a <strong>Ordem de Exibição</strong> (opcional)</li>
                                    <li>Marque <strong>Status Ativo</strong> (recomendado)</li>
                                    <li>Adicione uma <strong>Descrição</strong> (opcional, mas recomendado)</li>
                                    <li>Clique em "Salvar Grupo"</li>
                                </ol>

                                <h6 class="text-primary mb-3"><i class="bi bi-pencil me-2"></i>Editando um Grupo</h6>
                                <ol class="ms-3 mb-3">
                                    <li>Na lista de grupos, clique no ícone de editar (lápis)</li>
                                    <li>Modifique os campos desejados</li>
                                    <li><strong>Nota:</strong> O tipo do grupo não pode ser alterado</li>
                                    <li>Na mesma tela, você pode adicionar/editar subgrupos</li>
                                    <li>Clique em "Salvar"</li>
                                </ol>

                                <h6 class="text-info mb-3"><i class="bi bi-folder-plus me-2"></i>Adicionando Subgrupos</h6>
                                <ol class="ms-3 mb-3">
                                    <li>Edite um grupo existente</li>
                                    <li>Na seção "Subgrupos", clique em "Adicionar Subgrupo"</li>
                                    <li>Preencha o nome e ordem (se necessário)</li>
                                    <li>Salve o subgrupo</li>
                                </ol>

                                <h6 class="text-warning mb-3"><i class="bi bi-x-circle me-2"></i>Desativando um Grupo</h6>
                                <p class="ms-3 mb-3">Para desativar um grupo sem excluir:</p>
                                <ol class="ms-3 mb-3">
                                    <li>Edite o grupo</li>
                                    <li>Desmarque "Status Ativo"</li>
                                    <li>Salve as alterações</li>
                                    <li>O grupo não aparecerá mais em seleções, mas os dados permanecem</li>
                                </ol>
                            </div>
                        </div>
                    </div>

                    <!-- NAVEGAÇÃO POR ABAS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#navegacaoAbas">
                                <i class="bi bi-list-ul me-2"></i> <strong>6. Navegação por Abas</strong>
                            </button>
                        </h2>
                        <div id="navegacaoAbas" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionGruposPessoas">
                            <div class="accordion-body">
                                <p class="mb-3">Na página principal, os grupos são organizados em abas por tipo:</p>

                                <h6 class="text-primary mb-3"><i class="bi bi-people me-2"></i>Aba: Pessoas</h6>
                                <p class="ms-3 mb-3">Mostra todos os grupos do tipo "Pessoas" (clientes, fornecedores, transportadoras)</p>

                                <h6 class="text-warning mb-3"><i class="bi bi-box-seam me-2"></i>Aba: Itens</h6>
                                <p class="ms-3 mb-3">Mostra todos os grupos do tipo "Itens/Produtos"</p>

                                <h6 class="text-info mb-3"><i class="bi bi-credit-card me-2"></i>Aba: Métodos de Pagamento</h6>
                                <p class="ms-3 mb-3">Mostra todos os grupos do tipo "Métodos de Pagamento"</p>

                                <div class="alert alert-info mt-3">
                                    <i class="bi bi-info-circle me-2"></i>
                                    <small>Cada aba mostra um badge com a quantidade de grupos daquele tipo, facilitando a visualização.</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- BOAS PRÁTICAS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#boasPraticas">
                                <i class="bi bi-lightbulb me-2"></i> <strong>7. Boas Práticas</strong>
                            </button>
                        </h2>
                        <div id="boasPraticas" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionGruposPessoas">
                            <div class="accordion-body">
                                <h6 class="text-success mb-3"><i class="bi bi-check-circle me-2"></i>Nomenclatura</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Use nomes claros e descritivos</li>
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Evite abreviações confusas</li>
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Mantenha consistência na nomenclatura</li>
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Exemplo: "Clientes VIP" é melhor que "CVIP"</li>
                                </ul>

                                <h6 class="text-info mb-3"><i class="bi bi-diagram-3 me-2"></i>Organização</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Use subtipos para melhor segmentação</li>
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Crie subgrupos quando necessário para organização detalhada</li>
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Use ordem de exibição para priorizar grupos importantes</li>
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Evite criar muitos grupos similares</li>
                                </ul>

                                <h6 class="text-warning mb-3"><i class="bi bi-shield-check me-2"></i>Manutenção</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Revise periodicamente grupos não utilizados</li>
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Desative em vez de excluir quando possível</li>
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Mantenha grupos organizados e atualizados</li>
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Use descrições para documentar o propósito</li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-funnel me-2"></i>Uso em Filtros e Relatórios</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Use grupos para filtrar cadastros em listagens</li>
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Gere relatórios segmentados por grupo e subgrupo</li>
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Aplique configurações específicas por grupo</li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- EXEMPLOS PRÁTICOS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#exemplos">
                                <i class="bi bi-book me-2"></i> <strong>8. Exemplos Práticos</strong>
                            </button>
                        </h2>
                        <div id="exemplos" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionGruposPessoas">
                            <div class="accordion-body">
                                <h6 class="text-primary mb-3"><i class="bi bi-people me-2"></i>Grupos de Pessoas</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Grupo: "Clientes VIP" (Subtipo: Clientes)</strong>
                                        <br><small class="text-muted">Subgrupos: "VIP Gold", "VIP Platinum", "VIP Diamond"</small>
                                    </li>
                                    <li><strong>Grupo: "Fornecedores Nacionais" (Subtipo: Fornecedores)</strong>
                                        <br><small class="text-muted">Subgrupos: "Principais", "Secundários", "Emergenciais"</small>
                                    </li>
                                    <li><strong>Grupo: "Transportadoras Parceiras" (Subtipo: Transportadoras)</strong>
                                        <br><small class="text-muted">Subgrupos: "Nacionais", "Internacionais"</small>
                                    </li>
                                </ul>

                                <h6 class="text-warning mb-3"><i class="bi bi-box-seam me-2"></i>Grupos de Itens</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Grupo: "Produtos Premium" (Subtipo: Produto)</strong>
                                        <br><small class="text-muted">Subgrupos: "Eletrônicos", "Móveis", "Eletrodomésticos"</small>
                                    </li>
                                    <li><strong>Grupo: "Serviços de Instalação" (Subtipo: Serviço)</strong>
                                        <br><small class="text-muted">Subgrupos: "Residencial", "Comercial", "Industrial"</small>
                                    </li>
                                </ul>

                                <h6 class="text-info mb-3"><i class="bi bi-credit-card me-2"></i>Grupos de Métodos de Pagamento</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Grupo: "Cartões de Crédito" (Subtipo: Entradas)</strong>
                                        <br><small class="text-muted">Subgrupos: "Visa", "Mastercard", "Elo"</small>
                                    </li>
                                    <li><strong>Grupo: "Boleto Bancário" (Subtipo: Entradas)</strong>
                                        <br><small class="text-muted">Sem subgrupos necessários</small>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="alert alert-success mt-4">
                    <i class="bi bi-check-circle me-2"></i>
                    <strong>Pronto para começar!</strong> Agora você conhece todos os recursos do módulo de Grupos e pode organizar melhor seus cadastros com grupos e subgrupos.
                </div>
            </div>
        `,
            width: '90%',
            heightAuto: false,
            confirmButtonText: 'Entendi, obrigado!',
            confirmButtonColor: '#0d6efd',
            icon: null,
            customClass: {
                popup: 'tutorial-popup',
                container: 'tutorial-container'
            }
        });
    }
</script>

<style>
    /* Estilos para o Tutorial */
    .tutorial-container {
        max-height: 90vh !important;
    }

    .tutorial-popup {
        max-width: 90vw !important;
        max-height: 90vh !important;
        width: 90% !important;
    }

    .tutorial-popup .swal2-html-container {
        padding: 0;
        max-height: calc(90vh - 150px);
        overflow-y: auto;
    }

    .tutorial-popup .accordion-button {
        font-size: 0.95rem;
        font-weight: 600;
        padding: 0.75rem 1rem;
        background-color: #f8f9fa;
        border: 1px solid #dee2e6;
    }

    .tutorial-popup .accordion-button:not(.collapsed) {
        background-color: #e7f3ff;
        color: #0d6efd;
        border-color: #0d6efd;
    }

    .tutorial-popup .accordion-button:focus {
        box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
    }

    .tutorial-popup .accordion-body {
        padding: 1.25rem;
        background-color: #ffffff;
        border-left: 3px solid #0d6efd;
    }

    .tutorial-popup .accordion-item {
        border: 1px solid #dee2e6;
        border-radius: 8px;
        overflow: hidden;
        margin-bottom: 0.5rem;
    }

    .tutorial-popup .list-unstyled li {
        padding: 0.25rem 0;
        line-height: 1.6;
    }

    .tutorial-popup .alert {
        margin-top: 1rem;
        border-left: 4px solid;
    }

    .tutorial-popup .text-muted {
        font-size: 0.875rem;
    }

    .tutorial-popup .text-info {
        color: #0dcaf0 !important;
    }

    .tutorial-popup .text-success {
        color: #198754 !important;
    }

    .tutorial-popup .text-warning {
        color: #ffc107 !important;
    }

    .tutorial-popup .text-primary {
        color: #0d6efd !important;
    }

    /* Estilos para hierarquia de grupos e subgrupos */
    .table-group-row {
        background-color: #ffffff;
    }

    .table-subgroup-row {
        background-color: #f8f9fa;
    }

    .table-subgroup-row td {
        padding-top: 0.5rem;
        padding-bottom: 0.5rem;
        border-top: 1px solid #e9ecef;
    }

    .badge-sm {
        font-size: 0.7rem;
        padding: 0.25rem 0.5rem;
    }
</style>

<?php
$content = ob_get_clean();
$activeMenu = 'grupos-pessoas';
include ROOT_PATH . '/views/layouts/app.php';
?>