<?php
ob_start();
?>

<div class="container-fluid">
    <!-- Cabeçalho -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h2><i class="bi bi-pencil me-2"></i> Editar Grupo: <?= htmlspecialchars($grupo['nome']) ?></h2>
            <p class="text-muted">Edite as informações do grupo e gerencie seus subgrupos</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="<?= url('/grupos-pessoas') ?>" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-2"></i> Voltar
            </a>
        </div>
    </div>

    <!-- Tabs -->
    <ul class="nav nav-tabs mb-3" id="grupoTabs" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="dados-tab" data-bs-toggle="tab" data-bs-target="#dados" type="button">
                <i class="bi bi-info-circle me-2"></i> Dados do Grupo
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="subgrupos-tab" data-bs-toggle="tab" data-bs-target="#subgrupos" type="button">
                <i class="bi bi-tags me-2"></i> Subgrupos (<?= count($subgrupos) ?>)
            </button>
        </li>
    </ul>

    <!-- Conteúdo das Tabs -->
    <div class="tab-content" id="grupoTabContent">

        <!-- Tab 1: Dados do Grupo -->
        <div class="tab-pane fade show active" id="dados" role="tabpanel">
            <form id="formEditarGrupo" method="POST" action="<?= url('/grupos-pessoas/editar') ?>">
                <input type="hidden" name="id" value="<?= $grupo['id'] ?>">

                <div class="card shadow-sm">
                    <div class="card-header bg-primary text-white">
                        <i class="bi bi-info-circle me-2"></i> Informações do Grupo
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <!-- Tipo -->
                            <div class="col-md-6 mb-3">
                                <label for="tipo" class="form-label">Tipo de Grupo <span
                                        class="text-danger">*</span></label>
                                <select class="form-select" id="tipo" name="tipo" required>
                                    <option value="">Selecione o tipo...</option>
                                    <option value="pessoas" <?= ($grupo['tipo'] ?? 'pessoas') === 'pessoas' ? 'selected' : '' ?>>👥 Pessoas
                                    </option>
                                    <option value="itens" <?= ($grupo['tipo'] ?? '') === 'itens' ? 'selected' : '' ?>>📦
                                        Itens/Produtos</option>
                                    <option value="metodos_pagamento" <?= ($grupo['tipo'] ?? '') === 'metodos_pagamento' ? 'selected' : '' ?>>💳
                                        Métodos de Pagamento</option>
                                </select>
                            </div>

                            <!-- Subtipo -->
                            <div class="col-md-6 mb-3" id="div_subtipo"
                                style="<?= !empty($grupo['tipo']) ? '' : 'display: none;' ?>">
                                <label for="subtipo" class="form-label">Subtipo</label>
                                <select class="form-select" id="subtipo" name="subtipo">
                                    <option value="">Todos</option>
                                    <?php
                                    $tipoAtual = $grupo['tipo'] ?? 'pessoas';
                                    $subtipoAtual = $grupo['subtipo'] ?? '';

                                    if ($tipoAtual === 'pessoas'): ?>
                                        <option value="clientes" <?= $subtipoAtual === 'clientes' ? 'selected' : '' ?>>
                                            Clientes</option>
                                        <option value="fornecedores" <?= $subtipoAtual === 'fornecedores' ? 'selected' : '' ?>>
                                            Fornecedores</option>
                                        <option value="transportadoras" <?= $subtipoAtual === 'transportadoras' ? 'selected' : '' ?>>Transportadoras
                                        </option>
                                    <?php elseif ($tipoAtual === 'itens'): ?>
                                        <option value="produto" <?= $subtipoAtual === 'produto' ? 'selected' : '' ?>>Produto
                                        </option>
                                        <option value="servico" <?= $subtipoAtual === 'servico' ? 'selected' : '' ?>>Serviço
                                        </option>
                                    <?php elseif ($tipoAtual === 'metodos_pagamento'): ?>
                                        <option value="entradas" <?= $subtipoAtual === 'entradas' ? 'selected' : '' ?>>
                                            Entradas</option>
                                        <option value="saidas" <?= $subtipoAtual === 'saidas' ? 'selected' : '' ?>>Saídas
                                        </option>
                                    <?php endif; ?>
                                </select>
                                <small class="text-muted" id="subtipo_hint">
                                    <?php
                                    echo match ($tipoAtual) {
                                        'pessoas' => 'Tipo de pessoa',
                                        'itens' => 'Natureza do item',
                                        'metodos_pagamento' => 'Tipo de transação',
                                        default => 'Selecione um tipo primeiro'
                                    };
                                    ?>
                                </small>
                            </div>

                            <!-- Nome -->
                            <div class="col-md-6 mb-3">
                                <label for="nome" class="form-label">Nome do Grupo <span
                                        class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="nome" name="nome"
                                    value="<?= htmlspecialchars($grupo['nome']) ?>" required>
                            </div>

                            <!-- Ordem -->
                            <div class="col-md-3 mb-3">
                                <label for="ordem" class="form-label">Ordem</label>
                                <input type="number" class="form-control" id="ordem" name="ordem"
                                    value="<?= $grupo['ordem'] ?? 0 ?>" min="0">
                            </div>

                            <!-- Status -->
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Status</label>
                                <div class="form-check form-switch mt-2">
                                    <input class="form-check-input" type="checkbox" id="ativo" name="ativo" value="1"
                                        <?= ($grupo['ativo'] ?? 1) ? 'checked' : '' ?>>
                                    <label class="form-check-label" for="ativo">Ativo</label>
                                </div>
                            </div>

                            <!-- Descrição -->
                            <div class="col-md-12 mb-3">
                                <label for="descricao" class="form-label">Descrição</label>
                                <textarea class="form-control" id="descricao" name="descricao"
                                    rows="3"><?= htmlspecialchars($grupo['descricao'] ?? '') ?></textarea>
                            </div>

                        </div>
                    </div>
                    <div class="card-footer text-end">
                        <a href="<?= url('/grupos-pessoas') ?>" class="btn btn-outline-secondary">Cancelar</a>
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-check-circle me-2"></i> Salvar Alterações
                        </button>
                    </div>
                </div>
            </form>
        </div>

        <!-- Tab 2: Subgrupos -->
        <div class="tab-pane fade" id="subgrupos" role="tabpanel">
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-success text-white">
                    <i class="bi bi-plus-circle me-2"></i> Adicionar Subgrupo
                </div>
                <div class="card-body">
                    <form id="formAdicionarSubgrupo">
                        <input type="hidden" name="grupo_id" value="<?= $grupo['id'] ?>">
                        <div class="row">
                            <div class="col-md-4">
                                <label for="sub_nome" class="form-label">Nome <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="sub_nome" name="nome" required>
                            </div>
                            <!-- <div class="col-md-4">
                                <label for="sub_cor" class="form-label">Cor</label>
                                <input type="color" class="form-control form-control-color" id="sub_cor" name="cor"
                                    value="#6c757d">
                            </div> -->
                            <div class="col-md-4">
                                <label for="sub_ordem" class="form-label">Ordem</label>
                                <input type="number" class="form-control" id="sub_ordem" name="ordem" value="0" min="0">
                            </div>
                            <div class="col-md-4" style="margin-top: 32px;">
                                <button type="submit" class="btn btn-success">
                                    <i class="bi bi-plus-circle me-2"></i> Adicionar
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Lista de Subgrupos -->
            <div class="card shadow-sm">
                <div class="card-header">
                    <i class="bi bi-tags me-2"></i> Subgrupos Cadastrados (<?= count($subgrupos) ?>)
                </div>
                <div class="card-body">
                    <?php if (empty($subgrupos)): ?>
                        <div class="alert alert-info">
                            <i class="bi bi-info-circle me-2"></i>
                            Nenhum subgrupo cadastrado para este grupo.
                        </div>
                    <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th width="50">Cor</th>
                                        <th>Nome</th>
                                        <th width="80">Ordem</th>
                                        <th width="100">Status</th>
                                        <th width="150">Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($subgrupos as $subgrupo): ?>
                                        <tr>
                                            <td>
                                                <span class="badge"
                                                    style="background-color: <?= htmlspecialchars($subgrupo['cor']) ?>; width: 30px; height: 30px;">&nbsp;</span>
                                            </td>
                                            <td>
                                                <strong><?= htmlspecialchars($subgrupo['nome']) ?></strong>
                                                <?php if ($subgrupo['descricao']): ?>
                                                    <br><small
                                                        class="text-muted"><?= htmlspecialchars($subgrupo['descricao']) ?></small>
                                                <?php endif; ?>
                                            </td>
                                            <td><?= $subgrupo['ordem'] ?></td>
                                            <td>
                                                <?php if ($subgrupo['ativo']): ?>
                                                    <span class="badge bg-success">Ativo</span>
                                                <?php else: ?>
                                                    <span class="badge bg-secondary">Inativo</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <div class="btn-group btn-group-sm">
                                                    <button class="btn btn-outline-primary"
                                                        onclick="editarSubgrupo(<?= $subgrupo['id'] ?>)">
                                                        <i class="bi bi-pencil"></i>
                                                    </button>
                                                    <button class="btn btn-outline-danger"
                                                        onclick="excluirSubgrupo(<?= $subgrupo['id'] ?>, '<?= htmlspecialchars($subgrupo['nome']) ?>')">
                                                        <i class="bi bi-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    (function aguardarJQuery() {
        if (typeof jQuery === 'undefined' || typeof Swal === 'undefined') {
            setTimeout(aguardarJQuery, 100);
            return;
        }

        $(document).ready(function () {
            // Definir opções de subtipo baseado no tipo
            const subtipoOptions = {
                'pessoas': [{
                    value: '',
                    text: 'Todos'
                },
                {
                    value: 'clientes',
                    text: 'Clientes'
                },
                {
                    value: 'fornecedores',
                    text: 'Fornecedores'
                },
                {
                    value: 'transportadoras',
                    text: 'Transportadoras'
                }
                ],
                'itens': [{
                    value: '',
                    text: 'Todos'
                },
                {
                    value: 'produto',
                    text: 'Produto'
                },
                {
                    value: 'servico',
                    text: 'Serviço'
                }
                ],
                'metodos_pagamento': [{
                    value: '',
                    text: 'Todos'
                },
                {
                    value: 'entradas',
                    text: 'Entradas'
                },
                {
                    value: 'saidas',
                    text: 'Saídas'
                }
                ]
            };

            const subtipoHints = {
                'pessoas': 'Tipo de pessoa',
                'itens': 'Natureza do item',
                'metodos_pagamento': 'Tipo de transação'
            };

            // Mostrar/ocultar e preencher subtipo baseado no tipo
            $('#tipo').on('change', function () {
                const tipo = $(this).val();
                const $subtipoSelect = $('#subtipo');
                const $subtipoHint = $('#subtipo_hint');
                const subtipoAtualValue = $subtipoSelect.val(); // Guardar valor atual

                if (tipo && subtipoOptions[tipo]) {
                    // Limpar opções
                    $subtipoSelect.empty();

                    // Adicionar novas opções
                    subtipoOptions[tipo].forEach(function (option) {
                        const opt = new Option(option.text, option.value);
                        if (option.value === subtipoAtualValue) {
                            opt.selected = true;
                        }
                        $subtipoSelect.append(opt);
                    });

                    // Atualizar hint
                    $subtipoHint.text(subtipoHints[tipo] || 'Selecione um subtipo');

                    // Mostrar campo
                    $('#div_subtipo').slideDown();
                } else {
                    $('#div_subtipo').slideUp();
                    $subtipoSelect.val('');
                }
            });


            // Submit formulário de edição
            $('#formEditarGrupo').on('submit', function (e) {
                e.preventDefault();

                const data = {};
                $(this).serializeArray().forEach(item => {
                    data[item.name] = item.value;
                });
                data.ativo = $('#ativo').is(':checked') ? '1' : '0';

                $.ajax({
                    url: appUrl('/grupos-pessoas/editar'),
                    type: 'POST',
                    data: data,
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Sucesso!',
                                text: response.message,
                                timer: 1500,
                                showConfirmButton: false
                            }).then(() => {
                                window.location.href = response.redirect ||
                                    appUrl('/grupos-pessoas');
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro!',
                                text: response.message
                            });
                        }
                    },
                    error: function () {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro!',
                            text: 'Erro ao atualizar grupo'
                        });
                    }
                });
            });

            // Adicionar subgrupo
            $('#formAdicionarSubgrupo').on('submit', function (e) {
                e.preventDefault();

                const data = {
                    grupo_id: <?= $grupo['id'] ?>,
                    company_id: <?= $grupo['company_id'] ?>,
                    nome: $('#sub_nome').val(),
                    cor: $('#sub_cor').val(),
                    ordem: $('#sub_ordem').val() || 0,
                    ativo: 1
                };

                $.ajax({
                    url: appUrl('/grupos-pessoas/adicionar-subgrupo'),
                    type: 'POST',
                    data: data,
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Sucesso!',
                                text: 'Subgrupo adicionado!',
                                timer: 1000,
                                showConfirmButton: false
                            }).then(() => {
                                window.location.reload();
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro!',
                                text: response.message
                            });
                        }
                    },
                    error: function () {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro!',
                            text: 'Erro ao adicionar subgrupo'
                        });
                    }
                });
            });
        });

        // Excluir subgrupo
        window.excluirSubgrupo = function (id, nome) {
            Swal.fire({
                title: 'Confirmar Exclusão',
                html: `Deseja excluir o subgrupo <strong>${nome}</strong>?`,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#dc3545',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Sim, excluir!',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: appUrl('/grupos-pessoas/deletar-subgrupo'),
                        type: 'POST',
                        data: {
                            id: id
                        },
                        dataType: 'json',
                        success: function (response) {
                            if (response.success) {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Excluído!',
                                    text: response.message,
                                    timer: 1000,
                                    showConfirmButton: false
                                }).then(() => {
                                    window.location.reload();
                                });
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Erro!',
                                    text: response.message
                                });
                            }
                        }
                    });
                }
            });
        };
    })();
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'grupos-pessoas';
include ROOT_PATH . '/views/layouts/app.php';
?>