<?php
ob_start();
?>

<div class="container-fluid">
    <!-- Cabeçalho -->
    <div class="row mb-4">
        <div class="col-md-8">
            <h2><i class="bi bi-folder-plus me-2"></i> Novo Grupo</h2>
            <p class="text-muted">Crie um novo grupo para categorizar pessoas (clientes, fornecedores, etc)</p>
        </div>
        <div class="col-md-4 text-end">
            <a href="<?= url('/grupos-pessoas') ?>" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-2"></i> Voltar
            </a>
        </div>
    </div>

    <!-- Formulário -->
    <form id="formGrupoPessoas" method="POST" action="<?= url('/grupos-pessoas/criar') ?>">
        <div class="card shadow-sm">
            <div class="card-header bg-primary text-white">
                <i class="bi bi-info-circle me-2"></i> Dados do Grupo
            </div>
            <div class="card-body">
                <div class="row">
                    <!-- Tipo -->
                    <div class="col-md-6 mb-3">
                        <label for="tipo" class="form-label">Tipo de Grupo <span class="text-danger">*</span></label>
                        <select class="form-select" id="tipo" name="tipo" required>
                            <option value="">Selecione o tipo...</option>
                            <option value="pessoas">👥 Pessoas</option>
                            <option value="itens">📦 Itens/Produtos</option>
                            <option value="metodos_pagamento">💳 Métodos de Pagamento</option>
                        </select>
                        <small class="text-muted">Categoria principal do grupo</small>
                    </div>

                    <!-- Subtipo (dinâmico baseado no tipo) -->
                    <div class="col-md-6 mb-3" id="div_subtipo" style="display: none;">
                        <label for="subtipo" class="form-label">Subtipo</label>
                        <select class="form-select" id="subtipo" name="subtipo">
                            <option value="">Todos</option>
                        </select>
                        <small class="text-muted" id="subtipo_hint">Selecione um tipo primeiro</small>
                    </div>

                    <!-- Nome -->
                    <div class="col-md-6 mb-3">
                        <label for="nome" class="form-label">Nome do Grupo <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="nome" name="nome"
                            placeholder="Ex: Clientes Premium, Fornecedores Principais..." required>
                        <small class="text-muted">Dê um nome descritivo ao grupo</small>
                    </div>

                    <!-- Ordem -->
                    <div class="col-md-3 mb-3">
                        <label for="ordem" class="form-label">Ordem de Exibição</label>
                        <input type="number" class="form-control" id="ordem" name="ordem" value="0" min="0" max="999">
                        <small class="text-muted">Define a ordem na listagem</small>
                    </div>

                    <!-- Status -->
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Status</label>
                        <div class="form-check form-switch mt-2">
                            <input class="form-check-input" type="checkbox" id="ativo" name="ativo" value="1" checked>
                            <label class="form-check-label" for="ativo">
                                <i class="bi bi-check-circle me-1"></i> Ativo
                            </label>
                        </div>
                    </div>

                    <!-- Descrição -->
                    <div class="col-md-12 mb-3">
                        <label for="descricao" class="form-label">Descrição</label>
                        <textarea class="form-control" id="descricao" name="descricao" rows="3"
                            placeholder="Descreva o propósito deste grupo e que tipo de pessoas ele agrupa..."></textarea>
                    </div>

                </div>
            </div>
            <div class="card-footer text-end">
                <a href="<?= url('/grupos-pessoas') ?>" class="btn btn-outline-secondary">
                    <i class="bi bi-x-circle me-2"></i> Cancelar
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-check-circle me-2"></i> Salvar Grupo
                </button>
            </div>
        </div>
    </form>
</div>

<script>
    (function aguardarJQuery() {
        if (typeof jQuery === 'undefined' || typeof Swal === 'undefined') {
            setTimeout(aguardarJQuery, 100);
            return;
        }

        $(document).ready(function () {
            // Definir opções de subtipo baseado no tipo
            const subtipoOptions = {
                'pessoas': [{
                    value: '',
                    text: 'Todos'
                },
                {
                    value: 'clientes',
                    text: 'Clientes'
                },
                {
                    value: 'fornecedores',
                    text: 'Fornecedores'
                },
                {
                    value: 'transportadoras',
                    text: 'Transportadoras'
                }
                ],
                'itens': [{
                    value: '',
                    text: 'Todos'
                },
                {
                    value: 'produto',
                    text: 'Produto'
                },
                {
                    value: 'servico',
                    text: 'Serviço'
                }
                ],
                'metodos_pagamento': [{
                    value: '',
                    text: 'Todos'
                },
                {
                    value: 'entradas',
                    text: 'Entradas'
                },
                {
                    value: 'saidas',
                    text: 'Saídas'
                }
                ]
            };

            const subtipoHints = {
                'pessoas': 'Tipo de pessoa',
                'itens': 'Natureza do item',
                'metodos_pagamento': 'Tipo de transação'
            };

            // Mostrar/ocultar e preencher subtipo baseado no tipo
            $('#tipo').on('change', function () {
                const tipo = $(this).val();
                const $subtipoSelect = $('#subtipo');
                const $subtipoHint = $('#subtipo_hint');

                if (tipo && subtipoOptions[tipo]) {
                    // Limpar opções
                    $subtipoSelect.empty();

                    // Adicionar novas opções
                    subtipoOptions[tipo].forEach(function (option) {
                        $subtipoSelect.append(new Option(option.text, option.value));
                    });

                    // Atualizar hint
                    $subtipoHint.text(subtipoHints[tipo] || 'Selecione um subtipo');

                    // Mostrar campo
                    $('#div_subtipo').slideDown();
                } else {
                    $('#div_subtipo').slideUp();
                    $subtipoSelect.val('');
                }
            });


            // Submit do formulário
            $('#formGrupoPessoas').on('submit', function (e) {
                e.preventDefault();

                const formData = $(this).serializeArray();
                const data = {};
                formData.forEach(item => {
                    data[item.name] = item.value;
                });

                // Adicionar checkbox manualmente
                data.ativo = $('#ativo').is(':checked') ? '1' : '0';

                $.ajax({
                    url: appUrl('/grupos-pessoas/criar'),
                    type: 'POST',
                    data: data,
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Sucesso!',
                                text: response.message,
                                timer: 1500,
                                showConfirmButton: false
                            }).then(() => {
                                window.location.href = response.redirect ||
                                    appUrl('/grupos-pessoas');
                            });
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro!',
                                text: response.message
                            });
                        }
                    },
                    error: function (xhr) {
                        console.error('Erro:', xhr);
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro!',
                            text: 'Erro ao salvar grupo. Verifique os dados.'
                        });
                    }
                });
            });
        });
    })();
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'grupos-pessoas';
include ROOT_PATH . '/views/layouts/app.php';
?>