<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-people-fill me-2"></i> Grupos</h2>
        <p class="text-muted">Organize suas pessoas em grupos</p>
    </div>
    <div class="col-md-6 text-end">
        <button type="button" class="btn btn-outline-info me-2" onclick="abrirTutorialGrupos()"
            title="Tutorial do Módulo">
            <i class="bi bi-question-circle me-2"></i> Tutorial
        </button>
        <a href="<?= url('/grupos/criar') ?>" class="btn btn-primary">
            <i class="bi bi-plus-circle me-2"></i> Novo Grupo
        </a>
    </div>
</div>

<!-- Listagem -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span><i class="bi bi-list-ul me-2"></i> Lista de Grupos</span>
        <span class="badge bg-primary"><?= count($grupos ?? []) ?> registro(s)</span>
    </div>
    <div class="card-body p-0">
        <?php if (!empty($grupos)): ?>
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th width="60">ID</th>
                            <th>Nome</th>
                            <th>Descrição</th>
                            <th>Status</th>
                            <th width="120" class="text-center">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($grupos as $grupo): ?>
                            <tr>
                                <td><?= $grupo['id'] ?></td>
                                <td><strong><?= htmlspecialchars($grupo['name']) ?></strong></td>
                                <td><small class="text-muted"><?= htmlspecialchars($grupo['description'] ?? '-') ?></small></td>
                                <td>
                                    <?php if ($grupo['is_active']): ?>
                                        <span class="badge bg-success">Ativo</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary">Inativo</span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <div class="btn-group btn-group-sm">
                                        <a href="<?= url('/grupos/editar?id=' . $grupo['id']) ?>" class="btn btn-outline-primary" title="Editar">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        <button class="btn btn-outline-danger" onclick="deletarGrupo(<?= $grupo['id'] ?>)" title="Excluir">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-people-fill" style="font-size: 4rem; color: var(--text-secondary);"></i>
                <p class="text-muted mt-3">Nenhum grupo encontrado</p>
                <a href="<?= url('/grupos/criar') ?>" class="btn btn-primary mt-2">
                    <i class="bi bi-plus-circle me-2"></i> Cadastrar Primeiro Grupo
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
/* Estilos para o Tutorial */
.tutorial-container {
    max-height: 90vh !important;
}

.tutorial-popup {
    max-width: 90vw !important;
    max-height: 90vh !important;
    width: 90% !important;
}

.tutorial-popup .swal2-html-container {
    padding: 0;
    max-height: calc(90vh - 150px);
    overflow-y: auto;
}

.tutorial-popup .accordion-button {
    font-size: 0.95rem;
    font-weight: 600;
    padding: 0.75rem 1rem;
    background-color: #f8f9fa;
    border: 1px solid #dee2e6;
}

.tutorial-popup .accordion-button:not(.collapsed) {
    background-color: #e7f3ff;
    color: #0d6efd;
    border-color: #0d6efd;
}

.tutorial-popup .accordion-button:focus {
    box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
}

.tutorial-popup .accordion-body {
    padding: 1.25rem;
    background-color: #ffffff;
    border-left: 3px solid #0d6efd;
}

.tutorial-popup .accordion-item {
    border: 1px solid #dee2e6;
    border-radius: 8px;
    overflow: hidden;
    margin-bottom: 0.5rem;
}

.tutorial-popup .list-unstyled li {
    padding: 0.25rem 0;
    line-height: 1.6;
}

.tutorial-popup .alert {
    margin-top: 1rem;
    border-left: 4px solid;
}

.tutorial-popup .text-muted {
    font-size: 0.875rem;
}

.tutorial-popup .text-info {
    color: #0dcaf0 !important;
}

.tutorial-popup .text-success {
    color: #198754 !important;
}

.tutorial-popup .text-warning {
    color: #ffc107 !important;
}

.tutorial-popup .text-primary {
    color: #0d6efd !important;
}
</style>

<script>
async function deletarGrupo(id) {
    const confirmed = await confirmDelete('Tem certeza que deseja excluir este grupo?');
    if (confirmed) {
        $.ajax({
            url: appUrl('/grupos/deletar'),
            type: 'POST',
            data: { id: id },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    Toast.success(response.message);
                    setTimeout(() => location.reload(), 1500);
                } else {
                    Toast.error(response.message);
                }
            }
        });
    }
}

// Função para abrir tutorial do módulo de Grupos
function abrirTutorialGrupos() {
    Swal.fire({
        title: '<i class="bi bi-people-fill text-primary"></i> Tutorial Completo: Módulo de Grupos',
        html: `
            <div class="text-start" style="max-height: 70vh; overflow-y: auto;">
                <div class="mb-4">
                    <h5 class="text-primary mb-3"><i class="bi bi-info-circle me-2"></i>Visão Geral</h5>
                    <p class="text-muted">O módulo de Grupos permite organizar e categorizar diferentes tipos de cadastros no sistema (Pessoas, Itens/Produtos, Pagamentos e Tabelas de Preço), facilitando a organização, filtros e relatórios.</p>
                </div>

                <div class="accordion" id="tutorialAccordionGrupos">
                    <!-- O QUE SÃO GRUPOS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#oQueSaoGrupos">
                                <i class="bi bi-question-circle me-2"></i> <strong>1. O que são Grupos?</strong>
                            </button>
                        </h2>
                        <div id="oQueSaoGrupos" class="accordion-collapse collapse show" data-bs-parent="#tutorialAccordionGrupos">
                            <div class="accordion-body">
                                <p class="mb-3">Grupos são categorias que ajudam a organizar e segmentar diferentes tipos de cadastros no sistema. Eles funcionam como "etiquetas" que permitem:</p>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-check-circle text-success me-2"></i><strong>Organizar:</strong> Agrupar cadastros relacionados</li>
                                    <li><i class="bi bi-check-circle text-success me-2"></i><strong>Filtrar:</strong> Encontrar rapidamente cadastros específicos</li>
                                    <li><i class="bi bi-check-circle text-success me-2"></i><strong>Relatórios:</strong> Gerar relatórios segmentados por grupo</li>
                                    <li><i class="bi bi-check-circle text-success me-2"></i><strong>Configurações:</strong> Aplicar configurações específicas a grupos</li>
                                </ul>
                                <div class="alert alert-info mt-3">
                                    <i class="bi bi-lightbulb me-2"></i>
                                    <small><strong>Exemplo:</strong> Você pode criar um grupo "Clientes VIP" para pessoas e depois filtrar apenas esses clientes em vendas e relatórios.</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- TIPOS DE GRUPOS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#tiposGrupos">
                                <i class="bi bi-tags me-2"></i> <strong>2. Tipos de Grupos</strong>
                            </button>
                        </h2>
                        <div id="tiposGrupos" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionGrupos">
                            <div class="accordion-body">
                                <p class="mb-3">Ao criar um grupo, você deve selecionar o <strong>Tipo do Grupo</strong>. Cada tipo é usado em módulos específicos do sistema:</p>

                                <h6 class="text-primary mb-3"><i class="bi bi-people me-2"></i>Pessoas</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Usado para categorizar clientes, fornecedores e transportadoras</li>
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Aparece no campo "Grupo" ao cadastrar/editar uma pessoa</li>
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Exemplos: "Clientes VIP", "Fornecedores Nacionais", "Transportadoras Parceiras"</li>
                                </ul>

                                <h6 class="text-warning mb-3"><i class="bi bi-box-seam me-2"></i>Itens/Produtos</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Usado para categorizar produtos e serviços</li>
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Aparece no campo "Grupo" ao cadastrar/editar um produto</li>
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Exemplos: "Produtos Premium", "Serviços de Instalação", "Materiais de Consumo"</li>
                                </ul>

                                <h6 class="text-info mb-3"><i class="bi bi-credit-card me-2"></i>Pagamentos</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Usado para categorizar métodos de pagamento</li>
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Útil para organizar diferentes formas de recebimento/pagamento</li>
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Exemplos: "Cartões de Crédito", "Boleto Bancário", "PIX"</li>
                                </ul>

                                <h6 class="text-success mb-3"><i class="bi bi-table me-2"></i>Tabelas de Preço</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Usado para categorizar tabelas de preço</li>
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Útil para organizar diferentes políticas de preços</li>
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Exemplos: "Tabela Atacado", "Tabela Varejo", "Tabela Promocional"</li>
                                </ul>

                                <div class="alert alert-warning mt-3">
                                    <i class="bi bi-exclamation-triangle me-2"></i>
                                    <small><strong>Importante:</strong> O tipo do grupo não pode ser alterado após a criação. Escolha cuidadosamente!</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- CAMPOS DO FORMULÁRIO -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#camposFormulario">
                                <i class="bi bi-card-text me-2"></i> <strong>3. Campos do Formulário</strong>
                            </button>
                        </h2>
                        <div id="camposFormulario" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionGrupos">
                            <div class="accordion-body">
                                <h6 class="text-primary mb-3"><i class="bi bi-info-circle me-2"></i>Aba: Dados Principais</h6>

                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Tipo do Grupo *:</strong> Selecione o tipo (Pessoas, Itens/Produtos, Pagamentos ou Tabelas de Preço)
                                        <br><small class="text-danger">Campo obrigatório e não pode ser alterado após criação</small>
                                    </li>
                                    <li><strong>Nome do Grupo *:</strong> Nome que identifica o grupo (ex: "Clientes VIP", "Produtos Premium")
                                        <br><small class="text-danger">Campo obrigatório, mínimo de 2 caracteres</small>
                                        <br><small class="text-muted">Use nomes descritivos e claros</small>
                                    </li>
                                    <li><strong>Descrição:</strong> Texto explicativo sobre o propósito e características do grupo
                                        <br><small class="text-muted">Opcional, mas recomendado para documentar o uso do grupo</small>
                                    </li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-gear me-2"></i>Aba: Configurações</h6>

                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Grupo Ativo:</strong> Marque para manter o grupo ativo no sistema
                                        <br><small class="text-muted">Grupos inativos não aparecem em listagens e seleções</small>
                                        <br><small class="text-info">Use "Inativo" para desativar temporariamente sem excluir</small>
                                    </li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-graph-up me-2"></i>Aba: Informações (apenas ao editar)</h6>

                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>ID do Grupo:</strong> Identificador único do grupo no sistema</li>
                                    <li><strong>Criado em:</strong> Data e hora de criação do grupo</li>
                                    <li><strong>Última Atualização:</strong> Data e hora da última modificação</li>
                                    <li><strong>Status Atual:</strong> Indica se o grupo está ativo ou inativo</li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- COMO USAR -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#comoUsar">
                                <i class="bi bi-play-circle me-2"></i> <strong>4. Como Usar Grupos</strong>
                            </button>
                        </h2>
                        <div id="comoUsar" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionGrupos">
                            <div class="accordion-body">
                                <h6 class="text-success mb-3"><i class="bi bi-plus-circle me-2"></i>Criando um Grupo</h6>
                                <ol class="ms-3 mb-3">
                                    <li>Clique em "Novo Grupo"</li>
                                    <li>Selecione o <strong>Tipo do Grupo</strong> (Pessoas, Itens, etc.)</li>
                                    <li>Digite um <strong>Nome</strong> descritivo</li>
                                    <li>Adicione uma <strong>Descrição</strong> (opcional, mas recomendado)</li>
                                    <li>Clique em "Salvar"</li>
                                </ol>

                                <h6 class="text-primary mb-3"><i class="bi bi-pencil me-2"></i>Editando um Grupo</h6>
                                <ol class="ms-3 mb-3">
                                    <li>Na lista de grupos, clique no ícone de editar (lápis)</li>
                                    <li>Modifique os campos desejados</li>
                                    <li><strong>Nota:</strong> O tipo do grupo não pode ser alterado</li>
                                    <li>Clique em "Salvar"</li>
                                </ol>

                                <h6 class="text-warning mb-3"><i class="bi bi-x-circle me-2"></i>Desativando um Grupo</h6>
                                <p class="ms-3 mb-3">Em vez de excluir, você pode desativar um grupo:</p>
                                <ol class="ms-3 mb-3">
                                    <li>Edite o grupo</li>
                                    <li>Na aba "Configurações", desmarque "Grupo Ativo"</li>
                                    <li>Salve as alterações</li>
                                    <li>O grupo não aparecerá mais em seleções, mas os cadastros associados permanecem</li>
                                </ol>

                                <h6 class="text-danger mb-3"><i class="bi bi-trash me-2"></i>Excluindo um Grupo</h6>
                                <div class="alert alert-warning ms-3">
                                    <i class="bi bi-exclamation-triangle me-2"></i>
                                    <small><strong>Atenção:</strong> Ao excluir um grupo, os cadastros associados a ele não são excluídos, mas perdem a referência ao grupo. Use a desativação quando possível.</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- BOAS PRÁTICAS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#boasPraticas">
                                <i class="bi bi-lightbulb me-2"></i> <strong>5. Boas Práticas</strong>
                            </button>
                        </h2>
                        <div id="boasPraticas" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionGrupos">
                            <div class="accordion-body">
                                <h6 class="text-success mb-3"><i class="bi bi-check-circle me-2"></i>Nomenclatura</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Use nomes claros e descritivos</li>
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Evite abreviações confusas</li>
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Mantenha consistência na nomenclatura</li>
                                    <li><i class="bi bi-arrow-right text-success me-2"></i>Exemplo: "Clientes VIP" é melhor que "CVIP"</li>
                                </ul>

                                <h6 class="text-info mb-3"><i class="bi bi-diagram-3 me-2"></i>Organização</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Crie grupos específicos, não genéricos demais</li>
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Evite criar muitos grupos similares</li>
                                    <li><i class="bi bi-arrow-right text-info me-2"></i>Use descrições para documentar o propósito</li>
                                </ul>

                                <h6 class="text-warning mb-3"><i class="bi bi-shield-check me-2"></i>Manutenção</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Revise periodicamente grupos não utilizados</li>
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Desative em vez de excluir quando possível</li>
                                    <li><i class="bi bi-arrow-right text-warning me-2"></i>Mantenha grupos organizados e atualizados</li>
                                </ul>

                                <h6 class="text-primary mb-3"><i class="bi bi-funnel me-2"></i>Uso em Filtros e Relatórios</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Use grupos para filtrar cadastros em listagens</li>
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Gere relatórios segmentados por grupo</li>
                                    <li><i class="bi bi-arrow-right text-primary me-2"></i>Aplique configurações específicas por grupo</li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- EXEMPLOS PRÁTICOS -->
                    <div class="accordion-item mb-2">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#exemplos">
                                <i class="bi bi-book me-2"></i> <strong>6. Exemplos Práticos</strong>
                            </button>
                        </h2>
                        <div id="exemplos" class="accordion-collapse collapse" data-bs-parent="#tutorialAccordionGrupos">
                            <div class="accordion-body">
                                <h6 class="text-primary mb-3"><i class="bi bi-people me-2"></i>Grupos de Pessoas</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Clientes VIP:</strong> Clientes com compras frequentes ou alto valor</li>
                                    <li><strong>Fornecedores Nacionais:</strong> Fornecedores do Brasil</li>
                                    <li><strong>Transportadoras Parceiras:</strong> Transportadoras com contrato especial</li>
                                    <li><strong>Clientes Atacado:</strong> Clientes que compram em grande volume</li>
                                </ul>

                                <h6 class="text-warning mb-3"><i class="bi bi-box-seam me-2"></i>Grupos de Itens/Produtos</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Produtos Premium:</strong> Produtos de alta qualidade/preço</li>
                                    <li><strong>Serviços de Instalação:</strong> Serviços relacionados a instalação</li>
                                    <li><strong>Materiais de Consumo:</strong> Materiais que se esgotam rapidamente</li>
                                    <li><strong>Produtos Promocionais:</strong> Produtos em promoção</li>
                                </ul>

                                <h6 class="text-info mb-3"><i class="bi bi-credit-card me-2"></i>Grupos de Pagamentos</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Cartões de Crédito:</strong> Todos os tipos de cartão de crédito</li>
                                    <li><strong>Boleto Bancário:</strong> Pagamentos via boleto</li>
                                    <li><strong>PIX:</strong> Pagamentos instantâneos via PIX</li>
                                </ul>

                                <h6 class="text-success mb-3"><i class="bi bi-table me-2"></i>Grupos de Tabelas de Preço</h6>
                                <ul class="list-unstyled ms-3 mb-3">
                                    <li><strong>Tabela Atacado:</strong> Preços para compradores em grande volume</li>
                                    <li><strong>Tabela Varejo:</strong> Preços para compradores individuais</li>
                                    <li><strong>Tabela Promocional:</strong> Preços com desconto especial</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="alert alert-success mt-4">
                    <i class="bi bi-check-circle me-2"></i>
                    <strong>Pronto para começar!</strong> Agora você conhece todos os recursos do módulo de Grupos e pode organizar melhor seus cadastros.
                </div>
            </div>
        `,
        width: '90%',
        heightAuto: false,
        confirmButtonText: 'Entendi, obrigado!',
        confirmButtonColor: '#0d6efd',
        icon: null,
        customClass: {
            popup: 'tutorial-popup',
            container: 'tutorial-container'
        }
    });
}
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'grupos';
include ROOT_PATH . '/views/layouts/app.php';
?>
