<?php
$isEdit = isset($grupo['id']);
?>

<!-- Tabs de Navegação -->
<ul class="nav nav-tabs" id="grupoTabs" role="tablist">
    <li class="nav-item" role="presentation">
        <button class="nav-link active" id="dados-tab" data-bs-toggle="tab" data-bs-target="#dados" type="button">
            <i class="bi bi-info-circle me-2"></i> Dados Principais
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="config-tab" data-bs-toggle="tab" data-bs-target="#config" type="button">
            <i class="bi bi-gear me-2"></i> Configurações
        </button>
    </li>
    <?php if ($isEdit): ?>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="info-tab" data-bs-toggle="tab" data-bs-target="#info" type="button">
            <i class="bi bi-graph-up me-2"></i> Informações
        </button>
    </li>
    <?php endif; ?>
</ul>

<!-- Conteúdo das Tabs -->
<div class="tab-content mt-3" id="grupoTabContent">

    <!-- ABA 1: Dados Principais -->
    <div class="tab-pane fade show active" id="dados" role="tabpanel">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-info-circle me-2"></i> Dados Principais do Grupo
            </div>
            <div class="card-body">
                <div class="row">
                    <!-- Tipo do Grupo -->
                    <div class="col-md-6 mb-3">
                        <label for="type" class="form-label">Tipo do Grupo *</label>
                        <select class="form-select" id="type" name="type" required>
                            <option value="">Selecione o tipo...</option>
                            <option value="pessoas" <?= ($grupo['type'] ?? '') === 'pessoas' ? 'selected' : '' ?>>Pessoas</option>
                            <option value="itens" <?= ($grupo['type'] ?? '') === 'itens' ? 'selected' : '' ?>>Itens/Produtos</option>
                            <option value="pagamentos" <?= ($grupo['type'] ?? '') === 'pagamentos' ? 'selected' : '' ?>>Pagamentos</option>
                            <option value="tabelas" <?= ($grupo['type'] ?? '') === 'tabelas' ? 'selected' : '' ?>>Tabelas de Preço</option>
                        </select>
                        <small class="text-muted">Defina a categoria deste grupo</small>
                    </div>

                    <!-- Nome do Grupo -->
                    <div class="col-md-6 mb-3">
                        <label for="name" class="form-label">Nome do Grupo *</label>
                        <input type="text" class="form-control" id="name" name="name"
                            placeholder="Ex: Clientes VIP, Atacado, Fornecedores..."
                            value="<?= htmlspecialchars($grupo['name'] ?? '') ?>" required>
                    </div>

                    <!-- Descrição -->
                    <div class="col-md-12 mb-3">
                        <label for="description" class="form-label">Descrição</label>
                        <textarea class="form-control" id="description" name="description" rows="4"
                            placeholder="Descreva o propósito e características deste grupo..."><?= htmlspecialchars($grupo['description'] ?? '') ?></textarea>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- ABA 2: Configurações -->
    <div class="tab-pane fade" id="config" role="tabpanel">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-gear me-2"></i> Configurações do Grupo
            </div>
            <div class="card-body">
                <div class="row">
                    <!-- Status Ativo/Inativo -->
                    <?php if ($isEdit): ?>
                    <div class="col-md-6 mb-4">
                        <label class="form-label">Status do Grupo</label>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1"
                                <?= ($grupo['is_active'] ?? 1) ? 'checked' : '' ?>>
                            <label class="form-check-label" for="is_active">
                                Grupo Ativo
                            </label>
                        </div>
                        <small class="text-muted">Grupos inativos não aparecem em listagens e seleções</small>
                    </div>
                    <?php endif; ?>
                </div>

                <div class="alert alert-info">
                    <i class="bi bi-lightbulb me-2"></i>
                    <strong>Dica:</strong> Grupos ajudam a organizar e segmentar diferentes tipos de cadastros no sistema, facilitando filtros e relatórios.
                </div>
            </div>
        </div>
    </div>

    <!-- ABA 3: Informações -->
    <?php if ($isEdit): ?>
    <div class="tab-pane fade" id="info" role="tabpanel">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-graph-up me-2"></i> Informações do Sistema
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">ID do Grupo</label>
                        <p class="form-control-plaintext">#<?= $grupo['id'] ?></p>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Criado em</label>
                        <p class="form-control-plaintext">
                            <?= date('d/m/Y \à\s H:i', strtotime($grupo['created_at'])) ?>
                        </p>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Última Atualização</label>
                        <p class="form-control-plaintext">
                            <?= date('d/m/Y \à\s H:i', strtotime($grupo['updated_at'])) ?>
                        </p>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Status Atual</label>
                        <p class="form-control-plaintext">
                            <?php if ($grupo['is_active']): ?>
                                <span class="badge bg-success">Ativo</span>
                            <?php else: ?>
                                <span class="badge bg-secondary">Inativo</span>
                            <?php endif; ?>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

</div>

<?php if ($isEdit): ?>
<input type="hidden" name="id" value="<?= $grupo['id'] ?>">
<?php endif; ?>
