<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-pencil me-2"></i> Editar Grupo</h2>
        <p class="text-muted"><?= htmlspecialchars($grupo['name'] ?? '') ?></p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/grupos') ?>" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left me-2"></i> Voltar
        </a>
    </div>
</div>

<form id="formGrupo" method="POST" action="<?= url('/grupos/editar') ?>">
    <?php include __DIR__ . '/form.php'; ?>

    <div class="row mt-4">
        <div class="col-12">
            <button type="submit" class="btn btn-primary btn-lg">
                <i class="bi bi-check-circle me-2"></i> Atualizar Grupo
            </button>
            <a href="<?= url('/grupos') ?>" class="btn btn-outline-secondary btn-lg ms-2">
                <i class="bi bi-x-circle me-2"></i> Cancelar
            </a>
        </div>
    </div>
</form>

<script>
(function aguardarJQuery() {
    if (typeof jQuery === 'undefined') {
        setTimeout(aguardarJQuery, 100);
        return;
    }

    $(document).ready(function() {
        $('#formGrupo').on('submit', function(e) {
            e.preventDefault();

            const formData = $(this).serializeArray();
            const data = {};
            formData.forEach(item => {
                data[item.name] = item.value;
            });

            $('input[type="checkbox"]').each(function() {
                if (!$(this).is(':checked')) {
                    data[$(this).attr('name')] = '0';
                }
            });

            $.ajax({
                url: appUrl('/grupos/editar'),
                type: 'POST',
                data: data,
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Sucesso!',
                            text: response.message,
                            timer: 1500
                        }).then(() => {
                            window.location.href = response.redirect || '/grupos';
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro!',
                            text: response.message
                        });
                    }
                },
                error: function(xhr) {
                    console.error('Erro:', xhr);
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: 'Erro ao atualizar grupo. Verifique os dados.'
                    });
                }
            });
        });
    });
})();
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'grupos';
include ROOT_PATH . '/views/layouts/app.php';
?>
