<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-geo-alt me-2"></i> Locais de Estoque</h2>
        <p class="text-muted">Gerencie os locais de armazenamento</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/gestor-estoque/criar') ?>" class="btn btn-primary">
            <i class="bi bi-plus-circle me-2"></i> Novo Local
        </a>
    </div>
</div>

<!-- Listagem -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span><i class="bi bi-list-ul me-2"></i> Lista de Locais</span>
        <span class="badge bg-primary"><?= count($locais ?? []) ?> registro(s)</span>
    </div>
    <div class="card-body p-0">
        <?php if (!empty($locais)): ?>
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th width="80">Código</th>
                            <th>Nome</th>
                            <th width="120">Tipo</th>
                            <th>Descrição</th>
                            <th width="80">Status</th>
                            <th width="120" class="text-center">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($locais as $local): ?>
                            <tr>
                                <td><code>#<?= str_pad($local['id'], 4, '0', STR_PAD_LEFT) ?></code></td>
                                <td><strong><?= htmlspecialchars($local['name']) ?></strong></td>
                                <td>
                                    <?php
                                    $tipos = [
                                        'entrada' => '<span class="badge bg-success"><i class="bi bi-arrow-down-circle me-1"></i>Entrada</span>',
                                        'saida' => '<span class="badge bg-danger"><i class="bi bi-arrow-up-circle me-1"></i>Saída</span>',
                                        'ambos' => '<span class="badge bg-info"><i class="bi bi-arrows-collapse me-1"></i>Ambos</span>'
                                    ];
                                    echo $tipos[$local['tipo'] ?? ''] ?? '<span class="badge bg-secondary">-</span>';
                                    ?>
                                </td>
                                <td><small
                                        class="text-muted"><?= htmlspecialchars(substr($local['notes'] ?? $local['description'] ?? '', 0, 40)) ?><?= strlen($local['notes'] ?? $local['description'] ?? '') > 40 ? '...' : '' ?></small>
                                </td>
                                <td>
                                    <?php if ($local['is_active']): ?>
                                        <span class="badge bg-success">Ativo</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary">Inativo</span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <div class="btn-group btn-group-sm">
                                        <a href="<?= url('/gestor-estoque/editar?id=' . $local['id']) ?>"
                                            class="btn btn-outline-primary" title="Editar">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        <button class="btn btn-outline-danger" onclick="deletarLocal(<?= $local['id'] ?>)"
                                            title="Excluir">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-geo-alt" style="font-size: 4rem; color: var(--text-secondary);"></i>
                <p class="text-muted mt-3">Nenhum local encontrado</p>
                <a href="<?= url('/gestor-estoque/criar') ?>" class="btn btn-primary mt-2">
                    <i class="bi bi-plus-circle me-2"></i> Cadastrar Primeiro Local
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
    async function deletarLocal(id) {
        const confirmed = await confirmDelete('Tem certeza que deseja excluir este local?');
        if (confirmed) {
            $.ajax({
                url: appUrl('/gestor-estoque/deletar'),
                type: 'POST',
                data: { id: id },
                dataType: 'json',
                success: function (response) {
                    if (response.success) {
                        Toast.success(response.message);
                        setTimeout(() => location.reload(), 1500);
                    } else {
                        Toast.error(response.message);
                    }
                }
            });
        }
    }
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'gestor-estoque';
include ROOT_PATH . '/views/layouts/app.php';
?>