<div class="row">
    <!-- Nome -->
    <div class="col-md-6 mb-3">
        <label for="name" class="form-label">Nome do Local *</label>
        <input type="text" class="form-control" id="name" name="name"
            value="<?= htmlspecialchars($local['name'] ?? '') ?>" placeholder="Ex: Depósito Principal" required>
    </div>

    <!-- Tipo -->
    <div class="col-md-6 mb-3">
        <label for="tipo" class="form-label">Tipo *</label>
        <select class="form-control" id="tipo" name="tipo" required>
            <option value="">Selecione...</option>
            <option value="entrada" <?= ($local['tipo'] ?? '') === 'entrada' ? 'selected' : '' ?>>Entrada</option>
            <option value="saida" <?= ($local['tipo'] ?? '') === 'saida' ? 'selected' : '' ?>>Saída</option>
            <option value="ambos" <?= ($local['tipo'] ?? '') === 'ambos' ? 'selected' : '' ?>>Ambos</option>
        </select>
    </div>

    <!-- Posições -->
    <div class="col-md-12 mb-3">
        <label class="form-label">Posições</label>
        <div class="input-group mb-2">
            <input type="text" class="form-control" id="nova_posicao" placeholder="Ex: Prateleira A-1, Corredor 2-B">
            <button type="button" class="btn btn-primary" id="btn_add_posicao">
                <i class="bi bi-plus-circle me-1"></i> Adicionar
            </button>
        </div>

        <!-- Tabela de posições -->
        <div class="table-responsive" id="tabela_posicoes_wrapper"
            style="<?= empty($posicoes ?? []) ? 'display: none;' : '' ?>">
            <table class="table table-bordered table-hover mb-0" id="tabela_posicoes">
                <thead class="table-light">
                    <tr>
                        <th width="50">#</th>
                        <th>Posição</th>
                        <th width="100" class="text-center">Ações</th>
                    </tr>
                </thead>
                <tbody id="tbody_posicoes">
                    <?php if (!empty($posicoes ?? [])): ?>
                        <?php foreach ($posicoes as $index => $posicao): ?>
                            <tr data-posicao-index="<?= $index ?>">
                                <td><?= $index + 1 ?></td>
                                <td>
                                    <input type="hidden" name="posicoes[<?= $index ?>][id]" value="<?= $posicao['id'] ?? '' ?>">
                                    <input type="hidden" name="posicoes[<?= $index ?>][posicao]"
                                        value="<?= htmlspecialchars($posicao['posicao']) ?>">
                                    <strong><?= htmlspecialchars($posicao['posicao']) ?></strong>
                                </td>
                                <td class="text-center">
                                    <button type="button" class="btn btn-sm btn-outline-danger btn-remover-posicao"
                                        title="Remover">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Mensagem quando não há posições -->
        <div id="msg_sem_posicoes" class="alert alert-info mb-0"
            style="<?= !empty($posicoes ?? []) ? 'display: none;' : '' ?>">
            <i class="bi bi-info-circle me-2"></i> Nenhuma posição cadastrada. Adicione posições acima.
        </div>
    </div>

    <!-- Descrição -->
    <div class="col-md-12 mb-3">
        <label for="description" class="form-label">Descrição</label>
        <textarea class="form-control" id="description" name="description" rows="3"
            placeholder="Informações adicionais sobre o local..."><?= htmlspecialchars($local['notes'] ?? $local['description'] ?? '') ?></textarea>
    </div>

    <?php if ($isEdit): ?>
        <!-- Status (apenas no edit) -->
        <div class="col-md-12 mb-3">
            <div class="form-check form-switch">
                <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1"
                    <?= ($local['is_active'] ?? 1) ? 'checked' : '' ?>>
                <label class="form-check-label" for="is_active">
                    Local ativo
                </label>
            </div>
            <small class="text-muted">Locais inativos não aparecem nas seleções</small>
        </div>
    <?php endif; ?>
</div>

<script>
    $(document).ready(function () {
        let posicaoIndex = <?= count($posicoes ?? []) ?>;
        const tbodyPosicoes = $('#tbody_posicoes');
        const tabelaWrapper = $('#tabela_posicoes_wrapper');
        const msgSemPosicoes = $('#msg_sem_posicoes');
        const inputNovaPosicao = $('#nova_posicao');

        // Inicializar índice baseado nas posições já existentes
        const linhasExistentes = tbodyPosicoes.find('tr').length;
        if (linhasExistentes > 0) {
            // Pegar o maior índice existente para continuar a partir dele
            let maxIndex = -1;
            tbodyPosicoes.find('tr').each(function () {
                const nameAttr = $(this).find('input[type="hidden"][name*="[posicao]"]').attr('name');
                if (nameAttr) {
                    const match = nameAttr.match(/\[(\d+)\]/);
                    if (match) {
                        const index = parseInt(match[1]);
                        if (index > maxIndex) {
                            maxIndex = index;
                        }
                    }
                }
            });
            posicaoIndex = maxIndex + 1;
        }

        // Função para atualizar numeração das linhas e índices dos inputs
        function atualizarNumeracao() {
            tbodyPosicoes.find('tr').each(function (index) {
                $(this).find('td:first').text(index + 1);

                // Atualizar índices dos inputs hidden
                $(this).find('input[type="hidden"]').each(function () {
                    const name = $(this).attr('name');
                    if (name) {
                        const newName = name.replace(/\[\d+\]/, `[${index}]`);
                        $(this).attr('name', newName);
                    }
                });
            });
        }

        // Adicionar posição
        $('#btn_add_posicao').on('click', function () {
            const posicao = inputNovaPosicao.val().trim();

            if (!posicao) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Atenção',
                    text: 'Informe a posição antes de adicionar'
                });
                inputNovaPosicao.focus();
                return;
            }

            // Verificar se já existe
            let existe = false;
            tbodyPosicoes.find('tr').each(function () {
                const posicaoExistente = $(this).find('input[type="hidden"][name*="[posicao]"]').val();
                if (posicaoExistente === posicao) {
                    existe = true;
                    return false;
                }
            });

            if (existe) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Atenção',
                    text: 'Esta posição já foi adicionada'
                });
                inputNovaPosicao.focus();
                return;
            }

            // Adicionar linha na tabela
            const row = `
            <tr data-posicao-index="${posicaoIndex}">
                <td>${tbodyPosicoes.find('tr').length + 1}</td>
                <td>
                    <input type="hidden" name="posicoes[${posicaoIndex}][posicao]" value="${posicao.replace(/"/g, '&quot;').replace(/'/g, '&#39;')}">
                    <strong>${posicao.replace(/</g, '&lt;').replace(/>/g, '&gt;')}</strong>
                </td>
                <td class="text-center">
                    <button type="button" class="btn btn-sm btn-outline-danger btn-remover-posicao" title="Remover">
                        <i class="bi bi-trash"></i>
                    </button>
                </td>
            </tr>
        `;

            tbodyPosicoes.append(row);
            inputNovaPosicao.val('').focus();
            posicaoIndex++;

            // Atualizar numeração
            atualizarNumeracao();

            // Mostrar tabela e ocultar mensagem
            tabelaWrapper.show();
            msgSemPosicoes.hide();
        });

        // Permitir adicionar com Enter
        inputNovaPosicao.on('keypress', function (e) {
            if (e.which === 13) {
                e.preventDefault();
                $('#btn_add_posicao').click();
            }
        });

        // Remover posição
        $(document).on('click', '.btn-remover-posicao', function () {
            const row = $(this).closest('tr');

            Swal.fire({
                icon: 'question',
                title: 'Confirmar remoção',
                text: 'Deseja realmente remover esta posição?',
                showCancelButton: true,
                confirmButtonText: 'Sim, remover',
                cancelButtonText: 'Cancelar',
                confirmButtonColor: '#dc3545'
            }).then((result) => {
                if (result.isConfirmed) {
                    row.remove();
                    atualizarNumeracao();

                    // Se não houver mais posições, ocultar tabela e mostrar mensagem
                    if (tbodyPosicoes.find('tr').length === 0) {
                        tabelaWrapper.hide();
                        msgSemPosicoes.show();
                    }
                }
            });
        });
    });
</script>