<?php
ob_start();
?>

<!-- Breadcrumb -->
<nav aria-label="breadcrumb" class="mb-3">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>"><i class="bi bi-house-door"></i> Home</a></li>
        <li class="breadcrumb-item"><a href="<?= url('/gestor-estoque') ?>">Locais de Estoque</a></li>
        <li class="breadcrumb-item active">Editar Local</li>
    </ol>
</nav>

<!-- Título -->
<div class="row mb-4">
    <div class="col-md-12">
        <h2><i class="bi bi-pencil me-2"></i> Editar Local de Estoque</h2>
        <p class="text-muted">Atualize as informações do local</p>
    </div>
</div>

<!-- Formulário -->
<div class="card">
    <div class="card-body">
        <form id="formLocal" action="<?= url('/gestor-estoque/editar') ?>" method="POST">
            <input type="hidden" name="id" value="<?= $local['id'] ?>">

            <?php
            $isEdit = true;
            include __DIR__ . '/form.php';
            ?>

            <div class="row mt-4">
                <div class="col-12">
                    <button type="submit" class="btn btn-primary btn-lg">
                        <i class="bi bi-check-circle me-2"></i> Salvar Alterações
                    </button>
                    <a href="<?= url('/gestor-estoque') ?>" class="btn btn-secondary btn-lg">
                        <i class="bi bi-x-circle me-2"></i> Cancelar
                    </a>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
    $(document).ready(function () {
        $('#formLocal').on('submit', function (e) {
            e.preventDefault();

            // Coletar dados do formulário incluindo posições dinâmicas
            const formData = new FormData(this);

            // Converter FormData para objeto serializado (para compatibilidade)
            const serializedData = {};
            for (let [key, value] of formData.entries()) {
                if (serializedData[key]) {
                    if (Array.isArray(serializedData[key])) {
                        serializedData[key].push(value);
                    } else {
                        serializedData[key] = [serializedData[key], value];
                    }
                } else {
                    serializedData[key] = value;
                }
            }

            // Usar serialize para arrays (posicoes[])
            const formDataSerialized = $(this).serialize();

            $.ajax({
                url: $(this).attr('action'),
                type: 'POST',
                data: formDataSerialized,
                dataType: 'json',
                success: function (response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Sucesso!',
                            text: response.message,
                            timer: 1500,
                            showConfirmButton: false
                        }).then(() => {
                            window.location.href = response.redirect || '<?= url('/gestor-estoque') ?>';
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro!',
                            text: response.message || 'Erro ao atualizar local'
                        });
                    }
                },
                error: function () {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: 'Erro ao processar requisição'
                    });
                }
            });
        });
    });
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'gestor-estoque';
include ROOT_PATH . '/views/layouts/app.php';
?>