<?php
ob_start();
?>

<!-- Breadcrumb -->
<nav aria-label="breadcrumb" class="mb-3">
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>"><i class="bi bi-house-door"></i> Home</a></li>
        <li class="breadcrumb-item"><a href="<?= url('/gestor-estoque') ?>">Locais de Estoque</a></li>
        <li class="breadcrumb-item active">Novo Local</li>
    </ol>
</nav>

<!-- Título -->
<div class="row mb-4">
    <div class="col-md-12">
        <h2><i class="bi bi-geo-alt me-2"></i> Novo Local de Estoque</h2>
        <p class="text-muted">Cadastre um novo local para armazenamento</p>
    </div>
</div>

<!-- Formulário -->
<div class="card">
    <div class="card-body">
        <form id="formLocal" action="<?= url('/gestor-estoque/criar') ?>" method="POST">
            <?php
            $local = $local ?? [];
            $posicoes = $posicoes ?? [];
            $isEdit = false;
            include __DIR__ . '/form.php';
            ?>

            <div class="row mt-4">
                <div class="col-12">
                    <button type="submit" class="btn btn-primary btn-lg">
                        <i class="bi bi-check-circle me-2"></i> Salvar Local
                    </button>
                    <a href="<?= url('/gestor-estoque') ?>" class="btn btn-secondary btn-lg">
                        <i class="bi bi-x-circle me-2"></i> Cancelar
                    </a>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
    $(document).ready(function () {
        $('#formLocal').on('submit', function (e) {
            e.preventDefault();

            // Coletar dados do formulário incluindo posições dinâmicas
            const formDataSerialized = $(this).serialize();

            $.ajax({
                url: $(this).attr('action'),
                type: 'POST',
                data: formDataSerialized,
                dataType: 'json',
                success: function (response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Sucesso!',
                            text: response.message,
                            timer: 1500,
                            showConfirmButton: false
                        }).then(() => {
                            window.location.href = response.redirect || '<?= url('/gestor-estoque') ?>';
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro!',
                            text: response.message || 'Erro ao salvar local'
                        });
                    }
                },
                error: function () {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: 'Erro ao processar requisição'
                    });
                }
            });
        });
    });
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'gestor-estoque';
include ROOT_PATH . '/views/layouts/app.php';
?>