<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-bank me-2"></i> Saldo Bancário</h2>
        <p class="text-muted">Consulte o saldo atual e do dia anterior de suas contas bancárias</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/fluxo-caixa') ?>" class="btn btn-secondary">
            <i class="bi bi-arrow-left me-2"></i> Voltar
        </a>
    </div>
</div>

<div class="row mb-3">
    <div class="col-md-12">
        <div class="alert alert-info">
            <i class="bi bi-info-circle me-2"></i>
            <strong>Data de Referência:</strong>
            Saldo do dia anterior: <?= date('d/m/Y', strtotime($dataOntem)) ?> |
            Saldo atual: <?= date('d/m/Y', strtotime($dataHoje)) ?>
        </div>
    </div>
</div>

<?php if (empty($contas)): ?>
    <div class="card">
        <div class="card-body text-center py-5">
            <i class="bi bi-bank" style="font-size: 4rem; color: var(--text-secondary);"></i>
            <p class="text-muted mt-3">Nenhuma conta bancária cadastrada</p>
            <a href="<?= url('/contas/criar') ?>" class="btn btn-primary mt-2">
                <i class="bi bi-plus-circle me-2"></i> Cadastrar Conta Bancária
            </a>
        </div>
    </div>
<?php else: ?>
    <div class="row">
        <?php foreach ($contas as $conta): ?>
            <div class="col-md-6 mb-4">
                <div class="card h-100">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">
                            <i class="bi bi-bank me-2"></i>
                            <?= htmlspecialchars($conta['bank_name']) ?>
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <small class="text-muted">Agência / Conta</small>
                            <p class="mb-0">
                                <strong><?= htmlspecialchars($conta['agency']) ?> /
                                    <?= htmlspecialchars($conta['account_number']) ?></strong>
                            </p>
                        </div>

                        <div class="row mb-3">
                            <div class="col-6">
                                <small class="text-muted d-block">Saldo Inicial</small>
                                <h6 class="mb-0">R$ <?= formatCurrency($conta['saldo_inicial']) ?></h6>
                            </div>
                            <div class="col-6">
                                <small class="text-muted d-block">Limite de Crédito</small>
                                <h6 class="mb-0">R$ <?= formatCurrency($conta['credit_limit'] ?? 0) ?></h6>
                            </div>
                        </div>

                        <hr>

                        <div class="row">
                            <div class="col-6">
                                <small class="text-muted d-block">Saldo do Dia Anterior</small>
                                <h5 class="mb-0 <?= ($conta['saldo_ontem'] ?? 0) >= 0 ? 'text-success' : 'text-danger' ?>">
                                    R$ <?= formatCurrency($conta['saldo_ontem'] ?? 0) ?>
                                </h5>
                                <small class="text-muted"><?= date('d/m/Y', strtotime($dataOntem)) ?></small>
                            </div>
                            <div class="col-6">
                                <small class="text-muted d-block">Saldo Atual</small>
                                <h5 class="mb-0 <?= ($conta['saldo_atual'] ?? 0) >= 0 ? 'text-success' : 'text-danger' ?>">
                                    R$ <?= formatCurrency($conta['saldo_atual'] ?? 0) ?>
                                </h5>
                                <small class="text-muted"><?= date('d/m/Y', strtotime($dataHoje)) ?></small>
                            </div>
                        </div>

                        <?php
                        $variacao = ($conta['saldo_atual'] ?? 0) - ($conta['saldo_ontem'] ?? 0);
                        if ($variacao != 0):
                            ?>
                            <div
                                class="mt-3 p-2 rounded <?= $variacao > 0 ? 'bg-success bg-opacity-10' : 'bg-danger bg-opacity-10' ?>">
                                <small class="d-block text-muted">Variação do Dia</small>
                                <strong class="<?= $variacao > 0 ? 'text-success' : 'text-danger' ?>">
                                    <?= $variacao > 0 ? '+' : '' ?>R$ <?= formatCurrency(abs($variacao)) ?>
                                </strong>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>

<?php
$content = ob_get_clean();
$activeMenu = 'fluxo-caixa';
include ROOT_PATH . '/views/layouts/app.php';
?>