<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-calendar-day me-2"></i> Movimentação do Dia</h2>
        <p class="text-muted">Todas as movimentações financeiras do dia atual</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/fluxo-caixa') ?>" class="btn btn-secondary">
            <i class="bi bi-arrow-left me-2"></i> Voltar
        </a>
    </div>
</div>

<!-- Resumo do Dia -->
<div class="row mb-4">
    <div class="col-md-4">
        <div class="card bg-success text-white">
            <div class="card-body text-center">
                <h4 class="mb-0">R$ <?= formatCurrency($totalEntradas ?? 0) ?></h4>
                <small class="opacity-75"><i class="bi bi-arrow-up-circle me-1"></i> Entradas</small>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-danger text-white">
            <div class="card-body text-center">
                <h4 class="mb-0">R$ <?= formatCurrency($totalSaidas ?? 0) ?></h4>
                <small class="opacity-75"><i class="bi bi-arrow-down-circle me-1"></i> Saídas</small>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card <?= ($saldoDia ?? 0) >= 0 ? 'bg-primary' : 'bg-warning' ?> text-white">
            <div class="card-body text-center">
                <h4 class="mb-0">R$ <?= formatCurrency($saldoDia ?? 0) ?></h4>
                <small class="opacity-75"><i class="bi bi-wallet2 me-1"></i> Saldo do Dia</small>
            </div>
        </div>
    </div>
</div>

<!-- Listagem -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span><i class="bi bi-list-ul me-2"></i> Movimentações de <?= date('d/m/Y', strtotime($dataHoje)) ?></span>
        <span class="badge bg-primary"><?= count($movimentos ?? []) ?> registro(s)</span>
    </div>
    <div class="card-body p-0">
        <?php if (!empty($movimentos)): ?>
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th width="60" class="align-middle">ID</th>
                            <th width="120" class="align-middle">Hora</th>
                            <th width="200" class="align-middle">Pessoa</th>
                            <th width="200" class="align-middle">Plano de Contas</th>
                            <th class="align-middle">Descrição</th>
                            <?php if ($hasContaBancaria ?? false): ?>
                                <th width="150" class="align-middle">Conta Bancária</th>
                            <?php endif; ?>
                            <th width="120" class="text-end align-middle">Valor</th>
                            <th width="120" class="text-end align-middle">Saldo</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($movimentos as $movimento): ?>
                            <?php
                            // Limitar nome da pessoa a 40 caracteres
                            $pessoaNome = $movimento['pessoa_nome'] ?? '';
                            $pessoaNomeCompleto = $pessoaNome;
                            $pessoaNomeLimitado = mb_strlen($pessoaNome) > 40 ? mb_substr($pessoaNome, 0, 40) . '...' : $pessoaNome;

                            // Remover "Venda" da descrição
                            $descricao = $movimento['description'] ?? '';
                            $descricao = preg_replace('/^Venda\s+/i', '', $descricao);
                            ?>
                            <tr style="cursor: pointer;" data-id="<?= $movimento['id'] ?>" onclick="abrirOpcoes(this)">
                                <td class="align-middle"><?= $movimento['id'] ?></td>
                                <td class="align-middle">
                                    <?= date('H:i', strtotime($movimento['created_at'] ?? $movimento['date'])) ?>
                                </td>
                                <td class="align-middle">
                                    <?php if (!empty($pessoaNome)): ?>
                                        <small class="fw-bold d-block text-truncate"
                                            title="<?= htmlspecialchars($pessoaNomeCompleto) ?>" style="max-width: 180px;">
                                            <?= htmlspecialchars($pessoaNomeLimitado) ?>
                                        </small>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td class="align-middle">
                                    <?php if (!empty($movimento['plano_nome'])): ?>
                                        <small class="d-block text-truncate" style="max-width: 180px;"
                                            title="<?= htmlspecialchars(($movimento['plano_codigo'] ?? '') . ' - ' . ($movimento['plano_nome'] ?? '')) ?>">
                                            <strong><?= htmlspecialchars($movimento['plano_codigo'] ?? '') ?></strong>
                                            <?= htmlspecialchars($movimento['plano_nome']) ?>
                                        </small>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td class="align-middle">
                                    <span class="text-truncate d-inline-block" style="max-width: 300px;"
                                        title="<?= htmlspecialchars($descricao) ?>">
                                        <?= htmlspecialchars($descricao) ?>
                                    </span>
                                </td>
                                <?php if ($hasContaBancaria ?? false): ?>
                                    <td class="align-middle">
                                        <?php if (!empty($movimento['bank_name'])): ?>
                                            <small>
                                                <?= htmlspecialchars($movimento['bank_name']) ?>
                                                <?php if (!empty($movimento['account_number'])): ?>
                                                    <br><span
                                                        class="text-muted"><?= htmlspecialchars($movimento['account_number']) ?></span>
                                                <?php endif; ?>
                                            </small>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                <?php endif; ?>
                                <td class="text-end align-middle">
                                    <span
                                        class="fw-bold <?= $movimento['type'] === 'entrada' ? 'text-success' : 'text-danger' ?>"
                                        style="white-space: nowrap;">
                                        <?= $movimento['type'] === 'entrada' ? '+' : '-' ?>
                                        <?= formatCurrency($movimento['amount']) ?>
                                    </span>
                                </td>
                                <td class="text-end align-middle">
                                    <span style="white-space: nowrap;">
                                        <?= formatCurrency($movimento['balance'] ?? 0) ?>
                                    </span>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-calendar-day" style="font-size: 4rem; color: var(--text-secondary);"></i>
                <p class="text-muted mt-3">Nenhuma movimentação registrada hoje</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
    function abrirOpcoes(row) {
        const id = row.dataset.id;
        window.location.href = appUrl('/fluxo-caixa/editar?id=' + id);
    }
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'fluxo-caixa';
include ROOT_PATH . '/views/layouts/app.php';
?>