<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-cash-stack me-2"></i> Fluxo de Caixa</h2>
        <p class="text-muted">Controle suas entradas e saídas financeiras</p>
    </div>
    <div class="col-md-6 text-end">
        <div class="btn-group" role="group">
            <a href="<?= url('/fluxo-caixa/saldo-bancario') ?>" class="btn btn-outline-primary" data-bs-toggle="tooltip"
                data-bs-placement="bottom" title="Saldo Bancário">
                <i class="bi bi-bank"></i>
            </a>
            <a href="<?= url('/fluxo-caixa/conciliacao') ?>" class="btn btn-outline-primary" data-bs-toggle="tooltip"
                data-bs-placement="bottom" title="Conciliação">
                <i class="bi bi-check2-square"></i>
            </a>
            <a href="<?= url('/fluxo-caixa/movimentacao-dia') ?>" class="btn btn-outline-primary"
                data-bs-toggle="tooltip" data-bs-placement="bottom" title="Movimentação do Dia">
                <i class="bi bi-calendar-day"></i>
            </a>
            <a href="<?= url('/fluxo-caixa/criar') ?>" class="btn btn-primary">
                <i class="bi bi-plus-circle me-2"></i> Nova Movimentação
            </a>
        </div>
    </div>
</div>

<!-- Resumo -->
<div class="row mb-4">
    <div class="col-md-4">
        <div class="card bg-success text-white">
            <div class="card-body text-center">
                <h4 class="mb-0">R$ <?= formatCurrency($totalEntradas ?? 0) ?></h4>
                <small class="opacity-75"><i class="bi bi-arrow-up-circle me-1"></i> Entradas</small>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-danger text-white">
            <div class="card-body text-center">
                <h4 class="mb-0">R$ <?= formatCurrency($totalSaidas ?? 0) ?></h4>
                <small class="opacity-75"><i class="bi bi-arrow-down-circle me-1"></i> Saídas</small>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card <?= ($saldoTotal ?? 0) >= 0 ? 'bg-primary' : 'bg-warning' ?> text-white">
            <div class="card-body text-center">
                <h4 class="mb-0">R$ <?= formatCurrency($saldoTotal ?? 0) ?></h4>
                <small class="opacity-75"><i class="bi bi-wallet2 me-1"></i> Saldo</small>
            </div>
        </div>
    </div>
</div>

<!-- Filtros -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" class="row g-3">
            <div class="col-md-3">
                <input type="text" class="form-control" name="search" placeholder="Buscar por descrição, categoria..."
                    value="<?= htmlspecialchars($search ?? '') ?>">
            </div>
            <div class="col-md-2">
                <select class="form-select" name="type">
                    <option value="">Todos os Tipos</option>
                    <option value="entrada" <?= ($type ?? '') === 'entrada' ? 'selected' : '' ?>>Entrada</option>
                    <option value="saida" <?= ($type ?? '') === 'saida' ? 'selected' : '' ?>>Saída</option>
                </select>
            </div>
            <div class="col-md-2">
                <input type="date" class="form-control" name="date_from"
                    value="<?= htmlspecialchars($date_from ?? '') ?>">
            </div>
            <div class="col-md-2">
                <input type="date" class="form-control" name="date_to" value="<?= htmlspecialchars($date_to ?? '') ?>">
            </div>
            <div class="col-md-3">
                <button type="submit" class="btn btn-secondary w-100">
                    <i class="bi bi-search"></i> Buscar
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Listagem -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span><i class="bi bi-list-ul me-2"></i> Lista de Movimentações</span>
        <span class="badge bg-primary"><?= count($movimentos ?? []) ?> registro(s)</span>
    </div>
    <div class="card-body p-0">
        <?php if (!empty($movimentos)): ?>
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th width="60" class="align-middle">ID</th>
                            <th width="100" class="align-middle">Data</th>
                            <th width="200" class="align-middle">Pessoa</th>
                            <th width="200" class="align-middle">Plano de Contas</th>
                            <th class="align-middle">Descrição</th>
                            <th width="120" class="text-end align-middle">Valor</th>
                            <th width="120" class="text-end align-middle">Saldo</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($movimentos as $movimento): ?>
                            <?php
                            // Limitar nome da pessoa a 40 caracteres
                            $pessoaNome = $movimento['pessoa_nome'] ?? '';
                            $pessoaNomeCompleto = $pessoaNome;
                            $pessoaNomeLimitado = mb_strlen($pessoaNome) > 40 ? mb_substr($pessoaNome, 0, 40) . '...' : $pessoaNome;

                            // Formatar CNPJ/CPF
                            $documento = $movimento['pessoa_documento'] ?? '';
                            $documentoFormatado = '';
                            if (!empty($documento)) {
                                $documentoLimpo = preg_replace('/\D/', '', $documento);
                                if (strlen($documentoLimpo) === 11) {
                                    $documentoFormatado = formatCPF($documentoLimpo);
                                } elseif (strlen($documentoLimpo) === 14) {
                                    $documentoFormatado = formatCNPJ($documentoLimpo);
                                } else {
                                    $documentoFormatado = $documento;
                                }
                            }

                            // Remover "Venda" da descrição
                            $descricao = $movimento['description'] ?? '';
                            $descricao = preg_replace('/^Venda\s+/i', '', $descricao);
                            ?>
                            <tr style="cursor: pointer;" data-id="<?= $movimento['id'] ?>"
                                data-data="<?= date('d/m/Y', strtotime($movimento['date'])) ?>"
                                data-tipo="<?= $movimento['type'] === 'entrada' ? 'Entrada' : 'Saída' ?>"
                                data-pessoa="<?= htmlspecialchars($pessoaNomeCompleto ?: '-', ENT_QUOTES) ?>"
                                data-plano="<?= htmlspecialchars(($movimento['plano_codigo'] ?? '') . ' - ' . ($movimento['plano_nome'] ?? '-'), ENT_QUOTES) ?>"
                                data-descricao="<?= htmlspecialchars($descricao, ENT_QUOTES) ?>"
                                data-valor="<?= formatCurrency($movimento['amount']) ?>"
                                data-reference-type="<?= htmlspecialchars($movimento['reference_type'] ?? '', ENT_QUOTES) ?>"
                                data-reference-id="<?= htmlspecialchars($movimento['reference_id'] ?? '', ENT_QUOTES) ?>"
                                data-plano-contas-id="<?= htmlspecialchars($movimento['plano_contas_id'] ?? '', ENT_QUOTES) ?>"
                                data-centro-custo-id="<?= htmlspecialchars($movimento['centro_custo_id'] ?? '', ENT_QUOTES) ?>"
                                onclick="abrirOpcoes(this)">
                                <td class="align-middle"><?= $movimento['id'] ?></td>
                                <td class="align-middle"><?= date('d/m/Y', strtotime($movimento['date'])) ?></td>
                                <td class="align-middle">
                                    <?php if (!empty($pessoaNome)): ?>
                                        <div class="d-flex align-items-center">
                                            <div
                                                class="avatar-xs bg-primary rounded-circle d-flex align-items-center justify-content-center me-2 flex-shrink-0">
                                                <i class="bi bi-person text-white" style="font-size: 0.7rem;"></i>
                                            </div>
                                            <div class="flex-grow-1" style="min-width: 0;">
                                                <small class="fw-bold d-block text-truncate"
                                                    title="<?= htmlspecialchars($pessoaNomeCompleto) ?>" style="max-width: 150px;">
                                                    <?= htmlspecialchars($pessoaNomeLimitado) ?>
                                                </small>
                                                <?php if (!empty($documentoFormatado)): ?>
                                                    <small
                                                        class="text-muted d-block"><?= htmlspecialchars($documentoFormatado) ?></small>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td class="align-middle">
                                    <?php if (!empty($movimento['plano_nome'])): ?>
                                        <small class="d-block text-truncate" style="max-width: 180px;"
                                            title="<?= htmlspecialchars(($movimento['plano_codigo'] ?? '') . ' - ' . ($movimento['plano_nome'] ?? '')) ?>">
                                            <strong><?= htmlspecialchars($movimento['plano_codigo'] ?? '') ?></strong>
                                            <?= htmlspecialchars($movimento['plano_nome']) ?>
                                        </small>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td class="align-middle">
                                    <span class="text-truncate d-inline-block" style="max-width: 300px;"
                                        title="<?= htmlspecialchars($descricao) ?>">
                                        <?= htmlspecialchars($descricao) ?>
                                    </span>
                                </td>
                                <td class="text-end align-middle">
                                    <span
                                        class="fw-bold <?= $movimento['type'] === 'entrada' ? 'text-success' : 'text-danger' ?>"
                                        style="white-space: nowrap;">
                                        <?= $movimento['type'] === 'entrada' ? '+' : '-' ?>
                                        <?= formatCurrency($movimento['amount']) ?>
                                    </span>
                                </td>
                                <td class="text-end align-middle">
                                    <span style="white-space: nowrap;">
                                        <?= formatCurrency($movimento['balance']) ?>
                                    </span>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="bi bi-cash-stack" style="font-size: 4rem; color: var(--text-secondary);"></i>
                <p class="text-muted mt-3">Nenhuma movimentação encontrada</p>
                <a href="<?= url('/fluxo-caixa/criar') ?>" class="btn btn-primary mt-2">
                    <i class="bi bi-plus-circle me-2"></i> Cadastrar Primeira Movimentação
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
    .avatar-xs {
        width: 24px;
        height: 24px;
        font-size: 12px;
    }

    /* Melhorar alinhamento e simetria da tabela */
    .table th,
    .table td {
        vertical-align: middle;
    }

    /* Garantir que valores não quebrem linha */
    .table td.text-end {
        white-space: nowrap;
    }

    /* Limitar largura das colunas para melhor alinhamento */
    .table td:nth-child(3) {
        max-width: 200px;
    }

    .table td:nth-child(4) {
        max-width: 200px;
    }

    .table td:nth-child(5) {
        max-width: 300px;
    }

    .opcoes-grid {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 12px;
        padding: 10px 0;
    }

    .opcoes-grid-3 {
        grid-template-columns: repeat(3, 1fr);
    }

    .opcoes-grid-4 {
        grid-template-columns: repeat(2, 1fr);
    }

    .opcao-card {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        padding: 16px 12px;
        border: none;
        border-radius: 10px;
        cursor: pointer;
        transition: all 0.2s ease;
        gap: 8px;
        min-height: 80px;
    }

    .opcao-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }

    .opcao-card i {
        font-size: 1.5rem;
    }

    .opcao-card span {
        font-size: 0.85rem;
        font-weight: 500;
    }

    .opcao-card-primary {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
    }

    .opcao-card-danger {
        background: linear-gradient(135deg, #ef4444, #dc2626);
        color: white;
    }
</style>

<script>
    function abrirOpcoes(row) {
        const id = row.dataset.id;
        const data = row.dataset.data;
        const tipo = row.dataset.tipo;
        const pessoa = row.dataset.pessoa;
        const plano = row.dataset.plano;
        const descricao = row.dataset.descricao;
        const valor = row.dataset.valor;
        const referenceType = row.dataset.referenceType || '';
        const planoContasId = row.dataset.planoContasId || '';
        const centroCustoId = row.dataset.centroCustoId || '';

        // Verificar se pode editar (não permitir se reference_type for contas_pagar ou contas_receber)
        const podeEditar = referenceType !== 'contas_pagar' && referenceType !== 'contas_receber';

        const headerHtml = `
        <div style="background: linear-gradient(135deg, #1e3a8a 0%, #3b82f6 100%);
                    margin: -20px -20px 20px -20px;
                    padding: 20px;
                    border-radius: 12px 12px 0 0;
                    color: white;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px;">
                <span style="font-size: 0.85rem; opacity: 0.9;">
                    <i class="bi bi-calendar3 me-1"></i> ${data}
                </span>
                <span class="badge ${tipo === 'Entrada' ? 'bg-success' : 'bg-danger'}">${tipo}</span>
            </div>
            <h5 style="margin: 0; font-weight: 600;">${descricao}</h5>
            ${pessoa && pessoa !== '-' ? `<p style="margin: 5px 0 0 0; font-size: 0.85rem; opacity: 0.9;"><i class="bi bi-person me-1"></i> ${pessoa}</p>` : ''}
            ${plano && plano !== ' - -' ? `<p style="margin: 3px 0 0 0; font-size: 0.8rem; opacity: 0.85;"><i class="bi bi-diagram-3 me-1"></i> ${plano}</p>` : ''}
            <p style="margin: 10px 0 0 0; font-size: 1.3rem; font-weight: bold;">
                ${valor}
            </p>
        </div>
    `;

        // Determinar quantas colunas usar baseado nos botões disponíveis
        // Sempre temos: Plano de Contas, Centro de Custos e Excluir (3 botões fixos)
        // Mais Editar se permitido (1 opcional)
        let numBotoes = 3; // Plano de Contas, Centro de Custos e Excluir sempre presentes
        if (podeEditar) numBotoes++;

        let gridClass = 'opcoes-grid';
        if (numBotoes === 3) {
            gridClass = 'opcoes-grid opcoes-grid-3';
        } else if (numBotoes >= 4) {
            gridClass = 'opcoes-grid opcoes-grid-4';
        }

        let buttonsHtml = `<div class="${gridClass}">`;

        // Botão Editar (apenas se podeEditar)
        if (podeEditar) {
            buttonsHtml += `
                <button type="button" class="opcao-card opcao-card-primary" onclick="window.location.href=appUrl('/fluxo-caixa/editar?id=${id}')">
                    <i class="bi bi-pencil"></i>
                    <span>Editar</span>
                </button>
            `;
        }

        // Botão Plano de Contas (sempre disponível para alterar)
        buttonsHtml += `
            <button type="button" class="opcao-card opcao-card-primary" onclick="Swal.close(); alterarPlanoContas(${id}, '${planoContasId || ''}')">
                <i class="bi bi-diagram-3"></i>
                <span>Plano de Contas</span>
            </button>
        `;

        // Botão Centro de Custos (sempre disponível para alterar)
        buttonsHtml += `
            <button type="button" class="opcao-card opcao-card-primary" onclick="Swal.close(); alterarCentroCusto(${id}, '${centroCustoId || ''}')">
                <i class="bi bi-folder"></i>
                <span>Centro de Custos</span>
            </button>
        `;

        // Botão Excluir (sempre presente)
        buttonsHtml += `
            <button type="button" class="opcao-card opcao-card-danger" onclick="Swal.close(); deletarMovimento(${id})">
                <i class="bi bi-trash"></i>
                <span>Excluir</span>
            </button>
        `;

        buttonsHtml += '</div>';

        Swal.fire({
            html: headerHtml + buttonsHtml,
            showConfirmButton: false,
            showCloseButton: true,
            width: 600,
            padding: '20px',
            customClass: {
                popup: 'swal-opcoes-popup'
            }
        });
    }

    async function deletarMovimento(id) {
        const confirmed = await confirmDelete('Tem certeza que deseja excluir esta movimentação?');
        if (confirmed) {
            $.ajax({
                url: appUrl('/fluxo-caixa/excluir'),
                type: 'POST',
                data: { id: id },
                dataType: 'json',
                success: function (response) {
                    if (response.success) {
                        Toast.success(response.message);
                        setTimeout(() => location.reload(), 1500);
                    } else {
                        Toast.error(response.message);
                    }
                }
            });
        }
    }

    async function alterarPlanoContas(movimentoId, planoContasIdAtual) {
        try {
            // Buscar planos de contas
            const response = await fetch(appUrl('/fluxo-caixa/planos-contas'));

            if (!response.ok) {
                Toast.error('Erro ao carregar planos de contas');
                return;
            }
            const result = await response.json();

            if (!result.success || !result.data) {
                Toast.error(result.message || 'Erro ao carregar planos de contas');
                return;
            }

            const planosContas = result.data;
            const options = planosContas.map(pc => ({
                value: pc.id,
                text: `${pc.codigo || ''} - ${pc.nome || ''}`.trim()
            }));

            // Adicionar opção "Nenhum"
            options.unshift({ value: '', text: 'Nenhum' });

            const { value: novoPlanoContasId } = await Swal.fire({
                title: '<i class="bi bi-diagram-3 me-2"></i> Alterar Plano de Contas',
                html: `
                    <div style="text-align: left; margin-bottom: 15px;">
                        <label for="swal-plano-contas" style="display: block; margin-bottom: 8px; font-weight: 500;">
                            Selecione o Plano de Contas:
                        </label>
                        <select id="swal-plano-contas" class="form-select" style="width: 100%; padding: 10px; font-size: 14px; border: 1px solid #ddd; border-radius: 5px;">
                            ${options.map(opt =>
                    `<option value="${opt.value}" ${opt.value == planoContasIdAtual ? 'selected' : ''}>${opt.text || 'Nenhum'}</option>`
                ).join('')}
                        </select>
                    </div>
                `,
                showCancelButton: true,
                confirmButtonText: '<i class="bi bi-check-lg me-1"></i> Salvar',
                cancelButtonText: '<i class="bi bi-x-lg me-1"></i> Cancelar',
                confirmButtonColor: '#0d6efd',
                cancelButtonColor: '#6c757d',
                width: 500,
                didOpen: () => {
                    const select = document.getElementById('swal-plano-contas');
                    if (select) {
                        select.focus();
                        // Melhorar estilo do select
                        select.style.cursor = 'pointer';
                    }
                },
                preConfirm: () => {
                    const select = document.getElementById('swal-plano-contas');
                    return select ? select.value : null;
                }
            });

            if (novoPlanoContasId !== null && novoPlanoContasId !== undefined) {
                // Atualizar via AJAX
                const formData = new FormData();
                formData.append('id', movimentoId);
                formData.append('plano_contas_id', novoPlanoContasId || '');

                const updateResponse = await fetch(appUrl('/fluxo-caixa/atualizar-plano-contas'), {
                    method: 'POST',
                    body: formData
                });

                if (!updateResponse.ok) {
                    Toast.error('Erro ao atualizar Plano de Contas');
                    return;
                }

                const updateResult = await updateResponse.json();

                if (updateResult.success) {
                    Toast.success(updateResult.message || 'Plano de Contas atualizado com sucesso');
                    setTimeout(() => location.reload(), 1000);
                } else {
                    Toast.error(updateResult.message || 'Erro ao atualizar Plano de Contas');
                }
            }
        } catch (error) {
            console.error('Erro ao alterar plano de contas:', error);
            Toast.error('Erro ao alterar Plano de Contas');
        }
    }

    async function alterarCentroCusto(movimentoId, centroCustoIdAtual) {
        try {
            // Buscar centros de custos
            const response = await fetch(appUrl('/fluxo-caixa/centros-custos'));

            if (!response.ok) {
                Toast.error('Erro ao carregar centros de custos');
                return;
            }

            const result = await response.json();

            if (!result.success || !result.data) {
                Toast.error(result.message || 'Erro ao carregar centros de custos');
                return;
            }

            const centrosCustos = result.data;
            const options = centrosCustos.map(cc => ({
                value: cc.id,
                text: `${cc.codigo || ''} - ${cc.nome || ''}`.trim()
            }));

            // Adicionar opção "Nenhum"
            options.unshift({ value: '', text: 'Nenhum' });

            const { value: novoCentroCustoId } = await Swal.fire({
                title: '<i class="bi bi-folder me-2"></i> Alterar Centro de Custos',
                html: `
                    <div style="text-align: left; margin-bottom: 15px;">
                        <label for="swal-centro-custo" style="display: block; margin-bottom: 8px; font-weight: 500;">
                            Selecione o Centro de Custos:
                        </label>
                        <select id="swal-centro-custo" class="form-select" style="width: 100%; padding: 10px; font-size: 14px; border: 1px solid #ddd; border-radius: 5px;">
                            ${options.map(opt =>
                    `<option value="${opt.value}" ${opt.value == centroCustoIdAtual ? 'selected' : ''}>${opt.text || 'Nenhum'}</option>`
                ).join('')}
                        </select>
                    </div>
                `,
                showCancelButton: true,
                confirmButtonText: '<i class="bi bi-check-lg me-1"></i> Salvar',
                cancelButtonText: '<i class="bi bi-x-lg me-1"></i> Cancelar',
                confirmButtonColor: '#0d6efd',
                cancelButtonColor: '#6c757d',
                width: 500,
                didOpen: () => {
                    const select = document.getElementById('swal-centro-custo');
                    if (select) {
                        select.focus();
                        // Melhorar estilo do select
                        select.style.cursor = 'pointer';
                    }
                },
                preConfirm: () => {
                    const select = document.getElementById('swal-centro-custo');
                    return select ? select.value : null;
                }
            });

            if (novoCentroCustoId !== null && novoCentroCustoId !== undefined) {
                // Atualizar via AJAX
                const formData = new FormData();
                formData.append('id', movimentoId);
                formData.append('centro_custo_id', novoCentroCustoId || '');

                const updateResponse = await fetch(appUrl('/fluxo-caixa/atualizar-centro-custo'), {
                    method: 'POST',
                    body: formData
                });

                if (!updateResponse.ok) {
                    Toast.error('Erro ao atualizar Centro de Custos');
                    return;
                }

                const updateResult = await updateResponse.json();

                if (updateResult.success) {
                    Toast.success(updateResult.message || 'Centro de Custos atualizado com sucesso');
                    setTimeout(() => location.reload(), 1000);
                } else {
                    Toast.error(updateResult.message || 'Erro ao atualizar Centro de Custos');
                }
            }
        } catch (error) {
            console.error('Erro ao alterar centro de custos:', error);
            Toast.error('Erro ao alterar Centro de Custos');
        }
    }

    // Inicializar tooltips
    document.addEventListener('DOMContentLoaded', function () {
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
    });
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'fluxo-caixa';
include ROOT_PATH . '/views/layouts/app.php';
?>