<?php
ob_start();
$mov = $movimento ?? [];
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-pencil me-2"></i> Editar Movimentação</h2>
        <p class="text-muted">Altere os dados da movimentação #<?= $mov['id'] ?? '' ?></p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/fluxo-caixa') ?>" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left me-2"></i> Voltar
        </a>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <i class="bi bi-cash-stack me-2"></i> Dados da Movimentação
    </div>
    <div class="card-body">
        <form id="formMovimentacao">
            <input type="hidden" name="id" value="<?= $mov['id'] ?? '' ?>">

            <div class="row">
                <div class="col-md-4 mb-3">
                    <label class="form-label">Data <span class="text-danger">*</span></label>
                    <input type="date" class="form-control" name="date" value="<?= $mov['date'] ?? date('Y-m-d') ?>"
                        required>
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Tipo <span class="text-danger">*</span></label>
                    <select class="form-select" name="type" required>
                        <option value="">Selecione...</option>
                        <option value="entrada" <?= ($mov['type'] ?? '') === 'entrada' ? 'selected' : '' ?>>Entrada
                        </option>
                        <option value="saida" <?= ($mov['type'] ?? '') === 'saida' ? 'selected' : '' ?>>Saída</option>
                    </select>
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Valor <span class="text-danger">*</span></label>
                    <input type="number" class="form-control" name="amount" step="0.01" min="0.01"
                        value="<?= $mov['amount'] ?? '' ?>" required>
                </div>
            </div>

            <div class="row">
                <div class="col-md-8 mb-3">
                    <label class="form-label">Descrição <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" name="description"
                        value="<?= htmlspecialchars($mov['description'] ?? '') ?>" required>
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Pessoa (Cliente/Fornecedor)</label>
                    <div class="position-relative">
                        <input type="text" class="form-control" id="pessoa_search" placeholder="Digite para buscar..."
                            autocomplete="off" value="<?php
                            $pessoaSelecionada = null;
                            foreach ($pessoas ?? [] as $p) {
                                if ($p['id'] == ($mov['people_id'] ?? '')) {
                                    $pessoaSelecionada = $p;
                                    echo htmlspecialchars($p['name']);
                                    break;
                                }
                            }
                            ?>">
                        <div id="pessoa_dropdown" class="autocomplete-dropdown" style="display: none;"></div>
                    </div>
                    <input type="hidden" name="people_id" id="people_id" value="<?= $mov['people_id'] ?? '' ?>">
                    <div id="pessoa_info" class="mt-2 p-2 bg-light rounded small"
                        style="<?= !empty($mov['people_id']) ? '' : 'display: none;' ?>">
                        <span
                            id="pessoa_info_text"><?php if ($pessoaSelecionada): ?><strong><?= htmlspecialchars($pessoaSelecionada['name']) ?></strong>
                                <?= $pessoaSelecionada['document'] ? '- ' . $pessoaSelecionada['document'] : '' ?><?php endif; ?></span>
                        <button type="button" class="btn btn-sm btn-link text-danger p-0 ms-2" onclick="limparPessoa()">
                            <i class="bi bi-x-circle"></i> Limpar
                        </button>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-4 mb-3">
                    <label class="form-label">Responsável</label>
                    <select class="form-select" name="responsible_id" id="responsible_id">
                        <option value="">Selecione...</option>
                        <?php foreach ($usuarios ?? [] as $usuario): ?>
                            <option value="<?= $usuario['id'] ?>" <?= ($mov['responsible_id'] ?? '') == $usuario['id'] ? 'selected' : '' ?>><?= htmlspecialchars($usuario['name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Plano de Contas</label>
                    <select class="form-select" name="plano_contas_id">
                        <option value="">Selecione...</option>
                        <?php foreach ($planosContas ?? [] as $plano): ?>
                            <option value="<?= $plano['id'] ?>" <?= ($mov['plano_contas_id'] ?? '') == $plano['id'] ? 'selected' : '' ?>><?= htmlspecialchars($plano['codigo'] . ' - ' . $plano['nome']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Centro de Custos</label>
                    <select class="form-select" name="centro_custo_id">
                        <option value="">Selecione...</option>
                        <?php foreach ($centrosCustos ?? [] as $centro): ?>
                            <option value="<?= $centro['id'] ?>" <?= ($mov['centro_custo_id'] ?? '') == $centro['id'] ? 'selected' : '' ?>><?= htmlspecialchars($centro['codigo'] . ' - ' . $centro['nome']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>

            <input type="hidden" name="reference_type" value="fluxo_caixa">

            <hr>

            <div class="d-flex justify-content-between">
                <button type="button" class="btn btn-outline-danger" onclick="deletarMovimento(<?= $mov['id'] ?? 0 ?>)">
                    <i class="bi bi-trash me-2"></i> Excluir
                </button>
                <div>
                    <a href="<?= url('/fluxo-caixa') ?>" class="btn btn-secondary">
                        <i class="bi bi-x-lg me-2"></i> Cancelar
                    </a>
                    <button type="submit" class="btn btn-primary" id="btnSalvar">
                        <i class="bi bi-check-lg me-2"></i> Salvar Alterações
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<style>
    .autocomplete-dropdown {
        position: absolute;
        top: 100%;
        left: 0;
        right: 0;
        background: white;
        border: 1px solid #dee2e6;
        border-radius: 0 0 8px 8px;
        max-height: 300px;
        overflow-y: auto;
        z-index: 1050;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }

    .autocomplete-item {
        padding: 10px 12px;
        cursor: pointer;
        border-bottom: 1px solid #f0f0f0;
        transition: background 0.15s;
    }

    .autocomplete-item:hover {
        background: #f8f9fa;
    }

    .autocomplete-item:last-child {
        border-bottom: none;
    }

    .autocomplete-no-results {
        padding: 12px;
        text-align: center;
        color: #6c757d;
    }
</style>

<script>
    // Dados das pessoas para autocomplete
    const pessoasData = <?= json_encode($pessoas ?? [], JSON_UNESCAPED_UNICODE) ?>;
    let autocompleteTimeout = null;

    // Inicializar autocomplete de pessoa
    $(document).ready(function () {
        inicializarAutocompletePessoa();
    });

    function inicializarAutocompletePessoa() {
        const $search = $('#pessoa_search');
        const $dropdown = $('#pessoa_dropdown');

        $search.on('input', function () {
            const query = $(this).val().trim().toLowerCase();
            clearTimeout(autocompleteTimeout);

            if (query.length < 2) {
                $dropdown.hide();
                return;
            }

            autocompleteTimeout = setTimeout(() => {
                buscarPessoas(query);
            }, 300);
        });

        $(document).on('click', function (e) {
            if (!$(e.target).closest('#pessoa_search, #pessoa_dropdown').length) {
                $dropdown.hide();
            }
        });

        $search.on('focus', function () {
            if ($(this).val().length >= 2) {
                buscarPessoas($(this).val().trim().toLowerCase());
            }
        });

        $search.on('keydown', function (e) {
            if (e.key === 'Enter') {
                e.preventDefault();
            }
        });
    }

    function buscarPessoas(query) {
        const $dropdown = $('#pessoa_dropdown');

        const results = pessoasData.filter(pessoa => {
            const name = (pessoa.name || '').toLowerCase();
            const tradeName = (pessoa.trade_name || '').toLowerCase();
            const document = (pessoa.document || '').toLowerCase();
            const email = (pessoa.email || '').toLowerCase();
            const phone = (pessoa.phone || '').toLowerCase();
            const mobile = (pessoa.mobile || '').toLowerCase();
            const normalizedQuery = query.replace(/[^\d\w]/g, '').toLowerCase();
            const normalizedDocument = document.replace(/[^\d\w]/g, '').toLowerCase();

            return name.includes(query) || tradeName.includes(query) ||
                document.includes(query) || normalizedDocument.includes(normalizedQuery) ||
                email.includes(query) || phone.includes(query) || mobile.includes(query);
        });

        let html = '';
        if (results.length > 0) {
            results.slice(0, 10).forEach(pessoa => {
                const codigo = String(pessoa.id).padStart(4, '0');
                const documento = pessoa.document || 'Não informado';
                const razaoSocial = pessoa.name || '-';
                const fantasia = pessoa.trade_name || '-';
                const telefone = pessoa.phone || pessoa.mobile || '-';
                const email = pessoa.email || '-';

                html += `
                <div class="autocomplete-item" data-id="${pessoa.id}">
                    <div class="mb-1">
                        <strong>Código: ${codigo}</strong> | <strong>CPF/CNPJ:</strong> ${documento}
                    </div>
                    <div class="mb-1">
                        <strong>Razão Social:</strong> ${razaoSocial} | <strong>Fantasia:</strong> ${fantasia}
                    </div>
                    <div class="text-muted small">
                        <strong>Fone:</strong> ${telefone} | <strong>Email:</strong> ${email}
                    </div>
                </div>
            `;
            });
        } else {
            html = '<div class="autocomplete-no-results">Nenhuma pessoa encontrada</div>';
        }

        $dropdown.html(html).show();

        $dropdown.find('.autocomplete-item').on('click', function () {
            const pessoaId = $(this).data('id');
            const pessoa = pessoasData.find(p => p.id == pessoaId);
            if (pessoa) {
                selecionarPessoa(pessoa);
            }
        });
    }

    function selecionarPessoa(pessoa) {
        const codigo = String(pessoa.id).padStart(4, '0');
        const fantasia = pessoa.trade_name || '-';
        const razaoSocial = pessoa.name || '-';
        const documento = pessoa.document || 'Não informado';
        const telefone = pessoa.phone || pessoa.mobile || '-';
        const email = pessoa.email || '-';
        const nomeExibir = fantasia !== '-' ? fantasia : razaoSocial;

        $('#people_id').val(pessoa.id);
        $('#pessoa_search').val(nomeExibir);

        const infoHtml = `
            <div style="line-height: 1.5;">
                <div class="mb-1"><strong>Código: ${codigo}</strong> | ${documento}</div>
                <div class="mb-1"><strong>Razão Social:</strong> ${razaoSocial} | <strong>Fantasia:</strong> ${fantasia}</div>
                <div class="text-muted small"><strong>Fone:</strong> ${telefone} | <strong>Email:</strong> ${email}</div>
            </div>
        `;

        $('#pessoa_info_text').html(infoHtml);
        $('#pessoa_info').slideDown();
        $('#pessoa_dropdown').hide();
    }

    function limparPessoa() {
        $('#people_id').val('');
        $('#pessoa_search').val('');
        $('#pessoa_info').slideUp();
    }

    // Submit do formulário
    $('#formMovimentacao').on('submit', function (e) {
        e.preventDefault();

        const $btn = $('#btnSalvar');
        const originalText = $btn.html();
        $btn.prop('disabled', true).html('<i class="spinner-border spinner-border-sm me-2"></i> Salvando...');

        $.ajax({
            url: appUrl('/fluxo-caixa/editar'),
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function (response) {
                if (response.success) {
                    Toast.success(response.message);
                    setTimeout(() => {
                        window.location.href = appUrl(response.data?.redirect || '/fluxo-caixa');
                    }, 1500);
                } else {
                    Toast.error(response.message);
                    $btn.prop('disabled', false).html(originalText);
                }
            },
            error: function () {
                Toast.error('Erro ao salvar movimentação');
                $btn.prop('disabled', false).html(originalText);
            }
        });
    });

    async function deletarMovimento(id) {
        const confirmed = await confirmDelete('Tem certeza que deseja excluir esta movimentação?');
        if (confirmed) {
            $.ajax({
                url: appUrl('/fluxo-caixa/excluir'),
                type: 'POST',
                data: { id: id },
                dataType: 'json',
                success: function (response) {
                    if (response.success) {
                        Toast.success(response.message);
                        setTimeout(() => {
                            window.location.href = appUrl('/fluxo-caixa');
                        }, 1500);
                    } else {
                        Toast.error(response.message);
                    }
                }
            });
        }
    }
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'fluxo-caixa';
include ROOT_PATH . '/views/layouts/app.php';
?>