<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-plus-circle me-2"></i> Nova Movimentação</h2>
        <p class="text-muted">Cadastre uma nova entrada ou saída no fluxo de caixa</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/fluxo-caixa') ?>" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left me-2"></i> Voltar
        </a>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <i class="bi bi-cash-stack me-2"></i> Dados da Movimentação
    </div>
    <div class="card-body">
        <form id="formMovimentacao">
            <div class="row">
                <div class="col-md-4 mb-3">
                    <label class="form-label">Data <span class="text-danger">*</span></label>
                    <input type="date" class="form-control" name="date" value="<?= date('Y-m-d') ?>" required>
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Tipo <span class="text-danger">*</span></label>
                    <select class="form-select" name="type" required>
                        <option value="">Selecione...</option>
                        <option value="entrada">Entrada</option>
                        <option value="saida">Saída</option>
                    </select>
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Valor <span class="text-danger">*</span></label>
                    <input type="number" class="form-control" name="amount" step="0.01" min="0.01" placeholder="0,00"
                        required>
                </div>
            </div>

            <div class="row">
                <div class="col-md-8 mb-3">
                    <label class="form-label">Descrição <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" name="description" placeholder="Descrição da movimentação"
                        required>
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Pessoa (Cliente/Fornecedor)</label>
                    <div class="position-relative">
                        <input type="text" class="form-control" id="pessoa_search" placeholder="Digite para buscar..."
                            autocomplete="off">
                        <div id="pessoa_dropdown" class="autocomplete-dropdown" style="display: none;"></div>
                    </div>
                    <input type="hidden" name="people_id" id="people_id" value="">
                    <div id="pessoa_info" class="mt-2 p-2 bg-light rounded small" style="display: none;">
                        <span id="pessoa_info_text"></span>
                        <button type="button" class="btn btn-sm btn-link text-danger p-0 ms-2" onclick="limparPessoa()">
                            <i class="bi bi-x-circle"></i> Limpar
                        </button>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-4 mb-3">
                    <label class="form-label">Responsável</label>
                    <select class="form-select" name="responsible_id" id="responsible_id">
                        <option value="">Selecione...</option>
                        <?php foreach ($usuarios ?? [] as $usuario): ?>
                            <option value="<?= $usuario['id'] ?>"><?= htmlspecialchars($usuario['name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Plano de Contas</label>
                    <select class="form-select" name="plano_contas_id">
                        <option value="">Selecione...</option>
                        <?php foreach ($planosContas ?? [] as $plano): ?>
                            <option value="<?= $plano['id'] ?>">
                                <?= htmlspecialchars($plano['codigo'] . ' - ' . $plano['nome']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Centro de Custos</label>
                    <select class="form-select" name="centro_custo_id">
                        <option value="">Selecione...</option>
                        <?php foreach ($centrosCustos ?? [] as $centro): ?>
                            <option value="<?= $centro['id'] ?>">
                                <?= htmlspecialchars($centro['codigo'] . ' - ' . $centro['nome']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>

            <input type="hidden" name="reference_type" value="fluxo_caixa">

            <hr>

            <div class="text-end">
                <a href="<?= url('/fluxo-caixa') ?>" class="btn btn-secondary">
                    <i class="bi bi-x-lg me-2"></i> Cancelar
                </a>
                <button type="submit" class="btn btn-primary" id="btnSalvar">
                    <i class="bi bi-check-lg me-2"></i> Salvar Movimentação
                </button>
            </div>
        </form>
    </div>
</div>

<style>
    .autocomplete-dropdown {
        position: absolute;
        top: 100%;
        left: 0;
        right: 0;
        background: white;
        border: 1px solid #dee2e6;
        border-radius: 0 0 8px 8px;
        max-height: 300px;
        overflow-y: auto;
        z-index: 1050;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }

    .autocomplete-item {
        padding: 10px 12px;
        cursor: pointer;
        border-bottom: 1px solid #f0f0f0;
        transition: background 0.15s;
    }

    .autocomplete-item:hover {
        background: #f8f9fa;
    }

    .autocomplete-item:last-child {
        border-bottom: none;
    }

    .autocomplete-no-results {
        padding: 12px;
        text-align: center;
        color: #6c757d;
    }
</style>

<script>
    // Dados das pessoas para autocomplete
    const pessoasData = <?= json_encode($pessoas ?? [], JSON_UNESCAPED_UNICODE) ?>;
    let autocompleteTimeout = null;

    // Inicializar autocomplete de pessoa
    $(document).ready(function () {
        inicializarAutocompletePessoa();
    });

    function inicializarAutocompletePessoa() {
        const $search = $('#pessoa_search');
        const $dropdown = $('#pessoa_dropdown');

        $search.on('input', function () {
            const query = $(this).val().trim().toLowerCase();
            clearTimeout(autocompleteTimeout);

            if (query.length < 2) {
                $dropdown.hide();
                return;
            }

            autocompleteTimeout = setTimeout(() => {
                buscarPessoas(query);
            }, 300);
        });

        $(document).on('click', function (e) {
            if (!$(e.target).closest('#pessoa_search, #pessoa_dropdown').length) {
                $dropdown.hide();
            }
        });

        $search.on('focus', function () {
            if ($(this).val().length >= 2) {
                buscarPessoas($(this).val().trim().toLowerCase());
            }
        });

        $search.on('keydown', function (e) {
            if (e.key === 'Enter') {
                e.preventDefault();
            }
        });
    }

    function buscarPessoas(query) {
        const $dropdown = $('#pessoa_dropdown');

        const results = pessoasData.filter(pessoa => {
            const name = (pessoa.name || '').toLowerCase();
            const tradeName = (pessoa.trade_name || '').toLowerCase();
            const document = (pessoa.document || '').toLowerCase();
            const email = (pessoa.email || '').toLowerCase();
            const phone = (pessoa.phone || '').toLowerCase();
            const mobile = (pessoa.mobile || '').toLowerCase();
            const normalizedQuery = query.replace(/[^\d\w]/g, '').toLowerCase();
            const normalizedDocument = document.replace(/[^\d\w]/g, '').toLowerCase();

            return name.includes(query) || tradeName.includes(query) ||
                document.includes(query) || normalizedDocument.includes(normalizedQuery) ||
                email.includes(query) || phone.includes(query) || mobile.includes(query);
        });

        let html = '';
        if (results.length > 0) {
            results.slice(0, 10).forEach(pessoa => {
                const codigo = String(pessoa.id).padStart(4, '0');
                const documento = pessoa.document || 'Não informado';
                const razaoSocial = pessoa.name || '-';
                const fantasia = pessoa.trade_name || '-';
                const telefone = pessoa.phone || pessoa.mobile || '-';
                const email = pessoa.email || '-';

                html += `
                <div class="autocomplete-item" data-id="${pessoa.id}">
                    <div class="mb-1">
                        <strong>Código: ${codigo}</strong> | <strong>CPF/CNPJ:</strong> ${documento}
                    </div>
                    <div class="mb-1">
                        <strong>Razão Social:</strong> ${razaoSocial} | <strong>Fantasia:</strong> ${fantasia}
                    </div>
                    <div class="text-muted small">
                        <strong>Fone:</strong> ${telefone} | <strong>Email:</strong> ${email}
                    </div>
                </div>
            `;
            });
        } else {
            html = '<div class="autocomplete-no-results">Nenhuma pessoa encontrada</div>';
        }

        $dropdown.html(html).show();

        $dropdown.find('.autocomplete-item').on('click', function () {
            const pessoaId = $(this).data('id');
            const pessoa = pessoasData.find(p => p.id == pessoaId);
            if (pessoa) {
                selecionarPessoa(pessoa);
            }
        });
    }

    function selecionarPessoa(pessoa) {
        const codigo = String(pessoa.id).padStart(4, '0');
        const fantasia = pessoa.trade_name || '-';
        const razaoSocial = pessoa.name || '-';
        const documento = pessoa.document || 'Não informado';
        const telefone = pessoa.phone || pessoa.mobile || '-';
        const email = pessoa.email || '-';
        const nomeExibir = fantasia !== '-' ? fantasia : razaoSocial;

        $('#people_id').val(pessoa.id);
        $('#pessoa_search').val(nomeExibir);

        const infoHtml = `
            <div style="line-height: 1.5;">
                <div class="mb-1"><strong>Código: ${codigo}</strong> | ${documento}</div>
                <div class="mb-1"><strong>Razão Social:</strong> ${razaoSocial} | <strong>Fantasia:</strong> ${fantasia}</div>
                <div class="text-muted small"><strong>Fone:</strong> ${telefone} | <strong>Email:</strong> ${email}</div>
            </div>
        `;

        $('#pessoa_info_text').html(infoHtml);
        $('#pessoa_info').slideDown();
        $('#pessoa_dropdown').hide();
    }

    function limparPessoa() {
        $('#people_id').val('');
        $('#pessoa_search').val('');
        $('#pessoa_info').slideUp();
    }

    // Submit do formulário
    $('#formMovimentacao').on('submit', function (e) {
        e.preventDefault();

        const $btn = $('#btnSalvar');
        const originalText = $btn.html();
        $btn.prop('disabled', true).html('<i class="spinner-border spinner-border-sm me-2"></i> Salvando...');

        $.ajax({
            url: appUrl('/fluxo-caixa/criar'),
            type: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function (response) {
                if (response.success) {
                    Toast.success(response.message);
                    setTimeout(() => {
                        window.location.href = appUrl(response.data?.redirect || '/fluxo-caixa');
                    }, 1500);
                } else {
                    Toast.error(response.message);
                    $btn.prop('disabled', false).html(originalText);
                }
            },
            error: function () {
                Toast.error('Erro ao salvar movimentação');
                $btn.prop('disabled', false).html(originalText);
            }
        });
    });
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'fluxo-caixa';
include ROOT_PATH . '/views/layouts/app.php';
?>