<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-check2-square me-2"></i> Conciliação Bancária</h2>
        <p class="text-muted">Importe e compare extratos bancários com as movimentações do sistema</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/fluxo-caixa') ?>" class="btn btn-secondary">
            <i class="bi bi-arrow-left me-2"></i> Voltar
        </a>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0"><i class="bi bi-upload me-2"></i> Importar Arquivo OFX</h5>
    </div>
    <div class="card-body">
        <form id="formConciliacao" enctype="multipart/form-data">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="conta_bancaria_id" class="form-label">Conta Bancária <span
                            class="text-danger">*</span></label>
                    <select class="form-select" id="conta_bancaria_id" name="conta_bancaria_id" required>
                        <option value="">Selecione uma conta...</option>
                        <?php foreach ($contasBancarias ?? [] as $conta): ?>
                            <option value="<?= $conta['id'] ?>">
                                <?= htmlspecialchars($conta['bank_name']) ?> -
                                Ag: <?= htmlspecialchars($conta['agency']) ?> /
                                Conta: <?= htmlspecialchars($conta['account_number']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="arquivo_ofx" class="form-label">Arquivo OFX <span class="text-danger">*</span></label>
                    <input type="file" class="form-control" id="arquivo_ofx" name="arquivo_ofx" accept=".ofx" required>
                    <small class="text-muted">Selecione o arquivo OFX exportado do seu banco</small>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-upload me-2"></i> Importar e Comparar
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<div id="resultadoConciliacao" class="card mt-4" style="display: none;">
    <div class="card-header">
        <h5 class="mb-0"><i class="bi bi-list-check me-2"></i> Resultado da Conciliação</h5>
    </div>
    <div class="card-body">
        <div id="conteudoResultado"></div>
    </div>
</div>

<script>
    document.getElementById('formConciliacao').addEventListener('submit', async function (e) {
        e.preventDefault();

        const formData = new FormData(this);
        const btn = this.querySelector('button[type="submit"]');
        const btnOriginalText = btn.innerHTML;

        btn.disabled = true;
        btn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>Processando...';

        try {
            const response = await fetch(appUrl('/fluxo-caixa/conciliacao/processar'), {
                method: 'POST',
                body: formData
            });

            const result = await response.json();

            if (result.success) {
                document.getElementById('resultadoConciliacao').style.display = 'block';
                const conteudoDiv = document.getElementById('conteudoResultado');
                conteudoDiv.innerHTML = result.html || '<p>Conciliação processada com sucesso!</p>';

                // Executar scripts dentro do HTML inserido
                const scripts = conteudoDiv.querySelectorAll('script');
                scripts.forEach(function(oldScript) {
                    const newScript = document.createElement('script');
                    Array.from(oldScript.attributes).forEach(function(attr) {
                        newScript.setAttribute(attr.name, attr.value);
                    });
                    newScript.appendChild(document.createTextNode(oldScript.innerHTML));
                    oldScript.parentNode.replaceChild(newScript, oldScript);
                });

                Toast.success(result.message || 'Arquivo processado com sucesso');
            } else {
                Toast.error(result.message || 'Erro ao processar arquivo');
            }
        } catch (error) {
            console.error('Erro:', error);
            Toast.error('Erro ao processar arquivo OFX');
        } finally {
            btn.disabled = false;
            btn.innerHTML = btnOriginalText;
        }
    });
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'fluxo-caixa';
include ROOT_PATH . '/views/layouts/app.php';
?>