<?php
ob_start();

$statusDisponiveis = $statusDisponiveis ?? [];
$vendas = $vendas ?? [];
$clientes = $clientes ?? [];
$filtroStatus = $filtroStatus ?? '';
$filtroClienteId = $filtroClienteId ?? '';
$dataInicio = $dataInicio ?? '';
$dataFim = $dataFim ?? '';

function statusBadgeExpedicao(string $status): string
{
    $badges = [
        'pendente' => 'bg-warning text-dark',
        'realizado' => 'bg-info text-dark',
        'faturamento' => 'bg-primary',
        'expedicao' => 'bg-secondary',
        'finalizado' => 'bg-success',
    ];

    $classe = $badges[$status] ?? 'bg-light text-dark';
    return '<span class="badge ' . $classe . '">' . strtoupper($status) . '</span>';
}
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-truck-front me-2"></i> Expedição</h2>
        <p class="text-muted">Conferência, emissão de NF-e e despacho das vendas</p>
    </div>
</div>

<div class="card mb-4">
    <div class="card-body">
        <form id="filtroExpedicao" class="row g-3" method="GET" action="<?= url('/expedicao') ?>">
            <div class="col-md-2">
                <label class="form-label">Status</label>
                <select name="status" class="form-select">
                    <option value="">Todos</option>
                    <?php foreach ($statusDisponiveis as $status): ?>
                    <option value="<?= htmlspecialchars($status['codigo']) ?>"
                        <?= $filtroStatus === $status['codigo'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($status['nome'] ?? strtoupper($status['codigo'])) ?>
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">Cliente</label>
                <select name="cliente_id" class="form-select">
                    <option value="">Todos</option>
                    <?php foreach ($clientes as $cliente): ?>
                    <option value="<?= (int) $cliente['id'] ?>"
                        <?= (string) $filtroClienteId === (string) $cliente['id'] ? 'selected' : '' ?>>
                        #<?= (int) $cliente['id'] ?> - <?= htmlspecialchars($cliente['name']) ?>
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">De</label>
                <input type="date" name="data_inicio" class="form-control" value="<?= htmlspecialchars($dataInicio) ?>">
            </div>
            <div class="col-md-2">
                <label class="form-label">Até</label>
                <input type="date" name="data_fim" class="form-control" value="<?= htmlspecialchars($dataFim) ?>">
            </div>
            <div class="col-md-3 d-flex align-items-end justify-content-end gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-funnel me-1"></i> Filtrar
                </button>
                <button type="button" class="btn btn-outline-secondary" onclick="iniciarConferenciaManual()">
                    <i class="bi bi-clipboard-check me-1"></i> Conferência
                </button>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <?php if (!empty($vendas)): ?>
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead class="table-light">
                    <tr>
                        <th>Número</th>
                        <th>Cliente</th>
                        <th>Status</th>
                        <th class="text-end">Total</th>
                        <th>Data</th>
                        <th>Vendedor</th>
                        <th>NF-e</th>
                        <th>Conferência</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($vendas as $venda): ?>
                    <?php
                        $clienteId = $venda['customer_id'] ?? null;
                        $clienteNome = $venda['customer_name'] ?? 'Consumidor Final';
                        $badgeStatus = statusBadgeExpedicao($venda['status']);
                        $conferido = !empty($venda['conferido']);
                        $nfEmitida = !empty($venda['chave_nfe']);
                    ?>
                    <tr data-venda-id="<?= (int) $venda['id'] ?>">
                        <td>
                            <strong><?= htmlspecialchars($venda['sale_number']) ?></strong>
                        </td>
                        <td>
                            <?php if ($clienteId): ?>
                            <span class="text-muted">#<?= (int) $clienteId ?></span> -
                            <?= htmlspecialchars($clienteNome) ?>
                            <?php else: ?>
                            <span class="badge bg-secondary">Consumidor Final</span>
                            <?php endif; ?>
                        </td>
                        <td><?= $badgeStatus ?></td>
                        <td class="text-end"><strong>R$
                                <?= number_format((float) ($venda['total'] ?? 0), 2, ',', '.') ?></strong></td>
                        <td><?= !empty($venda['sale_date']) ? date('d/m/Y', strtotime($venda['sale_date'])) : '-' ?>
                        </td>
                        <td><?= htmlspecialchars($venda['vendor_name'] ?? '-') ?></td>
                        <td>
                            <?php if ($nfEmitida): ?>
                            <span class="badge bg-success"><i class="bi bi-check-circle me-1"></i>Emitida</span>
                            <?php else: ?>
                            <span class="badge bg-outline-secondary text-dark"><i
                                    class="bi bi-clock me-1"></i>Pendente</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($conferido): ?>
                            <span class="badge bg-success"><i class="bi bi-clipboard-check me-1"></i>Conferido</span>
                            <?php else: ?>
                            <span class="badge bg-warning text-dark"><i
                                    class="bi bi-exclamation-triangle me-1"></i>Pendente</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <div class="btn-group btn-group-sm" role="group">
                                <button type="button" class="btn btn-outline-primary" title="Detalhes"
                                    onclick="visualizarVenda(<?= (int) $venda['id'] ?>)">
                                    <i class="bi bi-eye"></i>
                                </button>
                                <button type="button" class="btn btn-outline-success" title="Conferência"
                                    onclick="conferirVenda(<?= (int) $venda['id'] ?>, '<?= htmlspecialchars($venda['sale_number']) ?>')"
                                    <?= $conferido ? 'disabled' : '' ?>>
                                    <i class="bi bi-clipboard-check"></i>
                                </button>
                                <button type="button" class="btn btn-outline-warning" title="Emitir NF-e"
                                    onclick="emitirNFe(<?= (int) $venda['id'] ?>, '<?= htmlspecialchars($venda['sale_number']) ?>', '<?= htmlspecialchars($clienteNome) ?>')">
                                    <i class="bi bi-file-earmark-text"></i>
                                </button>
                                <button type="button" class="btn btn-outline-secondary" title="Despachar"
                                    onclick="despacharVenda(<?= (int) $venda['id'] ?>, '<?= htmlspecialchars($venda['sale_number']) ?>')">
                                    <i class="bi bi-truck"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php else: ?>
        <div class="text-center py-5">
            <i class="bi bi-inboxes" style="font-size: 4rem; color: var(--text-secondary);"></i>
            <p class="text-muted mt-3">Nenhuma venda aguardando expedição com os filtros selecionados.</p>
        </div>
        <?php endif; ?>
    </div>
</div>

<?php
$content = ob_get_clean();
$activeMenu = 'expedicao';
include ROOT_PATH . '/views/layouts/app.php';
?>

<script>
function iniciarConferenciaManual() {
    Swal.fire({
        title: 'Conferir venda/DAV',
        input: 'text',
        inputLabel: 'Informe o número da venda (ex.: VND-000123 ou DAV-000123)',
        inputPlaceholder: 'Número da venda',
        showCancelButton: true,
        confirmButtonText: 'Conferir',
        cancelButtonText: 'Cancelar',
        inputValidator: (value) => {
            if (!value || !value.trim()) {
                return 'Informe o número da venda';
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            const saleNumber = result.value.trim();
            $.ajax({
                url: appUrl('/expedicao/visualizar'),
                method: 'GET',
                data: {
                    sale_number: saleNumber
                },
                success: function(response) {
                    if (response.success && response.data && response.data.venda) {
                        const venda = response.data.venda;
                        conferirVenda(venda.id, venda.sale_number || saleNumber);
                    } else {
                        Swal.fire('Não encontrado', response.message || 'Venda não localizada.',
                            'warning');
                    }
                },
                error: function() {
                    Swal.fire('Erro', 'Falha ao localizar a venda.', 'error');
                }
            });
        }
    });
}

function visualizarVenda(vendaId) {
    $.ajax({
        url: appUrl('/expedicao/visualizar'),
        method: 'GET',
        data: {
            id: vendaId
        },
        success: function(response) {
            if (response.success) {
                const venda = response.data.venda || {};
                const clienteId = venda.customer_id ? `#${venda.customer_id}` : 'Consumidor Final';
                const clienteNome = venda.customer_name || 'Consumidor Final';
                const total = parseFloat(venda.total || 0).toLocaleString('pt-BR', {
                    style: 'currency',
                    currency: 'BRL'
                });
                const conferido = venda.conferido ? '<span class="badge bg-success">Conferido</span>' :
                    '<span class="badge bg-warning text-dark">Pendente</span>';

                Swal.fire({
                    title: `Venda ${venda.sale_number || ''}`,
                    html: `
                        <div class="text-start">
                            <p><strong>Cliente:</strong> ${clienteId} - ${clienteNome}</p>
                            <p><strong>Status:</strong> ${venda.status || '-'}</p>
                            <p><strong>Total:</strong> ${total}</p>
                            <p><strong>Conferência:</strong> ${conferido}</p>
                            <p><strong>Transportadora:</strong> ${venda.dispatch_transportadora || '-'}</p>
                            <p><strong>Código de rastreio:</strong> ${venda.dispatch_rastreio || '-'}</p>
                            <p><strong>Volumes:</strong> ${venda.dispatch_volumes || '-'}</p>
                        </div>
                    `,
                    icon: 'info'
                });
            } else {
                Swal.fire('Erro', response.message || 'Não foi possível carregar a venda.', 'error');
            }
        },
        error: function() {
            Swal.fire('Erro', 'Não foi possível carregar a venda.', 'error');
        }
    });
}

function conferirVenda(vendaId, numeroVenda) {
    Swal.fire({
        title: 'Conferência de Expedição',
        text: `Confirmar conferência da venda ${numeroVenda}?`,
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Sim, conferir',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: appUrl('/expedicao/conferir'),
                method: 'POST',
                data: {
                    id: vendaId
                },
                success: function(response) {
                    if (response.success) {
                        Swal.fire('Sucesso', response.message, 'success').then(() => location
                            .reload());
                    } else {
                        Swal.fire('Erro', response.message || 'Falha ao registrar conferência.',
                            'error');
                    }
                },
                error: function() {
                    Swal.fire('Erro', 'Falha ao registrar conferência.', 'error');
                }
            });
        }
    });
}

function emitirNFe(vendaId, numeroVenda, clienteNome) {
    Swal.fire({
        title: 'Emitir NF-e',
        text: `Emitir NF-e para a venda ${numeroVenda} (${clienteNome})?`,
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Sim, emitir',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: appUrl('/expedicao/emitir-nfe'),
                method: 'POST',
                data: {
                    venda_id: vendaId
                },
                success: function(response) {
                    if (response.success) {
                        Swal.fire('Sucesso', response.message || 'NF-e enviada para emissão.',
                            'success').then(() => location.reload());
                    } else {
                        Swal.fire('Erro', response.message || 'Falha ao emitir NF-e.', 'error');
                    }
                },
                error: function(xhr) {
                    const response = xhr.responseJSON || {};
                    Swal.fire('Erro', response.message || 'Falha ao emitir NF-e.', 'error');
                }
            });
        }
    });
}

function despacharVenda(vendaId, numeroVenda) {
    Swal.fire({
        title: 'Despacho',
        html: `
            <div class="mb-3 text-start">
                <label class="form-label">Transportadora</label>
                <input type="text" id="swal-transportadora" class="form-control" placeholder="Transportadora">
            </div>
            <div class="row">
                <div class="col-md-6 mb-3 text-start">
                    <label class="form-label">Volumes</label>
                    <input type="number" id="swal-volumes" class="form-control" min="0" placeholder="0">
                </div>
                <div class="col-md-6 mb-3 text-start">
                    <label class="form-label">Rastreamento</label>
                    <input type="text" id="swal-rastreio" class="form-control" placeholder="Código de rastreio">
                </div>
            </div>
            <div class="mb-3 text-start">
                <label class="form-label">Responsável</label>
                <input type="text" id="swal-responsavel" class="form-control" placeholder="Responsável pelo despacho">
            </div>
            <div class="mb-3 text-start">
                <label class="form-label">Data/Hora</label>
                <input type="datetime-local" id="swal-data" class="form-control">
            </div>
            <div class="mb-3 text-start">
                <label class="form-label">Observações</label>
                <textarea id="swal-observacoes" class="form-control" rows="3" placeholder="Observações adicionais"></textarea>
            </div>
        `,
        focusConfirm: false,
        showCancelButton: true,
        confirmButtonText: 'Registrar despacho',
        cancelButtonText: 'Cancelar',
        preConfirm: () => {
            return {
                transportadora: document.getElementById('swal-transportadora').value.trim(),
                volumes: document.getElementById('swal-volumes').value,
                rastreio: document.getElementById('swal-rastreio').value.trim(),
                responsavel: document.getElementById('swal-responsavel').value.trim(),
                data: document.getElementById('swal-data').value,
                observacoes: document.getElementById('swal-observacoes').value.trim()
            };
        }
    }).then((result) => {
        if (result.isConfirmed && result.value) {
            const dados = result.value;
            $.ajax({
                url: appUrl('/expedicao/despachar'),
                method: 'POST',
                data: {
                    id: vendaId,
                    transportadora: dados.transportadora,
                    volumes: dados.volumes,
                    rastreio: dados.rastreio,
                    responsavel: dados.responsavel,
                    data_despacho: dados.data,
                    observacoes: dados.observacoes
                },
                success: function(response) {
                    if (response.success) {
                        Swal.fire('Sucesso', response.message || 'Despacho registrado com sucesso.',
                                'success')
                            .then(() => location.reload());
                    } else {
                        Swal.fire('Erro', response.message || 'Falha ao registrar despacho.',
                            'error');
                    }
                },
                error: function() {
                    Swal.fire('Erro', 'Falha ao registrar despacho.', 'error');
                }
            });
        }
    });
}
</script>