<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-lg-8">
        <h2 class="mb-1"><i class="bi bi-clipboard-data me-2"></i> Inventários realizados</h2>
        <p class="text-muted mb-0">Visualize as contagens finalizadas, pendentes ou canceladas e analise os resultados
            com rapidez.</p>
    </div>
    <div class="col-lg-4 text-lg-end mt-3 mt-lg-0">
        <div class="d-flex flex-wrap justify-content-lg-end gap-2">
            <a href="javascript:void(0)" class="btn btn-outline-primary" onclick="abrirExportacaoInventario()">
                <i class="bi bi-file-earmark-spreadsheet me-1"></i> Exportar modelo
            </a>
            <button type="button" class="btn btn-info" data-bs-toggle="modal"
                data-bs-target="#modalImportarInventario">
                <i class="bi bi-upload me-1"></i> Importar planilha
            </button>
            <a href="<?= url('/estoque/inventario/criar') ?>" class="btn btn-success">
                <i class="bi bi-plus-circle me-1"></i> Nova contagem
            </a>
        </div>
    </div>
</div>

<?php if (!$inventarioTabelasAtivas || !$inventarioItensAtivos): ?>
<?php
    $faltantes = [];
    if (!$inventarioTabelasAtivas) {
        $faltantes[] = '`inventarios`';
    }
    if ($inventarioTabelasAtivas && !$inventarioItensAtivos) {
        $faltantes[] = '`inventario_itens`';
    }
    $mensagemTabelas = empty($faltantes)
        ? 'as tabelas necessárias'
        : implode(' e ', $faltantes);
    ?>
<div class="alert alert-warning border-warning">
    <div class="d-flex align-items-start">
        <i class="bi bi-exclamation-triangle me-2 fs-4"></i>
        <div>
            <strong>Configuração necessária:</strong> execute a migração
            <code>database/migration_create_inventarios.sql</code> para criar <?= htmlspecialchars($mensagemTabelas) ?>.
            Após a criação, os inventários realizados aparecerão automaticamente nesta tela.
        </div>
    </div>
</div>
<?php else: ?>
<?php
    $totalInventarios = (int) ($estatisticasInventario['total'] ?? 0);
    $finalizados = (int) ($estatisticasInventario['finalizado'] ?? 0);
    $emAndamento = (int) ($estatisticasInventario['em_andamento'] ?? 0);
    $cancelados = (int) ($estatisticasInventario['cancelado'] ?? 0);
    ?>

<!-- <div class="row g-3 mb-4">
        <div class="col-md-3">
            <div class="card shadow-sm border-primary h-100">
                <div class="card-body">
                    <span class="text-muted text-uppercase small">Total</span>
                    <h3 class="fw-bold mb-0"><?= number_format($totalInventarios, 0, ',', '.') ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card shadow-sm border-success h-100">
                <div class="card-body">
                    <span class="text-muted text-uppercase small">Finalizados</span>
                    <h3 class="fw-bold text-success mb-0"><?= number_format($finalizados, 0, ',', '.') ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card shadow-sm border-warning h-100">
                <div class="card-body">
                    <span class="text-muted text-uppercase small">Em andamento</span>
                    <h3 class="fw-bold text-warning mb-0"><?= number_format($emAndamento, 0, ',', '.') ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card shadow-sm border-danger h-100">
                <div class="card-body">
                    <span class="text-muted text-uppercase small">Cancelados</span>
                    <h3 class="fw-bold text-danger mb-0"><?= number_format($cancelados, 0, ',', '.') ?></h3>
                </div>
            </div>
        </div>
    </div> -->

<div class="card mb-4">
    <div class="card-header bg-light">
        <i class="bi bi-funnel me-2"></i>Filtros
    </div>
    <div class="card-body">
        <form class="row g-3 align-items-end" method="GET" action="<?= url('/estoque/inventario') ?>">
            <div class="col-md-3">
                <label for="filtro-busca" class="form-label">Buscar</label>
                <input type="text" class="form-control" id="filtro-busca" name="busca"
                    value="<?= htmlspecialchars($filtrosInventario['busca'] ?? '') ?>"
                    placeholder="Código ou observação">
            </div>

            <div class="col-md-2">
                <label for="filtro-status" class="form-label">Status</label>
                <select class="form-select" id="filtro-status" name="status">
                    <option value="">Todos</option>
                    <option value="finalizado"
                        <?= ($filtrosInventario['status'] ?? '') === 'finalizado' ? 'selected' : '' ?>>Finalizado
                    </option>
                    <option value="em_andamento"
                        <?= ($filtrosInventario['status'] ?? '') === 'em_andamento' ? 'selected' : '' ?>>Em andamento
                    </option>
                    <option value="cancelado"
                        <?= ($filtrosInventario['status'] ?? '') === 'cancelado' ? 'selected' : '' ?>>Cancelado</option>
                </select>
            </div>

            <div class="col-md-2">
                <label for="filtro-local" class="form-label">Local</label>
                <select class="form-select" id="filtro-local" name="inventario_local">
                    <option value="">Todos os locais</option>
                    <option value="sem_local"
                        <?= ($filtrosInventario['local'] ?? '') === 'sem_local' ? 'selected' : '' ?>>Sem local associado
                    </option>
                    <?php foreach ($locais ?? [] as $local): ?>
                    <option value="<?= $local['id'] ?>"
                        <?= ($filtrosInventario['local'] ?? '') == $local['id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($local['name']) ?>
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <!-- <div class="col-md-2">
                <label for="filtro-responsavel" class="form-label">Responsável</label>
                <select class="form-select" id="filtro-responsavel" name="responsavel">
                    <option value="">Todos</option>
                    <?php foreach ($responsaveisInventario ?? [] as $responsavel): ?>
                    <option value="<?= $responsavel['created_by'] ?>"
                        <?= ($filtrosInventario['responsavel'] ?? '') == $responsavel['created_by'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($responsavel['nome']) ?>
                    </option>
                    <?php endforeach; ?>
                </select>
            </div> -->

            <div class="col-md-2">
                <label for="filtro-data-inicio" class="form-label">De</label>
                <input type="date" class="form-control" id="filtro-data-inicio" name="data_inicio"
                    value="<?= htmlspecialchars($filtrosInventario['data_inicio'] ?? '') ?>">
            </div>

            <div class="col-md-2">
                <label for="filtro-data-fim" class="form-label">Até</label>
                <input type="date" class="form-control" id="filtro-data-fim" name="data_fim"
                    value="<?= htmlspecialchars($filtrosInventario['data_fim'] ?? '') ?>">
            </div>

            <div class="col-md-3 col-lg-1">
                <button type="submit" class="btn btn-primary w-100">
                    <i class="bi bi-search me-2"></i>
                </button>
            </div>
            <!-- <div class="col-md-3 col-lg-2">
                <a href="<?= url('/estoque/inventario') ?>" class="btn btn-outline-secondary w-100">
                    <i class="bi bi-x-circle me-2"></i>Limpar
                </a>
            </div> -->
        </form>
    </div>
</div>

<div class="card shadow-sm">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span><i class="bi bi-journal-text me-2"></i> Inventários cadastrados</span>
        <span class="text-muted small"><?= count($inventarios) ?> registro(s)</span>
    </div>
    <div class="card-body p-0">
        <?php if (empty($inventarios)): ?>
        <div class="text-center text-muted py-5">
            <i class="bi bi-inboxes" style="font-size: 3rem;"></i>
            <p class="mt-2 mb-1">Nenhum inventário encontrado com os filtros atuais.</p>
            <p class="small mb-0">Use o botão "Nova contagem" para registrar um inventário.</p>
        </div>
        <?php else: ?>
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th width="12%">Código</th>
                        <th width="18%">Execução / Referência</th>
                        <th width="18%">Local</th>
                        <th width="18%">Responsável</th>
                        <th width="10%" class="text-center">Itens (ajustados / total)</th>
                        <th width="10%" class="text-end">Diferença</th>
                        <th width="8%" class="text-center">Status</th>
                        <th width="16%">Observações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($inventarios as $inventario): ?>
                    <?php
                                $inventarioId = (int) ($inventario['id'] ?? 0);
                                $codigo = 'INV-' . str_pad((string) $inventarioId, 5, '0', STR_PAD_LEFT);
                                $dataCriacao = !empty($inventario['created_at']) ? date('d/m/Y H:i', strtotime($inventario['created_at'])) : '-';
                                $dataReferencia = !empty($inventario['date']) ? date('d/m/Y', strtotime($inventario['date'])) : '-';
                                $localNome = $inventario['local_name'] ?? 'Todos os locais';
                                $usuarioNome = $inventario['usuario_nome'] ?? '—';
                                $totalItens = (int) ($inventario['total_itens'] ?? 0);
                                $itensAjustados = (int) ($inventario['itens_ajustados'] ?? 0);
                                $diferencaTotal = number_format((float) ($inventario['diferenca_total'] ?? 0), 3, ',', '.');
                                $notes = trim((string) ($inventario['notes'] ?? ''));
                                $resumoItens = $totalItens > 0 ? sprintf('%d / %d', $itensAjustados, $totalItens) : '—';
                                $status = strtolower((string) ($inventario['status'] ?? ''));

                                switch ($status) {
                                    case 'finalizado':
                                        $statusClasse = 'bg-success';
                                        $statusRotulo = 'Finalizado';
                                        break;
                                    case 'em_andamento':
                                        $statusClasse = 'bg-warning text-dark';
                                        $statusRotulo = 'Em andamento';
                                        break;
                                    case 'cancelado':
                                        $statusClasse = 'bg-danger';
                                        $statusRotulo = 'Cancelado';
                                        break;
                                    default:
                                        $statusClasse = 'bg-secondary';
                                        $statusRotulo = strtoupper($status);
                                        break;
                                }

                                $notaResumida = '';
                                if ($notes !== '') {
                                    $notaResumida = function_exists('mb_strimwidth')
                                        ? mb_strimwidth($notes, 0, 80, '…', 'UTF-8')
                                        : (strlen($notes) > 80 ? substr($notes, 0, 80) . '…' : $notes);
                                }
                                ?>
                    <tr class="inventario-row" data-id="<?= $inventarioId ?>" style="cursor: pointer;">
                        <td><strong><?= htmlspecialchars($codigo) ?></strong></td>
                        <td>
                            <span class="d-block fw-semibold"><?= htmlspecialchars($dataCriacao) ?></span>
                            <small class="text-muted">Referência: <?= htmlspecialchars($dataReferencia) ?></small>
                        </td>
                        <td><?= htmlspecialchars($localNome) ?></td>
                        <td><?= htmlspecialchars($usuarioNome) ?></td>
                        <td class="text-center"><?= htmlspecialchars($resumoItens) ?></td>
                        <td class="text-end"><?= $diferencaTotal ?></td>
                        <td class="text-center"><span
                                class="badge <?= $statusClasse ?>"><?= htmlspecialchars($statusRotulo ?: '—') ?></span>
                        </td>
                        <td>
                            <?php if ($notes !== ''): ?>
                            <div class="text-muted small">
                                <i class="bi bi-sticky me-1"></i><?= htmlspecialchars($notaResumida) ?>
                            </div>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php endif; ?>
    </div>
</div>
<?php endif; ?>

<!-- Modal: Importar Inventário -->
<div class="modal fade" id="modalImportarInventario" tabindex="-1" aria-labelledby="modalImportarInventarioLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="modalImportarInventarioLabel">
                    <i class="bi bi-upload me-2"></i>Importar contagem via planilha
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                    aria-label="Fechar"></button>
            </div>
            <form id="form-importar-inventario" action="<?= url('/estoque/inventario/importar') ?>" method="POST"
                enctype="multipart/form-data">
                <div class="modal-body">
                    <div class="alert alert-info d-flex align-items-start mb-4">
                        <i class="bi bi-info-circle me-2 mt-1"></i>
                        <div>
                            <strong>Instruções:</strong>
                            <ul class="mb-0 small">
                                <li>Utilize o modelo padrão exportado pelo sistema</li>
                                <li>Preencha a coluna <strong>QUANTIDADE_FISICA</strong> com as quantidades contadas</li>
                                <?php if (!empty($mostrarCampoLote)): ?>
                                <li>Quando aplicável, informe <strong>LOTE</strong>, <strong>FABRICACAO</strong> e <strong>VALIDADE</strong></li>
                                <?php endif; ?>
                                <li>Opcionalmente, informe <strong>NUMERO_SERIE</strong> quando necessário</li>
                            </ul>
                        </div>
                    </div>

                    <div class="row g-3">
                        <div class="col-12">
                            <label for="arquivo-inventario" class="form-label">
                                Planilha de inventário (.xlsx, .xls, .csv) <span class="text-danger">*</span>
                            </label>
                            <input type="file" class="form-control" id="arquivo-inventario" name="arquivo_inventario"
                                accept=".xlsx,.xls,.csv" required>
                            <div class="form-text">
                                <a href="<?= url('/estoque/inventario/exportar') ?>" class="text-decoration-none">
                                    <i class="bi bi-download me-1"></i>Baixar modelo de planilha
                                </a>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <label for="import-location" class="form-label">Local de estoque</label>
                            <select class="form-select" id="import-location" name="import_location_id">
                                <option value="">Todos os locais</option>
                                <?php foreach ($locais ?? [] as $local): ?>
                                <option value="<?= $local['id'] ?>">
                                    <?= htmlspecialchars($local['name'] ?? ('Local #' . $local['id'])) ?>
                                </option>
                                <?php endforeach; ?>
                            </select>
                            <div class="form-text">Deixe em branco para aplicar a todos os locais</div>
                        </div>

                        <div class="col-md-6">
                            <label for="import-notes" class="form-label">Observações gerais</label>
                            <textarea class="form-control" id="import-notes" name="import_notes" rows="3"
                                placeholder="Informações adicionais sobre esta contagem (opcional)"></textarea>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                        <i class="bi bi-x-circle me-1"></i>Cancelar
                    </button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-cloud-arrow-up me-1"></i>Processar planilha
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
(function($) {
    'use strict';

    const numberFormatter = new Intl.NumberFormat('pt-BR', {
        minimumFractionDigits: 3,
        maximumFractionDigits: 3
    });

    function escapeHtml(text) {
        if (text === null || text === undefined) {
            return '';
        }
        return $('<div>').text(text).html();
    }

    function formatarDataHora(valor) {
        if (!valor) {
            return '-';
        }
        const data = new Date((valor || '').replace(' ', 'T'));
        if (Number.isNaN(data.getTime())) {
            return valor;
        }
        return data.toLocaleString('pt-BR');
    }

    function formatarData(valor) {
        if (!valor) {
            return '-';
        }
        const data = new Date((valor || '').replace(' ', 'T'));
        if (Number.isNaN(data.getTime())) {
            return valor;
        }
        return data.toLocaleDateString('pt-BR');
    }

    function badgeStatus(status) {
        switch (status) {
            case 'finalizado':
                return '<span class="badge bg-success">Finalizado</span>';
            case 'em_andamento':
                return '<span class="badge bg-warning text-dark">Em andamento</span>';
            case 'cancelado':
                return '<span class="badge bg-danger">Cancelado</span>';
            default:
                return `<span class="badge bg-secondary">${escapeHtml((status || '').toUpperCase())}</span>`;
        }
    }

    $(document).on('click', '.inventario-row', function() {
        const inventarioId = $(this).data('id');
        if (!inventarioId) {
            return;
        }

        Swal.fire({
            title: 'Carregando inventário...',
            allowOutsideClick: false,
            allowEscapeKey: false,
            didOpen: () => Swal.showLoading()
        });

        $.ajax({
            url: appUrl('/estoque/inventario/detalhes'),
            method: 'GET',
            data: {
                id: inventarioId
            },
            success: function(response) {
                Swal.close();

                if (!response || !response.success || !response.data) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: response && response.message ? response.message :
                            'Não foi possível carregar os detalhes do inventário.'
                    });
                    return;
                }

                const inventario = response.data.inventario || {};
                const itens = response.data.itens || [];
                const codigo = 'INV-' + String(inventario.id || inventarioId).padStart(5, '0');
                const status = (inventario.status || '').toString().toLowerCase();

                let linhas = '';
                itens.forEach((item, index) => {
                    const nomeProduto = escapeHtml(item.product_name ||
                        `Produto #${item.item_id}`);
                    const sku = escapeHtml(item.sku || '-');
                    const sistema = Number(item.system_quantity || 0);
                    const contada = Number(item.counted_quantity || 0);
                    const diferenca = Number(item.difference !== undefined ? item
                        .difference : (contada - sistema));

                    linhas += `
                        <tr>
                            <td class="text-end">${index + 1}</td>
                            <td>
                                <strong>${nomeProduto}</strong><br>
                                <small class="text-muted">SKU: ${sku}</small>
                            </td>
                            <td class="text-end">${numberFormatter.format(sistema)}</td>
                            <td class="text-end">${numberFormatter.format(contada)}</td>
                            <td class="text-end">${numberFormatter.format(diferenca)}</td>
                        </tr>
                    `;
                });

                if (!linhas) {
                    linhas =
                        '<tr><td colspan="5" class="text-center text-muted">Nenhum item registrado para este inventário.</td></tr>';
                }

                const html = `
                    <div class="text-start mb-3">
                        <div class="row g-3 mb-2">
                            <div class="col-md-4">
                                <span class="text-muted text-uppercase small">Código</span>
                                <div class="fw-bold fs-5">${escapeHtml(codigo)}</div>
                            </div>
                            <div class="col-md-4">
                                <span class="text-muted text-uppercase small">Execução</span>
                                <div class="fw-semibold">${formatarDataHora(inventario.created_at)}</div>
                            </div>
                            <div class="col-md-4">
                                <span class="text-muted text-uppercase small">Status</span>
                                <div>${badgeStatus(status)}</div>
                            </div>
                            <div class="col-md-4">
                                <span class="text-muted text-uppercase small">Referência</span>
                                <div>${formatarData(inventario.date)}</div>
                            </div>
                            <div class="col-md-4">
                                <span class="text-muted text-uppercase small">Local</span>
                                <div>${escapeHtml(inventario.local_name || 'Todos os locais')}</div>
                            </div>
                            <div class="col-md-4">
                                <span class="text-muted text-uppercase small">Responsável</span>
                                <div>${escapeHtml(inventario.usuario_nome || '—')}</div>
                            </div>
                        </div>
                        <div class="mt-2">
                            <span class="text-muted text-uppercase small">Observações</span>
                            <div>${inventario.notes ? escapeHtml(inventario.notes) : '<span class="text-muted">—</span>'}</div>
                        </div>
                    </div>
                    <div class="table-responsive border rounded">
                        <table class="table table-sm table-striped align-middle mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th width="5%" class="text-end">#</th>
                                    <th>Produto</th>
                                    <th width="15%" class="text-end">Sistema</th>
                                    <th width="15%" class="text-end">Contada</th>
                                    <th width="15%" class="text-end">Diferença</th>
                                </tr>
                            </thead>
                            <tbody>${linhas}</tbody>
                        </table>
                    </div>
                `;

                Swal.fire({
                    title: `Inventário ${escapeHtml(codigo)}`,
                    html: html,
                    width: '60rem',
                    confirmButtonText: 'Fechar',
                    focusConfirm: false
                });
            },
            error: function() {
                Swal.close();
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: 'Falha ao consultar detalhes do inventário.'
                });
            }
        });
    });

    $('#form-importar-inventario').on('submit', function(event) {
        event.preventDefault();

        const input = document.getElementById('arquivo-inventario');
        if (!input || !input.files || !input.files[0]) {
            Swal.fire({
                icon: 'warning',
                title: 'Selecione um arquivo',
                text: 'Escolha a planilha de inventário antes de continuar.'
            });
            return;
        }

        const extensao = input.files[0].name.split('.').pop().toLowerCase();
        if (!['xlsx', 'xls', 'csv'].includes(extensao)) {
            Swal.fire({
                icon: 'error',
                title: 'Formato inválido',
                text: 'A planilha deve estar nos formatos .xlsx, .xls ou .csv.'
            });
            return;
        }

        Swal.fire({
            title: 'Processando planilha...',
            text: 'Aguarde enquanto validamos os dados.',
            allowOutsideClick: false,
            allowEscapeKey: false,
            didOpen: () => Swal.showLoading()
        });

        const formData = new FormData(this);
        const locationId = document.getElementById('import_location_id')?.value || '';
        const notes = document.getElementById('import_notes')?.value || '';

        if (locationId) formData.append('import_location_id', locationId);
        if (notes) formData.append('import_notes', notes);

        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            xhrFields: {
                withCredentials: true
            },
            beforeSend: function(xhr) {
                xhr.setRequestHeader('X-Requested-With', 'XMLHttpRequest');
            },
            success: function(response) {
                Swal.close();
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Sucesso!',
                        text: response.message || 'Importação concluída com sucesso!',
                        confirmButtonText: 'OK'
                    }).then(() => {
                        if (response.data && response.data.redirect) {
                            window.location.href = appUrl(response.data.redirect);
                        } else {
                            window.location.reload();
                        }
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: response.message || 'Erro ao importar inventário.'
                    });
                }
            },
            error: function(xhr) {
                Swal.close();
                let mensagem = 'Erro ao importar inventário.';
                try {
                    const response = JSON.parse(xhr.responseText);
                    mensagem = response.message || mensagem;
                } catch (e) {
                    mensagem = xhr.status === 0 ? 'Erro de conexão. Verifique sua internet.' : mensagem;
                }
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: mensagem
                });
            }
        });
    });
})(jQuery);

// Exportação de modelo de inventário por empresa (contagem cega) - Função global
function abrirExportacaoInventario() {
    $.ajax({
        url: appUrl('/compras/monitor-nfe'),
        type: 'GET',
        data: { listar_empresas: 1 },
        dataType: 'json',
        success: function(response) {

            if (!response || !response.success || !response.data) {
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: response && response.message ? response.message : 'Erro ao carregar empresas para exportação.'
                });
                return;
            }
            const empresas = response.data.empresas || [];

            if (empresas.length === 0) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Atenção',
                    text: 'Nenhuma empresa cadastrada para exportação de inventário.'
                });
                return;
            }

            // Se houver apenas uma, exporta direto
            if (empresas.length === 1) {
                const empresaId = empresas[0].id;
                window.location.href = appUrl('/estoque/inventario/exportar') + '?empresa_id=' + encodeURIComponent(empresaId);
                return;
            }

            // Montar opções do select
            let opcoesHtml = '<option value="">Selecione uma empresa...</option>';
            empresas.forEach(emp => {
                const nome = emp.razao_social || emp.nome_fantasia || 'Empresa';
                const cnpj = emp.cnpj ? emp.cnpj.replace(/^(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})$/, '$1.$2.$3/$4-$5') : '';
                opcoesHtml += `<option value="${emp.id}">${nome}${cnpj ? ' - ' + cnpj : ''}</option>`;
            });

            Swal.fire({
                title: 'Selecione a Empresa',
                html: `
                    <div class="mb-3 text-start">
                        <label class="form-label">Empresa para a contagem:</label>
                        <select id="empresa_export_inventario" class="form-select">
                            ${opcoesHtml}
                        </select>
                        <div class="form-text">
                            A planilha será gerada como <strong>contagem cega</strong>, sem coluna de estoque do sistema.
                        </div>
                    </div>
                `,
                icon: 'question',
                showCancelButton: true,
                confirmButtonText: 'Exportar modelo',
                cancelButtonText: 'Cancelar',
                focusConfirm: false,
                didOpen: () => {
                    const select = document.getElementById('empresa_export_inventario');
                    if (select) select.focus();
                },
                preConfirm: () => {
                    const select = document.getElementById('empresa_export_inventario');
                    const empresaId = select ? select.value : '';
                    if (!empresaId) {
                        Swal.showValidationMessage('Por favor, selecione uma empresa');
                        return false;
                    }
                    return empresaId;
                }
            }).then((result) => {
                if (result.isConfirmed && result.value) {
                    const empresaId = result.value;
                    window.location.href = appUrl('/estoque/inventario/exportar') + '?empresa_id=' + encodeURIComponent(empresaId);
                }
            });
        },
        error: function(xhr, status, error) {
            console.error('Erro ao abrir exportação de inventário:', error);
            console.error('Status:', xhr.status);
            console.error('Response:', xhr.responseText);
            Swal.fire({
                icon: 'error',
                title: 'Erro',
                text: 'Erro ao carregar empresas para exportação. Verifique o console para mais detalhes.'
            });
        }
    });
}
</script>

<?php
$content = ob_get_clean();
include dirname(__DIR__, 2) . '/layouts/app.php';
?>