<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-lg-8">
        <h2 class="mb-1"><i class="bi bi-plus-circle me-2"></i> Nova contagem de inventário</h2>
        <p class="text-muted mb-0">Selecione os itens contados, informe as quantidades físicas e registre as diferenças.
        </p>
    </div>
    <div class="col-lg-4 text-lg-end mt-3 mt-lg-0">
        <a href="<?= url('/estoque/inventario') ?>" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left me-2"></i> Voltar para inventários
        </a>
    </div>
</div>

<form id="form-inventario" method="POST" action="<?= url('/estoque/inventario/criar') ?>">
    <div class="mb-4">
        <label for="inventario-notes" class="form-label">Observações (opcional)</label>
        <textarea class="form-control" id="inventario-notes" name="notes" rows="2"
            placeholder="Ex.: Inventário mensal, conferência extraordinária..."></textarea>
    </div>

    <div class="card bg-light mb-4" id="bloco-adicionar-item">
        <div class="card-body">
            <h5 class="mb-3"><i class="bi bi-cart-plus me-2"></i> Adicionar item</h5>
            <div class="row g-2 align-items-end">
                <div class="col-lg-4">
                    <label class="form-label">Produto</label>
                    <div class="position-relative">
                        <input type="text" class="form-control" id="item_search"
                            placeholder="Digite nome, SKU ou código" autocomplete="off">
                        <div id="item_dropdown" class="autocomplete-dropdown" style="display:none;"></div>
                    </div>
                    <input type="hidden" id="produto_id">
                    <div id="card-produto-selecionado" class="alert alert-primary mt-2 py-2 px-3 d-none">
                        <div class="d-flex justify-content-between">
                            <div>
                                <strong id="card-produto-nome"></strong>
                                <div class="small text-muted">SKU: <span id="card-produto-sku"></span></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-1">
                    <label class="form-label">Qtd. Contada</label>
                    <input type="number" class="form-control text-center" id="quantidade_contada" step="0.001" min="0"
                        value="0">
                </div>
                <?php if (!empty($mostrarCampoLote)): ?>
                <div class="col-lg-2">
                    <label class="form-label">Lote</label>
                    <input type="text" class="form-control" id="lote_atual" placeholder="Lote" maxlength="50">
                </div>
                <div class="col-lg-2">
                    <label class="form-label">Fabricação</label>
                    <input type="date" class="form-control" id="fabricacao_atual">
                </div>
                <div class="col-lg-2">
                    <label class="form-label">Validade</label>
                    <input type="date" class="form-control" id="validade_atual">
                </div>
                <div class="col-lg-1 d-grid">
                    <button type="button" class="btn btn-success" id="btn-adicionar-item">
                        <i class="bi bi-plus-circle me-1"></i>
                    </button>
                </div>
                <?php else: ?>
                <div class="col-lg-1 d-grid">
                    <button type="button" class="btn btn-success" id="btn-adicionar-item">
                        <i class="bi bi-plus-circle me-1"></i>Adicionar
                    </button>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="card shadow-sm">
            <div class="card-header bg-primary text-white">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <i class="bi bi-list-check me-2"></i> Itens do inventário
                    </div>
                    <div>
                        <span class="badge bg-light text-dark" id="total-produtos">0 produto(s)</span>
                    </div>
                </div>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0" id="tabela-itens">
                        <thead class="table-light">
                            <tr>
                                <th width="32%">Produto</th>
                                <th width="12%" class="text-center">SKU</th>
                                <th width="15%" class="text-center">Qtd. Contada</th>
                                <?php if (!empty($mostrarCampoLote)): ?>
                                <th width="12%" class="text-center">Lote</th>
                                <?php endif; ?>
                                <th width="12%" class="text-center">Nº Série</th>
                                <th width="10%" class="text-center">Fabricação</th>
                                <th width="10%" class="text-center">Validade</th>
                                <th width="9%" class="text-center">Diferença</th>
                                <th width="8%" class="text-center">Ações</th>
                            </tr>
                        </thead>
                        <tbody id="tbody-produtos">
                            <tr class="linha-vazia">
                                <td colspan="9" class="text-center py-5 text-muted">
                                    <i class="bi bi-plus-square" style="font-size: 3rem;"></i>
                                    <p class="mt-2 mb-0">Nenhum item adicionado. Utilize o campo de busca acima e
                                        clique em
                                        <strong>Adicionar</strong>.
                                    </p>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card-footer bg-light">
                <div class="row align-items-center">
                    <div class="col-md-6">
                        <span class="text-muted">
                            <strong id="produtos-com-ajuste">0</strong> item(ns) com diferença
                        </span>
                    </div>
                    <div class="col-md-6 text-end">
                        <button type="button" class="btn btn-secondary" id="btn-limpar">
                            <i class="bi bi-arrow-counterclockwise me-2"></i> Limpar
                        </button>
                        <button type="submit" class="btn btn-success">
                            <i class="bi bi-check-circle me-2"></i> Processar Inventário
                        </button>
                    </div>
                </div>
            </div>
        </div>
</form>

<style>
.autocomplete-dropdown {
    position: absolute;
    top: 100%;
    left: 0;
    right: 0;
    background: var(--bs-body-bg, #fff);
    border: 1px solid var(--bs-border-color, #dee2e6);
    border-top: none;
    border-radius: 0 0 .375rem .375rem;
    z-index: 50;
    max-height: 280px;
    overflow-y: auto;
    box-shadow: 0 .5rem 1rem rgba(0, 0, 0, .1);
}

.autocomplete-dropdown .autocomplete-item {
    padding: .75rem 1rem;
    cursor: pointer;
    border-bottom: 1px solid var(--bs-border-color, #f0f0f0);
}

.autocomplete-dropdown .autocomplete-item:hover {
    background-color: var(--bs-primary, #0d6efd);
    color: #fff;
}
</style>

<script>
(function($) {
    'use strict';

    const produtosData = <?= json_encode($produtos ?? []) ?>;
    const numberFormatter = new Intl.NumberFormat('pt-BR', {
        minimumFractionDigits: 3,
        maximumFractionDigits: 3
    });
    const mostrarCampoLote = <?= !empty($mostrarCampoLote) ? 'true' : 'false' ?>;
    let itemIndex = 0;
    let produtoSelecionado = null;

    function escapeHtml(text) {
        if (text === null || text === undefined) {
            return '';
        }
        return $('<div>').text(text).html();
    }

    function atualizarTabelaVazia() {
        const total = $('#tbody-produtos tr.item-inventario').length;
        if (total === 0) {
            if ($('#tbody-produtos .linha-vazia').length === 0) {
                $('#tbody-produtos').append(`
                    <tr class="linha-vazia">
                        <td colspan="9" class="text-center py-5 text-muted">
                            <i class="bi bi-plus-square" style="font-size: 3rem;"></i>
                            <p class="mt-2 mb-0">Nenhum item adicionado. Utilize o campo de busca acima e clique em <strong>Adicionar</strong>.</p>
                        </td>
                    </tr>
                `);
            }
        } else {
            $('#tbody-produtos .linha-vazia').remove();
        }
        $('#total-produtos').text(total + ' produto(s)');
    }

    function atualizarBadgeDiferenca($linha) {
        const sistema = parseFloat($linha.find('.quantidade-sistema').val()) || 0;
        const contada = parseFloat($linha.find('.quantidade-contada').val()) || 0;
        const diferenca = contada - sistema;
        const $badge = $linha.find('.badge-diferenca');
        $badge.removeClass('bg-secondary bg-success bg-danger');
        if (diferenca > 0) {
            $badge.addClass('bg-success').text('+' + diferenca.toFixed(2));
        } else if (diferenca < 0) {
            $badge.addClass('bg-danger').text(diferenca.toFixed(2));
        } else {
            $badge.addClass('bg-secondary').text('0.00');
        }
    }

    function atualizarResumoAjustes() {
        let ajustes = 0;
        $('#tbody-produtos tr.item-inventario').each(function() {
            const sistema = parseFloat($(this).find('.quantidade-sistema').val()) || 0;
            const contada = parseFloat($(this).find('.quantidade-contada').val()) || 0;
            if (sistema !== contada) {
                ajustes += 1;
            }
        });
        $('#produtos-com-ajuste').text(ajustes);
    }

    function limparFormularioItem() {
        produtoSelecionado = null;
        $('#produto_id').val('');
        $('#item_search').val('').focus();
        $('#quantidade_contada').val('0');
        $('#lote_atual').val('');
        $('#fabricacao_atual').val('');
        $('#validade_atual').val('');
        $('#item_dropdown').hide().empty();
        $('#card-produto-selecionado').addClass('d-none');
    }

    function adicionarLinha(produto) {
        const loteAtual = mostrarCampoLote ? $('#lote_atual').val().trim() : '';

        // Se o campo de lote está habilitado, verificar se já existe o mesmo produto com o mesmo lote
        if (mostrarCampoLote && loteAtual) {
            const existeMesmoLote = $('#tbody-produtos tr.item-inventario').filter(function() {
                const productId = $(this).attr('data-product-id');
                const lote = $(this).attr('data-lote') || '';
                return productId == produto.id && lote === loteAtual;
            }).length > 0;

            if (existeMesmoLote) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Item já adicionado',
                    text: 'Este produto com este lote já está na contagem. Ajuste a quantidade na tabela.'
                });
                return;
            }
        } else {
            // Se não há campo de lote ou lote está vazio, verificar apenas se o produto já existe
            if ($('#tbody-produtos tr.item-inventario[data-product-id="' + produto.id + '"]').length) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Item já adicionado',
                    text: 'Este produto já está na contagem. Ajuste a quantidade na tabela.'
                });
                return;
            }
        }

        const linha = `
            <tr class="item-inventario" data-product-id="${produto.id}" ${mostrarCampoLote ? `data-lote="${escapeHtml(loteAtual)}"` : ''}>
                <td>
                    <strong>${escapeHtml(produto.name)}</strong>
                    <input type="hidden" name="ajustes[${itemIndex}][product_id]" value="${produto.id}">
                    <input type="hidden" class="quantidade-sistema" name="ajustes[${itemIndex}][quantidade_sistema]" value="${produto.estoque_sistema}">
                </td>
                <td class="text-center">${escapeHtml(produto.sku || '-')}</td>
                <td class="text-center">
                    <input type="number" class="form-control form-control-sm text-center quantidade-contada" name="ajustes[${itemIndex}][quantidade_fisica]" step="0.001" min="0" value="${$('#quantidade_contada').val() || produto.estoque_sistema}">
                </td>
                ${mostrarCampoLote ? `<td class="text-center"><input type="text" class="form-control form-control-sm text-center campo-lote" name="ajustes[${itemIndex}][lote]" maxlength="50" value="${escapeHtml($('#lote_atual').val())}"></td>` : ''}
                <td class="text-center"><input type="text" class="form-control form-control-sm text-center" name="ajustes[${itemIndex}][numero_serie]" maxlength="100"></td>
                <td class="text-center"><input type="date" class="form-control form-control-sm text-center" name="ajustes[${itemIndex}][fabricacao]" value="${$('#fabricacao_atual').val()}"></td>
                <td class="text-center"><input type="date" class="form-control form-control-sm text-center" name="ajustes[${itemIndex}][validade]" value="${$('#validade_atual').val()}"></td>
                <td class="text-center"><span class="badge bg-secondary badge-diferenca">0.00</span></td>
                <td class="text-center">
                    <button type="button" class="btn btn-sm btn-outline-danger btn-remover-item">
                        <i class="bi bi-trash"></i>
                    </button>
                </td>
            </tr>
        `;

        $('#tbody-produtos').append(linha);
        const $linha = $('#tbody-produtos tr.item-inventario').last();
        atualizarBadgeDiferenca($linha);
        atualizarResumoAjustes();
        itemIndex++;
        atualizarTabelaVazia();
        limparFormularioItem();
    }

    function filtrarProdutos(query) {
        const termo = query.toLowerCase();
        return produtosData.filter(produto => {
            const name = (produto.name || '').toLowerCase();
            const sku = (produto.sku || '').toLowerCase();
            return name.includes(termo) || sku.includes(termo);
        }).slice(0, 20);
    }

    function exibirResultados(produtos) {
        const $dropdown = $('#item_dropdown');
        if (!produtos.length) {
            $dropdown.html('<div class="autocomplete-item text-muted">Nenhum produto encontrado</div>').show();
            return;
        }

        let html = '';
        produtos.forEach(produto => {
            html += `
                <div class="autocomplete-item" data-id="${produto.id}" data-nome="${escapeHtml(produto.name)}" data-sku="${escapeHtml(produto.sku || '')}" data-estoque="${produto.estoque_sistema}">
                    <div class="fw-semibold">${escapeHtml(produto.name)}</div>
                    <div class="small text-muted">SKU: ${escapeHtml(produto.sku || '-')}</div>
                </div>
            `;
        });
        $dropdown.html(html).show();
    }

    $('#item_dropdown').on('click', '.autocomplete-item', function() {
        produtoSelecionado = {
            id: $(this).data('id'),
            name: $(this).data('nome'),
            sku: $(this).data('sku'),
            estoque_sistema: $(this).data('estoque')
        };

        $('#produto_id').val(produtoSelecionado.id);
        $('#item_search').val(produtoSelecionado.name);
        $('#quantidade_contada').val(produtoSelecionado.estoque_sistema);
        $('#card-produto-nome').text(produtoSelecionado.name);
        $('#card-produto-sku').text(produtoSelecionado.sku || '-');
        $('#card-produto-selecionado').removeClass('d-none');
        $('#item_dropdown').hide().empty();
    });

    $('#item_search').on('input', function() {
        const termo = $(this).val().trim();
        produtoSelecionado = null;
        $('#produto_id').val('');
        $('#card-produto-selecionado').addClass('d-none');
        if (termo.length < 2) {
            $('#item_dropdown').hide();
            return;
        }

        const resultados = filtrarProdutos(termo);
        exibirResultados(resultados);
    });

    $(document).on('click', function(e) {
        if (!$(e.target).closest('#item_search, #item_dropdown').length) {
            $('#item_dropdown').hide();
        }
    });

    $('#btn-adicionar-item').on('click', function() {
        if (!produtoSelecionado || !$('#produto_id').val()) {
            Swal.fire({
                icon: 'warning',
                title: 'Selecione um produto',
                text: 'Busque e selecione um produto antes de adicionar.'
            });
            return;
        }

        const quantidade = parseFloat($('#quantidade_contada').val());
        if (Number.isNaN(quantidade) || quantidade < 0) {
            Swal.fire({
                icon: 'warning',
                title: 'Quantidade inválida',
                text: 'Informe a quantidade contada do produto.'
            });
            $('#quantidade_contada').focus();
            return;
        }

        adicionarLinha(produtoSelecionado);
    });

    $('#tbody-produtos').on('input', '.quantidade-contada', function() {
        const $linha = $(this).closest('tr');
        atualizarBadgeDiferenca($linha);
        atualizarResumoAjustes();
    });

    // Atualizar atributo data-lote quando o lote for editado na tabela
    $('#tbody-produtos').on('input', '.campo-lote', function() {
        const $linha = $(this).closest('tr');
        const novoLote = $(this).val().trim();
        $linha.attr('data-lote', novoLote);
    });

    $('#tbody-produtos').on('click', '.btn-remover-item', function() {
        $(this).closest('tr').remove();
        atualizarTabelaVazia();
        atualizarResumoAjustes();
    });

    $('#btn-limpar').on('click', function() {
        Swal.fire({
            title: 'Limpar contagem?',
            text: 'Todos os itens adicionados serão removidos.',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#dc3545',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Sim, limpar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                $('#tbody-produtos').empty();
                itemIndex = 0;
                atualizarTabelaVazia();
                atualizarResumoAjustes();
                limparFormularioItem();
                $('#inventario-notes').val('');
            }
        });
    });

    $('#form-inventario').on('submit', function(e) {
        if ($('#tbody-produtos tr.item-inventario').length === 0) {
            e.preventDefault();
            Swal.fire({
                icon: 'warning',
                title: 'Adicione ao menos um item',
                text: 'Inclua os produtos contados antes de processar o inventário.'
            });
        }
    });

    atualizarTabelaVazia();
})(jQuery);
</script>

<?php
$content = ob_get_clean();
include dirname(__DIR__, 2) . '/layouts/app.php';
?>