<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-lg-8">
        <h2 class="mb-1"><i class="bi bi-clipboard-check me-2"></i> Inventário de Estoque</h2>
        <p class="text-muted mb-0">Acompanhe as contagens realizadas, revise diferenças e registre novos ajustes com
            controle completo.</p>
    </div>
    <div class="col-lg-4 text-lg-end mt-3 mt-lg-0">
        <a href="<?= url('/estoque') ?>" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left me-2"></i> Voltar para Gestão de Estoque
        </a>
    </div>
</div>

<ul class="nav nav-tabs mb-4" id="inventarioTabs" role="tablist">
    <li class="nav-item" role="presentation">
        <button class="nav-link active" id="inventario-lista-tab" data-bs-toggle="tab" data-bs-target="#tab-lista"
            type="button" role="tab" aria-controls="tab-lista" aria-selected="true">
            <i class="bi bi-clipboard-data me-2"></i> Inventários realizados
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="inventario-novo-tab" data-bs-toggle="tab" data-bs-target="#tab-nova" type="button"
            role="tab" aria-controls="tab-nova" aria-selected="false">
            <i class="bi bi-plus-circle me-2"></i> Nova contagem
        </button>
    </li>
</ul>

<div class="tab-content" id="inventarioTabsContent">
    <div class="tab-pane fade show active" id="tab-lista" role="tabpanel" aria-labelledby="inventario-lista-tab">
        <?php if (!$inventarioTabelasAtivas || !$inventarioItensAtivos): ?>
            <?php
            $faltantes = [];
            if (!$inventarioTabelasAtivas) {
                $faltantes[] = '`inventarios`';
            }
            if ($inventarioTabelasAtivas && !$inventarioItensAtivos) {
                $faltantes[] = '`inventario_itens`';
            }
            $mensagemTabelas = empty($faltantes)
                ? 'as tabelas necessárias'
                : implode(' e ', $faltantes);
            ?>
            <div class="alert alert-warning border-warning">
                <div class="d-flex align-items-start">
                    <i class="bi bi-exclamation-triangle me-2 fs-4"></i>
                    <div>
                        <strong>Configuração necessária:</strong> execute a migração
                        <code>database/migration_create_inventarios.sql</code> para criar
                        <?= htmlspecialchars($mensagemTabelas) ?>.
                        Assim que as tabelas estiverem disponíveis, o histórico de inventários será exibido nesta tela.
                    </div>
                </div>
            </div>
        <?php else: ?>
            <?php
            $totalInventarios = (int) ($estatisticasInventario['total'] ?? 0);
            $finalizados = (int) ($estatisticasInventario['finalizado'] ?? 0);
            $emAndamento = (int) ($estatisticasInventario['em_andamento'] ?? 0);
            $cancelados = (int) ($estatisticasInventario['cancelado'] ?? 0);
            ?>

            <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center gap-3 mb-3">
                <div>
                    <h5 class="mb-1">Histórico de inventários</h5>
                    <p class="text-muted mb-0">Revise as contagens finalizadas, pendentes ou canceladas e acompanhe os
                        responsáveis.</p>
                </div>
                <div class="d-flex flex-wrap gap-2">
                    <button type="button" class="btn btn-outline-primary" id="btn-atualizar-inventarios">
                        <i class="bi bi-arrow-clockwise me-2"></i>Atualizar
                    </button>
                    <button type="button" class="btn btn-success" id="btn-abrir-nova-contagem">
                        <i class="bi bi-plus-circle me-2"></i>Iniciar nova contagem
                    </button>
                </div>
            </div>

            <!-- <div class="row g-3 mb-4">
            <div class="col-md-3">
                <div class="card shadow-sm border-primary h-100">
                    <div class="card-body">
                        <span class="text-muted text-uppercase small">Total de inventários</span>
                        <h3 class="fw-bold mb-0"><?= number_format($totalInventarios, 0, ',', '.') ?></h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card shadow-sm border-success h-100">
                    <div class="card-body">
                        <span class="text-muted text-uppercase small">Finalizados</span>
                        <h3 class="fw-bold text-success mb-0"><?= number_format($finalizados, 0, ',', '.') ?></h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card shadow-sm border-warning h-100">
                    <div class="card-body">
                        <span class="text-muted text-uppercase small">Em andamento</span>
                        <h3 class="fw-bold text-warning mb-0"><?= number_format($emAndamento, 0, ',', '.') ?></h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card shadow-sm border-danger h-100">
                    <div class="card-body">
                        <span class="text-muted text-uppercase small">Cancelados</span>
                        <h3 class="fw-bold text-danger mb-0"><?= number_format($cancelados, 0, ',', '.') ?></h3>
                    </div>
                </div>
            </div>
        </div> -->

            <div class="card mb-4">
                <div class="card-header bg-light">
                    <i class="bi bi-funnel me-2"></i>Filtros
                </div>
                <div class="card-body">
                    <form class="row g-3 align-items-end" id="form-filtros-inventarios" method="GET"
                        action="<?= url('/estoque/inventario') ?>">
                        <input type="hidden" name="location_id"
                            value="<?= htmlspecialchars($filtros['location_id'] ?? '') ?>">

                        <div class="col-md-3">
                            <label for="filtro-busca" class="form-label">Buscar</label>
                            <input type="text" class="form-control" id="filtro-busca" name="busca"
                                value="<?= htmlspecialchars($filtrosInventario['busca'] ?? '') ?>"
                                placeholder="Código ou observação">
                        </div>

                        <div class="col-md-2">
                            <label for="filtro-status" class="form-label">Status</label>
                            <select class="form-select" id="filtro-status" name="status">
                                <option value="">Todos</option>
                                <option value="finalizado"
                                    <?= ($filtrosInventario['status'] ?? '') === 'finalizado' ? 'selected' : '' ?>>
                                    Finalizado</option>
                                <option value="em_andamento"
                                    <?= ($filtrosInventario['status'] ?? '') === 'em_andamento' ? 'selected' : '' ?>>Em
                                    andamento</option>
                                <option value="cancelado"
                                    <?= ($filtrosInventario['status'] ?? '') === 'cancelado' ? 'selected' : '' ?>>Cancelado
                                </option>
                            </select>
                        </div>

                        <div class="col-md-2">
                            <label for="filtro-local" class="form-label">Local</label>
                            <select class="form-select" id="filtro-local" name="inventario_local">
                                <option value="">Todos os locais</option>
                                <option value="sem_local"
                                    <?= ($filtrosInventario['local'] ?? '') === 'sem_local' ? 'selected' : '' ?>>Sem local
                                    associado</option>
                                <?php foreach ($locais ?? [] as $local): ?>
                                    <option value="<?= $local['id'] ?>"
                                        <?= ($filtrosInventario['local'] ?? '') == $local['id'] ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($local['name']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="col-md-2">
                            <label for="filtro-responsavel" class="form-label">Responsável</label>
                            <select class="form-select" id="filtro-responsavel" name="responsavel">
                                <option value="">Todos</option>
                                <?php foreach ($responsaveisInventario ?? [] as $responsavel): ?>
                                    <option value="<?= $responsavel['created_by'] ?>"
                                        <?= ($filtrosInventario['responsavel'] ?? '') == $responsavel['created_by'] ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($responsavel['nome']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="col-md-1">
                            <label for="filtro-data-inicio" class="form-label">De</label>
                            <input type="date" class="form-control" id="filtro-data-inicio" name="data_inicio"
                                value="<?= htmlspecialchars($filtrosInventario['data_inicio'] ?? '') ?>">
                        </div>

                        <div class="col-md-1">
                            <label for="filtro-data-fim" class="form-label">Até</label>
                            <input type="date" class="form-control" id="filtro-data-fim" name="data_fim"
                                value="<?= htmlspecialchars($filtrosInventario['data_fim'] ?? '') ?>">
                        </div>

                        <div class="col-md-3 col-lg-2">
                            <button type="submit" class="btn btn-primary w-100">
                                <i class="bi bi-search me-2"></i>Filtrar
                            </button>
                        </div>
                        <div class="col-md-3 col-lg-2">
                            <a href="<?= url('/estoque/inventario') ?>" class="btn btn-outline-secondary w-100">
                                <i class="bi bi-x-circle me-2"></i>Limpar
                            </a>
                        </div>
                    </form>
                </div>
            </div>

            <div class="card shadow-sm">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span><i class="bi bi-journal-text me-2"></i> Inventários cadastrados</span>
                    <span class="text-muted small"><?= count($inventarios) ?> registro(s)</span>
                </div>
                <div class="card-body p-0">
                    <?php if (empty($inventarios)): ?>
                        <div class="text-center text-muted py-5">
                            <i class="bi bi-inboxes" style="font-size: 3rem;"></i>
                            <p class="mt-2 mb-1">Nenhum inventário encontrado com os filtros atuais.</p>
                            <p class="small mb-0">Inicie uma contagem em "Nova contagem" para registrar o primeiro inventário.
                            </p>
                        </div>
                    <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th width="12%">Código</th>
                                        <th width="18%">Execução / Referência</th>
                                        <th width="18%">Local</th>
                                        <th width="18%">Responsável</th>
                                        <th width="10%" class="text-center">Itens (ajustados / total)</th>
                                        <th width="10%" class="text-end">Diferença</th>
                                        <th width="8%" class="text-center">Status</th>
                                        <th width="16%">Ações</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($inventarios as $inventario): ?>
                                        <?php
                                        $inventarioId = (int) ($inventario['id'] ?? 0);
                                        $codigo = 'INV-' . str_pad((string) $inventarioId, 5, '0', STR_PAD_LEFT);
                                        $dataCriacao = !empty($inventario['created_at']) ? date('d/m/Y H:i', strtotime($inventario['created_at'])) : '-';
                                        $dataReferencia = !empty($inventario['date']) ? date('d/m/Y', strtotime($inventario['date'])) : '-';
                                        $localNome = $inventario['local_name'] ?? 'Todos os locais';
                                        $usuarioNome = $inventario['usuario_nome'] ?? '—';
                                        $totalItens = (int) ($inventario['total_itens'] ?? 0);
                                        $itensAjustados = (int) ($inventario['itens_ajustados'] ?? 0);
                                        $diferencaTotal = number_format((float) ($inventario['diferenca_total'] ?? 0), 3, ',', '.');
                                        $notes = trim((string) ($inventario['notes'] ?? ''));
                                        $resumoItens = $totalItens > 0 ? sprintf('%d / %d', $itensAjustados, $totalItens) : '—';
                                        $status = strtolower((string) ($inventario['status'] ?? ''));

                                        switch ($status) {
                                            case 'finalizado':
                                                $statusClasse = 'bg-success';
                                                $statusRotulo = 'Finalizado';
                                                break;
                                            case 'em_andamento':
                                                $statusClasse = 'bg-warning text-dark';
                                                $statusRotulo = 'Em andamento';
                                                break;
                                            case 'cancelado':
                                                $statusClasse = 'bg-danger';
                                                $statusRotulo = 'Cancelado';
                                                break;
                                            default:
                                                $statusClasse = 'bg-secondary';
                                                $statusRotulo = strtoupper($status);
                                                break;
                                        }

                                        $notaResumida = '';
                                        if ($notes !== '') {
                                            $notaResumida = function_exists('mb_strimwidth')
                                                ? mb_strimwidth($notes, 0, 80, '…', 'UTF-8')
                                                : (strlen($notes) > 80 ? substr($notes, 0, 80) . '…' : $notes);
                                        }
                                        ?>
                                        <tr>
                                            <td><strong><?= htmlspecialchars($codigo) ?></strong></td>
                                            <td>
                                                <span class="d-block fw-semibold"><?= htmlspecialchars($dataCriacao) ?></span>
                                                <small class="text-muted">Referência:
                                                    <?= htmlspecialchars($dataReferencia) ?></small>
                                            </td>
                                            <td><?= htmlspecialchars($localNome) ?></td>
                                            <td><?= htmlspecialchars($usuarioNome) ?></td>
                                            <td class="text-center"><?= htmlspecialchars($resumoItens) ?></td>
                                            <td class="text-end"><?= $diferencaTotal ?></td>
                                            <td class="text-center"><span
                                                    class="badge <?= $statusClasse ?>"><?= htmlspecialchars($statusRotulo ?: '—') ?></span>
                                            </td>
                                            <td>
                                                <?php if ($notes !== ''): ?>
                                                    <div class="text-muted small mb-2">
                                                        <i class="bi bi-sticky me-1"></i><?= htmlspecialchars($notaResumida) ?>
                                                    </div>
                                                <?php endif; ?>
                                                <div class="d-flex flex-wrap gap-2">
                                                    <button type="button"
                                                        class="btn btn-sm btn-outline-primary btn-visualizar-inventario"
                                                        data-id="<?= $inventarioId ?>">
                                                        <i class="bi bi-eye me-1"></i>Detalhes
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <div class="tab-pane fade" id="tab-nova" role="tabpanel" aria-labelledby="inventario-novo-tab">
        <div class="alert alert-info">
            <i class="bi bi-info-circle me-2"></i>
            <strong>Como funciona:</strong> informe a quantidade contada para cada produto. O sistema calcula
            automaticamente a diferença em relação ao estoque atual e registra os ajustes necessários em
            <code>estoque_movimentos</code>.
        </div>

        <div class="card mb-4">
            <div class="card-header bg-light">
                <i class="bi bi-funnel me-2"></i>Filtros da contagem
            </div>
            <div class="card-body">
                <form method="GET" action="<?= url('/estoque/inventario') ?>" id="form-filtros">
                    <input type="hidden" name="executar_filtro" value="1">
                    <div class="row g-3">
                        <div class="col-md-3">
                            <label for="location_id" class="form-label">Local de Estoque</label>
                            <select class="form-select" id="location_id" name="location_id">
                                <option value="">Todos os locais</option>
                                <?php foreach ($locais ?? [] as $local): ?>
                                    <option value="<?= $local['id'] ?>"
                                        <?= ($filtros['location_id'] ?? '') == $local['id'] ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($local['name']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label for="grupo_id" class="form-label">Grupo de Itens</label>
                            <select class="form-select" id="grupo_id" name="grupo_id">
                                <option value="">Todos os grupos</option>
                                <?php foreach ($grupos ?? [] as $grupo): ?>
                                    <option value="<?= $grupo['id'] ?>"
                                        <?= ($filtros['grupo_id'] ?? '') == $grupo['id'] ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($grupo['nome']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label for="subgrupo_id" class="form-label">Subgrupo</label>
                            <select class="form-select" id="subgrupo_id" name="subgrupo_id">
                                <option value="">Todos os subgrupos</option>
                                <?php foreach ($subgrupos ?? [] as $subgrupo): ?>
                                    <option value="<?= $subgrupo['id'] ?>" data-grupo="<?= $subgrupo['grupo_id'] ?>"
                                        <?= ($filtros['subgrupo_id'] ?? '') == $subgrupo['id'] ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($subgrupo['nome']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label for="fornecedor_id" class="form-label">Fornecedor</label>
                            <select class="form-select" id="fornecedor_id" name="fornecedor_id">
                                <option value="">Todos os fornecedores</option>
                                <?php foreach ($fornecedores ?? [] as $fornecedor): ?>
                                    <option value="<?= $fornecedor['id'] ?>"
                                        <?= ($filtros['fornecedor_id'] ?? '') == $fornecedor['id'] ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($fornecedor['trade_name'] ?: $fornecedor['name']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="col-md-2 d-flex align-items-end">
                            <button type="submit" class="btn btn-primary w-100">
                                <i class="bi bi-search me-2"></i> Filtrar
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <div class="card mb-4">
            <div class="card-header bg-light">
                <i class="bi bi-pencil-square me-2"></i> Observações gerais
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-12">
                        <label for="inventario-notes" class="form-label">Observações do inventário</label>
                        <textarea class="form-control" id="inventario-notes" name="notes" rows="2"
                            placeholder="Ex.: Contagem anual, conferência do depósito A, inventário extraordinário etc."></textarea>
                    </div>
                </div>
            </div>
        </div>

        <?php if (!$executarFiltroProdutos): ?>
            <div class="alert alert-info">
                <i class="bi bi-info-circle me-2"></i>
                Selecione os filtros desejados e clique em <strong>Filtrar</strong> para carregar os itens que serão
                contados no inventário.
            </div>
        <?php endif; ?>

        <form id="form-inventario" method="POST" action="<?= url('/estoque/inventario/criar') ?>">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <i class="bi bi-list-check me-2"></i> Produtos para contagem
                        </div>
                        <div>
                            <span class="badge bg-light text-dark" id="total-produtos"><?= count($produtos) ?>
                                produto(s)</span>
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th width="3%" class="text-center">
                                        <input type="checkbox" id="select-all" title="Selecionar todos">
                                    </th>
                                    <th width="20%">Produto</th>
                                    <th width="8%" class="text-center">SKU</th>
                                    <th width="8%" class="text-center">Atual</th>
                                    <th width="8%" class="text-center">Contada</th>
                                    <?php if (!empty($mostrarCampoLote)): ?>
                                        <th width="8%" class="text-center">Lote</th>
                                    <?php endif; ?>
                                    <th width="10%" class="text-center">Nº Série</th>
                                    <th width="8%" class="text-center">Fabricação</th>
                                    <th width="8%" class="text-center">Validade</th>
                                    <th width="7%" class="text-center">Diferença</th>
                                    <th width="5%" class="text-center">Ações</th>
                                </tr>
                            </thead>
                            <tbody id="tbody-produtos">
                                <?php if (!$executarFiltroProdutos): ?>
                                    <tr>
                                        <td colspan="11" class="text-center py-5 text-muted">
                                            <i class="bi bi-filter-circle" style="font-size: 3rem;"></i>
                                            <p class="mt-2 mb-0">Defina os filtros acima e clique em
                                                <strong>Filtrar</strong> para carregar os itens do inventário.
                                            </p>
                                        </td>
                                    </tr>
                                <?php elseif (empty($produtos)): ?>
                                    <tr>
                                        <td colspan="11" class="text-center py-5 text-muted">
                                            <i class="bi bi-inbox" style="font-size: 3rem;"></i>
                                            <p class="mt-2 mb-0">Nenhum produto encontrado com os filtros aplicados.</p>
                                        </td>
                                    </tr>
                                <?php else: ?>
                                    <?php foreach ($produtos as $index => $produto): ?>
                                        <tr data-product-id="<?= $produto['id'] ?>">
                                            <td class="text-center align-middle">
                                                <input type="checkbox" class="form-check-input produto-check"
                                                    data-index="<?= $index ?>">
                                            </td>
                                            <td class="align-middle">
                                                <strong><?= htmlspecialchars($produto['name']) ?></strong>
                                                <?php if (!empty($produto['category_name'])): ?>
                                                    <br><small class="text-muted">categoria:
                                                        <?= htmlspecialchars($produto['category_name']) ?></small>
                                                <?php endif; ?>
                                            </td>
                                            <td class="text-center align-middle">
                                                <span
                                                    class="badge bg-secondary"><?= htmlspecialchars($produto['sku'] ?? '-') ?></span>
                                            </td>
                                            <td class="text-center align-middle">
                                                <span
                                                    class="badge bg-info text-dark fs-6"><?= number_format($produto['estoque_sistema'], 0, ',', '.') ?></span>
                                                <input type="hidden" class="qtd-sistema"
                                                    value="<?= $produto['estoque_sistema'] ?>">
                                            </td>
                                            <td class="text-center align-middle">
                                                <input type="number" class="form-control form-control-sm text-center qtd-fisica"
                                                    data-index="<?= $index ?>" data-product-id="<?= $produto['id'] ?>"
                                                    data-sistema="<?= $produto['estoque_sistema'] ?>" min="0" step="0.001"
                                                    placeholder="0">
                                            </td>
                                            <?php if (!empty($mostrarCampoLote)): ?>
                                                <td class="text-center align-middle">
                                                    <input type="text" class="form-control form-control-sm text-center lote-campo"
                                                        data-index="<?= $index ?>" placeholder="Lote" maxlength="50">
                                                </td>
                                            <?php endif; ?>
                                            <td class="text-center align-middle">
                                                <input type="text"
                                                    class="form-control form-control-sm text-center numero-serie-campo"
                                                    data-index="<?= $index ?>" placeholder="Nº Série" maxlength="100">
                                            </td>
                                            <td class="text-center align-middle">
                                                <input type="date"
                                                    class="form-control form-control-sm text-center fabricacao-campo"
                                                    data-index="<?= $index ?>">
                                            </td>
                                            <td class="text-center align-middle">
                                                <input type="date"
                                                    class="form-control form-control-sm text-center validade-campo"
                                                    data-index="<?= $index ?>">
                                            </td>
                                            <td class="text-center align-middle">
                                                <span class="badge diferenca-<?= $index ?> bg-secondary">-</span>
                                            </td>
                                            <td class="text-center align-middle">
                                                <button type="button" class="btn btn-sm btn-outline-primary btn-detalhes"
                                                    data-index="<?= $index ?>"
                                                    data-product-name="<?= htmlspecialchars($produto['name']) ?>"
                                                    title="Ver detalhes">
                                                    <i class="bi bi-info-circle"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer bg-light">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <span class="text-muted">
                                <strong id="produtos-com-ajuste">0</strong> produto(s) com ajuste para processar
                            </span>
                        </div>
                        <div class="col-md-6 text-end">
                            <button type="button" class="btn btn-secondary" onclick="limparContagem()">
                                <i class="bi bi-arrow-counterclockwise me-2"></i> Limpar
                            </button>
                            <button type="submit" class="btn btn-success">
                                <i class="bi bi-check-circle me-2"></i> Processar Inventário
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
    (function($) {
        'use strict';

        const numberFormatter = new Intl.NumberFormat('pt-BR', {
            minimumFractionDigits: 3,
            maximumFractionDigits: 3
        });

        function escapeHtml(text) {
            if (text === null || text === undefined) {
                return '';
            }
            return $('<div>').text(text).html();
        }

        function formatarDataHora(valor) {
            if (!valor) {
                return '-';
            }
            const data = new Date((valor || '').replace(' ', 'T'));
            if (Number.isNaN(data.getTime())) {
                return valor;
            }
            return data.toLocaleString('pt-BR');
        }

        function formatarData(valor) {
            if (!valor) {
                return '-';
            }
            const data = new Date((valor || '').replace(' ', 'T'));
            if (Number.isNaN(data.getTime())) {
                return valor;
            }
            return data.toLocaleDateString('pt-BR');
        }

        function badgeStatus(status) {
            switch (status) {
                case 'finalizado':
                    return '<span class="badge bg-success">Finalizado</span>';
                case 'em_andamento':
                    return '<span class="badge bg-warning text-dark">Em andamento</span>';
                case 'cancelado':
                    return '<span class="badge bg-danger">Cancelado</span>';
                default:
                    return `<span class="badge bg-secondary">${escapeHtml((status || '').toUpperCase())}</span>`;
            }
        }

        $(document).ready(function() {
            $('#btn-abrir-nova-contagem').on('click', function() {
                const tabTrigger = document.querySelector(
                    '#inventarioTabs button[data-bs-target="#tab-nova"]');
                if (tabTrigger && typeof bootstrap !== 'undefined') {
                    const tab = new bootstrap.Tab(tabTrigger);
                    tab.show();
                }
            });

            $('#btn-atualizar-inventarios').on('click', function() {
                window.location.reload();
            });

            const $grupoSelect = $('#grupo_id');
            const $subgrupoSelect = $('#subgrupo_id');
            let subgrupoOptions = null;

            if ($subgrupoSelect.length) {
                subgrupoOptions = $subgrupoSelect.find('option').clone();

                const atualizarSubgrupos = (preservar = true) => {
                    if (!subgrupoOptions) {
                        return;
                    }

                    const valorAtual = preservar ? $subgrupoSelect.val() : '';
                    $subgrupoSelect.html(subgrupoOptions.clone());

                    const grupoSelecionado = $grupoSelect.val();
                    if (grupoSelecionado) {
                        $subgrupoSelect.find('option').each(function() {
                            const $option = $(this);
                            const grupoAttr = $option.data('grupo');
                            const valor = $option.val();
                            if (!valor) {
                                return;
                            }
                            if (String(grupoAttr) !== String(grupoSelecionado)) {
                                $option.remove();
                            }
                        });
                    }

                    if (valorAtual && $subgrupoSelect.find(`option[value="${valorAtual}"]`).length) {
                        $subgrupoSelect.val(valorAtual);
                    } else {
                        $subgrupoSelect.val('');
                    }
                };

                atualizarSubgrupos(true);
                $grupoSelect.on('change', function() {
                    atualizarSubgrupos(false);
                });
            }

            $(document).on('click', '.btn-visualizar-inventario', function() {
                const inventarioId = $(this).data('id');
                if (!inventarioId) {
                    return;
                }

                Swal.fire({
                    title: 'Carregando inventário...',
                    allowOutsideClick: false,
                    allowEscapeKey: false,
                    didOpen: () => Swal.showLoading()
                });

                $.ajax({
                    url: appUrl('/estoque/inventario/detalhes'),
                    method: 'GET',
                    data: {
                        id: inventarioId
                    },
                    success: function(response) {
                        Swal.close();

                        if (!response || !response.success || !response.data) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro',
                                text: response && response.message ? response
                                    .message : 'Não foi possível carregar os detalhes do inventário.'
                            });
                            return;
                        }

                        const inventario = response.data.inventario || {};
                        const itens = response.data.itens || [];
                        const mostrarCampoLote = response.data.mostrarCampoLote === true || response.data.mostrarCampoLote === 'true' || response.data.mostrarCampoLote === 1;
                        const codigo = 'INV-' + String(inventario.id || inventarioId)
                            .padStart(5, '0');
                        const status = (inventario.status || '').toString().toLowerCase();

                        // Debug: verificar se mostrarCampoLote está sendo recebido
                        console.log('🔍 Debug Inventário:', {
                            mostrarCampoLote: mostrarCampoLote,
                            tipo: typeof mostrarCampoLote,
                            itensCount: itens.length,
                            primeiroItem: itens[0] || null
                        });

                        let linhas = '';
                        itens.forEach((item, index) => {
                            const nomeProduto = escapeHtml(item.product_name ||
                                `Produto #${item.item_id}`);
                            const sku = escapeHtml(item.sku || '-');
                            const sistema = Number(item.system_quantity || 0);
                            const contada = Number(item.counted_quantity || 0);
                            const diferenca = Number(item.difference !== undefined ?
                                item.difference : (contada - sistema));

                            // Campos de lote, fabricação e validade (sempre buscar, mesmo se vazios)
                            const lote = item.lote ? escapeHtml(item.lote) : '-';
                            const fabricacao = item.fabricacao ? formatarData(item.fabricacao) : '-';
                            const validade = item.validade ? formatarData(item.validade) : '-';

                            linhas += `
                            <tr>
                                <td>${index + 1}</td>
                                <td>
                                    <strong>${nomeProduto}</strong><br>
                                    <small class="text-muted">SKU: ${sku}</small>
                                </td>
                                <td class="text-end">${numberFormatter.format(sistema)}</td>
                                <td class="text-end">${numberFormatter.format(contada)}</td>
                                ${mostrarCampoLote ? `<td class="text-center">${lote}</td>` : ''}
                                ${mostrarCampoLote ? `<td class="text-center">${fabricacao}</td>` : ''}
                                ${mostrarCampoLote ? `<td class="text-center">${validade}</td>` : ''}
                                <td class="text-end">${numberFormatter.format(diferenca)}</td>
                            </tr>
                        `;
                        });

                        if (!linhas) {
                            const colspan = mostrarCampoLote ? 8 : 5;
                            linhas =
                                `<tr><td colspan="${colspan}" class="text-center text-muted">Nenhum item registrado para este inventário.</td></tr>`;
                        }

                        // Ajustar largura do modal baseado em mostrarCampoLote (mais larga quando tem campos de lote)
                        const larguraModal = mostrarCampoLote ? '95rem' : '60rem';

                        const html = `
                        <div class="text-start mb-3">
                            <div class="row g-3 mb-2">
                                <div class="col-md-4">
                                    <span class="text-muted text-uppercase small">Código</span>
                                    <div class="fw-bold fs-5">${codigo}</div>
                                </div>
                                <div class="col-md-4">
                                    <span class="text-muted text-uppercase small">Execução</span>
                                    <div class="fw-semibold">${formatarDataHora(inventario.created_at)}</div>
                                </div>
                                <div class="col-md-4">
                                    <span class="text-muted text-uppercase small">Status</span>
                                    <div>${badgeStatus(status)}</div>
                                </div>
                                <div class="col-md-4">
                                    <span class="text-muted text-uppercase small">Referência</span>
                                    <div>${formatarData(inventario.date)}</div>
                                </div>
                                <div class="col-md-4">
                                    <span class="text-muted text-uppercase small">Local</span>
                                    <div>${escapeHtml(inventario.local_name || 'Todos os locais')}</div>
                                </div>
                                <div class="col-md-4">
                                    <span class="text-muted text-uppercase small">Responsável</span>
                                    <div>${escapeHtml(inventario.usuario_nome || '—')}</div>
                                </div>
                            </div>
                            <div class="mt-2">
                                <span class="text-muted text-uppercase small">Observações</span>
                                <div>${inventario.notes ? escapeHtml(inventario.notes) : '<span class="text-muted">—</span>'}</div>
                            </div>
                        </div>
                        <div class="table-responsive border rounded" id="tabela-inventario-detalhes">
                            <table class="table table-sm table-striped align-middle mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th width="5%">#</th>
                                        <th>Produto</th>
                                        <th width="12%" class="text-end">Sistema</th>
                                        <th width="12%" class="text-end">Contada</th>
                                        ${mostrarCampoLote ? '<th width="12%" class="text-center">Lote</th>' : ''}
                                        ${mostrarCampoLote ? '<th width="12%" class="text-center">Fabricação</th>' : ''}
                                        ${mostrarCampoLote ? '<th width="12%" class="text-center">Validade</th>' : ''}
                                        <th width="12%" class="text-end">Diferença</th>
                                    </tr>
                                </thead>
                                <tbody>${linhas}</tbody>
                            </table>
                        </div>
                        <div class="mt-3 text-end">
                            <button type="button" class="btn btn-primary btn-sm" onclick="window.print()">
                                <i class="bi bi-printer me-2"></i>Imprimir
                            </button>
                        </div>
                    `;

                        Swal.fire({
                            title: `Inventário ${codigo}`,
                            html: html,
                            width: larguraModal,
                            confirmButtonText: 'Fechar',
                            focusConfirm: false,
                            customClass: {
                                popup: 'swal2-popup-inventario',
                                htmlContainer: 'swal2-html-container-inventario'
                            }
                        });
                    },
                    error: function() {
                        Swal.close();
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro',
                            text: 'Falha ao consultar detalhes do inventário.'
                        });
                    }
                });
            });

            $(document).on('click', '.btn-detalhes', function() {
                const index = $(this).data('index');
                const productName = $(this).data('product-name');
                const sistema = parseFloat($(`.qtd-fisica[data-index="${index}"]`).data('sistema')) ||
                    0;
                const valorDigitado = $(`.qtd-fisica[data-index="${index}"]`).val();
                const fisica = valorDigitado === '' ? null : (parseFloat(valorDigitado) || 0);
                const lote = $(`.lote-campo[data-index="${index}"]`).val() || '-';
                const numeroSerie = $(`.numero-serie-campo[data-index="${index}"]`).val() || '-';
                const fabricacao = $(`.fabricacao-campo[data-index="${index}"]`).val() || '-';
                const validade = $(`.validade-campo[data-index="${index}"]`).val() || '-';
                const diferenca = fisica === null ? null : (fisica - sistema);

                const html = `
                <div class="text-start">
                    <h5 class="mb-3">${escapeHtml(productName)}</h5>
                    <table class="table table-sm">
                        <tr>
                            <th width="40%">Qtd. Sistema</th>
                            <td class="text-end"><strong>${numberFormatter.format(sistema)}</strong></td>
                        </tr>
                        <tr>
                            <th>Qtd. Contada</th>
                            <td class="text-end"><strong>${fisica === null ? '<span class="text-muted">—</span>' : numberFormatter.format(fisica)}</strong></td>
                        </tr>
                        <tr>
                            <th>Diferença</th>
                            <td class="text-end">${diferenca === null ? '<span class="text-muted">—</span>' : numberFormatter.format(diferenca)}</td>
                        </tr>
                        <tr><td colspan="2"><hr></td></tr>
                        <tr>
                            <th>Lote</th>
                            <td class="text-end">${escapeHtml(lote)}</td>
                        </tr>
                        <tr>
                            <th>Nº Série</th>
                            <td class="text-end">${escapeHtml(numeroSerie)}</td>
                        </tr>
                        <tr>
                            <th>Fabricação</th>
                            <td class="text-end">${fabricacao !== '-' ? formatarData(fabricacao) : '-'}</td>
                        </tr>
                        <tr>
                            <th>Validade</th>
                            <td class="text-end">${validade !== '-' ? formatarData(validade) : '-'}</td>
                        </tr>
                    </table>
                </div>
            `;

                Swal.fire({
                    title: 'Detalhes do produto',
                    html: html,
                    width: '32rem',
                    confirmButtonText: 'Fechar'
                });
            });

            $('#select-all').on('change', function() {
                $('.produto-check').prop('checked', $(this).prop('checked'));
            });

            $('.qtd-fisica').on('input', function() {
                const index = $(this).data('index');
                const sistema = parseFloat($(this).data('sistema')) || 0;
                const valorDigitado = $(this).val();
                const fisica = valorDigitado === '' ? 0 : (parseFloat(valorDigitado) || 0);
                const diferenca = fisica - sistema;

                const $badge = $(`.diferenca-${index}`);

                if (valorDigitado === '') {
                    $badge.removeClass('bg-success bg-danger bg-warning').addClass('bg-secondary').text(
                        '-');
                } else if (diferenca > 0) {
                    $badge.removeClass('bg-secondary bg-danger bg-warning').addClass('bg-success').text(
                        '+' + diferenca.toFixed(0));
                } else if (diferenca < 0) {
                    $badge.removeClass('bg-secondary bg-success bg-warning').addClass('bg-danger').text(
                        diferenca.toFixed(0));
                } else {
                    $badge.removeClass('bg-success bg-danger bg-warning').addClass('bg-secondary').text(
                        '0');
                }

                atualizarContador();
            });

            function atualizarContador() {
                let total = 0;
                $('.qtd-fisica').each(function() {
                    const valorDigitado = $(this).val();
                    if (valorDigitado === '') {
                        return;
                    }
                    const sistema = parseFloat($(this).data('sistema')) || 0;
                    const fisica = parseFloat(valorDigitado) || 0;
                    if (fisica !== sistema) {
                        total++;
                    }
                });
                $('#produtos-com-ajuste').text(total);
            }

            $('#form-inventario').on('submit', function(e) {
                e.preventDefault();

                const ajustes = [];
                $('.qtd-fisica').each(function() {
                    const valorDigitado = $(this).val();
                    if (valorDigitado === '') {
                        return;
                    }

                    const index = $(this).data('index');
                    const productId = $(this).data('product-id');
                    const sistema = parseFloat($(this).data('sistema')) || 0;
                    const fisica = parseFloat(valorDigitado) || 0;
                    const lote = $(`.lote-campo[data-index="${index}"]`).val();
                    const numeroSerie = $(`.numero-serie-campo[data-index="${index}"]`).val();
                    const fabricacao = $(`.fabricacao-campo[data-index="${index}"]`).val();
                    const validade = $(`.validade-campo[data-index="${index}"]`).val();

                    ajustes.push({
                        product_id: productId,
                        quantidade_sistema: sistema,
                        quantidade_fisica: fisica,
                        lote: lote || null,
                        numero_serie: numeroSerie || null,
                        fabricacao: fabricacao || null,
                        validade: validade || null
                    });
                });

                if (ajustes.length === 0) {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Atenção',
                        text: 'Nenhum ajuste foi informado. Insira as quantidades contadas para processar o inventário.'
                    });
                    return;
                }

                Swal.fire({
                    title: 'Confirmar Inventário?',
                    html: `Serão processados <strong>${ajustes.length}</strong> item(ns). Os ajustes necessários serão lançados em <code>estoque_movimentos</code>.`,
                    icon: 'question',
                    showCancelButton: true,
                    confirmButtonColor: '#198754',
                    cancelButtonColor: '#6c757d',
                    confirmButtonText: '<i class="bi bi-check-circle me-2"></i>Confirmar',
                    cancelButtonText: '<i class="bi bi-x-circle me-2"></i>Cancelar'
                }).then((result) => {
                    if (result.isConfirmed) {
                        processarInventario(ajustes);
                    }
                });
            });

            function processarInventario(ajustes) {
                const $btn = $('#form-inventario button[type="submit"]');
                $btn.prop('disabled', true).html(
                    '<span class="spinner-border spinner-border-sm me-2"></span>Processando...');

                $.ajax({
                    url: appUrl('/estoque/inventario/criar'),
                    type: 'POST',
                    data: {
                        ajustes: ajustes,
                        location_id: $('#location_id').val() || '',
                        notes: $('#inventario-notes').val() || ''
                    },
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Inventário processado',
                                text: response.message,
                                timer: 2200
                            }).then(() => {
                                window.location.reload();
                            });
                        } else {
                            $btn.prop('disabled', false).html(
                                '<i class="bi bi-check-circle me-2"></i> Processar Inventário');
                            Swal.fire({
                                icon: 'error',
                                title: 'Erro',
                                text: response.message
                            });
                        }
                    },
                    error: function(xhr) {
                        $btn.prop('disabled', false).html(
                            '<i class="bi bi-check-circle me-2"></i> Processar Inventário');
                        const response = xhr.responseJSON || {};
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro',
                            text: response.message || 'Erro ao processar inventário'
                        });
                    }
                });
            }
        });

        // Estilos para impressão do inventário e ajuste do modal
        const stylePrint = document.createElement('style');
        stylePrint.textContent = `
        .swal2-popup-inventario {
            max-width: 90rem !important;
        }
        .swal2-html-container-inventario {
            max-height: 70vh;
            overflow-y: auto;
        }
        @media print {
            body * {
                visibility: hidden;
            }
            #tabela-inventario-detalhes,
            #tabela-inventario-detalhes * {
                visibility: visible;
            }
            #tabela-inventario-detalhes {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
            }
            .swal2-popup {
                max-width: 100% !important;
                width: 100% !important;
            }
            .swal2-html-container {
                overflow: visible !important;
            }
        }
    `;
        document.head.appendChild(stylePrint);

        window.limparContagem = function limparContagem() {
            Swal.fire({
                title: 'Limpar todas as contagens?',
                text: 'Esta ação irá limpar todos os campos (quantidade contada, lote, validade, observações, etc).',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#dc3545',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Sim, limpar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    $('.qtd-fisica').val('');
                    $('.lote-campo').val('');
                    $('.numero-serie-campo').val('');
                    $('.fabricacao-campo').val('');
                    $('.validade-campo').val('');
                    $('span').filter(function() {
                        return this.className.indexOf('diferenca-') !== -1;
                    }).removeClass('bg-success bg-danger bg-warning').addClass('bg-secondary').text('-');
                    $('.produto-check').prop('checked', false);
                    $('#select-all').prop('checked', false);
                    $('#inventario-notes').val('');
                    $('#produtos-com-ajuste').text('0');
                }
            });
        };
    })(jQuery);
</script>

<?php
$content = ob_get_clean();
include __DIR__ . '/../layouts/app.php';
?>