<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-8">
        <h2><i class="bi bi-box-seam me-2"></i> Gestão de Estoque</h2>
        <p class="text-muted">Central de gerenciamento e controle do estoque</p>
    </div>
</div>

<!-- Estatísticas -->
<div class="row g-3 mb-4">
    <div class="col-lg-4 col-md-6">
        <div class="card stats-card stats-warning h-100" onclick="abrirModalEstoqueBaixo()" style="cursor:pointer;">
            <div class="card-body d-flex align-items-center justify-content-between">
                <div>
                    <span class="stats-label">Estoque Baixo</span>
                </div>
                <div class="stats-value">
                    <?= $produtosEstoqueBaixo ?? 0 ?>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-4 col-md-6">
        <div class="card stats-card stats-info h-100" onclick="abrirModalProximosVencer()" style="cursor:pointer;">
            <div class="card-body d-flex align-items-center justify-content-between">
                <div>
                    <span class="stats-label">Próximos a Vencer</span>
                    <small class="d-block text-muted-50">Até 30 dias</small>
                </div>
                <div class="stats-value">
                    <?= $produtosProximosVencer ?? 0 ?>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-4 col-md-6">
        <div class="card stats-card stats-danger h-100" onclick="abrirModalProdutosVencidos()" style="cursor:pointer;">
            <div class="card-body d-flex align-items-center justify-content-between">
                <div>
                    <span class="stats-label">Produtos Vencidos</span>
                    <small class="d-block text-muted-50">Remover do estoque</small>
                </div>
                <div class="stats-value">
                    <?= $produtosVencidos ?? 0 ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Cards de Módulos -->
<div class="row">
    <!-- Card Inventário -->
    <div class="col-lg-6 col-md-6 mb-4">
        <div class="card h-100 border-0 shadow-sm hover-card">
            <div class="card-body text-center p-4">
                <div class="mb-3">
                    <div class="icon-box bg-primary bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center"
                        style="width: 80px; height: 80px;">
                        <i class="bi bi-clipboard-check text-primary" style="font-size: 2.5rem;"></i>
                    </div>
                </div>
                <h4 class="card-title mb-3">Inventário</h4>
                <p class="card-text text-muted mb-4">
                    Realize contagens e ajustes de estoque. Gere inventários periódicos para manter seus dados
                    atualizados.
                </p>
                <a href="<?= url('/estoque/inventario') ?>" class="btn btn-primary btn-lg w-100">
                    <i class="bi bi-arrow-right-circle me-2"></i> Acessar Inventário
                </a>
            </div>
            <div class="card-footer bg-transparent border-0 text-center pb-3">
                <small class="text-muted">
                    <i class="bi bi-info-circle me-1"></i> Faça contagens físicas e ajustes
                </small>
            </div>
        </div>
    </div>

    <!-- Card Expedição -->
    <div class="col-lg-6 col-md-6 mb-4">
        <div class="card h-100 border-0 shadow-sm hover-card">
            <div class="card-body text-center p-4">
                <div class="mb-3">
                    <div class="icon-box bg-success bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center"
                        style="width: 80px; height: 80px;">
                        <i class="bi bi-truck text-success" style="font-size: 2.5rem;"></i>
                    </div>
                </div>
                <h4 class="card-title mb-3">Expedição</h4>
                <p class="card-text text-muted mb-4">
                    Gerencie a expedição de vendas finalizadas com NF-e emitida. Controle e organize as entregas
                    pendentes.
                </p>
                <button type="button" class="btn btn-success btn-lg w-100" onclick="abrirModalExpedicao()">
                    <i class="bi bi-box-arrow-up me-2"></i> Acessar Expedição
                </button>
            </div>
            <div class="card-footer bg-transparent border-0 text-center pb-3">
                <small class="text-muted">
                    <i class="bi bi-info-circle me-1"></i> Vendas finalizadas com NF-e
                </small>
            </div>
        </div>
    </div>

    <?php if (!empty($mostrarCardLotes)): ?>
        <!-- Card Lotes -->
        <div class="col-lg-6 col-md-6 mb-4">
            <div class="card h-100 border-0 shadow-sm hover-card">
                <div class="card-body text-center p-4">
                    <div class="mb-3">
                        <div class="icon-box bg-warning bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center"
                            style="width: 80px; height: 80px;">
                            <i class="bi bi-stack text-warning" style="font-size: 2.5rem;"></i>
                        </div>
                    </div>
                    <h4 class="card-title mb-3">Lotes</h4>
                    <p class="card-text text-muted mb-4">
                        Gerencie lotes de produtos, controle validade e rastreie movimentações por lote específico.
                    </p>
                    <a href="<?= url('/estoque/lotes') ?>" class="btn btn-warning btn-lg w-100">
                        <i class="bi bi-arrow-right-circle me-2"></i> Gerenciar Lotes
                    </a>
                </div>
                <div class="card-footer bg-transparent border-0 text-center pb-3">
                    <small class="text-muted">
                        <i class="bi bi-info-circle me-1"></i> Controle de validade e rastreamento
                    </small>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Card Transferência de Estoque -->
    <div class="col-lg-6 col-md-6 mb-4">
        <div class="card h-100 border-0 shadow-sm hover-card">
            <div class="card-body text-center p-4">
                <div class="mb-3">
                    <div class="icon-box bg-info bg-opacity-10 rounded-circle d-inline-flex align-items-center justify-content-center"
                        style="width: 80px; height: 80px;">
                        <i class="bi bi-arrow-left-right text-info" style="font-size: 2.5rem;"></i>
                    </div>
                </div>
                <h4 class="card-title mb-3">Transferência de Estoque</h4>
                <p class="card-text text-muted mb-4">
                    Transfira produtos entre diferentes locais de estoque. Mantenha o controle de movimentações entre
                    depósitos e filiais.
                </p>
                <a href="<?= url('/estoque/transferencia') ?>" class="btn btn-info btn-lg w-100">
                    <i class="bi bi-arrow-right-circle me-2"></i> Nova Transferência
                </a>
            </div>
            <div class="card-footer bg-transparent border-0 text-center pb-3">
                <small class="text-muted">
                    <i class="bi bi-info-circle me-1"></i> Movimentação entre locais de estoque
                </small>
            </div>
        </div>
    </div>
</div>

<style>
    .stats-card {
        border: 1px solid rgba(255, 255, 255, 0.08);
        background: #1f2937;
        color: #f8fafc;
        border-radius: 0.75rem;
        box-shadow: 0 12px 24px rgba(15, 23, 42, 0.12);
    }

    .modal-dark .modal-content {
        background: #111827;
        color: #f9fafb;
        border-radius: 0.75rem;
    }

    .modal-dark .modal-header {
        border-bottom-color: rgba(255, 255, 255, 0.1);
    }

    .modal-dark .modal-footer {
        border-top-color: rgba(255, 255, 255, 0.1);
    }

    .modal-dark .table-dark {
        background-color: #1f2937;
        color: #f9fafb;
    }

    .modal-dark .table-dark thead th {
        background-color: #111827;
        border-color: rgba(255, 255, 255, 0.1);
        font-weight: 600;
    }

    .modal-dark .table-dark tbody tr:hover {
        background-color: #374151;
    }

    .modal-dark .badge {
        font-size: 0.875rem;
        padding: 0.4em 0.65em;
    }

    .stats-card .stats-label {
        font-size: 0.85rem;
        text-transform: uppercase;
        letter-spacing: 0.08em;
        color: rgba(248, 250, 252, 0.7);
    }

    .stats-card .stats-value {
        font-size: 2.5rem;
        font-weight: 700;
    }

    .stats-card.stats-warning {
        border-left: 4px solid #f59e0b;
    }

    .stats-card.stats-info {
        border-left: 4px solid #3b82f6;
    }

    .stats-card.stats-danger {
        border-left: 4px solid #ef4444;
    }

    .text-muted-50 {
        color: rgba(248, 250, 252, 0.6) !important;
    }

    .hover-card {
        transition: all 0.3s ease;
        cursor: pointer;
    }

    .hover-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 .5rem 1.5rem rgba(0, 0, 0, .15) !important;
    }

    .hover-shadow {
        transition: all 0.3s ease;
    }

    .hover-shadow:hover {
        box-shadow: 0 .25rem .75rem rgba(0, 0, 0, .1) !important;
        transform: translateY(-2px);
    }

    .icon-box {
        transition: all 0.3s ease;
    }

    .hover-card:hover .icon-box {
        transform: scale(1.1);
    }

    .card {
        border-radius: 0.5rem;
    }

    @media (max-width: 768px) {
        .hover-card:hover {
            transform: none;
        }
    }
</style>

<!-- Modais -->
<!-- Estoque Baixo -->
<div class="modal fade modal-dark" id="modalEstoqueBaixo" tabindex="-1" aria-labelledby="modalEstoqueBaixoLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalEstoqueBaixoLabel"><i
                        class="bi bi-exclamation-triangle me-2"></i>Produtos com Estoque Baixo</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                    aria-label="Fechar"></button>
            </div>
            <div class="modal-body">
                <?php if (!empty($listaEstoqueBaixo)): ?>
                    <div class="alert alert-warning mb-3">
                        <i class="bi bi-exclamation-triangle me-2"></i>
                        <strong>Atenção!</strong> Estes produtos estão abaixo do estoque mínimo e precisam ser repostos.
                    </div>
                    <div class="table-responsive">
                        <table class="table table-dark table-striped mb-0">
                            <thead>
                                <tr>
                                    <th>Produto</th>
                                    <th>SKU</th>
                                    <th>Estoque Atual</th>
                                    <th>Estoque Mínimo</th>
                                    <th>Diferença</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($listaEstoqueBaixo as $produto):
                                    $estoqueAtual = (float) ($produto['estoque_atual'] ?? 0);
                                    $estoqueMinimo = (float) ($produto['min_stock'] ?? 0);
                                    $diferenca = $estoqueMinimo - $estoqueAtual;
                                    ?>
                                    <tr>
                                        <td><strong><?= htmlspecialchars($produto['name']) ?></strong></td>
                                        <td><?= htmlspecialchars($produto['sku'] ?? '-') ?></td>
                                        <td>
                                            <span
                                                class="badge bg-danger"><?= number_format($estoqueAtual, 2, ',', '.') ?></span>
                                        </td>
                                        <td><?= number_format($estoqueMinimo, 2, ',', '.') ?></td>
                                        <td>
                                            <span class="badge bg-warning text-dark">Falta
                                                <?= number_format($diferenca, 2, ',', '.') ?></span>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <p class="text-muted mb-0">Nenhum produto com estoque abaixo do mínimo.</p>
                <?php endif; ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>

<!-- Próximos a Vencer -->
<div class="modal fade modal-dark" id="modalProximosVencer" tabindex="-1" aria-labelledby="modalProximosVencerLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalProximosVencerLabel"><i class="bi bi-hourglass-split me-2"></i>Produtos
                    Próximos a Vencer</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                    aria-label="Fechar"></button>
            </div>
            <div class="modal-body">
                <?php if (!empty($listaProximosVencer)): ?>
                    <div class="table-responsive">
                        <table class="table table-dark table-striped mb-0">
                            <thead>
                                <tr>
                                    <th>Produto</th>
                                    <th>Lote</th>
                                    <th>Quantidade</th>
                                    <th>Validade</th>
                                    <th>Dias para Vencer</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                foreach ($listaProximosVencer as $item):
                                    $validade = !empty($item['validade']) ? new DateTime($item['validade']) : null;
                                    $hoje = new DateTime();
                                    $hoje->setTime(0, 0, 0);
                                    if ($validade) {
                                        $validade->setTime(0, 0, 0);
                                        $diff = $hoje->diff($validade);
                                        $diasParaVencer = $validade > $hoje ? $diff->days : 0;
                                    } else {
                                        $diasParaVencer = null;
                                    }
                                    ?>
                                    <tr>
                                        <td>
                                            <strong><?= htmlspecialchars($item['name']) ?></strong>
                                            <?php if (!empty($item['sku'])): ?>
                                                <br><small class="text-muted">SKU: <?= htmlspecialchars($item['sku']) ?></small>
                                            <?php endif; ?>
                                        </td>
                                        <td><?= htmlspecialchars($item['lote'] ?? '-') ?></td>
                                        <td><?= number_format($item['quantidade_lote'] ?? 0, 2, ',', '.') ?>
                                            <?= htmlspecialchars($item['unit'] ?? 'UN') ?></td>
                                        <td>
                                            <?= $validade ? $validade->format('d/m/Y') : '-' ?>
                                        </td>
                                        <td>
                                            <?php if ($diasParaVencer !== null):
                                                if ($diasParaVencer <= 7): ?>
                                                    <span class="badge bg-danger"><?= $diasParaVencer ?> dias</span>
                                                <?php elseif ($diasParaVencer <= 15): ?>
                                                    <span class="badge bg-warning text-dark"><?= $diasParaVencer ?> dias</span>
                                                <?php else: ?>
                                                    <span class="badge bg-info"><?= $diasParaVencer ?> dias</span>
                                                <?php endif;
                                            else: ?>
                                                -
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <p class="text-muted mb-0">Nenhum produto com validade próxima.</p>
                <?php endif; ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>

<!-- Produtos Vencidos -->
<div class="modal fade modal-dark" id="modalProdutosVencidos" tabindex="-1" aria-labelledby="modalProdutosVencidosLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalProdutosVencidosLabel"><i class="bi bi-x-circle me-2"></i>Produtos
                    Vencidos</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                    aria-label="Fechar"></button>
            </div>
            <div class="modal-body">
                <?php if (!empty($listaVencidos)): ?>
                    <div class="alert alert-danger mb-3">
                        <i class="bi bi-exclamation-triangle me-2"></i>
                        <strong>Atenção!</strong> Estes produtos estão com validade expirada e devem ser removidos do
                        estoque.
                    </div>
                    <div class="table-responsive">
                        <table class="table table-dark table-striped mb-0">
                            <thead>
                                <tr>
                                    <th>Produto</th>
                                    <th>Lote</th>
                                    <th>Quantidade</th>
                                    <th>Validade Expirada</th>
                                    <th>Dias Vencidos</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                foreach ($listaVencidos as $item):
                                    $validade = !empty($item['validade']) ? new DateTime($item['validade']) : null;
                                    $hoje = new DateTime();
                                    $hoje->setTime(0, 0, 0);
                                    if ($validade) {
                                        $validade->setTime(0, 0, 0);
                                        $diff = $hoje->diff($validade);
                                        $diasVencidos = $validade < $hoje ? $diff->days : 0;
                                    } else {
                                        $diasVencidos = null;
                                    }
                                    ?>
                                    <tr>
                                        <td>
                                            <strong><?= htmlspecialchars($item['name']) ?></strong>
                                            <?php if (!empty($item['sku'])): ?>
                                                <br><small class="text-muted">SKU: <?= htmlspecialchars($item['sku']) ?></small>
                                            <?php endif; ?>
                                        </td>
                                        <td><?= htmlspecialchars($item['lote'] ?? '-') ?></td>
                                        <td><?= number_format($item['quantidade_lote'] ?? 0, 2, ',', '.') ?>
                                            <?= htmlspecialchars($item['unit'] ?? 'UN') ?></td>
                                        <td>
                                            <?= $validade ? $validade->format('d/m/Y') : '-' ?>
                                        </td>
                                        <td>
                                            <?php if ($diasVencidos !== null): ?>
                                                <span class="badge bg-danger"><?= $diasVencidos ?> dias</span>
                                            <?php else: ?>
                                                -
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <p class="text-muted mb-0">Nenhum produto vencido encontrado.</p>
                <?php endif; ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Expedição -->
<div class="modal fade modal-dark" id="modalExpedicao" tabindex="-1" aria-labelledby="modalExpedicaoLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-xl" style="width: 98%; max-width: 98%; height: 98vh; margin: 1vh auto;">
        <div class="modal-content" style="height: 100%; display: flex; flex-direction: column;">
            <div class="modal-header">
                <h5 class="modal-title" id="modalExpedicaoLabel">
                    <i class="bi bi-truck me-2"></i>Expedição
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                    aria-label="Fechar"></button>
            </div>
            <div class="modal-body" style="flex: 1; overflow-y: auto;">
                <div class="table-responsive" style="height: 100%;">
                    <table class="table table-dark table-striped table-hover mb-0">
                        <thead class="table-dark sticky-top">
                            <tr>
                                <th>ID Venda</th>
                                <th>Cliente</th>
                                <th>Data</th>
                                <th>Valor Total</th>
                                <th>NF-e</th>
                                <th>Operações</th>
                            </tr>
                        </thead>
                        <tbody id="tbody-vendas-expedicao">
                            <tr>
                                <td colspan="6" class="text-center text-muted">
                                    <div class="spinner-border text-primary" role="status">
                                        <span class="visually-hidden">Carregando...</span>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
                <button type="button" class="btn btn-primary" onclick="carregarVendasExpedicao()">
                    <i class="bi bi-arrow-clockwise me-1"></i> Atualizar
                </button>
            </div>
        </div>
    </div>
</div>

<script>
    function abrirModalEstoqueBaixo() {
        const modal = new bootstrap.Modal(document.getElementById('modalEstoqueBaixo'));
        modal.show();
    }

    function abrirModalProximosVencer() {
        const modal = new bootstrap.Modal(document.getElementById('modalProximosVencer'));
        modal.show();
    }

    function abrirModalProdutosVencidos() {
        const modal = new bootstrap.Modal(document.getElementById('modalProdutosVencidos'));
        modal.show();
    }

    function abrirModalExpedicao() {
        const modal = new bootstrap.Modal(document.getElementById('modalExpedicao'));
        modal.show();
        carregarVendasExpedicao();
    }

    function carregarVendasExpedicao() {
        const tbody = document.getElementById('tbody-vendas-expedicao');
        if (!tbody) return;

        tbody.innerHTML = '<tr><td colspan="6" class="text-center"><div class="spinner-border text-primary" role="status"></div></td></tr>';

        fetch(appUrl('/estoque/expedicao/buscar-vendas'), {
            method: 'GET',
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            console.log('Resposta completa:', data);

            if (!data.success) {
                tbody.innerHTML = '<tr><td colspan="6" class="text-center text-danger">' + (data.message || 'Erro ao carregar vendas') + '</td></tr>';
                return;
            }

            const vendas = data.data?.vendas || data.vendas || [];

            if (vendas.length === 0) {
                tbody.innerHTML = '<tr><td colspan="6" class="text-center text-muted">Nenhuma venda encontrada.</td></tr>';
                return;
            }

            tbody.innerHTML = vendas.map((venda, index) => {
                const dataVenda = venda.sale_date ? new Date(venda.sale_date).toLocaleDateString('pt-BR') : '-';
                const valorTotal = parseFloat(venda.total || 0).toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' });
                const numeroNfe = venda.numero_nfe || '-';
                const rowId = 'row-venda-' + venda.id + '-' + index;

                return `
                    <tr id="${rowId}">
                        <td>#${venda.id || '-'}</td>
                        <td>${venda.customer_name || '-'}</td>
                        <td>${dataVenda}</td>
                        <td>${valorTotal}</td>
                        <td>${numeroNfe}</td>
                        <td>
                            <div class="btn-group" role="group">
                                <button type="button" class="btn btn-sm btn-outline-info" title="Romaneio de Separação" onclick="gerarRomaneio(${venda.id})">
                                    <i class="bi bi-file-earmark-text"></i>
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-warning" title="Conferência" data-venda-id="${venda.id}" data-sale-number="${String(venda.sale_number || '').replace(/"/g, '&quot;')}" onclick="abrirConferenciaFromButton(this)">
                                    <i class="bi bi-check-square"></i>
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-success" title="Reimprimir NF-e" onclick="reimprimirNfe(${venda.id})">
                                    <i class="bi bi-printer"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                `;
            }).join('');
        })
        .catch(error => {
            console.error('Erro:', error);
            tbody.innerHTML = '<tr><td colspan="6" class="text-center text-danger">Erro ao carregar vendas: ' + error.message + '</td></tr>';
        });
    }

    function gerarRomaneio(vendaId) {
        // Abre o romaneio de separação em nova aba (mesma rotina do módulo de vendas)
        window.open(appUrl('/vendas/romaneio-separacao?id=' + vendaId), '_blank');
    }

    function abrirConferenciaFromButton(button) {
        const vendaId = button.getAttribute('data-venda-id');
        const numeroVenda = button.getAttribute('data-sale-number');
        abrirConferencia(vendaId, numeroVenda);
    }

    async function abrirConferencia(vendaId, numeroVenda) {
        // Inicia a conferência diretamente com o número da venda carregado
        if (!numeroVenda) {
            Swal.fire({
                icon: 'error',
                title: 'Erro',
                text: 'Número da venda não informado',
                confirmButtonText: 'OK'
            });
            return;
        }

        // Mostrar loading
        Swal.fire({
            title: 'Carregando conferência...',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        try {
            const response = await fetch(appUrl(`/vendas/buscar-conferencia?numero=${encodeURIComponent(numeroVenda)}`));
            const result = await response.json();

            if (!result.success || !result.venda) {
                Swal.fire({
                    icon: 'error',
                    title: 'Venda não encontrada',
                    text: result.message || 'Não foi possível encontrar a venda com o número informado.',
                    confirmButtonText: 'OK'
                });
                return;
            }

            const venda = result.venda;
            const itens = result.itens || [];

            // Formatar valor
            const formatCurrency = (value) => {
                return new Intl.NumberFormat('pt-BR', {
                    style: 'currency',
                    currency: 'BRL'
                }).format(value || 0);
            };

            // Formatar data
            const formatDate = (dateString) => {
                if (!dateString) return '-';
                const date = new Date(dateString);
                return date.toLocaleDateString('pt-BR') + ' ' + date.toLocaleTimeString('pt-BR', { hour: '2-digit', minute: '2-digit' });
            };

            // Armazenar dados da venda globalmente para uso na conferência
            window.vendaConferencia = venda;
            window.itensConferencia = itens;
            window.itensConferidos = {}; // Armazenar itens conferidos

            // Verificar itens já conferidos
            const itensJaConferidos = itens.filter(item => item.item_conferido === 'Sim');
            itensJaConferidos.forEach(item => {
                window.itensConferidos[item.id] = true;
            });

            // Criar HTML da tabela de itens conferidos
            let itensConferidosHtml = '';
            if (itensJaConferidos.length > 0) {
                itensConferidosHtml = `
                    <div class="mt-3">
                        <h6 class="mb-2 text-success"><strong>Itens Conferidos:</strong></h6>
                        <div class="table-responsive" style="max-height: 200px; overflow-y: auto;">
                            <table class="table table-sm table-bordered table-success mb-0" id="tabela_itens_conferidos">
                                <thead class="table-light" style="position: sticky; top: 0;">
                                    <tr>
                                        <th>SKU</th>
                                        <th>Produto</th>
                                        <th class="text-center" width="80">Qtd</th>
                                        <th class="text-center" width="100">Lote</th>
                                        <th class="text-center" width="100">Validade</th>
                                    </tr>
                                </thead>
                                <tbody id="tbody_itens_conferidos">
                                    ${itensJaConferidos.map(item => {
                                        const validadeFormatada = item.validade ?
                                            new Date(item.validade).toLocaleDateString('pt-BR') : '-';
                                        return `
                                            <tr data-item-id="${item.id}">
                                                <td>${item.product_sku || '-'}</td>
                                                <td><strong>${item.product_name || '-'}</strong></td>
                                                <td class="text-center">${parseFloat(item.quantity || 0).toFixed(3).replace('.', ',')}</td>
                                                <td class="text-center">${item.lote || '-'}</td>
                                                <td class="text-center">${validadeFormatada}</td>
                                            </tr>
                                        `;
                                    }).join('')}
                                </tbody>
                            </table>
                        </div>
                    </div>
                `;
            }

            // Mostrar modal com dados da venda
            Swal.fire({
                title: `<i class="bi bi-clipboard-check text-info"></i> Venda ${venda.sale_number}`,
                html: `
                    <div class="text-start">
                        <div class="alert alert-info mb-3">
                            <div class="row">
                                <div class="col-md-6">
                                    <strong>Cliente:</strong><br>
                                    ${venda.customer_name || 'Consumidor Final'}<br>
                                    ${venda.customer_document ? `<small>${venda.customer_document}</small>` : ''}
                                </div>
                                <div class="col-md-6 text-end">
                                    <strong>Data:</strong><br>
                                    ${formatDate(venda.sale_date || venda.created_at)}<br>
                                    <strong>Total:</strong> ${formatCurrency(venda.total || 0)}
                                </div>
                            </div>
                        </div>

                        <!-- Campo de Busca de Código de Barras -->
                        <div class="mb-3 p-3 bg-light border rounded">
                            <label class="form-label fw-bold mb-2">
                                <i class="bi bi-upc-scan text-primary"></i> Código de Barras:
                            </label>
                            <input type="text"
                                   class="form-control form-control-lg"
                                   id="codigo_barras_conferencia"
                                   placeholder="Leia ou digite o código de barras e pressione Enter"
                                   autocomplete="off">
                            <div id="mensagem_conferencia" class="mt-2" style="min-height: 20px; font-size: 0.875rem;"></div>
                        </div>

                        ${itensConferidosHtml}
                    </div>
                `,
                width: '900px',
                showCancelButton: true,
                confirmButtonText: '<i class="bi bi-eye me-2"></i>Visualizar Completo',
                cancelButtonText: '<i class="bi bi-x-circle me-2"></i>Fechar',
                confirmButtonColor: '#0dcaf0',
                cancelButtonColor: '#6c757d',
                didOpen: () => {
                    // Focar no campo de código de barras
                    const codigoBarrasInput = document.getElementById('codigo_barras_conferencia');
                    if (codigoBarrasInput) {
                        codigoBarrasInput.focus();
                        codigoBarrasInput.addEventListener('keypress', function (e) {
                            if (e.key === 'Enter') {
                                e.preventDefault();
                                const codigoBarras = this.value.trim();
                                if (!codigoBarras) {
                                    mostrarMensagemConferencia('Por favor, informe o código de barras', 'error');
                                    return;
                                }
                                conferirItemModal(venda.id, codigoBarras);
                            }
                        });
                    }
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = appUrl('/vendas/visualizar?id=' + venda.id);
                }
            });

        } catch (error) {
            console.error('Erro ao buscar venda:', error);
            Swal.fire({
                icon: 'error',
                title: 'Erro',
                text: 'Ocorreu um erro ao buscar a venda. Tente novamente.',
                confirmButtonText: 'OK'
            });
        }
    }

    function mostrarMensagemConferencia(texto, tipo = 'info') {
        const mensagemEl = document.getElementById('mensagem_conferencia');
        if (!mensagemEl) return;

        const cor = tipo === 'error' ? '#dc3545' : tipo === 'success' ? '#28a745' : '#0dcaf0';
        mensagemEl.innerHTML = `<span style="color: ${cor}; font-weight: 600;">${texto}</span>`;
        setTimeout(() => {
            mensagemEl.innerHTML = '';
        }, 3000);
    }

    function conferirItemModal(vendaId, codigoBarras) {
        fetch(appUrl('/vendas/buscar-item-conferencia'), {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: new URLSearchParams({
                venda_id: vendaId,
                codigo_barras: codigoBarras
            })
        })
        .then(response => response.json())
        .then(result => {
            if (result.success && result.item) {
                abrirModalQuantidadeLote(result.item, vendaId, codigoBarras);
            } else {
                mostrarMensagemConferencia(result.message || 'Erro ao buscar item', 'error');
            }
        })
        .catch(error => {
            console.error('Erro:', error);
            mostrarMensagemConferencia('Erro ao processar busca', 'error');
        });
    }

    function abrirModalQuantidadeLote(item, vendaId, codigoBarras) {
        const quantidadePedido = parseFloat(item.quantity || 0);
        const lotePedido = (item.lote || '').trim();
        const produtoNome = item.product_name || item.product_sku || 'Produto';

        Swal.fire({
            title: '<i class="bi bi-clipboard-check text-primary"></i> Conferir Item',
            html: `
                <div class="text-start">
                    <div class="mb-3">
                        <label class="form-label fw-bold">Produto:</label>
                        <p class="form-control-plaintext">${produtoNome}</p>
                    </div>
                    <div class="mb-3">
                        <label for="quantidade_conferencia" class="form-label fw-bold">
                            Quantidade (Pedido: ${quantidadePedido.toFixed(3).replace('.', ',')}):
                        </label>
                        <input type="number"
                               step="0.001"
                               class="form-control"
                               id="quantidade_conferencia"
                               value="${quantidadePedido.toFixed(3)}"
                               autofocus>
                    </div>
                    ${lotePedido ? `
                    <div class="mb-3">
                        <label for="lote_conferencia" class="form-label fw-bold">
                            Lote (Pedido: ${lotePedido}):
                        </label>
                        <input type="text"
                               class="form-control"
                               id="lote_conferencia"
                               value="${lotePedido}">
                    </div>
                    ` : ''}
                </div>
            `,
            width: '500px',
            showCancelButton: true,
            confirmButtonText: '<i class="bi bi-check-circle me-2"></i>Conferir',
            cancelButtonText: '<i class="bi bi-x-circle me-2"></i>Cancelar',
            confirmButtonColor: '#28a745',
            cancelButtonColor: '#6c757d',
            didOpen: () => {
                const quantidadeInput = document.getElementById('quantidade_conferencia');
                if (quantidadeInput) {
                    quantidadeInput.focus();
                    quantidadeInput.select();
                }
            },
            preConfirm: () => {
                const quantidadeInput = document.getElementById('quantidade_conferencia');
                const quantidade = parseFloat(quantidadeInput.value) || 0;
                const loteInput = document.getElementById('lote_conferencia');
                const lote = lotePedido && loteInput ? loteInput.value.trim() : '';

                if (quantidade <= 0) {
                    Swal.showValidationMessage('A quantidade deve ser maior que zero');
                    return false;
                }

                return {
                    quantidade: quantidade,
                    lote: lote
                };
            }
        }).then((result) => {
            if (result.isConfirmed && result.value) {
                const quantidade = result.value.quantidade;
                const lote = result.value.lote;

                confirmarConferenciaItem(vendaId, item.id, quantidade, lote, codigoBarras);
            }
        });
    }

    function confirmarConferenciaItem(vendaId, itemId, quantidade, lote, codigoBarras) {
        fetch(appUrl('/vendas/conferir-item-romaneio'), {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: new URLSearchParams({
                venda_id: vendaId,
                item_id: itemId,
                quantidade: quantidade,
                lote: lote,
                codigo_barras: codigoBarras
            })
        })
        .then(response => response.json())
        .then(result => {
            if (result.success) {
                mostrarMensagemConferencia('Item conferido com sucesso!', 'success');
                const codigoBarrasInput = document.getElementById('codigo_barras_conferencia');
                if (codigoBarrasInput) {
                    codigoBarrasInput.value = '';
                    codigoBarrasInput.focus();
                }
                // Atualizar lista de itens conferidos se necessário
                if (result.item_conferido) {
                    window.itensConferidos[itemId] = true;
                }
            } else {
                mostrarMensagemConferencia(result.message || 'Erro ao conferir item', 'error');
            }
        })
        .catch(error => {
            console.error('Erro:', error);
            mostrarMensagemConferencia('Erro ao processar conferência', 'error');
        });
    }

    function reimprimirNfe(vendaId) {
        // Reimpressão de NF-e (mesma rotina do módulo de vendas)
        Swal.fire({
            title: 'Buscando DANFE...',
            text: 'Aguarde enquanto carregamos o PDF',
            allowOutsideClick: false,
            didOpen: () => Swal.showLoading()
        });

        $.ajax({
            url: appUrl('/vendas/reimprimir-nfe?id=' + vendaId),
            type: 'GET',
            dataType: 'json',
            success: function (response) {
                Swal.close();

                if (response.success && response.data) {
                    let pdfUrl = response.data.pdf_path || response.data.pdf_path_alternativo;

                    if (pdfUrl) {
                        if (pdfUrl.startsWith('/')) {
                            pdfUrl = window.location.origin + pdfUrl;
                        }

                        const link = document.createElement('a');
                        link.href = pdfUrl;
                        link.target = '_blank';
                        link.rel = 'noopener noreferrer';
                        document.body.appendChild(link);
                        link.click();
                        document.body.removeChild(link);

                        Swal.fire({
                            icon: 'success',
                            title: 'DANFE Aberto',
                            text: 'O DANFE foi aberto em uma nova aba.',
                            timer: 2000,
                            showConfirmButton: false
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro',
                            text: 'Caminho do PDF não encontrado na resposta'
                        });
                    }
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: response.message || 'PDF não encontrado'
                    });
                }
            },
            error: function (xhr) {
                Swal.close();
                const response = xhr.responseJSON;
                Swal.fire({
                    icon: 'error',
                    title: 'Erro ao buscar DANFE',
                    text: response?.message || 'Não foi possível carregar o PDF da NF-e'
                });
            }
        });
    }
</script>

<?php
$content = ob_get_clean();
$activeMenu = 'estoque';
include ROOT_PATH . '/views/layouts/app.php';
?>