<?php
ob_start();
$isDev = ($_ENV['APP_ENV'] ?? 'production') !== 'production';
$statusCode = $statusCode ?? 400;
?>

<div class="container my-5">
    <div class="row justify-content-center">
        <div class="col-md-8 col-lg-6 text-center">
            <div class="error-page">
                <div class="error-code">
                    <h1 class="display-1 fw-bold text-danger"><?= $statusCode ?></h1>
                </div>
                <div class="error-message mt-4">
                    <h2 class="h4 mb-3">Erro</h2>
                    <p class="text-muted mb-4">
                        <?= htmlspecialchars($message ?? 'Ocorreu um erro inesperado') ?>
                    </p>

                    <?php if ($isDev && !empty($message)): ?>
                    <div class="alert alert-info text-start mt-4">
                        <strong>Detalhes do erro (desenvolvimento):</strong>
                        <pre class="mb-0 mt-2" style="font-size: 0.85rem;"><?= htmlspecialchars($message) ?></pre>
                    </div>
                    <?php endif; ?>

                    <div class="error-actions mt-4">
                        <a href="<?= url('/dashboard') ?>" class="btn btn-primary me-2">
                            <i class="bi bi-house-door me-2"></i> Ir para o Dashboard
                        </a>
                        <button onclick="history.back()" class="btn btn-outline-secondary">
                            <i class="bi bi-arrow-left me-2"></i> Voltar
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.error-page {
    padding: 2rem 0;
}

.error-code h1 {
    font-size: 8rem;
    line-height: 1;
    margin: 0;
    background: linear-gradient(135deg, #dc3545 0%, #a02a37 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

@media (max-width: 768px) {
    .error-code h1 {
        font-size: 5rem;
    }
}
</style>

<?php
$content = ob_get_clean();
$activeMenu = null;
include ROOT_PATH . '/views/layouts/app.php';
?>

