<?php
$activeMenu = 'entradas';
include ROOT_PATH . '/views/layouts/app.php';
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="<?= url('/entradas') ?>">Contas a Receber</a></li>
                        <li class="breadcrumb-item active">Visualizar</li>
                    </ol>
                </div>
                <h4 class="page-title">
                    <i class="bi bi-eye me-2"></i> Visualizar Conta a Receber
                </h4>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <i class="bi bi-receipt me-2"></i> Informações da Conta
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <strong>ID:</strong> #<?= $conta['id'] ?>
                        </div>
                        <div class="col-md-6">
                            <strong>Número do Documento:</strong> <?= htmlspecialchars($conta['numero'] ?? '-') ?>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-12">
                            <strong>Descrição:</strong><br>
                            <?= htmlspecialchars($conta['description'] ?? '-') ?>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <strong>Cliente:</strong><br>
                            <?= htmlspecialchars($cliente['name'] ?? 'Não identificado') ?>
                        </div>
                        <div class="col-md-6">
                            <strong>CPF/CNPJ:</strong><br>
                            <?= htmlspecialchars($cliente['document'] ?? '-') ?>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-4">
                            <strong>Valor Total:</strong><br>
                            <span class="h5 text-primary">R$ <?= number_format($conta['amount'], 2, ',', '.') ?></span>
                        </div>
                        <div class="col-md-4">
                            <strong>Valor Pago:</strong><br>
                            <span class="h5 text-success">R$ <?= number_format($conta['amount_paid'] ?? $conta['amount_received'] ?? 0, 2, ',', '.') ?></span>
                        </div>
                        <div class="col-md-4">
                            <strong>Valor Restante:</strong><br>
                            <span class="h5 text-warning">R$ <?= number_format($conta['amount_remaining'] ?? 0, 2, ',', '.') ?></span>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <strong>Data de Vencimento:</strong><br>
                            <?= date('d/m/Y', strtotime($conta['due_date'])) ?>
                        </div>
                        <div class="col-md-6">
                            <strong>Data de Pagamento:</strong><br>
                            <?= !empty($conta['payment_date']) ? date('d/m/Y', strtotime($conta['payment_date'])) : '-' ?>
                        </div>
                    </div>

                    <?php if (!empty($conta['notes'])): ?>
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <strong>Observações:</strong><br>
                            <?= nl2br(htmlspecialchars($conta['notes'])) ?>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <i class="bi bi-gear me-2"></i> Ações
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="<?= url('/entradas/editar?id=' . $conta['id']) ?>" class="btn btn-primary">
                            <i class="bi bi-pencil me-2"></i> Editar
                        </a>
                        <a href="<?= url('/entradas/recibo?id=' . $conta['id']) ?>" class="btn btn-secondary" target="_blank">
                            <i class="bi bi-receipt me-2"></i> Gerar Recibo
                        </a>
                        <a href="<?= url('/entradas/duplicata?id=' . $conta['id']) ?>" class="btn btn-warning" target="_blank">
                            <i class="bi bi-file-earmark-text me-2"></i> Gerar Duplicata
                        </a>
                        <a href="<?= url('/entradas') ?>" class="btn btn-outline-secondary">
                            <i class="bi bi-arrow-left me-2"></i> Voltar
                        </a>
                    </div>
                </div>
            </div>

            <div class="card mt-3">
                <div class="card-header">
                    <i class="bi bi-clock-history me-2"></i> Histórico
                </div>
                <div class="card-body">
                    <p class="small text-muted mb-2">
                        <strong>Criado em:</strong><br>
                        <?= date('d/m/Y H:i', strtotime($conta['created_at'])) ?>
                    </p>
                    <?php if (!empty($conta['updated_at']) && $conta['updated_at'] != $conta['created_at']): ?>
                    <p class="small text-muted">
                        <strong>Atualizado em:</strong><br>
                        <?= date('d/m/Y H:i', strtotime($conta['updated_at'])) ?>
                    </p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Seção de Anexos -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <i class="bi bi-paperclip me-2"></i> Anexos
                </div>
                <div class="card-body">
                    <!-- Upload de Anexo -->
                    <div class="mb-4">
                        <form id="formUploadAnexo" enctype="multipart/form-data">
                            <input type="hidden" name="conta_id" value="<?= $conta['id'] ?>">
                            <div class="row">
                                <div class="col-md-6">
                                    <label for="arquivo_anexo" class="form-label">Selecionar Arquivo</label>
                                    <input type="file" class="form-control" id="arquivo_anexo" name="arquivo"
                                        accept=".jpg,.jpeg,.png,.pdf">
                                    <small class="text-muted">Formatos permitidos: JPG, JPEG, PNG e PDF (máx. 10MB)</small>
                                </div>
                                <div class="col-md-4">
                                    <label for="descricao_anexo" class="form-label">Descrição (opcional)</label>
                                    <input type="text" class="form-control" id="descricao_anexo" name="descricao"
                                        placeholder="Ex: Nota fiscal, comprovante...">
                                </div>
                                <div class="col-md-2 d-flex align-items-end">
                                    <button type="submit" class="btn btn-primary w-100">
                                        <i class="bi bi-upload me-1"></i> Enviar
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>

                    <!-- Lista de Anexos -->
                    <div id="listaAnexos">
                        <div class="text-center text-muted py-3">
                            <i class="bi bi-hourglass-split"></i> Carregando anexos...
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    const contaId = <?= $conta['id'] ?>;

    // Carregar anexos ao abrir a página
    carregarAnexos(contaId);

    // Upload de anexo
    $('#formUploadAnexo').on('submit', function(e) {
        e.preventDefault();

        const formData = new FormData(this);
        const descricao = $('#descricao_anexo').val();
        formData.append('descricao', descricao);

        $.ajax({
            url: appUrl('/entradas/anexos/upload'),
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function() {
                $('#formUploadAnexo button[type="submit"]').prop('disabled', true).html('<i class="bi bi-hourglass-split"></i> Enviando...');
            },
            success: function(response) {
                $('#formUploadAnexo button[type="submit"]').prop('disabled', false).html('<i class="bi bi-upload me-1"></i> Enviar');

                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Sucesso!',
                        text: response.message,
                        timer: 1500,
                        showConfirmButton: false
                    });

                    // Limpar formulário
                    $('#formUploadAnexo')[0].reset();

                    // Recarregar lista
                    carregarAnexos(contaId);
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: response.message
                    });
                }
            },
            error: function() {
                $('#formUploadAnexo button[type="submit"]').prop('disabled', false).html('<i class="bi bi-upload me-1"></i> Enviar');
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: 'Erro ao fazer upload do anexo'
                });
            }
        });
    });
});

function carregarAnexos(contaId) {
    $.ajax({
        url: appUrl('/entradas/anexos/listar'),
        type: 'GET',
        data: { conta_id: contaId },
        success: function(response) {
            if (response.success) {
                exibirAnexos(response.data.anexos || []);
            }
        },
        error: function() {
            $('#listaAnexos').html('<div class="alert alert-danger">Erro ao carregar anexos</div>');
        }
    });
}

function exibirAnexos(anexos) {
    if (anexos.length === 0) {
        $('#listaAnexos').html('<div class="text-center text-muted py-3"><i class="bi bi-inbox"></i> Nenhum anexo cadastrado</div>');
        return;
    }

    let html = '<div class="table-responsive"><table class="table table-hover">';
    html += '<thead><tr><th>Arquivo</th><th>Descrição</th><th>Tamanho</th><th>Enviado por</th><th>Data</th><th width="120">Ações</th></tr></thead>';
    html += '<tbody>';

    anexos.forEach(function(anexo) {
        const tamanho = formatarTamanho(anexo.tamanho);
        const data = new Date(anexo.created_at).toLocaleString('pt-BR');
        const icone = obterIconeArquivo(anexo.nome_original);

        html += '<tr>';
        html += '<td><i class="bi ' + icone + ' me-2"></i>' + anexo.nome_original + '</td>';
        html += '<td>' + (anexo.descricao || '<span class="text-muted">-</span>') + '</td>';
        html += '<td>' + tamanho + '</td>';
        html += '<td>' + (anexo.usuario_nome || '-') + '</td>';
        html += '<td>' + data + '</td>';
        html += '<td>';
        html += '<a href="' + appUrl('/entradas/anexos/download?id=' + anexo.id) + '" class="btn btn-sm btn-outline-primary me-1" title="Download">';
        html += '<i class="bi bi-download"></i></a>';
        html += '<button onclick="deletarAnexo(' + anexo.id + ', ' + anexo.conta_id + ')" class="btn btn-sm btn-outline-danger" title="Excluir">';
        html += '<i class="bi bi-trash"></i></button>';
        html += '</td>';
        html += '</tr>';
    });

    html += '</tbody></table></div>';
    $('#listaAnexos').html(html);
}

function deletarAnexo(anexoId, contaId) {
    Swal.fire({
        title: 'Confirmar Exclusão',
        text: 'Tem certeza que deseja excluir este anexo?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Sim, excluir',
        cancelButtonText: 'Cancelar',
        confirmButtonColor: '#dc3545'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: appUrl('/entradas/anexos/deletar'),
                type: 'POST',
                data: { anexo_id: anexoId },
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Sucesso!',
                            text: response.message,
                            timer: 1500,
                            showConfirmButton: false
                        });
                        carregarAnexos(contaId);
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro',
                            text: response.message
                        });
                    }
                },
                error: function() {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: 'Erro ao excluir anexo'
                    });
                }
            });
        }
    });
}

function formatarTamanho(bytes) {
    if (bytes === 0) return '0 Bytes';
    const k = 1024;
    const sizes = ['Bytes', 'KB', 'MB', 'GB'];
    const i = Math.floor(Math.log(bytes) / Math.log(k));
    return Math.round(bytes / Math.pow(k, i) * 100) / 100 + ' ' + sizes[i];
}

function obterIconeArquivo(nomeArquivo) {
    const extensao = nomeArquivo.split('.').pop().toLowerCase();
    const icones = {
        'pdf': 'bi-file-pdf',
        'jpg': 'bi-file-image',
        'jpeg': 'bi-file-image',
        'png': 'bi-file-image'
    };
    return icones[extensao] || 'bi-file';
}
</script>

