<?php
/**
 * Recibo de Pagamento - PDF usando mPDF
 */

// Preparar dados
$nomeEmpresa = $empresa['razao_social'] ?? $empresa['name'] ?? 'EMPRESA';
$cnpjEmpresa = $empresa['cnpj'] ?? $empresa['document'] ?? '';
$enderecoEmpresa = ($empresa['endereco'] ?? $empresa['address'] ?? '') . ', ' . ($empresa['numero'] ?? '');
$cidadeEmpresa = ($empresa['cidade'] ?? $empresa['city'] ?? '') . ' - ' . ($empresa['uf'] ?? $empresa['state'] ?? '');
$telefoneEmpresa = $empresa['telefone'] ?? $empresa['phone'] ?? '';

$nomeCliente = $cliente['name'] ?? 'Cliente não identificado';
$documentoCliente = $cliente['document'] ?? 'Não informado';

$valorTotal = number_format($conta['amount'], 2, ',', '.');
$dataEmissao = date('d/m/Y');
$cidade = $empresa['cidade'] ?? $empresa['city'] ?? 'São Paulo';

// Valor por extenso
function valorPorExtenso($valor)
{
    $valor = number_format($valor, 2, '.', '');
    list($inteiro, $centavos) = explode('.', $valor);

    $extenso = numeroPorExtenso((int) $inteiro);

    if ($inteiro == 1) {
        $extenso .= ' real';
    } else {
        $extenso .= ' reais';
    }

    if ($centavos > 0) {
        $extenso .= ' e ' . numeroPorExtenso((int) $centavos);
        if ($centavos == 1) {
            $extenso .= ' centavo';
        } else {
            $extenso .= ' centavos';
        }
    }

    return $extenso;
}

function numeroPorExtenso($numero)
{
    $unidades = ['', 'um', 'dois', 'três', 'quatro', 'cinco', 'seis', 'sete', 'oito', 'nove'];
    $dez = ['dez', 'onze', 'doze', 'treze', 'quatorze', 'quinze', 'dezesseis', 'dezessete', 'dezoito', 'dezenove'];
    $dezenas = ['', '', 'vinte', 'trinta', 'quarenta', 'cinquenta', 'sessenta', 'setenta', 'oitenta', 'noventa'];
    $centenas = ['', 'cento', 'duzentos', 'trezentos', 'quatrocentos', 'quinhentos', 'seiscentos', 'setecentos', 'oitocentos', 'novecentos'];

    if ($numero == 0)
        return 'zero';
    if ($numero == 100)
        return 'cem';

    $resultado = '';

    // Milhares
    if ($numero >= 1000) {
        $milhares = floor($numero / 1000);
        if ($milhares == 1) {
            $resultado .= 'mil';
        } else {
            $resultado .= numeroPorExtenso($milhares) . ' mil';
        }
        $numero %= 1000;
        if ($numero > 0)
            $resultado .= ' ';
    }

    // Centenas
    if ($numero >= 100) {
        $resultado .= $centenas[floor($numero / 100)];
        $numero %= 100;
        if ($numero > 0)
            $resultado .= ' e ';
    }

    // Dezenas
    if ($numero >= 20) {
        $resultado .= $dezenas[floor($numero / 10)];
        $numero %= 10;
        if ($numero > 0)
            $resultado .= ' e ';
    } elseif ($numero >= 10) {
        $resultado .= $dez[$numero - 10];
        return $resultado;
    }

    // Unidades
    if ($numero > 0) {
        $resultado .= $unidades[$numero];
    }

    return $resultado;
}

$valorExtenso = valorPorExtenso($conta['amount']);

// HTML do recibo - COMPACTO
$html = '
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <style>
        body { font-family: Arial, sans-serif; font-size: 11px; }
        .cabecalho {
            text-align: center;
            margin-bottom: 15px;
            border-bottom: 2px solid #000;
            padding-bottom: 8px;
        }
        .titulo { font-size: 20px; font-weight: bold; margin-bottom: 3px; }
        .numero { font-size: 11px; color: #666; }
        .valor-destaque {
            background-color: #2c3e50;
            color: white;
            padding: 12px;
            text-align: center;
            font-size: 18px;
            font-weight: bold;
            margin: 12px 0;
        }
        .extenso {
            text-align: center;
            font-style: italic;
            color: #555;
            margin-bottom: 15px;
            font-size: 11px;
        }
        .corpo {
            line-height: 1.6;
            text-align: justify;
            font-size: 11px;
            margin: 15px 0;
            padding: 12px;
            border: 1px solid #ddd;
            background-color: #fafafa;
        }
        .observacoes {
            background-color: #fff3cd;
            border-left: 3px solid #ffc107;
            padding: 8px;
            margin: 10px 0;
            font-size: 10px;
        }
        .assinatura {
            text-align: right;
            margin-top: 25px;
            font-size: 10px;
        }
        p { margin: 5px 0; }
    </style>
</head>
<body>
    <div class="cabecalho">
        <div class="titulo">RECIBO DE PAGAMENTO</div>
        <div class="numero">Nº ' . str_pad($conta['id'], 6, '0', STR_PAD_LEFT) . '</div>
    </div>

    <div class="valor-destaque">
        R$ ' . $valorTotal . '
    </div>

    <div class="extenso">
        (' . ucfirst($valorExtenso) . ')
    </div>

    <div class="corpo">
        <p><b>Recebi(emos)</b> de <b>' . strtoupper($nomeCliente) . '</b>,
        inscrito(a) no CPF/CNPJ nº <b>' . $documentoCliente . '</b>,
        a quantia de <b>R$ ' . $valorTotal . '</b>
        (<i>' . $valorExtenso . '</i>),
        referente a <b>' . htmlspecialchars($conta['description'] ?? 'serviços prestados') . '</b>.</p>

        <p>Para clareza, firmo o presente recibo dando plena, rasa e irrevogável <b>QUITAÇÃO</b> do valor recebido.</p>
    </div>

    ' . (!empty($conta['notes']) ? '
    <div class="observacoes">
        <b>Obs:</b> ' . nl2br(htmlspecialchars($conta['notes'])) . '
    </div>
    ' : '') . '

    <div class="assinatura">
        <p><b>' . $cidade . '</b>, ' . $dataEmissao . '</p>
        <br><br>
        <p>_______________________________________________<br>
        <b>' . strtoupper($nomeEmpresa) . '</b><br>
        CNPJ: ' . $cnpjEmpresa . '</p>
    </div>

    <div style="text-align: center; color: #999; font-size: 8px; margin-top: 20px; padding-top: 10px; border-top: 1px solid #ddd;">
        Recibo gerado em ' . date('d/m/Y H:i') . ' - Systhema ERP - Válido sem assinatura
    </div>
</body>
</html>
';

// Criar PDF com mPDF
try {
    // Limpar qualquer output anterior
    if (ob_get_level()) {
        ob_end_clean();
    }

    $mpdf = new \Mpdf\Mpdf([
        'mode' => 'utf-8',
        'format' => 'A4',
        'margin_left' => 15,
        'margin_right' => 15,
        'margin_top' => 15,
        'margin_bottom' => 15,
    ]);

    $mpdf->WriteHTML($html);
    $mpdf->Output('Recibo_' . str_pad($conta['id'], 6, '0', STR_PAD_LEFT) . '.pdf', 'I');

} catch (Exception $e) {
    error_log("Erro ao gerar recibo PDF: " . $e->getMessage());
    die("Erro ao gerar recibo: " . $e->getMessage());
}
exit;
