<?php
/**
 * Duplicata/Boleto Simples - PDF usando mPDF
 */

// Preparar dados
$nomeEmpresa = $empresa['razao_social'] ?? $empresa['name'] ?? 'EMPRESA';
$cnpjEmpresa = $empresa['cnpj'] ?? $empresa['document'] ?? '';
$enderecoEmpresa = ($empresa['endereco'] ?? $empresa['address'] ?? '') . ', ' . ($empresa['numero'] ?? '');
$cidadeEmpresa = ($empresa['cidade'] ?? $empresa['city'] ?? '') . ' - ' . ($empresa['uf'] ?? $empresa['state'] ?? '');
$telefoneEmpresa = $empresa['telefone'] ?? $empresa['phone'] ?? '';

$nomeCliente = $cliente['name'] ?? 'Cliente não identificado';
$documentoCliente = $cliente['document'] ?? 'Não informado';
$enderecoCliente = ($cliente['address'] ?? '') . ($cliente['numero'] ? ', ' . $cliente['numero'] : '');
$cidadeCliente = ($cliente['city'] ?? '') . ($cliente['state'] ? ' - ' . $cliente['state'] : '');
$cepCliente = $cliente['zip_code'] ?? '';

$numeroDuplicata = str_pad($conta['numero'] ?? $conta['id'], 10, '0', STR_PAD_LEFT);
$valorTotal = number_format($conta['amount'], 2, ',', '.');
$dataVencimento = date('d/m/Y', strtotime($conta['due_date']));
$dataEmissao = date('d/m/Y');

// Valor por extenso
function valorPorExtenso($valor)
{
    $valor = number_format($valor, 2, '.', '');
    list($inteiro, $centavos) = explode('.', $valor);

    $extenso = numeroPorExtenso((int) $inteiro);

    if ($inteiro == 1) {
        $extenso .= ' real';
    } else {
        $extenso .= ' reais';
    }

    if ($centavos > 0) {
        $extenso .= ' e ' . numeroPorExtenso((int) $centavos);
        if ($centavos == 1) {
            $extenso .= ' centavo';
        } else {
            $extenso .= ' centavos';
        }
    }

    return $extenso;
}

function numeroPorExtenso($numero)
{
    $unidades = ['', 'um', 'dois', 'três', 'quatro', 'cinco', 'seis', 'sete', 'oito', 'nove'];
    $dez = ['dez', 'onze', 'doze', 'treze', 'quatorze', 'quinze', 'dezesseis', 'dezessete', 'dezoito', 'dezenove'];
    $dezenas = ['', '', 'vinte', 'trinta', 'quarenta', 'cinquenta', 'sessenta', 'setenta', 'oitenta', 'noventa'];
    $centenas = ['', 'cento', 'duzentos', 'trezentos', 'quatrocentos', 'quinhentos', 'seiscentos', 'setecentos', 'oitocentos', 'novecentos'];

    if ($numero == 0)
        return 'zero';
    if ($numero == 100)
        return 'cem';

    $resultado = '';

    // Milhares
    if ($numero >= 1000) {
        $milhares = floor($numero / 1000);
        if ($milhares == 1) {
            $resultado .= 'mil';
        } else {
            $resultado .= numeroPorExtenso($milhares) . ' mil';
        }
        $numero %= 1000;
        if ($numero > 0)
            $resultado .= ' ';
    }

    // Centenas
    if ($numero >= 100) {
        $resultado .= $centenas[floor($numero / 100)];
        $numero %= 100;
        if ($numero > 0)
            $resultado .= ' e ';
    }

    // Dezenas
    if ($numero >= 20) {
        $resultado .= $dezenas[floor($numero / 10)];
        $numero %= 10;
        if ($numero > 0)
            $resultado .= ' e ';
    } elseif ($numero >= 10) {
        $resultado .= $dez[$numero - 10];
        return $resultado;
    }

    // Unidades
    if ($numero > 0) {
        $resultado .= $unidades[$numero];
    }

    return $resultado;
}

$valorExtenso = valorPorExtenso($conta['amount']);

// HTML da duplicata - COMPACTO
$html = '
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <style>
        body { font-family: Arial, sans-serif; font-size: 10px; }
        .titulo { text-align: center; font-size: 18px; font-weight: bold; margin-bottom: 3px; }
        .subtitulo { text-align: center; font-size: 10px; margin-bottom: 10px; }
        .secao { border: 1px solid #000; padding: 5px; margin-bottom: 8px; }
        .secao-titulo { background-color: #34495e; color: white; padding: 4px; font-weight: bold; font-size: 10px; margin: -5px -5px 5px -5px; }
        .valor-destaque { background-color: #34495e; color: white; padding: 8px; text-align: center; font-size: 16px; font-weight: bold; margin: 8px 0; }
        .instrucoes { border: 1px solid #ccc; padding: 6px; background-color: #f9f9f9; font-size: 8px; margin: 8px 0; }
        .assinatura { text-align: right; margin-top: 20px; font-size: 9px; }
        table { width: 100%; border-collapse: collapse; }
        td { padding: 3px; font-size: 9px; }
        .borda { border: 1px solid #000; }
        p { margin: 3px 0; }
    </style>
</head>
<body>
    <div class="titulo">DUPLICATA DE COBRANÇA</div>
    <div class="subtitulo">Nº ' . $numeroDuplicata . '</div>

    <div class="secao">
        <div class="secao-titulo">SACADO (PAGADOR)</div>
        <table>
            <tr>
                <td class="borda" style="width:60%"><b>Nome:</b> ' . strtoupper($nomeCliente) . '</td>
                <td class="borda" style="width:40%"><b>CPF/CNPJ:</b> ' . $documentoCliente . '</td>
            </tr>
            <tr>
                <td class="borda"><b>Endereço:</b> ' . $enderecoCliente . '</td>
                <td class="borda"><b>Cidade/UF:</b> ' . $cidadeCliente . '</td>
            </tr>
        </table>
    </div>

    <div class="secao">
        <div class="secao-titulo">CEDENTE (BENEFICIÁRIO)</div>
        <table>
            <tr>
                <td class="borda" colspan="2"><b>Razão Social:</b> ' . strtoupper($nomeEmpresa) . '</td>
            </tr>
            <tr>
                <td class="borda" style="width:50%"><b>CNPJ:</b> ' . $cnpjEmpresa . '</td>
                <td class="borda" style="width:50%"><b>Tel:</b> ' . $telefoneEmpresa . '</td>
            </tr>
        </table>
    </div>

    <table style="margin-bottom: 8px;">
        <tr>
            <td class="borda" style="width:25%"><b>Número:</b><br>' . $numeroDuplicata . '</td>
            <td class="borda" style="width:25%"><b>Emissão:</b><br>' . $dataEmissao . '</td>
            <td class="borda" style="width:25%"><b>Vencimento:</b><br>' . $dataVencimento . '</td>
            <td class="borda" style="width:25%"><b>Valor:</b><br>R$ ' . $valorTotal . '</td>
        </tr>
    </table>

    <div class="secao">
        <div class="secao-titulo">DISCRIMINAÇÃO</div>
        <p style="font-size: 9px;">' . nl2br(htmlspecialchars($conta['description'] ?? 'Serviços prestados')) . '</p>
        ' . (!empty($conta['notes']) ? '<p style="font-size: 8px; font-style: italic; color: #666;">Obs: ' . nl2br(htmlspecialchars($conta['notes'])) . '</p>' : '') . '
    </div>

    <div class="instrucoes">
        <b>INSTRUÇÕES:</b> Após vencimento: juros 1% a.m. + multa 2% • Não receber após 30 dias • Tel: ' . $telefoneEmpresa . '
    </div>

    <div class="valor-destaque">
        TOTAL: R$ ' . $valorTotal . ' <span style="font-size: 10px;">(' . ucfirst($valorExtenso) . ')</span>
    </div>

    <div class="assinatura">
        <p>' . $cidade . ', ___/___/_____</p>
        <br>
        <p>_______________________________<br>
        <b>' . strtoupper($nomeEmpresa) . '</b> - CNPJ: ' . $cnpjEmpresa . '</p>
    </div>

    <div style="text-align: center; color: #999; font-size: 7px; margin-top: 15px;">
        Documento gerado em ' . date('d/m/Y H:i') . ' - Systhema ERP
    </div>
</body>
</html>
';

// Criar PDF com mPDF
try {
    // Limpar qualquer output anterior
    if (ob_get_level()) {
        ob_end_clean();
    }

    $mpdf = new \Mpdf\Mpdf([
        'mode' => 'utf-8',
        'format' => 'A4',
        'margin_left' => 15,
        'margin_right' => 15,
        'margin_top' => 15,
        'margin_bottom' => 15,
    ]);

    $mpdf->WriteHTML($html);
    $mpdf->Output('Duplicata_' . str_pad($conta['id'], 6, '0', STR_PAD_LEFT) . '.pdf', 'I');

} catch (Exception $e) {
    error_log("Erro ao gerar duplicata PDF: " . $e->getMessage());
    die("Erro ao gerar duplicata: " . $e->getMessage());
}
exit;
