<?php
ob_start();
$isEdit = isset($empresa);
$titulo = $isEdit ? 'Editar Empresa' : 'Nova Empresa';
?>

<div class="row mb-4">
    <div class="col-md-12">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= url('/dashboard') ?>">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="<?= url('/empresas') ?>">Empresas</a></li>
                <li class="breadcrumb-item active"><?= $titulo ?></li>
            </ol>
        </nav>
        <h2><i class="bi bi-building me-2"></i> <?= $titulo ?></h2>
    </div>
</div>

<form id="formEmpresa" novalidate enctype="multipart/form-data">
    <input type="hidden" name="id" value="<?= htmlspecialchars($empresa['id'] ?? '') ?>">

    <!-- Navegação por Abas -->
    <div class="row mb-4">
        <div class="col-12">
            <ul class="nav nav-tabs" id="empresaTabs" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="dados-tab" data-bs-toggle="tab" data-bs-target="#dados"
                        type="button" role="tab">
                        <i class="bi bi-info-circle me-2"></i> Dados Principais
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="endereco-tab" data-bs-toggle="tab" data-bs-target="#endereco"
                        type="button" role="tab">
                        <i class="bi bi-geo-alt me-2"></i> Endereço
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="contador-tab" data-bs-toggle="tab" data-bs-target="#contador"
                        type="button" role="tab">
                        <i class="bi bi-calculator me-2"></i> Contador
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="configuracoes-tab" data-bs-toggle="tab" data-bs-target="#configuracoes"
                        type="button" role="tab">
                        <i class="bi bi-gear me-2"></i> Configurações
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="integracoes-tab" data-bs-toggle="tab" data-bs-target="#integracoes"
                        type="button" role="tab">
                        <i class="bi bi-plug me-2"></i> Integrações
                    </button>
                </li>
            </ul>
        </div>
    </div>

    <!-- Conteúdo das Abas -->
    <div class="tab-content" id="empresaTabsContent">
        <!-- Aba: Dados Principais -->
        <div class="tab-pane fade show active" id="dados" role="tabpanel">
            <div class="card">
                <div class="card-header">
                    <i class="bi bi-info-circle me-2"></i> Dados da Empresa
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="name" class="form-label">Razão Social *</label>
                            <input type="text" class="form-control" id="name" name="name"
                                value="<?= htmlspecialchars($empresa['name'] ?? '') ?>" required>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="trade_name" class="form-label">Nome Fantasia</label>
                            <input type="text" class="form-control" id="trade_name" name="trade_name"
                                value="<?= htmlspecialchars($empresa['trade_name'] ?? '') ?>">
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="document" class="form-label">CNPJ/CPF *</label>
                            <input type="text" class="form-control" id="document" name="document"
                                placeholder="00.000.000/0000-00"
                                value="<?= htmlspecialchars($empresa['document'] ?? '') ?>" required>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="email" class="form-label">Email</label>
                            <input type="email" class="form-control" id="email" name="email"
                                placeholder="email@empresa.com.br"
                                value="<?= htmlspecialchars($empresa['email'] ?? '') ?>">
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="phone" class="form-label">Telefone</label>
                            <input type="text" class="form-control" id="phone" name="phone" placeholder="(00) 0000-0000"
                                value="<?= htmlspecialchars($empresa['phone'] ?? '') ?>">
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="state_registration" class="form-label">Inscrição Estadual</label>
                            <input type="text" class="form-control" id="state_registration" name="state_registration"
                                placeholder="000.000.000.000"
                                value="<?= htmlspecialchars($empresa['state_registration'] ?? '') ?>">
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="municipal_registration" class="form-label">Inscrição Municipal</label>
                            <input type="text" class="form-control" id="municipal_registration"
                                name="municipal_registration" placeholder="000.000.000"
                                value="<?= htmlspecialchars($empresa['municipal_registration'] ?? '') ?>">
                        </div>

                        <div class="col-md-12 mb-3">
                            <label for="website" class="form-label">Website</label>
                            <input type="url" class="form-control" id="website" name="website"
                                placeholder="https://www.exemplo.com.br"
                                value="<?= htmlspecialchars($empresa['website'] ?? '') ?>">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Aba: Endereço -->
        <div class="tab-pane fade" id="endereco" role="tabpanel">
            <div class="card">
                <div class="card-header">
                    <i class="bi bi-geo-alt me-2"></i> Endereço
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <label for="zip_code" class="form-label">
                                CEP <i class="bi bi-search text-primary" style="cursor: pointer;"
                                    title="Busca automática ao digitar"></i>
                            </label>
                            <input type="text" class="form-control" id="zip_code" name="zip_code"
                                placeholder="00000-000" value="<?= htmlspecialchars($empresa['zip_code'] ?? '') ?>">
                            <small class="text-muted">Preenche automaticamente</small>
                        </div>

                        <div class="col-md-7 mb-3">
                            <label for="address" class="form-label">Logradouro</label>
                            <input type="text" class="form-control" id="address" name="address"
                                placeholder="Rua, Avenida..."
                                value="<?= htmlspecialchars($empresa['address'] ?? '') ?>">
                        </div>

                        <div class="col-md-2 mb-3">
                            <label for="numero" class="form-label">Número</label>
                            <input type="text" class="form-control" id="numero" name="numero" placeholder="123"
                                value="<?= htmlspecialchars($empresa['numero'] ?? '') ?>">
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="complemento" class="form-label">Complemento</label>
                            <input type="text" class="form-control" id="complemento" name="complemento"
                                placeholder="Sala, Andar..."
                                value="<?= htmlspecialchars($empresa['complemento'] ?? '') ?>">
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="bairro" class="form-label">Bairro</label>
                            <input type="text" class="form-control" id="bairro" name="bairro" placeholder="Centro"
                                value="<?= htmlspecialchars($empresa['bairro'] ?? '') ?>">
                        </div>

                        <div class="col-md-2 mb-3">
                            <label for="state" class="form-label">UF</label>
                            <select class="form-select" id="state" name="state">
                                <option value="">UF</option>
                                <?php
                                $estados = ['AC', 'AL', 'AP', 'AM', 'BA', 'CE', 'DF', 'ES', 'GO', 'MA', 'MT', 'MS', 'MG', 'PA', 'PB', 'PR', 'PE', 'PI', 'RJ', 'RN', 'RS', 'RO', 'RR', 'SC', 'SP', 'SE', 'TO'];
                                foreach ($estados as $uf):
                                    ?>
                                    <option value="<?= $uf ?>" <?= ($empresa['state'] ?? '') === $uf ? 'selected' : '' ?>>
                                        <?= $uf ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="col-md-10 mb-3">
                            <label for="city" class="form-label">Cidade</label>
                            <input type="text" class="form-control" id="city" name="city" placeholder="São Paulo"
                                value="<?= htmlspecialchars($empresa['city'] ?? '') ?>">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Aba: Contador -->
        <div class="tab-pane fade" id="contador" role="tabpanel">
            <div class="card">
                <div class="card-header">
                    <i class="bi bi-calculator me-2"></i> Dados do Contador
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="contador_nome" class="form-label">Nome do Contador</label>
                            <input type="text" class="form-control" id="contador_nome" name="contador_nome"
                                placeholder="Nome completo do contador"
                                value="<?= htmlspecialchars($empresa['contador_nome'] ?? '') ?>">
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="contador_cpf" class="form-label">CPF do Contador</label>
                            <input type="text" class="form-control" id="contador_cpf" name="contador_cpf"
                                placeholder="000.000.000-00"
                                value="<?= htmlspecialchars($empresa['contador_cpf'] ?? '') ?>">
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="contador_crc" class="form-label">CRC (Registro no CRC)</label>
                            <input type="text" class="form-control" id="contador_crc" name="contador_crc"
                                placeholder="CRC/UF 000000/O-0"
                                value="<?= htmlspecialchars($empresa['contador_crc'] ?? '') ?>">
                            <small class="text-muted">Ex: CRC/SP 123456/O-1</small>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="contador_cnpj" class="form-label">
                                CNPJ do Escritório Contábil
                                <i class="bi bi-search text-primary" style="cursor: pointer;"
                                    title="Busca automática na Receita Federal ao digitar"></i>
                            </label>
                            <input type="text" class="form-control" id="contador_cnpj" name="contador_cnpj"
                                placeholder="00.000.000/0000-00"
                                value="<?= htmlspecialchars($empresa['contador_cnpj'] ?? '') ?>">
                            <small class="text-muted">Preenche automaticamente ao sair do campo</small>
                        </div>

                        <div class="col-md-12 mb-3">
                            <label for="contador_razao_social" class="form-label">Razão Social do Escritório</label>
                            <input type="text" class="form-control" id="contador_razao_social"
                                name="contador_razao_social" placeholder="Nome do escritório de contabilidade"
                                value="<?= htmlspecialchars($empresa['contador_razao_social'] ?? '') ?>">
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="contador_email" class="form-label">Email do Contador</label>
                            <input type="email" class="form-control" id="contador_email" name="contador_email"
                                placeholder="contador@escritorio.com.br"
                                value="<?= htmlspecialchars($empresa['contador_email'] ?? '') ?>">
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="contador_telefone" class="form-label">Telefone do Contador</label>
                            <input type="text" class="form-control" id="contador_telefone" name="contador_telefone"
                                placeholder="(00) 00000-0000"
                                value="<?= htmlspecialchars($empresa['contador_telefone'] ?? '') ?>">
                        </div>
                    </div>
                </div>
            </div>

            <!-- Endereço do Contador -->
            <div class="card mt-3">
                <div class="card-header">
                    <i class="bi bi-geo-alt me-2"></i> Endereço do Escritório Contábil
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <label for="contador_cep" class="form-label">CEP</label>
                            <input type="text" class="form-control" id="contador_cep" name="contador_cep"
                                placeholder="00000-000" value="<?= htmlspecialchars($empresa['contador_cep'] ?? '') ?>">
                        </div>

                        <div class="col-md-7 mb-3">
                            <label for="contador_logradouro" class="form-label">Logradouro</label>
                            <input type="text" class="form-control" id="contador_logradouro" name="contador_logradouro"
                                placeholder="Rua, Avenida..."
                                value="<?= htmlspecialchars($empresa['contador_logradouro'] ?? '') ?>">
                        </div>

                        <div class="col-md-2 mb-3">
                            <label for="contador_numero" class="form-label">Número</label>
                            <input type="text" class="form-control" id="contador_numero" name="contador_numero"
                                placeholder="123" value="<?= htmlspecialchars($empresa['contador_numero'] ?? '') ?>">
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="contador_complemento" class="form-label">Complemento</label>
                            <input type="text" class="form-control" id="contador_complemento"
                                name="contador_complemento" placeholder="Sala, Andar..."
                                value="<?= htmlspecialchars($empresa['contador_complemento'] ?? '') ?>">
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="contador_bairro" class="form-label">Bairro</label>
                            <input type="text" class="form-control" id="contador_bairro" name="contador_bairro"
                                placeholder="Centro" value="<?= htmlspecialchars($empresa['contador_bairro'] ?? '') ?>">
                        </div>

                        <div class="col-md-2 mb-3">
                            <label for="contador_uf" class="form-label">UF</label>
                            <select class="form-select" id="contador_uf" name="contador_uf">
                                <option value="">UF</option>
                                <?php
                                $estados = ['AC', 'AL', 'AP', 'AM', 'BA', 'CE', 'DF', 'ES', 'GO', 'MA', 'MT', 'MS', 'MG', 'PA', 'PB', 'PR', 'PE', 'PI', 'RJ', 'RN', 'RS', 'RO', 'RR', 'SC', 'SP', 'SE', 'TO'];
                                foreach ($estados as $uf):
                                    ?>
                                    <option value="<?= $uf ?>" <?= ($empresa['contador_uf'] ?? '') === $uf ? 'selected' : '' ?>>
                                        <?= $uf ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <div class="col-md-10 mb-3">
                            <label for="contador_municipio" class="form-label">Município</label>
                            <input type="text" class="form-control" id="contador_municipio" name="contador_municipio"
                                placeholder="São Paulo"
                                value="<?= htmlspecialchars($empresa['contador_municipio'] ?? '') ?>">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Aba: Configurações -->
        <div class="tab-pane fade" id="configuracoes" role="tabpanel">
            <div class="card">
                <div class="card-header">
                    <i class="bi bi-gear me-2"></i> Configurações
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="logo" class="form-label">Logo da Empresa</label>
                            <input type="file" class="form-control" id="logo" name="logo" accept="image/*">
                            <?php if (!empty($empresa['logo'])): ?>
                                <?php
                                $logoPath = $empresa['logo'];
                                // Se o caminho não começa com /, adiciona
                                if (!empty($logoPath) && $logoPath[0] !== '/') {
                                    $logoPath = '/' . $logoPath;
                                }
                                // Usa url() para garantir o base path correto
                                $logoUrl = url($logoPath);
                                ?>
                                <div class="mt-2">
                                    <img src="<?= htmlspecialchars($logoUrl) ?>" alt="Logo"
                                        style="max-width: 100%; height: auto; max-height: 150px;"
                                        class="border rounded p-2"
                                        onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
                                    <div style="display: none; color: red; font-size: 0.9em;">Erro ao carregar imagem. Verifique o caminho do arquivo.</div>
                                    <div class="mt-2">
                                        <a href="<?= htmlspecialchars($logoUrl) ?>" download
                                            class="btn btn-sm btn-outline-primary">
                                            <i class="bi bi-download me-1"></i>Download Logo
                                        </a>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label class="form-label d-block mb-3">Status e Opções</label>

                            <div class="form-check form-switch mb-3">
                                <input class="form-check-input" type="checkbox" id="is_active" name="is_active"
                                    value="1" <?= ($empresa['is_active'] ?? 1) ? 'checked' : '' ?>>
                                <label class="form-check-label" for="is_active">
                                    Empresa Ativa
                                </label>
                            </div>

                            <?php if (!$isEdit): ?>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="is_default" name="is_default"
                                        value="1">
                                    <label class="form-check-label" for="is_default">
                                        Definir como Padrão
                                    </label>
                                </div>
                            <?php endif; ?>
                        </div>

                        <?php if ($isEdit): ?>
                            <div class="col-12">
                                <hr>
                                <p class="small text-muted mb-1">
                                    <strong>Criado em:</strong> <?= date('d/m/Y H:i', strtotime($empresa['created_at'])) ?>
                                </p>
                                <p class="small text-muted">
                                    <strong>Atualizado em:</strong>
                                    <?= date('d/m/Y H:i', strtotime($empresa['updated_at'])) ?>
                                </p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Certificado Digital -->
            <div class="card mb-4">
                <div class="card-header">
                    <i class="bi bi-shield-lock me-2"></i> Certificado Digital
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8 mb-3">
                            <label for="certificado" class="form-label">Certificado Digital (A1 .pfx)</label>
                            <input type="file" class="form-control" id="certificado" name="certificado"
                                accept=".pfx,.p12">
                            <small class="text-muted">Arquivo .pfx ou .p12 (certificado A1)</small>
                            <?php if (!empty($empresa['certificado_path'])): ?>
                                <div class="mt-2">
                                    <span class="badge bg-success me-2">
                                        <i class="bi bi-check-circle me-1"></i>Certificado configurado
                                    </span>
                                    <a href="<?= url('/empresas/download-certificado?id=' . htmlspecialchars($empresa['id'])) ?>"
                                        class="btn btn-sm btn-outline-success">
                                        <i class="bi bi-download me-1"></i>Download Certificado
                                    </a>
                                    <?php if ($isEdit): ?>
                                        <button type="button" class="btn btn-sm btn-outline-primary"
                                            onclick="testarCertificado(<?= $empresa['id'] ?>)">
                                            <i class="bi bi-shield-check me-1"></i>Testar Certificado
                                        </button>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="senha_certificado" class="form-label">Senha do Certificado</label>
                            <input type="password" class="form-control" id="senha_certificado" name="senha_certificado"
                                placeholder="Senha do certificado"
                                value="<?= htmlspecialchars($empresa['senha_certificado'] ?? '') ?>">
                        </div>
                    </div>
                </div>
            </div>

            <!-- Configurações NF-e -->
            <div class="card mb-4">
                <div class="card-header">
                    <i class="bi bi-file-earmark-text me-2"></i> Configurações NF-e
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label for="serie_nfe" class="form-label">Série NF-e</label>
                            <input type="text" class="form-control" id="serie_nfe" name="serie_nfe" placeholder="1"
                                value="<?= htmlspecialchars($empresa['serie_nfe'] ?? '1') ?>">
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="numero_nfe" class="form-label">Último Número NF-e</label>
                            <input type="number" class="form-control" id="numero_nfe" name="numero_nfe" placeholder="0"
                                value="<?= htmlspecialchars($empresa['numero_nfe'] ?? '0') ?>">
                            <small class="text-muted">Próxima: <?= (($empresa['numero_nfe'] ?? 0) + 1) ?></small>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label for="ambiente_nfe" class="form-label">Ambiente</label>
                            <select class="form-select" id="ambiente_nfe" name="ambiente_nfe">
                                <option value="homologacao" <?= ($empresa['ambiente_nfe'] ?? 'homologacao') === 'homologacao' ? 'selected' : '' ?>>
                                    Homologação</option>
                                <option value="producao" <?= ($empresa['ambiente_nfe'] ?? '') === 'producao' ? 'selected' : '' ?>>Produção
                                </option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Configurações NFC-e -->
            <div class="card mb-4">
                <div class="card-header">
                    <i class="bi bi-receipt me-2"></i> Configurações NFC-e
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <label for="serie_nfce" class="form-label">Série</label>
                            <input type="text" class="form-control" id="serie_nfce" name="serie_nfce" placeholder="1"
                                value="<?= htmlspecialchars($empresa['serie_nfce'] ?? '1') ?>">
                        </div>

                        <div class="col-md-3 mb-3">
                            <label for="numero_nfce" class="form-label">Último Número</label>
                            <input type="number" class="form-control" id="numero_nfce" name="numero_nfce"
                                placeholder="0" value="<?= htmlspecialchars($empresa['numero_nfce'] ?? '0') ?>">
                            <small class="text-muted">Próxima: <?= (($empresa['numero_nfce'] ?? 0) + 1) ?></small>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="ambiente_nfce" class="form-label">Ambiente</label>
                            <select class="form-select" id="ambiente_nfce" name="ambiente_nfce">
                                <option value="homologacao" <?= ($empresa['ambiente_nfce'] ?? 'homologacao') === 'homologacao' ? 'selected' : '' ?>>
                                    Homologação</option>
                                <option value="producao" <?= ($empresa['ambiente_nfce'] ?? '') === 'producao' ? 'selected' : '' ?>>Produção
                                </option>
                            </select>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="csc_nfce" class="form-label">CSC (Código de Segurança)</label>
                            <input type="text" class="form-control" id="csc_nfce" name="csc_nfce"
                                placeholder="CSC fornecido pela SEFAZ"
                                value="<?= htmlspecialchars($empresa['csc_nfce'] ?? '') ?>">
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="id_token_nfce" class="form-label">ID Token CSC</label>
                            <input type="text" class="form-control" id="id_token_nfce" name="id_token_nfce"
                                placeholder="Ex: 000001"
                                value="<?= htmlspecialchars($empresa['id_token_nfce'] ?? '') ?>">
                        </div>
                    </div>
                </div>
            </div>

            <!-- Configurações NFS-e -->
            <!-- <div class="card mb-4">
                <div class="card-header">
                    <i class="bi bi-file-text me-2"></i> NFS-e (Nota de Serviço)
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="serie_nfse" class="form-label">Série</label>
                            <input type="text" class="form-control" id="serie_nfse" name="serie_nfse" placeholder="1"
                                value="<?= htmlspecialchars($empresa['serie_nfse'] ?? '1') ?>">
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="numero_nfse" class="form-label">Último Número</label>
                            <input type="number" class="form-control" id="numero_nfse" name="numero_nfse"
                                placeholder="0" value="<?= htmlspecialchars($empresa['numero_nfse'] ?? '0') ?>">
                            <small class="text-muted">Próxima: <?= (($empresa['numero_nfse'] ?? 0) + 1) ?></small>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label for="nfse_codigo_servico" class="form-label">Código de Serviço (Item Lista)</label>
                            <input type="text" class="form-control" id="nfse_codigo_servico" name="nfse_codigo_servico"
                                placeholder="Ex: 0107"
                                value="<?= htmlspecialchars($empresa['nfse_codigo_servico'] ?? '') ?>">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="nfse_codigo_tributacao" class="form-label">Código de Tributação</label>
                            <input type="text" class="form-control" id="nfse_codigo_tributacao"
                                name="nfse_codigo_tributacao" placeholder="Código municipal"
                                value="<?= htmlspecialchars($empresa['nfse_codigo_tributacao'] ?? '') ?>">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="nfse_aliquota_iss" class="form-label">Alíquota ISS (%)</label>
                            <input type="number" step="0.01" min="0" class="form-control" id="nfse_aliquota_iss"
                                name="nfse_aliquota_iss" placeholder="Ex: 2.00"
                                value="<?= htmlspecialchars($empresa['nfse_aliquota_iss'] ?? '') ?>">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label for="nfse_natureza_operacao" class="form-label">Natureza da Operação</label>
                            <select id="nfse_natureza_operacao" name="nfse_natureza_operacao" class="form-select">
                                <?php $naturezaAtual = $empresa['nfse_natureza_operacao'] ?? '1'; ?>
                                <option value="1" <?= $naturezaAtual === '1' ? 'selected' : '' ?>>01 - Tributação no
                                    município</option>
                                <option value="2" <?= $naturezaAtual === '2' ? 'selected' : '' ?>>02 - Tributação fora
                                    do município</option>
                                <option value="3" <?= $naturezaAtual === '3' ? 'selected' : '' ?>>03 - Isenção</option>
                                <option value="4" <?= $naturezaAtual === '4' ? 'selected' : '' ?>>04 - Imune</option>
                                <option value="5" <?= $naturezaAtual === '5' ? 'selected' : '' ?>>05 - Exigibilidade
                                    suspensa por decisão judicial</option>
                                <option value="6" <?= $naturezaAtual === '6' ? 'selected' : '' ?>>06 - Exigibilidade
                                    suspensa por procedimento administrativo</option>
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="nfse_regime_tributacao" class="form-label">Regime Especial</label>
                            <?php $regimeAtual = $empresa['nfse_regime_tributacao'] ?? ''; ?>
                            <select id="nfse_regime_tributacao" name="nfse_regime_tributacao" class="form-select">
                                <option value="" <?= ($regimeAtual === '' ? 'selected' : '') ?>>(Não informado)</option>
                                <option value="1" <?= $regimeAtual === '1' ? 'selected' : '' ?>>01 - Microempresa
                                    Municipal</option>
                                <option value="2" <?= $regimeAtual === '2' ? 'selected' : '' ?>>02 - Estimativa</option>
                                <option value="3" <?= $regimeAtual === '3' ? 'selected' : '' ?>>03 - Sociedade de
                                    Profissionais</option>
                                <option value="4" <?= $regimeAtual === '4' ? 'selected' : '' ?>>04 - Cooperativa
                                </option>
                                <option value="5" <?= $regimeAtual === '5' ? 'selected' : '' ?>>05 - MEI</option>
                                <option value="6" <?= $regimeAtual === '6' ? 'selected' : '' ?>>06 - ME/EPP</option>
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="nfse_optante_simples" class="form-label">Optante Simples Nacional</label>
                            <?php $optanteAtual = $empresa['nfse_optante_simples'] ?? '2'; ?>
                            <select id="nfse_optante_simples" name="nfse_optante_simples" class="form-select">
                                <option value="1" <?= $optanteAtual === '1' ? 'selected' : '' ?>>Sim</option>
                                <option value="2" <?= $optanteAtual === '2' ? 'selected' : '' ?>>Não</option>
                            </select>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label for="nfse_iss_retido_padrao" class="form-label">ISS Retido?</label>
                            <?php $retidoAtual = $empresa['nfse_iss_retido_padrao'] ?? '2'; ?>
                            <select id="nfse_iss_retido_padrao" name="nfse_iss_retido_padrao" class="form-select">
                                <option value="2" <?= $retidoAtual === '2' ? 'selected' : '' ?>>Não</option>
                                <option value="1" <?= $retidoAtual === '1' ? 'selected' : '' ?>>Sim</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div> -->

            <!-- Configurações MDF-e -->
            <!-- <div class="card mb-4">
                <div class="card-header">
                    <i class="bi bi-truck me-2"></i> MDF-e (Manifesto Eletrônico)
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="serie_mdfe" class="form-label">Série</label>
                            <input type="text" class="form-control" id="serie_mdfe" name="serie_mdfe" placeholder="1"
                                value="<?= htmlspecialchars($empresa['serie_mdfe'] ?? '1') ?>">
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="numero_mdfe" class="form-label">Último Número</label>
                            <input type="number" class="form-control" id="numero_mdfe" name="numero_mdfe"
                                placeholder="0" value="<?= htmlspecialchars($empresa['numero_mdfe'] ?? '0') ?>">
                            <small class="text-muted">Próximo: <?= (($empresa['numero_mdfe'] ?? 0) + 1) ?></small>
                        </div>
                    </div>
                </div>
            </div> -->

            <!-- Configurações CT-e -->
            <!-- <div class="card mb-4">
                <div class="card-header">
                    <i class="bi bi-box-seam me-2"></i> CT-e (Conhecimento de Transporte)
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="serie_cte" class="form-label">Série</label>
                            <input type="text" class="form-control" id="serie_cte" name="serie_cte" placeholder="1"
                                value="<?= htmlspecialchars($empresa['serie_cte'] ?? '1') ?>">
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="numero_cte" class="form-label">Último Número</label>
                            <input type="number" class="form-control" id="numero_cte" name="numero_cte" placeholder="0"
                                value="<?= htmlspecialchars($empresa['numero_cte'] ?? '0') ?>">
                            <small class="text-muted">Próximo: <?= (($empresa['numero_cte'] ?? 0) + 1) ?></small>
                        </div>
                    </div>
                </div>
            </div> -->
        </div>

        <!-- Aba: Integrações -->
        <div class="tab-pane fade" id="integracoes" role="tabpanel">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <div>
                        <i class="bi bi-plug me-2"></i> Integração Shipay
                    </div>
                    <a href="https://shipay.readme.io/reference/postpdvauth" class="btn btn-sm btn-outline-secondary"
                        target="_blank" rel="noreferrer">
                        <i class="bi bi-box-arrow-up-right me-1"></i> Documentação
                    </a>
                </div>
                <div class="card-body">
                    <div class="form-check form-switch mb-4">
                        <input class="form-check-input" type="checkbox" role="switch" id="shipay_enabled"
                            name="shipay_enabled" value="1" <?= !empty($empresa['shipay_enabled']) ? 'checked' : '' ?>>
                        <label class="form-check-label fw-semibold" for="shipay_enabled">
                            Ativar geração de cobranças (boleto/Pix) pela Shipay para esta empresa
                        </label>
                    </div>

                    <div id="shipayDisabledAlert"
                        class="alert alert-warning <?= !empty($empresa['shipay_enabled']) ? 'd-none' : '' ?>">
                        <i class="bi bi-info-circle me-2"></i> Habilite a integração para informar as credenciais. Todos
                        os campos abaixo
                        são opcionais enquanto a Shipay estiver desativada.
                    </div>

                    <div id="shipayFields" class="row g-3">
                        <?php $shipayEnvironment = $empresa['shipay_environment'] ?? 'sandbox'; ?>
                        <div class="col-md-4">
                            <label for="shipay_environment" class="form-label">Ambiente Shipay</label>
                            <select class="form-select" id="shipay_environment" name="shipay_environment">
                                <option value="sandbox" <?= $shipayEnvironment === 'sandbox' ? 'selected' : '' ?>>
                                    Sandbox (Homologação)</option>
                                <option value="production" <?= $shipayEnvironment === 'production' ? 'selected' : '' ?>>
                                    Produção</option>
                            </select>
                            <small class="text-muted">Use sandbox para testes antes de emitir boletos reais.</small>
                        </div>

                        <div class="col-md-4">
                            <label for="shipay_access_key" class="form-label">Access Key</label>
                            <input type="text" class="form-control" id="shipay_access_key" name="shipay_access_key"
                                placeholder="Access key fornecida pela Shipay"
                                value="<?= htmlspecialchars($empresa['shipay_access_key'] ?? '') ?>">
                        </div>

                        <div class="col-md-4">
                            <label for="shipay_secret_key" class="form-label">Secret Key</label>
                            <input type="password" class="form-control" id="shipay_secret_key" name="shipay_secret_key"
                                placeholder="Secret key fornecida pela Shipay"
                                value="<?= htmlspecialchars($empresa['shipay_secret_key'] ?? '') ?>">
                        </div>

                        <div class="col-md-4">
                            <label for="shipay_client_id" class="form-label">Client ID</label>
                            <input type="text" class="form-control" id="shipay_client_id" name="shipay_client_id"
                                placeholder="Identificador do cliente Shipay"
                                value="<?= htmlspecialchars($empresa['shipay_client_id'] ?? '') ?>">
                        </div>

                        <div class="col-md-4">
                            <label for="shipay_store_id" class="form-label">Loja (Store ID)</label>
                            <input type="text" class="form-control" id="shipay_store_id" name="shipay_store_id"
                                placeholder="Opcional - ID da loja Shipay"
                                value="<?= htmlspecialchars($empresa['shipay_store_id'] ?? '') ?>">
                            <small class="text-muted">Use se o tenant possuir mais de uma loja cadastrada.</small>
                        </div>

                        <div class="col-md-4">
                            <label for="shipay_cashier_id" class="form-label">Caixa (Cashier ID)</label>
                            <input type="text" class="form-control" id="shipay_cashier_id" name="shipay_cashier_id"
                                placeholder="Opcional - ID do caixa Shipay"
                                value="<?= htmlspecialchars($empresa['shipay_cashier_id'] ?? '') ?>">
                        </div>

                        <div class="col-md-6">
                            <label for="shipay_webhook_url" class="form-label">Webhook configurado na Shipay</label>
                            <input type="url" class="form-control" id="shipay_webhook_url" name="shipay_webhook_url"
                                placeholder="https://exemplo.com/webhooks/shipay"
                                value="<?= htmlspecialchars($empresa['shipay_webhook_url'] ?? '') ?>">
                            <small class="text-muted">URL que será registrada no painel Shipay para receber
                                eventos.</small>
                        </div>

                        <div class="col-md-6">
                            <label for="shipay_webhook_secret" class="form-label">Webhook Secret</label>
                            <input type="text" class="form-control" id="shipay_webhook_secret"
                                name="shipay_webhook_secret" placeholder="Token utilizado para validar assinaturas"
                                value="<?= htmlspecialchars($empresa['shipay_webhook_secret'] ?? '') ?>">
                        </div>

                        <?php if (!empty($empresa['id']) && !empty($empresa['shipay_enabled'])): ?>
                            <div class="col-12 mt-3">
                                <button type="button" class="btn btn-outline-primary"
                                    onclick="testarShipay(<?= $empresa['id'] ?>)">
                                    <i class="bi bi-plug me-1"></i> Testar Conexão Shipay
                                </button>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Integração Portal Nacional de NFS-e -->
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <div>
                        <i class="bi bi-globe me-2"></i> Portal Nacional de NFS-e
                        <small class="text-muted ms-2">(Substitui webservice da Prefeitura)</small>
                    </div>
                    <a href="https://www.gov.br/nfse/" class="btn btn-sm btn-outline-secondary" target="_blank"
                        rel="noreferrer">
                        <i class="bi bi-box-arrow-up-right me-1"></i> Portal Nacional
                    </a>
                </div>
                <div class="card-body">
                    <div class="alert alert-info">
                        <i class="bi bi-info-circle me-2"></i>
                        <strong>Atenção:</strong> A Prefeitura de Recife está migrando para o Portal Nacional de NFS-e.
                        Configure as credenciais OAuth2 abaixo para usar o novo sistema padronizado.
                    </div>

                    <div class="form-check form-switch mb-4">
                        <input class="form-check-input" type="checkbox" role="switch" id="nfse_nacional_ativo"
                            name="nfse_nacional_ativo" value="1" <?= !empty($empresa['nfse_nacional_ativo']) ? 'checked' : '' ?>>
                        <label class="form-check-label fw-semibold" for="nfse_nacional_ativo">
                            Ativar integração com Portal Nacional de NFS-e
                        </label>
                    </div>

                    <div id="nfseNacionalDisabledAlert"
                        class="alert alert-warning <?= !empty($empresa['nfse_nacional_ativo']) ? 'd-none' : '' ?>">
                        <i class="bi bi-info-circle me-2"></i> Habilite a integração para configurar. Você pode usar
                        <strong>OAuth2</strong> OU <strong>apenas certificado digital</strong>.
                    </div>

                    <div id="nfseNacionalFields" class="row g-3">
                        <div class="alert alert-info">
                            <i class="bi bi-info-circle me-2"></i>
                            <strong>Método de Autenticação:</strong> Você pode usar <strong>OAuth2</strong> (se tiver
                            credenciais) OU <strong>apenas certificado digital</strong> (já configurado na empresa).
                            Se deixar OAuth2 vazio, será usado o certificado digital.
                        </div>

                        <div class="col-md-6">
                            <label for="nfse_nacional_client_id" class="form-label">Client ID (OAuth2) <span
                                    class="text-muted">(Opcional)</span></label>
                            <input type="text" class="form-control" id="nfse_nacional_client_id"
                                name="nfse_nacional_client_id" placeholder="Deixe vazio para usar apenas certificado"
                                value="<?= htmlspecialchars($empresa['nfse_nacional_client_id'] ?? '') ?>">
                            <small class="text-muted">Opcional: Client ID OAuth2. Se vazio, usará certificado
                                digital.</small>
                        </div>

                        <div class="col-md-6">
                            <label for="nfse_nacional_client_secret" class="form-label">Client Secret (OAuth2) <span
                                    class="text-muted">(Opcional)</span></label>
                            <div class="input-group">
                                <input type="password" class="form-control" id="nfse_nacional_client_secret"
                                    name="nfse_nacional_client_secret"
                                    placeholder="Deixe vazio para usar apenas certificado"
                                    value="<?= htmlspecialchars($empresa['nfse_nacional_client_secret'] ?? '') ?>">
                                <button class="btn btn-outline-secondary" type="button"
                                    onclick="togglePassword('nfse_nacional_client_secret')">
                                    <i class="bi bi-eye" id="icon-nfse_nacional_client_secret"></i>
                                </button>
                            </div>
                            <small class="text-muted">Opcional: Client Secret OAuth2. Se vazio, usará certificado
                                digital.</small>
                        </div>

                        <div class="col-md-12">
                            <div class="alert alert-info mb-0">
                                <i class="bi bi-info-circle me-2"></i>
                                <strong>Ambiente:</strong> Sempre <strong class="text-success">PRODUÇÃO</strong>
                                (emissão real)
                                <input type="hidden" name="nfse_nacional_homologacao" value="0">
                            </div>
                        </div>
                    </div>

                    <div class="alert alert-success mt-3">
                        <i class="bi bi-check-circle me-2"></i>
                        <strong>✅ Você pode usar APENAS certificado digital!</strong><br>
                        Se o certificado digital da empresa já está configurado (aba "Dados Principais"),
                        você pode deixar os campos OAuth2 vazios. O sistema usará automaticamente o certificado para
                        autenticação.
                    </div>

                    <div class="alert alert-info mt-3">
                        <i class="bi bi-info-circle me-2"></i>
                        <strong>Opção OAuth2 (opcional):</strong> Se preferir usar OAuth2:
                        <ol class="mb-0 mt-2">
                            <li>Acesse <a href="https://www.gov.br/nfse/" target="_blank">https://www.gov.br/nfse/</a>
                            </li>
                            <li>Faça seu cadastro no Portal Nacional</li>
                            <li>Solicite as credenciais OAuth2 (Client ID e Client Secret)</li>
                            <li>Preencha os campos acima</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <!-- Fim do tab-content -->

    <!-- Botões de Ação -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-check-circle me-2"></i> Salvar
                </button>
                <a href="<?= url('/empresas') ?>" class="btn btn-secondary">
                    <i class="bi bi-x-circle me-2"></i> Cancelar
                </a>
            </div>
        </div>
    </div>
</form>

<style>
    /* Animações personalizadas para busca de CEP */
    .animated-popup {
        animation: popupZoomIn 0.3s ease-out;
    }

    @keyframes popupZoomIn {
        from {
            transform: scale(0.7);
            opacity: 0;
        }

        to {
            transform: scale(1);
            opacity: 1;
        }
    }

    /* Spinner personalizado */
    .spinner-border {
        border-width: 0.3rem;
        animation: spinner-grow 0.75s linear infinite;
    }

    @keyframes spinner-grow {
        0% {
            transform: rotate(0deg);
        }

        100% {
            transform: rotate(360deg);
        }
    }

    /* Efeito de pulso no título durante loading */
    .swal2-title i.bi-search {
        animation: pulse-icon 1.5s ease-in-out infinite;
    }

    @keyframes pulse-icon {

        0%,
        100% {
            transform: scale(1);
            opacity: 1;
        }

        50% {
            transform: scale(1.1);
            opacity: 0.8;
        }
    }

    /* Efeito smooth na barra de progresso */
    .swal2-timer-progress-bar {
        background: linear-gradient(90deg, #0066CC, #0099FF) !important;
    }

    /* Transição suave para os campos preenchidos */
    .form-control {
        transition: all 0.3s ease;
    }

    .form-control:focus {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0, 102, 204, 0.2);
    }

    /* Animação para campos preenchidos automaticamente */
    .campo-preenchido-auto {
        animation: fieldFillAnimation 0.5s ease-out;
    }

    @keyframes fieldFillAnimation {
        0% {
            background-color: #fff;
            transform: scale(1);
        }

        50% {
            background-color: #d4edff;
            transform: scale(1.03);
        }

        100% {
            background-color: #e7f3ff;
            transform: scale(1.02);
        }
    }

    /* Efeito de brilho no spinner */
    .spinner-border {
        position: relative;
    }

    .spinner-border::after {
        content: '';
        position: absolute;
        top: -5px;
        left: -5px;
        right: -5px;
        bottom: -5px;
        border-radius: 50%;
        background: radial-gradient(circle, rgba(0, 102, 204, 0.3) 0%, transparent 70%);
        animation: pulse-glow 1.5s ease-in-out infinite;
    }

    @keyframes pulse-glow {

        0%,
        100% {
            opacity: 0.3;
            transform: scale(0.95);
        }

        50% {
            opacity: 0.6;
            transform: scale(1.05);
        }
    }

    /* Estilo para o texto do CEP durante busca */
    .fw-bold.text-primary {
        letter-spacing: 2px;
        font-size: 1.2em;
        text-shadow: 0 2px 4px rgba(0, 102, 204, 0.2);
    }

    /* Pontos de loading animados */
    .loading-dots {
        display: inline-block;
        width: 24px;
        text-align: left;
        font-weight: bold;
        color: #0066CC;
    }

    /* Barra de progresso animada */
    .progress {
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }

    .progress-bar {
        transition: width 0.3s ease;
    }

    /* Efeito de entrada suave no popup de sucesso */
    .swal2-icon.swal2-success {
        animation: successZoom 0.5s ease-out;
    }

    @keyframes successZoom {
        0% {
            transform: scale(0);
            opacity: 0;
        }

        50% {
            transform: scale(1.1);
        }

        100% {
            transform: scale(1);
            opacity: 1;
        }
    }

    /* Destaque visual no ícone de busca */
    .bi-search {
        display: inline-block;
        color: #0066CC;
        filter: drop-shadow(0 2px 4px rgba(0, 102, 204, 0.3));
    }

    /* Sombra suave no card de resultado */
    .swal2-html-container .text-start p {
        padding: 8px;
        margin: 4px 0;
        border-radius: 4px;
        transition: background-color 0.2s ease;
    }

    .swal2-html-container .text-start p:hover {
        background-color: #f8f9fa;
    }

    /* Destaque para ícones de busca automática nos labels */
    .form-label .bi-search {
        animation: iconPulse 2s ease-in-out infinite;
        transition: all 0.3s ease;
    }

    .form-label .bi-search:hover {
        transform: scale(1.2);
        filter: drop-shadow(0 2px 6px rgba(0, 102, 204, 0.5));
    }

    @keyframes iconPulse {

        0%,
        100% {
            opacity: 0.7;
        }

        50% {
            opacity: 1;
        }
    }

    /* Notificação toast personalizada */
    .swal2-toast {
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15) !important;
    }

    /* Ícone de sucesso no toast */
    .swal2-toast .swal2-icon.swal2-success {
        border-color: #28a745 !important;
    }

    /* Alert info no popup */
    .alert-info {
        background-color: #e7f3ff;
        border-color: #b3d9ff;
        color: #004085;
    }

    /* Badge de destaque QSA */
    @keyframes fadeInBounce {
        0% {
            opacity: 0;
            transform: translateY(-20px) scale(0.8);
        }

        50% {
            transform: translateY(5px) scale(1.1);
        }

        100% {
            opacity: 1;
            transform: translateY(0) scale(1);
        }
    }

    .badge-destaque-qsa {
        box-shadow: 0 2px 8px rgba(40, 167, 69, 0.4);
        font-size: 0.75rem;
        padding: 4px 8px;
    }

    /* Destaque verde para campos do QSA */
    .campo-preenchido-qsa {
        background-color: #d4f4dd !important;
        border-color: #28a745 !important;
    }

    /* Alerta de múltiplos responsáveis */
    .alert-warning {
        background-color: #fff3cd;
        border-color: #ffc107;
        color: #856404;
    }

    .alert-secondary {
        background-color: #f8f9fa;
        border-color: #dee2e6;
        color: #6c757d;
    }
</style>

<script>

    $(document).ready(function () {
        const shipayFieldsWrapper = $('#shipayFields');
        const shipayDisabledAlert = $('#shipayDisabledAlert');

        function toggleShipayFields() {
            const enabled = $('#shipay_enabled').is(':checked');
            shipayFieldsWrapper.toggleClass('opacity-50', !enabled);
            shipayDisabledAlert.toggleClass('d-none', enabled);
        }

        $('#shipay_enabled').on('change', toggleShipayFields);

        // Toggle campos Portal Nacional de NFS-e
        const nfseNacionalFieldsWrapper = $('#nfseNacionalFields');
        const nfseNacionalDisabledAlert = $('#nfseNacionalDisabledAlert');

        function toggleNfseNacionalFields() {
            const enabled = $('#nfse_nacional_ativo').is(':checked');
            nfseNacionalFieldsWrapper.toggleClass('opacity-50', !enabled);
            nfseNacionalDisabledAlert.toggleClass('d-none', enabled);
        }

        toggleNfseNacionalFields(); // Estado inicial
        $('#nfse_nacional_ativo').on('change', toggleNfseNacionalFields);
        toggleShipayFields();
    });

    // Testar conexão Shipay
    function testarShipay(empresaId) {
        Swal.fire({
            title: 'Testando Conexão...',
            html: '<p>Conectando à API da Shipay...</p>',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        $.ajax({
            url: appUrl('/empresas/testar-shipay?id=' + empresaId),
            type: 'GET',
            dataType: 'json',
            success: function (response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Conexão OK!',
                        html: `
                            <div class="text-start">
                                <p><strong>Ambiente:</strong> ${response.data?.ambiente || 'N/A'}</p>
                                <p><strong>URL Base:</strong> ${response.data?.url_base || 'N/A'}</p>
                            </div>
                        `,
                        confirmButtonColor: '#6f42c1'
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro na Conexão',
                        text: response.message || 'Não foi possível conectar à Shipay',
                        confirmButtonColor: '#dc3545'
                    });
                }
            },
            error: function (xhr) {
                const erro = xhr.responseJSON || {};
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: erro.message || 'Erro ao testar conexão com Shipay',
                    confirmButtonColor: '#dc3545'
                });
            }
        });
    }

    // Função para inicializar eventos do formulário
    function inicializarFormularioEmpresa() {
        console.log('Inicializando formulário empresa...');

        // Verificar se o formulário existe
        const $form = $('#formEmpresa');
        if ($form.length === 0) {
            console.error('Formulário #formEmpresa não encontrado!');
            return false;
        }

        console.log('Formulário encontrado, registrando eventos...', $form.length);
        return $form;
    }

    $(document).ready(function () {
        console.log('[FORM] Document ready executado!');
        console.log('[FORM] Verificando dependências...');
        console.log('[FORM] jQuery disponível:', typeof $ !== 'undefined');
        console.log('[FORM] appUrl disponível:', typeof appUrl !== 'undefined');
        console.log('[FORM] APP_BASE_PATH:', window.APP_BASE_PATH);

        const $form = inicializarFormularioEmpresa();
        if (!$form) {
            console.error('[FORM] Não foi possível inicializar o formulário!');
            return;
        }

        console.log('[FORM] Formulário inicializado com sucesso!');

        // Função para processar o submit
        function processarSubmit(e) {
            console.log('========================================');
            console.log('[SUBMIT] === INÍCIO DO PROCESSAMENTO ===');
            console.log('[SUBMIT] Timestamp:', new Date().toISOString());
            console.log('[SUBMIT] Evento recebido:', e ? 'SIM' : 'NÃO');
            console.log('[SUBMIT] Tipo do evento:', e ? e.type : 'N/A');

            // Verificar se o formulário existe
            const $formCheck = $('#formEmpresa');
            if ($formCheck.length === 0) {
                console.error('[SUBMIT] ❌ ERRO: Formulário #formEmpresa não encontrado!');
                Swal.fire({
                    icon: 'error',
                    title: 'Erro',
                    text: 'Formulário não encontrado. Recarregue a página.',
                    confirmButtonText: 'OK'
                });
                return;
            }
            console.log('[SUBMIT] ✅ Formulário encontrado');

            if (e) {
                e.preventDefault();
                e.stopPropagation();
                console.log('[SUBMIT] Evento preventDefault e stopPropagation executados');
            }

            // Validação cliente mínima para evitar 400 por validação server-side
            let mensagens = [];
            const nome = ($('#name').val() || '').toString().trim();
            const documento = ($('#document').val() || '').replace(/\D/g, '');
            const email = ($('#email').val() || '').toString().trim();
            const telefone = ($('#phone').val() || '').toString().trim();

            console.log('[SUBMIT] Valores capturados:');
            console.log('[SUBMIT] - Nome:', nome);
            console.log('[SUBMIT] - Documento:', documento, '(tamanho:', documento.length + ')');
            console.log('[SUBMIT] - Email:', email);
            console.log('[SUBMIT] - Telefone:', telefone);

            if (nome.length === 0) {
                mensagens.push('Razão Social está vazia.');
            } else if (nome.length < 3) {
                mensagens.push('Razão Social deve ter ao menos 3 caracteres.');
            }
            if (documento.length === 0) {
                mensagens.push('CNPJ/CPF está vazio.');
            } else if (documento.length !== 14 && documento.length !== 11) {
                mensagens.push('CNPJ/CPF inválido (deve ter 11 ou 14 dígitos).');
            }
            // Email e telefone não são obrigatórios, apenas validar formato se preenchidos
            if (email.length > 0 && !email.match(/^[^\s@]+@[^\s@]+\.[^\s@]+$/)) {
                mensagens.push('Email inválido.');
            }

            if (mensagens.length > 0) {
                console.error('[SUBMIT] ❌ Validação falhou:', mensagens);
                Swal.fire({
                    icon: 'warning',
                    title: 'Campos obrigatórios faltando:',
                    html: '<ul style="text-align:left;">' + mensagens.map(m => `<li>${m}</li>`).join('') + '</ul>'
                });
                console.log('[SUBMIT] === FIM (Validação falhou) ===');
                console.log('========================================');
                return;
            }

            console.log('[SUBMIT] ✅ Validação passou, preparando dados...');

            const formData = new FormData($form[0]);
            const url = appUrl('<?= $isEdit ? "/empresas/editar" : "/empresas/criar" ?>');
            const isEdit = <?= $isEdit ? 'true' : 'false' ?>;

            console.log('[SUBMIT] URL gerada:', url);
            console.log('[SUBMIT] Modo:', isEdit ? 'EDIÇÃO' : 'CRIAÇÃO');
            console.log('[SUBMIT] FormData criado, listando campos...');

            // Listar todos os campos do FormData
            const formDataEntries = [];
            for (let pair of formData.entries()) {
                formDataEntries.push({ key: pair[0], value: pair[1] });
            }
            console.log('[SUBMIT] Campos do formulário:', formDataEntries);
            console.log('[SUBMIT] Total de campos:', formDataEntries.length);

            Swal.fire({
                title: 'Salvando...',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            console.log('[SUBMIT] Enviando requisição AJAX...');
            console.log('[SUBMIT] Configuração AJAX:');
            console.log('[SUBMIT] - URL:', url);
            console.log('[SUBMIT] - Method: POST');
            console.log('[SUBMIT] - processData: false');
            console.log('[SUBMIT] - contentType: false');
            console.log('[SUBMIT] - dataType: json');

            $.ajax({
                url: url,
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                dataType: 'json',
                beforeSend: function (xhr) {
                    console.log('[SUBMIT] ⏳ Requisição sendo enviada...');
                    // Definir header X-Requested-With para identificar como AJAX
                    xhr.setRequestHeader('X-Requested-With', 'XMLHttpRequest');
                    console.log('[SUBMIT] Header X-Requested-With definido');
                },
                success: function (response) {
                    console.log('[SUBMIT] ✅ Resposta recebida do servidor!');
                    console.log('[SUBMIT] Status: Sucesso');
                    console.log('[SUBMIT] Resposta completa:', response);
                    Swal.close();

                    if (response && response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Sucesso!',
                            text: response.message || 'Empresa salva com sucesso!',
                            showConfirmButton: false,
                            timer: 1500
                        }).then(() => {
                            window.location.href = appUrl('/empresas');
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro',
                            text: (response && response.message) ? response.message : 'Erro ao salvar a empresa',
                            confirmButtonText: 'OK'
                        });
                    }
                },
                error: function (xhr, status, error) {
                    console.error('[SUBMIT] ❌ ERRO na requisição AJAX!');
                    console.error('[SUBMIT] Detalhes do erro:');
                    console.error('[SUBMIT] - Status HTTP:', xhr.status);
                    console.error('[SUBMIT] - Status:', status);
                    console.error('[SUBMIT] - Error:', error);
                    console.error('[SUBMIT] - URL:', url);
                    console.error('[SUBMIT] - Response Text:', xhr.responseText);
                    console.error('[SUBMIT] - Response Headers:', xhr.getAllResponseHeaders());
                    console.error('[SUBMIT] - Ready State:', xhr.readyState);
                    Swal.close();

                    let errorMessage = 'Ocorreu um erro ao salvar a empresa';
                    let response = null;

                    try {
                        if (xhr.responseText) {
                            response = JSON.parse(xhr.responseText);
                        } else if (xhr.responseJSON) {
                            response = xhr.responseJSON;
                        }
                    } catch (e) {
                        console.error('Erro ao parsear resposta JSON:', e);
                    }

                    if (response && response.message) {
                        errorMessage = response.message;
                        if (response.errors && typeof response.errors === 'object') {
                            const errorsList = Object.values(response.errors).flat().join('<br>');
                            errorMessage += '<br><br>' + errorsList;
                        }
                    } else if (xhr.status === 0) {
                        errorMessage = 'Erro de conexão. Verifique sua internet.';
                    } else if (xhr.status === 404) {
                        errorMessage = 'Rota não encontrada. Verifique a configuração do sistema.';
                    } else if (xhr.status === 500) {
                        errorMessage = 'Erro interno do servidor. Verifique os logs do servidor.';
                    } else if (xhr.status === 403) {
                        errorMessage = 'Você não tem permissão para realizar esta ação.';
                    } else if (xhr.status === 422) {
                        errorMessage = 'Dados inválidos. Verifique os campos do formulário.';
                    } else if (xhr.responseText) {
                        errorMessage = 'Erro: ' + xhr.responseText.substring(0, 200);
                    }

                    Swal.fire({
                        icon: 'error',
                        title: 'Erro ao salvar',
                        html: errorMessage,
                        footer: xhr.status ? `Status HTTP: ${xhr.status}` : '',
                        confirmButtonText: 'OK'
                    });
                }
            });
        }

        // Também procurar por botão com texto "Salvar" - MÉTODO MAIS AGRESSIVO
        $(document).off('click.salvar', '#formEmpresa button.btn-primary').on('click.salvar', '#formEmpresa button.btn-primary', function (e) {
            const $btn = $(this);
            const text = $btn.text().toLowerCase().trim();
            const hasIcon = $btn.find('i.bi-check-circle').length > 0;
            const isSubmit = $btn.attr('type') === 'submit';

            console.log('[FORM] Click em botão btn-primary detectado:', {
                text: text,
                hasIcon: hasIcon,
                isSubmit: isSubmit,
                button: $btn[0]
            });

            if ((text.includes('salvar') && hasIcon) || isSubmit) {
                console.log('[FORM] 🔵 CLIQUE NO BOTÃO SALVAR (delegação por texto/ícone)');
                e.preventDefault();
                e.stopPropagation();
                e.stopImmediatePropagation();
                processarSubmit(e);
                return false;
            }
        });

        // MÉTODO ULTRA AGRESSIVO - captura QUALQUER clique em botão dentro do form
        $(document).off('click.ultra', '#formEmpresa button').on('click.ultra', '#formEmpresa button', function (e) {
            const $btn = $(this);
            const text = $btn.text().toLowerCase().trim();
            const isNavLink = $btn.hasClass('nav-link');

            // Ignorar botões de navegação
            if (isNavLink) {
                return true;
            }

            // Se tem "salvar" no texto, processar
            if (text.includes('salvar')) {
                console.log('[FORM] 🔵 CLIQUE NO BOTÃO SALVAR (método ultra agressivo)');
                e.preventDefault();
                e.stopPropagation();
                e.stopImmediatePropagation();
                processarSubmit(e);
                return false;
            }
        });

        console.log('[FORM] ✅ Delegação de eventos registrada no documento (3 métodos)');

        // Evento de click no botão de submit (garantir que funciona)
        // Aguardar um pouco para garantir que o DOM está totalmente carregado
        setTimeout(function () {
            console.log('[FORM] Procurando botão submit (após delay)...');

            // Procurar por múltiplos seletores possíveis
            let $btnSubmit = $('#formEmpresa button[type="submit"]');
            console.log('[FORM] Botões com type="submit" (seletor direto):', $btnSubmit.length);

            // Se não encontrou, procurar dentro do formulário
            if ($btnSubmit.length === 0) {
                $btnSubmit = $form.find('button[type="submit"]');
                console.log('[FORM] Botões com type="submit" (dentro do form):', $btnSubmit.length);
            }

            // Se ainda não encontrou, procurar pelo texto "Salvar"
            if ($btnSubmit.length === 0) {
                console.log('[FORM] Procurando botão com texto "Salvar"...');
                $('#formEmpresa button').each(function () {
                    const $btn = $(this);
                    const text = $btn.text().toLowerCase().trim();
                    const hasIcon = $btn.find('i.bi-check-circle').length > 0;
                    if (text.includes('salvar') || (hasIcon && $btn.hasClass('btn-primary'))) {
                        $btnSubmit = $btnSubmit.add($btn);
                    }
                });
                console.log('[FORM] Botões encontrados pelo texto "Salvar":', $btnSubmit.length);
            }

            // Se ainda não encontrou, pegar o botão btn-primary que não é tab
            if ($btnSubmit.length === 0) {
                console.log('[FORM] Procurando qualquer botão btn-primary (exceto tabs)...');
                $btnSubmit = $('#formEmpresa button.btn-primary').not('.nav-link, [data-bs-toggle="tab"]');
                console.log('[FORM] Botões btn-primary (sem tabs):', $btnSubmit.length);
            }

            console.log('[FORM] Botão submit final encontrado:', $btnSubmit.length);

            if ($btnSubmit.length > 0) {
                console.log('[FORM] ✅ Botão encontrado! HTML:', $btnSubmit[0].outerHTML.substring(0, 200));
                console.log('[FORM] ID do botão:', $btnSubmit.attr('id'));
                console.log('[FORM] Classes do botão:', $btnSubmit.attr('class'));

                // Remover eventos anteriores e adicionar novo
                $btnSubmit.off('click.submit').on('click.submit', function (e) {
                    console.log('[FORM] 🔵 CLIQUE NO BOTÃO SALVAR DETECTADO (método direto)');
                    e.preventDefault();
                    e.stopPropagation();
                    e.stopImmediatePropagation();
                    processarSubmit(e);
                    return false;
                });
                console.log('[FORM] Evento click direto registrado no botão');

                // Fallback adicional usando delegação de eventos
                $(document).off('click.submit', '#formEmpresa button[type="submit"]').on('click.submit', '#formEmpresa button[type="submit"]', function (e) {
                    console.log('[FORM] 🔵 CLIQUE NO BOTÃO SALVAR DETECTADO (método delegação)');
                    e.preventDefault();
                    e.stopPropagation();
                    e.stopImmediatePropagation();
                    processarSubmit(e);
                    return false;
                });
                console.log('[FORM] Evento click por delegação registrado');

                // Teste: adicionar listener nativo também
                $btnSubmit.each(function () {
                    this.addEventListener('click', function (e) {
                        console.log('[FORM] 🔵 CLIQUE NO BOTÃO SALVAR DETECTADO (método nativo)');
                        e.preventDefault();
                        e.stopPropagation();
                        processarSubmit(e);
                        return false;
                    }, true);
                });
                console.log('[FORM] Evento click nativo registrado');

                // Adicionar um teste visual - mudar cor do botão ao passar o mouse
                $btnSubmit.on('mouseenter', function () {
                    console.log('[FORM] 🖱️ Mouse sobre o botão Salvar');
                });

            } else {
                console.error('[FORM] ❌ Botão submit não encontrado!');
                console.error('[FORM] Formulário HTML:', $form[0]);
                console.error('[FORM] Todos os botões no formulário:', $form.find('button'));
                console.error('[FORM] HTML do formulário:', $form.html().substring(0, 500));
            }
        }, 200); // Fim do setTimeout

        // Adicionar função global para teste manual
        window.testarSubmit = function () {
            console.log('[TESTE] ========================================');
            console.log('[TESTE] Testando submit manualmente...');
            console.log('[TESTE] ========================================');
            processarSubmit(null);
        };

        // Adicionar função para verificar estado
        window.verificarEstadoForm = function () {
            console.log('[VERIFICAÇÃO] ========================================');
            console.log('[VERIFICAÇÃO] Estado do formulário:');
            console.log('[VERIFICAÇÃO] - Formulário existe:', $('#formEmpresa').length > 0);
            console.log('[VERIFICAÇÃO] - Botão submit existe:', $('#formEmpresa button[type="submit"]').length > 0);
            console.log('[VERIFICAÇÃO] - jQuery disponível:', typeof $ !== 'undefined');
            console.log('[VERIFICAÇÃO] - appUrl disponível:', typeof appUrl !== 'undefined');
            console.log('[VERIFICAÇÃO] - processarSubmit definido:', typeof processarSubmit !== 'undefined');
            console.log('[VERIFICAÇÃO] ========================================');
        };

        console.log('[FORM] Funções de teste disponíveis:');
        console.log('[FORM] - window.testarSubmit() - Testa o submit manualmente');
        console.log('[FORM] - window.verificarEstadoForm() - Verifica o estado do formulário');

        // Máscara CNPJ/CPF
        $('#document').on('input', function () {
            this.value = maskDocument(this.value);
        });

        // Busca CNPJ automaticamente - EMPRESA
        // Verificar se o campo existe antes de adicionar evento
        const $documentField = $('#document');
        if ($documentField.length === 0) {
            console.error('[CNPJ] Campo #document não encontrado!');
        } else {
            console.log('[CNPJ] Campo #document encontrado, registrando evento blur...');

            // Remover eventos anteriores para evitar duplicação
            $documentField.off('blur.cnpj').on('blur.cnpj', function (e) {
                console.log('[CNPJ] Evento blur disparado!');
                const $campo = $(this);
                let doc = $campo.val();

                // Remove formatação
                doc = doc.replace(/\D/g, '');

                console.log('[CNPJ] Campo CNPJ perdeu foco. Valor original:', $campo.val(), 'Valor limpo:', doc);

                // Verifica se é CNPJ válido (14 dígitos)
                if (doc.length === 14) {
                    console.log('[CNPJ] CNPJ válido detectado (14 dígitos). Iniciando busca...', doc);

                    // Mostra loading
                    Swal.fire({
                        title: 'Consultando CNPJ...',
                        html: '<div class="text-center"><div class="spinner-border text-primary mb-3" role="status"></div><p>Buscando dados na Receita Federal</p></div>',
                        allowOutsideClick: false,
                        showConfirmButton: false,
                        didOpen: () => {
                            Swal.showLoading();
                        }
                    });

                    // Garantir que o CNPJ está limpo (sem formatação)
                    const cnpjLimpo = doc.replace(/\D/g, '');
                    console.log('[CNPJ] CNPJ limpo para busca:', cnpjLimpo);

                    // Verificar se appUrl está disponível
                    if (typeof appUrl === 'undefined') {
                        console.error('[CNPJ] ERRO: appUrl não está definido!');
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro de Configuração',
                            text: 'A função appUrl não está disponível. Recarregue a página.',
                            confirmButtonText: 'OK'
                        });
                        return;
                    }

                    const apiUrl = appUrl('/api-cnpj.php?cnpj=' + cnpjLimpo);
                    console.log('[CNPJ] URL da API CNPJ gerada:', apiUrl);
                    console.log('[CNPJ] APP_BASE_PATH:', window.APP_BASE_PATH);
                    console.log('[CNPJ] Fazendo requisição AJAX para:', apiUrl);

                    $.ajax({
                        url: apiUrl,
                        type: 'GET',
                        dataType: 'json',
                        timeout: 30000,
                        cache: false,
                        success: function (response) {
                            console.log('Resposta da API CNPJ:', response);
                            Swal.close();

                            if (response && response.success && response.data) {
                                const data = response.data;

                                // Preenche os campos da empresa
                                if (data.razao_social) $('#name').val(data.razao_social).addClass('border-success');
                                if (data.nome_fantasia) $('#trade_name').val(data.nome_fantasia).addClass('border-success');
                                if (data.email) $('#email').val(data.email).addClass('border-success');
                                if (data.telefone) $('#phone').val(data.telefone).addClass('border-success');
                                if (data.cep) $('#zip_code').val(data.cep).addClass('border-success');
                                if (data.logradouro) $('#address').val(data.logradouro).addClass('border-success');
                                if (data.numero) $('#numero').val(data.numero).addClass('border-success');
                                if (data.complemento) $('#complemento').val(data.complemento).addClass('border-success');
                                if (data.bairro) $('#bairro').val(data.bairro).addClass('border-success');
                                if (data.municipio) $('#city').val(data.municipio).addClass('border-success');
                                if (data.uf) $('#state').val(data.uf).addClass('border-success');

                                // Remove a classe de destaque após 2 segundos
                                setTimeout(() => {
                                    $('.border-success').removeClass('border-success');
                                }, 2000);

                                Swal.fire({
                                    icon: 'success',
                                    title: 'CNPJ encontrado!',
                                    text: 'Os dados foram preenchidos automaticamente.',
                                    timer: 2000,
                                    showConfirmButton: false,
                                    toast: true,
                                    position: 'top-end'
                                });
                            } else {
                                Swal.fire({
                                    icon: 'warning',
                                    title: 'CNPJ não encontrado',
                                    text: (response && response.message) ? response.message : 'Não foi possível consultar este CNPJ na Receita Federal.',
                                    confirmButtonText: 'OK'
                                });
                            }
                        },
                        error: function (xhr, status, error) {
                            console.error('Erro ao buscar CNPJ:', {
                                xhr: xhr,
                                status: status,
                                error: error,
                                statusCode: xhr.status,
                                responseText: xhr.responseText,
                                url: apiUrl
                            });
                            Swal.close();

                            let errorMsg = 'Erro ao consultar CNPJ.';
                            if (status === 'timeout') {
                                errorMsg = 'Tempo de espera esgotado. Tente novamente.';
                            } else if (xhr.status === 0) {
                                errorMsg = 'Erro de conexão. Verifique sua internet.';
                            } else if (xhr.status === 404) {
                                errorMsg = 'Endpoint da API não encontrado. Verifique a configuração do sistema.';
                            } else if (xhr.status === 500) {
                                errorMsg = 'Erro interno do servidor ao consultar CNPJ.';
                            } else if (xhr.responseText) {
                                try {
                                    const errorResponse = JSON.parse(xhr.responseText);
                                    if (errorResponse.message) {
                                        errorMsg = errorResponse.message;
                                    }
                                } catch (e) {
                                    errorMsg = 'Erro ao processar resposta do servidor.';
                                }
                            }

                            Swal.fire({
                                icon: 'error',
                                title: 'Erro',
                                text: errorMsg,
                                confirmButtonText: 'OK',
                                footer: xhr.status ? `Status HTTP: ${xhr.status}` : ''
                            });
                        }
                    });
                } else if (doc.length > 0 && doc.length !== 11 && doc.length !== 14) {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Documento inválido',
                        text: 'O CNPJ deve ter 14 dígitos ou CPF deve ter 11 dígitos.',
                        timer: 3000,
                        showConfirmButton: false,
                        toast: true,
                        position: 'top-end'
                    });
                } else {
                    console.log('[CNPJ] Documento não é CNPJ válido. Tamanho:', doc.length);
                }
            });

            // Log de confirmação
            console.log('[CNPJ] Evento blur registrado no campo #document');
            console.log('[CNPJ] Para testar manualmente, execute no console: $("#document").trigger("blur")');

            // Adicionar função global para teste manual
            window.testarBuscaCNPJ = function (cnpj) {
                if (!cnpj) {
                    cnpj = $('#document').val().replace(/\D/g, '');
                }
                if (cnpj.length !== 14) {
                    console.error('[CNPJ TESTE] CNPJ deve ter 14 dígitos. Valor:', cnpj);
                    return;
                }
                console.log('[CNPJ TESTE] Testando busca com CNPJ:', cnpj);
                const apiUrl = appUrl('/api-cnpj.php?cnpj=' + cnpj);
                console.log('[CNPJ TESTE] URL:', apiUrl);
                $.ajax({
                    url: apiUrl,
                    type: 'GET',
                    dataType: 'json',
                    success: function (response) {
                        console.log('[CNPJ TESTE] Sucesso:', response);
                    },
                    error: function (xhr, status, error) {
                        console.error('[CNPJ TESTE] Erro:', { xhr, status, error, url: apiUrl });
                    }
                });
            };
            console.log('[CNPJ] Função de teste disponível: window.testarBuscaCNPJ("11222333000181")');
        } // fim do if ($documentField.length === 0)

        // Máscara CEP
        $('#zip_code').on('input', function () {
            this.value = maskZipCode(this.value);
        });

        // Busca CEP automaticamente
        $('#zip_code').on('blur', function () {
            const cep = this.value;
            if (cep.replace(/\D/g, '').length === 8) {
                buscarCep(cep, function (data) {
                    $('#address').val(data.logradouro);
                    $('#bairro').val(data.bairro);
                    $('#city').val(data.localidade);
                    $('#state').val(data.uf);
                });
            }
        });

        // Máscara Telefone
        $('#phone').on('input', function () {
            this.value = maskPhone(this.value);
        });

        // === MÁSCARAS E BUSCAS DO CONTADOR ===

        // Máscara CPF do Contador
        $('#contador_cpf').on('input', function () {
            this.value = maskCPF(this.value);
        });

        // Máscara CNPJ do Contador
        $('#contador_cnpj').on('input', function () {
            this.value = maskCNPJ(this.value);
        });

        // Busca CNPJ do Contador automaticamente na Receita Federal
        $('#contador_cnpj').on('blur', function () {
            const cnpj = this.value.replace(/\D/g, '');

            if (cnpj.length === 14) { // É CNPJ válido
                // Animação de loading personalizada
                Swal.fire({
                    title: '<i class="bi bi-building"></i> Consultando CNPJ...',
                    html: `
                    <div class="text-center">
                        <div class="spinner-border text-primary mb-3" role="status" style="width: 3rem; height: 3rem;">
                            <span class="visually-hidden">Carregando...</span>
                        </div>
                        <p class="text-muted mb-2">Buscando dados do escritório contábil na Receita Federal<span class="loading-dots"></span></p>
                        <p class="fw-bold text-primary mb-3">${this.value}</p>
                        <div class="progress" style="height: 4px;">
                            <div class="progress-bar progress-bar-striped progress-bar-animated bg-primary"
                                 role="progressbar" style="width: 100%"></div>
                        </div>
                    </div>
                `,
                    allowOutsideClick: false,
                    showConfirmButton: false,
                    customClass: {
                        popup: 'animated-popup'
                    },
                    didOpen: () => {
                        // Animação dos pontos
                        const dots = Swal.getHtmlContainer().querySelector('.loading-dots');
                        let count = 0;
                        const interval = setInterval(() => {
                            count = (count + 1) % 4;
                            dots.textContent = '.'.repeat(count);
                        }, 400);

                        Swal.getHtmlContainer().dataset.interval = interval;
                    },
                    willClose: () => {
                        const interval = Swal.getHtmlContainer().dataset.interval;
                        if (interval) clearInterval(interval);
                    }
                });

                $.ajax({
                    url: appUrl('/api-cnpj.php?cnpj=' + cnpj),
                    type: 'GET',
                    dataType: 'json',
                    success: function (response) {
                        if (response.success && response.data) {
                            const data = response.data;

                            // Extrai dados do responsável/contador do QSA (Quadro Societário)
                            let contadorNome = '';
                            let contadorCPF = '';
                            let qsaInfo = '';

                            if (data.qsa && Array.isArray(data.qsa) && data.qsa.length > 0) {
                                // Se tiver apenas um sócio/administrador, usa automaticamente
                                if (data.qsa.length === 1) {
                                    const socio = data.qsa[0];
                                    contadorNome = socio.nome || '';
                                    contadorCPF = socio.cpf_cnpj_socio || '';
                                    qsaInfo =
                                        `<p><strong><i class="bi bi-person-badge me-2 text-success"></i>Responsável:</strong> ${contadorNome}</p>`;
                                    if (contadorCPF) {
                                        qsaInfo +=
                                            `<p><strong><i class="bi bi-card-text me-2 text-success"></i>CPF:</strong> ${contadorCPF}</p>`;
                                    }
                                }
                                // Se tiver múltiplos, mostra o primeiro ou oferece escolha
                                else {
                                    const primeiro = data.qsa[0];
                                    contadorNome = primeiro.nome || '';
                                    contadorCPF = primeiro.cpf_cnpj_socio || '';
                                    qsaInfo = `
                                    <p><strong><i class="bi bi-person-badge me-2 text-warning"></i>Responsáveis (${data.qsa.length}):</strong></p>
                                    <div class="alert alert-warning small mb-2">
                                        <i class="bi bi-exclamation-triangle me-1"></i> Múltiplos responsáveis encontrados.
                                        O primeiro será preenchido: <strong>${contadorNome}</strong>
                                    </div>
                                `;
                                }
                            } else {
                                qsaInfo = `
                                <div class="alert alert-secondary small mb-2">
                                    <i class="bi bi-info-circle me-1"></i> Dados do responsável não disponíveis.
                                    Será necessário preencher manualmente.
                                </div>
                            `;
                            }

                            Swal.fire({
                                title: '<i class="bi bi-check-circle-fill text-success"></i> CNPJ Encontrado!',
                                html: `
                                <div class="text-start">
                                    <h6 class="mb-3 text-center">Deseja preencher os dados automaticamente?</h6>
                                    <div class="alert alert-info mb-3">
                                        <small><i class="bi bi-info-circle me-1"></i> Os dados abaixo serão preenchidos:</small>
                                    </div>
                                    ${qsaInfo}
                                    <hr class="my-2">
                                    <p><strong><i class="bi bi-building me-2"></i>Razão Social:</strong><br/>${data.razao_social || 'Não informado'}</p>
                                    <p><strong><i class="bi bi-geo-alt me-2"></i>Endereço:</strong><br/>${data.logradouro || ''} ${data.numero || ''}</p>
                                    <p><strong><i class="bi bi-pin-map me-2"></i>Bairro:</strong> ${data.bairro || 'Não informado'}</p>
                                    <p><strong><i class="bi bi-map me-2"></i>Cidade/UF:</strong> ${data.municipio || ''} - ${data.uf || ''}</p>
                                    <p><strong><i class="bi bi-mailbox me-2"></i>CEP:</strong> ${data.cep || 'Não informado'}</p>
                                    <p><strong><i class="bi bi-telephone me-2"></i>Telefone:</strong> ${data.telefone || 'Não informado'}</p>
                                    <p><strong><i class="bi bi-envelope me-2"></i>Email:</strong> ${data.email || 'Não informado'}</p>
                                </div>
                            `,
                                icon: 'question',
                                showCancelButton: true,
                                confirmButtonText: '<i class="bi bi-check-lg me-1"></i> Sim, preencher',
                                cancelButtonText: '<i class="bi bi-x-lg me-1"></i> Não',
                                confirmButtonColor: '#0066CC',
                                cancelButtonColor: '#6c757d',
                                customClass: {
                                    popup: 'animated-popup'
                                },
                                width: '650px'
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    // Preenche os campos com animação
                                    const campos = [{
                                        id: '#contador_nome',
                                        valor: contadorNome,
                                        destaque: true
                                    }, // Nome do contador/responsável
                                    {
                                        id: '#contador_cpf',
                                        valor: contadorCPF,
                                        destaque: true
                                    }, // CPF do contador
                                    {
                                        id: '#contador_razao_social',
                                        valor: data.razao_social
                                    },
                                    {
                                        id: '#contador_cep',
                                        valor: data.cep
                                    },
                                    {
                                        id: '#contador_logradouro',
                                        valor: data.logradouro
                                    },
                                    {
                                        id: '#contador_numero',
                                        valor: data.numero
                                    },
                                    {
                                        id: '#contador_complemento',
                                        valor: data.complemento
                                    },
                                    {
                                        id: '#contador_bairro',
                                        valor: data.bairro
                                    },
                                    {
                                        id: '#contador_municipio',
                                        valor: data.municipio
                                    },
                                    {
                                        id: '#contador_uf',
                                        valor: data.uf
                                    },
                                    {
                                        id: '#contador_telefone',
                                        valor: data.telefone
                                    },
                                    {
                                        id: '#contador_email',
                                        valor: data.email
                                    }
                                    ];

                                    campos.forEach((campo, index) => {
                                        if (campo
                                            .valor
                                        ) { // Só preenche se tiver valor
                                            setTimeout(() => {
                                                // Destaque especial para nome e CPF do contador
                                                const isDestaque = campo
                                                    .destaque === true;
                                                const corFundo =
                                                    isDestaque ?
                                                        '#d4f4dd' :
                                                        '#e7f3ff';
                                                const corBorda =
                                                    isDestaque ?
                                                        '#28a745' :
                                                        '#0066CC';

                                                $(campo.id).val(campo
                                                    .valor)
                                                    .addClass(
                                                        'campo-preenchido-auto'
                                                    )
                                                    .css({
                                                        'background-color': corFundo,
                                                        'border-color': corBorda,
                                                        'transform': 'scale(1.02)',
                                                        'font-weight': isDestaque ?
                                                            'bold' : 'normal'
                                                    });

                                                // Animação extra para campos em destaque
                                                if (isDestaque) {
                                                    $(campo.id).parent()
                                                        .prepend(
                                                            '<span class="badge bg-success badge-destaque-qsa" style="position: absolute; top: -10px; right: 10px; z-index: 10; animation: fadeInBounce 0.5s;">' +
                                                            '<i class="bi bi-check-circle me-1"></i>QSA' +
                                                            '</span>'
                                                        );

                                                    setTimeout(() => {
                                                        $('.badge-destaque-qsa')
                                                            .fadeOut(
                                                                400,
                                                                function () {
                                                                    $(this)
                                                                        .remove();
                                                                }
                                                            );
                                                    }, 2000);
                                                }

                                                // Remove o destaque após 1.5 segundos
                                                setTimeout(() => {
                                                    $(campo.id)
                                                        .removeClass(
                                                            'campo-preenchido-auto'
                                                        )
                                                        .css({
                                                            'background-color': '',
                                                            'border-color': '',
                                                            'transform': '',
                                                            'font-weight': ''
                                                        });
                                                }, 1500);
                                            }, index * 100);
                                        }
                                    });

                                    // Notificação de sucesso
                                    setTimeout(() => {
                                        const mensagemSucesso = contadorNome ?
                                            `Dados do escritório e do responsável (${contadorNome}) preenchidos com sucesso!` :
                                            'Todos os dados do escritório contábil foram preenchidos com sucesso.';

                                        Swal.fire({
                                            icon: 'success',
                                            title: 'Dados Preenchidos!',
                                            text: mensagemSucesso,
                                            showConfirmButton: false,
                                            timer: 3000,
                                            timerProgressBar: true,
                                            toast: true,
                                            position: 'top-end'
                                        });
                                    }, campos.length * 100 + 500);

                                    // Foco no próximo campo vazio (CRC se nome foi preenchido, senão nome)
                                    setTimeout(() => {
                                        if (contadorNome) {
                                            $('#contador_crc')
                                                .focus(); // Nome já foi preenchido, foca no CRC
                                        } else {
                                            $('#contador_nome')
                                                .focus(); // Nome vazio, foca nele
                                        }
                                    }, campos.length * 100 + 3000);
                                }
                            });
                        } else {
                            Swal.fire({
                                icon: 'warning',
                                title: 'CNPJ não encontrado',
                                text: response.message ||
                                    'Não foi possível consultar este CNPJ na Receita Federal.',
                                confirmButtonText: 'Ok',
                                confirmButtonColor: '#0066CC'
                            });
                        }
                    },
                    error: function () {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro na Consulta',
                            html: `
                            <p>Não foi possível consultar o CNPJ na Receita Federal.</p>
                            <p class="text-muted small mt-2">Possíveis causas:</p>
                            <ul class="text-start text-muted small">
                                <li>Sem conexão com a internet</li>
                                <li>Serviço da Receita Federal indisponível</li>
                                <li>CNPJ inválido ou inexistente</li>
                            </ul>
                        `,
                            confirmButtonText: 'Ok',
                            confirmButtonColor: '#0066CC'
                        });
                    }
                });
            }
        });

        // Função para testar certificado digital (exposta globalmente)
        window.testarCertificado = function(empresaId) {
            Swal.fire({
                title: 'Testando Certificado...',
                text: 'Aguarde enquanto validamos o certificado digital',
                allowOutsideClick: false,
                didOpen: () => Swal.showLoading()
            });

            $.ajax({
                url: appUrl('/empresas/testar-certificado?id=' + empresaId),
                type: 'GET',
                dataType: 'json',
                success: function (response) {
                    if (response.success && response.data) {
                        const data = response.data;

                        // Ícone e cor baseado na validade
                        let icon = data.valido ? 'success' : 'warning';
                        let titulo = data.valido ? '✅ Certificado Válido!' : '⚠️ Certificado Inválido';

                        // Cor do status
                        let statusColor = data.valido ? '#28a745' : '#dc3545';
                        let statusText = data.valido ?
                            `<span style="color: ${statusColor}; font-weight: bold;">✓ VÁLIDO</span>` :
                            `<span style="color: ${statusColor}; font-weight: bold;">✗ INVÁLIDO</span>`;

                        // Cor do CNPJ
                        let cnpjColor = data.cnpj_corresponde ? '#28a745' : '#dc3545';
                        let cnpjIcon = data.cnpj_corresponde ? '✓' : '✗';

                        // Dias restantes com cor
                        let diasColor = data.dias_restantes > 60 ? '#28a745' : (data.dias_restantes > 30 ?
                            '#ffc107' : '#dc3545');
                        let diasText =
                            `<span style="color: ${diasColor}; font-weight: bold;">${data.dias_restantes} dias</span>`;

                        // Monta HTML com as informações
                        const htmlContent = `
                    <div class="text-start">
                        <div class="alert ${data.valido ? 'alert-success' : 'alert-warning'} mb-3">
                            <h6 class="mb-2"><strong>Status do Certificado</strong></h6>
                            <p class="mb-1">${statusText}</p>
                            <p class="mb-0 small">Dias restantes: ${diasText}</p>
                        </div>

                        <div class="mb-3">
                            <h6 class="mb-2"><strong><i class="bi bi-building me-2"></i>Dados da Empresa (Certificado)</strong></h6>
                            <table class="table table-sm table-bordered">
                                <tr>
                                    <td width="40%"><strong>Razão Social:</strong></td>
                                    <td>${data.razao_social_certificado}</td>
                                </tr>
                                <tr>
                                    <td><strong>CNPJ:</strong></td>
                                    <td>${data.cnpj_certificado}</td>
                                </tr>
                                <tr>
                                    <td><strong>CNPJ da Empresa (Cadastro):</strong></td>
                                    <td>${data.cnpj_empresa}</td>
                                </tr>
                                <tr>
                                    <td><strong>CNPJ corresponde:</strong></td>
                                    <td><span style="color: ${cnpjColor}; font-weight: bold;">${cnpjIcon} ${data.cnpj_corresponde ? 'SIM' : 'NÃO'}</span></td>
                                </tr>
                            </table>
                        </div>

                        <div class="mb-3">
                            <h6 class="mb-2"><strong><i class="bi bi-calendar me-2"></i>Validade</strong></h6>
                            <table class="table table-sm table-bordered">
                                <tr>
                                    <td width="40%"><strong>Válido de:</strong></td>
                                    <td>${data.validade_de}</td>
                                </tr>
                                <tr>
                                    <td><strong>Válido até:</strong></td>
                                    <td>${data.validade_ate}</td>
                                </tr>
                                <tr>
                                    <td><strong>Dias restantes:</strong></td>
                                    <td>${diasText}</td>
                                </tr>
                            </table>
                        </div>

                        <div class="mb-3">
                            <h6 class="mb-2"><strong><i class="bi bi-info-circle me-2"></i>Informações Técnicas</strong></h6>
                            <table class="table table-sm table-bordered">
                                <tr>
                                    <td width="40%"><strong>Número de Série:</strong></td>
                                    <td><code>${data.serial_number || 'N/A'}</code></td>
                                </tr>
                                <tr>
                                    <td><strong>Emissor:</strong></td>
                                    <td>${data.emissor}</td>
                                </tr>
                            </table>
                        </div>
                    </div>
                `;

                        Swal.fire({
                            icon: icon,
                            title: titulo,
                            html: htmlContent,
                            width: '700px',
                            confirmButtonText: 'Fechar',
                            confirmButtonColor: '#0d6efd'
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Erro ao Testar Certificado',
                            text: response.message || 'Não foi possível testar o certificado'
                        });
                    }
                },
                error: function (xhr) {
                    const response = xhr.responseJSON;
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: response?.message || 'Erro ao testar certificado. Verifique a conexão.'
                    });
                }
            });
        }


    }); // Fim do $(document).ready

</script>

<?php
$content = ob_get_clean();
$activeMenu = 'empresas';
include ROOT_PATH . '/views/layouts/app.php';
?>
?>