<?php
ob_start();
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2><i class="bi bi-file-earmark-text me-2"></i> Contrato: <?= htmlspecialchars($contrato['numero_contrato']) ?></h2>
    </div>
    <div class="col-md-6 text-end">
        <a href="<?= url('/contratos/editar?id=' . $contrato['id']) ?>" class="btn btn-primary me-2">
            <i class="bi bi-pencil me-2"></i> Editar
        </a>
        <a href="<?= url('/contratos') ?>" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left me-2"></i> Voltar
        </a>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card mb-3">
            <div class="card-header">
                <i class="bi bi-info-circle me-2"></i> Informações do Contrato
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <strong>Número:</strong><br>
                        <?= htmlspecialchars($contrato['numero_contrato']) ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Tipo:</strong><br>
                        <?php
                        $tipos = [
                            'licenca_software' => 'Licença de Software',
                            'prestacao_servicos' => 'Prestação de Serviços',
                            'manutencao' => 'Manutenção',
                            'suporte' => 'Suporte',
                            'outro' => 'Outro'
                        ];
                        echo $tipos[$contrato['tipo']] ?? $contrato['tipo'];
                        ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Status:</strong><br>
                        <?php
                        $statusClasses = [
                            'rascunho' => 'secondary',
                            'ativo' => 'success',
                            'suspenso' => 'warning',
                            'cancelado' => 'danger',
                            'vencido' => 'dark',
                            'renovado' => 'info'
                        ];
                        $statusLabels = [
                            'rascunho' => 'Rascunho',
                            'ativo' => 'Ativo',
                            'suspenso' => 'Suspenso',
                            'cancelado' => 'Cancelado',
                            'vencido' => 'Vencido',
                            'renovado' => 'Renovado'
                        ];
                        $class = $statusClasses[$contrato['status']] ?? 'secondary';
                        $label = $statusLabels[$contrato['status']] ?? $contrato['status'];
                        ?>
                        <span class="badge bg-<?= $class ?>"><?= $label ?></span>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Data de Início:</strong><br>
                        <?= date('d/m/Y', strtotime($contrato['data_inicio'])) ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Data de Fim:</strong><br>
                        <?= $contrato['data_fim'] ? date('d/m/Y', strtotime($contrato['data_fim'])) : '<span class="text-muted">Sem término</span>' ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <strong>Data de Assinatura:</strong><br>
                        <?= $contrato['data_assinatura'] ? date('d/m/Y', strtotime($contrato['data_assinatura'])) : '<span class="text-muted">Não assinado</span>' ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mb-3">
            <div class="card-header">
                <i class="bi bi-building me-2"></i> Contratante
            </div>
            <div class="card-body">
                <?php if ($contrato['empresa_nome']): ?>
                    <p><strong>Empresa:</strong> <?= htmlspecialchars($contrato['empresa_nome']) ?></p>
                    <?php if ($contrato['empresa_cnpj']): ?>
                        <p><strong>CNPJ:</strong> <?= htmlspecialchars($contrato['empresa_cnpj']) ?></p>
                    <?php endif; ?>
                    <?php if ($contrato['empresa_endereco']): ?>
                        <p><strong>Endereço:</strong>
                            <?= htmlspecialchars($contrato['empresa_endereco']) ?>
                            <?= $contrato['empresa_numero'] ? ', ' . htmlspecialchars($contrato['empresa_numero']) : '' ?>
                            <?= $contrato['empresa_bairro'] ? ' - ' . htmlspecialchars($contrato['empresa_bairro']) : '' ?>
                            <?= $contrato['empresa_cidade'] ? ' - ' . htmlspecialchars($contrato['empresa_cidade']) : '' ?>
                            <?= $contrato['empresa_uf'] ? '/' . htmlspecialchars($contrato['empresa_uf']) : '' ?>
                            <?= $contrato['empresa_cep'] ? ' - CEP ' . htmlspecialchars($contrato['empresa_cep']) : '' ?>
                        </p>
                    <?php endif; ?>
                <?php elseif ($contrato['pessoa_nome']): ?>
                    <p><strong>Pessoa:</strong> <?= htmlspecialchars($contrato['pessoa_nome']) ?></p>
                    <?php if ($contrato['pessoa_document']): ?>
                        <p><strong>Documento:</strong> <?= htmlspecialchars($contrato['pessoa_document']) ?></p>
                    <?php endif; ?>
                <?php else: ?>
                    <p class="text-muted">Nenhum contratante associado</p>
                <?php endif; ?>
                <?php if (!empty($contrato['representante_legal'])): ?>
                    <p><strong>Representante Legal:</strong> <?= htmlspecialchars($contrato['representante_legal']) ?></p>
                <?php endif; ?>
                <?php if (!empty($contrato['cpf_representante'])): ?>
                    <p><strong>CPF do Representante:</strong> <?= htmlspecialchars($contrato['cpf_representante']) ?></p>
                <?php endif; ?>
            </div>
        </div>

        <?php if ($contrato['observacoes']): ?>
            <div class="card mb-3">
                <div class="card-header">
                    <i class="bi bi-chat-left-text me-2"></i> Observações
                </div>
                <div class="card-body">
                    <p><?= nl2br(htmlspecialchars($contrato['observacoes'])) ?></p>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <div class="col-md-4">
        <div class="card mb-3">
            <div class="card-header">
                <i class="bi bi-currency-dollar me-2"></i> Valores
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <strong>Valor Mensal:</strong><br>
                    <span class="fs-5 text-primary">R$ <?= number_format($contrato['valor_mensal'], 2, ',', '.') ?></span>
                </div>
                <div class="mb-3">
                    <strong>Valor Total:</strong><br>
                    <span class="fs-5 text-success">R$ <?= number_format($contrato['valor_total'], 2, ',', '.') ?></span>
                </div>
                <div class="mb-3">
                    <strong>Valor de Implantação:</strong><br>
                    <span class="fs-5">R$ <?= number_format($contrato['valor_implantacao'], 2, ',', '.') ?></span>
                </div>
                <?php if ($contrato['plano']): ?>
                    <div class="mb-3">
                        <strong>Plano:</strong><br>
                        <?= htmlspecialchars($contrato['plano']) ?>
                    </div>
                <?php endif; ?>
                <div class="mb-3">
                    <strong>Quantidade de Usuários:</strong><br>
                    <?= $contrato['quantidade_usuarios'] ?>
                </div>
                <?php if ($contrato['valor_usuario_adicional'] > 0): ?>
                    <div class="mb-3">
                        <strong>Valor por Usuário Adicional:</strong><br>
                        R$ <?= number_format($contrato['valor_usuario_adicional'], 2, ',', '.') ?>
                    </div>
                <?php endif; ?>
                <?php if ($contrato['forma_pagamento']): ?>
                    <div class="mb-3">
                        <strong>Forma de Pagamento:</strong><br>
                        <?= htmlspecialchars($contrato['forma_pagamento']) ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <i class="bi bi-info-circle me-2"></i> Informações do Sistema
            </div>
            <div class="card-body">
                <?php if ($contrato['criado_por_nome']): ?>
                    <div class="mb-2">
                        <strong>Criado por:</strong><br>
                        <?= htmlspecialchars($contrato['criado_por_nome']) ?>
                    </div>
                <?php endif; ?>
                <?php if ($contrato['atualizado_por_nome']): ?>
                    <div class="mb-2">
                        <strong>Atualizado por:</strong><br>
                        <?= htmlspecialchars($contrato['atualizado_por_nome']) ?>
                    </div>
                <?php endif; ?>
                <div class="mb-2">
                    <strong>Criado em:</strong><br>
                    <?= date('d/m/Y H:i', strtotime($contrato['created_at'])) ?>
                </div>
                <?php if ($contrato['updated_at']): ?>
                    <div class="mb-2">
                        <strong>Atualizado em:</strong><br>
                        <?= date('d/m/Y H:i', strtotime($contrato['updated_at'])) ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php
$content = ob_get_clean();
$activeMenu = 'contratos';
include ROOT_PATH . '/views/layouts/app.php';
?>