<?php

/**
 * View: Impressão de Contrato
 * Layout Corporativo Profissional
 */

// Dados do contratante (empresa ou pessoa)
$contratanteNome = '';
$contratanteCnpj = '';
$contratanteEndereco = '';
$contratanteRepresentante = '';

if ($contrato['empresa_nome']) {
    $contratanteNome = $contrato['empresa_nome'];
    $contratanteCnpj = $contrato['empresa_cnpj'] ?? '[●]';
    $contratanteEndereco = ($contrato['empresa_endereco'] ?? '') .
        ($contrato['empresa_numero'] ? ', ' . $contrato['empresa_numero'] : '') .
        ($contrato['empresa_bairro'] ? ' - ' . $contrato['empresa_bairro'] : '') .
        ($contrato['empresa_cidade'] ? ' - ' . $contrato['empresa_cidade'] : '') .
        ($contrato['empresa_uf'] ? '/' . $contrato['empresa_uf'] : '') .
        ($contrato['empresa_cep'] ? ' - CEP ' . $contrato['empresa_cep'] : '');
    if (empty(trim($contratanteEndereco))) {
        $contratanteEndereco = '[●]';
    }
} elseif ($contrato['pessoa_nome']) {
    $contratanteNome = $contrato['pessoa_nome'];
    $contratanteCnpj = $contrato['pessoa_document'] ?? '[●]';
    $contratanteEndereco = ($contrato['pessoa_endereco'] ?? '') .
        ($contrato['pessoa_numero'] ? ', ' . $contrato['pessoa_numero'] : '') .
        ($contrato['pessoa_bairro'] ? ' - ' . $contrato['pessoa_bairro'] : '') .
        ($contrato['pessoa_cidade'] ? ' - ' . $contrato['pessoa_cidade'] : '') .
        ($contrato['pessoa_uf'] ? '/' . $contrato['pessoa_uf'] : '') .
        ($contrato['pessoa_cep'] ? ' - CEP ' . $contrato['pessoa_cep'] : '');
    if (empty(trim($contratanteEndereco))) {
        $contratanteEndereco = '[●]';
    }
} else {
    $contratanteNome = '[●]';
    $contratanteCnpj = '[●]';
    $contratanteEndereco = '[●]';
}

$contratanteRepresentante = $contrato['representante_legal'] ?? '[●]';
$contratanteCpf = $contrato['cpf_representante'] ?? '';

// Dados da empresa Systhema
$empresaSysthemaNome = $empresa['razao_social'] ?? $empresa['nome_fantasia'] ?? 'Systhema Tecnologia Ltda.';
$empresaSysthemaCnpj = $empresa['cnpj'] ?? '30.305.332/0001-45';
$empresaSysthemaEndereco = ($empresa['endereco'] ?? 'Av. Recife, 3250 – Sala 402 – Areias') .
    ($empresa['numero'] ? ', ' . $empresa['numero'] : '') .
    ($empresa['bairro'] ? ' - ' . $empresa['bairro'] : '') .
    ($empresa['cidade'] ? ' - ' . $empresa['cidade'] : ' - Recife') .
    ($empresa['uf'] ? '/' . $empresa['uf'] : '/PE') .
    ($empresa['cep'] ? ' - CEP ' . $empresa['cep'] : ' - CEP 50781-001');

// Tipo de contrato
$tipos = [
    'licenca_software' => 'Licença de Software',
    'site' => 'Site',
    'loja_virtual' => 'Loja Virtual',
    'treinamento_adicional' => 'Treinamento Adicional',
    'prestacao_servicos' => 'Prestação de Serviços',
    'manutencao' => 'Manutenção',
    'suporte' => 'Suporte',
    'outro' => 'Outro'
];
$tipoContrato = $tipos[$contrato['tipo']] ?? $contrato['tipo'];

// Plano
$plano = $contrato['plano'] ?? '[●]';

// Valores
$valorMensal = number_format($contrato['valor_mensal'], 2, ',', '.');
$valorTotal = number_format($contrato['valor_total'], 2, ',', '.');
$valorImplantacao = $contrato['valor_implantacao'] > 0 ? number_format($contrato['valor_implantacao'], 2, ',', '.') : '[●]';
$valorUsuarioAdicional = $contrato['valor_usuario_adicional'] > 0 ? number_format($contrato['valor_usuario_adicional'], 2, ',', '.') : '[●]';
$quantidadeUsuarios = $contrato['quantidade_usuarios'] ?? '[●]';
$formaPagamento = $contrato['forma_pagamento'] ?? '[●]';

// Datas
$dataInicio = $contrato['data_inicio'] ? date('d/m/Y', strtotime($contrato['data_inicio'])) : '[●]';
$dataFim = $contrato['data_fim'] ? date('d/m/Y', strtotime($contrato['data_fim'])) : '[●]';
$dataAssinatura = $contrato['data_assinatura'] ? date('d/m/Y', strtotime($contrato['data_assinatura'])) : '[●]';
?>
<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contrato <?= htmlspecialchars($contrato['numero_contrato']) ?></title>
    <style>
        @page {
            size: A4;
            margin: 3cm 3.5cm 4cm 3.5cm;
        }

        @page: first {
            margin-top: 3cm;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Georgia', 'Times New Roman', serif;
            font-size: 11pt;
            line-height: 1.7;
            color: #1a1a1a;
            background: white;
            text-align: justify;
        }

        .document-wrapper {
            max-width: 100%;
            margin: 0 auto;
            position: relative;
        }

        /* Cabeçalho Corporativo */
        .header {
            text-align: center;
            margin-bottom: 3rem;
            padding-bottom: 2rem;
            border-bottom: 4px solid #1e3a5f;
            position: relative;
        }

        .header::after {
            content: '';
            position: absolute;
            bottom: -4px;
            left: 50%;
            transform: translateX(-50%);
            width: 200px;
            height: 4px;
            background: #2c5f8d;
        }

        .contract-title {
            font-size: 18pt;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 2px;
            margin-bottom: 1rem;
            line-height: 1.3;
            color: #1e3a5f;
        }

        .contract-subtitle {
            font-size: 11pt;
            color: #555;
            font-weight: normal;
            text-transform: none;
            letter-spacing: 0.5px;
            margin-top: 0.5rem;
        }

        .contract-number {
            font-size: 13pt;
            font-weight: bold;
            margin-top: 1.5rem;
            color: #1e3a5f;
            background: #f0f4f8;
            padding: 0.75rem 1.5rem;
            display: inline-block;
            border-radius: 4px;
            border: 2px solid #1e3a5f;
        }

        /* Seções */
        .section {
            margin-bottom: 2.5rem;
            page-break-inside: avoid;
        }

        .section-title {
            font-size: 13pt;
            font-weight: bold;
            text-transform: uppercase;
            margin-bottom: 1.25rem;
            margin-top: 2rem;
            color: #1e3a5f;
            letter-spacing: 1px;
            border-bottom: 2px solid #2c5f8d;
            padding-bottom: 0.5rem;
            position: relative;
        }

        .section-title::before {
            content: '';
            position: absolute;
            left: 0;
            bottom: -2px;
            width: 60px;
            height: 2px;
            background: #4a90c2;
        }

        .clause {
            margin-bottom: 1.25rem;
            text-indent: 0;
            line-height: 1.8;
        }

        .clause-number {
            font-weight: bold;
            color: #1e3a5f;
            margin-right: 0.5rem;
            font-size: 11.5pt;
        }

        /* Listas */
        ul {
            margin-left: 2.5rem;
            margin-bottom: 1.25rem;
            margin-top: 0.75rem;
        }

        li {
            margin-bottom: 0.75rem;
            line-height: 1.8;
            position: relative;
        }

        li::marker {
            color: #2c5f8d;
            font-weight: bold;
        }

        /* Partes do contrato - Design Moderno */
        .parties {
            margin-bottom: 3rem;
            background: linear-gradient(to bottom, #f8fafc 0%, #ffffff 100%);
            padding: 2rem;
            border: 2px solid #e0e7ef;
            border-left: 6px solid #1e3a5f;
            border-radius: 6px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
        }

        .parties-intro {
            text-align: center;
            font-weight: bold;
            margin-bottom: 2rem;
            color: #1e3a5f;
            font-size: 11.5pt;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .party {
            margin-bottom: 2rem;
            padding: 1.5rem;
            background: white;
            border-radius: 4px;
            border: 1px solid #e0e7ef;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
        }

        .party:last-child {
            margin-bottom: 0;
        }

        .party-title {
            font-size: 12pt;
            font-weight: bold;
            text-transform: uppercase;
            margin-bottom: 1rem;
            color: #1e3a5f;
            letter-spacing: 1px;
            padding-bottom: 0.5rem;
            border-bottom: 2px solid #2c5f8d;
            display: inline-block;
            width: 100%;
        }

        .party-info {
            margin-left: 0.5rem;
        }

        .party-info p {
            margin-bottom: 0.5rem;
            line-height: 1.7;
        }

        .party-name {
            font-weight: bold;
            font-size: 12pt;
            color: #1a1a1a;
            margin-bottom: 0.75rem;
            display: block;
        }

        .party-detail {
            color: #444;
            font-size: 10.5pt;
        }

        .party-detail strong {
            color: #1e3a5f;
            font-weight: 600;
        }

        /* Valores destacados */
        .value-highlight {
            font-weight: bold;
            color: #1e3a5f;
            font-size: 11.5pt;
            background: #f0f4f8;
            padding: 0.2rem 0.5rem;
            border-radius: 3px;
            display: inline-block;
        }

        .value-box {
            background: linear-gradient(135deg, #f0f4f8 0%, #e8f0f6 100%);
            border: 2px solid #2c5f8d;
            border-radius: 6px;
            padding: 1.5rem;
            margin: 1.5rem 0;
        }

        .value-item {
            display: flex;
            justify-content: space-between;
            padding: 0.75rem 0;
            border-bottom: 1px solid #d0d9e3;
        }

        .value-item:last-child {
            border-bottom: none;
        }

        .value-label {
            font-weight: 600;
            color: #1e3a5f;
        }

        .value-amount {
            font-weight: bold;
            color: #1e3a5f;
            font-size: 12pt;
        }

        /* Rodapé de assinaturas */
        .signatures {
            margin-top: 5rem;
            padding-top: 3rem;
            border-top: 3px solid #1e3a5f;
            page-break-inside: avoid;
            position: relative;
            text-align: center;
        }

        .signatures::before {
            content: '';
            position: absolute;
            top: -3px;
            left: 50%;
            transform: translateX(-50%);
            width: 150px;
            height: 3px;
            background: #2c5f8d;
        }

        .signatures-container {
            display: flex;
            justify-content: center;
            gap: 4rem;
            margin-bottom: 3rem;
            flex-wrap: wrap;
            align-items: flex-start;
        }

        .signature-box {
            display: inline-block;
            width: 300px;
            text-align: center;
            padding: 1.5rem;
            background: #f8fafc;
            border-radius: 6px;
            border: 1px solid #e0e7ef;
        }

        .signature-company {
            font-weight: bold;
            font-size: 11.5pt;
            margin-bottom: 1.5rem;
            min-height: 2.5rem;
            color: #1e3a5f;
            padding-bottom: 0.75rem;
            border-bottom: 2px solid #2c5f8d;
        }

        .signature-label {
            font-size: 10pt;
            text-transform: uppercase;
            margin-bottom: 4rem;
            color: #555;
            font-weight: 600;
            letter-spacing: 0.5px;
        }

        .signature-line {
            border-top: 2px solid #1e3a5f;
            width: 90%;
            margin: 0 auto;
            padding-top: 0.75rem;
            font-size: 9pt;
            color: #666;
            min-height: 3rem;
        }

        .signature-footer {
            text-align: center;
            margin-top: 3rem;
            padding-top: 2rem;
            border-top: 1px solid #e0e7ef;
            font-size: 10.5pt;
            color: #555;
            font-style: italic;
        }

        /* Observações */
        .observations {
            background: linear-gradient(to right, #fff9e6 0%, #fffef5 100%);
            border-left: 5px solid #d4a017;
            padding: 1.5rem 2rem;
            margin: 2rem 0;
            border-radius: 4px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
        }

        .observations-title {
            font-weight: bold;
            color: #8b6914;
            margin-bottom: 0.75rem;
            font-size: 11pt;
        }

        /* Anexos */
        .annex {
            margin-top: 3rem;
            page-break-before: auto;
            background: #f8fafc;
            padding: 2rem;
            border-radius: 6px;
            border: 1px solid #e0e7ef;
        }

        .annex-title {
            font-size: 12pt;
            font-weight: bold;
            margin-bottom: 1.5rem;
            text-transform: uppercase;
            color: #1e3a5f;
            border-bottom: 2px solid #2c5f8d;
            padding-bottom: 0.5rem;
            letter-spacing: 0.5px;
        }

        /* Texto centralizado */
        .text-center {
            text-align: center;
        }

        .intro-text {
            text-align: center;
            font-weight: bold;
            margin: 2.5rem 0;
            color: #1e3a5f;
            font-size: 11.5pt;
            font-style: italic;
        }

        /* Quebras de página */
        .page-break {
            page-break-before: always;
        }

        /* Espaçamento */
        .mb-1 {
            margin-bottom: 0.5rem;
        }

        .mb-2 {
            margin-bottom: 1rem;
        }

        .mb-3 {
            margin-bottom: 1.5rem;
        }

        .mb-4 {
            margin-bottom: 2rem;
        }

        .mt-2 {
            margin-top: 1rem;
        }

        .mt-3 {
            margin-top: 1.5rem;
        }

        .mt-4 {
            margin-top: 2rem;
        }

        /* Impressão */
        @media print {
            body {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }

            .section {
                page-break-inside: avoid;
            }

            .signatures {
                page-break-inside: avoid;
            }

            .parties {
                page-break-inside: avoid;
            }

            .signatures-container {
                display: block;
                text-align: center;
            }

            .signature-box {
                display: inline-block;
                vertical-align: top;
                margin: 0 3rem;
            }

            @page {
                margin: 3cm 3.5cm 4cm 3.5cm;
            }
        }

        /* Tela */
        @media screen {
            body {
                padding: 2rem;
                background: #f0f2f5;
            }

            .document-wrapper {
                background: white;
                padding: 4rem;
                box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
                max-width: 210mm;
                margin: 0 auto;
                border-radius: 8px;
            }
        }

        /* Melhorias visuais */
        strong {
            color: #1e3a5f;
            font-weight: 600;
        }

        .highlight-box {
            background: #f0f4f8;
            border-left: 4px solid #2c5f8d;
            padding: 1rem 1.5rem;
            margin: 1.5rem 0;
            border-radius: 4px;
        }
    </style>
</head>

<body>
    <div class="document-wrapper">
        <!-- Cabeçalho Corporativo -->
        <div class="header">
            <div class="contract-title">
                CONTRATO DE LICENÇA DE USO DE SOFTWARE,<br>
                <span class="contract-subtitle">SUPORTE TÉCNICO E SERVIÇOS CORRELATOS</span>
            </div>
            <div class="contract-number">
                Contrato Nº: <?= htmlspecialchars($contrato['numero_contrato']) ?>
            </div>
        </div>

        <!-- Partes do Contrato -->
        <div class="parties">
            <p class="parties-intro">Pelo presente instrumento, as partes:</p>

            <div class="party">
                <div class="party-title">CONTRATADA</div>
                <div class="party-info">
                    <span class="party-name"><?= htmlspecialchars($empresaSysthemaNome) ?></span>
                    <p class="party-detail"><strong>CNPJ:</strong> <?= htmlspecialchars($empresaSysthemaCnpj) ?></p>
                    <p class="party-detail"><strong>Endereço:</strong> <?= htmlspecialchars($empresaSysthemaEndereco) ?>
                    </p>
                    <p class="party-detail"><strong>E-mail:</strong>
                        <?= htmlspecialchars($empresa['email'] ?? 'contato@Systhema.com.br') ?></p>
                    <p class="party-detail"><strong>Telefone:</strong>
                        <?= htmlspecialchars($empresa['telefone'] ?? '(81) 99710-2197') ?></p>
                </div>
            </div>

            <div class="party">
                <div class="party-title">CONTRATANTE</div>
                <div class="party-info">
                    <span class="party-name"><?= htmlspecialchars($contratanteNome) ?></span>
                    <p class="party-detail"><strong>CNPJ/CPF:</strong> <?= htmlspecialchars($contratanteCnpj) ?></p>
                    <p class="party-detail"><strong>Endereço:</strong> <?= htmlspecialchars($contratanteEndereco) ?></p>
                    <p class="party-detail"><strong>Representante Legal:</strong>
                        <?= htmlspecialchars($contratanteRepresentante) ?></p>
                    <?php if ($contratanteCpf): ?>
                        <p class="party-detail"><strong>CPF do Representante:</strong>
                            <?= htmlspecialchars($contratanteCpf) ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <p class="intro-text">Têm entre si justo e contratado o seguinte:</p>

        <!-- Cláusulas -->
        <div class="section">
            <div class="section-title">1. OBJETO DO CONTRATO</div>
            <div class="clause">
                <span class="clause-number">1.1.</span> O presente contrato tem por objeto a concessão de licença de uso
                não exclusiva, não transferível e limitada do software Systhema ERP, bem como a prestação dos serviços
                de suporte, manutenção, atualizações e demais serviços acessórios descritos neste instrumento e em seus
                anexos.
            </div>
            <div class="clause">
                <span class="clause-number">1.2.</span> Tipo de contrato:
                <strong><?= htmlspecialchars($tipoContrato) ?></strong>
            </div>
            <div class="clause">
                <span class="clause-number">1.3.</span> O software Systhema é composto pelos módulos, funcionalidades e
                características técnicas descritas no <strong>ANEXO I – Descrição Técnica do ERP</strong>.
            </div>
        </div>

        <div class="section">
            <div class="section-title">2. CONCESSÃO DE LICENÇA</div>
            <div class="clause">
                <span class="clause-number">2.1.</span> A CONTRATADA concede à CONTRATANTE licença de uso do Systhema
                ERP pelo prazo de vigência deste contrato, restrita aos usuários e limites descritos na Cláusula 6 deste
                instrumento.
            </div>
            <div class="clause">
                <span class="clause-number">2.2.</span> A licença não implica transferência de propriedade intelectual,
                permanecendo o software integralmente sob titularidade da CONTRATADA.
            </div>
        </div>

        <div class="section">
            <div class="section-title">3. SUPORTE E ATUALIZAÇÕES</div>
            <div class="clause">
                <span class="clause-number">3.1.</span> O suporte será prestado de segunda a sexta-feira, das 08h às
                18h, por chat, e-mail ou telefone.
            </div>
            <div class="clause">
                <span class="clause-number">3.2.</span> O suporte cobre:
            </div>
            <ul>
                <li>esclarecimento de dúvidas;</li>
                <li>correções de falhas;</li>
                <li>orientações de uso;</li>
                <li>atualizações periódicas de segurança e melhorias.</li>
            </ul>
            <div class="clause">
                <span class="clause-number">3.3.</span> Customizações, integrações externas, relatórios personalizados e
                desenvolvimentos específicos não estão incluídos no suporte, sendo contratados à parte.
            </div>
        </div>

        <div class="section">
            <div class="section-title">4. DISPONIBILIDADE E ACESSO</div>
            <div class="clause">
                <span class="clause-number">4.1.</span> O Systhema permanecerá disponível 24 horas por dia, 7 dias por
                semana, salvo interrupções motivadas por:
            </div>
            <ul>
                <li>manutenção programada;</li>
                <li>caso fortuito ou força maior;</li>
                <li>falhas externas fora do controle da CONTRATADA.</li>
            </ul>
            <div class="clause">
                <span class="clause-number">4.2.</span> Manutenções programadas serão informadas com antecedência mínima
                de 24 horas.
            </div>
        </div>

        <div class="section">
            <div class="section-title">5. OBRIGAÇÕES DAS PARTES</div>
            <div class="clause">
                <span class="clause-number">5.1.</span> Obrigações da CONTRATADA:
            </div>
            <ul>
                <li>fornecer acesso ao ERP dentro dos parâmetros contratados;</li>
                <li>manter integridade e segurança dos dados;</li>
                <li>realizar backups conforme <strong>ANEXO II – Política de Backup</strong>;</li>
                <li>prestar suporte técnico.</li>
            </ul>
            <div class="clause">
                <span class="clause-number">5.2.</span> Obrigações da CONTRATANTE:
            </div>
            <ul>
                <li>utilizar o sistema conforme orientações técnicas;</li>
                <li>preservar sigilo de logins e senhas;</li>
                <li>manter seus equipamentos e internet em condições adequadas;</li>
                <li>pagar pontualmente os valores contratados.</li>
            </ul>
        </div>

        <div class="section">
            <div class="section-title">6. VALORES, PLANOS E LIMITES</div>
            <div class="value-box">
                <div class="value-item">
                    <span class="value-label">Plano Escolhido:</span>
                    <span class="value-amount"><?= htmlspecialchars($plano) ?></span>
                </div>
                <div class="value-item">
                    <span class="value-label">Quantidade de Usuários:</span>
                    <span class="value-amount"><?= htmlspecialchars($quantidadeUsuarios) ?></span>
                </div>
                <div class="value-item">
                    <span class="value-label">Valor Mensal da Licença:</span>
                    <span class="value-amount">R$ <?= htmlspecialchars($valorMensal) ?></span>
                </div>
                <?php if ($valorImplantacao !== '[●]'): ?>
                    <div class="value-item">
                        <span class="value-label">Valor da Implantação:</span>
                        <span class="value-amount">R$ <?= htmlspecialchars($valorImplantacao) ?></span>
                    </div>
                <?php endif; ?>
                <?php if ($valorUsuarioAdicional !== '[●]'): ?>
                    <div class="value-item">
                        <span class="value-label">Valor por Usuário Adicional:</span>
                        <span class="value-amount">R$ <?= htmlspecialchars($valorUsuarioAdicional) ?></span>
                    </div>
                <?php endif; ?>
                <?php if ($valorTotal && $valorTotal !== '0,00'): ?>
                    <div class="value-item" style="border-top: 2px solid #2c5f8d; margin-top: 0.5rem; padding-top: 1rem;">
                        <span class="value-label" style="font-size: 12.5pt;">Valor Total do Contrato:</span>
                        <span class="value-amount" style="font-size: 14pt; color: #1e3a5f;">R$
                            <?= htmlspecialchars($valorTotal) ?></span>
                    </div>
                <?php endif; ?>
                <?php if ($formaPagamento !== '[●]'): ?>
                    <div class="value-item">
                        <span class="value-label">Forma de Pagamento:</span>
                        <span class="value-amount"><?= htmlspecialchars($formaPagamento) ?></span>
                    </div>
                <?php endif; ?>
            </div>
            <div class="clause">
                <span class="clause-number">6.2.</span> A cobrança ocorrerá mensalmente por boleto, Pix ou cartão,
                conforme escolha da CONTRATANTE.
            </div>
            <div class="clause">
                <span class="clause-number">6.3.</span> O não pagamento por 15 dias permite a suspensão temporária do
                acesso; por 30 dias, permite o cancelamento definitivo.
            </div>
        </div>

        <div class="section">
            <div class="section-title">7. PRAZO E RESCISÃO</div>
            <div class="clause">
                <span class="clause-number">7.1.</span> O contrato tem vigência de
                <strong><?= htmlspecialchars($dataInicio) ?></strong> a
                <strong><?= htmlspecialchars($dataFim) ?></strong>.
            </div>
            <div class="clause">
                <span class="clause-number">7.2.</span> Pode ser rescindido por qualquer das partes mediante aviso
                prévio de 30 dias.
            </div>
            <div class="clause">
                <span class="clause-number">7.3.</span> Em caso de rescisão por inadimplência, os valores vencidos
                permanecem exigíveis.
            </div>
        </div>

        <div class="section">
            <div class="section-title">8. PROPRIEDADE INTELECTUAL</div>
            <div class="clause">
                <span class="clause-number">8.1.</span> O software, seus módulos, código-fonte, layout e estrutura
                pertencem exclusivamente à CONTRATADA.
            </div>
            <div class="clause">
                <span class="clause-number">8.2.</span> É vedado à CONTRATANTE:
            </div>
            <ul>
                <li>copiar, distribuir ou comercializar o ERP;</li>
                <li>permitir engenharia reversa;</li>
                <li>usar o sistema para fins ilícitos.</li>
            </ul>
        </div>

        <div class="section">
            <div class="section-title">9. PROTEÇÃO DE DADOS E LGPD</div>
            <div class="clause">
                <span class="clause-number">9.1.</span> As partes cumprem a Lei Geral de Proteção de Dados (Lei
                13.709/2018).
            </div>
            <div class="clause">
                <span class="clause-number">9.2.</span> A CONTRATADA adota medidas técnicas e administrativas adequadas
                para proteção dos dados processados pelo ERP.
            </div>
        </div>

        <div class="section">
            <div class="section-title">10. BACKUP E SEGURANÇA</div>
            <div class="clause">
                <span class="clause-number">10.1.</span> A rotina completa de backup aplicada ao ambiente está descrita
                detalhadamente no <strong>ANEXO II – Política de Backup</strong>.
            </div>
            <div class="clause">
                <span class="clause-number">10.2.</span> A CONTRATADA não se responsabiliza por perdas de dados
                decorrentes de ações da CONTRATANTE, como exclusões, alterações indevidas ou inserção incorreta de
                informações.
            </div>
        </div>

        <div class="section">
            <div class="section-title">11. DISPOSIÇÕES GERAIS</div>
            <div class="clause">
                <span class="clause-number">11.1.</span> Este contrato não gera vínculo societário ou empregatício entre
                as partes.
            </div>
            <div class="clause">
                <span class="clause-number">11.2.</span> Alterações só terão validade se realizadas por termo aditivo
                assinado por ambas as partes.
            </div>
            <div class="clause">
                <span class="clause-number">11.3.</span> O foro eleito é o da Comarca de Recife/PE.
            </div>
        </div>

        <?php if (!empty($contrato['observacoes'])): ?>
            <div class="section">
                <div class="section-title">12. OBSERVAÇÕES</div>
                <div class="observations">
                    <div class="observations-title">Observações Especiais:</div>
                    <?= nl2br(htmlspecialchars($contrato['observacoes'])) ?>
                </div>
            </div>
        <?php endif; ?>

        <div class="section annex">
            <div class="annex-title">ANEXO I – DESCRIÇÃO TÉCNICA DO ERP Systhema</div>
            <div class="clause">
                <strong>1. Arquitetura e Tecnologia</strong>
            </div>
            <ul>
                <li>Linguagem: PHP 8</li>
                <li>Banco de dados: MySQL</li>
                <li>Interface: Bootstrap 3 + AdminLTE</li>
                <li>Ambiente: Web / Cloud</li>
                <li>Padrão modular e escalável.</li>
            </ul>
            <div class="clause mt-2">
                <strong>2. Módulos Disponíveis</strong>
            </div>
            <ul>
                <li>Cadastro de Empresas</li>
                <li>Cadastros de Pessoas (PF/PJ)</li>
                <li>Cadastro de Produtos</li>
                <li>Estoque e Almoxarifado</li>
                <li>Compras</li>
                <li>Vendas e Pedidos</li>
                <li>Financeiro: Contas a Pagar e Receber</li>
                <li>Controle de Caixa</li>
                <li>PDV para loja física</li>
                <li>Auditoria e Log de Ações</li>
                <li>Permissões por módulos</li>
                <li>Agenda de visitas</li>
                <li>Administração do sistema</li>
                <li>Importação de NF-e via SEFAZ (NFePHP)</li>
                <li>Consulta de notas contra o CNPJ</li>
                <li>Emissão de cobrança via API Asaas</li>
            </ul>
        </div>

        <div class="section annex">
            <div class="annex-title">ANEXO II – POLÍTICA DE BACKUP</div>
            <div class="clause">
                <strong>1. Objetivo</strong>
            </div>
            <p>Garantir proteção, redundância e recuperabilidade dos dados armazenados no ERP Systhema.</p>
            <div class="clause mt-2">
                <strong>2. Tipos de Backup</strong>
            </div>
            <ul>
                <li>Backup diário completo do banco de dados</li>
                <li>Backup incremental a cada 6 horas</li>
                <li>Backup semanal consolidado</li>
                <li>Retenção padrão: 30 dias</li>
            </ul>
        </div>

        <!-- Assinaturas -->
        <div class="signatures">
            <div class="signatures-container">
                <div class="signature-box">
                    <div class="signature-company"><?= htmlspecialchars($empresaSysthemaNome) ?></div>
                    <div class="signature-label">CONTRATADA</div>
                    <div class="signature-line">Assinatura</div>
                </div>
                <div class="signature-box">
                    <div class="signature-company"><?= htmlspecialchars($contratanteNome) ?></div>
                    <div class="signature-label">CONTRATANTE</div>
                    <div class="signature-line">Assinatura</div>
                </div>
            </div>
            <?php if ($dataAssinatura !== '[●]'): ?>
                <div class="signature-footer">
                    Recife/PE, <?= htmlspecialchars($dataAssinatura) ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</body>

</html>