<?php
$isEdit = isset($contrato['id']);
$actionUrl = $isEdit ? url('/contratos/editar') : url('/contratos/criar');
?>

<form id="formContrato" action="<?= $actionUrl ?>" method="POST">
    <?php if ($isEdit): ?>
        <input type="hidden" name="id" value="<?= $contrato['id'] ?>">
    <?php endif; ?>

    <div class="card">
        <div class="card-header">
            <i class="bi bi-file-earmark-text me-2"></i> Dados do Contrato
        </div>
        <div class="card-body">
            <div class="row">
                <!-- Número do Contrato -->
                <div class="col-md-4 mb-3">
                    <label for="numero_contrato" class="form-label">Número do Contrato *</label>
                    <input type="text" class="form-control" id="numero_contrato" name="numero_contrato"
                        value="<?= htmlspecialchars($contrato['numero_contrato'] ?? $numeroContrato ?? '') ?>" required>
                </div>

                <!-- Tipo -->
                <div class="col-md-4 mb-3">
                    <label for="tipo" class="form-label">Tipo *</label>
                    <select class="form-select" id="tipo" name="tipo" required>
                        <option value="licenca_software" <?= ($contrato['tipo'] ?? 'licenca_software') === 'licenca_software' ? 'selected' : '' ?>>Licença de Software</option>
                        <option value="site" <?= ($contrato['tipo'] ?? '') === 'site' ? 'selected' : '' ?>>Site</option>
                        <option value="loja_virtual" <?= ($contrato['tipo'] ?? '') === 'loja_virtual' ? 'selected' : '' ?>>Loja Virtual</option>
                        <option value="treinamento_adicional" <?= ($contrato['tipo'] ?? '') === 'treinamento_adicional' ? 'selected' : '' ?>>Treinamento Adicional</option>
                        <option value="outro" <?= ($contrato['tipo'] ?? '') === 'outro' ? 'selected' : '' ?>>Outro</option>
                    </select>
                </div>

                <!-- Status -->
                <div class="col-md-4 mb-3">
                    <label for="status" class="form-label">Status *</label>
                    <select class="form-select" id="status" name="status" required>
                        <option value="rascunho" <?= ($contrato['status'] ?? 'rascunho') === 'rascunho' ? 'selected' : '' ?>>Rascunho</option>
                        <option value="ativo" <?= ($contrato['status'] ?? '') === 'ativo' ? 'selected' : '' ?>>Ativo</option>
                        <option value="suspenso" <?= ($contrato['status'] ?? '') === 'suspenso' ? 'selected' : '' ?>>Suspenso</option>
                        <option value="cancelado" <?= ($contrato['status'] ?? '') === 'cancelado' ? 'selected' : '' ?>>Cancelado</option>
                        <option value="vencido" <?= ($contrato['status'] ?? '') === 'vencido' ? 'selected' : '' ?>>Vencido</option>
                        <option value="renovado" <?= ($contrato['status'] ?? '') === 'renovado' ? 'selected' : '' ?>>Renovado</option>
                    </select>
                </div>

                <!-- Empresa -->
                <div class="col-md-6 mb-3">
                    <label for="empresa_id" class="form-label">Empresa</label>
                    <select class="form-select" id="empresa_id" name="empresa_id">
                        <option value="">Selecione uma empresa...</option>
                        <?php if (!empty($empresas)): ?>
                            <?php foreach ($empresas as $emp): ?>
                                <option value="<?= $emp['id'] ?>" <?= ($contrato['empresa_id'] ?? '') == $emp['id'] ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($emp['razao_social']) ?> <?= $emp['cnpj'] ? '(' . htmlspecialchars($emp['cnpj']) . ')' : '' ?>
                                </option>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </select>
                </div>

                <!-- Cliente com Autocomplete -->
                <div class="col-md-6 mb-3">
                    <label for="pessoa_search" class="form-label">Cliente</label>
                    <div class="position-relative">
                        <input type="text" class="form-control" id="pessoa_search"
                            placeholder="Digite nome, razão social ou CNPJ/CPF do cliente..." autocomplete="off"
                            value="<?= htmlspecialchars($contrato['pessoa_nome'] ?? '') ?>">
                        <div id="pessoa_dropdown" class="autocomplete-dropdown" style="display: none;"></div>
                    </div>
                    <input type="hidden" id="pessoa_id" name="pessoa_id" value="<?= $contrato['pessoa_id'] ?? '' ?>">
                    <div class="col-md-12 mt-2" id="pessoa_info" style="display: none;">
                        <div class="alert alert-info mb-0">
                            <div class="d-flex justify-content-between align-items-start">
                                <div class="flex-grow-1" id="pessoa_info_name"></div>
                                <button type="button" class="btn btn-sm btn-outline-danger ms-2" onclick="limparPessoa()">
                                    <i class="bi bi-x"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Representante Legal -->
                <div class="col-md-6 mb-3">
                    <label for="representante_legal" class="form-label">Representante Legal</label>
                    <input type="text" class="form-control" id="representante_legal" name="representante_legal"
                        placeholder="Nome do representante legal"
                        value="<?= htmlspecialchars($contrato['representante_legal'] ?? '') ?>">
                </div>

                <!-- CPF do Representante -->
                <div class="col-md-6 mb-3">
                    <label for="cpf_representante" class="form-label">CPF do Representante</label>
                    <input type="text" class="form-control" id="cpf_representante" name="cpf_representante"
                        placeholder="000.000.000-00" maxlength="14"
                        value="<?= htmlspecialchars($contrato['cpf_representante'] ?? '') ?>">
                </div>

                <!-- Data Início -->
                <div class="col-md-4 mb-3">
                    <label for="data_inicio" class="form-label">Data de Início *</label>
                    <input type="date" class="form-control" id="data_inicio" name="data_inicio"
                        value="<?= $contrato['data_inicio'] ?? '' ?>" required>
                </div>

                <!-- Data Fim -->
                <div class="col-md-4 mb-3">
                    <label for="data_fim" class="form-label">Data de Fim</label>
                    <input type="date" class="form-control" id="data_fim" name="data_fim"
                        value="<?= $contrato['data_fim'] ?? '' ?>">
                </div>

                <!-- Data Assinatura -->
                <div class="col-md-4 mb-3">
                    <label for="data_assinatura" class="form-label">Data de Assinatura</label>
                    <input type="date" class="form-control" id="data_assinatura" name="data_assinatura"
                        value="<?= $contrato['data_assinatura'] ?? '' ?>">
                </div>

                <!-- Valor Mensal -->
                <div class="col-md-4 mb-3">
                    <label for="valor_mensal" class="form-label">Valor Mensal (R$)</label>
                    <input type="number" class="form-control" id="valor_mensal" name="valor_mensal"
                        step="0.01" value="<?= $contrato['valor_mensal'] ?? '0.00' ?>">
                </div>

                <!-- Valor Total -->
                <div class="col-md-4 mb-3">
                    <label for="valor_total" class="form-label">Valor Total (R$)</label>
                    <input type="number" class="form-control" id="valor_total" name="valor_total"
                        step="0.01" value="<?= $contrato['valor_total'] ?? '0.00' ?>">
                </div>

                <!-- Valor Implantação -->
                <div class="col-md-4 mb-3">
                    <label for="valor_implantacao" class="form-label">Valor de Implantação (R$)</label>
                    <input type="number" class="form-control" id="valor_implantacao" name="valor_implantacao"
                        step="0.01" value="<?= $contrato['valor_implantacao'] ?? '0.00' ?>">
                </div>

                <!-- Plano -->
                <div class="col-md-4 mb-3">
                    <label for="plano" class="form-label">Plano</label>
                    <select class="form-select" id="plano" name="plano">
                        <option value="">Selecione...</option>
                        <option value="Revenda" <?= ($contrato['plano'] ?? '') === 'Revenda' ? 'selected' : '' ?>>Revenda</option>
                        <option value="Cliente Final" <?= ($contrato['plano'] ?? '') === 'Cliente Final' ? 'selected' : '' ?>>Cliente Final</option>
                    </select>
                </div>

                <!-- Quantidade de Usuários -->
                <div class="col-md-4 mb-3">
                    <label for="quantidade_usuarios" class="form-label">Quantidade de Usuários</label>
                    <input type="number" class="form-control" id="quantidade_usuarios" name="quantidade_usuarios"
                        min="1" value="<?= $contrato['quantidade_usuarios'] ?? '1' ?>">
                </div>

                <!-- Valor Usuário Adicional -->
                <div class="col-md-4 mb-3">
                    <label for="valor_usuario_adicional" class="form-label">Valor por Usuário Adicional (R$)</label>
                    <input type="number" class="form-control" id="valor_usuario_adicional" name="valor_usuario_adicional"
                        step="0.01" value="<?= $contrato['valor_usuario_adicional'] ?? '0.00' ?>">
                </div>

                <!-- Forma de Pagamento -->
                <div class="col-md-4 mb-3">
                    <label for="forma_pagamento" class="form-label">Forma de Pagamento</label>
                    <select class="form-select" id="forma_pagamento" name="forma_pagamento">
                        <option value="">Selecione...</option>
                        <option value="Boleto" <?= ($contrato['forma_pagamento'] ?? '') === 'Boleto' ? 'selected' : '' ?>>Boleto</option>
                        <option value="Pix" <?= ($contrato['forma_pagamento'] ?? '') === 'Pix' ? 'selected' : '' ?>>Pix</option>
                        <option value="Cartão" <?= ($contrato['forma_pagamento'] ?? '') === 'Cartão' ? 'selected' : '' ?>>Cartão</option>
                        <option value="Transferência" <?= ($contrato['forma_pagamento'] ?? '') === 'Transferência' ? 'selected' : '' ?>>Transferência</option>
                    </select>
                </div>

                <!-- Observações -->
                <div class="col-md-12 mb-3">
                    <label for="observacoes" class="form-label">Observações</label>
                    <textarea class="form-control" id="observacoes" name="observacoes" rows="4"><?= htmlspecialchars($contrato['observacoes'] ?? '') ?></textarea>
                </div>
            </div>
        </div>
        <div class="card-footer">
            <div class="d-flex justify-content-end gap-2">
                <a href="<?= url('/contratos') ?>" class="btn btn-secondary">Cancelar</a>
                <button type="submit" class="btn btn-primary">
                    <i class="bi bi-check-circle me-2"></i> Salvar
                </button>
            </div>
        </div>
    </div>
</form>

<style>
.autocomplete-dropdown {
    position: absolute;
    top: 100%;
    left: 0;
    right: 0;
    background: var(--bs-body-bg, #fff);
    border: 1px solid var(--bs-border-color, #dee2e6);
    border-top: none;
    border-radius: 0 0 0.375rem 0.375rem;
    max-height: 300px;
    overflow-y: auto;
    z-index: 1000;
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
}

.autocomplete-item {
    padding: 0.875rem 1rem;
    cursor: pointer;
    border-bottom: 1px solid var(--bs-border-color, #f0f0f0);
    transition: all 0.15s ease-in-out;
    line-height: 1.5;
}

.autocomplete-item:hover,
.autocomplete-item.active {
    background-color: var(--bs-primary, #0d6efd);
    color: white;
    transform: translateX(3px);
}

.autocomplete-item:hover .text-muted {
    color: rgba(255, 255, 255, 0.8) !important;
}

.autocomplete-item:last-child {
    border-bottom: none;
}

.autocomplete-item .mb-1 {
    margin-bottom: 0.375rem;
}

.autocomplete-item strong {
    font-weight: 600;
}

.autocomplete-no-results {
    padding: 1rem;
    text-align: center;
    color: var(--bs-secondary, #6c757d);
    font-style: italic;
}
</style>

<script>
const pessoasData = <?= json_encode($pessoas ?? []) ?>;
let selectedPessoa = null;
let autocompleteTimeout = null;

$(document).ready(function() {
    // Inicializar autocomplete de cliente
    inicializarAutocompletePessoa();

    // Máscara para CPF do Representante
    $('#cpf_representante').on('input', function() {
        let value = $(this).val().replace(/\D/g, '');
        if (value.length <= 11) {
            value = value.replace(/(\d{3})(\d)/, '$1.$2');
            value = value.replace(/(\d{3})(\d)/, '$1.$2');
            value = value.replace(/(\d{3})(\d{1,2})$/, '$1-$2');
            $(this).val(value);
        }
    });

    // Carregar pessoa existente se estiver editando
    <?php if ($isEdit && !empty($contrato['pessoa_id'])): ?>
    const pessoaInicial = pessoasData.find(p => p.id == <?= $contrato['pessoa_id'] ?>);
    if (pessoaInicial) {
        selecionarPessoa(pessoaInicial);
    }
    <?php endif; ?>

    $('#formContrato').on('submit', function(e) {
        e.preventDefault();

        const formData = $(this).serialize();
        const url = $(this).attr('action');

        $.ajax({
            url: url,
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Sucesso!',
                        text: response.message || 'Contrato salvo com sucesso',
                        timer: 1500,
                        showConfirmButton: false
                    }).then(() => {
                        window.location.href = response.data?.redirect || appUrl('/contratos');
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erro!',
                        text: response.message || 'Erro ao salvar contrato'
                    });
                }
            },
            error: function(xhr) {
                let message = 'Erro ao processar requisição';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    message = xhr.responseJSON.message;
                }
                Swal.fire({
                    icon: 'error',
                    title: 'Erro!',
                    text: message
                });
            }
        });
    });
});

function inicializarAutocompletePessoa() {
    const $search = $('#pessoa_search');
    const $dropdown = $('#pessoa_dropdown');

    // Ao digitar
    $search.on('input', function() {
        const query = $(this).val().trim().toLowerCase();
        clearTimeout(autocompleteTimeout);

        if (query.length < 2) {
            $dropdown.hide();
            return;
        }

        autocompleteTimeout = setTimeout(() => {
            buscarPessoas(query);
        }, 300);
    });

    // Ao clicar fora, fechar dropdown
    $(document).on('click', function(e) {
        if (!$(e.target).closest('#pessoa_search, #pessoa_dropdown').length) {
            $dropdown.hide();
        }
    });

    // Ao focar no campo
    $search.on('focus', function() {
        if ($(this).val().length >= 2) {
            buscarPessoas($(this).val().trim().toLowerCase());
        }
    });

    // Ao pressionar Enter, apenas prevenir submit
    $search.on('keydown', function(e) {
        if (e.key === 'Enter') {
            e.preventDefault();
        }
    });
}

function buscarPessoas(query) {
    const $dropdown = $('#pessoa_dropdown');

    // Filtrar pessoas
    const results = pessoasData.filter(pessoa => {
        const name = (pessoa.name || '').toLowerCase();
        const tradeName = (pessoa.trade_name || '').toLowerCase();
        const document = (pessoa.document || '').toLowerCase();
        const email = (pessoa.email || '').toLowerCase();
        const phone = (pessoa.phone || '').toLowerCase();
        const mobile = (pessoa.mobile || '').toLowerCase();

        // Normalizar query e documento para busca mais flexível
        const normalizedQuery = query.replace(/[^\d\w]/g, '').toLowerCase();
        const normalizedDocument = document.replace(/[^\d\w]/g, '').toLowerCase();

        return name.includes(query) || tradeName.includes(query) ||
            document.includes(query) || normalizedDocument.includes(normalizedQuery) ||
            email.includes(query) || phone.includes(query) || mobile.includes(query);
    });

    // Montar HTML
    let html = '';

    if (results.length > 0) {
        results.forEach(pessoa => {
            const nomeFantasia = pessoa.trade_name || '-';
            const razaoSocial = pessoa.name || '-';
            const documento = pessoa.document || 'Não informado';
            const codigo = String(pessoa.id).padStart(4, '0');
            const telefone = pessoa.phone || pessoa.mobile || '-';
            const email = pessoa.email || '-';

            html += `
                <div class="autocomplete-item" data-id="${pessoa.id}">
                    <div class="mb-1">
                        <strong>Código: ${codigo}</strong>  |  <strong>CNPJ/CPF:</strong> ${documento}
                    </div>
                    <div class="mb-1">
                        <strong>Razão Social:</strong> ${razaoSocial}  |  <strong>Fantasia:</strong> ${nomeFantasia}
                    </div>
                    <div class="text-muted small">
                        <strong>Fone:</strong> ${telefone}  |  <strong>Email:</strong> ${email}
                    </div>
                </div>
            `;
        });
    } else {
        html = '<div class="autocomplete-no-results">Nenhum cliente encontrado</div>';
    }

    $dropdown.html(html).show();

    // Event listeners
    $dropdown.find('.autocomplete-item').on('click', function() {
        const pessoaId = $(this).data('id');
        const pessoa = pessoasData.find(p => p.id == pessoaId);
        if (pessoa) {
            selecionarPessoa(pessoa);
        }
    });
}

function selecionarPessoa(pessoa) {
    selectedPessoa = pessoa;

    const nomeFantasia = pessoa.trade_name || '-';
    const razaoSocial = pessoa.name || '-';
    const nomeExibir = nomeFantasia !== '-' ? nomeFantasia : razaoSocial;
    const codigo = String(pessoa.id).padStart(4, '0');
    const documento = pessoa.document || 'Não informado';
    const telefone = pessoa.phone || pessoa.mobile || '-';
    const email = pessoa.email || '-';

    // Preencher campo hidden
    $('#pessoa_id').val(pessoa.id);

    // Atualizar campo de busca
    $('#pessoa_search').val(nomeExibir);

    // Mostrar info da pessoa no formato estruturado
    let infoHtml = `
        <div style="line-height: 1.6;">
            <div class="mb-1">
                <strong>Código: ${codigo}</strong>  |  ${documento}
            </div>
            <div class="mb-1">
                <strong>Razão Social:</strong> ${razaoSocial}  |  <strong>Fantasia:</strong> ${nomeFantasia}
            </div>
            <div class="text-muted small">
                <strong>Fone:</strong> ${telefone}  |  <strong>Email:</strong> ${email}
            </div>
        </div>
    `;

    $('#pessoa_info_name').html(infoHtml);
    $('#pessoa_info').slideDown();

    // Fechar dropdown
    $('#pessoa_dropdown').hide();
}

function limparPessoa() {
    selectedPessoa = null;
    $('#pessoa_id').val('');
    $('#pessoa_search').val('');
    $('#pessoa_info').slideUp();
}
</script>

